/* srspeech.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _SRSPEECH_H
#define _SRSPEECH_H

#include <glib.h>

typedef struct
{
	gchar		*voice_id;
	
	/* TTS Engine fields */
	gchar		*tts_engine_name;
	gchar		*tts_voice_name;	

	gboolean	initialized;
	
	/* SRS fields */
	gint		priority;
	gboolean	preempt;
	
	gint	 	cb_support;

	guint8		rate;	/* in % */
	guint8		pitch;	/* in % */
	guint8		volume;	/* in % */
} SRSVoice;

typedef struct
{
	gchar *voice;
	gchar *marker;
	gchar *spelling;
	gchar *language;	
	gchar *text;
} SRSText;

typedef enum
{
  TTS_EV_RESERVED,
  TTS_EV_SPEECH_STARTED,
  TTS_EV_END_OF_SPEECH,
  TTS_EV_WORD_MARKER
}TTSEvent;

typedef void (* TTSCallback) (TTSEvent	event, 
			      gpointer	event_data, 
			      gpointer	user_data); 

typedef	void (* TTSSpeakFunc	) (SRSVoice 	*voice, 
				   SRSText  	*text);
typedef	void (* TTSShutUpFunc	) (void);
typedef	void (* TTSPauseFunc	) (void);
typedef	void (* TTSResumeFunc	) (void);
typedef	void (* TTSTerminateFunc) (void);

typedef struct
{
    gboolean 		initialized;

    TTSCallback		callback;
	
    TTSSpeakFunc 	speak;
    TTSShutUpFunc 	shut_up;	
    TTSPauseFunc 	pause;
    TTSResumeFunc 	resume;
    TTSTerminateFunc	terminate;
}TTSEngine;

/*___________________________< SRSVoice METHODS >_____________________________*/

SRSVoice * 	srs_voice_new 	(void);
void       	srs_voice_free 	(SRSVoice	*srs_voice);
SRSVoice * 	srs_voice_copy 	(SRSVoice  	*orig_srs_voice);
SRSVoice * 	srs_voice_dup  	(SRSVoice  	*orig_srs_voice);
gboolean   	srs_voice_find 	(SRSVoice 	**srs_voice);

void 		srs_voice_set_id (SRSVoice	*srs_voice,
		    		  gchar     	*voice_id);

void 		srs_voice_set_tts_engine_name (SRSVoice 	*srs_voice,
					       gchar     	*tts_engine_name);
void 		srs_voice_set_tts_voice_name  (SRSVoice 	*srs_voice,
					      gchar     	*tts_voice_name);

void 		srs_voice_set_priority	(SRSVoice 	*srs_voice,
			    		gchar     	*priority);
void 		srs_voice_set_preempt  	(SRSVoice 	*srs_voice,
			    		gchar     	*preempt);

void 		srs_voice_set_rate   	(SRSVoice	*srs_voice, 
				        gchar		*rate);
void 		srs_voice_set_pitch  	(SRSVoice	*srs_voice, 
				        gchar     	*pitch);
void 		srs_voice_set_volume 	(SRSVoice	*srs_voice, 
				        gchar     	*volume);
/*___________________________</SRSVoice METHODS >_____________________________*/

/*____________________________< SRSText METHODS >_____________________________*/
SRSText *	srs_text_new 		(void);
void 		srs_text_free 		(SRSText	*srs_text);
SRSText* 	srs_text_copy 		(SRSText	*orig_srs_text);

void 		srs_text_set_voice    	(SRSText 	*srs_text, 
				         gchar		*voice);	
void 		srs_text_set_marker   	(SRSText 	*srs_text, 
				        gchar    	*marker);
void 		srs_text_set_spelling 	(SRSText 	*srs_text, 
				        gchar		*spelling);
void 		srs_text_set_language 	(SRSText 	*srs_text, 
				        gchar    	*language);
void 		srs_text_set_text     	(SRSText 	*srs_text, 
				        gchar    	*text);
void 		srs_text_add_text     	(SRSText 	*srs_text, 
				        gchar    	*text);
/*____________________________</SRSText METHODS >_____________________________*/

/*____________________________< engine METHODS >______________________________*/
int        	srs_initialize 		(void);
void       	srs_terminate  		(void);
void       	srs_add_voice  		(SRSVoice	*srs_voice);
SRSVoice * 	srs_get_voice  		(gchar 		*voice_ID);
int        	srs_speak      		(SRSText  	*srs_text);
int        	srs_speak_optimization	(void);
void       	srs_speak_to_engine 	(SRSText 	*srs_text);
int        	srs_shut_up    		(void);
int        	srs_pause      		(void);
int        	srs_resume     		(void);
/*____________________________< engine METHODS >______________________________*/

#endif
