/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GSWITCHIT_CONFIG_H__
#define __GSWITCHIT_CONFIG_H__

#include <X11/XKBlib.h>

#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gconf/gconf-client.h>

#define GROUP_MASK 0x1FFF

typedef struct _GSwitchItConfig
{
/*
 * Applet configuration
 */
  int secondaryGroupsMask;
  int defaultGroup;

  gchar *imageFiles[XkbNumKbdGroups];
  gchar *commands[XkbNumKbdGroups];

  gboolean doBeep;
  gboolean groupPerApp;
  gboolean handleIndicators;
  gboolean layoutNamesAsGroupNames;

  int debugLevel;

  GConfClient *confClient;

// transient part
  GdkPixbuf *images[XkbNumKbdGroups];
/*
 * XKB configuration
 */
  gboolean xkbOverrideSettings;
  gchar *xkbModel;
  GSList *xkbLayouts;
  GSList *xkbOptions;
  int xkbSwitchcutId;
}
GSwitchItConfig;

typedef char GroupDescriptionsBuffer[XkbNumKbdGroups][XKL_MAX_CI_DESC_LENGTH *
                                                      2];

extern void GSwitchItConfigInit( GSwitchItConfig * config );
extern void GSwitchItConfigLoadXkbParams( GSwitchItConfig * config );
extern void GSwitchItConfigSaveXkbParams( GSwitchItConfig * config );
extern void GSwitchItConfigLoadAppletParams( GSwitchItConfig * config );
extern void GSwitchItConfigSaveAppletParams( GSwitchItConfig * config );
extern void GSwitchItConfigTerm( GSwitchItConfig * config );
extern void GSwitchItConfigLoadXkbParamsFromServer( GSwitchItConfig *
                                                    config );

extern void GSwitchItConfigLoadImages( GSwitchItConfig * config );
extern void GSwitchItConfigFreeImages( GSwitchItConfig * config );

extern void GSwitchItConfigLockNextGroup( GSwitchItConfig * config );
extern void GSwitchItConfigLockPrevGroup( GSwitchItConfig * config );
extern void GSwitchItConfigRestoreGroup( GSwitchItConfig * config );

extern const char *GSwitchItConfigXkbMergeItems( const char *parent,
                                                 const char *child );

extern gboolean GSwitchItConfigXkbSplitItems( const char *merged,
                                              char **parent, char **child );

extern void GSwitchItConfigXkbModelSet( GSwitchItConfig * config,
                                        const gchar * modelName );

extern void GSwitchItConfigXkbLayoutsReset( GSwitchItConfig * config );
extern void GSwitchItConfigXkbLayoutsAdd( GSwitchItConfig * config,
                                          const gchar * layoutName,
                                          const gchar * variantName );

extern void GSwitchItConfigXkbLayoutsReset( GSwitchItConfig * config );
extern void GSwitchItConfigXkbOptionsReset( GSwitchItConfig * config );

extern void GSwitchItConfigXkbOptionsAdd( GSwitchItConfig * config,
                                          const gchar * groupName,
                                          const gchar * optionName );
extern gboolean GSwitchItConfigXkbOptionsIsSet( GSwitchItConfig * config,
                                                const gchar * groupName,
                                                const gchar * optionName );

extern void GSwitchItConfigActivateAppletParams( GSwitchItConfig * config );

extern void GSwitchItConfigActivateXkbParams( GSwitchItConfig * config );

extern void GSwitchItConfigXkbDumpSettings( GSwitchItConfig * config,
                                            const char *fileName );

extern void GSwitchItConfigStartListenSettings( GSwitchItConfig *
                                                config,
                                                GConfClientNotifyFunc
                                                func, gpointer user_data );

extern void GSwitchItConfigStopListenSettings( GSwitchItConfig * config );

extern Bool GSwitchItConfigGetDescriptions( const char *name,
                                            char **layoutDescr,
                                            char **variantDescr );

extern const char *GSwitchItConfigFormatFullLayout( const char
                                                    *layoutDescr,
                                                    const char
                                                    *variantDescr );

extern void GSwitchItConfigLoadGroupDescriptions( GSwitchItConfig * config,
                                                  GroupDescriptionsBuffer
                                                  namesToFill );

#endif
