/* util.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#if 0
#include "util.h"

#include <config.h>
#include <libgnome/gnome-init.h>
#include <libgnomeui/gnome-ui-init.h>
#include <stdlib.h>
#include <unistd.h>



/**
 *
 * The return list should be freed when no longer needed.
 * argc,argv - command line parameters
 * param - non default arguments. (should be freed by the caller if necessary)
 * coutn - no of entry in structure "param"
 * return val (char **) - retrun the non-option arguments. It should be freed.
 *
**/
gchar **
sru_parse_command_line_options (gint argc, gchar** argv,struct poptOption *param,gint count,gint *sru_return_value)
{
	poptContext popt_context;
	gchar **args;
	gchar **tokens;
	
	tokens = g_strsplit(g_strreverse(argv[0]),"/",2);
	

	if (tokens != NULL && tokens[0] != NULL)
	{

	    gnome_init_with_popt_table (g_strreverse(tokens[0]),VERSION,argc,argv,param, 0, &popt_context);
	    
	    g_strfreev(tokens);

	    args = (gchar**) poptGetArgs (popt_context);
		
	    if (args != NULL) {
		fprintf (stderr, "Invalid argument.\n");
		
		*sru_return_value = EXIT_FAILURE;
		
		return args;
		}

	    poptFreeContext (popt_context);
	    
	    *sru_return_value = EXIT_SUCCESS;
	}
	else
	    *sru_return_value = EXIT_FAILURE;
	
	return args;
}
#endif
