/*
 *  Copyright (C) 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MISC_GENERAL_H
#define __MISC_GENERAL_H

#include <glib.h>
#include <libxml/tree.h>

G_BEGIN_DECLS

char 		*gul_general_tmp_filename	 (const char *base,
						  const char *extension);

gchar 		*gul_general_user_file 		 (const char *fname, gboolean critical);

gchar 		*gul_general_read_line_from_file (FILE *f);

gboolean	 gul_backup_file		 (const char *fname, 
					 	  guint num_backups, 
					 	  const gchar *newversion);

gboolean	 gul_copy_file			 (const char *orig,
						  const char *dest);

GSList *	 gul_find_file			 (const char *path, 
						  const char *fname, 
						  gint maxdepth);

xmlAttrPtr 	 xmlSetRawProp 			 (xmlNodePtr node, 
					 	  const xmlChar *name,
			  		 	  const xmlChar *value);

xmlChar 	*xmlGetRawProp 			(xmlNodePtr node, 
					 	 const xmlChar *name);

gint 		xmlGetIntProp 			(xmlNodePtr node, 
					 	 const gchar *attribute);

void		gul_general_launch_application  (const char *command_string, 
                                		 const char *parameter, 
                                		 gboolean use_terminal);

G_END_DECLS

#endif

