
/* GnomeMeeting -- A Video-Conferencing application
 * Copyright (C) 2000-2002 Damien Sandras
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *                         gdkvideoio.cxx  -  description
 *                        -------------------
 *   begin                : Sat Feb 17 2001
 *   copyright            : (C) 2000-2001 by Damien Sandras
 *   description          : Class to permit to display in GDK Drawing Area
 *   email                : dsandras@seconix.com
 *
 */


#ifndef _GDKVIDEOIO_H_
#define _GDKVIDEOIO_H_

#include <ptlib.h>
#include <h323.h>
#include <videoio.h>
#include <gtk/gtk.h>
#include <pthread.h>

#ifdef HAS_SDL
#include <SDL.h>
#endif

#include "common.h"


class GDKVideoOutputDevice : public H323VideoDevice
{
  PCLASSINFO(GDKVideoOutputDevice, H323VideoDevice);


  public:

  /* DESCRIPTION  :  The constructor.
   * BEHAVIOR     :  Setup parameters.
   * PRE          :  GmWindow is a valid pointer to a valid
   *                 GmWindow structure.
   */
  GDKVideoOutputDevice (GmWindow *);
    
    
  /* DESCRIPTION  :  The constructor.
   * BEHAVIOR     :  Setups the parameters, 
   *                 int = 0 if we do not transmit,
   *                 1 otherwise, if we do not transmit, 
   *                 default display = local
   *                 else default display = remote.
   * PRE          :  GmWindow is a valid pointer to a valid
   *                 GmWindow structure.
   */
  GDKVideoOutputDevice (int, GmWindow *);


  /* DESCRIPTION  :  The destructor.
   * BEHAVIOR     :  /
   * PRE          :  /
   */
  ~GDKVideoOutputDevice ();


  /* Same as in H323VideoDevice.
   */
  virtual BOOL Redraw(const void * frame);


 protected:

  /* Same as in H323VideoDevice */
  BOOL WriteLineSegment(int x, int y, unsigned len, const BYTE * data);

  int device_id;      /* The current device : encoding or not */
  int transmitted_frame_number;
  int received_frame_number;

  PBYTEArray buffer;  /* The RGB24 buffer; contains the images */
  int display_config; /* Current display : local or remote or both */
  PMutex redraw_mutex;

#ifdef HAS_SDL
  SDL_Surface *screen;
  SDL_Overlay *overlay;

  SDL_Rect dest;
  PMutex sdl_mutex;  /* Mutex to ensure that only one thread access to the SDL
			stuff at the same time */
#endif

  enum {REMOTE, LOCAL};

  GmWindow *gw;
};

#endif
