/* gok-key.h
*
* Copyright 2001,2002 Sun Microsystems, Inc.,
* Copyright 2001,2002 University Of Toronto
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*/

#ifndef __GOKKEY_H__
#define __GOKKEY_H__

#define XK_MISCELLANY
#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBgeom.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gnome.h>
#include "gok-spy-priv.h"
#include "gok-output.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* general type of key */
typedef enum {
KEYTYPE_NORMAL,
KEYTYPE_MODIFIER,
KEYTYPE_BRANCH,
KEYTYPE_BRANCHBACK,
KEYTYPE_BRANCHMENUS,
KEYTYPE_BRANCHMENUITEMS,
KEYTYPE_MENUITEM,
KEYTYPE_BRANCHTOOLBARS,
KEYTYPE_TOOLBARITEM,
KEYTYPE_BRANCHWINDOWS,
KEYTYPE_RAISEAPPLICATION,
KEYTYPE_BRANCHGUI,
KEYTYPE_BRANCHGUIACTIONS,
KEYTYPE_BRANCHEDITTEXT,
KEYTYPE_EDITABLETEXTACTION,
KEYTYPE_EDITABLETEXT_CUT,
KEYTYPE_EDITABLETEXT_COPY,
KEYTYPE_EDITABLETEXT_PASTE,
KEYTYPE_EDITABLETEXT_CLEAR,
KEYTYPE_BRANCHALPHABET,
KEYTYPE_SETTINGS,
KEYTYPE_WORDCOMPLETE,
KEYTYPE_COMMANDPREDICT,
KEYTYPE_WINDOW,
KEYTYPE_MOVERESIZE,
KEYTYPE_POINTERCONTROL,
KEYTYPE_BRANCHMODAL
} KeyTypes;

/* display style of key (from the .rc file) */
typedef enum {
KEYSTYLE_NORMAL,
KEYSTYLE_BRANCH,
KEYSTYLE_BRANCHBACK,
KEYSTYLE_GENERALDYNAMIC,
KEYSTYLE_BRANCHMENUS,
KEYSTYLE_BRANCHMENUITEMS,
KEYSTYLE_MENUITEM,
KEYSTYLE_BRANCHTOOLBARS,
KEYSTYLE_TOOLBARITEM,
KEYSTYLE_BRANCHGUI,
KEYSTYLE_BRANCHGUIACTIONS,
KEYSTYLE_BRANCHEDITTEXT,
KEYSTYLE_EDITABLETEXTACTION,
KEYSTYLE_EDITABLETEXT_CUT,
KEYSTYLE_EDITABLETEXT_COPY,
KEYSTYLE_EDITABLETEXT_PASTE,
KEYSTYLE_EDITABLETEXT_CLEAR,
KEYSTYLE_BRANCHALPHABET,
KEYSTYLE_SETTINGS,
KEYSTYLE_WORDCOMPLETE,
KEYSTYLE_POINTERCONTROL,
KEYSTYLE_BRANCHMODAL,
KEYSTYLE_INSENSITIVE
} KeyStyles;

/* determines the image display for the key */
#define KEYDISPLAY_TEXT 0
#define KEYDISPLAY_IMAGE 1

/* font size groups */
#define FONT_SIZE_GROUP_UNDEFINED 0
#define FONT_SIZE_GROUP_UNIQUE -1
#define FONT_SIZE_GROUP_WORDCOMPLETE -2
#define FONT_SIZE_GROUP_GLYPH -3

#define GOK_MODMASK_CURRENT -1

/* a key label */
/* if you add data members to this structure, initialize them in gok_keylabel_new */
typedef struct GokKeyLabel{
	gchar* Text;
	gchar* Modifier;
	struct GokKeyLabel* pLabelNext;	
} GokKeyLabel;

typedef struct _GokUIState {
	guint active:1;
	guint unused:15;
} GokUIState;

/* GokKey structure */
/* If you add data members to this structure, initialize them in gok_key_new */

typedef struct GokKey{
	GokKeyLabel* pLabel;
	gchar* Target;
	GokOutput* pOutput;
	GokOutput* pOutputWrapperPre;
	GokOutput* pOutputWrapperPost;
	gchar* ModifierName;
	GtkWidget* pButton;
	gint Type; /* e.g. normal or word completion */
	gint Style; /* display style from the .rc file */
	gint ImageCode;
	AccessibleNode* pNodeAccessible;
	gint CellsRequired;
	gint FontSizeGroup;
	gint FontSize;
        GokUIState ComponentState;
	gint State; /* highlight state */
	gint StateWhenNotFlashed;

	/* general use pointer */
	void* pGeneral;
		
	/* section */
        gint Section;
  
	/* cell coordinates */
	gint Top;
	gint Bottom;
	gint Left;
	gint Right;

	/* window coordinates */
	gint TopWin;
	gint BottomWin;
	gint LeftWin;
	gint RightWin;
	struct GokKey* pMimicKey;

	struct GokKey* pKeyNext;
	struct GokKey* pKeyPrevious;
} GokKey;

gboolean gok_key_initialize (GokKey* pKey, xmlNode* pNode);
gboolean gok_key_add_label (GokKey* pKey, gchar* pLabelText, gchar* pModifier);
void gok_key_set_output (GokKey* pKey, gint Type, gchar* pName, AccessibleKeySynthType Flag);
void gok_key_add_output (GokKey* pKey, gint Type, gchar* pName, AccessibleKeySynthType Flag);
void gok_key_change_label (GokKey* pKey, gchar* LabelText);
void gok_key_update_label (GokKey* pKey);
gint gok_key_get_label_lengthpercell (GokKey* pKey);
gint gok_key_get_label_heightpercell (GokKey* pKey);
gint gok_key_calculate_font_size (GokKey* pKey, gboolean width, gboolean bHeight);
void gok_key_set_font_size (GokKey* pKey, gint Size);
void gok_key_set_button_name (GokKey* pKey);
void gok_key_set_button_label (GokKey* pKey, gchar* LabelText);
gint gok_key_get_default_border_width (GokKey* pKey);
gchar* gok_key_get_label (GokKey* pKey);
GokKeyLabel* gok_keylabel_new (GokKey* pKey, gchar* pLabelText, gchar* pModifierText);
void gok_keylabel_delete (GokKeyLabel* pKeyLabel);
void gok_key_update_toggle_state (GokKey *pKey);
void gok_key_set_cells(GokKey* pKey, gint top, gint bottom, gint left, gint right);
GokKey* gok_key_duplicate(GokKey* pKey);
GokKey* gok_feedback_get_key_flashing (void);
gboolean gok_key_make_html_safe (gchar* pString, gchar* pSafeString, gint SafeStringLength);
gboolean gok_key_contains_point (GokKey *pKey, gint x, gint y);
void gok_key_set_effective_group (gint group);
gint gok_key_get_effective_group (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* #ifndef __GOKKEY_H__ */
