/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __gul_tbi_test_h
#define __gul_tbi_test_h

#include "gul-toolbar-item.h"

/* object forward declarations */

typedef struct _GulTbiTest GulTbiTest;
typedef struct _GulTbiTestClass GulTbiTestClass;
typedef struct _GulTbiTestPrivate GulTbiTestPrivate;

/**
 * TbiTest object
 */

#define GUL_TYPE_TBI_TEST		(gul_tbi_test_get_type())
#define GUL_TBI_TEST(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GUL_TYPE_TBI_TEST,\
					 GulTbiTest))
#define GUL_TBI_TEST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST((klass), GUL_TYPE_TBI_TEST,\
					 GulTbiTestClass))
#define GUL_IS_TBI_TEST(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), GUL_TYPE_TBI_TEST))
#define GUL_IS_TBI_TEST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GUL_TYPE_TBI_TEST))
#define GUL_TBI_TEST_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GUL_TYPE_TBI_TEST,\
					 GulTbiTestClass))

struct _GulTbiTestClass 
{
	GulTbItemClass parent_class;
	
};

/* Remember: fields are public read-only */
struct _GulTbiTest
{
	GulTbItem parent_object;

	GulTbiTestPrivate *priv;
};

/* this class is abstract */

GType		gul_tbi_test_get_type		(void);
GulTbiTest *	gul_tbi_test_new		(void);
void		gul_tbi_test_set_label		(GulTbiTest *t, const gchar *label);

#endif
