/* ev-document-transition.c
 *  this file is part of evince, a gnome document viewer
 * 
 * Copyright (C) 2006 Carlos Garcia Campos <carlosgc@gnome.org>
 *
 * Evince is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Evince is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include "ev-document-transition.h"

GType
ev_document_transition_get_type (void)
{
	static GType type = 0;

	if (G_UNLIKELY (type == 0)) {
		const GTypeInfo our_info = {
			sizeof (EvDocumentTransitionIface),
			NULL,
			NULL,
		};

		type = g_type_register_static (G_TYPE_INTERFACE,
					       "EvDocumentTransition",
					       &our_info, (GTypeFlags)0);
	}

	return type;
}

gdouble
ev_document_transition_get_page_duration (EvDocumentTransition *document_trans,
					  gint                  page)
{
	EvDocumentTransitionIface *iface = EV_DOCUMENT_TRANSITION_GET_IFACE (document_trans);

	if (iface->get_page_duration)
		return iface->get_page_duration (document_trans, page);

	return -1;
}

EvTransitionEffect *
ev_document_transition_get_effect (EvDocumentTransition *document_trans,
				   gint                  page)
{
	EvDocumentTransitionIface *iface = EV_DOCUMENT_TRANSITION_GET_IFACE (document_trans);
	EvTransitionEffect *effect = NULL;

	if (iface->get_effect)
		effect = iface->get_effect (document_trans, page);

	if (!effect)
		return ev_transition_effect_new (EV_TRANSITION_EFFECT_REPLACE, NULL);

	return effect;
}
