/* GStreamer Push File Source
 * Copyright (C) <2007> Tim-Philipp Müller <tim centricular net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_PUSH_FILE_SRC_H__
#define __GST_PUSH_FILE_SRC_H__

#include <gst/gstbin.h>

G_BEGIN_DECLS

#define GST_TYPE_PUSH_FILE_SRC \
  (gst_push_file_src_get_type())
#define GST_PUSH_FILE_SRC(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_PUSH_FILE_SRC,GstPushFileSrc))
#define GST_PUSH_FILE_SRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_PUSH_FILE_SRC,GstPushFileSrcClass))
#define GST_IS_PUSH_FILE_SRC(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_PUSH_FILE_SRC))
#define GST_IS_PUSH_FILE_SRC_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_PUSH_FILE_SRC))

typedef struct _GstPushFileSrc GstPushFileSrc;
typedef struct _GstPushFileSrcClass GstPushFileSrcClass;

struct _GstPushFileSrc
{
  GstBin parent;

  /*< private >*/
  GstElement *filesrc;
  GstPad     *srcpad;
};

struct _GstPushFileSrcClass
{
  GstBinClass parent_class;
};

GType gst_push_file_src_get_type(void);

G_END_DECLS

#endif /* __GST_PUSH_FILE_SRC_H__*/

