/* GStreamer
 * Copyright (C) <2002> David A. Schleef <ds@schleef.org>
 * Copyright (C) <1999> Erik Walthinsen <omega@cse.ogi.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GST_SUBPARSE_H__
#define __GST_SUBPARSE_H__

#include <gst/gst.h>

G_BEGIN_DECLS

#define GST_TYPE_SUBPARSE \
  (gst_sub_parse_get_type ())
#define GST_SUBPARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GST_TYPE_SUBPARSE, GstSubParse))
#define GST_SUBPARSE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), GST_TYPE_SUBPARSE, GstSubParse))
#define GST_IS_SUBPARSE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GST_TYPE_SUBPARSE))
#define GST_IS_SUBPARSE_CLASS(obj) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), GST_TYPE_SUBPARSE))

typedef struct _GstSubParse GstSubParse;
typedef struct _GstSubParseClass GstSubParseClass;

/* format enum */
typedef enum
{
  GST_SUB_PARSE_FORMAT_UNKNOWN = 0,
  GST_SUB_PARSE_FORMAT_MDVDSUB = 1,
  GST_SUB_PARSE_FORMAT_SUBRIP = 2,
  GST_SUB_PARSE_FORMAT_MPSUB = 3
} GstSubParseFormat;

typedef struct {
  int      state;
  GString *buf;
  guint64  start_time;
  guint64  duration;
  GstSegment *segment;
} ParserState;

typedef gchar* (*Parser) (ParserState *state, const gchar *line);

struct _GstSubParse {
  GstElement element;

  GstPad *sinkpad,*srcpad;

  GString *textbuf;

  GstSubParseFormat parser_type;
  gboolean parser_detected;

  Parser parse_line;
  ParserState state;

  /* seek */
  guint64 offset;
  guint64 next_offset;
  
  /* Segment */
  GstSegment *segment;
  GstSeekFlags  segment_flags;
  gboolean need_segment;
  
  gboolean flushing;
};

struct _GstSubParseClass {
  GstElementClass parent_class;
};

GType gst_sub_parse_get_type (void);

G_END_DECLS

#endif /* __GST_SUBPARSE_H__ */
