%define gettext_package gnome-panel-2.0

%define glib2_version 2.2.0
%define gtk2_version 2.5.4
%define libglade2_version 2.5.0
%define libgnomeui_version 2.5.4
%define gnome_desktop_version 2.9.91
%define libwnck_version 2.9.92
%define libbonobo_version 2.3.0
%define libbonoboui_version 2.3.0
%define gnome_vfs2_version 2.3.7
%define libxslt_version 1.0.21
%define startup_notification_version 0.5

Summary: GNOME panel
Name: gnome-panel
Version: 2.13.1
Release: 1
URL: http://www.gnome.org
Source0: ftp://ftp.gnome.org/pub/GNOME/sources/gnome-panel/%{name}-%{version}.tar.gz
License: GPL 
Group: User Interface/Desktops
BuildRoot: %{_tmppath}/%{name}-root

Requires: gnome-desktop >= %{gnome_desktop_version}
Requires: libwnck >= %{libwnck_version}

Prereq: /bin/awk, /bin/cat, /bin/ln, /bin/rm
Prereq: GConf2 >= 2.6.0
Prereq: scrollkeeper

BuildRequires: intltool
BuildRequires: libpng-devel
BuildRequires: scrollkeeper
BuildRequires: glib2-devel >= %{glib2_version}
BuildRequires: gtk2-devel >= %{gtk2_version}
BuildRequires: libglade2-devel >= %{libglade2_version}
BuildRequires: libgnomeui-devel >= %{libgnomeui_version}
BuildRequires: gnome-desktop-devel >= %{gnome_desktop_version}
BuildRequires: libwnck-devel >= %{libwnck_version}
BuildRequires: libbonobo-devel >= %{libbonobo_version}
BuildRequires: libbonoboui-devel >= %{libbonoboui_version}
BuildRequires: gnome-vfs2-devel >= %{gnome_vfs2_version}
BuildRequires: libxslt-devel >= %{libxslt_version}
BuildRequires: startup-notification-devel >= %{startup_notification_version}
BuildRequires: fontconfig-devel
BuildRequires: libtool automake autoconf

%description

The GNOME panel provides the window list, workspace switcher, menus, and other 
features for the GNOME desktop.

%package devel
Summary: Headers and libraries for Panel Applet development
Group: Development/Libraries
Requires: %{name} = %{version}
Requires: gtk2-devel >= %{gtk2_version}
Requires: libbonoboui-devel >= %{libbonoboui_version}
Requires: libgnomeui-devel >= %{libgnomeui_version}

%description devel
Panel Applet development package. Contains files needed for developing
Panel Applets using the libpanel-applet library.

%prep
%setup -q

%build
%configure --disable-gtk-doc
make

%install
rm -rf $RPM_BUILD_ROOT

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
make DESTDIR=$RPM_BUILD_ROOT install
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

#
# Create pager and tasklist schemas for compatibility with older
# configurations which reference the old schema names
#
sed -e 's|/schemas/apps/window_list_applet/prefs/|/schemas/apps/tasklist_applet/prefs/|' $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas/window-list.schemas > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas/tasklist.schemas
sed -e 's|/schemas/apps/workspace_switcher_applet/prefs/|/schemas/apps/pager_applet/prefs/|; s|<default>1</default>|<default>2</default>|' $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas/workspace-switcher.schemas > $RPM_BUILD_ROOT%{_sysconfdir}/gconf/schemas/pager.schemas

## blow away stuff we don't want
/bin/rm -rf $RPM_BUILD_ROOT/var/scrollkeeper
/bin/rm -f $RPM_BUILD_ROOT%{_libdir}/libpanel-applet-2.*a

%find_lang %{gettext_package}

%clean
rm -rf $RPM_BUILD_ROOT

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

#
# Clear out the old defaults
#
gconftool-2 --direct --config-source=$GCONF_CONFIG_SOURCE --recursive-unset /apps/panel > /dev/null
gconftool-2 --direct --config-source=$GCONF_CONFIG_SOURCE --recursive-unset /schemas/apps/panel > /dev/null

#
# Install the schemas
#
SCHEMAS="panel-global.schemas panel-general.schemas panel-toplevel.schemas panel-object.schemas clock.schemas fish.schemas window-list.schemas workspace-switcher.schemas panel-compatibility.schemas tasklist.schemas pager.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S > /dev/null
done

#
# Install the default setup into /apps/panel and /apps/panel/default_setup
#
gconftool-2 --direct --config-source=$GCONF_CONFIG_SOURCE --load %{_sysconfdir}/gconf/schemas/panel-default-setup.entries > /dev/null
gconftool-2 --direct --config-source=$GCONF_CONFIG_SOURCE --load %{_sysconfdir}/gconf/schemas/panel-default-setup.entries /apps/panel > /dev/null

/sbin/ldconfig

%postun
/sbin/ldconfig
  
%files -f %{gettext_package}.lang
%defattr(-,root,root)

%doc AUTHORS COPYING ChangeLog NEWS README

%{_datadir}/pixmaps/*.png
%{_datadir}/icons/hicolor/48x48/apps/*.png
%{_datadir}/gnome/panel
%{_datadir}/gnome/help/*
%{_datadir}/gnome-panelrc
%{_datadir}/idl/gnome-panel-2.0
%{_datadir}/gnome-2.0/ui/*.xml
%{_datadir}/omf/gnome-panel
%{_datadir}/man/man*/*
%{_bindir}/*
%{_libexecdir}/*
%{_libdir}/bonobo/servers/*.server
%{_libdir}/*.so.*
%{_sysconfdir}/gconf/schemas/*.schemas
%{_sysconfdir}/gconf/schemas/*.entries

%files devel
%defattr(-, root, root)
%{_libdir}/pkgconfig/*
%{_includedir}/panel-2.0
%{_libdir}/*.so
%{_datadir}/gtk-doc

%changelog
* Sun Jan 02 2005 Vincent Untz <vincent@vuntz.net>
- Update of CVS version based on Fedora one

* Sun Nov 10 2002 Christian F.K. Schaller <Uraeus@gnome.org>
- Initial update of CVS version based on RH one

