/*
 * Copyright (C) 2005 Ronald S. Bultje <rbultje@ronald.bitfreak.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GST_IMAGE_MIXER_PAD_H__
#define __GST_IMAGE_MIXER_PAD_H__

#include <gst/gst.h>

G_BEGIN_DECLS

#define GST_TYPE_IMAGE_MIXER_PAD \
  (gst_image_mixer_pad_get_type ())
#define GST_IMAGE_MIXER_PAD(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST (obj, GST_TYPE_IMAGE_MIXER_PAD, GstImageMixerPad))
#define GST_IS_IMAGE_MIXER_PAD(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE (obj, GST_TYPE_IMAGE_MIXER_PAD))

typedef enum {
  GST_IMAGE_MIXER_PAD_V_ALIGN_TOP,
  GST_IMAGE_MIXER_PAD_V_ALIGN_MIDDLE,
  GST_IMAGE_MIXER_PAD_V_ALIGN_BOTTOM
} GstImageMixerPadVAlign;

typedef enum {
  GST_IMAGE_MIXER_PAD_H_ALIGN_LEFT,
  GST_IMAGE_MIXER_PAD_H_ALIGN_CENTER,
  GST_IMAGE_MIXER_PAD_H_ALIGN_RIGHT
} GstImageMixerPadHAlign;

typedef struct _GstImageMixerFormat {
  gint width, height;
  guint32 fourcc;
} GstImageMixerFormat;

typedef struct _GstImageMixerPad {
  GstRealPad real_pad;

  GstImageMixerFormat fmt;

  /* cache current data (filler, interrupt, eos or buffer) */
  GstData *current_data;

  /* properties */
  gint z_order;
  gfloat alpha;
  gint v_offset, h_offset;
  gint v_align, h_align;
} GstImageMixerPad;

typedef struct _GstImageMixerPadClass {
  GstRealPadClass real_pad_class;
} GstImageMixerPadClass;

GType	gst_image_mixer_pad_get_type	(void);

G_END_DECLS

#endif /* __GST_IMAGE_MIXER_PAD_H__ */
