/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Copyright (C) 2005 Vincent Noel <vnoel@cox.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GDICT_ENTRY_H
#define GDICT_ENTRY_H

G_BEGIN_DECLS

#include <gtk/gtk.h>
#include "dict.h"
#include "gdict-app.h"

#define GDICT_TYPE_ENTRY            (gdict_entry_get_type ())
#define GDICT_ENTRY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDICT_TYPE_ENTRY, GDictEntry))
#define GDICT_ENTRY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GDICT_TYPE_ENTRY, GDictEntryClass))
#define GDICT_IS_ENTRY(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDICT_TYPE_ENTRY))
#define GDICT_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDICT_TYPE_ENTRY))
#define GDICT_ENTRY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GDICT_TYPE_ENTRY, GDictEntryClass))

typedef struct _GDictEntry        GDictEntry;
typedef struct _GDictEntryClass   GDictEntryClass;

struct _GDictEntry {
  GtkEntry entry;

  dict_context_t *context;
  dict_command_t *spell_cmd;
  gchar          *database;
  gchar          *current_text;
  int            completions;

  GDictWindow *gdict;
};

struct _GDictEntryClass {
    GtkEntryClass  parent_class;
    
    void (*word_lookup_start) (GDictEntry *);
    void (*word_lookup_done)  (GDictEntry *);
    void (*word_not_found)    (GDictEntry *);
    void (*socket_error)      (GDictEntry *, gchar *);
};

GtkWidget *gdict_entry_new         (GDictWindow *gdict);

G_END_DECLS

#endif /* GDICT_ENTRY_H */
