/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  fonts.c: test functions for the libgpa config database
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:
 *    Tambet Ingo <tambet@ximian.com>
 *
 *  Copyright (C) 2002 Ximian Inc. and authors
 *
 */

#include <popt.h>
#include <glib.h>
#include <libgnomeprint/gnome-font.h>

gboolean dump_list = FALSE;
gboolean dump_long_list = FALSE;

static struct poptOption options[] = {
	{ "list", 'l', POPT_ARG_NONE, &dump_list,   0,
	  "List fonts gnome-print knows about (Default action)", NULL},
	{ "list-full", 'f', POPT_ARG_NONE, &dump_long_list,   0,
	  "Dump full list of fonts and their properties",  NULL},
	POPT_AUTOHELP
	{ NULL }
};

static void
print_short_list (void)
{
	GList *list, *tmp;
	gchar *font;

	tmp = list = gnome_font_list ();

	while (tmp) {
		font = tmp->data;
		tmp = tmp->next;

		g_print ("%s\n", font);
	}

	gnome_font_list_free (list);
}

static void
print_long_list (void)
{
	g_print ("You think it's that easy? :)\n");
}

int
main (int argc, char *argv[])
{
	poptContext popt;

	popt = poptGetContext ("test", argc, argv, options, 0);
	poptGetNextOpt (popt);

	if (dump_long_list)
		print_long_list ();
	else
		print_short_list ();

	poptFreeContext (popt);

	return 0;
}
