#include "gnome-string.h"
#include <string.h>

gchar **gnome_split_string(gchar *string, gchar *delim, gint max_tokens)
{
	gchar **strings;
	gchar *src;
	guint src_len;
	gchar *start;
	gchar *contains;
	GList *list = NULL;
	GList *tmp_list;
	guint i;

	g_return_val_if_fail (string != NULL, NULL);
	g_return_val_if_fail (delim != NULL, NULL);

	src = g_strdup (string);
	src_len = strlen (src);
	start = src;
	i = 0;
	do
	{
		contains = strchr (delim, src[i]);
		if (contains)
		{
			src[i] = 0;
			list = g_list_append (list, g_strdup (start));
		}
		else if (src[i] != 0)
			list = g_list_append (list, g_strdup (start));

		start = &src[++i];
	}
	while (i < src_len && contains);

	g_free (src);

	tmp_list = g_list_first (list);

	if (max_tokens < 1)
		max_tokens = g_list_length (tmp_list);
	else
		max_tokens = MIN (g_list_length (tmp_list), max_tokens);

	strings = g_new (gchar*, max_tokens + 1);
	strings[max_tokens] = NULL;

	i = 0;
	while (tmp_list)
	{
		strings[i++] = tmp_list->data;

		tmp_list = tmp_list->next;

		if (i >= max_tokens)
			while (tmp_list)
			{
				g_free (tmp_list->data);
				tmp_list = tmp_list->next;
			}
	}
	g_list_free (list);

	return strings;
}

gchar *
gnome_join_strings(gchar *separator, ...)
{
	va_list l;
	va_start(l, separator);
	/* Elliot: this can not be done like this: */
/*	return gnome_join_vstrings(separator, l); */
}

gchar *
gnome_join_vstrings(gchar *separator, gchar **strings)
{
	gchar *retval;
	gint total_size, i, seplen;

	g_return_val_if_fail(separator != NULL, NULL);
	g_return_val_if_fail(strings != NULL, NULL);

	/* While it's not an error to have no strings to join, it
	   still needs to be handled differently */
	if(!strings[0])
		return g_strdup("");

	total_size = strlen(strings[0]) + 1;
	retval = g_malloc(total_size);
	strcpy(retval, strings[0]);
	seplen = strlen(separator);

	for(i = 1; strings[i]; i++)
	{
		total_size += seplen + strlen(strings[i]);
		retval = g_realloc(retval, total_size);
		strcat(retval, separator);
		strcat(retval, strings[i]);
	}

	return retval;
}
