#ifndef PANEL_H
#define PANEL_H

#include "gnome.h"

BEGIN_GNOME_DECLS


typedef enum {
	PANEL_POS_TOP,
	PANEL_POS_BOTTOM,
	PANEL_POS_LEFT,
	PANEL_POS_RIGHT
} PanelPos;

typedef enum {
	PANEL_HIDDEN,
	PANEL_SHOWN
} PanelState;

typedef enum {
	PANEL_STAYS_PUT,
	PANEL_GETS_HIDDEN
} PanelMode;

typedef enum {
	APPLET_HAS_PROPERTIES = 1 << 0
} AppletFlags;

typedef struct {
	GtkWidget  *window;
	GtkWidget  *fixed;
	PanelPos    pos;
	PanelState  state;
	PanelMode   mode;
	int         step_size;
	int         delay;
} Panel;

typedef enum {
	PANEL_CMD_REGISTER_TOY,
	PANEL_CMD_QUIT
} PanelCommandType;

typedef struct {
	PanelCommandType cmd;

	union {
		/* Register toy parameters */
		struct {
			GtkWidget *applet;
			int        xpos;
			int        ypos;
			int        flags;
		} register_toy;
	} params;
} PanelCommand;

typedef int (*PanelCallback) (Panel *panel, PanelCommand *cmd);

Panel *panel_new(void);

int panel_command (Panel *panel, PanelCommand *cmd);

END_GNOME_DECLS

#endif
