/*
 * Screen Saver property configurator
 * Written by Radek Doulik, 1997 <doulik@karlin.mff.cuni.cz>
 */

#include "property-screensaver.h"
#include "xlockmore.h"
#include <stdio.h>
#include <stdarg.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include "gnome.h"
#include "gnome-desktop.h"

#define _(String) gettext(String)

ConfigScreenSaver *css;

struct SelectInfo {
	ConfigScreenSaver *th;
	ScreenSaverMode *m;
	
	SelectInfo (ConfigScreenSaver *t, ScreenSaverMode *p) : th (t), m(p) {}
};

void
ConfigScreenSaver::select_mode (GtkWidget *, GdkEventButton *, SelectInfo *si)
{
	si->th->curMode = si->m;
	si->m->run (SS_PREVIEW,
		    (gint)(GTK_RANGE (si->th->nice)->adjustment->value),
		    si->th->monitor,
		    GNOME_MONITOR_WIDGET_X,
		    GNOME_MONITOR_WIDGET_Y,
		    GNOME_MONITOR_WIDGET_WIDTH,
		    GNOME_MONITOR_WIDGET_HEIGHT);
}

void
ConfigScreenSaver::test_mode (GtkWidget *, ConfigScreenSaver *th)
{
	if (th->curMode)
		th->curMode->run (SS_TEST,
				  (gint)(GTK_RANGE (th->nice)->adjustment->value),
				  GTK_TOGGLE_BUTTON (th->lock)->active);
}

void
ConfigScreenSaver::setup_mode (GtkWidget *, ConfigScreenSaver *th)
{
	if (th->curMode)
		th->curMode->setup ();
}

static void
insert_modes_to_list (ScreenSaverMode *m, ConfigScreenSaver *th)
{
	GtkWidget *listItem;

        // printf ("adding %s\n", m->name);
	listItem = gtk_list_item_new_with_label (m->name);
	gtk_signal_connect (GTK_OBJECT (listItem),
			    "button_press_event",
			    (GtkSignalFunc) ConfigScreenSaver::select_mode,
			    (gpointer)new SelectInfo (th, m));
	gtk_container_add (GTK_CONTAINER (th->mlist), listItem);
	gtk_widget_show (listItem);

	m->lp = gtk_list_child_position (GTK_LIST (th->mlist), listItem);
}

void
ConfigScreenSaver::add_screensaver (ScreenSaver *ss)
{
	g_hash_table_insert (ssavers, ss->name, ss);
	g_list_foreach (ss->modesL, (GFunc) insert_modes_to_list, this);
}

void
ConfigScreenSaver::setup_screensavers ()
{
	// add all known screensavers (ok, now we have only xlockmore :)
	add_screensaver (new XLockMore);

	/* printf ("screensaver: %s\nmode: %s\n",
				     gnome_config_get_string ("/Desktop/"
							      "ScreenSaver/"
							      "screensaver=xlockmore"),
					     gnome_config_get_string ("/Desktop/"
								      "ScreenSaver/"
								      "mode=blank")
		); */

	// look in config for mode
	ScreenSaver *ss = (ScreenSaver *)
		g_hash_table_lookup (ssavers,
				     gnome_config_get_string ("/Desktop/"
							      "ScreenSaver/"
							      "screensaver=xlockmore"));
	if (ss)
		curMode = (ScreenSaverMode *)
			g_hash_table_lookup (ss->modes,
					     gnome_config_get_string ("/Desktop/"
								      "ScreenSaver/"
								      "mode=blank"));
	gtk_list_select_item (GTK_LIST (mlist), curMode->lp);
}

GtkWidget *
ConfigScreenSaver::settings_frame ()
{
	GtkWidget *vbox, *hb1;
	GtkWidget *f, *l1, *l2;
	GtkObject *adjustment;
	GtkWidget *vb1, *l3, *hb2, *l4, *l5;
	
	f  = gtk_frame_new (_("Settings"));

	l1 = gtk_label_new (_("Wait"));
	l2 = gtk_label_new (_("min"));
	waitMin  = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (waitMin),
			    gnome_config_get_string ("/Desktop/ScreenSaver/waitMin=5"));

	gtk_widget_set_usize (waitMin, 50, -1);
	hb1 = gtk_hbox_new (FALSE, 0);

	lock = gtk_check_button_new_with_label (_("requires password"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (lock),
				     gnome_config_get_int ("/Desktop/ScreenSaver/lock=1"));

	vb1 = gtk_vbox_new (FALSE, 0);
	l3 = gtk_label_new (_("Priority"));
	gtk_misc_set_alignment (GTK_MISC (l3), 0, 0.5);

	adjustment = gtk_adjustment_new (gnome_config_get_int ("/Desktop/ScreenSaver/nice=12"),
					 0.0, 19.0, 1.0, 1.0, 0.0);
	nice = gtk_hscale_new (GTK_ADJUSTMENT (adjustment));
	gtk_scale_set_digits (GTK_SCALE (nice), 0);
	gtk_scale_set_draw_value (GTK_SCALE (nice), FALSE);
	l4 = gtk_label_new (_("normal"));
	l5 = gtk_label_new (_("low"));
	hb2 = gtk_hbox_new (FALSE, 0);
     
	vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_border_width (GTK_CONTAINER (vbox), 10);

	gtk_box_pack_start (GTK_BOX (hb1), l1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hb1), waitMin, TRUE, TRUE, 10);
	gtk_box_pack_start (GTK_BOX (hb1), l2, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hb1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), lock, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vb1), l3, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vb1), nice, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hb2), l4, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hb2), l5, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vb1), hb2, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), vb1, FALSE, TRUE, 0);
	gtk_container_add (GTK_CONTAINER (f), vbox);

	gtk_widget_show (l1);
	gtk_widget_show (l2);
	gtk_widget_show (waitMin);
	gtk_widget_show (lock);
	gtk_widget_show (l3);
	gtk_widget_show (nice);
	gtk_widget_show (l4);
	gtk_widget_show (l5);
	gtk_widget_show (hb1);
	gtk_widget_show (hb2);
	gtk_widget_show (vb1);
	gtk_widget_show (vbox);

	return f;
}

GtkWidget *
ConfigScreenSaver::modes_frame ()
{
	GtkWidget *f, *hb1, *vb1, *b1, *b2;

	f  = gtk_frame_new (_("Screen savers"));

	hb1 = gtk_hbox_new (FALSE, 10);
	gtk_container_border_width (GTK_CONTAINER (hb1), 10);

	sw = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	mlist = gtk_list_new ();
	gtk_list_set_selection_mode (GTK_LIST (mlist), GTK_SELECTION_BROWSE);
	gtk_widget_set_usize (f, 220, -1);
	vb1 = gtk_vbox_new (FALSE, 10);
	b1 = gtk_button_new_with_label (_("Setup"));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
			    (GtkSignalFunc) setup_mode, (gpointer)this);

	b2 = gtk_button_new_with_label (_("Test"));
	gtk_signal_connect (GTK_OBJECT (b2), "clicked",
			    (GtkSignalFunc) test_mode, (gpointer)this);


	gtk_container_add (GTK_CONTAINER (sw), mlist);
	gtk_box_pack_start (GTK_BOX (hb1), sw, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vb1), b1, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vb1), b2, FALSE, FALSE, 0);
	gtk_box_pack_end (GTK_BOX (hb1), vb1, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER (f), hb1);

	gtk_widget_show (sw);
	gtk_widget_show (mlist);
	gtk_widget_show (b1);
	gtk_widget_show (b2);
	gtk_widget_show (vb1);
	gtk_widget_show (hb1);

	return f;
}

static void
runPreviewXLock (GtkWidget *w, ConfigScreenSaver *c)
{
	// printf ("map\n");
	if (c->curMode)
		c->curMode->run (SS_PREVIEW,
				 (gint)(GTK_RANGE (c->nice)->adjustment->value),
				 c->monitor,
				 GNOME_MONITOR_WIDGET_X,
				 GNOME_MONITOR_WIDGET_Y,
				 GNOME_MONITOR_WIDGET_WIDTH,
				 GNOME_MONITOR_WIDGET_HEIGHT);
}

static void
killPreviewXLock (GtkWidget *w, ConfigScreenSaver *c)
{
	// printf ("unmap\n");
	if (c->curMode)
		c->curMode->stop (SS_PREVIEW);
}

ConfigScreenSaver::ConfigScreenSaver (GtkWidget *window)
{
	GtkWidget *hbox, *bottom;
	GtkWidget *settings, *modes;
	
	ssavers = g_hash_table_new (g_hash_function_gcharp,
				    g_hash_compare_gcharp);
	curMode = NULL;
	
	vbox = gtk_vbox_new (TRUE, 0);
	hbox = gtk_hbox_new (TRUE, 0);
	gtk_container_border_width (GTK_CONTAINER (hbox), GNOME_PAD);
	bottom = gtk_hbox_new (FALSE, GNOME_PAD);
	gtk_container_border_width (GTK_CONTAINER (bottom), GNOME_PAD);

	monitor = get_monitor_preview_widget (window);
	gtk_signal_connect (GTK_OBJECT (monitor), "map",
			    (GtkSignalFunc) runPreviewXLock, this);
	gtk_signal_connect (GTK_OBJECT (monitor), "unmap",
			    (GtkSignalFunc) killPreviewXLock, this);
	gtk_signal_connect (GTK_OBJECT (monitor), "destroy",
			    (GtkSignalFunc) killPreviewXLock, this);


	settings = settings_frame ();
	modes = modes_frame ();

	gtk_box_pack_start (GTK_BOX(hbox), monitor, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX(bottom), settings, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX(bottom), modes, TRUE, TRUE, 0);
	gtk_box_pack_end (GTK_BOX (vbox), bottom, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

	setup_screensavers ();

	gtk_widget_show (monitor);
	gtk_widget_show (settings);
	gtk_widget_show (modes);
	gtk_widget_show (hbox);
	gtk_widget_show (bottom);
	gtk_widget_show (vbox);
}


GtkWidget *
prepareConfigScreenSaver (GtkWidget *w)
{
	css = new ConfigScreenSaver (w);
	return css->vbox;
}

static gint
screensaver_action (GnomePropertyRequest req)
{
	char buffer [60];
	int r, g, b;
	
	if (req != GNOME_PROPERTY_APPLY)
		return 0;

	gnome_config_set_string ("/Desktop/ScreenSaver/screensaver",
				 css->curMode->parent->name);
	gnome_config_set_string ("/Desktop/ScreenSaver/mode",
				 css->curMode->name);
	gnome_config_set_int ("/Desktop/ScreenSaver/nice",
			      (gint)(GTK_RANGE (css->nice)->adjustment->value));
	gnome_config_set_string ("/Desktop/ScreenSaver/lock",
				 (GTK_TOGGLE_BUTTON (css->lock)->active)
				 ? "true" : "false");
	gnome_config_set_string ("/Desktop/ScreenSaver/waitMin",
				 gtk_entry_get_text (GTK_ENTRY (css->waitMin)));

	return 1;
}

extern "C" {
void
screensaver_setup (GtkWidget *window)
{
	GtkWidget *sc;

	sc = prepareConfigScreenSaver (window);

	register_extension (gtk_label_new (_(" Screen saver ")),
			    sc, screensaver_action);
}
}
