#ifndef __RAFT_CONFIG_H__
#define __RAFT_CONFIG_H__

/* a linked list of all the launcher buttons */

struct _Raft_launcher 
{
    char *label_text;
    char *command;
    char *tooltips_text;
    char *xpm_file;
    GtkWidget *button;
    GtkWidget *label;
    GtkTooltips *tooltip;
    GtkWidget *pixmap;
    GtkWidget *box;
    
    struct _Raft_launcher *next;
    
} _Raft_launcher;

typedef struct _Raft_launcher Raft_launcher;

/* application defaults */

typedef struct 
{
    /* average padding around objects. */
    gint padding;

    gint spacing;
    gint x_position;
    gint y_position;
    
    /* whether the launcher is all expanded or not */
    gint expanded;

    /* set usize of buttons, -1 to not set.*/
    gint x_usize;
    gint y_usize;
    
    /* 0 for horizontal, 1 for vertical button bar. */
    gint orientation;
    
    /* direction to open - 0 to open to the right or down, 1 to open to the
     * left or up.. depending on the orientation. */
    gint open_direction;
    
    /* boolean - close on launch ? */
    gint close_on_launch;
    
    /* wether we're in config mode or normal mode */
    gint config_mode;
    
    /* Launcher window */
    GtkWidget *window;
    
    /* The first box packed into the main launcher window */
    GtkWidget *main_box;
    
} Raft_info;


void raft_config_interface_show(void);
void raft_config_register_button(GtkWidget *widget);

#endif /* __RAFT_CONFIG_H__ */
