#include "obgtkFontSelection.h"
#include "obgtkButton.h"

@implementation Gtk_FontSelection
- castGtkFontSelection:(GtkFontSelection *) castitem
{
  gtkfontselection = castitem;
  return [super castGtkNotebook:GTK_NOTEBOOK(castitem)];
}

- init
{
  return [self castGtkFontSelection:GTK_FONT_SELECTION(gtk_font_selection_new())];
}

- (gchar *) get_font_name
{
  return gtk_font_selection_get_font_name(gtkfontselection);
}

- (GdkFont *) get_font
{
  return gtk_font_selection_get_font(gtkfontselection);
}

- (gboolean) set_font_name:(const gchar *) fontname
{
  return gtk_font_selection_set_font_name(gtkfontselection, fontname);
}

- (gchar *) get_preview_text
{
  return gtk_font_selection_get_preview_text(gtkfontselection);
}

- set_preview_text:(const gchar *) text
{
  gtk_font_selection_set_preview_text(gtkfontselection, text);
  return self;
}

@end

@implementation Gtk_FontSelectionDialog
- castGtkFontSelectionDialog:(GtkFontSelectionDialog *) castitem
{
  gtkfontselectiondialog = castitem;
  fontsel = [[Gtk_FontSelection alloc] castGtkFontSelection:GTK_FONT_SELECTION(castitem->fontsel)];
  ok_button = [[Gtk_Button alloc] castGtkButton:GTK_BUTTON(castitem->ok_button)];
  apply_button = [[Gtk_Button alloc] castGtkButton:GTK_BUTTON(castitem->apply_button)];
  cancel_button = [[Gtk_Button alloc] castGtkButton:GTK_BUTTON(castitem->cancel_button)];
  return [super castGtkWindow:GTK_WINDOW(castitem)];
}

- initWithTitle:(const gchar *) title
{
  return [self castGtkFontSelectionDialog:GTK_FONT_SELECTION_DIALOG(gtk_font_selection_dialog_new(title))];
}

- (gchar *) get_font_name
{
  return [fontsel get_font_name];
}

- (GdkFont *) get_font
{
  return [fontsel get_font];
}

- (gboolean) set_font_name:(const gchar *) fontname
{
  return [fontsel set_font_name:fontname];
}

- (gchar *) get_preview_text
{
  return [fontsel get_preview_text];
}

- set_preview_text:(const gchar *) text
{
  [fontsel set_preview_text:text];
  return self;
}
@end
