AC_DEFUN([GNOME_CHECK_OBJC],
[
dnl Look for an ObjC compiler.
dnl FIXME: extend list of possible names of ObjC compilers.
  AC_CHECK_PROGS(OBJC, $OBJC egcs, "")
  if test "x$OBJC" = "x" ; then
    AC_CHECK_PROGS(OBJC, $OBJC gcc, "")
  fi

  AC_REQUIRE([GNOME_PTHREAD_CHECK])

  OBJC_LIBS="-lobjc $PTHREAD_LIB"
  AC_CHECK_FUNC(sched_yield,,[
    AC_CHECK_LIB(posix4,sched_yield,
		OBJC_LIBS="$OBJC_LIBS -lposix4",, $OBJC_LIBS)])
  AC_SUBST(OBJC_LIBS)

  AC_CACHE_CHECK([if Objective C compiler ($OBJC) works],
		 ac_cv_prog_objc_works, [
    if test -n "$OBJC"; then
      cat > conftest.m <<EOF
#include <objc/Object.h>
@interface myRandomObj : Object
{
}
@end
@implementation myRandomObj
@end
int main () {
  /* No, you are not seeing double.  Remember that square brackets
     are the autoconf m4 quotes.  */
  id myid = [[myRandomObj alloc]];
  [[myid free]];
  return 0;
}
EOF

      $OBJC -o conftest $LDFLAGS conftest.m $OBJC_LIBS 1>&AC_FD_CC 2>&1
      result=$?
      rm -f conftest*

      if test $result -eq 0; then
        ac_cv_prog_objc_works=yes
      fi
    else
      ac_cv_prog_objc_works=no
    fi
  ])

  AM_CONDITIONAL(OBJECTIVE_C, test x$ac_cv_prog_objc_works = xyes)
  dnl Also set the shell variable OBJECTIVE_C to "yes" or "no".
  OBJECTIVE_C=$ac_cv_prog_objc_works
])

AC_DEFUN([GNOME_INIT_OBJC],
[
        AC_MSG_CHECKING(for obGnomeConf.sh file in $gnome_prefix)
	if test -f $gnome_prefix/obGnomeConf.sh; then
	    . $gnome_prefix/obGnomeConf.sh
	    AC_MSG_RESULT(found)
	else
	    AC_MSG_RESULT(not found)
	    AC_MSG_ERROR(Could not find the obGnomeConf.sh file that is generated by gnome-objc install)
	fi
	AC_SUBST(OBGNOME_INCLUDEDIR)
	AC_SUBST(OBGNOME_LIBS)
	AC_SUBST(OBGTK_LIBS)
])
