/*
 * $Id: menus.c,v 1.8 1998/07/29 21:18:49 jochen Exp $
 * GXSNMP - An snmp managment application
 * Copyright (C) 1998 Gregory McLean
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc.,  59 Temple Place - Suite 330, Cambridge, MA 02139, USA.
 *
 * Menu code.
 */
#include <gtk/gtk.h>
#include "menus.h"
#include "main.h"
#include "host_list.h"

extern gxsnmp *app_info;

static void info_menu_cb   (GtkWidget     *widget,
			    gpointer      data);
static void intf_menu_cb   (GtkWidget     *widget,
			    gpointer      data);
static void edit_menu_cb   (GtkWidget     *widget,
			    gpointer      data);
static void dnode_menu_cb  (GtkWidget     *widget,
			    gpointer      data);
static void route_menu_cb  (GtkWidget     *widget,
			    gpointer      data);

void 
create_host_popup (GtkWindow *window)
{
  GtkWidget              *menu_item;
#ifdef GTK_HAVE_FEATURES_1_1_0
  GtkAccelGroup          *accel_table;
  accel_table = gtk_accel_group_new ();
#else
  GtkAcceleratorTable    *accel_table;
  accel_table = gtk_accelerator_table_new ();
#endif
  app_info->host_popup_right = gtk_menu_new ();
  gtk_widget_realize (app_info->host_popup_right);
#ifdef GTK_HAVE_FEATURES_1_1_0
  gtk_accel_group_attach (accel_table, app_info->host_popup_right);
#else
  gtk_menu_set_accelerator_table (GTK_MENU(app_info->host_popup_right),
				  accel_table);
  gtk_window_add_accelerator_table (GTK_WINDOW (window), accel_table);
#endif
  menu_item = gtk_menu_item_new_with_label (_("Node Information"));
#ifdef GTK_HAVE_FEATURES_1_1_0
  gtk_widget_add_accelerator (GTK_WIDGET (menu_item),
			      "activate", accel_table, 'I', GDK_MOD1_MASK, 
			      GTK_ACCEL_VISIBLE);
#else
  gtk_widget_install_accelerator (menu_item,
				  accel_table,
				  "activate", 'I', GDK_MOD1_MASK);
#endif
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
		      GTK_SIGNAL_FUNC (info_menu_cb),
		      NULL);
  gtk_menu_append (GTK_MENU (app_info->host_popup_right), menu_item);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (_("Route table"));
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
		      GTK_SIGNAL_FUNC (route_menu_cb),
		      NULL);
  gtk_menu_append (GTK_MENU (app_info->host_popup_right), menu_item);
  gtk_widget_show (menu_item);

  menu_item = gtk_menu_item_new_with_label (_("Node Interfaces"));
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
		      GTK_SIGNAL_FUNC (intf_menu_cb),
		      NULL);
  gtk_menu_append (GTK_MENU (app_info->host_popup_right), menu_item);
  gtk_widget_show (menu_item);
  menu_item = gtk_menu_item_new_with_label (_("Edit host"));
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
		      GTK_SIGNAL_FUNC (edit_menu_cb),
		      NULL);
  gtk_menu_append (GTK_MENU (app_info->host_popup_right), menu_item);
  gtk_widget_show (menu_item);
  menu_item = gtk_menu_item_new_with_label (_("Delete host"));
  gtk_signal_connect (GTK_OBJECT (menu_item), "activate",
		      GTK_SIGNAL_FUNC (dnode_menu_cb),
		      NULL);
  gtk_menu_append (GTK_MENU (app_info->host_popup_right), menu_item);
  gtk_widget_show (menu_item);

}

void
host_menu_right_popup (gint button, guint32 activate_time)
{
  gtk_menu_popup(GTK_MENU(app_info->host_popup_right), NULL, NULL,
		 NULL, NULL, button, activate_time);
}

static void
info_menu_cb (GtkWidget *widget, gpointer data)
{
  open_sysinfo_panel ();
}

static void
intf_menu_cb (GtkWidget *widget, gpointer data)
{
  open_interface_panel ();
}

static void
edit_menu_cb (GtkWidget *widget, gpointer data)
{
  open_edit_panel ();
}

static void
dnode_menu_cb (GtkWidget *widget, gpointer data)
{
  hosts *host;
#ifdef HAVE_SQL
  sql_server    *sql_serv;
#endif

  if (app_info->current_host != NULL)
    {
      host = gtk_object_get_data (GTK_OBJECT (app_info->current_host),
				  "host_entry");
      hl_del_host (host);
      app_info->host_count--;
      update_known_hosts (app_info->host_count);
#ifdef HAVE_SQL
      sql_serv = g_new (sql_server, 1);
      sql_serv->sql_host = g_strdup (app_info->current_config.def_sql_host);
      sql_serv->sql_user = g_strdup (app_info->current_config.def_sql_user);
      sql_serv->sql_pass = g_strdup (app_info->current_config.def_sql_pass);
      sql_del_host_entry (sql_serv, host);
      g_free (sql_serv);
#endif
    }
}

static void
route_menu_cb (GtkWidget *widget, gpointer data)
{
  open_route_panel ();
}

/* EOF */
