/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtksbox.h"


static void gtk_sbox_class_init    (GtkSBoxClass   *klass);
static void gtk_sbox_init          (GtkSBox        *box);
static void gtk_sbox_size_request  (GtkWidget      *widget,
				    GtkRequisition *requisition);
static void gtk_sbox_size_allocate (GtkWidget      *widget,
				    GtkAllocation  *allocation);


guint
gtk_sbox_get_type ()
{
  static guint sbox_type = 0;

  if (!sbox_type)
    {
      GtkTypeInfo sbox_info =
      {
	"GtkSBox",
	sizeof (GtkSBox),
	sizeof (GtkSBoxClass),
	(GtkClassInitFunc) gtk_sbox_class_init,
	(GtkObjectInitFunc) gtk_sbox_init,
	(GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL,
      };

      sbox_type = gtk_type_unique (gtk_box_get_type (), &sbox_info);
    }

  return sbox_type;
}

static void
gtk_sbox_class_init (GtkSBoxClass *class)
{
  GtkWidgetClass *widget_class;

  widget_class = (GtkWidgetClass*) class;

  widget_class->size_request = gtk_sbox_size_request;
  widget_class->size_allocate = gtk_sbox_size_allocate;
}

static void
gtk_sbox_init (GtkSBox *sbox)
{
}

GtkWidget*
gtk_sbox_new (gint homogeneous,
	      gint spacing)
{
  GtkSBox *sbox;

  sbox = gtk_type_new (gtk_sbox_get_type ());

  GTK_BOX (sbox)->spacing = 4;

  return GTK_WIDGET (sbox);
}


static void
gtk_sbox_size_request (GtkWidget      *widget,
		       GtkRequisition *requisition)
{
  GtkBox *box;
  GtkBoxChild *child;
  GList *children;
  gint nvis_children;
  gint height;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_SBOX (widget));
  g_return_if_fail (requisition != NULL);

  box = GTK_BOX (widget);
  requisition->width = 0;
  requisition->height = 0;
  nvis_children = 0;

  children = box->children;
  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
	  gtk_widget_size_request (child->widget, &child->widget->requisition);
	      requisition->height += child->widget->requisition.height + 
		child->padding * 2;
	  nvis_children += 1;
	}
    }

  if (nvis_children > 0)
    {
      requisition->height += (nvis_children - 1) * box->spacing;
    }


  requisition->width += GTK_CONTAINER (box)->border_width * 2;
  requisition->height += GTK_CONTAINER (box)->border_width * 2;
}

static void
gtk_sbox_size_allocate (GtkWidget     *widget,
			GtkAllocation *allocation)
{
  GtkBox *box;
  GtkBoxChild *child;
  GList *children;
  GtkAllocation child_allocation;
  gint nvis_children;
  gint child_height;
  gint height;
  gint x,y;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_SBOX (widget));
  g_return_if_fail (allocation != NULL);

  box = GTK_BOX (widget);
  widget->allocation = *allocation;

  nvis_children = 0;
  children = box->children;

  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
	  nvis_children += 1;
	}
    }
  if (nvis_children > 0)
    {
      y = allocation->y + GTK_CONTAINER (box)->border_width;
      x = allocation->x + GTK_CONTAINER (box)->border_width;
      children = box->children;
      while (children)
	{
	  child = children->data;
	  if (GTK_WIDGET_VISIBLE (child->widget))
	    {
	      child_height = child->widget->requisition.height +
		             child->padding * 2;
	      child_allocation.height = child->widget->requisition.height;
	      child_allocation.width = child->widget->requisition.width;
	      child_allocation.y = y + (child_height - child_height) / 2;
	      child_allocation.x = x;
	      gtk_widget_size_allocate (child->widget, &child_allocation);
	      y += child_height + box->spacing;
	    }
	  children = children->next;
	}
  
    }
}

















