#include "global.h"
#include "graph.h"

static void
graph_expose (GtkWidget *w, GdkEventExpose *e, Graph *g)
{
	if (g->bs)
		gdk_window_copy_area (w->window,
				      w->style->black_gc,
				      e->area.x, e->area.y,
				      g->bs,
				      e->area.x, e->area.y,
				      e->area.width, e->area.height);
	else
		gdk_draw_rectangle (w->window,
				    w->style->bg_gc [0],
				    TRUE,
				    e->area.x, e->area.y,
				    e->area.width, e->area.height);
}

Graph *
graph_new (gpointer (*d_fn) (GraphCmd, gpointer))
{
	Graph *g = g_new (Graph, 1);

	g->data_fn = d_fn;
	g->bs = NULL;
	g->n = 0;
	g->colors_allocated = 0;

	g->da = gtk_drawing_area_new ();
	gtk_widget_set_events (g->da, GDK_EXPOSURE_MASK);
	gtk_signal_connect (GTK_OBJECT (g->da), "expose_event",
			    (GtkSignalFunc) graph_expose, (gpointer) g);
	/* gtk_signal_connect (GTK_OBJECT (pb->bar), "size_request",
			    (GtkSignalFunc) graph_request, (gpointer) g); */

	return g;
}

GtkWidget *
graph_widget (Graph *g)
{
	return g->da;
}

#define GRAPH_WIDTH       100
#define GRAPH_LINE_WIDTH   80
#define GRAPH_PAD_WIDTH    20

static void
graph_process_data (Graph *g)
{
	gint w ,h, draw;
	gpointer data;
	unsigned value, total;
	gchar *label;
	gint ll, mll = 0;
	gint th, gh=0, cgh;
	gint i, c = 0;
	GdkGC **tgcs;
	gint lines, fh, asc2;
	
	lines = total = 0;
	w = h = 10;

	if (!GTK_WIDGET_REALIZED (g->da))
		gtk_widget_realize (g->da);

	if (!g->colors_allocated) {
		GdkColormap *cmap;

		cmap = gdk_window_get_colormap (g->da->window);
		for (i = 0; i < g->n; i++)
			gdk_color_alloc (cmap, &g->colors [i]);

		g->colors_allocated = 1;
	}

	tgcs = g_new (GdkGC *, g->n);
	for (i = 0; i < g->n; i++) {
		tgcs [i] = gdk_gc_new (g->da->window);

		gdk_gc_copy (tgcs [i], g->da->style->text_gc [0]);
		gdk_gc_set_foreground (tgcs [i], &g->colors [i]);
	}

	if (g->bs) {
		gdk_pixmap_unref (g->bs);
		g->bs = NULL;
	}

	th = g->da->style->font->ascent;
	asc2 = th >> 1;
	fh = 1.2 * (g->da->style->font->ascent + g->da->style->font->descent) + 2;

	for (draw = 0; draw < 2; draw++) {
		if (draw) {
			g->bs = gdk_pixmap_new (g->da->window, w, h, -1);

			gdk_draw_rectangle (g->bs,
					    g->da->style->bg_gc [0],
					    TRUE,
					    0, 0,
					    w, h);
			h -= lines;
		}

		data = g->data_fn (GRAPH_FIRST, NULL);

		while (data) {
			value = (unsigned) g->data_fn (GRAPH_VALUE, data);
			label = g->data_fn (GRAPH_LABEL, data);
			/* printf ("label: %s\n", label); */

			data = g->data_fn (GRAPH_NEXT, data);

			if (draw) {

				cgh = h * ((double) value / total);
				gdk_draw_rectangle (g->bs,
						    tgcs [c],
						    TRUE,
						    0, gh,
						    GRAPH_WIDTH, cgh);
				gdk_draw_line (g->bs,
					       tgcs [c],
					       GRAPH_WIDTH + GRAPH_PAD_WIDTH,
					       gh + (cgh >> 1),
					       GRAPH_WIDTH + GRAPH_LINE_WIDTH +
					       GRAPH_PAD_WIDTH,
					       th - asc2);
				       
				gdk_draw_text (g->bs, g->da->style->font,
					       tgcs [c],
					       GRAPH_WIDTH + GRAPH_LINE_WIDTH +
					       (GRAPH_PAD_WIDTH << 1),
					       th,
					       label, strlen (label));
				       
				gh += (cgh) ? cgh + 1 : 0;
				th += fh;
				c++;
				c %= g->n;
				h -= cgh;
				total -= value;

			} else {
				total += value;
				h+=2;
				ll = gdk_string_width (g->da->style->font, label);
				if (mll < ll)
					mll = ll;
			}

			lines ++;
		}

		if (!draw) {
			w = GRAPH_WIDTH + GRAPH_LINE_WIDTH + (GRAPH_PAD_WIDTH << 1) +
				mll;
			h = fh * lines;

			gtk_widget_set_usize (g->da, w, h);
		}

		if (!lines)
			break;
	}

	for (i = 0; i < g->n; i++)
		gdk_gc_unref (tgcs [i]);
	g_free (tgcs);
}

void
graph_update (Graph *g)
{
	graph_process_data (g);
}

void
graph_colors_set (Graph *g, GdkColor *cs, gint n)
{
	g->colors_allocated = 0;
	g->colors = cs;
	g->n = n;
}
