#include "obgtkToolbar.h"

@implementation Gtk_Toolbar
- castGtkToolbar:(GtkToolbar *)castitem
{
  gtktoolbar = castitem;
  return [super castGtkContainer:GTK_CONTAINER(castitem)];
}

- init
{
  return [self initWithToolbarInfo:GTK_ORIENTATION_HORIZONTAL
	       :GTK_TOOLBAR_BOTH];
}

- initWithToolbarInfo:(GtkOrientation) orientation
		     :(GtkToolbarStyle) style
{
  return [self castGtkToolbar:GTK_TOOLBAR(gtk_toolbar_new(orientation, style))];
}

- append_item:(const char *) text
	     :(const char *) tooltip_text
	     :(const char *) private_tooltip_text
	     :(Gtk_Widget *) icon
	     :(GtkSignalFunc) callback
	     :(gpointer) user_data
{
  gtk_toolbar_append_item(gtktoolbar, text, tooltip_text,
			  private_tooltip_text,
			  icon->gtkwidget, callback, user_data);
  return self;
}

- prepend_item:(const char *) text
	      :(const char *) tooltip_text
	      :(const char *) private_tooltip_text
	      :(Gtk_Widget *) icon
	      :(GtkSignalFunc) callback
	      :(gpointer) user_data
{
  gtk_toolbar_prepend_item(gtktoolbar, text, tooltip_text,
			   private_tooltip_text,
			   icon->gtkwidget, callback, user_data);
  return self;
}

- insert_item:(const char *) text
	     :(const char *) tooltip_text
	     :(const char *) private_tooltip_text
	     :(Gtk_Widget *) icon
	     :(GtkSignalFunc) callback
	     :(gpointer) user_data
	     :(gint) position
{
  gtk_toolbar_insert_item(gtktoolbar, text, tooltip_text,
			  private_tooltip_text,
			  icon->gtkwidget, callback, user_data,
			  position);
  return self;
}

- append_space
{
  gtk_toolbar_append_space(gtktoolbar);
  return self;
}

- prepend_space
{
  gtk_toolbar_prepend_space(gtktoolbar);
  return self;
}

- insert_space:(gint) position
{
  gtk_toolbar_insert_space(gtktoolbar, position);
  return self;
}

- set_orientation:(GtkOrientation) orientation
{
  gtk_toolbar_set_orientation(gtktoolbar, orientation);
  return self;
}

- set_style:(GtkToolbarStyle) style
{
  gtk_toolbar_set_style(gtktoolbar, style);
  return self;
}

- set_tooltips:(BOOL) enable
{
  gtk_toolbar_set_tooltips(gtktoolbar, enable);
  return self;
}
@end
