#include "obgtkSpinButton.h"

@implementation Gtk_SpinButton
- castGtkSpinButton:(GtkSpinButton *) castitem
{
  gtkspinbutton = castitem;
  return [super castGtkEntry:GTK_ENTRY(castitem)];
}

- initWithSpinInfo:(Gtk_Adjustment *) adjustment
		  :(gfloat) climb_rate
		  :(gint) digits
{
  return [self castGtkSpinButton:GTK_SPIN_BUTTON(gtk_spin_button_new(adjustment->gtkadjustment, climb_rate, digits))];
}

- set_adjustment:(Gtk_Adjustment *) adjustment
{
  gtk_spin_button_set_adjustment(gtkspinbutton, adjustment->gtkadjustment);
}

- (id) get_adjustment
{
  return (id)gtk_object_get_data(GTK_OBJECT(gtk_spin_button_get_adjustment(gtkspinbutton)), "objc_id");
}

- set_digits:(gint) digits
{
  gtk_spin_button_set_digits(gtkspinbutton, digits);
  return self;
}

- (gfloat) get_value_as_float
{
  return gtk_spin_button_get_value_as_float(gtkspinbutton);
}

- (gint) get_value_as_int
{
  return gtk_spin_button_get_value_as_int(gtkspinbutton);
}

- set_value:(gfloat) value
{
  gtk_spin_button_set_value(gtkspinbutton, value);
  return self;
}

- set_update_policy:(GtkSpinButtonUpdatePolicy) policy
{
  gtk_spin_button_set_update_policy(gtkspinbutton, policy);
  return self;
}
@end
