#include "obgtk.h"

#include <objc/objc-api.h>
#include <string.h>
#include <stdlib.h>

#define DEBUG 1

gpointer
obgtk_signal_relay(GtkObject *object,
		   ObgtkRelayInfo data,
		   gint nargs,
		   GtkArg *args)
{
  id sigobj = nil;
  gpointer retval = 0;
  IMP callfunc;
  g_return_if_fail(object != NULL);
  g_return_if_fail(data != NULL);

  sigobj = gtk_object_get_data(object, "objc_id");

  if(!sigobj)
    sigobj = data->object;

#ifdef DEBUG
  printf("Call to method %s [%d] on %#x\n", sel_get_name(data->method),
		nargs, data->object);
#endif

  callfunc = objc_msg_lookup(data->object, data->method);

  if(callfunc)
    switch(nargs)
      {
      case 0:
	retval = callfunc(data->object, data->method,
				sigobj);
	break;
      case 1:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data);
	break;
      case 2:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data,
				args[1].d.pointer_data);
	break;
      case 3:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data,
				args[1].d.pointer_data,
				args[2].d.pointer_data);
	break;
      case 4:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data,
				args[1].d.pointer_data,
				args[2].d.pointer_data,
				args[3].d.pointer_data);
	break;
      case 5:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data,
				args[1].d.pointer_data,
				args[2].d.pointer_data,
				args[3].d.pointer_data,
				args[4].d.pointer_data);
	break;
      case 6:
	retval = callfunc(data->object, data->method,
				sigobj,
				args[0].d.pointer_data,
				args[1].d.pointer_data,
				args[2].d.pointer_data,
				args[3].d.pointer_data,
				args[4].d.pointer_data,
				args[5].d.pointer_data);
	break;
      default:
	[data->object error:"Can't handle %d arguments to an ObjC routine\n", nargs];
      }
  else
    [data->object error:"Couldn't find method %s on object.", data];
  return retval;
}

gint
obgtk_callback_relay(GtkObject *object,
		     gpointer data)
{
  id anobj = nil, sigobj = nil;
  gint retval;
  char *selname;
  IMP callfunc;
  SEL callsel;
  g_return_if_fail(object != NULL);
  g_return_if_fail(data != NULL);

  sigobj = gtk_object_get_data(object, "objc_id");
  selname = g_malloc(strlen(data) + 30);

  anobj = gtk_object_get_data(object, "obgtk_callback_relay");
#ifdef DEBUG
  printf("We got data %#x for %s\n", anobj, selname);
#endif

  if(!anobj)
    anobj = sigobj;

#ifdef DEBUG
  printf("Call to method %s on %#x\n", data, anobj);
#endif

  if(!anobj)
    {
      printf("We don't even have anobj for callback %s\n", data);
      return;
    }

  sprintf(selname, "%s:", (char *)data);
  callsel = sel_get_uid(selname);
  if(!callsel) {
    g_free(selname);
    [anobj error:"Couldn't find method %s on object.", data];
    return;
  }
  callfunc = objc_msg_lookup(anobj, callsel);

  if(callfunc)
    retval = (gint)callfunc(anobj, callsel, sigobj);
  else
    [anobj error:"Couldn't find method %s on object.", data];
  g_free(selname);
  return retval;
}

@implementation Gtk_Object
- init
{
  self = [super init];
  gtkobject = NULL;
  [self error:"Call to [Gtk_Object init] - probably not calling subclass initFooBlah\n"];
  return self;
}

- castGtkObject:(GtkObject *)castitem
{
  self = [super init];
  gtkobject = castitem;
/*  gtk_object_ref(gtkobject); */
  gtk_object_set_data(gtkobject, "objc_id", self);
  return [self connect:"destroy"];
}

- connect:(gchar *) signal_name
{
  return [self connectObj:signal_name :self];
}

- connectObj:(gchar *) signal_name
	    :(id) signalObject
{
  gchar *datid;
  int i;
  GString *foo;
  GtkSignalQuery *siginfo;
  ObgtkRelayInfo mydata;

  g_return_val_if_fail(signal_name != NULL, self);

  siginfo = gtk_signal_query(gtk_signal_lookup(signal_name,
					       gtkobject->klass->type));
  if(!siginfo)
    {
      g_warning("Couldn't lookup signale %s\n", signal_name);
      return self;
    }

  if(!strcmp(signal_name, "destroy"))
    foo = g_string_new("free");
  else
    foo = g_string_new(signal_name);

  mydata = g_new(struct _ObgtkRelayInfo, 1);
  mydata->object = signalObject;
  g_string_append_c(foo, ':'); /* For the "signalled object"
				  argument */
  for(i = 0; i < siginfo->nparams; i++)
    g_string_append_c(foo, ':'); /* For the various arguments Gtk passes
				    --these must be pointers-- */
  mydata->method = sel_get_uid(foo->str);
  gtk_signal_connect_interp(gtkobject,
			    signal_name,
			    (GtkCallbackMarshal) obgtk_signal_relay,
			    mydata,
			    g_free,
			    1);
  g_free(siginfo);
  g_string_free(foo, TRUE);
     
  return self;
}

- signal_connect:(gchar *) signal_name
      signalFunc:(GtkSignalFunc) signalfunc
	funcData:(gpointer) funcdata
{
  gtk_signal_connect(gtkobject, signal_name, signalfunc, funcdata);
  return self;
}

- free
{
  if(gtkobject) /* We need this here because gtkwidget has to do its
		   own destroy thingie */
    {
      gtk_object_remove_data(GTK_OBJECT(gtkobject), "objc_id");
/*  gtk_object_unref(gtkobject); */
      gtk_object_destroy(gtkobject);
    }
  return [super free];
}

- set_user_data:(gpointer) thedata
{
  gtk_object_set_user_data(gtkobject, thedata);
  return self;
}

- (gpointer)get_user_data
{
  return gtk_object_get_user_data(gtkobject);
}

- set_data:(const gchar *) key
	  :(gpointer) data
{
  gtk_object_set_data(gtkobject, key, data);
  return self;
}

- (gpointer)
  get_data:(const gchar *) key
{
  return gtk_object_get_data(gtkobject, key);
}

- ref
{
  gtk_object_ref(gtkobject);
  return self;
}

- unref
{
  gtk_object_unref(gtkobject);
  return self;
}
@end
