#ifndef OBGTK_CLIST_H
#define OBGTK_CLIST_H 1

#include <obgtk/obgtkContainer.h>
#include <gtk/gtkclist.h>

@interface Gtk_CList : Gtk_Container
{
@public
  GtkCList *gtkclist;
}

- castGtkCList:(GtkCList *) castitem;
- initWithCListInfo:(gint) ncolumns;
- initWithCListInfoTitles:(gint) ncolumns
		   Titles:(char **) titles;
- set_border:(GtkShadowType) border;
- set_selection_mode:(GtkSelectionMode) mode;
- set_policy:(GtkPolicyType) vscrollbar_policy
	    :(GtkPolicyType) hscrollbar_policy;
- freeze;
- thaw;
- set_column_title:(gint) column
		  :(gchar *) title;
- set_column_widget:(gint) column
		   :(Gtk_Widget *) widget;
- set_column_justification:(gint) column
			  :(GtkJustification) justification;
- set_column_width:(gint) column
		  :(gint) width;
- set_row_height:(gint) height;
- moveto:(gint) row
	:(gint) column
	:(gfloat) row_align
	:(gfloat) col_align;
- set_text:(gint) row
	  :(gint) column
	  :(gchar *) text;
- set_pixmap:(gint) row
	    :(gint) column
	    :(GdkPixmap *) pixmap
	    :(GdkBitmap *) mask;
- set_pixtext:(gint) row
	     :(gint) column
	     :(gchar *) text
	     :(guint8) spacing
	     :(GdkPixmap *) pixmap
	     :(GdkBitmap *) mask;
- set_foreground:(gint) row
		:(GdkColor *) color;
- set_background:(gint) row
		:(GdkColor *) color;
- set_shift:(gint) row
	   :(gint) column
	   :(gint) vertical
	   :(gint) horizontal;
- (gint)appendCListRow:(gchar **) text;
- insertCListRow:(gchar **) text
		:(gint) row;
- remove:(gint) row;
- set_row_data:(gint) row
	      :(gpointer) data;
- (gpointer) get_row_data:(gint) row;
- select_row:(gint) row
	    :(gint) column;
- unselect_row:(gint) row
	      :(gint) column;
- clear;
@end

#endif /* OBGTK_CLIST_H */
