#include <stdio.h>
#include <gtk/gtk.h>
#include "gnome.h"
#include "gnome-desktop.h"

void test (char *);
GtkWidget *main_window;
GnomePropertyConfigurator *display_config;

void
load_configurators (void)
{
	background_setup (main_window);
}

void
configurators_setup (void)
{
	/* Load the external configurators */
	load_configurators ();

	/* Then, start up the internal configurators */
}

int
gnome_config_load_int (char *str)
{
	return 0;
}

void
register_extension (GtkWidget *title_widget, GtkWidget *content_widget,
		    int (*callback)(GnomePropertyRequest r))
{
	gnome_property_configurator_register (display_config, title_widget, content_widget, callback);
}

GtkWidget *
get_monitor_preview_widget (GtkWidget *window)
{
	GtkWidget *pwid;
	GdkPixmap *pixmap, *mask;
	GtkStyle  *style;
	char *f;
	
	style = gtk_widget_get_style (window);
	f = gnome_datadir_file ("pixmaps/monitor.xpm");
	/* FIXME if f is 0, alert () */
	pixmap = gdk_pixmap_create_from_xpm (window->window, &mask, &style->bg [GTK_STATE_NORMAL], f);
	free (f);

	pwid = gtk_pixmap_new (pixmap, mask);
	gtk_widget_show (pwid);

	return pwid;
}

void
display_properties_setup (void)
{
	main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_show (main_window);
	display_config = gnome_property_configurator_new ();
	gtk_container_add (GTK_CONTAINER(main_window), display_config->notebook);
	gtk_widget_show (display_config->notebook);
}

int
main (int argc, char *argv [])
{
	gtk_init (&argc, &argv);
	gnome_init (&argc, &argv);
	
	gtk_widget_set_default_visual(gtk_preview_get_visual());
	gtk_widget_set_default_colormap(gtk_preview_get_cmap());
	display_properties_setup ();
	configurators_setup ();
#if 0
	{
		GtkWidget *window;
		GtkWidget *button;

		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_widget_show(window);

		button = gtk_button_new();
		gtk_widget_set_usize(button, 50, 20);
		gtk_widget_set_uposition(button, 10, 10);
		gtk_container_add(GTK_CONTAINER(window), button);
		gtk_widget_show(button);

		button = gtk_button_new();
		gtk_widget_set_usize(button, 50, 20);
		gtk_widget_set_uposition(button, 20, 20);
		gtk_container_add(GTK_CONTAINER(window), button);
		gtk_widget_show(button);
	}
#endif
	
	gtk_main ();
	gnome_property_configurator_destroy (display_config);
	return 0;
}

void
test (char *msg)
{
	GtkWidget *frame = gtk_frame_new ("Background-frame");
	GtkWidget *label = gtk_label_new (msg);

	gtk_widget_show (label);
	gtk_container_border_width (GTK_CONTAINER(frame), 10);
	gtk_widget_set_usize (frame, 200, 150);
	gtk_container_add (GTK_CONTAINER(frame), gtk_label_new ("testing"));
	
	register_extension (label, frame, NULL);
}

