/* valaversion.c generated by valac, the Vala compiler
 * generated from valaversion.vala, do not modify */

/* valaversion.vala
 *
 * Copyright (C) 2018  Rico Tzschichholz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Rico Tzschichholz <ricotz@ubuntu.com>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

/**
 * Returns the major version number of the vala library.
 *
 * This function is in the library, so it represents the GTK+
 * library your code is running against.
 *
 * @return the major version number of the vala library
 */
guint
vala_get_major_version (void)
{
	guint result;
	result = (guint) VALA_MAJOR_VERSION;
	return result;
}

/**
 * Returns the minor version number of the vala library.
 *
 * This function is in the library, so it represents the vala
 * library your code is are running against.
 *
 * @return the minor version number of the vala library
 */
guint
vala_get_minor_version (void)
{
	guint result;
	result = (guint) VALA_MINOR_VERSION;
	return result;
}

/**
 * Returns the micro version number of the vala library.
 *
 * This function is in the library, so it represents the vala
 * library your code is running against.
 *
 * @return the micro version number of the vala library
 */
guint
vala_get_micro_version (void)
{
	guint result;
	result = (guint) VALA_MICRO_VERSION;
	return result;
}

/**
 * Returns the full build-version string of the vala library.
 *
 * This function is in the library, so it represents the vala
 * library your code is running against.
 *
 * @return the full build-version string of the vala library
 */
const gchar*
vala_get_build_version (void)
{
	const gchar* result;
	result = VALA_BUILD_VERSION;
	return result;
}

/**
 * Checks that the vala library in use is compatible with the given version.
 *
 * This function is in the library, so it represents the vala
 * library your code is running against.
 *
 * @param required_major the required major version
 * @param required_minor the required minor version
 * @param required_micro the required micro version
 * @return null if the vala library is compatible with the given version,
 * or a string describing the version mismatch.
 */
const gchar*
vala_check_version (guint required_major,
                    guint required_minor,
                    guint required_micro)
{
	guint effective_micro = 0U;
	guint required_effective_micro = 0U;
	const gchar* result;
	effective_micro = (guint) ((100 * VALA_MINOR_VERSION) + VALA_MICRO_VERSION);
	required_effective_micro = (100 * required_minor) + required_micro;
	if (required_major > ((guint) VALA_MAJOR_VERSION)) {
		result = "vala version too old (major mismatch)";
		return result;
	}
	if (required_effective_micro > effective_micro) {
		result = "vala version too old (micro mismatch)";
		return result;
	}
	result = NULL;
	return result;
}

