/* valapropertyaccessor.c generated by valac, the Vala compiler
 * generated from valapropertyaccessor.vala, do not modify */

/* valapropertyaccessor.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaPropertyAccessorPrivate {
	gboolean _readable;
	gboolean _writable;
	gboolean _construction;
	gboolean _automatic_body;
	ValaParameter* _value_parameter;
	ValaDataType* _value_type;
};

static gint ValaPropertyAccessor_private_offset;
static gpointer vala_property_accessor_parent_class = NULL;

static void vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                            ValaDataType* value);
static void vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                          gboolean value);
static void vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                              gboolean value);
static void vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                                gboolean value);
static void vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                                 ValaParameter* value);
static void vala_property_accessor_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_property_accessor_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static void vala_property_accessor_finalize (ValaCodeNode * obj);
static GType vala_property_accessor_get_type_once (void);

static inline gpointer
vala_property_accessor_get_instance_private (ValaPropertyAccessor* self)
{
	return G_STRUCT_MEMBER_P (self, ValaPropertyAccessor_private_offset);
}

ValaProperty*
vala_property_accessor_get_prop (ValaPropertyAccessor* self)
{
	ValaProperty* result;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	result = VALA_IS_PROPERTY (_tmp1_) ? ((ValaProperty*) _tmp1_) : NULL;
	return result;
}

ValaDataType*
vala_property_accessor_get_value_type (ValaPropertyAccessor* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_property_accessor_set_value_type (ValaPropertyAccessor* self,
                                       ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_type);
	self->priv->_value_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_value_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}

gboolean
vala_property_accessor_get_readable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readable;
	return result;
}

static void
vala_property_accessor_set_readable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_readable = value;
}

gboolean
vala_property_accessor_get_writable (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_writable;
	return result;
}

static void
vala_property_accessor_set_writable (ValaPropertyAccessor* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_writable = value;
}

gboolean
vala_property_accessor_get_construction (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_construction;
	return result;
}

static void
vala_property_accessor_set_construction (ValaPropertyAccessor* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_construction = value;
}

gboolean
vala_property_accessor_get_automatic_body (ValaPropertyAccessor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic_body;
	return result;
}

static void
vala_property_accessor_set_automatic_body (ValaPropertyAccessor* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_automatic_body = value;
}

static gboolean
vala_property_accessor_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaPropertyAccessor* self;
	gboolean _tmp0_;
	self = (ValaPropertyAccessor*) base;
	_tmp0_ = self->priv->_readable;
	result = _tmp0_;
	return result;
}

ValaParameter*
vala_property_accessor_get_value_parameter (ValaPropertyAccessor* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value_parameter;
	result = _tmp0_;
	return result;
}

static void
vala_property_accessor_set_value_parameter (ValaPropertyAccessor* self,
                                            ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	self->priv->_value_parameter = _tmp0_;
}

/**
 * Creates a new property accessor.
 *
 * @param readable           true if get accessor, false otherwise
 * @param writable           true if set accessor, false otherwise
 * @param construction       true if construct accessor, false otherwise
 * @param body               accessor body
 * @param source_reference   reference to source code
 * @return                   newly created property accessor
 */
ValaPropertyAccessor*
vala_property_accessor_construct (GType object_type,
                                  gboolean readable,
                                  gboolean writable,
                                  gboolean construction,
                                  ValaDataType* value_type,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference,
                                  ValaComment* comment)
{
	ValaPropertyAccessor* self = NULL;
	self = (ValaPropertyAccessor*) vala_subroutine_construct (object_type, NULL, source_reference, comment);
	vala_property_accessor_set_readable (self, readable);
	vala_property_accessor_set_writable (self, writable);
	vala_property_accessor_set_construction (self, construction);
	vala_property_accessor_set_value_type (self, value_type);
	vala_subroutine_set_body ((ValaSubroutine*) self, body);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaPropertyAccessor*
vala_property_accessor_new (gboolean readable,
                            gboolean writable,
                            gboolean construction,
                            ValaDataType* value_type,
                            ValaBlock* body,
                            ValaSourceReference* source_reference,
                            ValaComment* comment)
{
	return vala_property_accessor_construct (VALA_TYPE_PROPERTY_ACCESSOR, readable, writable, construction, value_type, body, source_reference, comment);
}

static void
vala_property_accessor_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property_accessor (visitor, self);
}

static void
vala_property_accessor_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaLocalVariable* _tmp2_;
	ValaLocalVariable* _tmp3_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaLocalVariable* _tmp4_;
		ValaLocalVariable* _tmp5_;
		_tmp4_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		_tmp8_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

/**
 * Get the method representing this property accessor
 * @return   null if the accessor is neither readable nor writable
 */
ValaMethod*
vala_property_accessor_get_method (ValaPropertyAccessor* self)
{
	ValaMethod* m = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp46_;
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	m = NULL;
	_tmp0_ = self->priv->_readable;
	if (_tmp0_) {
		ValaProperty* _tmp1_;
		ValaProperty* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaComment* _tmp11_;
		ValaComment* _tmp12_;
		ValaMethod* _tmp13_;
		ValaMethod* _tmp14_;
		ValaProperty* _tmp15_;
		ValaProperty* _tmp16_;
		ValaMethod* _tmp17_;
		ValaProperty* _tmp18_;
		ValaProperty* _tmp19_;
		ValaMethod* _tmp20_;
		ValaProperty* _tmp21_;
		ValaProperty* _tmp22_;
		ValaMethod* _tmp23_;
		ValaProperty* _tmp24_;
		ValaProperty* _tmp25_;
		_tmp1_ = vala_property_accessor_get_prop (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("get_%s", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_property_accessor_get_value_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_symbol_get_comment ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_method_new (_tmp6_, _tmp8_, _tmp10_, _tmp12_);
		_vala_code_node_unref0 (m);
		m = _tmp13_;
		_g_free0 (_tmp6_);
		_tmp14_ = m;
		_tmp15_ = vala_property_accessor_get_prop (self);
		_tmp16_ = _tmp15_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp14_, (ValaCodeNode*) _tmp16_, "CCode", "array_length");
		_tmp17_ = m;
		_tmp18_ = vala_property_accessor_get_prop (self);
		_tmp19_ = _tmp18_;
		vala_code_node_copy_attribute_string ((ValaCodeNode*) _tmp17_, (ValaCodeNode*) _tmp19_, "CCode", "array_length_type");
		_tmp20_ = m;
		_tmp21_ = vala_property_accessor_get_prop (self);
		_tmp22_ = _tmp21_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp20_, (ValaCodeNode*) _tmp22_, "CCode", "array_null_terminated");
		_tmp23_ = m;
		_tmp24_ = vala_property_accessor_get_prop (self);
		_tmp25_ = _tmp24_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp23_, (ValaCodeNode*) _tmp25_, "CCode", "delegate_target");
	} else {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_;
		_tmp27_ = self->priv->_writable;
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp28_;
			_tmp28_ = self->priv->_construction;
			_tmp26_ = _tmp28_;
		}
		if (_tmp26_) {
			ValaProperty* _tmp29_;
			ValaProperty* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaVoidType* _tmp35_;
			ValaVoidType* _tmp36_;
			ValaSourceReference* _tmp37_;
			ValaSourceReference* _tmp38_;
			ValaComment* _tmp39_;
			ValaComment* _tmp40_;
			ValaMethod* _tmp41_;
			ValaMethod* _tmp42_;
			ValaParameter* _tmp43_;
			ValaParameter* _tmp44_;
			ValaParameter* _tmp45_;
			_tmp29_ = vala_property_accessor_get_prop (self);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_symbol_get_name ((ValaSymbol*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup_printf ("set_%s", _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_void_type_new (NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_symbol_get_comment ((ValaSymbol*) self);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_method_new (_tmp34_, (ValaDataType*) _tmp36_, _tmp38_, _tmp40_);
			_vala_code_node_unref0 (m);
			m = _tmp41_;
			_vala_code_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp42_ = m;
			_tmp43_ = self->priv->_value_parameter;
			_tmp44_ = vala_parameter_copy (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_callable_add_parameter ((ValaCallable*) _tmp42_, _tmp45_);
			_vala_code_node_unref0 (_tmp45_);
		}
	}
	_tmp46_ = m;
	if (_tmp46_ != NULL) {
		ValaMethod* _tmp47_;
		ValaProperty* _tmp48_;
		ValaProperty* _tmp49_;
		ValaScope* _tmp50_;
		ValaScope* _tmp51_;
		ValaMethod* _tmp52_;
		ValaSymbolAccessibility _tmp53_;
		ValaSymbolAccessibility _tmp54_;
		ValaMethod* _tmp55_;
		ValaProperty* _tmp56_;
		ValaProperty* _tmp57_;
		ValaMemberBinding _tmp58_;
		ValaMemberBinding _tmp59_;
		ValaMethod* _tmp60_;
		ValaProperty* _tmp61_;
		ValaProperty* _tmp62_;
		gboolean _tmp63_;
		gboolean _tmp64_;
		ValaMethod* _tmp65_;
		ValaProperty* _tmp66_;
		ValaProperty* _tmp67_;
		gboolean _tmp68_;
		gboolean _tmp69_;
		ValaMethod* _tmp70_;
		ValaProperty* _tmp71_;
		ValaProperty* _tmp72_;
		ValaParameter* _tmp73_;
		ValaParameter* _tmp74_;
		ValaMethod* _tmp75_;
		ValaProperty* _tmp76_;
		ValaProperty* _tmp77_;
		_tmp47_ = m;
		_tmp48_ = vala_property_accessor_get_prop (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_symbol_get_owner ((ValaSymbol*) _tmp49_);
		_tmp51_ = _tmp50_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp47_, _tmp51_);
		_tmp52_ = m;
		_tmp53_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp54_ = _tmp53_;
		vala_symbol_set_access ((ValaSymbol*) _tmp52_, _tmp54_);
		_tmp55_ = m;
		_tmp56_ = vala_property_accessor_get_prop (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_property_get_binding (_tmp57_);
		_tmp59_ = _tmp58_;
		vala_method_set_binding (_tmp55_, _tmp59_);
		_tmp60_ = m;
		_tmp61_ = vala_property_accessor_get_prop (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_property_get_is_abstract (_tmp62_);
		_tmp64_ = _tmp63_;
		vala_method_set_is_abstract (_tmp60_, _tmp64_);
		_tmp65_ = m;
		_tmp66_ = vala_property_accessor_get_prop (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_property_get_is_virtual (_tmp67_);
		_tmp69_ = _tmp68_;
		vala_method_set_is_virtual (_tmp65_, _tmp69_);
		_tmp70_ = m;
		_tmp71_ = vala_property_accessor_get_prop (self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_property_get_this_parameter (_tmp72_);
		_tmp74_ = _tmp73_;
		vala_method_set_this_parameter (_tmp70_, _tmp74_);
		_tmp75_ = m;
		_tmp76_ = vala_property_accessor_get_prop (self);
		_tmp77_ = _tmp76_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp75_, (ValaCodeNode*) _tmp77_, "GIR", "visible");
	}
	result = m;
	return result;
}

static gboolean
vala_property_accessor_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaPropertyAccessor * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaProfile _tmp36_;
	ValaProfile _tmp37_;
	ValaProperty* _tmp102_;
	ValaProperty* _tmp103_;
	ValaSourceFileType _tmp104_;
	ValaSourceFileType _tmp105_;
	gboolean _tmp161_ = FALSE;
	gboolean _tmp162_ = FALSE;
	gboolean _tmp163_ = FALSE;
	ValaProperty* _tmp164_;
	ValaProperty* _tmp165_;
	gboolean _tmp166_;
	gboolean _tmp167_;
	gboolean _tmp184_ = FALSE;
	ValaProfile _tmp185_;
	ValaProfile _tmp186_;
	gboolean _tmp213_ = FALSE;
	ValaBlock* _tmp214_;
	ValaBlock* _tmp215_;
	ValaBlock* _tmp226_;
	ValaBlock* _tmp227_;
	gboolean _tmp241_ = FALSE;
	ValaBlock* _tmp242_;
	ValaBlock* _tmp243_;
	ValaSemanticAnalyzer* _tmp270_;
	ValaSemanticAnalyzer* _tmp271_;
	ValaSymbol* _tmp272_;
	gboolean _tmp273_;
	gboolean _tmp274_;
	gboolean result;
	self = (ValaPropertyAccessor*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_property_accessor_get_value_type (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_code_context_get_analyzer (context);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_semantic_analyzer_get_current_symbol (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (_tmp9_);
	old_symbol = _tmp10_;
	_tmp11_ = vala_code_context_get_analyzer (context);
	_tmp12_ = _tmp11_;
	vala_semantic_analyzer_set_current_symbol (_tmp12_, (ValaSymbol*) self);
	_tmp14_ = self->priv->_writable;
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_;
		_tmp15_ = self->priv->_construction;
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		ValaProperty* _tmp23_;
		ValaProperty* _tmp24_;
		ValaParameter* _tmp25_;
		ValaProperty* _tmp26_;
		ValaProperty* _tmp27_;
		ValaParameter* _tmp28_;
		ValaProperty* _tmp29_;
		ValaProperty* _tmp30_;
		ValaParameter* _tmp31_;
		ValaProperty* _tmp32_;
		ValaProperty* _tmp33_;
		_tmp16_ = vala_property_accessor_get_value_type (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_parameter_new ("value", _tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_property_accessor_set_value_parameter (self, _tmp21_);
		_vala_code_node_unref0 (_tmp21_);
		_tmp22_ = self->priv->_value_parameter;
		_tmp23_ = vala_property_accessor_get_prop (self);
		_tmp24_ = _tmp23_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp22_, (ValaCodeNode*) _tmp24_, "CCode", "array_length");
		_tmp25_ = self->priv->_value_parameter;
		_tmp26_ = vala_property_accessor_get_prop (self);
		_tmp27_ = _tmp26_;
		vala_code_node_copy_attribute_string ((ValaCodeNode*) _tmp25_, (ValaCodeNode*) _tmp27_, "CCode", "array_length_type");
		_tmp28_ = self->priv->_value_parameter;
		_tmp29_ = vala_property_accessor_get_prop (self);
		_tmp30_ = _tmp29_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp28_, (ValaCodeNode*) _tmp30_, "CCode", "array_null_terminated");
		_tmp31_ = self->priv->_value_parameter;
		_tmp32_ = vala_property_accessor_get_prop (self);
		_tmp33_ = _tmp32_;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp31_, (ValaCodeNode*) _tmp33_, "CCode", "delegate_target");
	}
	_tmp36_ = vala_code_context_get_profile (context);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == VALA_PROFILE_GOBJECT) {
		gboolean _tmp38_;
		_tmp38_ = self->priv->_readable;
		_tmp35_ = _tmp38_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ValaProperty* _tmp39_;
		ValaProperty* _tmp40_;
		ValaSymbol* _tmp41_;
		ValaSymbol* _tmp42_;
		ValaSemanticAnalyzer* _tmp43_;
		ValaSemanticAnalyzer* _tmp44_;
		ValaClass* _tmp45_;
		_tmp39_ = vala_property_accessor_get_prop (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_context_get_analyzer (context);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_->object_type;
		_tmp34_ = vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp45_);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		ValaProperty* _tmp46_;
		ValaProperty* _tmp47_;
		ValaAttribute* _tmp48_;
		_tmp46_ = vala_property_accessor_get_prop (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp47_, "NoAccessorMethod");
		if (_tmp48_ != NULL) {
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			_tmp49_ = vala_property_accessor_get_value_type (self);
			_tmp50_ = _tmp49_;
			if (vala_data_type_is_real_struct_type (_tmp50_)) {
				gboolean _tmp51_ = FALSE;
				ValaSourceReference* _tmp52_;
				ValaSourceReference* _tmp53_;
				_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp53_ = _tmp52_;
				if (_tmp53_ == NULL) {
					_tmp51_ = TRUE;
				} else {
					ValaSourceReference* _tmp54_;
					ValaSourceReference* _tmp55_;
					ValaSourceFile* _tmp56_;
					ValaSourceFile* _tmp57_;
					_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_source_reference_get_file (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp51_ = _tmp57_ == NULL;
				}
				if (_tmp51_) {
				} else {
					gboolean _tmp58_ = FALSE;
					ValaDataType* _tmp59_;
					ValaDataType* _tmp60_;
					gboolean _tmp61_;
					gboolean _tmp62_;
					_tmp59_ = vala_property_accessor_get_value_type (self);
					_tmp60_ = _tmp59_;
					_tmp61_ = vala_data_type_get_value_owned (_tmp60_);
					_tmp62_ = _tmp61_;
					if (!_tmp62_) {
						ValaSourceReference* _tmp63_;
						ValaSourceReference* _tmp64_;
						ValaSourceFile* _tmp65_;
						ValaSourceFile* _tmp66_;
						ValaSourceFileType _tmp67_;
						ValaSourceFileType _tmp68_;
						_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp64_ = _tmp63_;
						_tmp65_ = vala_source_reference_get_file (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = vala_source_file_get_file_type (_tmp66_);
						_tmp68_ = _tmp67_;
						_tmp58_ = _tmp68_ == VALA_SOURCE_FILE_TYPE_SOURCE;
					} else {
						_tmp58_ = FALSE;
					}
					if (_tmp58_) {
						ValaSourceReference* _tmp69_;
						ValaSourceReference* _tmp70_;
						ValaProperty* _tmp71_;
						ValaProperty* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp70_ = _tmp69_;
						_tmp71_ = vala_property_accessor_get_prop (self);
						_tmp72_ = _tmp71_;
						_tmp73_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp72_);
						_tmp74_ = _tmp73_;
						vala_report_error (_tmp70_, "unowned return value for getter of property `%s' not supported without" \
" accessor", _tmp74_);
						_g_free0 (_tmp74_);
					}
				}
			} else {
				gboolean _tmp75_ = FALSE;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				gboolean _tmp78_;
				gboolean _tmp79_;
				_tmp76_ = vala_property_accessor_get_value_type (self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_value_owned (_tmp77_);
				_tmp79_ = _tmp78_;
				if (_tmp79_) {
					gboolean _tmp80_ = FALSE;
					ValaSourceReference* _tmp81_;
					ValaSourceReference* _tmp82_;
					_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp82_ = _tmp81_;
					if (_tmp82_ == NULL) {
						_tmp80_ = TRUE;
					} else {
						ValaSourceReference* _tmp83_;
						ValaSourceReference* _tmp84_;
						ValaSourceFile* _tmp85_;
						ValaSourceFile* _tmp86_;
						_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp84_ = _tmp83_;
						_tmp85_ = vala_source_reference_get_file (_tmp84_);
						_tmp86_ = _tmp85_;
						_tmp80_ = _tmp86_ == NULL;
					}
					_tmp75_ = _tmp80_;
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					gboolean _tmp87_ = FALSE;
					gboolean _tmp88_ = FALSE;
					ValaDataType* _tmp89_;
					ValaDataType* _tmp90_;
					_tmp89_ = vala_property_accessor_get_value_type (self);
					_tmp90_ = _tmp89_;
					if (VALA_IS_DELEGATE_TYPE (_tmp90_)) {
						_tmp88_ = TRUE;
					} else {
						ValaDataType* _tmp91_;
						ValaDataType* _tmp92_;
						_tmp91_ = vala_property_accessor_get_value_type (self);
						_tmp92_ = _tmp91_;
						_tmp88_ = VALA_IS_POINTER_TYPE (_tmp92_);
					}
					if (_tmp88_) {
						_tmp87_ = TRUE;
					} else {
						gboolean _tmp93_ = FALSE;
						ValaDataType* _tmp94_;
						ValaDataType* _tmp95_;
						_tmp94_ = vala_property_accessor_get_value_type (self);
						_tmp95_ = _tmp94_;
						if (VALA_IS_VALUE_TYPE (_tmp95_)) {
							ValaDataType* _tmp96_;
							ValaDataType* _tmp97_;
							gboolean _tmp98_;
							gboolean _tmp99_;
							_tmp96_ = vala_property_accessor_get_value_type (self);
							_tmp97_ = _tmp96_;
							_tmp98_ = vala_data_type_get_nullable (_tmp97_);
							_tmp99_ = _tmp98_;
							_tmp93_ = !_tmp99_;
						} else {
							_tmp93_ = FALSE;
						}
						_tmp87_ = _tmp93_;
					}
					if (_tmp87_) {
						ValaDataType* _tmp100_;
						ValaDataType* _tmp101_;
						_tmp100_ = vala_property_accessor_get_value_type (self);
						_tmp101_ = _tmp100_;
						vala_data_type_set_value_owned (_tmp101_, FALSE);
					}
				}
			}
		}
	}
	_tmp102_ = vala_property_accessor_get_prop (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_symbol_get_source_type ((ValaSymbol*) _tmp103_);
	_tmp105_ = _tmp104_;
	if (_tmp105_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp106_ = FALSE;
		gboolean _tmp107_ = FALSE;
		ValaBlock* _tmp108_;
		ValaBlock* _tmp109_;
		_tmp108_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp109_ = _tmp108_;
		if (_tmp109_ == NULL) {
			ValaProperty* _tmp110_;
			ValaProperty* _tmp111_;
			gboolean _tmp112_;
			gboolean _tmp113_;
			_tmp110_ = vala_property_accessor_get_prop (self);
			_tmp111_ = _tmp110_;
			_tmp112_ = vala_property_get_interface_only (_tmp111_);
			_tmp113_ = _tmp112_;
			_tmp107_ = !_tmp113_;
		} else {
			_tmp107_ = FALSE;
		}
		if (_tmp107_) {
			ValaProperty* _tmp114_;
			ValaProperty* _tmp115_;
			gboolean _tmp116_;
			gboolean _tmp117_;
			_tmp114_ = vala_property_accessor_get_prop (self);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_property_get_is_abstract (_tmp115_);
			_tmp117_ = _tmp116_;
			_tmp106_ = !_tmp117_;
		} else {
			_tmp106_ = FALSE;
		}
		if (_tmp106_) {
			ValaSourceReference* _tmp118_;
			ValaSourceReference* _tmp119_;
			ValaBlock* _tmp120_;
			ValaBlock* _tmp121_;
			ValaMemberAccess* ma = NULL;
			ValaProperty* _tmp122_;
			ValaProperty* _tmp123_;
			const gchar* _tmp124_;
			const gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			ValaMemberAccess* _tmp130_;
			ValaMemberAccess* _tmp131_;
			gboolean _tmp132_;
			vala_property_accessor_set_automatic_body (self, TRUE);
			_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp119_ = _tmp118_;
			_tmp120_ = vala_block_new (_tmp119_);
			_tmp121_ = _tmp120_;
			vala_subroutine_set_body ((ValaSubroutine*) self, _tmp121_);
			_vala_code_node_unref0 (_tmp121_);
			_tmp122_ = vala_property_accessor_get_prop (self);
			_tmp123_ = _tmp122_;
			_tmp124_ = vala_symbol_get_name ((ValaSymbol*) _tmp123_);
			_tmp125_ = _tmp124_;
			_tmp126_ = g_strdup_printf ("_%s", _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			_tmp130_ = vala_member_access_new_simple (_tmp127_, _tmp129_);
			_tmp131_ = _tmp130_;
			_g_free0 (_tmp127_);
			ma = _tmp131_;
			_tmp132_ = self->priv->_readable;
			if (_tmp132_) {
				ValaBlock* _tmp133_;
				ValaBlock* _tmp134_;
				ValaMemberAccess* _tmp135_;
				ValaSourceReference* _tmp136_;
				ValaSourceReference* _tmp137_;
				ValaReturnStatement* _tmp138_;
				ValaReturnStatement* _tmp139_;
				_tmp133_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp134_ = _tmp133_;
				_tmp135_ = ma;
				_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_return_statement_new ((ValaExpression*) _tmp135_, _tmp137_);
				_tmp139_ = _tmp138_;
				vala_block_add_statement (_tmp134_, (ValaStatement*) _tmp139_);
				_vala_code_node_unref0 (_tmp139_);
			} else {
				ValaExpression* value = NULL;
				ValaSourceReference* _tmp140_;
				ValaSourceReference* _tmp141_;
				ValaMemberAccess* _tmp142_;
				ValaDataType* _tmp143_;
				ValaDataType* _tmp144_;
				gboolean _tmp145_;
				gboolean _tmp146_;
				ValaAssignment* assignment = NULL;
				ValaMemberAccess* _tmp151_;
				ValaExpression* _tmp152_;
				ValaSourceReference* _tmp153_;
				ValaSourceReference* _tmp154_;
				ValaAssignment* _tmp155_;
				ValaBlock* _tmp156_;
				ValaBlock* _tmp157_;
				ValaAssignment* _tmp158_;
				ValaExpressionStatement* _tmp159_;
				ValaExpressionStatement* _tmp160_;
				_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_member_access_new_simple ("value", _tmp141_);
				value = (ValaExpression*) _tmp142_;
				_tmp143_ = vala_property_accessor_get_value_type (self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_data_type_get_value_owned (_tmp144_);
				_tmp146_ = _tmp145_;
				if (_tmp146_) {
					ValaExpression* _tmp147_;
					ValaSourceReference* _tmp148_;
					ValaSourceReference* _tmp149_;
					ValaReferenceTransferExpression* _tmp150_;
					_tmp147_ = value;
					_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp149_ = _tmp148_;
					_tmp150_ = vala_reference_transfer_expression_new (_tmp147_, _tmp149_);
					_vala_code_node_unref0 (value);
					value = (ValaExpression*) _tmp150_;
				}
				_tmp151_ = ma;
				_tmp152_ = value;
				_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_assignment_new ((ValaExpression*) _tmp151_, _tmp152_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp154_);
				assignment = _tmp155_;
				_tmp156_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = assignment;
				_tmp159_ = vala_expression_statement_new ((ValaExpression*) _tmp158_, NULL);
				_tmp160_ = _tmp159_;
				vala_block_add_statement (_tmp157_, (ValaStatement*) _tmp160_);
				_vala_code_node_unref0 (_tmp160_);
				_vala_code_node_unref0 (assignment);
				_vala_code_node_unref0 (value);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp164_ = vala_property_accessor_get_prop (self);
	_tmp165_ = _tmp164_;
	_tmp166_ = vala_property_get_is_abstract (_tmp165_);
	_tmp167_ = _tmp166_;
	if (_tmp167_) {
		_tmp163_ = TRUE;
	} else {
		ValaProperty* _tmp168_;
		ValaProperty* _tmp169_;
		gboolean _tmp170_;
		gboolean _tmp171_;
		_tmp168_ = vala_property_accessor_get_prop (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_property_get_is_virtual (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp163_ = _tmp171_;
	}
	if (_tmp163_) {
		_tmp162_ = TRUE;
	} else {
		ValaProperty* _tmp172_;
		ValaProperty* _tmp173_;
		gboolean _tmp174_;
		gboolean _tmp175_;
		_tmp172_ = vala_property_accessor_get_prop (self);
		_tmp173_ = _tmp172_;
		_tmp174_ = vala_property_get_overrides (_tmp173_);
		_tmp175_ = _tmp174_;
		_tmp162_ = _tmp175_;
	}
	if (_tmp162_) {
		ValaSymbolAccessibility _tmp176_;
		ValaSymbolAccessibility _tmp177_;
		_tmp176_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp177_ = _tmp176_;
		_tmp161_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	} else {
		_tmp161_ = FALSE;
	}
	if (_tmp161_) {
		ValaSourceReference* _tmp178_;
		ValaSourceReference* _tmp179_;
		ValaProperty* _tmp180_;
		ValaProperty* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_property_accessor_get_prop (self);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp181_);
		_tmp183_ = _tmp182_;
		vala_report_error (_tmp179_, "Property `%s' with private accessor cannot be marked as abstract, virt" \
"ual or override", _tmp183_);
		_g_free0 (_tmp183_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp185_ = vala_code_context_get_profile (context);
	_tmp186_ = _tmp185_;
	if (_tmp186_ == VALA_PROFILE_POSIX) {
		gboolean _tmp187_;
		_tmp187_ = self->priv->_construction;
		_tmp184_ = _tmp187_;
	} else {
		_tmp184_ = FALSE;
	}
	if (_tmp184_) {
		ValaSourceReference* _tmp188_;
		ValaSourceReference* _tmp189_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp189_ = _tmp188_;
		vala_report_error (_tmp189_, "`construct' is not supported in POSIX profile");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	} else {
		gboolean _tmp190_ = FALSE;
		gboolean _tmp191_;
		_tmp191_ = self->priv->_construction;
		if (_tmp191_) {
			ValaProperty* _tmp192_;
			ValaProperty* _tmp193_;
			ValaSymbol* _tmp194_;
			ValaSymbol* _tmp195_;
			ValaSemanticAnalyzer* _tmp196_;
			ValaSemanticAnalyzer* _tmp197_;
			ValaClass* _tmp198_;
			_tmp192_ = vala_property_accessor_get_prop (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp193_);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_context_get_analyzer (context);
			_tmp197_ = _tmp196_;
			_tmp198_ = _tmp197_->object_type;
			_tmp190_ = !vala_typesymbol_is_subtype_of (G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), (ValaTypeSymbol*) _tmp198_);
		} else {
			_tmp190_ = FALSE;
		}
		if (_tmp190_) {
			ValaSourceReference* _tmp199_;
			ValaSourceReference* _tmp200_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp200_ = _tmp199_;
			vala_report_error (_tmp200_, "construct properties require `GLib.Object'");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			return result;
		} else {
			gboolean _tmp201_ = FALSE;
			gboolean _tmp202_;
			_tmp202_ = self->priv->_construction;
			if (_tmp202_) {
				ValaSemanticAnalyzer* _tmp203_;
				ValaSemanticAnalyzer* _tmp204_;
				ValaProperty* _tmp205_;
				ValaProperty* _tmp206_;
				_tmp203_ = vala_code_context_get_analyzer (context);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_property_accessor_get_prop (self);
				_tmp206_ = _tmp205_;
				_tmp201_ = !vala_semantic_analyzer_is_gobject_property (_tmp204_, _tmp206_);
			} else {
				_tmp201_ = FALSE;
			}
			if (_tmp201_) {
				gboolean _tmp207_;
				gboolean _tmp208_;
				_tmp207_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp208_ = _tmp207_;
				if (_tmp208_) {
					ValaSourceReference* _tmp209_;
					ValaSourceReference* _tmp210_;
					_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp210_ = _tmp209_;
					vala_report_warning (_tmp210_, "construct properties not supported for specified property type");
				} else {
					ValaSourceReference* _tmp211_;
					ValaSourceReference* _tmp212_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp212_ = _tmp211_;
					vala_report_error (_tmp212_, "construct properties not supported for specified property type");
					result = FALSE;
					_vala_code_node_unref0 (old_symbol);
					return result;
				}
			}
		}
	}
	_tmp214_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp215_ = _tmp214_;
	if (_tmp215_ != NULL) {
		ValaProperty* _tmp216_;
		ValaProperty* _tmp217_;
		gboolean _tmp218_;
		gboolean _tmp219_;
		_tmp216_ = vala_property_accessor_get_prop (self);
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_property_get_is_abstract (_tmp217_);
		_tmp219_ = _tmp218_;
		_tmp213_ = _tmp219_;
	} else {
		_tmp213_ = FALSE;
	}
	if (_tmp213_) {
		ValaSourceReference* _tmp220_;
		ValaSourceReference* _tmp221_;
		ValaProperty* _tmp222_;
		ValaProperty* _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp221_ = _tmp220_;
		_tmp222_ = vala_property_accessor_get_prop (self);
		_tmp223_ = _tmp222_;
		_tmp224_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp223_);
		_tmp225_ = _tmp224_;
		vala_report_error (_tmp221_, "Accessor of abstract property `%s' cannot have body", _tmp225_);
		_g_free0 (_tmp225_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		return result;
	}
	_tmp226_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp227_ = _tmp226_;
	if (_tmp227_ != NULL) {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_;
		ValaBlock* _tmp239_;
		ValaBlock* _tmp240_;
		_tmp229_ = self->priv->_writable;
		if (_tmp229_) {
			_tmp228_ = TRUE;
		} else {
			gboolean _tmp230_;
			_tmp230_ = self->priv->_construction;
			_tmp228_ = _tmp230_;
		}
		if (_tmp228_) {
			ValaBlock* _tmp231_;
			ValaBlock* _tmp232_;
			ValaScope* _tmp233_;
			ValaScope* _tmp234_;
			ValaParameter* _tmp235_;
			const gchar* _tmp236_;
			const gchar* _tmp237_;
			ValaParameter* _tmp238_;
			_tmp231_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_symbol_get_scope ((ValaSymbol*) _tmp232_);
			_tmp234_ = _tmp233_;
			_tmp235_ = self->priv->_value_parameter;
			_tmp236_ = vala_symbol_get_name ((ValaSymbol*) _tmp235_);
			_tmp237_ = _tmp236_;
			_tmp238_ = self->priv->_value_parameter;
			vala_scope_add (_tmp234_, _tmp237_, (ValaSymbol*) _tmp238_);
		}
		_tmp239_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp240_ = _tmp239_;
		vala_code_node_check ((ValaCodeNode*) _tmp240_, context);
	}
	_tmp242_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp243_ = _tmp242_;
	if (_tmp243_ != NULL) {
		ValaBlock* _tmp244_;
		ValaBlock* _tmp245_;
		gboolean _tmp246_;
		gboolean _tmp247_;
		_tmp244_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_code_node_get_error ((ValaCodeNode*) _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp241_ = !_tmp247_;
	} else {
		_tmp241_ = FALSE;
	}
	if (_tmp241_) {
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp248_;
		ValaArrayList* _tmp249_;
		ValaBlock* _tmp250_;
		ValaBlock* _tmp251_;
		ValaArrayList* _tmp252_;
		_tmp248_ = g_direct_equal;
		_tmp249_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp248_);
		error_types = _tmp249_;
		_tmp250_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp251_ = _tmp250_;
		_tmp252_ = error_types;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp251_, (ValaCollection*) _tmp252_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp253_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp254_;
			gint _tmp255_;
			gint _tmp256_;
			gint _body_error_type_index = 0;
			_tmp253_ = error_types;
			_body_error_type_list = _tmp253_;
			_tmp254_ = _body_error_type_list;
			_tmp255_ = vala_collection_get_size ((ValaCollection*) _tmp254_);
			_tmp256_ = _tmp255_;
			_body_error_type_size = _tmp256_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp257_;
				gint _tmp258_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp259_;
				gpointer _tmp260_;
				ValaDataType* _tmp261_;
				gboolean _tmp262_;
				gboolean _tmp263_;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp257_ = _body_error_type_index;
				_tmp258_ = _body_error_type_size;
				if (!(_tmp257_ < _tmp258_)) {
					break;
				}
				_tmp259_ = _body_error_type_list;
				_tmp260_ = vala_list_get ((ValaList*) _tmp259_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp260_;
				_tmp261_ = body_error_type;
				_tmp262_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp261_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
				_tmp263_ = _tmp262_;
				if (!_tmp263_) {
					ValaDataType* _tmp264_;
					ValaSourceReference* _tmp265_;
					ValaSourceReference* _tmp266_;
					ValaDataType* _tmp267_;
					gchar* _tmp268_;
					gchar* _tmp269_;
					_tmp264_ = body_error_type;
					_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp264_);
					_tmp266_ = _tmp265_;
					_tmp267_ = body_error_type;
					_tmp268_ = vala_code_node_to_string ((ValaCodeNode*) _tmp267_);
					_tmp269_ = _tmp268_;
					vala_report_warning (_tmp266_, "unhandled error `%s'", _tmp269_);
					_g_free0 (_tmp269_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
		}
		_vala_iterable_unref0 (error_types);
	}
	_tmp270_ = vala_code_context_get_analyzer (context);
	_tmp271_ = _tmp270_;
	_tmp272_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp271_, _tmp272_);
	_tmp273_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp274_ = _tmp273_;
	result = !_tmp274_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_property_accessor_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaPropertyAccessor * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaPropertyAccessor*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_accessor_get_value_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_accessor_set_value_type (self, new_type);
	}
}

static void
vala_property_accessor_class_init (ValaPropertyAccessorClass * klass,
                                   gpointer klass_data)
{
	vala_property_accessor_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_accessor_finalize;
	g_type_class_adjust_private_offset (klass, &ValaPropertyAccessor_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_property_accessor_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_property_accessor_real_check;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_property_accessor_real_replace_type;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = (gboolean (*) (ValaSubroutine*)) vala_property_accessor_real_get_has_result;
}

static void
vala_property_accessor_instance_init (ValaPropertyAccessor * self,
                                      gpointer klass)
{
	self->priv = vala_property_accessor_get_instance_private (self);
}

static void
vala_property_accessor_finalize (ValaCodeNode * obj)
{
	ValaPropertyAccessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor);
	_vala_code_node_unref0 (self->priv->_value_parameter);
	_vala_code_node_unref0 (self->priv->_value_type);
	VALA_CODE_NODE_CLASS (vala_property_accessor_parent_class)->finalize (obj);
}

/**
 * Represents a get or set accessor of a property in the source code.
 */
static GType
vala_property_accessor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyAccessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_accessor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPropertyAccessor), 0, (GInstanceInitFunc) vala_property_accessor_instance_init, NULL };
	GType vala_property_accessor_type_id;
	vala_property_accessor_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaPropertyAccessor", &g_define_type_info, 0);
	ValaPropertyAccessor_private_offset = g_type_add_instance_private (vala_property_accessor_type_id, sizeof (ValaPropertyAccessorPrivate));
	return vala_property_accessor_type_id;
}

GType
vala_property_accessor_get_type (void)
{
	static volatile gsize vala_property_accessor_type_id__once = 0;
	if (g_once_init_enter (&vala_property_accessor_type_id__once)) {
		GType vala_property_accessor_type_id;
		vala_property_accessor_type_id = vala_property_accessor_get_type_once ();
		g_once_init_leave (&vala_property_accessor_type_id__once, vala_property_accessor_type_id);
	}
	return vala_property_accessor_type_id__once;
}

