// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Expression;
use crate::SortType;
use crate::Sorter;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GtkNumericSorter")]
    pub struct NumericSorter(Object<ffi::GtkNumericSorter, ffi::GtkNumericSorterClass>) @extends Sorter;

    match fn {
        type_ => || ffi::gtk_numeric_sorter_get_type(),
    }
}

impl NumericSorter {
    #[doc(alias = "gtk_numeric_sorter_new")]
    pub fn new(expression: Option<impl AsRef<Expression>>) -> NumericSorter {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_numeric_sorter_new(
                expression.as_ref().map(|p| p.as_ref()).to_glib_full(),
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`NumericSorter`] objects.
    ///
    /// This method returns an instance of [`NumericSorterBuilder`](crate::builders::NumericSorterBuilder) which can be used to create [`NumericSorter`] objects.
    pub fn builder() -> NumericSorterBuilder {
        NumericSorterBuilder::default()
    }

    #[doc(alias = "gtk_numeric_sorter_get_expression")]
    #[doc(alias = "get_expression")]
    pub fn expression(&self) -> Option<Expression> {
        unsafe {
            from_glib_none(ffi::gtk_numeric_sorter_get_expression(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_numeric_sorter_get_sort_order")]
    #[doc(alias = "get_sort_order")]
    pub fn sort_order(&self) -> SortType {
        unsafe {
            from_glib(ffi::gtk_numeric_sorter_get_sort_order(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_numeric_sorter_set_expression")]
    pub fn set_expression(&self, expression: Option<impl AsRef<Expression>>) {
        unsafe {
            ffi::gtk_numeric_sorter_set_expression(
                self.to_glib_none().0,
                expression.as_ref().map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_numeric_sorter_set_sort_order")]
    pub fn set_sort_order(&self, sort_order: SortType) {
        unsafe {
            ffi::gtk_numeric_sorter_set_sort_order(self.to_glib_none().0, sort_order.into_glib());
        }
    }

    #[doc(alias = "expression")]
    pub fn connect_expression_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_expression_trampoline<F: Fn(&NumericSorter) + 'static>(
            this: *mut ffi::GtkNumericSorter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::expression\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_expression_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "sort-order")]
    pub fn connect_sort_order_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_sort_order_trampoline<F: Fn(&NumericSorter) + 'static>(
            this: *mut ffi::GtkNumericSorter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::sort-order\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_sort_order_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for NumericSorter {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct NumericSorter object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`NumericSorter`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct NumericSorterBuilder {
    expression: Option<Expression>,
    sort_order: Option<SortType>,
}

impl NumericSorterBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`NumericSorterBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`NumericSorter`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> NumericSorter {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref expression) = self.expression {
            properties.push(("expression", expression));
        }
        if let Some(ref sort_order) = self.sort_order {
            properties.push(("sort-order", sort_order));
        }
        glib::Object::new::<NumericSorter>(&properties)
            .expect("Failed to create an instance of NumericSorter")
    }

    pub fn expression(mut self, expression: impl AsRef<Expression>) -> Self {
        self.expression = Some(expression.as_ref().clone());
        self
    }

    pub fn sort_order(mut self, sort_order: SortType) -> Self {
        self.sort_order = Some(sort_order);
        self
    }
}

impl fmt::Display for NumericSorter {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("NumericSorter")
    }
}
