/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp420_ = FALSE;
	ValaMethod* _tmp421_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp615_;
	ValaCCodeExpression* _tmp616_;
	gboolean _tmp617_ = FALSE;
	ValaMethod* _tmp618_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp646_ = FALSE;
	ValaMethod* _tmp647_;
	gboolean _tmp810_ = FALSE;
	ValaMethod* _tmp811_;
	ValaMethod* _tmp863_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1054_;
	ValaIterator* _tmp1055_;
	ValaIterator* _tmp1475_;
	gboolean _tmp1485_ = FALSE;
	gboolean _tmp1486_ = FALSE;
	ValaMethod* _tmp1487_;
	gboolean _tmp1608_ = FALSE;
	ValaDelegate* _tmp1609_;
	gboolean _tmp1705_ = FALSE;
	ValaMethod* _tmp1706_;
	gboolean _tmp1722_;
	gboolean _tmp1723_;
	gboolean _tmp1766_ = FALSE;
	ValaDelegate* _tmp1767_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1785_;
	ValaDataType* _tmp1786_;
	gboolean _tmp1787_ = FALSE;
	ValaDataType* _tmp1788_;
	ValaCCodeFunctionCall* _tmp1816_;
	ValaCCodeFunctionCall* _tmp1817_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1830_;
	ValaCCodeFunctionCall* _tmp1831_;
	ValaCCodeFunctionCall* _tmp1846_;
	gboolean _tmp1861_;
	gboolean _tmp1862_;
	gboolean _tmp1886_;
	gboolean _tmp1887_;
	gboolean _tmp1922_ = FALSE;
	gboolean _tmp1923_ = FALSE;
	ValaMethod* _tmp1924_;
	gboolean _tmp1962_ = FALSE;
	gboolean _tmp1963_ = FALSE;
	gboolean _tmp1964_ = FALSE;
	gboolean _tmp1965_ = FALSE;
	gboolean _tmp1966_ = FALSE;
	ValaMethod* _tmp1967_;
	gboolean _tmp1984_ = FALSE;
	gboolean _tmp1985_ = FALSE;
	ValaMethod* _tmp1986_;
	ValaMethod* _tmp2005_;
	gboolean _tmp2115_ = FALSE;
	ValaCodeNode* _tmp2116_;
	ValaCodeNode* _tmp2117_;
	ValaList* _tmp2217_;
	ValaIterator* _tmp2218_;
	gboolean _tmp2371_ = FALSE;
	gboolean _tmp2372_ = FALSE;
	ValaMethod* _tmp2373_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			ValaList* _tmp383_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_tmp383_ = _vala_iterable_ref0 (_tmp382_);
			_vala_iterable_unref0 (params);
			params = _tmp383_;
		} else {
			gboolean _tmp384_ = FALSE;
			ValaMemberAccess* _tmp385_;
			const gchar* _tmp386_;
			const gchar* _tmp387_;
			_tmp385_ = ma;
			_tmp386_ = vala_member_access_get_member_name (_tmp385_);
			_tmp387_ = _tmp386_;
			if (g_strcmp0 (_tmp387_, "end") == 0) {
				ValaMemberAccess* _tmp388_;
				ValaExpression* _tmp389_;
				ValaExpression* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaSymbol* _tmp392_;
				ValaMemberAccess* _tmp393_;
				ValaSymbol* _tmp394_;
				ValaSymbol* _tmp395_;
				_tmp388_ = ma;
				_tmp389_ = vala_member_access_get_inner (_tmp388_);
				_tmp390_ = _tmp389_;
				_tmp391_ = vala_expression_get_symbol_reference (_tmp390_);
				_tmp392_ = _tmp391_;
				_tmp393_ = ma;
				_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp393_);
				_tmp395_ = _tmp394_;
				_tmp384_ = _tmp392_ == _tmp395_;
			} else {
				_tmp384_ = FALSE;
			}
			if (_tmp384_) {
				ValaCCodeFunctionCall* _tmp396_;
				ValaCCodeFunctionCall* _tmp397_;
				ValaMethod* _tmp398_;
				ValaList* _tmp399_;
				ValaList* _tmp400_;
				_tmp396_ = finish_call;
				_tmp397_ = _vala_ccode_node_ref0 (_tmp396_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp397_;
				_tmp398_ = m;
				_tmp399_ = vala_method_get_async_end_parameters (_tmp398_);
				_tmp400_ = _vala_iterable_ref0 (_tmp399_);
				_vala_iterable_unref0 (params);
				params = _tmp400_;
			} else {
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp401_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp402_ = _tmp401_;
				if (!_tmp402_) {
					ValaCCodeFunctionCall* _tmp403_;
					ValaCCodeFunctionCall* _tmp404_;
					ValaMethod* _tmp405_;
					ValaList* _tmp406_;
					ValaList* _tmp407_;
					_tmp403_ = async_call;
					_tmp404_ = _vala_ccode_node_ref0 (_tmp403_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp404_;
					_tmp405_ = m;
					_tmp406_ = vala_method_get_async_begin_parameters (_tmp405_);
					_tmp407_ = _vala_iterable_ref0 (_tmp406_);
					_vala_iterable_unref0 (params);
					params = _tmp407_;
				} else {
					ValaCCodeFunctionCall* _tmp408_;
					ValaCCodeFunctionCall* _tmp409_;
					GHashFunc _tmp410_;
					GEqualFunc _tmp411_;
					GEqualFunc _tmp412_;
					ValaHashMap* _tmp413_;
					ValaHashMap* _tmp414_;
					ValaMethod* _tmp415_;
					ValaCCodeIdentifier* _tmp416_;
					ValaCCodeIdentifier* _tmp417_;
					ValaCCodeMemberAccess* _tmp418_;
					ValaCCodeMemberAccess* _tmp419_;
					_tmp408_ = finish_call;
					_tmp409_ = _vala_ccode_node_ref0 (_tmp408_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp409_;
					_tmp410_ = g_direct_hash;
					_tmp411_ = g_direct_equal;
					_tmp412_ = g_direct_equal;
					_tmp413_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp410_, _tmp411_, _tmp412_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp413_;
					_tmp414_ = out_arg_map;
					_tmp415_ = m;
					_tmp416_ = vala_ccode_identifier_new ("_data_");
					_tmp417_ = _tmp416_;
					_tmp418_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp417_, "_res_");
					_tmp419_ = _tmp418_;
					vala_map_set ((ValaMap*) _tmp414_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp415_), FALSE)), (ValaCCodeExpression*) _tmp419_);
					_vala_ccode_node_unref0 (_tmp419_);
					_vala_ccode_node_unref0 (_tmp417_);
				}
			}
		}
	}
	_tmp421_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp422_;
		ValaSymbol* _tmp423_;
		ValaSymbol* _tmp424_;
		_tmp422_ = m;
		_tmp423_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp422_);
		_tmp424_ = _tmp423_;
		_tmp420_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp424_, VALA_TYPE_CLASS);
	} else {
		_tmp420_ = FALSE;
	}
	if (_tmp420_) {
		ValaCodeContext* _tmp425_;
		ValaCodeContext* _tmp426_;
		ValaProfile _tmp427_;
		ValaProfile _tmp428_;
		ValaClass* _tmp440_;
		ValaClass* _tmp441_;
		gboolean _tmp442_;
		gboolean _tmp443_;
		_tmp425_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_code_context_get_profile (_tmp426_);
		_tmp428_ = _tmp427_;
		if (_tmp428_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp429_;
			ValaSymbol* _tmp430_;
			ValaSymbol* _tmp431_;
			gboolean _tmp432_;
			gboolean _tmp433_;
			_tmp429_ = m;
			_tmp430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp429_);
			_tmp431_ = _tmp430_;
			_tmp432_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp431_, VALA_TYPE_CLASS, ValaClass));
			_tmp433_ = _tmp432_;
			if (!_tmp433_) {
				ValaCCodeFunctionCall* _tmp434_;
				ValaCCodeExpression* _tmp435_;
				ValaCCodeExpression* _tmp436_;
				_tmp434_ = ccall;
				_tmp435_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp436_ = _tmp435_;
				vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
				_vala_ccode_node_unref0 (_tmp436_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			ValaCCodeExpression* _tmp439_;
			_tmp437_ = ccall;
			_tmp438_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp439_ = _tmp438_;
			vala_ccode_function_call_add_argument (_tmp437_, _tmp439_);
			_vala_ccode_node_unref0 (_tmp439_);
		}
		_tmp440_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_class_get_is_compact (_tmp441_);
		_tmp443_ = _tmp442_;
		if (!_tmp443_) {
			ValaClass* _tmp444_;
			ValaClass* _tmp445_;
			ValaMethod* _tmp446_;
			ValaSymbol* _tmp447_;
			ValaSymbol* _tmp448_;
			_tmp444_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp445_ = _tmp444_;
			_tmp446_ = m;
			_tmp447_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp446_);
			_tmp448_ = _tmp447_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp448_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp449_;
					ValaClass* _tmp450_;
					ValaList* _tmp451_;
					gint _base_type_size = 0;
					ValaList* _tmp452_;
					gint _tmp453_;
					gint _tmp454_;
					gint _base_type_index = 0;
					_tmp449_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp450_ = _tmp449_;
					_tmp451_ = vala_class_get_base_types (_tmp450_);
					_base_type_list = _tmp451_;
					_tmp452_ = _base_type_list;
					_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
					_tmp454_ = _tmp453_;
					_base_type_size = _tmp454_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp455_;
						gint _tmp456_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp457_;
						gpointer _tmp458_;
						ValaDataType* _tmp459_;
						ValaTypeSymbol* _tmp460_;
						ValaTypeSymbol* _tmp461_;
						_base_type_index = _base_type_index + 1;
						_tmp455_ = _base_type_index;
						_tmp456_ = _base_type_size;
						if (!(_tmp455_ < _tmp456_)) {
							break;
						}
						_tmp457_ = _base_type_list;
						_tmp458_ = vala_list_get (_tmp457_, _base_type_index);
						base_type = (ValaDataType*) _tmp458_;
						_tmp459_ = base_type;
						_tmp460_ = vala_data_type_get_type_symbol (_tmp459_);
						_tmp461_ = _tmp460_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp461_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp462_;
							gchar* _tmp463_;
							gchar* _tmp464_;
							gboolean _tmp465_;
							ValaMethod* _tmp471_;
							ValaHashMap* _tmp472_;
							ValaDataType* _tmp473_;
							ValaList* _tmp474_;
							ValaList* _tmp475_;
							type_parameters = NULL;
							_tmp462_ = m;
							_tmp463_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp462_);
							_tmp464_ = _tmp463_;
							_tmp465_ = g_strcmp0 (_tmp464_, "g_object_new") == 0;
							_g_free0 (_tmp464_);
							if (_tmp465_) {
								ValaDataType* _tmp466_;
								ValaTypeSymbol* _tmp467_;
								ValaTypeSymbol* _tmp468_;
								ValaList* _tmp469_;
								ValaList* _tmp470_;
								_tmp466_ = base_type;
								_tmp467_ = vala_data_type_get_type_symbol (_tmp466_);
								_tmp468_ = _tmp467_;
								_tmp469_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_CLASS, ValaClass));
								_tmp470_ = _vala_iterable_ref0 (_tmp469_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp470_;
							}
							_tmp471_ = m;
							_tmp472_ = in_arg_map;
							_tmp473_ = base_type;
							_tmp474_ = vala_data_type_get_type_arguments (_tmp473_);
							_tmp475_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp471_, (ValaMap*) _tmp472_, _tmp474_, (ValaCodeNode*) expr, TRUE, _tmp475_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp476_;
				ValaSymbol* _tmp477_;
				ValaSymbol* _tmp478_;
				ValaClass* _tmp479_;
				type_param_index = 0;
				_tmp476_ = m;
				_tmp477_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp478_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp479_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp480_;
					ValaList* _tmp481_;
					gint _type_param_size = 0;
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					gint _type_param_index = 0;
					_tmp480_ = cl;
					_tmp481_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp480_);
					_type_param_list = _tmp481_;
					_tmp482_ = _type_param_list;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_type_param_size = _tmp484_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp485_;
						gint _tmp486_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp487_;
						gpointer _tmp488_;
						ValaHashMap* _tmp489_;
						ValaTypeParameter* _tmp490_;
						const gchar* _tmp491_;
						const gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						gchar* _tmp495_;
						gchar* _tmp496_;
						ValaCCodeIdentifier* _tmp497_;
						ValaCCodeIdentifier* _tmp498_;
						ValaHashMap* _tmp499_;
						ValaTypeParameter* _tmp500_;
						const gchar* _tmp501_;
						const gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						gchar* _tmp505_;
						gchar* _tmp506_;
						ValaCCodeIdentifier* _tmp507_;
						ValaCCodeIdentifier* _tmp508_;
						ValaHashMap* _tmp509_;
						ValaTypeParameter* _tmp510_;
						const gchar* _tmp511_;
						const gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						gchar* _tmp515_;
						gchar* _tmp516_;
						ValaCCodeIdentifier* _tmp517_;
						ValaCCodeIdentifier* _tmp518_;
						gint _tmp519_;
						_type_param_index = _type_param_index + 1;
						_tmp485_ = _type_param_index;
						_tmp486_ = _type_param_size;
						if (!(_tmp485_ < _tmp486_)) {
							break;
						}
						_tmp487_ = _type_param_list;
						_tmp488_ = vala_list_get (_tmp487_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp488_;
						_tmp489_ = in_arg_map;
						_tmp490_ = type_param;
						_tmp491_ = vala_symbol_get_name ((ValaSymbol*) _tmp490_);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_ascii_strdown (_tmp492_, (gssize) -1);
						_tmp494_ = _tmp493_;
						_tmp495_ = g_strdup_printf ("%s_type", _tmp494_);
						_tmp496_ = _tmp495_;
						_tmp497_ = vala_ccode_identifier_new (_tmp496_);
						_tmp498_ = _tmp497_;
						vala_map_set ((ValaMap*) _tmp489_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp498_);
						_vala_ccode_node_unref0 (_tmp498_);
						_g_free0 (_tmp496_);
						_g_free0 (_tmp494_);
						_tmp499_ = in_arg_map;
						_tmp500_ = type_param;
						_tmp501_ = vala_symbol_get_name ((ValaSymbol*) _tmp500_);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_ascii_strdown (_tmp502_, (gssize) -1);
						_tmp504_ = _tmp503_;
						_tmp505_ = g_strdup_printf ("%s_dup_func", _tmp504_);
						_tmp506_ = _tmp505_;
						_tmp507_ = vala_ccode_identifier_new (_tmp506_);
						_tmp508_ = _tmp507_;
						vala_map_set ((ValaMap*) _tmp499_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp508_);
						_vala_ccode_node_unref0 (_tmp508_);
						_g_free0 (_tmp506_);
						_g_free0 (_tmp504_);
						_tmp509_ = in_arg_map;
						_tmp510_ = type_param;
						_tmp511_ = vala_symbol_get_name ((ValaSymbol*) _tmp510_);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_ascii_strdown (_tmp512_, (gssize) -1);
						_tmp514_ = _tmp513_;
						_tmp515_ = g_strdup_printf ("%s_destroy_func", _tmp514_);
						_tmp516_ = _tmp515_;
						_tmp517_ = vala_ccode_identifier_new (_tmp516_);
						_tmp518_ = _tmp517_;
						vala_map_set ((ValaMap*) _tmp509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp518_);
						_vala_ccode_node_unref0 (_tmp518_);
						_g_free0 (_tmp516_);
						_g_free0 (_tmp514_);
						_tmp519_ = type_param_index;
						type_param_index = _tmp519_ + 1;
						_vala_code_node_unref0 (type_param);
					}
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp520_;
			ValaClass* _tmp521_;
			ValaClass* _tmp522_;
			_tmp520_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp521_ = _tmp520_;
			_tmp522_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp521_, (ValaTypeSymbol*) _tmp522_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp523_;
				ValaClass* _tmp524_;
				gchar* _tmp525_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp526_;
				ValaCCodeDeclaration* _tmp527_;
				ValaCCodeDeclaration* _tmp528_;
				const gchar* _tmp529_;
				const gchar* _tmp530_;
				const gchar* _tmp531_;
				const gchar* _tmp532_;
				gchar* _tmp533_;
				gchar* _tmp534_;
				ValaCCodeConstant* _tmp535_;
				ValaCCodeConstant* _tmp536_;
				ValaCCodeVariableDeclarator* _tmp537_;
				ValaCCodeVariableDeclarator* _tmp538_;
				ValaCCodeFunction* _tmp539_;
				ValaCCodeFunction* _tmp540_;
				ValaCCodeDeclaration* _tmp541_;
				ValaCCodeFunctionCall* _tmp542_;
				ValaCCodeIdentifier* _tmp543_;
				ValaCCodeIdentifier* _tmp544_;
				ValaCCodeUnaryExpression* _tmp545_;
				ValaCCodeUnaryExpression* _tmp546_;
				ValaCCodeCastExpression* _tmp547_;
				ValaCCodeCastExpression* _tmp548_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp549_;
				ValaCCodeIdentifier* _tmp550_;
				ValaCCodeFunctionCall* _tmp551_;
				ValaCCodeFunctionCall* _tmp552_;
				ValaCCodeFunctionCall* _tmp553_;
				ValaClass* _tmp554_;
				ValaClass* _tmp555_;
				gchar* _tmp556_;
				gchar* _tmp557_;
				ValaCCodeIdentifier* _tmp558_;
				ValaCCodeIdentifier* _tmp559_;
				ValaCCodeFunctionCall* _tmp560_;
				ValaCCodeFunctionCall* _tmp561_;
				_tmp523_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp524_ = _tmp523_;
				_tmp525_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp524_, NULL);
				class_prefix = _tmp525_;
				_tmp526_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp526_;
				_tmp527_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp527_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp528_ = funcs;
				_tmp529_ = class_prefix;
				_tmp530_ = class_prefix;
				_tmp531_ = class_prefix;
				_tmp532_ = class_prefix;
				_tmp533_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp529_, _tmp530_, _tmp531_, _tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_ccode_constant_new (_tmp534_);
				_tmp536_ = _tmp535_;
				_tmp537_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp536_, NULL);
				_tmp538_ = _tmp537_;
				vala_ccode_declaration_add_declarator (_tmp528_, (ValaCCodeDeclarator*) _tmp538_);
				_vala_ccode_node_unref0 (_tmp538_);
				_vala_ccode_node_unref0 (_tmp536_);
				_g_free0 (_tmp534_);
				_tmp539_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp540_ = _tmp539_;
				_tmp541_ = funcs;
				vala_ccode_function_add_statement (_tmp540_, (ValaCCodeNode*) _tmp541_);
				_tmp542_ = ccall;
				_tmp543_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp546_, "GSourceFuncs *");
				_tmp548_ = _tmp547_;
				vala_ccode_function_call_add_argument (_tmp542_, (ValaCCodeExpression*) _tmp548_);
				_vala_ccode_node_unref0 (_tmp548_);
				_vala_ccode_node_unref0 (_tmp546_);
				_vala_ccode_node_unref0 (_tmp544_);
				_tmp549_ = vala_ccode_identifier_new ("sizeof");
				_tmp550_ = _tmp549_;
				_tmp551_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp550_);
				_tmp552_ = _tmp551_;
				_vala_ccode_node_unref0 (_tmp550_);
				csizeof = _tmp552_;
				_tmp553_ = csizeof;
				_tmp554_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_get_ccode_name ((ValaCodeNode*) _tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = vala_ccode_identifier_new (_tmp557_);
				_tmp559_ = _tmp558_;
				vala_ccode_function_call_add_argument (_tmp553_, (ValaCCodeExpression*) _tmp559_);
				_vala_ccode_node_unref0 (_tmp559_);
				_g_free0 (_tmp557_);
				_tmp560_ = ccall;
				_tmp561_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp560_, (ValaCCodeExpression*) _tmp561_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			} else {
				gboolean _tmp562_ = FALSE;
				ValaClass* _tmp563_;
				ValaClass* _tmp564_;
				ValaClass* _tmp565_;
				ValaClass* _tmp566_;
				_tmp563_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp564_ = _tmp563_;
				_tmp565_ = vala_class_get_base_class (_tmp564_);
				_tmp566_ = _tmp565_;
				if (_tmp566_ != NULL) {
					ValaMethod* _tmp567_;
					_tmp567_ = m;
					_tmp562_ = vala_get_ccode_simple_generics (_tmp567_);
				} else {
					_tmp562_ = FALSE;
				}
				if (_tmp562_) {
					ValaClass* _tmp568_;
					ValaClass* _tmp569_;
					ValaMethod* _tmp570_;
					ValaSymbol* _tmp571_;
					ValaSymbol* _tmp572_;
					_tmp568_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp569_ = _tmp568_;
					_tmp570_ = m;
					_tmp571_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp570_);
					_tmp572_ = _tmp571_;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp569_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp572_) {
						{
							ValaList* _base_type_list = NULL;
							ValaClass* _tmp573_;
							ValaClass* _tmp574_;
							ValaList* _tmp575_;
							gint _base_type_size = 0;
							ValaList* _tmp576_;
							gint _tmp577_;
							gint _tmp578_;
							gint _base_type_index = 0;
							_tmp573_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp574_ = _tmp573_;
							_tmp575_ = vala_class_get_base_types (_tmp574_);
							_base_type_list = _tmp575_;
							_tmp576_ = _base_type_list;
							_tmp577_ = vala_collection_get_size ((ValaCollection*) _tmp576_);
							_tmp578_ = _tmp577_;
							_base_type_size = _tmp578_;
							_base_type_index = -1;
							while (TRUE) {
								gint _tmp579_;
								gint _tmp580_;
								ValaDataType* base_type = NULL;
								ValaList* _tmp581_;
								gpointer _tmp582_;
								ValaDataType* _tmp583_;
								ValaTypeSymbol* _tmp584_;
								ValaTypeSymbol* _tmp585_;
								_base_type_index = _base_type_index + 1;
								_tmp579_ = _base_type_index;
								_tmp580_ = _base_type_size;
								if (!(_tmp579_ < _tmp580_)) {
									break;
								}
								_tmp581_ = _base_type_list;
								_tmp582_ = vala_list_get (_tmp581_, _base_type_index);
								base_type = (ValaDataType*) _tmp582_;
								_tmp583_ = base_type;
								_tmp584_ = vala_data_type_get_type_symbol (_tmp583_);
								_tmp585_ = _tmp584_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp585_, VALA_TYPE_CLASS)) {
									ValaMethod* _tmp586_;
									ValaHashMap* _tmp587_;
									ValaDataType* _tmp588_;
									ValaList* _tmp589_;
									_tmp586_ = m;
									_tmp587_ = in_arg_map;
									_tmp588_ = base_type;
									_tmp589_ = vala_data_type_get_type_arguments (_tmp588_);
									vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp586_, (ValaMap*) _tmp587_, _tmp589_, (ValaCodeNode*) expr, FALSE, NULL);
									_vala_code_node_unref0 (base_type);
									break;
								}
								_vala_code_node_unref0 (base_type);
							}
						}
					} else {
					}
				}
			}
		}
	} else {
		gboolean _tmp590_ = FALSE;
		ValaMethod* _tmp591_;
		_tmp591_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp591_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp592_;
			ValaSymbol* _tmp593_;
			ValaSymbol* _tmp594_;
			_tmp592_ = m;
			_tmp593_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp592_);
			_tmp594_ = _tmp593_;
			_tmp590_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp594_, VALA_TYPE_STRUCT);
		} else {
			_tmp590_ = FALSE;
		}
		if (_tmp590_) {
			ValaCCodeFunctionCall* _tmp595_;
			ValaCCodeExpression* _tmp596_;
			ValaCCodeExpression* _tmp597_;
			_tmp595_ = ccall;
			_tmp596_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp597_ = _tmp596_;
			vala_ccode_function_call_add_argument (_tmp595_, _tmp597_);
			_vala_ccode_node_unref0 (_tmp597_);
		} else {
			gboolean _tmp598_ = FALSE;
			gboolean _tmp599_ = FALSE;
			gboolean _tmp600_ = FALSE;
			gboolean _tmp601_ = FALSE;
			ValaMethod* _tmp602_;
			_tmp602_ = m;
			if (_tmp602_ != NULL) {
				ValaMethod* _tmp603_;
				_tmp603_ = m;
				_tmp601_ = vala_method_has_type_parameters (_tmp603_);
			} else {
				_tmp601_ = FALSE;
			}
			if (_tmp601_) {
				ValaMethod* _tmp604_;
				_tmp604_ = m;
				_tmp600_ = !vala_get_ccode_has_generic_type_parameter (_tmp604_);
			} else {
				_tmp600_ = FALSE;
			}
			if (_tmp600_) {
				ValaMethod* _tmp605_;
				_tmp605_ = m;
				_tmp599_ = !vala_get_ccode_simple_generics (_tmp605_);
			} else {
				_tmp599_ = FALSE;
			}
			if (_tmp599_) {
				gboolean _tmp606_ = FALSE;
				ValaCCodeFunctionCall* _tmp607_;
				ValaCCodeFunctionCall* _tmp608_;
				_tmp607_ = ccall;
				_tmp608_ = finish_call;
				if (_tmp607_ != _tmp608_) {
					_tmp606_ = TRUE;
				} else {
					gboolean _tmp609_;
					gboolean _tmp610_;
					_tmp609_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
					_tmp610_ = _tmp609_;
					_tmp606_ = _tmp610_;
				}
				_tmp598_ = _tmp606_;
			} else {
				_tmp598_ = FALSE;
			}
			if (_tmp598_) {
				ValaMethod* _tmp611_;
				ValaHashMap* _tmp612_;
				ValaMemberAccess* _tmp613_;
				ValaList* _tmp614_;
				_tmp611_ = m;
				_tmp612_ = in_arg_map;
				_tmp613_ = ma;
				_tmp614_ = vala_member_access_get_type_arguments (_tmp613_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, _tmp611_, (ValaMap*) _tmp612_, _tmp614_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp615_ = ccall;
	_tmp616_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp615_);
	ccall_expr = _tmp616_;
	_tmp618_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp618_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp619_;
		ValaCodeContext* _tmp620_;
		ValaProfile _tmp621_;
		ValaProfile _tmp622_;
		_tmp619_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp620_ = _tmp619_;
		_tmp621_ = vala_code_context_get_profile (_tmp620_);
		_tmp622_ = _tmp621_;
		_tmp617_ = _tmp622_ != VALA_PROFILE_POSIX;
	} else {
		_tmp617_ = FALSE;
	}
	if (_tmp617_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp623_;
		ValaExpression* _tmp624_;
		ValaExpression* _tmp625_;
		ValaDataType* _tmp626_;
		ValaDataType* _tmp627_;
		ValaArrayType* _tmp628_;
		ValaHashMap* _tmp629_;
		ValaArrayType* _tmp630_;
		ValaDataType* _tmp631_;
		ValaDataType* _tmp632_;
		gchar* _tmp633_;
		gchar* _tmp634_;
		ValaCCodeIdentifier* _tmp635_;
		ValaCCodeIdentifier* _tmp636_;
		_tmp623_ = ma;
		_tmp624_ = vala_member_access_get_inner (_tmp623_);
		_tmp625_ = _tmp624_;
		_tmp626_ = vala_expression_get_value_type (_tmp625_);
		_tmp627_ = _tmp626_;
		_tmp628_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp627_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp628_;
		_tmp629_ = in_arg_map;
		_tmp630_ = array_type;
		_tmp631_ = vala_array_type_get_element_type (_tmp630_);
		_tmp632_ = _tmp631_;
		_tmp633_ = vala_get_ccode_name ((ValaCodeNode*) _tmp632_);
		_tmp634_ = _tmp633_;
		_tmp635_ = vala_ccode_identifier_new (_tmp634_);
		_tmp636_ = _tmp635_;
		vala_map_set ((ValaMap*) _tmp629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp636_);
		_vala_ccode_node_unref0 (_tmp636_);
		_g_free0 (_tmp634_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp637_;
		_tmp637_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp637_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp638_;
			_tmp638_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp638_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp639_;
				ValaExpression* _tmp640_;
				ValaExpression* _tmp641_;
				ValaTargetValue* _tmp642_;
				ValaTargetValue* _tmp643_;
				ValaTargetValue* _tmp644_;
				ValaTargetValue* _tmp645_;
				_tmp639_ = ma;
				_tmp640_ = vala_member_access_get_inner (_tmp639_);
				_tmp641_ = _tmp640_;
				_tmp642_ = vala_expression_get_target_value (_tmp641_);
				_tmp643_ = _tmp642_;
				_tmp644_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp643_, (ValaCodeNode*) expr);
				_tmp645_ = _tmp644_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp645_);
				_vala_target_value_unref0 (_tmp645_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp647_ = m;
	if (_tmp647_ != NULL) {
		ValaMethod* _tmp648_;
		gboolean _tmp649_;
		gboolean _tmp650_;
		_tmp648_ = m;
		_tmp649_ = vala_method_get_is_async_callback (_tmp648_);
		_tmp650_ = _tmp649_;
		_tmp646_ = _tmp650_;
	} else {
		_tmp646_ = FALSE;
	}
	if (_tmp646_) {
		ValaMethod* _tmp651_;
		ValaMethod* _tmp652_;
		gboolean _tmp653_;
		gboolean _tmp654_;
		ValaHashMap* _tmp668_;
		ValaMethod* _tmp669_;
		ValaCCodeExpression* _tmp670_;
		ValaHashMap* _tmp671_;
		ValaMethod* _tmp672_;
		ValaCCodeExpression* _tmp673_;
		_tmp651_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp652_ = _tmp651_;
		_tmp653_ = vala_method_get_closure (_tmp652_);
		_tmp654_ = _tmp653_;
		if (_tmp654_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp655_;
			ValaSymbol* _tmp656_;
			ValaSymbol* _tmp657_;
			ValaBlock* _tmp658_;
			ValaBlock* _tmp659_;
			ValaBlock* _tmp660_;
			ValaBlock* _tmp661_;
			gchar* _tmp662_;
			gchar* _tmp663_;
			ValaCCodeExpression* _tmp664_;
			ValaCCodeExpression* _tmp665_;
			ValaCCodeMemberAccess* _tmp666_;
			_tmp655_ = m;
			_tmp656_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp655_);
			_tmp657_ = _tmp656_;
			_tmp658_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp657_, VALA_TYPE_METHOD, ValaMethod));
			_tmp659_ = _tmp658_;
			_tmp660_ = _vala_code_node_ref0 (_tmp659_);
			block = _tmp660_;
			_tmp661_ = block;
			_tmp662_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp661_));
			_tmp663_ = _tmp662_;
			_tmp664_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp663_);
			_tmp665_ = _tmp664_;
			_tmp666_ = vala_ccode_member_access_new_pointer (_tmp665_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp666_;
			_vala_ccode_node_unref0 (_tmp665_);
			_g_free0 (_tmp663_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp667_;
			_tmp667_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp667_;
		}
		_tmp668_ = in_arg_map;
		_tmp669_ = m;
		_tmp670_ = instance;
		vala_map_set ((ValaMap*) _tmp668_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp669_), FALSE)), _tmp670_);
		_tmp671_ = out_arg_map;
		_tmp672_ = m;
		_tmp673_ = instance;
		vala_map_set ((ValaMap*) _tmp671_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp672_), FALSE)), _tmp673_);
	} else {
		gboolean _tmp674_ = FALSE;
		gboolean _tmp675_ = FALSE;
		ValaMethod* _tmp676_;
		_tmp676_ = m;
		if (_tmp676_ != NULL) {
			ValaMethod* _tmp677_;
			ValaMemberBinding _tmp678_;
			ValaMemberBinding _tmp679_;
			_tmp677_ = m;
			_tmp678_ = vala_method_get_binding (_tmp677_);
			_tmp679_ = _tmp678_;
			_tmp675_ = _tmp679_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp675_ = FALSE;
		}
		if (_tmp675_) {
			ValaMethod* _tmp680_;
			_tmp680_ = m;
			_tmp674_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp680_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp674_ = FALSE;
		}
		if (_tmp674_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp681_;
			ValaExpression* _tmp682_;
			ValaExpression* _tmp683_;
			ValaTargetValue* _tmp684_;
			ValaTargetValue* _tmp685_;
			ValaTargetValue* _tmp686_;
			gboolean _tmp687_ = FALSE;
			gboolean _tmp688_ = FALSE;
			ValaMemberAccess* _tmp689_;
			const gchar* _tmp690_;
			const gchar* _tmp691_;
			ValaTargetValue* _tmp713_;
			ValaCCodeExpression* _tmp714_;
			ValaCCodeExpression* _tmp715_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp716_;
			ValaSymbol* _tmp717_;
			ValaSymbol* _tmp718_;
			ValaStruct* _tmp719_;
			gboolean _tmp720_ = FALSE;
			ValaStruct* _tmp721_;
			ValaMethod* _tmp729_;
			gboolean _tmp730_;
			gboolean _tmp731_;
			_tmp681_ = ma;
			_tmp682_ = vala_member_access_get_inner (_tmp681_);
			_tmp683_ = _tmp682_;
			_tmp684_ = vala_expression_get_target_value (_tmp683_);
			_tmp685_ = _tmp684_;
			_tmp686_ = _vala_target_value_ref0 (_tmp685_);
			instance_value = _tmp686_;
			_tmp689_ = ma;
			_tmp690_ = vala_member_access_get_member_name (_tmp689_);
			_tmp691_ = _tmp690_;
			if (g_strcmp0 (_tmp691_, "begin") == 0) {
				_tmp688_ = TRUE;
			} else {
				ValaMemberAccess* _tmp692_;
				const gchar* _tmp693_;
				const gchar* _tmp694_;
				_tmp692_ = ma;
				_tmp693_ = vala_member_access_get_member_name (_tmp692_);
				_tmp694_ = _tmp693_;
				_tmp688_ = g_strcmp0 (_tmp694_, "end") == 0;
			}
			if (_tmp688_) {
				ValaMemberAccess* _tmp695_;
				ValaExpression* _tmp696_;
				ValaExpression* _tmp697_;
				ValaSymbol* _tmp698_;
				ValaSymbol* _tmp699_;
				ValaMemberAccess* _tmp700_;
				ValaSymbol* _tmp701_;
				ValaSymbol* _tmp702_;
				_tmp695_ = ma;
				_tmp696_ = vala_member_access_get_inner (_tmp695_);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_expression_get_symbol_reference (_tmp697_);
				_tmp699_ = _tmp698_;
				_tmp700_ = ma;
				_tmp701_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp700_);
				_tmp702_ = _tmp701_;
				_tmp687_ = _tmp699_ == _tmp702_;
			} else {
				_tmp687_ = FALSE;
			}
			if (_tmp687_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp703_;
				ValaExpression* _tmp704_;
				ValaExpression* _tmp705_;
				ValaMemberAccess* _tmp706_;
				ValaMemberAccess* _tmp707_;
				ValaExpression* _tmp708_;
				ValaExpression* _tmp709_;
				ValaTargetValue* _tmp710_;
				ValaTargetValue* _tmp711_;
				ValaTargetValue* _tmp712_;
				_tmp703_ = ma;
				_tmp704_ = vala_member_access_get_inner (_tmp703_);
				_tmp705_ = _tmp704_;
				_tmp706_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp705_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp706_;
				_tmp707_ = inner_ma;
				_tmp708_ = vala_member_access_get_inner (_tmp707_);
				_tmp709_ = _tmp708_;
				_tmp710_ = vala_expression_get_target_value (_tmp709_);
				_tmp711_ = _tmp710_;
				_tmp712_ = _vala_target_value_ref0 (_tmp711_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp712_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp713_ = instance_value;
			_tmp714_ = vala_get_cvalue_ (_tmp713_);
			_tmp715_ = _vala_ccode_node_ref0 (_tmp714_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp715_;
			_tmp716_ = m;
			_tmp717_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp716_);
			_tmp718_ = _tmp717_;
			_tmp719_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp718_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp718_) : NULL);
			st = _tmp719_;
			_tmp721_ = st;
			if (_tmp721_ != NULL) {
				ValaStruct* _tmp722_;
				_tmp722_ = st;
				_tmp720_ = !vala_struct_is_simple_type (_tmp722_);
			} else {
				_tmp720_ = FALSE;
			}
			if (_tmp720_) {
				ValaTargetValue* _tmp723_;
				ValaTargetValue* _tmp726_;
				ValaCCodeExpression* _tmp727_;
				ValaCCodeUnaryExpression* _tmp728_;
				_tmp723_ = instance_value;
				if (!vala_get_lvalue (_tmp723_)) {
					ValaTargetValue* _tmp724_;
					ValaTargetValue* _tmp725_;
					_tmp724_ = instance_value;
					_tmp725_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp724_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp725_;
				}
				_tmp726_ = instance_value;
				_tmp727_ = vala_get_cvalue_ (_tmp726_);
				_tmp728_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp727_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp728_;
			}
			_tmp729_ = m;
			_tmp730_ = vala_method_get_coroutine (_tmp729_);
			_tmp731_ = _tmp730_;
			if (!_tmp731_) {
				ValaHashMap* _tmp732_;
				ValaMethod* _tmp733_;
				ValaCCodeExpression* _tmp734_;
				_tmp732_ = in_arg_map;
				_tmp733_ = m;
				_tmp734_ = instance;
				vala_map_set ((ValaMap*) _tmp732_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp733_), FALSE)), _tmp734_);
			} else {
				gboolean _tmp735_;
				gboolean _tmp736_;
				_tmp735_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
				_tmp736_ = _tmp735_;
				if (_tmp736_) {
					ValaHashMap* _tmp737_;
					ValaMethod* _tmp738_;
					ValaCCodeExpression* _tmp739_;
					ValaMethod* _tmp740_;
					_tmp737_ = in_arg_map;
					_tmp738_ = m;
					_tmp739_ = instance;
					vala_map_set ((ValaMap*) _tmp737_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp738_), FALSE)), _tmp739_);
					_tmp740_ = m;
					if (vala_get_ccode_finish_instance (_tmp740_)) {
						ValaHashMap* _tmp741_;
						ValaMethod* _tmp742_;
						ValaCCodeExpression* _tmp743_;
						_tmp741_ = out_arg_map;
						_tmp742_ = m;
						_tmp743_ = instance;
						vala_map_set ((ValaMap*) _tmp741_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp742_), FALSE)), _tmp743_);
					}
				} else {
					gboolean _tmp744_ = FALSE;
					ValaMemberAccess* _tmp745_;
					const gchar* _tmp746_;
					const gchar* _tmp747_;
					_tmp745_ = ma;
					_tmp746_ = vala_member_access_get_member_name (_tmp745_);
					_tmp747_ = _tmp746_;
					if (g_strcmp0 (_tmp747_, "end") != 0) {
						_tmp744_ = TRUE;
					} else {
						ValaMethod* _tmp748_;
						_tmp748_ = m;
						_tmp744_ = vala_get_ccode_finish_instance (_tmp748_);
					}
					if (_tmp744_) {
						ValaHashMap* _tmp749_;
						ValaMethod* _tmp750_;
						ValaCCodeExpression* _tmp751_;
						ValaHashMap* _tmp752_;
						ValaMethod* _tmp753_;
						ValaCCodeExpression* _tmp754_;
						_tmp749_ = out_arg_map;
						_tmp750_ = m;
						_tmp751_ = instance;
						vala_map_set ((ValaMap*) _tmp749_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp750_), FALSE)), _tmp751_);
						_tmp752_ = in_arg_map;
						_tmp753_ = m;
						_tmp754_ = instance;
						vala_map_set ((ValaMap*) _tmp752_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp753_), FALSE)), _tmp754_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp755_ = FALSE;
			ValaMethod* _tmp756_;
			_tmp756_ = m;
			if (_tmp756_ != NULL) {
				ValaMethod* _tmp757_;
				ValaMemberBinding _tmp758_;
				ValaMemberBinding _tmp759_;
				_tmp757_ = m;
				_tmp758_ = vala_method_get_binding (_tmp757_);
				_tmp759_ = _tmp758_;
				_tmp755_ = _tmp759_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp755_ = FALSE;
			}
			if (_tmp755_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp760_;
				ValaSymbol* _tmp761_;
				ValaSymbol* _tmp762_;
				ValaClass* _tmp763_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp764_;
				gchar* _tmp765_;
				gchar* _tmp766_;
				ValaCCodeIdentifier* _tmp767_;
				ValaCCodeIdentifier* _tmp768_;
				ValaCCodeFunctionCall* _tmp769_;
				ValaCCodeFunctionCall* _tmp770_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp771_;
				ValaExpression* _tmp772_;
				ValaExpression* _tmp773_;
				ValaCCodeFunctionCall* _tmp802_;
				ValaCCodeExpression* _tmp803_;
				ValaHashMap* _tmp804_;
				ValaMethod* _tmp805_;
				ValaCCodeFunctionCall* _tmp806_;
				ValaHashMap* _tmp807_;
				ValaMethod* _tmp808_;
				ValaCCodeFunctionCall* _tmp809_;
				_tmp760_ = m;
				_tmp761_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp760_);
				_tmp762_ = _tmp761_;
				_tmp763_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp763_;
				_tmp764_ = cl;
				_tmp765_ = vala_get_ccode_class_type_function (_tmp764_);
				_tmp766_ = _tmp765_;
				_tmp767_ = vala_ccode_identifier_new (_tmp766_);
				_tmp768_ = _tmp767_;
				_tmp769_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp768_);
				_tmp770_ = _tmp769_;
				_vala_ccode_node_unref0 (_tmp768_);
				_g_free0 (_tmp766_);
				cast = _tmp770_;
				_tmp771_ = ma;
				_tmp772_ = vala_member_access_get_inner (_tmp771_);
				_tmp773_ = _tmp772_;
				if (_tmp773_ == NULL) {
					ValaDataType* _tmp774_;
					_tmp774_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp774_ == NULL) {
						ValaCCodeIdentifier* _tmp775_;
						_tmp775_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp775_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaClass* _tmp776_;
						gchar* _tmp777_;
						gchar* _tmp778_;
						ValaCCodeIdentifier* _tmp779_;
						ValaCCodeIdentifier* _tmp780_;
						ValaCCodeFunctionCall* _tmp781_;
						ValaCCodeFunctionCall* _tmp782_;
						ValaCCodeFunctionCall* _tmp783_;
						ValaCCodeExpression* _tmp784_;
						ValaCCodeExpression* _tmp785_;
						ValaCCodeFunctionCall* _tmp786_;
						ValaCCodeExpression* _tmp787_;
						_tmp776_ = cl;
						_tmp777_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp776_);
						_tmp778_ = _tmp777_;
						_tmp779_ = vala_ccode_identifier_new (_tmp778_);
						_tmp780_ = _tmp779_;
						_tmp781_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp780_);
						_tmp782_ = _tmp781_;
						_vala_ccode_node_unref0 (_tmp780_);
						_g_free0 (_tmp778_);
						k = _tmp782_;
						_tmp783_ = k;
						_tmp784_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp785_ = _tmp784_;
						vala_ccode_function_call_add_argument (_tmp783_, _tmp785_);
						_vala_ccode_node_unref0 (_tmp785_);
						_tmp786_ = k;
						_tmp787_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp786_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp787_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaClass* _tmp788_;
					gchar* _tmp789_;
					gchar* _tmp790_;
					ValaCCodeIdentifier* _tmp791_;
					ValaCCodeIdentifier* _tmp792_;
					ValaCCodeFunctionCall* _tmp793_;
					ValaCCodeFunctionCall* _tmp794_;
					ValaCCodeFunctionCall* _tmp795_;
					ValaMemberAccess* _tmp796_;
					ValaExpression* _tmp797_;
					ValaExpression* _tmp798_;
					ValaCCodeExpression* _tmp799_;
					ValaCCodeFunctionCall* _tmp800_;
					ValaCCodeExpression* _tmp801_;
					_tmp788_ = cl;
					_tmp789_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp788_);
					_tmp790_ = _tmp789_;
					_tmp791_ = vala_ccode_identifier_new (_tmp790_);
					_tmp792_ = _tmp791_;
					_tmp793_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp792_);
					_tmp794_ = _tmp793_;
					_vala_ccode_node_unref0 (_tmp792_);
					_g_free0 (_tmp790_);
					k = _tmp794_;
					_tmp795_ = k;
					_tmp796_ = ma;
					_tmp797_ = vala_member_access_get_inner (_tmp796_);
					_tmp798_ = _tmp797_;
					_tmp799_ = vala_get_cvalue (_tmp798_);
					vala_ccode_function_call_add_argument (_tmp795_, _tmp799_);
					_tmp800_ = k;
					_tmp801_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp800_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp801_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp802_ = cast;
				_tmp803_ = klass;
				vala_ccode_function_call_add_argument (_tmp802_, _tmp803_);
				_tmp804_ = in_arg_map;
				_tmp805_ = m;
				_tmp806_ = cast;
				vala_map_set ((ValaMap*) _tmp804_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp805_), FALSE)), (ValaCCodeExpression*) _tmp806_);
				_tmp807_ = out_arg_map;
				_tmp808_ = m;
				_tmp809_ = cast;
				vala_map_set ((ValaMap*) _tmp807_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp808_), FALSE)), (ValaCCodeExpression*) _tmp809_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp811_ = m;
	if (_tmp811_ != NULL) {
		ValaMethod* _tmp812_;
		_tmp812_ = m;
		_tmp810_ = vala_get_ccode_has_generic_type_parameter (_tmp812_);
	} else {
		_tmp810_ = FALSE;
	}
	if (_tmp810_) {
		ValaMethod* _tmp813_;
		_tmp813_ = m;
		if (vala_method_has_type_parameters (_tmp813_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp814_;
				ValaList* _tmp815_;
				gint _type_arg_size = 0;
				ValaList* _tmp816_;
				gint _tmp817_;
				gint _tmp818_;
				gint _type_arg_index = 0;
				_tmp814_ = ma;
				_tmp815_ = vala_member_access_get_type_arguments (_tmp814_);
				_type_arg_list = _tmp815_;
				_tmp816_ = _type_arg_list;
				_tmp817_ = vala_collection_get_size ((ValaCollection*) _tmp816_);
				_tmp818_ = _tmp817_;
				_type_arg_size = _tmp818_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp819_;
					gint _tmp820_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp821_;
					gpointer _tmp822_;
					gboolean _tmp823_ = FALSE;
					gboolean _tmp824_ = FALSE;
					gboolean _tmp825_ = FALSE;
					ValaMethod* _tmp826_;
					ValaHashMap* _tmp834_;
					ValaMethod* _tmp835_;
					ValaDataType* _tmp836_;
					gchar* _tmp837_;
					gchar* _tmp838_;
					ValaCCodeIdentifier* _tmp839_;
					ValaCCodeIdentifier* _tmp840_;
					gint _tmp841_;
					_type_arg_index = _type_arg_index + 1;
					_tmp819_ = _type_arg_index;
					_tmp820_ = _type_arg_size;
					if (!(_tmp819_ < _tmp820_)) {
						break;
					}
					_tmp821_ = _type_arg_list;
					_tmp822_ = vala_list_get (_tmp821_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp822_;
					_tmp826_ = m;
					if (vala_get_ccode_simple_generics (_tmp826_)) {
						ValaDataType* _tmp827_;
						_tmp827_ = type_arg;
						_tmp825_ = vala_data_type_is_real_struct_type (_tmp827_);
					} else {
						_tmp825_ = FALSE;
					}
					if (_tmp825_) {
						ValaDataType* _tmp828_;
						gboolean _tmp829_;
						gboolean _tmp830_;
						_tmp828_ = type_arg;
						_tmp829_ = vala_data_type_get_nullable (_tmp828_);
						_tmp830_ = _tmp829_;
						_tmp824_ = !_tmp830_;
					} else {
						_tmp824_ = FALSE;
					}
					if (_tmp824_) {
						ValaDataType* _tmp831_;
						_tmp831_ = type_arg;
						_tmp823_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp831_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp823_ = FALSE;
					}
					if (_tmp823_) {
						ValaDataType* _tmp832_;
						ValaPointerType* _tmp833_;
						_tmp832_ = type_arg;
						_tmp833_ = vala_pointer_type_new (_tmp832_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp833_;
					}
					_tmp834_ = in_arg_map;
					_tmp835_ = m;
					_tmp836_ = type_arg;
					_tmp837_ = vala_get_ccode_name ((ValaCodeNode*) _tmp836_);
					_tmp838_ = _tmp837_;
					_tmp839_ = vala_ccode_identifier_new (_tmp838_);
					_tmp840_ = _tmp839_;
					vala_map_set ((ValaMap*) _tmp834_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp835_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp840_);
					_vala_ccode_node_unref0 (_tmp840_);
					_g_free0 (_tmp838_);
					_tmp841_ = type_param_index;
					type_param_index = _tmp841_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp842_;
				ValaExpression* _tmp843_;
				ValaExpression* _tmp844_;
				ValaDataType* _tmp845_;
				ValaDataType* _tmp846_;
				ValaList* _tmp847_;
				gint _type_arg_size = 0;
				ValaList* _tmp848_;
				gint _tmp849_;
				gint _tmp850_;
				gint _type_arg_index = 0;
				_tmp842_ = ma;
				_tmp843_ = vala_member_access_get_inner (_tmp842_);
				_tmp844_ = _tmp843_;
				_tmp845_ = vala_expression_get_value_type (_tmp844_);
				_tmp846_ = _tmp845_;
				_tmp847_ = vala_data_type_get_type_arguments (_tmp846_);
				_type_arg_list = _tmp847_;
				_tmp848_ = _type_arg_list;
				_tmp849_ = vala_collection_get_size ((ValaCollection*) _tmp848_);
				_tmp850_ = _tmp849_;
				_type_arg_size = _tmp850_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp851_;
					gint _tmp852_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp853_;
					gpointer _tmp854_;
					ValaHashMap* _tmp855_;
					ValaMethod* _tmp856_;
					ValaDataType* _tmp857_;
					gchar* _tmp858_;
					gchar* _tmp859_;
					ValaCCodeIdentifier* _tmp860_;
					ValaCCodeIdentifier* _tmp861_;
					gint _tmp862_;
					_type_arg_index = _type_arg_index + 1;
					_tmp851_ = _type_arg_index;
					_tmp852_ = _type_arg_size;
					if (!(_tmp851_ < _tmp852_)) {
						break;
					}
					_tmp853_ = _type_arg_list;
					_tmp854_ = vala_list_get (_tmp853_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp854_;
					_tmp855_ = in_arg_map;
					_tmp856_ = m;
					_tmp857_ = type_arg;
					_tmp858_ = vala_get_ccode_name ((ValaCodeNode*) _tmp857_);
					_tmp859_ = _tmp858_;
					_tmp860_ = vala_ccode_identifier_new (_tmp859_);
					_tmp861_ = _tmp860_;
					vala_map_set ((ValaMap*) _tmp855_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp856_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp861_);
					_vala_ccode_node_unref0 (_tmp861_);
					_g_free0 (_tmp859_);
					_tmp862_ = type_param_index;
					type_param_index = _tmp862_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
			}
		}
	}
	_tmp863_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp863_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp864_;
		ValaExpression* _tmp865_;
		ValaExpression* _tmp866_;
		ValaDataType* _tmp867_;
		ValaDataType* _tmp868_;
		ValaArrayType* _tmp869_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp870_;
		ValaCCodeIdentifier* _tmp871_;
		ValaCCodeFunctionCall* _tmp872_;
		ValaCCodeFunctionCall* _tmp873_;
		ValaCCodeFunctionCall* _tmp874_;
		ValaArrayType* _tmp875_;
		ValaDataType* _tmp876_;
		ValaDataType* _tmp877_;
		gchar* _tmp878_;
		gchar* _tmp879_;
		ValaCCodeIdentifier* _tmp880_;
		ValaCCodeIdentifier* _tmp881_;
		ValaHashMap* _tmp882_;
		ValaCCodeFunctionCall* _tmp883_;
		_tmp864_ = ma;
		_tmp865_ = vala_member_access_get_inner (_tmp864_);
		_tmp866_ = _tmp865_;
		_tmp867_ = vala_expression_get_value_type (_tmp866_);
		_tmp868_ = _tmp867_;
		_tmp869_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp869_;
		_tmp870_ = vala_ccode_identifier_new ("sizeof");
		_tmp871_ = _tmp870_;
		_tmp872_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp871_);
		_tmp873_ = _tmp872_;
		_vala_ccode_node_unref0 (_tmp871_);
		csizeof = _tmp873_;
		_tmp874_ = csizeof;
		_tmp875_ = array_type;
		_tmp876_ = vala_array_type_get_element_type (_tmp875_);
		_tmp877_ = _tmp876_;
		_tmp878_ = vala_get_ccode_name ((ValaCodeNode*) _tmp877_);
		_tmp879_ = _tmp878_;
		_tmp880_ = vala_ccode_identifier_new (_tmp879_);
		_tmp881_ = _tmp880_;
		vala_ccode_function_call_add_argument (_tmp874_, (ValaCCodeExpression*) _tmp881_);
		_vala_ccode_node_unref0 (_tmp881_);
		_g_free0 (_tmp879_);
		_tmp882_ = in_arg_map;
		_tmp883_ = csizeof;
		vala_map_set ((ValaMap*) _tmp882_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp883_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp884_;
		_tmp884_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp884_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp885_;
			ValaMethod* _tmp886_;
			ValaMethod* _tmp887_;
			gint param_nr = 0;
			ValaMethod* _tmp951_;
			ValaCCodeBaseModuleEmitContext* _tmp952_;
			_tmp885_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp886_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp885_, (ValaSymbol*) _tmp886_);
			_tmp887_ = m;
			vala_method_clear_parameters (_tmp887_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp888_;
				gint _arg_size = 0;
				ValaList* _tmp889_;
				gint _tmp890_;
				gint _tmp891_;
				gint _arg_index = 0;
				_tmp888_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
				_arg_list = _tmp888_;
				_tmp889_ = _arg_list;
				_tmp890_ = vala_collection_get_size ((ValaCollection*) _tmp889_);
				_tmp891_ = _tmp890_;
				_arg_size = _tmp891_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp892_;
					gint _tmp893_;
					ValaExpression* arg = NULL;
					ValaList* _tmp894_;
					gpointer _tmp895_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp896_;
					ValaUnaryExpression* _tmp897_;
					gboolean _tmp898_ = FALSE;
					ValaUnaryExpression* _tmp899_;
					gint _tmp940_;
					_arg_index = _arg_index + 1;
					_tmp892_ = _arg_index;
					_tmp893_ = _arg_size;
					if (!(_tmp892_ < _tmp893_)) {
						break;
					}
					_tmp894_ = _arg_list;
					_tmp895_ = vala_list_get (_tmp894_, _arg_index);
					arg = (ValaExpression*) _tmp895_;
					_tmp896_ = arg;
					_tmp897_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp896_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp896_) : NULL);
					unary = _tmp897_;
					_tmp899_ = unary;
					if (_tmp899_ != NULL) {
						ValaUnaryExpression* _tmp900_;
						ValaUnaryOperator _tmp901_;
						ValaUnaryOperator _tmp902_;
						_tmp900_ = unary;
						_tmp901_ = vala_unary_expression_get_operator (_tmp900_);
						_tmp902_ = _tmp901_;
						_tmp898_ = _tmp902_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp898_ = FALSE;
					}
					if (_tmp898_) {
						ValaParameter* param = NULL;
						gchar* _tmp903_;
						gchar* _tmp904_;
						ValaUnaryExpression* _tmp905_;
						ValaExpression* _tmp906_;
						ValaExpression* _tmp907_;
						ValaDataType* _tmp908_;
						ValaDataType* _tmp909_;
						ValaParameter* _tmp910_;
						ValaParameter* _tmp911_;
						ValaParameter* _tmp912_;
						ValaMethod* _tmp913_;
						ValaParameter* _tmp914_;
						_tmp903_ = g_strdup_printf ("param%d", param_nr);
						_tmp904_ = _tmp903_;
						_tmp905_ = unary;
						_tmp906_ = vala_unary_expression_get_inner (_tmp905_);
						_tmp907_ = _tmp906_;
						_tmp908_ = vala_expression_get_value_type (_tmp907_);
						_tmp909_ = _tmp908_;
						_tmp910_ = vala_parameter_new (_tmp904_, _tmp909_, NULL);
						_tmp911_ = _tmp910_;
						_g_free0 (_tmp904_);
						param = _tmp911_;
						_tmp912_ = param;
						vala_parameter_set_direction (_tmp912_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp913_ = m;
						_tmp914_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp913_, _tmp914_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp915_ = FALSE;
						ValaUnaryExpression* _tmp916_;
						_tmp916_ = unary;
						if (_tmp916_ != NULL) {
							ValaUnaryExpression* _tmp917_;
							ValaUnaryOperator _tmp918_;
							ValaUnaryOperator _tmp919_;
							_tmp917_ = unary;
							_tmp918_ = vala_unary_expression_get_operator (_tmp917_);
							_tmp919_ = _tmp918_;
							_tmp915_ = _tmp919_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp915_ = FALSE;
						}
						if (_tmp915_) {
							ValaParameter* param = NULL;
							gchar* _tmp920_;
							gchar* _tmp921_;
							ValaUnaryExpression* _tmp922_;
							ValaExpression* _tmp923_;
							ValaExpression* _tmp924_;
							ValaDataType* _tmp925_;
							ValaDataType* _tmp926_;
							ValaParameter* _tmp927_;
							ValaParameter* _tmp928_;
							ValaParameter* _tmp929_;
							ValaMethod* _tmp930_;
							ValaParameter* _tmp931_;
							_tmp920_ = g_strdup_printf ("param%d", param_nr);
							_tmp921_ = _tmp920_;
							_tmp922_ = unary;
							_tmp923_ = vala_unary_expression_get_inner (_tmp922_);
							_tmp924_ = _tmp923_;
							_tmp925_ = vala_expression_get_value_type (_tmp924_);
							_tmp926_ = _tmp925_;
							_tmp927_ = vala_parameter_new (_tmp921_, _tmp926_, NULL);
							_tmp928_ = _tmp927_;
							_g_free0 (_tmp921_);
							param = _tmp928_;
							_tmp929_ = param;
							vala_parameter_set_direction (_tmp929_, VALA_PARAMETER_DIRECTION_REF);
							_tmp930_ = m;
							_tmp931_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp930_, _tmp931_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp932_;
							gchar* _tmp933_;
							gchar* _tmp934_;
							ValaExpression* _tmp935_;
							ValaDataType* _tmp936_;
							ValaDataType* _tmp937_;
							ValaParameter* _tmp938_;
							ValaParameter* _tmp939_;
							_tmp932_ = m;
							_tmp933_ = g_strdup_printf ("param%d", param_nr);
							_tmp934_ = _tmp933_;
							_tmp935_ = arg;
							_tmp936_ = vala_expression_get_value_type (_tmp935_);
							_tmp937_ = _tmp936_;
							_tmp938_ = vala_parameter_new (_tmp934_, _tmp937_, NULL);
							_tmp939_ = _tmp938_;
							vala_callable_add_parameter ((ValaCallable*) _tmp932_, _tmp939_);
							_vala_code_node_unref0 (_tmp939_);
							_g_free0 (_tmp934_);
						}
					}
					_tmp940_ = param_nr;
					param_nr = _tmp940_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp941_;
				ValaList* _tmp942_;
				gint _param_size = 0;
				ValaList* _tmp943_;
				gint _tmp944_;
				gint _tmp945_;
				gint _param_index = 0;
				_tmp941_ = m;
				_tmp942_ = vala_callable_get_parameters ((ValaCallable*) _tmp941_);
				_param_list = _tmp942_;
				_tmp943_ = _param_list;
				_tmp944_ = vala_collection_get_size ((ValaCollection*) _tmp943_);
				_tmp945_ = _tmp944_;
				_param_size = _tmp945_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp946_;
					gint _tmp947_;
					ValaParameter* param = NULL;
					ValaList* _tmp948_;
					gpointer _tmp949_;
					ValaParameter* _tmp950_;
					_param_index = _param_index + 1;
					_tmp946_ = _param_index;
					_tmp947_ = _param_size;
					if (!(_tmp946_ < _tmp947_)) {
						break;
					}
					_tmp948_ = _param_list;
					_tmp949_ = vala_list_get (_tmp948_, _param_index);
					param = (ValaParameter*) _tmp949_;
					_tmp950_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp950_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
			}
			_tmp951_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp951_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp952_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp952_);
		} else {
			gboolean _tmp953_ = FALSE;
			gboolean _tmp954_ = FALSE;
			ValaMethod* _tmp955_;
			_tmp955_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp955_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp956_;
				ValaCodeContext* _tmp957_;
				ValaProfile _tmp958_;
				ValaProfile _tmp959_;
				_tmp956_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp957_ = _tmp956_;
				_tmp958_ = vala_code_context_get_profile (_tmp957_);
				_tmp959_ = _tmp958_;
				_tmp954_ = _tmp959_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp954_ = FALSE;
			}
			if (_tmp954_) {
				ValaMethod* _tmp960_;
				ValaSymbol* _tmp961_;
				ValaSymbol* _tmp962_;
				_tmp960_ = m;
				_tmp961_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp960_);
				_tmp962_ = _tmp961_;
				_tmp953_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp962_, VALA_TYPE_CLASS);
			} else {
				_tmp953_ = FALSE;
			}
			if (_tmp953_) {
				ValaCCodeFunction* _tmp963_;
				ValaCCodeFunction* _tmp964_;
				ValaCCodeExpression* _tmp965_;
				ValaCCodeExpression* _tmp966_;
				ValaCCodeFunctionCall* _tmp967_;
				ValaClass* _tmp968_;
				ValaClass* _tmp969_;
				gchar* _tmp970_;
				gchar* _tmp971_;
				gchar* _tmp972_;
				gchar* _tmp973_;
				ValaCCodeCastExpression* _tmp974_;
				ValaCCodeCastExpression* _tmp975_;
				ValaMethod* _tmp976_;
				ValaMethod* _tmp977_;
				ValaBlock* _tmp978_;
				ValaBlock* _tmp979_;
				gboolean _tmp980_;
				gboolean _tmp981_;
				gboolean _tmp1008_ = FALSE;
				ValaClass* _tmp1009_;
				ValaClass* _tmp1010_;
				gboolean _tmp1011_;
				gboolean _tmp1012_;
				_tmp963_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp964_ = _tmp963_;
				_tmp965_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp966_ = _tmp965_;
				_tmp967_ = ccall;
				_tmp968_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp969_ = _tmp968_;
				_tmp970_ = vala_get_ccode_name ((ValaCodeNode*) _tmp969_);
				_tmp971_ = _tmp970_;
				_tmp972_ = g_strconcat (_tmp971_, "*", NULL);
				_tmp973_ = _tmp972_;
				_tmp974_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp967_, _tmp973_);
				_tmp975_ = _tmp974_;
				vala_ccode_function_add_assignment (_tmp964_, _tmp966_, (ValaCCodeExpression*) _tmp975_);
				_vala_ccode_node_unref0 (_tmp975_);
				_g_free0 (_tmp973_);
				_g_free0 (_tmp971_);
				_vala_ccode_node_unref0 (_tmp966_);
				_tmp976_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp977_ = _tmp976_;
				_tmp978_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp977_);
				_tmp979_ = _tmp978_;
				_tmp980_ = vala_block_get_captured (_tmp979_);
				_tmp981_ = _tmp980_;
				if (_tmp981_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp982_;
					ValaClass* _tmp983_;
					ValaObjectType* _tmp984_;
					ValaObjectType* _tmp985_;
					ValaSourceReference* _tmp986_;
					ValaSourceReference* _tmp987_;
					ValaCCodeExpression* _tmp988_;
					ValaCCodeExpression* _tmp989_;
					ValaCCodeFunctionCall* _tmp990_;
					ValaCCodeFunctionCall* _tmp991_;
					ValaCCodeFunctionCall* _tmp992_;
					ValaCCodeExpression* _tmp993_;
					ValaCCodeExpression* _tmp994_;
					ValaCCodeFunction* _tmp995_;
					ValaCCodeFunction* _tmp996_;
					ValaMethod* _tmp997_;
					ValaMethod* _tmp998_;
					ValaBlock* _tmp999_;
					ValaBlock* _tmp1000_;
					gchar* _tmp1001_;
					gchar* _tmp1002_;
					ValaCCodeExpression* _tmp1003_;
					ValaCCodeExpression* _tmp1004_;
					ValaCCodeMemberAccess* _tmp1005_;
					ValaCCodeMemberAccess* _tmp1006_;
					ValaCCodeFunctionCall* _tmp1007_;
					_tmp982_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp983_ = _tmp982_;
					_tmp984_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp983_);
					_tmp985_ = _tmp984_;
					_tmp986_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp987_ = _tmp986_;
					_tmp988_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp985_, _tmp987_, FALSE);
					_tmp989_ = _tmp988_;
					_tmp990_ = vala_ccode_function_call_new (_tmp989_);
					_tmp991_ = _tmp990_;
					_vala_ccode_node_unref0 (_tmp989_);
					_vala_code_node_unref0 (_tmp985_);
					ref_call = _tmp991_;
					_tmp992_ = ref_call;
					_tmp993_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp994_ = _tmp993_;
					vala_ccode_function_call_add_argument (_tmp992_, _tmp994_);
					_vala_ccode_node_unref0 (_tmp994_);
					_tmp995_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp996_ = _tmp995_;
					_tmp997_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp998_ = _tmp997_;
					_tmp999_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp998_);
					_tmp1000_ = _tmp999_;
					_tmp1001_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp1000_));
					_tmp1002_ = _tmp1001_;
					_tmp1003_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1002_);
					_tmp1004_ = _tmp1003_;
					_tmp1005_ = vala_ccode_member_access_new_pointer (_tmp1004_, "self");
					_tmp1006_ = _tmp1005_;
					_tmp1007_ = ref_call;
					vala_ccode_function_add_assignment (_tmp996_, (ValaCCodeExpression*) _tmp1006_, (ValaCCodeExpression*) _tmp1007_);
					_vala_ccode_node_unref0 (_tmp1006_);
					_vala_ccode_node_unref0 (_tmp1004_);
					_g_free0 (_tmp1002_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp1009_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp1010_ = _tmp1009_;
				_tmp1011_ = vala_class_get_is_compact (_tmp1010_);
				_tmp1012_ = _tmp1011_;
				if (!_tmp1012_) {
					ValaClass* _tmp1013_;
					ValaClass* _tmp1014_;
					_tmp1013_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp1014_ = _tmp1013_;
					_tmp1008_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp1014_);
				} else {
					_tmp1008_ = FALSE;
				}
				if (_tmp1008_) {
					gchar** suffices = NULL;
					gchar* _tmp1015_;
					gchar* _tmp1016_;
					gchar* _tmp1017_;
					gchar** _tmp1018_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp1015_ = g_strdup ("type");
					_tmp1016_ = g_strdup ("dup_func");
					_tmp1017_ = g_strdup ("destroy_func");
					_tmp1018_ = g_new0 (gchar*, 3 + 1);
					_tmp1018_[0] = _tmp1015_;
					_tmp1018_[1] = _tmp1016_;
					_tmp1018_[2] = _tmp1017_;
					suffices = _tmp1018_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp1019_;
						ValaClass* _tmp1020_;
						ValaList* _tmp1021_;
						gint _type_param_size = 0;
						ValaList* _tmp1022_;
						gint _tmp1023_;
						gint _tmp1024_;
						gint _type_param_index = 0;
						_tmp1019_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp1020_ = _tmp1019_;
						_tmp1021_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp1020_);
						_type_param_list = _tmp1021_;
						_tmp1022_ = _type_param_list;
						_tmp1023_ = vala_collection_get_size ((ValaCollection*) _tmp1022_);
						_tmp1024_ = _tmp1023_;
						_type_param_size = _tmp1024_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp1025_;
							gint _tmp1026_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp1027_;
							gpointer _tmp1028_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp1029_;
							ValaCCodeIdentifier* _tmp1030_;
							ValaCCodeMemberAccess* _tmp1031_;
							ValaCCodeMemberAccess* _tmp1032_;
							gchar** _tmp1033_;
							gint _tmp1033__length1;
							_type_param_index = _type_param_index + 1;
							_tmp1025_ = _type_param_index;
							_tmp1026_ = _type_param_size;
							if (!(_tmp1025_ < _tmp1026_)) {
								break;
							}
							_tmp1027_ = _type_param_list;
							_tmp1028_ = vala_list_get (_tmp1027_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp1028_;
							_tmp1029_ = vala_ccode_identifier_new ("self");
							_tmp1030_ = _tmp1029_;
							_tmp1031_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1030_, "priv");
							_tmp1032_ = _tmp1031_;
							_vala_ccode_node_unref0 (_tmp1030_);
							priv_access = _tmp1032_;
							_tmp1033_ = suffices;
							_tmp1033__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1033_;
								suffix_collection_length1 = _tmp1033__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1034_;
									gchar* suffix = NULL;
									_tmp1034_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1034_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1035_;
										const gchar* _tmp1036_;
										const gchar* _tmp1037_;
										gchar* _tmp1038_;
										gchar* _tmp1039_;
										const gchar* _tmp1040_;
										gchar* _tmp1041_;
										gchar* _tmp1042_;
										ValaCCodeIdentifier* _tmp1043_;
										ValaCCodeIdentifier* _tmp1044_;
										ValaCCodeFunction* _tmp1045_;
										ValaCCodeFunction* _tmp1046_;
										ValaCCodeMemberAccess* _tmp1047_;
										ValaCCodeIdentifier* _tmp1048_;
										const gchar* _tmp1049_;
										const gchar* _tmp1050_;
										ValaCCodeMemberAccess* _tmp1051_;
										ValaCCodeMemberAccess* _tmp1052_;
										ValaCCodeIdentifier* _tmp1053_;
										_tmp1035_ = type_param;
										_tmp1036_ = vala_symbol_get_name ((ValaSymbol*) _tmp1035_);
										_tmp1037_ = _tmp1036_;
										_tmp1038_ = g_ascii_strdown (_tmp1037_, (gssize) -1);
										_tmp1039_ = _tmp1038_;
										_tmp1040_ = suffix;
										_tmp1041_ = g_strdup_printf ("%s_%s", _tmp1039_, _tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1043_ = vala_ccode_identifier_new (_tmp1042_);
										_tmp1044_ = _tmp1043_;
										_g_free0 (_tmp1042_);
										_g_free0 (_tmp1039_);
										param_name = _tmp1044_;
										_tmp1045_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1046_ = _tmp1045_;
										_tmp1047_ = priv_access;
										_tmp1048_ = param_name;
										_tmp1049_ = vala_ccode_identifier_get_name (_tmp1048_);
										_tmp1050_ = _tmp1049_;
										_tmp1051_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1047_, _tmp1050_);
										_tmp1052_ = _tmp1051_;
										_tmp1053_ = param_name;
										vala_ccode_function_add_assignment (_tmp1046_, (ValaCCodeExpression*) _tmp1052_, (ValaCCodeExpression*) _tmp1053_);
										_vala_ccode_node_unref0 (_tmp1052_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1054_ = params;
	_tmp1055_ = vala_iterable_iterator ((ValaIterable*) _tmp1054_);
	params_it = _tmp1055_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1056_;
		gint _arg_size = 0;
		ValaList* _tmp1057_;
		gint _tmp1058_;
		gint _tmp1059_;
		gint _arg_index = 0;
		_tmp1056_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp1056_;
		_tmp1057_ = _arg_list;
		_tmp1058_ = vala_collection_get_size ((ValaCollection*) _tmp1057_);
		_tmp1059_ = _tmp1058_;
		_arg_size = _tmp1059_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1060_;
			gint _tmp1061_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1062_;
			gpointer _tmp1063_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1064_;
			ValaCCodeExpression* _tmp1065_;
			ValaCCodeExpression* _tmp1066_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1067_;
			ValaHashMap* _tmp1068_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1069_;
			gboolean _tmp1079_ = FALSE;
			ValaParameter* _tmp1080_;
			gdouble _tmp1424_ = 0.0;
			gboolean _tmp1425_ = FALSE;
			ValaParameter* _tmp1426_;
			ValaHashMap* _tmp1428_;
			ValaCCodeExpression* _tmp1429_;
			gboolean _tmp1430_ = FALSE;
			ValaMethod* _tmp1431_;
			gboolean _tmp1456_ = FALSE;
			ValaExpression* _tmp1457_;
			gint _tmp1474_;
			_arg_index = _arg_index + 1;
			_tmp1060_ = _arg_index;
			_tmp1061_ = _arg_size;
			if (!(_tmp1060_ < _tmp1061_)) {
				break;
			}
			_tmp1062_ = _arg_list;
			_tmp1063_ = vala_list_get (_tmp1062_, _arg_index);
			arg = (ValaExpression*) _tmp1063_;
			_tmp1064_ = arg;
			_tmp1065_ = vala_get_cvalue (_tmp1064_);
			_tmp1066_ = _vala_ccode_node_ref0 (_tmp1065_);
			cexpr = _tmp1066_;
			_tmp1067_ = in_arg_map;
			_tmp1068_ = _vala_map_ref0 (_tmp1067_);
			carg_map = _tmp1068_;
			param = NULL;
			_tmp1069_ = params_it;
			if (vala_iterator_next (_tmp1069_)) {
				ValaIterator* _tmp1070_;
				gpointer _tmp1071_;
				gboolean _tmp1072_ = FALSE;
				ValaParameter* _tmp1073_;
				gboolean _tmp1074_;
				gboolean _tmp1075_;
				_tmp1070_ = params_it;
				_tmp1071_ = vala_iterator_get (_tmp1070_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1071_;
				_tmp1073_ = param;
				_tmp1074_ = vala_parameter_get_params_array (_tmp1073_);
				_tmp1075_ = _tmp1074_;
				if (_tmp1075_) {
					_tmp1072_ = TRUE;
				} else {
					ValaParameter* _tmp1076_;
					gboolean _tmp1077_;
					gboolean _tmp1078_;
					_tmp1076_ = param;
					_tmp1077_ = vala_parameter_get_ellipsis (_tmp1076_);
					_tmp1078_ = _tmp1077_;
					_tmp1072_ = _tmp1078_;
				}
				ellipsis = _tmp1072_;
			}
			_tmp1080_ = param;
			if (_tmp1080_ != NULL) {
				_tmp1079_ = !ellipsis;
			} else {
				_tmp1079_ = FALSE;
			}
			if (_tmp1079_) {
				ValaParameter* _tmp1081_;
				ValaParameterDirection _tmp1082_;
				ValaParameterDirection _tmp1083_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1086_;
				ValaUnaryExpression* _tmp1087_;
				gboolean _tmp1088_ = FALSE;
				ValaUnaryExpression* _tmp1089_;
				ValaParameter* _tmp1354_;
				gchar* _tmp1355_;
				gchar* _tmp1356_;
				gboolean _tmp1357_;
				_tmp1081_ = param;
				_tmp1082_ = vala_parameter_get_direction (_tmp1081_);
				_tmp1083_ = _tmp1082_;
				if (_tmp1083_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1084_;
					ValaHashMap* _tmp1085_;
					_tmp1084_ = out_arg_map;
					_tmp1085_ = _vala_map_ref0 (_tmp1084_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1085_;
				}
				_tmp1086_ = arg;
				_tmp1087_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1086_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1086_) : NULL);
				unary = _tmp1087_;
				_tmp1089_ = unary;
				if (_tmp1089_ == NULL) {
					_tmp1088_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1090_;
					ValaUnaryOperator _tmp1091_;
					ValaUnaryOperator _tmp1092_;
					_tmp1090_ = unary;
					_tmp1091_ = vala_unary_expression_get_operator (_tmp1090_);
					_tmp1092_ = _tmp1091_;
					_tmp1088_ = _tmp1092_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1088_) {
					gboolean _tmp1093_ = FALSE;
					gboolean _tmp1094_ = FALSE;
					ValaParameter* _tmp1095_;
					ValaParameter* _tmp1237_;
					ValaExpression* _tmp1238_;
					ValaCCodeExpression* _tmp1239_;
					ValaCCodeExpression* _tmp1240_;
					_tmp1095_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1095_)) {
						ValaParameter* _tmp1096_;
						ValaDataType* _tmp1097_;
						ValaDataType* _tmp1098_;
						_tmp1096_ = param;
						_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
						_tmp1098_ = _tmp1097_;
						_tmp1094_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1098_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1094_ = FALSE;
					}
					if (_tmp1094_) {
						ValaParameter* _tmp1099_;
						ValaDataType* _tmp1100_;
						ValaDataType* _tmp1101_;
						gboolean _tmp1102_;
						gboolean _tmp1103_;
						_tmp1099_ = param;
						_tmp1100_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1099_);
						_tmp1101_ = _tmp1100_;
						_tmp1102_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1103_ = _tmp1102_;
						_tmp1093_ = !_tmp1103_;
					} else {
						_tmp1093_ = FALSE;
					}
					if (_tmp1093_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1104_;
						ValaDataType* _tmp1105_;
						ValaDataType* _tmp1106_;
						ValaArrayType* _tmp1107_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1108_;
						gchar* _tmp1109_;
						gboolean _tmp1110_ = FALSE;
						ValaUnaryExpression* _tmp1111_;
						_tmp1104_ = param;
						_tmp1105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1104_);
						_tmp1106_ = _tmp1105_;
						_tmp1107_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1106_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1107_;
						_tmp1108_ = param;
						_tmp1109_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1108_);
						length_ctype = _tmp1109_;
						_tmp1111_ = unary;
						if (_tmp1111_ != NULL) {
							ValaUnaryExpression* _tmp1112_;
							ValaUnaryOperator _tmp1113_;
							ValaUnaryOperator _tmp1114_;
							_tmp1112_ = unary;
							_tmp1113_ = vala_unary_expression_get_operator (_tmp1112_);
							_tmp1114_ = _tmp1113_;
							_tmp1110_ = _tmp1114_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1110_ = FALSE;
						}
						if (_tmp1110_) {
							const gchar* _tmp1115_;
							gchar* _tmp1116_;
							_tmp1115_ = length_ctype;
							_tmp1116_ = g_strdup_printf ("%s*", _tmp1115_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1116_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1117_ = FALSE;
								_tmp1117_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1119_;
									gint _tmp1120_;
									gint _tmp1121_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1122_;
									ValaCCodeExpression* _tmp1123_;
									ValaCCodeExpression* _tmp1124_;
									const gchar* _tmp1125_;
									ValaCCodeCastExpression* _tmp1126_;
									ValaCCodeCastExpression* _tmp1127_;
									ValaHashMap* _tmp1128_;
									ValaParameter* _tmp1129_;
									ValaCCodeCastExpression* _tmp1130_;
									if (!_tmp1117_) {
										gint _tmp1118_;
										_tmp1118_ = dim;
										dim = _tmp1118_ + 1;
									}
									_tmp1117_ = FALSE;
									_tmp1119_ = array_type;
									_tmp1120_ = vala_array_type_get_rank (_tmp1119_);
									_tmp1121_ = _tmp1120_;
									if (!(dim <= _tmp1121_)) {
										break;
									}
									_tmp1122_ = arg;
									_tmp1123_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1122_, dim);
									_tmp1124_ = _tmp1123_;
									_tmp1125_ = length_ctype;
									_tmp1126_ = vala_ccode_cast_expression_new (_tmp1124_, _tmp1125_);
									_tmp1127_ = _tmp1126_;
									_vala_ccode_node_unref0 (_tmp1124_);
									array_length_expr = _tmp1127_;
									_tmp1128_ = carg_map;
									_tmp1129_ = param;
									_tmp1130_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1128_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1129_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1130_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1131_ = FALSE;
						ValaParameter* _tmp1132_;
						_tmp1132_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1132_)) {
							ValaParameter* _tmp1133_;
							ValaDataType* _tmp1134_;
							ValaDataType* _tmp1135_;
							_tmp1133_ = param;
							_tmp1134_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1133_);
							_tmp1135_ = _tmp1134_;
							_tmp1131_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1135_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1131_ = FALSE;
						}
						if (_tmp1131_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1136_;
							ValaDataType* _tmp1137_;
							ValaDataType* _tmp1138_;
							ValaDelegateType* _tmp1139_;
							ValaDelegateType* _tmp1140_;
							ValaDelegate* _tmp1141_;
							ValaDelegate* _tmp1142_;
							gboolean _tmp1143_;
							gboolean _tmp1144_;
							_tmp1136_ = param;
							_tmp1137_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1136_);
							_tmp1138_ = _tmp1137_;
							_tmp1139_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1138_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1139_;
							_tmp1140_ = deleg_type;
							_tmp1141_ = vala_delegate_type_get_delegate_symbol (_tmp1140_);
							_tmp1142_ = _tmp1141_;
							_tmp1143_ = vala_delegate_get_has_target (_tmp1142_);
							_tmp1144_ = _tmp1143_;
							if (_tmp1144_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1145_;
								ValaCCodeExpression* _tmp1146_ = NULL;
								ValaCCodeExpression* _tmp1147_;
								ValaCCodeExpression* _tmp1148_;
								ValaParameter* _tmp1149_;
								gchar* _tmp1150_;
								gchar* _tmp1151_;
								gboolean _tmp1152_;
								_tmp1145_ = arg;
								_tmp1147_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1145_, &_tmp1146_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1146_;
								delegate_target = _tmp1147_;
								_tmp1148_ = delegate_target;
								_vala_assert (_tmp1148_ != NULL, "delegate_target != null");
								_tmp1149_ = param;
								_tmp1150_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1149_);
								_tmp1151_ = _tmp1150_;
								_tmp1152_ = g_strcmp0 (_tmp1151_, "GClosure*") == 0;
								_g_free0 (_tmp1151_);
								if (_tmp1152_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1153_;
									ValaCCodeIdentifier* _tmp1154_;
									ValaCCodeFunctionCall* _tmp1155_;
									ValaCCodeFunctionCall* _tmp1156_;
									ValaCCodeFunctionCall* _tmp1157_;
									ValaCCodeExpression* _tmp1158_;
									ValaCCodeCastExpression* _tmp1159_;
									ValaCCodeCastExpression* _tmp1160_;
									ValaCCodeFunctionCall* _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaCCodeFunctionCall* _tmp1163_;
									ValaCCodeExpression* _tmp1164_;
									ValaCCodeCastExpression* _tmp1165_;
									ValaCCodeCastExpression* _tmp1166_;
									ValaCCodeExpression* _tmp1167_;
									ValaCCodeConstant* _tmp1168_;
									ValaCCodeConstant* _tmp1169_;
									ValaCCodeBinaryExpression* _tmp1170_;
									ValaCCodeBinaryExpression* _tmp1171_;
									ValaCCodeConstant* _tmp1172_;
									ValaCCodeConstant* _tmp1173_;
									ValaCCodeFunctionCall* _tmp1174_;
									ValaCCodeConditionalExpression* _tmp1175_;
									_tmp1153_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1154_ = _tmp1153_;
									_tmp1155_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1154_);
									_tmp1156_ = _tmp1155_;
									_vala_ccode_node_unref0 (_tmp1154_);
									closure_new = _tmp1156_;
									_tmp1157_ = closure_new;
									_tmp1158_ = cexpr;
									_tmp1159_ = vala_ccode_cast_expression_new (_tmp1158_, "GCallback");
									_tmp1160_ = _tmp1159_;
									vala_ccode_function_call_add_argument (_tmp1157_, (ValaCCodeExpression*) _tmp1160_);
									_vala_ccode_node_unref0 (_tmp1160_);
									_tmp1161_ = closure_new;
									_tmp1162_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1161_, _tmp1162_);
									_tmp1163_ = closure_new;
									_tmp1164_ = delegate_target_destroy_notify;
									_tmp1165_ = vala_ccode_cast_expression_new (_tmp1164_, "GClosureNotify");
									_tmp1166_ = _tmp1165_;
									vala_ccode_function_call_add_argument (_tmp1163_, (ValaCCodeExpression*) _tmp1166_);
									_vala_ccode_node_unref0 (_tmp1166_);
									_tmp1167_ = cexpr;
									_tmp1168_ = vala_ccode_constant_new ("NULL");
									_tmp1169_ = _tmp1168_;
									_tmp1170_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1167_, (ValaCCodeExpression*) _tmp1169_);
									_tmp1171_ = _tmp1170_;
									_tmp1172_ = vala_ccode_constant_new ("NULL");
									_tmp1173_ = _tmp1172_;
									_tmp1174_ = closure_new;
									_tmp1175_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1171_, (ValaCCodeExpression*) _tmp1173_, (ValaCCodeExpression*) _tmp1174_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1175_;
									_vala_ccode_node_unref0 (_tmp1173_);
									_vala_ccode_node_unref0 (_tmp1171_);
									_vala_ccode_node_unref0 (_tmp1169_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1176_;
									ValaParameter* _tmp1177_;
									gpointer _tmp1178_;
									gboolean _tmp1179_ = FALSE;
									ValaCCodeExpression* _tmp1180_;
									_tmp1176_ = carg_map;
									_tmp1177_ = param;
									_tmp1178_ = vala_map_get ((ValaMap*) _tmp1176_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1177_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1178_;
									_tmp1180_ = node;
									if (_tmp1180_ == NULL) {
										_tmp1179_ = TRUE;
									} else {
										gboolean _tmp1181_ = FALSE;
										ValaCCodeExpression* _tmp1182_;
										_tmp1182_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1182_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1183_;
											const gchar* _tmp1184_;
											const gchar* _tmp1185_;
											_tmp1183_ = node;
											_tmp1184_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1183_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1185_ = _tmp1184_;
											_tmp1181_ = g_strcmp0 (_tmp1185_, "NULL") == 0;
										} else {
											_tmp1181_ = FALSE;
										}
										_tmp1179_ = _tmp1181_;
									}
									if (_tmp1179_) {
										ValaHashMap* _tmp1186_;
										ValaParameter* _tmp1187_;
										ValaCCodeExpression* _tmp1188_;
										ValaDelegateType* _tmp1189_;
										_tmp1186_ = carg_map;
										_tmp1187_ = param;
										_tmp1188_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1186_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1187_), FALSE)), _tmp1188_);
										_tmp1189_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1189_)) {
											ValaCCodeExpression* _tmp1190_;
											ValaHashMap* _tmp1191_;
											ValaParameter* _tmp1192_;
											ValaCCodeExpression* _tmp1193_;
											_tmp1190_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1190_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1191_ = carg_map;
											_tmp1192_ = param;
											_tmp1193_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1191_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1192_), FALSE)), _tmp1193_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1194_;
							ValaDataType* _tmp1195_;
							ValaDataType* _tmp1196_;
							_tmp1194_ = param;
							_tmp1195_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1194_);
							_tmp1196_ = _tmp1195_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1196_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1197_;
								ValaParameter* _tmp1198_;
								ValaExpression* _tmp1199_;
								ValaCCodeExpression* _tmp1200_ = NULL;
								ValaCCodeExpression* _tmp1201_;
								ValaCCodeExpression* _tmp1202_;
								_tmp1197_ = carg_map;
								_tmp1198_ = param;
								_tmp1199_ = arg;
								_tmp1201_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1199_, &_tmp1200_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1200_;
								_tmp1202_ = _tmp1201_;
								vala_map_set ((ValaMap*) _tmp1197_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1198_), FALSE)), _tmp1202_);
								_vala_ccode_node_unref0 (_tmp1202_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1203_;
								ValaDataType* _tmp1204_;
								ValaDataType* _tmp1205_;
								_tmp1203_ = param;
								_tmp1204_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1203_);
								_tmp1205_ = _tmp1204_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1205_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1206_ = FALSE;
									ValaMethod* _tmp1207_;
									_tmp1207_ = m;
									if (_tmp1207_ != NULL) {
										ValaMethod* _tmp1208_;
										_tmp1208_ = m;
										_tmp1206_ = vala_get_ccode_simple_generics (_tmp1208_);
									} else {
										_tmp1206_ = FALSE;
									}
									if (_tmp1206_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1209_;
										ValaDataType* _tmp1210_;
										ValaDataType* _tmp1211_;
										ValaGenericType* _tmp1212_;
										gint type_param_index = 0;
										ValaMethod* _tmp1213_;
										ValaGenericType* _tmp1214_;
										ValaTypeParameter* _tmp1215_;
										ValaTypeParameter* _tmp1216_;
										const gchar* _tmp1217_;
										const gchar* _tmp1218_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1219_;
										ValaList* _tmp1220_;
										gpointer _tmp1221_;
										ValaParameter* _tmp1222_;
										ValaDataType* _tmp1223_;
										ValaDataType* _tmp1224_;
										gboolean _tmp1225_;
										gboolean _tmp1226_;
										_tmp1209_ = param;
										_tmp1210_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1209_);
										_tmp1211_ = _tmp1210_;
										_tmp1212_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1211_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1212_;
										_tmp1213_ = m;
										_tmp1214_ = generic_type;
										_tmp1215_ = vala_generic_type_get_type_parameter (_tmp1214_);
										_tmp1216_ = _tmp1215_;
										_tmp1217_ = vala_symbol_get_name ((ValaSymbol*) _tmp1216_);
										_tmp1218_ = _tmp1217_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1213_, _tmp1218_);
										_tmp1219_ = ma;
										_tmp1220_ = vala_member_access_get_type_arguments (_tmp1219_);
										_tmp1221_ = vala_list_get (_tmp1220_, type_param_index);
										type_arg = (ValaDataType*) _tmp1221_;
										_tmp1222_ = param;
										_tmp1223_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1222_);
										_tmp1224_ = _tmp1223_;
										_tmp1225_ = vala_data_type_get_value_owned (_tmp1224_);
										_tmp1226_ = _tmp1225_;
										if (_tmp1226_) {
											ValaDataType* _tmp1227_;
											_tmp1227_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1227_)) {
												ValaHashMap* _tmp1228_;
												ValaParameter* _tmp1229_;
												ValaDataType* _tmp1230_;
												ValaCCodeExpression* _tmp1231_;
												ValaCCodeExpression* _tmp1232_;
												_tmp1228_ = carg_map;
												_tmp1229_ = param;
												_tmp1230_ = type_arg;
												_tmp1231_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1230_, FALSE);
												_tmp1232_ = _tmp1231_;
												vala_map_set ((ValaMap*) _tmp1228_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1229_), FALSE)), _tmp1232_);
												_vala_ccode_node_unref0 (_tmp1232_);
											} else {
												ValaHashMap* _tmp1233_;
												ValaParameter* _tmp1234_;
												ValaCCodeConstant* _tmp1235_;
												ValaCCodeConstant* _tmp1236_;
												_tmp1233_ = carg_map;
												_tmp1234_ = param;
												_tmp1235_ = vala_ccode_constant_new ("NULL");
												_tmp1236_ = _tmp1235_;
												vala_map_set ((ValaMap*) _tmp1233_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1234_), FALSE)), (ValaCCodeExpression*) _tmp1236_);
												_vala_ccode_node_unref0 (_tmp1236_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1237_ = param;
					_tmp1238_ = arg;
					_tmp1239_ = cexpr;
					_tmp1240_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1237_, _tmp1238_, _tmp1239_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1240_;
				} else {
					ValaExpression* _tmp1241_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1242_;
					ValaDataType* _tmp1243_;
					ValaDataType* _tmp1244_;
					ValaParameter* _tmp1245_;
					ValaDataType* _tmp1246_;
					ValaDataType* _tmp1247_;
					gboolean _tmp1248_;
					gboolean _tmp1249_;
					ValaLocalVariable* _tmp1250_;
					ValaLocalVariable* _tmp1251_;
					ValaExpression* _tmp1252_;
					ValaLocalVariable* _tmp1253_;
					const gchar* _tmp1254_;
					const gchar* _tmp1255_;
					ValaCCodeExpression* _tmp1256_;
					ValaCCodeExpression* _tmp1257_;
					ValaExpression* _tmp1258_;
					ValaTargetValue* _tmp1259_;
					ValaTargetValue* _tmp1260_;
					ValaExpression* _tmp1261_;
					ValaDataType* _tmp1262_;
					ValaDataType* _tmp1263_;
					ValaExpression* _tmp1264_;
					ValaCCodeExpression* _tmp1265_;
					ValaCCodeUnaryExpression* _tmp1266_;
					gboolean _tmp1267_ = FALSE;
					gboolean _tmp1268_ = FALSE;
					ValaParameter* _tmp1269_;
					_tmp1241_ = arg;
					vala_expression_set_target_value (_tmp1241_, NULL);
					_tmp1242_ = param;
					_tmp1243_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1242_);
					_tmp1244_ = _tmp1243_;
					_tmp1245_ = param;
					_tmp1246_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1245_);
					_tmp1247_ = _tmp1246_;
					_tmp1248_ = vala_data_type_get_value_owned (_tmp1247_);
					_tmp1249_ = _tmp1248_;
					_tmp1250_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1244_, _tmp1249_, NULL, TRUE);
					temp_var = _tmp1250_;
					_tmp1251_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1251_, FALSE);
					_tmp1252_ = arg;
					_tmp1253_ = temp_var;
					_tmp1254_ = vala_symbol_get_name ((ValaSymbol*) _tmp1253_);
					_tmp1255_ = _tmp1254_;
					_tmp1256_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1255_);
					_tmp1257_ = _tmp1256_;
					vala_set_cvalue (_tmp1252_, _tmp1257_);
					_vala_ccode_node_unref0 (_tmp1257_);
					_tmp1258_ = arg;
					_tmp1259_ = vala_expression_get_target_value (_tmp1258_);
					_tmp1260_ = _tmp1259_;
					_tmp1261_ = arg;
					_tmp1262_ = vala_expression_get_target_type (_tmp1261_);
					_tmp1263_ = _tmp1262_;
					vala_target_value_set_value_type (_tmp1260_, _tmp1263_);
					_tmp1264_ = arg;
					_tmp1265_ = vala_get_cvalue (_tmp1264_);
					_tmp1266_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1265_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1266_;
					_tmp1269_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1269_)) {
						ValaParameter* _tmp1270_;
						ValaDataType* _tmp1271_;
						ValaDataType* _tmp1272_;
						_tmp1270_ = param;
						_tmp1271_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1270_);
						_tmp1272_ = _tmp1271_;
						_tmp1268_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1272_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1268_ = FALSE;
					}
					if (_tmp1268_) {
						ValaParameter* _tmp1273_;
						ValaDataType* _tmp1274_;
						ValaDataType* _tmp1275_;
						gboolean _tmp1276_;
						gboolean _tmp1277_;
						_tmp1273_ = param;
						_tmp1274_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1273_);
						_tmp1275_ = _tmp1274_;
						_tmp1276_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1275_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1277_ = _tmp1276_;
						_tmp1267_ = !_tmp1277_;
					} else {
						_tmp1267_ = FALSE;
					}
					if (_tmp1267_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1278_;
						ValaDataType* _tmp1279_;
						ValaDataType* _tmp1280_;
						ValaArrayType* _tmp1281_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1282_;
						gchar* _tmp1283_;
						_tmp1278_ = param;
						_tmp1279_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1278_);
						_tmp1280_ = _tmp1279_;
						_tmp1281_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1280_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1281_;
						_tmp1282_ = param;
						_tmp1283_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1282_);
						length_ctype = _tmp1283_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1284_ = FALSE;
								_tmp1284_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1286_;
									gint _tmp1287_;
									gint _tmp1288_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1289_;
									ValaCType* _tmp1290_;
									ValaCType* _tmp1291_;
									ValaLocalVariable* _tmp1292_;
									ValaLocalVariable* _tmp1293_;
									ValaLocalVariable* _tmp1294_;
									ValaExpression* _tmp1295_;
									ValaLocalVariable* _tmp1296_;
									const gchar* _tmp1297_;
									const gchar* _tmp1298_;
									ValaCCodeExpression* _tmp1299_;
									ValaCCodeExpression* _tmp1300_;
									ValaHashMap* _tmp1301_;
									ValaParameter* _tmp1302_;
									ValaExpression* _tmp1303_;
									ValaList* _tmp1304_;
									gpointer _tmp1305_;
									ValaCCodeExpression* _tmp1306_;
									ValaCCodeUnaryExpression* _tmp1307_;
									ValaCCodeUnaryExpression* _tmp1308_;
									if (!_tmp1284_) {
										gint _tmp1285_;
										_tmp1285_ = dim;
										dim = _tmp1285_ + 1;
									}
									_tmp1284_ = FALSE;
									_tmp1286_ = array_type;
									_tmp1287_ = vala_array_type_get_rank (_tmp1286_);
									_tmp1288_ = _tmp1287_;
									if (!(dim <= _tmp1288_)) {
										break;
									}
									_tmp1289_ = length_ctype;
									_tmp1290_ = vala_ctype_new (_tmp1289_, "0");
									_tmp1291_ = _tmp1290_;
									_tmp1292_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1291_, TRUE, NULL, TRUE);
									_tmp1293_ = _tmp1292_;
									_vala_code_node_unref0 (_tmp1291_);
									temp_array_length = _tmp1293_;
									_tmp1294_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1294_, FALSE);
									_tmp1295_ = arg;
									_tmp1296_ = temp_array_length;
									_tmp1297_ = vala_symbol_get_name ((ValaSymbol*) _tmp1296_);
									_tmp1298_ = _tmp1297_;
									_tmp1299_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1298_);
									_tmp1300_ = _tmp1299_;
									vala_append_array_length (_tmp1295_, _tmp1300_);
									_vala_ccode_node_unref0 (_tmp1300_);
									_tmp1301_ = carg_map;
									_tmp1302_ = param;
									_tmp1303_ = arg;
									_tmp1304_ = vala_get_array_lengths (_tmp1303_);
									_tmp1305_ = vala_list_get (_tmp1304_, dim - 1);
									_tmp1306_ = (ValaCCodeExpression*) _tmp1305_;
									_tmp1307_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1306_);
									_tmp1308_ = _tmp1307_;
									vala_map_set ((ValaMap*) _tmp1301_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1302_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1308_);
									_vala_ccode_node_unref0 (_tmp1308_);
									_vala_ccode_node_unref0 (_tmp1306_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1309_ = FALSE;
						ValaParameter* _tmp1310_;
						_tmp1310_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1310_)) {
							ValaParameter* _tmp1311_;
							ValaDataType* _tmp1312_;
							ValaDataType* _tmp1313_;
							_tmp1311_ = param;
							_tmp1312_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1311_);
							_tmp1313_ = _tmp1312_;
							_tmp1309_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1313_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1309_ = FALSE;
						}
						if (_tmp1309_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1314_;
							ValaDataType* _tmp1315_;
							ValaDataType* _tmp1316_;
							ValaDelegateType* _tmp1317_;
							ValaDelegateType* _tmp1318_;
							ValaDelegate* _tmp1319_;
							ValaDelegate* _tmp1320_;
							gboolean _tmp1321_;
							gboolean _tmp1322_;
							_tmp1314_ = param;
							_tmp1315_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1314_);
							_tmp1316_ = _tmp1315_;
							_tmp1317_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1316_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1317_;
							_tmp1318_ = deleg_type;
							_tmp1319_ = vala_delegate_type_get_delegate_symbol (_tmp1318_);
							_tmp1320_ = _tmp1319_;
							_tmp1321_ = vala_delegate_get_has_target (_tmp1320_);
							_tmp1322_ = _tmp1321_;
							if (_tmp1322_) {
								ValaDataType* _tmp1323_;
								ValaLocalVariable* _tmp1324_;
								ValaLocalVariable* _tmp1325_;
								ValaExpression* _tmp1326_;
								ValaLocalVariable* _tmp1327_;
								const gchar* _tmp1328_;
								const gchar* _tmp1329_;
								ValaCCodeExpression* _tmp1330_;
								ValaCCodeExpression* _tmp1331_;
								ValaHashMap* _tmp1332_;
								ValaParameter* _tmp1333_;
								ValaExpression* _tmp1334_;
								ValaCCodeExpression* _tmp1335_;
								ValaCCodeUnaryExpression* _tmp1336_;
								ValaCCodeUnaryExpression* _tmp1337_;
								ValaDelegateType* _tmp1338_;
								_tmp1323_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1324_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1323_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1324_;
								_tmp1325_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1325_, FALSE);
								_tmp1326_ = arg;
								_tmp1327_ = temp_var;
								_tmp1328_ = vala_symbol_get_name ((ValaSymbol*) _tmp1327_);
								_tmp1329_ = _tmp1328_;
								_tmp1330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1329_);
								_tmp1331_ = _tmp1330_;
								vala_set_delegate_target (_tmp1326_, _tmp1331_);
								_vala_ccode_node_unref0 (_tmp1331_);
								_tmp1332_ = carg_map;
								_tmp1333_ = param;
								_tmp1334_ = arg;
								_tmp1335_ = vala_get_delegate_target (_tmp1334_);
								_tmp1336_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1335_);
								_tmp1337_ = _tmp1336_;
								vala_map_set ((ValaMap*) _tmp1332_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1333_), FALSE)), (ValaCCodeExpression*) _tmp1337_);
								_vala_ccode_node_unref0 (_tmp1337_);
								_tmp1338_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1338_)) {
									ValaDelegateType* _tmp1339_;
									ValaLocalVariable* _tmp1340_;
									ValaLocalVariable* _tmp1341_;
									ValaExpression* _tmp1342_;
									ValaLocalVariable* _tmp1343_;
									const gchar* _tmp1344_;
									const gchar* _tmp1345_;
									ValaCCodeExpression* _tmp1346_;
									ValaCCodeExpression* _tmp1347_;
									ValaHashMap* _tmp1348_;
									ValaParameter* _tmp1349_;
									ValaExpression* _tmp1350_;
									ValaCCodeExpression* _tmp1351_;
									ValaCCodeUnaryExpression* _tmp1352_;
									ValaCCodeUnaryExpression* _tmp1353_;
									_tmp1339_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1340_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1339_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1340_;
									_tmp1341_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1341_, FALSE);
									_tmp1342_ = arg;
									_tmp1343_ = temp_var;
									_tmp1344_ = vala_symbol_get_name ((ValaSymbol*) _tmp1343_);
									_tmp1345_ = _tmp1344_;
									_tmp1346_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1345_);
									_tmp1347_ = _tmp1346_;
									vala_set_delegate_target_destroy_notify (_tmp1342_, _tmp1347_);
									_vala_ccode_node_unref0 (_tmp1347_);
									_tmp1348_ = carg_map;
									_tmp1349_ = param;
									_tmp1350_ = arg;
									_tmp1351_ = vala_get_delegate_target_destroy_notify (_tmp1350_);
									_tmp1352_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1351_);
									_tmp1353_ = _tmp1352_;
									vala_map_set ((ValaMap*) _tmp1348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1349_), FALSE)), (ValaCCodeExpression*) _tmp1353_);
									_vala_ccode_node_unref0 (_tmp1353_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1354_ = param;
				_tmp1355_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1354_);
				_tmp1356_ = _tmp1355_;
				_tmp1357_ = _tmp1356_ != NULL;
				_g_free0 (_tmp1356_);
				if (_tmp1357_) {
					ValaCCodeExpression* _tmp1358_;
					ValaParameter* _tmp1359_;
					gchar* _tmp1360_;
					gchar* _tmp1361_;
					ValaCCodeCastExpression* _tmp1362_;
					_tmp1358_ = cexpr;
					_tmp1359_ = param;
					_tmp1360_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1359_);
					_tmp1361_ = _tmp1360_;
					_tmp1362_ = vala_ccode_cast_expression_new (_tmp1358_, _tmp1361_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1362_;
					_g_free0 (_tmp1361_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1363_;
				ValaUnaryExpression* _tmp1364_;
				gboolean _tmp1365_ = FALSE;
				gboolean _tmp1366_ = FALSE;
				_tmp1363_ = arg;
				_tmp1364_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1363_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1363_) : NULL);
				unary = _tmp1364_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1367_;
					_tmp1367_ = unary;
					_tmp1366_ = _tmp1367_ != NULL;
				} else {
					_tmp1366_ = FALSE;
				}
				if (_tmp1366_) {
					ValaUnaryExpression* _tmp1368_;
					ValaUnaryOperator _tmp1369_;
					ValaUnaryOperator _tmp1370_;
					_tmp1368_ = unary;
					_tmp1369_ = vala_unary_expression_get_operator (_tmp1368_);
					_tmp1370_ = _tmp1369_;
					_tmp1365_ = _tmp1370_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1365_ = FALSE;
				}
				if (_tmp1365_) {
					ValaHashMap* _tmp1371_;
					ValaHashMap* _tmp1372_;
					ValaExpression* _tmp1373_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1374_;
					ValaDataType* _tmp1375_;
					ValaDataType* _tmp1376_;
					ValaExpression* _tmp1377_;
					ValaDataType* _tmp1378_;
					ValaDataType* _tmp1379_;
					gboolean _tmp1380_;
					gboolean _tmp1381_;
					ValaLocalVariable* _tmp1382_;
					ValaLocalVariable* _tmp1383_;
					ValaExpression* _tmp1384_;
					ValaLocalVariable* _tmp1385_;
					const gchar* _tmp1386_;
					const gchar* _tmp1387_;
					ValaCCodeExpression* _tmp1388_;
					ValaCCodeExpression* _tmp1389_;
					ValaExpression* _tmp1390_;
					ValaTargetValue* _tmp1391_;
					ValaTargetValue* _tmp1392_;
					ValaExpression* _tmp1393_;
					ValaDataType* _tmp1394_;
					ValaDataType* _tmp1395_;
					gboolean _tmp1396_ = FALSE;
					ValaExpression* _tmp1397_;
					ValaDataType* _tmp1398_;
					ValaDataType* _tmp1399_;
					ValaExpression* _tmp1418_;
					ValaCCodeExpression* _tmp1419_;
					ValaCCodeUnaryExpression* _tmp1420_;
					_tmp1371_ = out_arg_map;
					_tmp1372_ = _vala_map_ref0 (_tmp1371_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1372_;
					_tmp1373_ = arg;
					vala_expression_set_target_value (_tmp1373_, NULL);
					_tmp1374_ = arg;
					_tmp1375_ = vala_expression_get_value_type (_tmp1374_);
					_tmp1376_ = _tmp1375_;
					_tmp1377_ = arg;
					_tmp1378_ = vala_expression_get_value_type (_tmp1377_);
					_tmp1379_ = _tmp1378_;
					_tmp1380_ = vala_data_type_get_value_owned (_tmp1379_);
					_tmp1381_ = _tmp1380_;
					_tmp1382_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1376_, _tmp1381_, NULL, TRUE);
					temp_var = _tmp1382_;
					_tmp1383_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1383_, FALSE);
					_tmp1384_ = arg;
					_tmp1385_ = temp_var;
					_tmp1386_ = vala_symbol_get_name ((ValaSymbol*) _tmp1385_);
					_tmp1387_ = _tmp1386_;
					_tmp1388_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1387_);
					_tmp1389_ = _tmp1388_;
					vala_set_cvalue (_tmp1384_, _tmp1389_);
					_vala_ccode_node_unref0 (_tmp1389_);
					_tmp1390_ = arg;
					_tmp1391_ = vala_expression_get_target_value (_tmp1390_);
					_tmp1392_ = _tmp1391_;
					_tmp1393_ = arg;
					_tmp1394_ = vala_expression_get_value_type (_tmp1393_);
					_tmp1395_ = _tmp1394_;
					vala_target_value_set_value_type (_tmp1392_, _tmp1395_);
					_tmp1397_ = arg;
					_tmp1398_ = vala_expression_get_value_type (_tmp1397_);
					_tmp1399_ = _tmp1398_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1399_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1400_;
						ValaDataType* _tmp1401_;
						ValaDataType* _tmp1402_;
						ValaDelegate* _tmp1403_;
						ValaDelegate* _tmp1404_;
						gboolean _tmp1405_;
						gboolean _tmp1406_;
						_tmp1400_ = arg;
						_tmp1401_ = vala_expression_get_value_type (_tmp1400_);
						_tmp1402_ = _tmp1401_;
						_tmp1403_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1402_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1404_ = _tmp1403_;
						_tmp1405_ = vala_delegate_get_has_target (_tmp1404_);
						_tmp1406_ = _tmp1405_;
						_tmp1396_ = _tmp1406_;
					} else {
						_tmp1396_ = FALSE;
					}
					if (_tmp1396_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1407_;
						ValaTargetValue* _tmp1408_;
						ValaTargetValue* _tmp1409_;
						ValaGLibValue* _tmp1410_;
						ValaCCodeExpression* _tmp1411_;
						ValaGLibValue* _tmp1414_;
						ValaCCodeExpression* _tmp1415_;
						_tmp1407_ = arg;
						_tmp1408_ = vala_expression_get_target_value (_tmp1407_);
						_tmp1409_ = _tmp1408_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1409_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1410_ = arg_value;
						_tmp1411_ = _tmp1410_->delegate_target_cvalue;
						if (_tmp1411_ == NULL) {
							ValaGLibValue* _tmp1412_;
							ValaCCodeConstant* _tmp1413_;
							_tmp1412_ = arg_value;
							_tmp1413_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1412_->delegate_target_cvalue);
							_tmp1412_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1413_;
						}
						_tmp1414_ = arg_value;
						_tmp1415_ = _tmp1414_->delegate_target_destroy_notify_cvalue;
						if (_tmp1415_ == NULL) {
							ValaGLibValue* _tmp1416_;
							ValaCCodeConstant* _tmp1417_;
							_tmp1416_ = arg_value;
							_tmp1417_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1416_->delegate_target_destroy_notify_cvalue);
							_tmp1416_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1417_;
						}
					}
					_tmp1418_ = arg;
					_tmp1419_ = vala_get_cvalue (_tmp1418_);
					_tmp1420_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1419_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1420_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1421_;
					ValaCCodeExpression* _tmp1422_;
					ValaCCodeExpression* _tmp1423_;
					_tmp1421_ = arg;
					_tmp1422_ = cexpr;
					_tmp1423_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1421_, _tmp1422_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1423_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1426_ = param;
			if (_tmp1426_ != NULL) {
				_tmp1425_ = !ellipsis;
			} else {
				_tmp1425_ = FALSE;
			}
			if (_tmp1425_) {
				ValaParameter* _tmp1427_;
				_tmp1427_ = param;
				_tmp1424_ = vala_get_ccode_pos (_tmp1427_);
			} else {
				_tmp1424_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1424_, ellipsis);
			_tmp1428_ = carg_map;
			_tmp1429_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1428_, (gpointer) ((gintptr) arg_pos), _tmp1429_);
			_tmp1431_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1431_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1432_;
				ValaCodeContext* _tmp1433_;
				ValaProfile _tmp1434_;
				ValaProfile _tmp1435_;
				_tmp1432_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1433_ = _tmp1432_;
				_tmp1434_ = vala_code_context_get_profile (_tmp1433_);
				_tmp1435_ = _tmp1434_;
				_tmp1430_ = _tmp1435_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1430_ = FALSE;
			}
			if (_tmp1430_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1436_;
				ValaExpression* _tmp1437_;
				ValaExpression* _tmp1438_;
				ValaDataType* _tmp1439_;
				ValaDataType* _tmp1440_;
				ValaDataType* _tmp1441_;
				ValaDataType* _tmp1442_;
				gchar* _tmp1443_;
				gchar* _tmp1444_;
				gchar* _tmp1445_;
				gchar* _tmp1446_;
				ValaCCodeIdentifier* _tmp1447_;
				ValaCCodeIdentifier* _tmp1448_;
				ValaHashMap* _tmp1449_;
				ValaCCodeIdentifier* _tmp1450_;
				ValaCCodeExpression* _tmp1451_;
				ValaCCodeBinaryExpression* _tmp1452_;
				ValaCCodeBinaryExpression* _tmp1453_;
				_tmp1436_ = ma;
				_tmp1437_ = vala_member_access_get_inner (_tmp1436_);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = vala_expression_get_value_type (_tmp1438_);
				_tmp1440_ = _tmp1439_;
				_tmp1441_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1440_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1442_);
				_tmp1444_ = _tmp1443_;
				_tmp1445_ = g_strdup_printf ("sizeof (%s)", _tmp1444_);
				_tmp1446_ = _tmp1445_;
				_tmp1447_ = vala_ccode_identifier_new (_tmp1446_);
				_tmp1448_ = _tmp1447_;
				_g_free0 (_tmp1446_);
				_g_free0 (_tmp1444_);
				csizeof = _tmp1448_;
				_tmp1449_ = carg_map;
				_tmp1450_ = csizeof;
				_tmp1451_ = cexpr;
				_tmp1452_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1450_, _tmp1451_);
				_tmp1453_ = _tmp1452_;
				vala_map_set ((ValaMap*) _tmp1449_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1453_);
				_vala_ccode_node_unref0 (_tmp1453_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1454_;
				ValaCCodeExpression* _tmp1455_;
				_tmp1454_ = carg_map;
				_tmp1455_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1454_, (gpointer) ((gintptr) arg_pos), _tmp1455_);
			}
			_tmp1457_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1457_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1456_ = ellipsis;
			} else {
				_tmp1456_ = FALSE;
			}
			if (_tmp1456_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1458_;
				ValaNamedArgument* _tmp1459_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1460_;
				const gchar* _tmp1461_;
				const gchar* _tmp1462_;
				gchar** _tmp1463_;
				gchar** _tmp1464_;
				gchar** _tmp1465_;
				gint _tmp1465__length1;
				gchar* _tmp1466_;
				gchar* _tmp1467_;
				ValaHashMap* _tmp1468_;
				const gchar* _tmp1469_;
				gchar* _tmp1470_;
				gchar* _tmp1471_;
				ValaCCodeConstant* _tmp1472_;
				ValaCCodeConstant* _tmp1473_;
				_tmp1458_ = arg;
				_tmp1459_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1458_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1459_;
				_tmp1460_ = named_arg;
				_tmp1461_ = vala_named_argument_get_name (_tmp1460_);
				_tmp1462_ = _tmp1461_;
				_tmp1464_ = _tmp1463_ = g_strsplit (_tmp1462_, "_", 0);
				_tmp1465_ = _tmp1464_;
				_tmp1465__length1 = _vala_array_length (_tmp1463_);
				_tmp1466_ = _vala_g_strjoinv ("-", _tmp1465_, (gint) _vala_array_length (_tmp1463_));
				_tmp1467_ = _tmp1466_;
				_tmp1465_ = (_vala_array_free (_tmp1465_, _tmp1465__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1467_;
				_tmp1468_ = carg_map;
				_tmp1469_ = name;
				_tmp1470_ = g_strdup_printf ("\"%s\"", _tmp1469_);
				_tmp1471_ = _tmp1470_;
				_tmp1472_ = vala_ccode_constant_new (_tmp1471_);
				_tmp1473_ = _tmp1472_;
				vala_map_set ((ValaMap*) _tmp1468_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1473_);
				_vala_ccode_node_unref0 (_tmp1473_);
				_g_free0 (_tmp1471_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1474_ = i;
			i = _tmp1474_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp1475_ = params_it;
	if (vala_iterator_next (_tmp1475_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1476_;
		gpointer _tmp1477_;
		gboolean _tmp1478_ = FALSE;
		ValaParameter* _tmp1479_;
		gboolean _tmp1480_;
		gboolean _tmp1481_;
		_tmp1476_ = params_it;
		_tmp1477_ = vala_iterator_get (_tmp1476_);
		param = (ValaParameter*) _tmp1477_;
		_tmp1479_ = param;
		_tmp1480_ = vala_parameter_get_params_array (_tmp1479_);
		_tmp1481_ = _tmp1480_;
		if (_tmp1481_) {
			_tmp1478_ = TRUE;
		} else {
			ValaParameter* _tmp1482_;
			gboolean _tmp1483_;
			gboolean _tmp1484_;
			_tmp1482_ = param;
			_tmp1483_ = vala_parameter_get_ellipsis (_tmp1482_);
			_tmp1484_ = _tmp1483_;
			_tmp1478_ = _tmp1484_;
		}
		_vala_assert (_tmp1478_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1487_ = m;
	if (_tmp1487_ != NULL) {
		ValaMethod* _tmp1488_;
		ValaDataType* _tmp1489_;
		ValaDataType* _tmp1490_;
		_tmp1488_ = m;
		_tmp1489_ = vala_callable_get_return_type ((ValaCallable*) _tmp1488_);
		_tmp1490_ = _tmp1489_;
		_tmp1486_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1490_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1486_ = FALSE;
	}
	if (_tmp1486_) {
		ValaCCodeFunctionCall* _tmp1491_;
		ValaCCodeFunctionCall* _tmp1492_;
		_tmp1491_ = async_call;
		_tmp1492_ = ccall;
		_tmp1485_ = _tmp1491_ != _tmp1492_;
	} else {
		_tmp1485_ = FALSE;
	}
	if (_tmp1485_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1493_;
		ValaDataType* _tmp1494_;
		ValaDataType* _tmp1495_;
		ValaArrayType* _tmp1496_;
		_tmp1493_ = m;
		_tmp1494_ = vala_callable_get_return_type ((ValaCallable*) _tmp1493_);
		_tmp1495_ = _tmp1494_;
		_tmp1496_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1495_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1496_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1497_ = FALSE;
				_tmp1497_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1499_;
					gint _tmp1500_;
					gint _tmp1501_;
					ValaMethod* _tmp1502_;
					if (!_tmp1497_) {
						gint _tmp1498_;
						_tmp1498_ = dim;
						dim = _tmp1498_ + 1;
					}
					_tmp1497_ = FALSE;
					_tmp1499_ = array_type;
					_tmp1500_ = vala_array_type_get_rank (_tmp1499_);
					_tmp1501_ = _tmp1500_;
					if (!(dim <= _tmp1501_)) {
						break;
					}
					_tmp1502_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1502_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1503_;
						ValaDataType* _tmp1504_;
						ValaLocalVariable* _tmp1505_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1506_;
						const gchar* _tmp1507_;
						const gchar* _tmp1508_;
						ValaCCodeExpression* _tmp1509_;
						ValaLocalVariable* _tmp1510_;
						ValaCCodeExpression* _tmp1511_;
						ValaCCodeExpression* _tmp1512_;
						ValaCCodeAssignment* _tmp1513_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1514_;
						ValaCCodeIdentifier* _tmp1515_;
						ValaCCodeFunctionCall* _tmp1516_;
						ValaCCodeFunctionCall* _tmp1517_;
						ValaCCodeFunctionCall* _tmp1518_;
						ValaCCodeExpression* _tmp1519_;
						ValaCCodeFunctionCall* _tmp1520_;
						_tmp1503_ = itype;
						_tmp1504_ = vala_data_type_get_return_type (_tmp1503_);
						_tmp1505_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1504_, TRUE, NULL, FALSE);
						temp_var = _tmp1505_;
						_tmp1506_ = temp_var;
						_tmp1507_ = vala_symbol_get_name ((ValaSymbol*) _tmp1506_);
						_tmp1508_ = _tmp1507_;
						_tmp1509_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1508_);
						temp_ref = _tmp1509_;
						_tmp1510_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1510_, FALSE);
						_tmp1511_ = temp_ref;
						_tmp1512_ = ccall_expr;
						_tmp1513_ = vala_ccode_assignment_new (_tmp1511_, _tmp1512_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1513_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1514_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1515_ = _tmp1514_;
						_tmp1516_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1515_);
						_tmp1517_ = _tmp1516_;
						_vala_ccode_node_unref0 (_tmp1515_);
						len_call = _tmp1517_;
						_tmp1518_ = len_call;
						_tmp1519_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1518_, _tmp1519_);
						_tmp1520_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1520_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1521_;
						_tmp1521_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1521_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1522_;
							gchar* _tmp1523_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1524_;
							ValaCType* _tmp1525_;
							ValaCType* _tmp1526_;
							ValaLocalVariable* _tmp1527_;
							ValaLocalVariable* _tmp1528_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1529_;
							const gchar* _tmp1530_;
							const gchar* _tmp1531_;
							ValaCCodeExpression* _tmp1532_;
							ValaLocalVariable* _tmp1533_;
							ValaHashMap* _tmp1534_;
							ValaMethod* _tmp1535_;
							ValaCCodeExpression* _tmp1536_;
							ValaCCodeUnaryExpression* _tmp1537_;
							ValaCCodeUnaryExpression* _tmp1538_;
							ValaCCodeExpression* _tmp1539_;
							_tmp1522_ = m;
							_tmp1523_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1522_);
							length_ctype = _tmp1523_;
							_tmp1524_ = length_ctype;
							_tmp1525_ = vala_ctype_new (_tmp1524_, "0");
							_tmp1526_ = _tmp1525_;
							_tmp1527_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1526_, TRUE, NULL, TRUE);
							_tmp1528_ = _tmp1527_;
							_vala_code_node_unref0 (_tmp1526_);
							temp_var = _tmp1528_;
							_tmp1529_ = temp_var;
							_tmp1530_ = vala_symbol_get_name ((ValaSymbol*) _tmp1529_);
							_tmp1531_ = _tmp1530_;
							_tmp1532_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1531_);
							temp_ref = _tmp1532_;
							_tmp1533_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1533_, FALSE);
							_tmp1534_ = out_arg_map;
							_tmp1535_ = m;
							_tmp1536_ = temp_ref;
							_tmp1537_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1536_);
							_tmp1538_ = _tmp1537_;
							vala_map_set ((ValaMap*) _tmp1534_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1535_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1538_);
							_vala_ccode_node_unref0 (_tmp1538_);
							_tmp1539_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1539_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1540_;
							gchar* _tmp1541_;
							gchar* _tmp1542_;
							gboolean _tmp1543_;
							_tmp1540_ = m;
							_tmp1541_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1540_);
							_tmp1542_ = _tmp1541_;
							_tmp1543_ = _tmp1542_ != NULL;
							_g_free0 (_tmp1542_);
							if (_tmp1543_) {
								ValaMethod* _tmp1544_;
								gchar* _tmp1545_;
								gchar* _tmp1546_;
								ValaCCodeConstant* _tmp1547_;
								ValaCCodeConstant* _tmp1548_;
								_tmp1544_ = m;
								_tmp1545_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1544_);
								_tmp1546_ = _tmp1545_;
								_tmp1547_ = vala_ccode_constant_new (_tmp1546_);
								_tmp1548_ = _tmp1547_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1548_);
								_vala_ccode_node_unref0 (_tmp1548_);
								_g_free0 (_tmp1546_);
							} else {
								ValaCCodeConstant* _tmp1549_;
								ValaCCodeConstant* _tmp1550_;
								_tmp1549_ = vala_ccode_constant_new ("-1");
								_tmp1550_ = _tmp1549_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1550_);
								_vala_ccode_node_unref0 (_tmp1550_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1551_ = FALSE;
		gboolean _tmp1552_ = FALSE;
		ValaMethod* _tmp1553_;
		_tmp1553_ = m;
		if (_tmp1553_ != NULL) {
			ValaMethod* _tmp1554_;
			ValaDataType* _tmp1555_;
			ValaDataType* _tmp1556_;
			_tmp1554_ = m;
			_tmp1555_ = vala_callable_get_return_type ((ValaCallable*) _tmp1554_);
			_tmp1556_ = _tmp1555_;
			_tmp1552_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1556_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1552_ = FALSE;
		}
		if (_tmp1552_) {
			ValaCCodeFunctionCall* _tmp1557_;
			ValaCCodeFunctionCall* _tmp1558_;
			_tmp1557_ = async_call;
			_tmp1558_ = ccall;
			_tmp1551_ = _tmp1557_ != _tmp1558_;
		} else {
			_tmp1551_ = FALSE;
		}
		if (_tmp1551_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1559_;
			ValaDataType* _tmp1560_;
			ValaDataType* _tmp1561_;
			ValaDelegateType* _tmp1562_;
			gboolean _tmp1563_ = FALSE;
			ValaMethod* _tmp1564_;
			_tmp1559_ = m;
			_tmp1560_ = vala_callable_get_return_type ((ValaCallable*) _tmp1559_);
			_tmp1561_ = _tmp1560_;
			_tmp1562_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1561_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1562_;
			_tmp1564_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1564_)) {
				ValaDelegateType* _tmp1565_;
				ValaDelegate* _tmp1566_;
				ValaDelegate* _tmp1567_;
				gboolean _tmp1568_;
				gboolean _tmp1569_;
				_tmp1565_ = deleg_type;
				_tmp1566_ = vala_delegate_type_get_delegate_symbol (_tmp1565_);
				_tmp1567_ = _tmp1566_;
				_tmp1568_ = vala_delegate_get_has_target (_tmp1567_);
				_tmp1569_ = _tmp1568_;
				_tmp1563_ = _tmp1569_;
			} else {
				_tmp1563_ = FALSE;
			}
			if (_tmp1563_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1570_;
				ValaLocalVariable* _tmp1571_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1572_;
				const gchar* _tmp1573_;
				const gchar* _tmp1574_;
				ValaCCodeExpression* _tmp1575_;
				ValaLocalVariable* _tmp1576_;
				ValaHashMap* _tmp1577_;
				ValaMethod* _tmp1578_;
				ValaCCodeExpression* _tmp1579_;
				ValaCCodeUnaryExpression* _tmp1580_;
				ValaCCodeUnaryExpression* _tmp1581_;
				ValaCCodeExpression* _tmp1582_;
				ValaDelegateType* _tmp1583_;
				_tmp1570_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1571_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1570_, TRUE, NULL, TRUE);
				temp_var = _tmp1571_;
				_tmp1572_ = temp_var;
				_tmp1573_ = vala_symbol_get_name ((ValaSymbol*) _tmp1572_);
				_tmp1574_ = _tmp1573_;
				_tmp1575_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1574_);
				temp_ref = _tmp1575_;
				_tmp1576_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1576_, FALSE);
				_tmp1577_ = out_arg_map;
				_tmp1578_ = m;
				_tmp1579_ = temp_ref;
				_tmp1580_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1579_);
				_tmp1581_ = _tmp1580_;
				vala_map_set ((ValaMap*) _tmp1577_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1578_), FALSE)), (ValaCCodeExpression*) _tmp1581_);
				_vala_ccode_node_unref0 (_tmp1581_);
				_tmp1582_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1582_);
				_tmp1583_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1583_)) {
					ValaDelegateType* _tmp1584_;
					ValaLocalVariable* _tmp1585_;
					ValaLocalVariable* _tmp1586_;
					const gchar* _tmp1587_;
					const gchar* _tmp1588_;
					ValaCCodeExpression* _tmp1589_;
					ValaLocalVariable* _tmp1590_;
					ValaHashMap* _tmp1591_;
					ValaMethod* _tmp1592_;
					ValaCCodeExpression* _tmp1593_;
					ValaCCodeUnaryExpression* _tmp1594_;
					ValaCCodeUnaryExpression* _tmp1595_;
					ValaCCodeExpression* _tmp1596_;
					_tmp1584_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1585_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1584_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1585_;
					_tmp1586_ = temp_var;
					_tmp1587_ = vala_symbol_get_name ((ValaSymbol*) _tmp1586_);
					_tmp1588_ = _tmp1587_;
					_tmp1589_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1588_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1589_;
					_tmp1590_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1590_, FALSE);
					_tmp1591_ = out_arg_map;
					_tmp1592_ = m;
					_tmp1593_ = temp_ref;
					_tmp1594_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1593_);
					_tmp1595_ = _tmp1594_;
					vala_map_set ((ValaMap*) _tmp1591_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1592_), FALSE)), (ValaCCodeExpression*) _tmp1595_);
					_vala_ccode_node_unref0 (_tmp1595_);
					_tmp1596_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1596_);
				} else {
					ValaCCodeConstant* _tmp1597_;
					ValaCCodeConstant* _tmp1598_;
					_tmp1597_ = vala_ccode_constant_new ("NULL");
					_tmp1598_ = _tmp1597_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1598_);
					_vala_ccode_node_unref0 (_tmp1598_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1599_;
				ValaCCodeConstant* _tmp1600_;
				ValaDelegateType* _tmp1601_;
				ValaDelegate* _tmp1602_;
				ValaDelegate* _tmp1603_;
				gboolean _tmp1604_;
				gboolean _tmp1605_;
				_tmp1599_ = vala_ccode_constant_new ("NULL");
				_tmp1600_ = _tmp1599_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1600_);
				_vala_ccode_node_unref0 (_tmp1600_);
				_tmp1601_ = deleg_type;
				_tmp1602_ = vala_delegate_type_get_delegate_symbol (_tmp1601_);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_delegate_get_has_target (_tmp1603_);
				_tmp1605_ = _tmp1604_;
				if (_tmp1605_) {
					ValaCCodeConstant* _tmp1606_;
					ValaCCodeConstant* _tmp1607_;
					_tmp1606_ = vala_ccode_constant_new ("NULL");
					_tmp1607_ = _tmp1606_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1607_);
					_vala_ccode_node_unref0 (_tmp1607_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1609_ = deleg;
	if (_tmp1609_ != NULL) {
		ValaDelegate* _tmp1610_;
		ValaDataType* _tmp1611_;
		ValaDataType* _tmp1612_;
		_tmp1610_ = deleg;
		_tmp1611_ = vala_callable_get_return_type ((ValaCallable*) _tmp1610_);
		_tmp1612_ = _tmp1611_;
		_tmp1608_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1612_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1608_ = FALSE;
	}
	if (_tmp1608_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1613_;
		ValaDataType* _tmp1614_;
		ValaDataType* _tmp1615_;
		ValaArrayType* _tmp1616_;
		_tmp1613_ = deleg;
		_tmp1614_ = vala_callable_get_return_type ((ValaCallable*) _tmp1613_);
		_tmp1615_ = _tmp1614_;
		_tmp1616_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1615_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1616_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1617_ = FALSE;
				_tmp1617_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1619_;
					gint _tmp1620_;
					gint _tmp1621_;
					ValaDelegate* _tmp1622_;
					if (!_tmp1617_) {
						gint _tmp1618_;
						_tmp1618_ = dim;
						dim = _tmp1618_ + 1;
					}
					_tmp1617_ = FALSE;
					_tmp1619_ = array_type;
					_tmp1620_ = vala_array_type_get_rank (_tmp1619_);
					_tmp1621_ = _tmp1620_;
					if (!(dim <= _tmp1621_)) {
						break;
					}
					_tmp1622_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1622_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1623_;
						ValaDataType* _tmp1624_;
						ValaLocalVariable* _tmp1625_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1626_;
						const gchar* _tmp1627_;
						const gchar* _tmp1628_;
						ValaCCodeExpression* _tmp1629_;
						ValaLocalVariable* _tmp1630_;
						ValaCCodeExpression* _tmp1631_;
						ValaCCodeExpression* _tmp1632_;
						ValaCCodeAssignment* _tmp1633_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1634_;
						ValaCCodeIdentifier* _tmp1635_;
						ValaCCodeFunctionCall* _tmp1636_;
						ValaCCodeFunctionCall* _tmp1637_;
						ValaCCodeFunctionCall* _tmp1638_;
						ValaCCodeExpression* _tmp1639_;
						ValaCCodeFunctionCall* _tmp1640_;
						_tmp1623_ = itype;
						_tmp1624_ = vala_data_type_get_return_type (_tmp1623_);
						_tmp1625_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1624_, TRUE, NULL, FALSE);
						temp_var = _tmp1625_;
						_tmp1626_ = temp_var;
						_tmp1627_ = vala_symbol_get_name ((ValaSymbol*) _tmp1626_);
						_tmp1628_ = _tmp1627_;
						_tmp1629_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1628_);
						temp_ref = _tmp1629_;
						_tmp1630_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1630_, FALSE);
						_tmp1631_ = temp_ref;
						_tmp1632_ = ccall_expr;
						_tmp1633_ = vala_ccode_assignment_new (_tmp1631_, _tmp1632_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1633_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1634_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1635_ = _tmp1634_;
						_tmp1636_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1635_);
						_tmp1637_ = _tmp1636_;
						_vala_ccode_node_unref0 (_tmp1635_);
						len_call = _tmp1637_;
						_tmp1638_ = len_call;
						_tmp1639_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1638_, _tmp1639_);
						_tmp1640_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1640_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1641_;
						_tmp1641_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1641_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1642_;
							gchar* _tmp1643_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1644_;
							ValaCType* _tmp1645_;
							ValaCType* _tmp1646_;
							ValaLocalVariable* _tmp1647_;
							ValaLocalVariable* _tmp1648_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1649_;
							const gchar* _tmp1650_;
							const gchar* _tmp1651_;
							ValaCCodeExpression* _tmp1652_;
							ValaLocalVariable* _tmp1653_;
							ValaHashMap* _tmp1654_;
							ValaDelegate* _tmp1655_;
							ValaCCodeExpression* _tmp1656_;
							ValaCCodeUnaryExpression* _tmp1657_;
							ValaCCodeUnaryExpression* _tmp1658_;
							ValaCCodeExpression* _tmp1659_;
							_tmp1642_ = deleg;
							_tmp1643_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1642_);
							length_ctype = _tmp1643_;
							_tmp1644_ = length_ctype;
							_tmp1645_ = vala_ctype_new (_tmp1644_, "0");
							_tmp1646_ = _tmp1645_;
							_tmp1647_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1646_, TRUE, NULL, TRUE);
							_tmp1648_ = _tmp1647_;
							_vala_code_node_unref0 (_tmp1646_);
							temp_var = _tmp1648_;
							_tmp1649_ = temp_var;
							_tmp1650_ = vala_symbol_get_name ((ValaSymbol*) _tmp1649_);
							_tmp1651_ = _tmp1650_;
							_tmp1652_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1651_);
							temp_ref = _tmp1652_;
							_tmp1653_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1653_, FALSE);
							_tmp1654_ = out_arg_map;
							_tmp1655_ = deleg;
							_tmp1656_ = temp_ref;
							_tmp1657_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1656_);
							_tmp1658_ = _tmp1657_;
							vala_map_set ((ValaMap*) _tmp1654_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1655_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1658_);
							_vala_ccode_node_unref0 (_tmp1658_);
							_tmp1659_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1659_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1660_;
							ValaCCodeConstant* _tmp1661_;
							_tmp1660_ = vala_ccode_constant_new ("-1");
							_tmp1661_ = _tmp1660_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1661_);
							_vala_ccode_node_unref0 (_tmp1661_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1662_ = FALSE;
		gboolean _tmp1663_ = FALSE;
		ValaDelegate* _tmp1664_;
		_tmp1664_ = deleg;
		if (_tmp1664_ != NULL) {
			ValaDelegate* _tmp1665_;
			ValaDataType* _tmp1666_;
			ValaDataType* _tmp1667_;
			_tmp1665_ = deleg;
			_tmp1666_ = vala_callable_get_return_type ((ValaCallable*) _tmp1665_);
			_tmp1667_ = _tmp1666_;
			_tmp1663_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1667_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1663_ = FALSE;
		}
		if (_tmp1663_) {
			ValaDelegate* _tmp1668_;
			_tmp1668_ = deleg;
			_tmp1662_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1668_);
		} else {
			_tmp1662_ = FALSE;
		}
		if (_tmp1662_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1669_;
			ValaDataType* _tmp1670_;
			ValaDataType* _tmp1671_;
			ValaDelegateType* _tmp1672_;
			ValaDelegateType* _tmp1673_;
			ValaDelegate* _tmp1674_;
			ValaDelegate* _tmp1675_;
			gboolean _tmp1676_;
			gboolean _tmp1677_;
			_tmp1669_ = deleg;
			_tmp1670_ = vala_callable_get_return_type ((ValaCallable*) _tmp1669_);
			_tmp1671_ = _tmp1670_;
			_tmp1672_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1671_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1672_;
			_tmp1673_ = deleg_type;
			_tmp1674_ = vala_delegate_type_get_delegate_symbol (_tmp1673_);
			_tmp1675_ = _tmp1674_;
			_tmp1676_ = vala_delegate_get_has_target (_tmp1675_);
			_tmp1677_ = _tmp1676_;
			if (_tmp1677_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1678_;
				ValaLocalVariable* _tmp1679_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1680_;
				const gchar* _tmp1681_;
				const gchar* _tmp1682_;
				ValaCCodeExpression* _tmp1683_;
				ValaLocalVariable* _tmp1684_;
				ValaHashMap* _tmp1685_;
				ValaDelegate* _tmp1686_;
				ValaCCodeExpression* _tmp1687_;
				ValaCCodeUnaryExpression* _tmp1688_;
				ValaCCodeUnaryExpression* _tmp1689_;
				ValaCCodeExpression* _tmp1690_;
				ValaDelegateType* _tmp1691_;
				_tmp1678_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1679_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1678_, TRUE, NULL, TRUE);
				temp_var = _tmp1679_;
				_tmp1680_ = temp_var;
				_tmp1681_ = vala_symbol_get_name ((ValaSymbol*) _tmp1680_);
				_tmp1682_ = _tmp1681_;
				_tmp1683_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1682_);
				temp_ref = _tmp1683_;
				_tmp1684_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1684_, FALSE);
				_tmp1685_ = out_arg_map;
				_tmp1686_ = deleg;
				_tmp1687_ = temp_ref;
				_tmp1688_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1687_);
				_tmp1689_ = _tmp1688_;
				vala_map_set ((ValaMap*) _tmp1685_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1686_), FALSE)), (ValaCCodeExpression*) _tmp1689_);
				_vala_ccode_node_unref0 (_tmp1689_);
				_tmp1690_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1690_);
				_tmp1691_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1691_)) {
					ValaDelegateType* _tmp1692_;
					ValaLocalVariable* _tmp1693_;
					ValaLocalVariable* _tmp1694_;
					const gchar* _tmp1695_;
					const gchar* _tmp1696_;
					ValaCCodeExpression* _tmp1697_;
					ValaLocalVariable* _tmp1698_;
					ValaHashMap* _tmp1699_;
					ValaDelegate* _tmp1700_;
					ValaCCodeExpression* _tmp1701_;
					ValaCCodeUnaryExpression* _tmp1702_;
					ValaCCodeUnaryExpression* _tmp1703_;
					ValaCCodeExpression* _tmp1704_;
					_tmp1692_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1693_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1692_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1693_;
					_tmp1694_ = temp_var;
					_tmp1695_ = vala_symbol_get_name ((ValaSymbol*) _tmp1694_);
					_tmp1696_ = _tmp1695_;
					_tmp1697_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1696_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1697_;
					_tmp1698_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1698_, FALSE);
					_tmp1699_ = out_arg_map;
					_tmp1700_ = deleg;
					_tmp1701_ = temp_ref;
					_tmp1702_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1701_);
					_tmp1703_ = _tmp1702_;
					vala_map_set ((ValaMap*) _tmp1699_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1700_), FALSE)), (ValaCCodeExpression*) _tmp1703_);
					_vala_ccode_node_unref0 (_tmp1703_);
					_tmp1704_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1704_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1706_ = m;
	if (_tmp1706_ != NULL) {
		ValaMethod* _tmp1707_;
		gboolean _tmp1708_;
		gboolean _tmp1709_;
		_tmp1707_ = m;
		_tmp1708_ = vala_method_get_coroutine (_tmp1707_);
		_tmp1709_ = _tmp1708_;
		_tmp1705_ = _tmp1709_;
	} else {
		_tmp1705_ = FALSE;
	}
	if (_tmp1705_) {
		gboolean _tmp1710_;
		gboolean _tmp1711_;
		_tmp1710_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
		_tmp1711_ = _tmp1710_;
		if (_tmp1711_) {
			ValaHashMap* _tmp1712_;
			ValaMethod* _tmp1713_;
			ValaMethod* _tmp1714_;
			gchar* _tmp1715_;
			gchar* _tmp1716_;
			ValaCCodeIdentifier* _tmp1717_;
			ValaCCodeIdentifier* _tmp1718_;
			ValaHashMap* _tmp1719_;
			ValaCCodeIdentifier* _tmp1720_;
			ValaCCodeIdentifier* _tmp1721_;
			_tmp1712_ = in_arg_map;
			_tmp1713_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1714_ = _tmp1713_;
			_tmp1715_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1714_);
			_tmp1716_ = _tmp1715_;
			_tmp1717_ = vala_ccode_identifier_new (_tmp1716_);
			_tmp1718_ = _tmp1717_;
			vala_map_set ((ValaMap*) _tmp1712_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1718_);
			_vala_ccode_node_unref0 (_tmp1718_);
			_g_free0 (_tmp1716_);
			_tmp1719_ = in_arg_map;
			_tmp1720_ = vala_ccode_identifier_new ("_data_");
			_tmp1721_ = _tmp1720_;
			vala_map_set ((ValaMap*) _tmp1719_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1721_);
			_vala_ccode_node_unref0 (_tmp1721_);
		}
	}
	_tmp1722_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1723_ = _tmp1722_;
	if (_tmp1723_) {
		ValaCallable* _tmp1724_ = NULL;
		ValaMethod* _tmp1725_;
		ValaHashMap* _tmp1727_;
		ValaCCodeExpression* _tmp1728_;
		ValaCCodeExpression* _tmp1729_;
		ValaCCodeUnaryExpression* _tmp1730_;
		ValaCCodeUnaryExpression* _tmp1731_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1725_ = m;
		_tmp1724_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1725_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1724_ == NULL) {
			ValaDelegate* _tmp1726_;
			_tmp1726_ = deleg;
			_tmp1724_ = (ValaCallable*) _tmp1726_;
		}
		_tmp1727_ = out_arg_map;
		_tmp1728_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1729_ = _tmp1728_;
		_tmp1730_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1729_);
		_tmp1731_ = _tmp1730_;
		vala_map_set ((ValaMap*) _tmp1727_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1724_), FALSE)), (ValaCCodeExpression*) _tmp1731_);
		_vala_ccode_node_unref0 (_tmp1731_);
		_vala_ccode_node_unref0 (_tmp1729_);
	} else {
		gboolean _tmp1732_ = FALSE;
		gboolean _tmp1733_ = FALSE;
		ValaMethod* _tmp1734_;
		_tmp1734_ = m;
		if (_tmp1734_ != NULL) {
			ValaMethod* _tmp1735_;
			_tmp1735_ = m;
			_tmp1733_ = vala_method_has_error_type_parameter (_tmp1735_);
		} else {
			_tmp1733_ = FALSE;
		}
		if (_tmp1733_) {
			ValaCCodeFunctionCall* _tmp1736_;
			ValaCCodeFunctionCall* _tmp1737_;
			_tmp1736_ = async_call;
			_tmp1737_ = ccall;
			_tmp1732_ = _tmp1736_ != _tmp1737_;
		} else {
			_tmp1732_ = FALSE;
		}
		if (_tmp1732_) {
			ValaHashMap* _tmp1738_;
			ValaMethod* _tmp1739_;
			ValaCCodeConstant* _tmp1740_;
			ValaCCodeConstant* _tmp1741_;
			_tmp1738_ = out_arg_map;
			_tmp1739_ = m;
			_tmp1740_ = vala_ccode_constant_new ("NULL");
			_tmp1741_ = _tmp1740_;
			vala_map_set ((ValaMap*) _tmp1738_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1739_), FALSE)), (ValaCCodeExpression*) _tmp1741_);
			_vala_ccode_node_unref0 (_tmp1741_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1742_;
		_tmp1742_ = m;
		if (_tmp1742_ == NULL) {
			ValaHashMap* _tmp1743_;
			ValaCCodeConstant* _tmp1744_;
			ValaCCodeConstant* _tmp1745_;
			_tmp1743_ = in_arg_map;
			_tmp1744_ = vala_ccode_constant_new ("NULL");
			_tmp1745_ = _tmp1744_;
			vala_map_set ((ValaMap*) _tmp1743_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1745_);
			_vala_ccode_node_unref0 (_tmp1745_);
		} else {
			gboolean _tmp1746_ = FALSE;
			gboolean _tmp1747_ = FALSE;
			gboolean _tmp1748_ = FALSE;
			ValaMethod* _tmp1749_;
			gboolean _tmp1750_;
			gboolean _tmp1751_;
			_tmp1749_ = m;
			_tmp1750_ = vala_method_get_printf_format (_tmp1749_);
			_tmp1751_ = _tmp1750_;
			if (!_tmp1751_) {
				ValaMethod* _tmp1752_;
				gboolean _tmp1753_;
				gboolean _tmp1754_;
				_tmp1752_ = m;
				_tmp1753_ = vala_method_get_scanf_format (_tmp1752_);
				_tmp1754_ = _tmp1753_;
				_tmp1748_ = !_tmp1754_;
			} else {
				_tmp1748_ = FALSE;
			}
			if (_tmp1748_) {
				ValaMethod* _tmp1755_;
				gchar* _tmp1756_;
				gchar* _tmp1757_;
				_tmp1755_ = m;
				_tmp1756_ = vala_get_ccode_sentinel (_tmp1755_);
				_tmp1757_ = _tmp1756_;
				_tmp1747_ = g_strcmp0 (_tmp1757_, "") != 0;
				_g_free0 (_tmp1757_);
			} else {
				_tmp1747_ = FALSE;
			}
			if (_tmp1747_) {
				gboolean _tmp1758_;
				gboolean _tmp1759_;
				_tmp1758_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1759_ = _tmp1758_;
				_tmp1746_ = !_tmp1759_;
			} else {
				_tmp1746_ = FALSE;
			}
			if (_tmp1746_) {
				ValaHashMap* _tmp1760_;
				ValaMethod* _tmp1761_;
				gchar* _tmp1762_;
				gchar* _tmp1763_;
				ValaCCodeConstant* _tmp1764_;
				ValaCCodeConstant* _tmp1765_;
				_tmp1760_ = in_arg_map;
				_tmp1761_ = m;
				_tmp1762_ = vala_get_ccode_sentinel (_tmp1761_);
				_tmp1763_ = _tmp1762_;
				_tmp1764_ = vala_ccode_constant_new (_tmp1763_);
				_tmp1765_ = _tmp1764_;
				vala_map_set ((ValaMap*) _tmp1760_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1765_);
				_vala_ccode_node_unref0 (_tmp1765_);
				_g_free0 (_tmp1763_);
			}
		}
	}
	_tmp1767_ = deleg;
	if (_tmp1767_ != NULL) {
		ValaDelegate* _tmp1768_;
		gboolean _tmp1769_;
		gboolean _tmp1770_;
		_tmp1768_ = deleg;
		_tmp1769_ = vala_delegate_get_has_target (_tmp1768_);
		_tmp1770_ = _tmp1769_;
		_tmp1766_ = _tmp1770_;
	} else {
		_tmp1766_ = FALSE;
	}
	if (_tmp1766_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1771_;
		ValaDelegate* _tmp1772_;
		ValaExpression* _tmp1773_;
		ValaExpression* _tmp1774_;
		ValaCCodeExpression* _tmp1775_ = NULL;
		ValaCCodeExpression* _tmp1776_;
		ValaCCodeExpression* _tmp1777_;
		ValaHashMap* _tmp1778_;
		ValaDelegate* _tmp1779_;
		ValaExpression* _tmp1780_;
		ValaExpression* _tmp1781_;
		ValaCCodeExpression* _tmp1782_ = NULL;
		ValaCCodeExpression* _tmp1783_;
		ValaCCodeExpression* _tmp1784_;
		_tmp1771_ = in_arg_map;
		_tmp1772_ = deleg;
		_tmp1773_ = vala_method_call_get_call (expr);
		_tmp1774_ = _tmp1773_;
		_tmp1776_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1774_, &_tmp1775_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1775_;
		_tmp1777_ = _tmp1776_;
		vala_map_set ((ValaMap*) _tmp1771_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1772_), FALSE)), _tmp1777_);
		_vala_ccode_node_unref0 (_tmp1777_);
		_tmp1778_ = out_arg_map;
		_tmp1779_ = deleg;
		_tmp1780_ = vala_method_call_get_call (expr);
		_tmp1781_ = _tmp1780_;
		_tmp1783_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1781_, &_tmp1782_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1782_;
		_tmp1784_ = _tmp1783_;
		vala_map_set ((ValaMap*) _tmp1778_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1779_), FALSE)), _tmp1784_);
		_vala_ccode_node_unref0 (_tmp1784_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1785_ = itype;
	_tmp1786_ = vala_data_type_get_return_type (_tmp1785_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1786_);
	_tmp1788_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1788_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1789_;
		ValaDataType* _tmp1790_;
		_tmp1789_ = itype;
		_tmp1790_ = vala_data_type_get_return_type (_tmp1789_);
		_tmp1787_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1790_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1787_ = FALSE;
	}
	if (_tmp1787_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1791_;
		ValaSignal* _tmp1792_;
		ValaSignal* _tmp1793_;
		ValaSignal* _tmp1794_;
		gboolean _tmp1795_ = FALSE;
		gboolean _tmp1796_ = FALSE;
		ValaMemberAccess* _tmp1797_;
		_tmp1791_ = itype;
		_tmp1792_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1791_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1793_ = _tmp1792_;
		_tmp1794_ = _vala_code_node_ref0 (_tmp1793_);
		sig = _tmp1794_;
		_tmp1797_ = ma;
		if (_tmp1797_ != NULL) {
			ValaMemberAccess* _tmp1798_;
			ValaExpression* _tmp1799_;
			ValaExpression* _tmp1800_;
			_tmp1798_ = ma;
			_tmp1799_ = vala_member_access_get_inner (_tmp1798_);
			_tmp1800_ = _tmp1799_;
			_tmp1796_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1800_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1796_ = FALSE;
		}
		if (_tmp1796_) {
			ValaSignal* _tmp1801_;
			gboolean _tmp1802_;
			gboolean _tmp1803_;
			_tmp1801_ = sig;
			_tmp1802_ = vala_signal_get_is_virtual (_tmp1801_);
			_tmp1803_ = _tmp1802_;
			_tmp1795_ = _tmp1803_;
		} else {
			_tmp1795_ = FALSE;
		}
		if (_tmp1795_) {
		} else {
			gboolean _tmp1804_ = FALSE;
			ValaSignal* _tmp1805_;
			_tmp1805_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1805_)) {
				_tmp1804_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1806_;
				ValaSourceReference* _tmp1807_;
				ValaSourceReference* _tmp1808_;
				ValaSourceFile* _tmp1809_;
				ValaSourceFile* _tmp1810_;
				ValaSignal* _tmp1811_;
				ValaSourceReference* _tmp1812_;
				ValaSourceReference* _tmp1813_;
				ValaSourceFile* _tmp1814_;
				ValaSourceFile* _tmp1815_;
				_tmp1806_ = ma;
				_tmp1807_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1806_);
				_tmp1808_ = _tmp1807_;
				_tmp1809_ = vala_source_reference_get_file (_tmp1808_);
				_tmp1810_ = _tmp1809_;
				_tmp1811_ = sig;
				_tmp1812_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1811_);
				_tmp1813_ = _tmp1812_;
				_tmp1814_ = vala_source_reference_get_file (_tmp1813_);
				_tmp1815_ = _tmp1814_;
				_tmp1804_ = _tmp1810_ == _tmp1815_;
			}
			if (_tmp1804_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1816_ = async_call;
	_tmp1817_ = ccall;
	if (_tmp1816_ == _tmp1817_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1818_;
		ValaDataType* _tmp1819_;
		ValaLocalVariable* _tmp1820_;
		ValaLocalVariable* _tmp1821_;
		const gchar* _tmp1822_;
		const gchar* _tmp1823_;
		ValaCCodeExpression* _tmp1824_;
		ValaLocalVariable* _tmp1825_;
		ValaHashMap* _tmp1826_;
		ValaCCodeExpression* _tmp1827_;
		ValaCCodeUnaryExpression* _tmp1828_;
		ValaCCodeUnaryExpression* _tmp1829_;
		_tmp1818_ = itype;
		_tmp1819_ = vala_data_type_get_return_type (_tmp1818_);
		_tmp1820_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1819_, TRUE, NULL, TRUE);
		out_param_var = _tmp1820_;
		_tmp1821_ = out_param_var;
		_tmp1822_ = vala_symbol_get_name ((ValaSymbol*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1823_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1824_;
		_tmp1825_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1825_, FALSE);
		_tmp1826_ = out_arg_map;
		_tmp1827_ = out_param_ref;
		_tmp1828_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1827_);
		_tmp1829_ = _tmp1828_;
		vala_map_set ((ValaMap*) _tmp1826_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1829_);
		_vala_ccode_node_unref0 (_tmp1829_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1830_ = async_call;
	_tmp1831_ = ccall;
	if (_tmp1830_ != _tmp1831_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1842_;
			ValaHashMap* _tmp1843_;
			gpointer _tmp1844_;
			ValaCCodeExpression* _tmp1845_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1832_;
				ValaSet* _tmp1833_;
				ValaSet* _tmp1834_;
				ValaIterator* _tmp1835_;
				ValaIterator* _tmp1836_;
				_tmp1832_ = out_arg_map;
				_tmp1833_ = vala_map_get_keys ((ValaMap*) _tmp1832_);
				_tmp1834_ = _tmp1833_;
				_tmp1835_ = vala_iterable_iterator ((ValaIterable*) _tmp1834_);
				_tmp1836_ = _tmp1835_;
				_vala_iterable_unref0 (_tmp1834_);
				_pos_it = _tmp1836_;
				while (TRUE) {
					ValaIterator* _tmp1837_;
					gint pos = 0;
					ValaIterator* _tmp1838_;
					gpointer _tmp1839_;
					gboolean _tmp1840_ = FALSE;
					_tmp1837_ = _pos_it;
					if (!vala_iterator_next (_tmp1837_)) {
						break;
					}
					_tmp1838_ = _pos_it;
					_tmp1839_ = vala_iterator_get (_tmp1838_);
					pos = (gint) ((gintptr) _tmp1839_);
					if (pos > last_pos) {
						gboolean _tmp1841_ = FALSE;
						if (min_pos == -1) {
							_tmp1841_ = TRUE;
						} else {
							_tmp1841_ = pos < min_pos;
						}
						_tmp1840_ = _tmp1841_;
					} else {
						_tmp1840_ = FALSE;
					}
					if (_tmp1840_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1842_ = ccall;
			_tmp1843_ = out_arg_map;
			_tmp1844_ = vala_map_get ((ValaMap*) _tmp1843_, (gpointer) ((gintptr) min_pos));
			_tmp1845_ = (ValaCCodeExpression*) _tmp1844_;
			vala_ccode_function_call_add_argument (_tmp1842_, _tmp1845_);
			_vala_ccode_node_unref0 (_tmp1845_);
			last_pos = min_pos;
		}
	}
	_tmp1846_ = async_call;
	if (_tmp1846_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1857_;
			ValaHashMap* _tmp1858_;
			gpointer _tmp1859_;
			ValaCCodeExpression* _tmp1860_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1847_;
				ValaSet* _tmp1848_;
				ValaSet* _tmp1849_;
				ValaIterator* _tmp1850_;
				ValaIterator* _tmp1851_;
				_tmp1847_ = in_arg_map;
				_tmp1848_ = vala_map_get_keys ((ValaMap*) _tmp1847_);
				_tmp1849_ = _tmp1848_;
				_tmp1850_ = vala_iterable_iterator ((ValaIterable*) _tmp1849_);
				_tmp1851_ = _tmp1850_;
				_vala_iterable_unref0 (_tmp1849_);
				_pos_it = _tmp1851_;
				while (TRUE) {
					ValaIterator* _tmp1852_;
					gint pos = 0;
					ValaIterator* _tmp1853_;
					gpointer _tmp1854_;
					gboolean _tmp1855_ = FALSE;
					_tmp1852_ = _pos_it;
					if (!vala_iterator_next (_tmp1852_)) {
						break;
					}
					_tmp1853_ = _pos_it;
					_tmp1854_ = vala_iterator_get (_tmp1853_);
					pos = (gint) ((gintptr) _tmp1854_);
					if (pos > last_pos) {
						gboolean _tmp1856_ = FALSE;
						if (min_pos == -1) {
							_tmp1856_ = TRUE;
						} else {
							_tmp1856_ = pos < min_pos;
						}
						_tmp1855_ = _tmp1856_;
					} else {
						_tmp1855_ = FALSE;
					}
					if (_tmp1855_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1857_ = async_call;
			_tmp1858_ = in_arg_map;
			_tmp1859_ = vala_map_get ((ValaMap*) _tmp1858_, (gpointer) ((gintptr) min_pos));
			_tmp1860_ = (ValaCCodeExpression*) _tmp1859_;
			vala_ccode_function_call_add_argument (_tmp1857_, _tmp1860_);
			_vala_ccode_node_unref0 (_tmp1860_);
			last_pos = min_pos;
		}
	}
	_tmp1861_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) expr);
	_tmp1862_ = _tmp1861_;
	if (_tmp1862_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1863_;
		gint _tmp1864_;
		ValaCCodeFunction* _tmp1865_;
		ValaCCodeFunction* _tmp1866_;
		ValaCCodeIdentifier* _tmp1867_;
		ValaCCodeIdentifier* _tmp1868_;
		ValaCCodeMemberAccess* _tmp1869_;
		ValaCCodeMemberAccess* _tmp1870_;
		gchar* _tmp1871_;
		gchar* _tmp1872_;
		ValaCCodeConstant* _tmp1873_;
		ValaCCodeConstant* _tmp1874_;
		ValaCCodeFunction* _tmp1875_;
		ValaCCodeFunction* _tmp1876_;
		ValaCCodeFunctionCall* _tmp1877_;
		ValaCCodeFunction* _tmp1878_;
		ValaCCodeFunction* _tmp1879_;
		ValaCCodeConstant* _tmp1880_;
		ValaCCodeConstant* _tmp1881_;
		ValaCCodeFunction* _tmp1882_;
		ValaCCodeFunction* _tmp1883_;
		gchar* _tmp1884_;
		gchar* _tmp1885_;
		_tmp1863_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1864_ = _tmp1863_->next_coroutine_state;
		_tmp1863_->next_coroutine_state = _tmp1864_ + 1;
		state = _tmp1864_;
		_tmp1865_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1866_ = _tmp1865_;
		_tmp1867_ = vala_ccode_identifier_new ("_data_");
		_tmp1868_ = _tmp1867_;
		_tmp1869_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1868_, "_state_");
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = g_strdup_printf ("%i", state);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = vala_ccode_constant_new (_tmp1872_);
		_tmp1874_ = _tmp1873_;
		vala_ccode_function_add_assignment (_tmp1866_, (ValaCCodeExpression*) _tmp1870_, (ValaCCodeExpression*) _tmp1874_);
		_vala_ccode_node_unref0 (_tmp1874_);
		_g_free0 (_tmp1872_);
		_vala_ccode_node_unref0 (_tmp1870_);
		_vala_ccode_node_unref0 (_tmp1868_);
		_tmp1875_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1876_ = _tmp1875_;
		_tmp1877_ = async_call;
		vala_ccode_function_add_expression (_tmp1876_, (ValaCCodeExpression*) _tmp1877_);
		_tmp1878_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1879_ = _tmp1878_;
		_tmp1880_ = vala_ccode_constant_new ("FALSE");
		_tmp1881_ = _tmp1880_;
		vala_ccode_function_add_return (_tmp1879_, (ValaCCodeExpression*) _tmp1881_);
		_vala_ccode_node_unref0 (_tmp1881_);
		_tmp1882_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1883_ = _tmp1882_;
		_tmp1884_ = g_strdup_printf ("_state_%d", state);
		_tmp1885_ = _tmp1884_;
		vala_ccode_function_add_label (_tmp1883_, _tmp1885_);
		_g_free0 (_tmp1885_);
	}
	_tmp1886_ = vala_method_call_get_is_assert (expr);
	_tmp1887_ = _tmp1886_;
	if (_tmp1887_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1888_;
		ValaSourceReference* _tmp1889_;
		ValaSourceLocation _tmp1890_ = {0};
		ValaSourceLocation _tmp1891_;
		gchar* _tmp1892_;
		ValaSourceReference* _tmp1893_;
		ValaSourceReference* _tmp1894_;
		ValaSourceLocation _tmp1895_ = {0};
		ValaSourceLocation _tmp1896_;
		gchar* _tmp1897_;
		ValaSourceReference* _tmp1898_;
		ValaSourceReference* _tmp1899_;
		ValaSourceLocation _tmp1900_ = {0};
		ValaSourceLocation _tmp1901_;
		gchar* _tmp1902_;
		gchar* _tmp1903_;
		ValaCCodeFunctionCall* _tmp1904_;
		ValaCCodeIdentifier* _tmp1905_;
		ValaCCodeIdentifier* _tmp1906_;
		ValaCCodeFunctionCall* _tmp1907_;
		const gchar* _tmp1908_;
		gchar* _tmp1909_;
		gchar* _tmp1910_;
		gchar* _tmp1911_;
		gchar* _tmp1912_;
		gchar* _tmp1913_;
		gchar* _tmp1914_;
		ValaCCodeConstant* _tmp1915_;
		ValaCCodeConstant* _tmp1916_;
		_tmp1888_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1889_ = _tmp1888_;
		vala_source_reference_get_begin (_tmp1889_, &_tmp1890_);
		_tmp1891_ = _tmp1890_;
		_tmp1892_ = _tmp1891_.pos;
		_tmp1893_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1894_ = _tmp1893_;
		vala_source_reference_get_end (_tmp1894_, &_tmp1895_);
		_tmp1896_ = _tmp1895_;
		_tmp1897_ = _tmp1896_.pos;
		_tmp1898_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1899_ = _tmp1898_;
		vala_source_reference_get_begin (_tmp1899_, &_tmp1900_);
		_tmp1901_ = _tmp1900_;
		_tmp1902_ = _tmp1901_.pos;
		_tmp1903_ = string_substring ((const gchar*) _tmp1892_, (glong) 0, (glong) ((gint) (_tmp1897_ - _tmp1902_)));
		message = _tmp1903_;
		_tmp1904_ = ccall;
		_tmp1905_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1906_ = _tmp1905_;
		vala_ccode_function_call_set_call (_tmp1904_, (ValaCCodeExpression*) _tmp1906_);
		_vala_ccode_node_unref0 (_tmp1906_);
		_tmp1907_ = ccall;
		_tmp1908_ = message;
		_tmp1909_ = string_replace (_tmp1908_, "\n", " ");
		_tmp1910_ = _tmp1909_;
		_tmp1911_ = g_strescape (_tmp1910_, "");
		_tmp1912_ = _tmp1911_;
		_tmp1913_ = g_strdup_printf ("\"%s\"", _tmp1912_);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = vala_ccode_constant_new (_tmp1914_);
		_tmp1916_ = _tmp1915_;
		vala_ccode_function_call_add_argument (_tmp1907_, (ValaCCodeExpression*) _tmp1916_);
		_vala_ccode_node_unref0 (_tmp1916_);
		_g_free0 (_tmp1914_);
		_g_free0 (_tmp1912_);
		_g_free0 (_tmp1910_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1917_;
		ValaCCodeFunction* _tmp1918_;
		ValaCCodeExpression* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaCCodeExpression* _tmp1921_;
		_tmp1917_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1918_ = _tmp1917_;
		_tmp1919_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1918_, _tmp1919_);
		_tmp1920_ = out_param_ref;
		_tmp1921_ = _vala_ccode_node_ref0 (_tmp1920_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1921_;
	}
	_tmp1924_ = m;
	if (_tmp1924_ != NULL) {
		ValaMethod* _tmp1925_;
		ValaMemberBinding _tmp1926_;
		ValaMemberBinding _tmp1927_;
		_tmp1925_ = m;
		_tmp1926_ = vala_method_get_binding (_tmp1925_);
		_tmp1927_ = _tmp1926_;
		_tmp1923_ = _tmp1927_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1923_ = FALSE;
	}
	if (_tmp1923_) {
		ValaMethod* _tmp1928_;
		gboolean _tmp1929_;
		gboolean _tmp1930_;
		_tmp1928_ = m;
		_tmp1929_ = vala_method_get_returns_modified_pointer (_tmp1928_);
		_tmp1930_ = _tmp1929_;
		_tmp1922_ = _tmp1930_;
	} else {
		_tmp1922_ = FALSE;
	}
	if (_tmp1922_) {
		gboolean _tmp1931_ = FALSE;
		gboolean _tmp1932_ = FALSE;
		ValaMemberAccess* _tmp1933_;
		_tmp1933_ = ma;
		if (_tmp1933_ != NULL) {
			ValaMemberAccess* _tmp1934_;
			ValaExpression* _tmp1935_;
			ValaExpression* _tmp1936_;
			ValaSymbol* _tmp1937_;
			ValaSymbol* _tmp1938_;
			_tmp1934_ = ma;
			_tmp1935_ = vala_member_access_get_inner (_tmp1934_);
			_tmp1936_ = _tmp1935_;
			_tmp1937_ = vala_expression_get_symbol_reference (_tmp1936_);
			_tmp1938_ = _tmp1937_;
			_tmp1932_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1938_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1932_ = FALSE;
		}
		if (_tmp1932_) {
			ValaMemberAccess* _tmp1939_;
			ValaExpression* _tmp1940_;
			ValaExpression* _tmp1941_;
			_tmp1939_ = ma;
			_tmp1940_ = vala_member_access_get_inner (_tmp1939_);
			_tmp1941_ = _tmp1940_;
			_tmp1931_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1941_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1931_ = FALSE;
		}
		if (_tmp1931_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1942_;
			ValaExpression* _tmp1943_;
			ValaExpression* _tmp1944_;
			ValaSymbol* _tmp1945_;
			ValaSymbol* _tmp1946_;
			ValaProperty* _tmp1947_;
			ValaProperty* _tmp1948_;
			ValaMemberAccess* _tmp1949_;
			ValaExpression* _tmp1950_;
			ValaExpression* _tmp1951_;
			ValaExpression* _tmp1952_;
			ValaExpression* _tmp1953_;
			ValaDataType* _tmp1954_;
			ValaDataType* _tmp1955_;
			ValaCCodeExpression* _tmp1956_;
			ValaGLibValue* _tmp1957_;
			ValaGLibValue* _tmp1958_;
			_tmp1942_ = ma;
			_tmp1943_ = vala_member_access_get_inner (_tmp1942_);
			_tmp1944_ = _tmp1943_;
			_tmp1945_ = vala_expression_get_symbol_reference (_tmp1944_);
			_tmp1946_ = _tmp1945_;
			_tmp1947_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1946_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1947_;
			_tmp1948_ = prop;
			_tmp1949_ = ma;
			_tmp1950_ = vala_member_access_get_inner (_tmp1949_);
			_tmp1951_ = _tmp1950_;
			_tmp1952_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1951_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1953_ = _tmp1952_;
			_tmp1954_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1955_ = _tmp1954_;
			_tmp1956_ = ccall_expr;
			_tmp1957_ = vala_glib_value_new (_tmp1955_, _tmp1956_, FALSE);
			_tmp1958_ = _tmp1957_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1948_, _tmp1953_, (ValaTargetValue*) _tmp1958_);
			_vala_target_value_unref0 (_tmp1958_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1959_;
			ValaCCodeExpression* _tmp1960_;
			ValaCCodeAssignment* _tmp1961_;
			_tmp1959_ = instance;
			_tmp1960_ = ccall_expr;
			_tmp1961_ = vala_ccode_assignment_new (_tmp1959_, _tmp1960_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1961_;
		}
	}
	_tmp1967_ = m;
	if (_tmp1967_ != NULL) {
		ValaMethod* _tmp1968_;
		_tmp1968_ = m;
		_tmp1966_ = vala_get_ccode_simple_generics (_tmp1968_);
	} else {
		_tmp1966_ = FALSE;
	}
	if (_tmp1966_) {
		ValaMethod* _tmp1969_;
		ValaDataType* _tmp1970_;
		ValaDataType* _tmp1971_;
		_tmp1969_ = m;
		_tmp1970_ = vala_callable_get_return_type ((ValaCallable*) _tmp1969_);
		_tmp1971_ = _tmp1970_;
		_tmp1965_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1971_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1965_ = FALSE;
	}
	if (_tmp1965_) {
		ValaDataType* _tmp1972_;
		ValaDataType* _tmp1973_;
		_tmp1972_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1973_ = _tmp1972_;
		_tmp1964_ = vala_data_type_is_real_struct_type (_tmp1973_);
	} else {
		_tmp1964_ = FALSE;
	}
	if (_tmp1964_) {
		ValaDataType* _tmp1974_;
		ValaDataType* _tmp1975_;
		gboolean _tmp1976_;
		gboolean _tmp1977_;
		_tmp1974_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1975_ = _tmp1974_;
		_tmp1976_ = vala_data_type_get_nullable (_tmp1975_);
		_tmp1977_ = _tmp1976_;
		_tmp1963_ = !_tmp1977_;
	} else {
		_tmp1963_ = FALSE;
	}
	if (_tmp1963_) {
		ValaDataType* _tmp1978_;
		ValaDataType* _tmp1979_;
		_tmp1978_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1979_ = _tmp1978_;
		_tmp1962_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1979_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1962_ = FALSE;
	}
	if (_tmp1962_) {
		ValaCCodeExpression* _tmp1980_;
		ValaCCodeParenthesizedExpression* _tmp1981_;
		ValaCCodeParenthesizedExpression* _tmp1982_;
		ValaCCodeUnaryExpression* _tmp1983_;
		_tmp1980_ = ccall_expr;
		_tmp1981_ = vala_ccode_parenthesized_expression_new (_tmp1980_);
		_tmp1982_ = _tmp1981_;
		_tmp1983_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1982_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1983_;
		_vala_ccode_node_unref0 (_tmp1982_);
	}
	_tmp1986_ = m;
	if (_tmp1986_ != NULL) {
		ValaMethod* _tmp1987_;
		gchar* _tmp1988_;
		gchar* _tmp1989_;
		_tmp1987_ = m;
		_tmp1988_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1987_);
		_tmp1989_ = _tmp1988_;
		_tmp1985_ = _tmp1989_ != NULL;
		_g_free0 (_tmp1989_);
	} else {
		_tmp1985_ = FALSE;
	}
	if (_tmp1985_) {
		ValaMethod* _tmp1990_;
		gchar* _tmp1991_;
		gchar* _tmp1992_;
		ValaMethod* _tmp1993_;
		ValaDataType* _tmp1994_;
		ValaDataType* _tmp1995_;
		gchar* _tmp1996_;
		gchar* _tmp1997_;
		_tmp1990_ = m;
		_tmp1991_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1990_);
		_tmp1992_ = _tmp1991_;
		_tmp1993_ = m;
		_tmp1994_ = vala_callable_get_return_type ((ValaCallable*) _tmp1993_);
		_tmp1995_ = _tmp1994_;
		_tmp1996_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1995_);
		_tmp1997_ = _tmp1996_;
		_tmp1984_ = g_strcmp0 (_tmp1992_, _tmp1997_) != 0;
		_g_free0 (_tmp1997_);
		_g_free0 (_tmp1992_);
	} else {
		_tmp1984_ = FALSE;
	}
	if (_tmp1984_) {
		ValaCCodeExpression* _tmp1998_;
		ValaMethod* _tmp1999_;
		ValaDataType* _tmp2000_;
		ValaDataType* _tmp2001_;
		gchar* _tmp2002_;
		gchar* _tmp2003_;
		ValaCCodeCastExpression* _tmp2004_;
		_tmp1998_ = ccall_expr;
		_tmp1999_ = m;
		_tmp2000_ = vala_callable_get_return_type ((ValaCallable*) _tmp1999_);
		_tmp2001_ = _tmp2000_;
		_tmp2002_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2001_);
		_tmp2003_ = _tmp2002_;
		_tmp2004_ = vala_ccode_cast_expression_new (_tmp1998_, _tmp2003_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp2004_;
		_g_free0 (_tmp2003_);
	}
	_tmp2005_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2005_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp2006_;
		ValaIterator* _tmp2007_;
		ValaIterator* _tmp2008_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp2009_;
		gpointer _tmp2010_;
		ValaExpression* _tmp2011_;
		ValaCCodeExpression* _tmp2012_;
		ValaCCodeExpression* _tmp2013_;
		ValaCCodeExpression* _tmp2014_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp2015_;
		ValaLocalVariable* _tmp2016_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp2017_;
		const gchar* _tmp2018_;
		const gchar* _tmp2019_;
		ValaCCodeExpression* _tmp2020_;
		ValaLocalVariable* _tmp2021_;
		ValaCCodeFile* _tmp2022_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp2023_;
		ValaExpression* _tmp2024_;
		ValaExpression* _tmp2025_;
		ValaCCodeExpression* _tmp2026_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp2027_;
		ValaExpression* _tmp2028_;
		ValaExpression* _tmp2029_;
		ValaCCodeExpression* _tmp2030_;
		ValaCCodeExpression* _tmp2031_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2032_;
		ValaExpression* _tmp2033_;
		ValaExpression* _tmp2034_;
		ValaDataType* _tmp2035_;
		ValaDataType* _tmp2036_;
		ValaArrayType* _tmp2037_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2038_;
		ValaDataType* _tmp2039_;
		ValaDataType* _tmp2040_;
		gchar* _tmp2041_;
		gchar* _tmp2042_;
		gchar* _tmp2043_;
		gchar* _tmp2044_;
		ValaCCodeIdentifier* _tmp2045_;
		ValaCCodeIdentifier* _tmp2046_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2047_;
		ValaCCodeExpression* _tmp2048_;
		ValaCCodeBinaryExpression* _tmp2049_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2050_;
		ValaCCodeExpression* _tmp2051_;
		ValaCCodeBinaryExpression* _tmp2052_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2053_;
		ValaCCodeIdentifier* _tmp2054_;
		ValaCCodeFunctionCall* _tmp2055_;
		ValaCCodeFunctionCall* _tmp2056_;
		ValaCCodeFunctionCall* _tmp2057_;
		ValaCCodeExpression* _tmp2058_;
		ValaCCodeExpression* _tmp2059_;
		ValaCCodeBinaryExpression* _tmp2060_;
		ValaCCodeBinaryExpression* _tmp2061_;
		ValaCCodeFunctionCall* _tmp2062_;
		ValaCCodeConstant* _tmp2063_;
		ValaCCodeConstant* _tmp2064_;
		ValaCCodeFunctionCall* _tmp2065_;
		ValaCCodeIdentifier* _tmp2066_;
		ValaCCodeBinaryExpression* _tmp2067_;
		ValaCCodeBinaryExpression* _tmp2068_;
		ValaCCodeBinaryExpression* _tmp2069_;
		ValaCCodeFunction* _tmp2070_;
		ValaCCodeFunction* _tmp2071_;
		ValaCCodeExpression* _tmp2072_;
		ValaCCodeExpression* _tmp2073_;
		ValaCCodeFunction* _tmp2074_;
		ValaCCodeFunction* _tmp2075_;
		ValaCCodeExpression* _tmp2076_;
		ValaCCodeFunction* _tmp2077_;
		ValaCCodeFunction* _tmp2078_;
		ValaCCodeBinaryExpression* _tmp2079_;
		ValaCCodeFunctionCall* _tmp2080_;
		ValaCCodeConstant* _tmp2081_;
		ValaCCodeConstant* _tmp2082_;
		ValaCCodeConditionalExpression* _tmp2083_;
		ValaCCodeConditionalExpression* _tmp2084_;
		ValaCCodeFunction* _tmp2085_;
		ValaCCodeFunction* _tmp2086_;
		ValaMemberAccess* _tmp2087_;
		ValaExpression* _tmp2088_;
		ValaExpression* _tmp2089_;
		ValaCCodeExpression* _tmp2090_;
		ValaCCodeExpression* _tmp2091_;
		ValaCCodeExpression* _tmp2092_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2093_;
		ValaExpression* _tmp2094_;
		ValaExpression* _tmp2095_;
		ValaSymbol* _tmp2096_;
		ValaSymbol* _tmp2097_;
		ValaSymbol* _tmp2098_;
		gboolean _tmp2099_ = FALSE;
		gboolean _tmp2100_ = FALSE;
		ValaSymbol* _tmp2101_;
		_tmp2006_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_tmp2007_ = vala_iterable_iterator ((ValaIterable*) _tmp2006_);
		arg_it = _tmp2007_;
		_tmp2008_ = arg_it;
		vala_iterator_next (_tmp2008_);
		_tmp2009_ = arg_it;
		_tmp2010_ = vala_iterator_get (_tmp2009_);
		_tmp2011_ = (ValaExpression*) _tmp2010_;
		_tmp2012_ = vala_get_cvalue (_tmp2011_);
		_tmp2013_ = _vala_ccode_node_ref0 (_tmp2012_);
		_tmp2014_ = _tmp2013_;
		_vala_code_node_unref0 (_tmp2011_);
		new_size = _tmp2014_;
		_tmp2015_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp2016_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2015_, TRUE, NULL, FALSE);
		temp_decl = _tmp2016_;
		_tmp2017_ = temp_decl;
		_tmp2018_ = vala_symbol_get_name ((ValaSymbol*) _tmp2017_);
		_tmp2019_ = _tmp2018_;
		_tmp2020_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2019_);
		temp_ref = _tmp2020_;
		_tmp2021_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2021_, FALSE);
		_tmp2022_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp2022_, "string.h", FALSE);
		_tmp2023_ = ma;
		_tmp2024_ = vala_member_access_get_inner (_tmp2023_);
		_tmp2025_ = _tmp2024_;
		_tmp2026_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2025_, 1);
		clen = _tmp2026_;
		_tmp2027_ = ma;
		_tmp2028_ = vala_member_access_get_inner (_tmp2027_);
		_tmp2029_ = _tmp2028_;
		_tmp2030_ = vala_get_cvalue (_tmp2029_);
		_tmp2031_ = _vala_ccode_node_ref0 (_tmp2030_);
		celems = _tmp2031_;
		_tmp2032_ = ma;
		_tmp2033_ = vala_member_access_get_inner (_tmp2032_);
		_tmp2034_ = _tmp2033_;
		_tmp2035_ = vala_expression_get_value_type (_tmp2034_);
		_tmp2036_ = _tmp2035_;
		_tmp2037_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2036_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2037_;
		_tmp2038_ = array_type;
		_tmp2039_ = vala_array_type_get_element_type (_tmp2038_);
		_tmp2040_ = _tmp2039_;
		_tmp2041_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2040_);
		_tmp2042_ = _tmp2041_;
		_tmp2043_ = g_strdup_printf ("sizeof (%s)", _tmp2042_);
		_tmp2044_ = _tmp2043_;
		_tmp2045_ = vala_ccode_identifier_new (_tmp2044_);
		_tmp2046_ = _tmp2045_;
		_g_free0 (_tmp2044_);
		_g_free0 (_tmp2042_);
		csizeof = _tmp2046_;
		_tmp2047_ = temp_ref;
		_tmp2048_ = clen;
		_tmp2049_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2047_, _tmp2048_);
		cdelta = _tmp2049_;
		_tmp2050_ = temp_ref;
		_tmp2051_ = clen;
		_tmp2052_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2050_, _tmp2051_);
		ccheck = _tmp2052_;
		_tmp2053_ = vala_ccode_identifier_new ("memset");
		_tmp2054_ = _tmp2053_;
		_tmp2055_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2054_);
		_tmp2056_ = _tmp2055_;
		_vala_ccode_node_unref0 (_tmp2054_);
		czero = _tmp2056_;
		_tmp2057_ = czero;
		_tmp2058_ = celems;
		_tmp2059_ = clen;
		_tmp2060_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2058_, _tmp2059_);
		_tmp2061_ = _tmp2060_;
		vala_ccode_function_call_add_argument (_tmp2057_, (ValaCCodeExpression*) _tmp2061_);
		_vala_ccode_node_unref0 (_tmp2061_);
		_tmp2062_ = czero;
		_tmp2063_ = vala_ccode_constant_new ("0");
		_tmp2064_ = _tmp2063_;
		vala_ccode_function_call_add_argument (_tmp2062_, (ValaCCodeExpression*) _tmp2064_);
		_vala_ccode_node_unref0 (_tmp2064_);
		_tmp2065_ = czero;
		_tmp2066_ = csizeof;
		_tmp2067_ = cdelta;
		_tmp2068_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2066_, (ValaCCodeExpression*) _tmp2067_);
		_tmp2069_ = _tmp2068_;
		vala_ccode_function_call_add_argument (_tmp2065_, (ValaCCodeExpression*) _tmp2069_);
		_vala_ccode_node_unref0 (_tmp2069_);
		_tmp2070_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2071_ = _tmp2070_;
		_tmp2072_ = temp_ref;
		_tmp2073_ = new_size;
		vala_ccode_function_add_assignment (_tmp2071_, _tmp2072_, _tmp2073_);
		_tmp2074_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2075_ = _tmp2074_;
		_tmp2076_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2075_, _tmp2076_);
		_tmp2077_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2078_ = _tmp2077_;
		_tmp2079_ = ccheck;
		_tmp2080_ = czero;
		_tmp2081_ = vala_ccode_constant_new ("NULL");
		_tmp2082_ = _tmp2081_;
		_tmp2083_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2079_, (ValaCCodeExpression*) _tmp2080_, (ValaCCodeExpression*) _tmp2082_);
		_tmp2084_ = _tmp2083_;
		vala_ccode_function_add_expression (_tmp2078_, (ValaCCodeExpression*) _tmp2084_);
		_vala_ccode_node_unref0 (_tmp2084_);
		_vala_ccode_node_unref0 (_tmp2082_);
		_tmp2085_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2086_ = _tmp2085_;
		_tmp2087_ = ma;
		_tmp2088_ = vala_member_access_get_inner (_tmp2087_);
		_tmp2089_ = _tmp2088_;
		_tmp2090_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2089_, 1);
		_tmp2091_ = _tmp2090_;
		_tmp2092_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2086_, _tmp2091_, _tmp2092_);
		_vala_ccode_node_unref0 (_tmp2091_);
		_tmp2093_ = ma;
		_tmp2094_ = vala_member_access_get_inner (_tmp2093_);
		_tmp2095_ = _tmp2094_;
		_tmp2096_ = vala_expression_get_symbol_reference (_tmp2095_);
		_tmp2097_ = _tmp2096_;
		_tmp2098_ = _vala_code_node_ref0 (_tmp2097_);
		array_var = _tmp2098_;
		_tmp2101_ = array_var;
		if (_tmp2101_ != NULL) {
			ValaSymbol* _tmp2102_;
			_tmp2102_ = array_var;
			_tmp2100_ = vala_symbol_is_internal_symbol (_tmp2102_);
		} else {
			_tmp2100_ = FALSE;
		}
		if (_tmp2100_) {
			gboolean _tmp2103_ = FALSE;
			ValaSymbol* _tmp2104_;
			_tmp2104_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2104_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2103_ = TRUE;
			} else {
				ValaSymbol* _tmp2105_;
				_tmp2105_ = array_var;
				_tmp2103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2105_, VALA_TYPE_FIELD);
			}
			_tmp2099_ = _tmp2103_;
		} else {
			_tmp2099_ = FALSE;
		}
		if (_tmp2099_) {
			ValaCCodeFunction* _tmp2106_;
			ValaCCodeFunction* _tmp2107_;
			ValaMemberAccess* _tmp2108_;
			ValaExpression* _tmp2109_;
			ValaExpression* _tmp2110_;
			ValaTargetValue* _tmp2111_;
			ValaTargetValue* _tmp2112_;
			ValaCCodeExpression* _tmp2113_;
			ValaCCodeExpression* _tmp2114_;
			_tmp2106_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2107_ = _tmp2106_;
			_tmp2108_ = ma;
			_tmp2109_ = vala_member_access_get_inner (_tmp2108_);
			_tmp2110_ = _tmp2109_;
			_tmp2111_ = vala_expression_get_target_value (_tmp2110_);
			_tmp2112_ = _tmp2111_;
			_tmp2113_ = vala_get_array_size_cvalue (_tmp2112_);
			_tmp2114_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2107_, _tmp2113_, _tmp2114_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2116_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2117_ = _tmp2116_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2117_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2118_;
		ValaDataType* _tmp2119_;
		_tmp2118_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2119_ = _tmp2118_;
		_tmp2115_ = !vala_data_type_is_disposable (_tmp2119_);
	} else {
		_tmp2115_ = FALSE;
	}
	if (_tmp2115_) {
		gboolean _tmp2120_ = FALSE;
		ValaCCodeExpression* _tmp2121_;
		_tmp2121_ = ccall_expr;
		if (_tmp2121_ != NULL) {
			_tmp2120_ = !return_result_via_out_param;
		} else {
			_tmp2120_ = FALSE;
		}
		if (_tmp2120_) {
			ValaCCodeFunction* _tmp2122_;
			ValaCCodeFunction* _tmp2123_;
			ValaCCodeExpression* _tmp2124_;
			_tmp2122_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2123_ = _tmp2122_;
			_tmp2124_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2123_, _tmp2124_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2125_;
		ValaDataType* _tmp2126_;
		ValaDataType* _tmp2127_;
		gboolean _tmp2128_ = FALSE;
		ValaDataType* _tmp2129_;
		ValaDataType* _tmp2130_;
		gboolean _tmp2183_ = FALSE;
		ValaMethod* _tmp2184_;
		_tmp2125_ = itype;
		_tmp2126_ = vala_data_type_get_return_type (_tmp2125_);
		_tmp2127_ = _vala_code_node_ref0 (_tmp2126_);
		result_type = _tmp2127_;
		_tmp2129_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2130_ = _tmp2129_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2130_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2131_;
			ValaDataType* _tmp2132_;
			_tmp2131_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2132_ = _tmp2131_;
			_tmp2128_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2132_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2128_ = FALSE;
		}
		if (_tmp2128_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2133_;
			ValaDataType* _tmp2134_;
			ValaTypeParameter* _tmp2135_;
			ValaTypeParameter* _tmp2136_;
			ValaTypeParameter* _tmp2137_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2138_;
			ValaSymbol* _tmp2139_;
			ValaSymbol* _tmp2140_;
			ValaSymbol* _tmp2141_;
			ValaSymbol* _tmp2142_;
			ValaStruct* _tmp2143_;
			gboolean _tmp2144_ = FALSE;
			ValaTypeParameter* _tmp2145_;
			ValaSymbol* _tmp2146_;
			ValaSymbol* _tmp2147_;
			ValaTypeSymbol* _tmp2148_;
			gboolean _tmp2157_ = FALSE;
			gboolean _tmp2158_ = FALSE;
			ValaStruct* _tmp2159_;
			_tmp2133_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2134_ = _tmp2133_;
			_tmp2135_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2134_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2136_ = _tmp2135_;
			_tmp2137_ = _vala_code_node_ref0 (_tmp2136_);
			type_parameter = _tmp2137_;
			_tmp2138_ = type_parameter;
			_tmp2139_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2138_);
			_tmp2140_ = _tmp2139_;
			_tmp2141_ = vala_symbol_get_parent_symbol (_tmp2140_);
			_tmp2142_ = _tmp2141_;
			_tmp2143_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2142_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2142_) : NULL);
			st = _tmp2143_;
			_tmp2145_ = type_parameter;
			_tmp2146_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2145_);
			_tmp2147_ = _tmp2146_;
			_tmp2148_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2147_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2148_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2144_ = TRUE;
			} else {
				gboolean _tmp2149_ = FALSE;
				ValaStruct* _tmp2150_;
				_tmp2150_ = st;
				if (_tmp2150_ != NULL) {
					ValaStruct* _tmp2151_;
					gchar* _tmp2152_;
					gchar* _tmp2153_;
					_tmp2151_ = st;
					_tmp2152_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2151_);
					_tmp2153_ = _tmp2152_;
					_tmp2149_ = g_strcmp0 (_tmp2153_, "va_list") == 0;
					_g_free0 (_tmp2153_);
				} else {
					_tmp2149_ = FALSE;
				}
				_tmp2144_ = _tmp2149_;
			}
			if (_tmp2144_) {
				ValaDataType* _tmp2154_;
				ValaDataType* _tmp2155_;
				ValaDataType* _tmp2156_;
				_tmp2154_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2155_ = _tmp2154_;
				_tmp2156_ = _vala_code_node_ref0 (_tmp2155_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2156_;
			}
			_tmp2159_ = st;
			if (_tmp2159_ != NULL) {
				ValaStruct* _tmp2160_;
				gchar* _tmp2161_;
				gchar* _tmp2162_;
				_tmp2160_ = st;
				_tmp2161_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2160_);
				_tmp2162_ = _tmp2161_;
				_tmp2158_ = g_strcmp0 (_tmp2162_, "va_list") == 0;
				_g_free0 (_tmp2162_);
			} else {
				_tmp2158_ = FALSE;
			}
			if (_tmp2158_) {
				ValaMemberAccess* _tmp2163_;
				const gchar* _tmp2164_;
				const gchar* _tmp2165_;
				_tmp2163_ = ma;
				_tmp2164_ = vala_member_access_get_member_name (_tmp2163_);
				_tmp2165_ = _tmp2164_;
				_tmp2157_ = g_strcmp0 (_tmp2165_, "arg") == 0;
			} else {
				_tmp2157_ = FALSE;
			}
			if (_tmp2157_) {
				gboolean _tmp2166_ = FALSE;
				ValaDataType* _tmp2167_;
				_tmp2167_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2167_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2168_;
					ValaDelegate* _tmp2169_;
					ValaDelegate* _tmp2170_;
					gboolean _tmp2171_;
					gboolean _tmp2172_;
					_tmp2168_ = result_type;
					_tmp2169_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2168_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2170_ = _tmp2169_;
					_tmp2171_ = vala_delegate_get_has_target (_tmp2170_);
					_tmp2172_ = _tmp2171_;
					_tmp2166_ = _tmp2172_;
				} else {
					_tmp2166_ = FALSE;
				}
				if (_tmp2166_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2173_;
					ValaTargetValue* _tmp2174_;
					ValaGLibValue* _tmp2175_;
					ValaCCodeExpression* _tmp2176_;
					ValaGLibValue* _tmp2179_;
					ValaCCodeExpression* _tmp2180_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2173_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2174_ = _tmp2173_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2174_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2175_ = arg_value;
					_tmp2176_ = _tmp2175_->delegate_target_cvalue;
					if (_tmp2176_ == NULL) {
						ValaGLibValue* _tmp2177_;
						ValaCCodeConstant* _tmp2178_;
						_tmp2177_ = arg_value;
						_tmp2178_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2177_->delegate_target_cvalue);
						_tmp2177_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2178_;
					}
					_tmp2179_ = arg_value;
					_tmp2180_ = _tmp2179_->delegate_target_destroy_notify_cvalue;
					if (_tmp2180_ == NULL) {
						ValaGLibValue* _tmp2181_;
						ValaCCodeConstant* _tmp2182_;
						_tmp2181_ = arg_value;
						_tmp2182_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2181_->delegate_target_destroy_notify_cvalue);
						_tmp2181_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2182_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2184_ = m;
		if (_tmp2184_ != NULL) {
			ValaMethod* _tmp2185_;
			_tmp2185_ = m;
			_tmp2183_ = vala_method_get_format_arg_index (_tmp2185_) >= 0;
		} else {
			_tmp2183_ = FALSE;
		}
		if (_tmp2183_) {
			ValaCCodeExpression* _tmp2186_;
			_tmp2186_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2186_);
		} else {
			gboolean _tmp2187_ = FALSE;
			ValaMethod* _tmp2188_;
			_tmp2188_ = m;
			if (_tmp2188_ != NULL) {
				ValaMethod* _tmp2189_;
				_tmp2189_ = m;
				_tmp2187_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2189_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2187_ = FALSE;
			}
			if (_tmp2187_) {
				ValaCCodeExpression* _tmp2190_;
				_tmp2190_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2190_);
			} else {
				gboolean _tmp2191_ = FALSE;
				gboolean _tmp2192_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2192_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2192_ = FALSE;
				}
				if (_tmp2192_) {
					gboolean _tmp2193_ = FALSE;
					ValaDataType* _tmp2194_;
					_tmp2194_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2194_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2195_;
						_tmp2195_ = result_type;
						_tmp2193_ = !vala_data_type_is_disposable (_tmp2195_);
					} else {
						_tmp2193_ = FALSE;
					}
					_tmp2191_ = _tmp2193_;
				} else {
					_tmp2191_ = FALSE;
				}
				if (_tmp2191_) {
					ValaCCodeExpression* _tmp2196_;
					_tmp2196_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2196_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2197_;
						ValaDataType* _tmp2198_;
						gboolean _tmp2199_;
						gboolean _tmp2200_;
						ValaLocalVariable* _tmp2201_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2202_;
						const gchar* _tmp2203_;
						const gchar* _tmp2204_;
						ValaCCodeExpression* _tmp2205_;
						ValaLocalVariable* _tmp2206_;
						ValaCCodeFunction* _tmp2207_;
						ValaCCodeFunction* _tmp2208_;
						ValaCCodeExpression* _tmp2209_;
						ValaCCodeExpression* _tmp2210_;
						ValaCCodeExpression* _tmp2211_;
						ValaTargetValue* _tmp2212_;
						ValaTargetValue* _tmp2213_;
						_tmp2197_ = result_type;
						_tmp2198_ = result_type;
						_tmp2199_ = vala_data_type_get_value_owned (_tmp2198_);
						_tmp2200_ = _tmp2199_;
						_tmp2201_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2197_, _tmp2200_, NULL, FALSE);
						temp_var = _tmp2201_;
						_tmp2202_ = temp_var;
						_tmp2203_ = vala_symbol_get_name ((ValaSymbol*) _tmp2202_);
						_tmp2204_ = _tmp2203_;
						_tmp2205_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2204_);
						temp_ref = _tmp2205_;
						_tmp2206_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2206_, FALSE);
						_tmp2207_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2208_ = _tmp2207_;
						_tmp2209_ = temp_ref;
						_tmp2210_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2208_, _tmp2209_, _tmp2210_);
						_tmp2211_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2211_);
						_tmp2212_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2213_ = _tmp2212_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2213_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2214_;
						ValaTargetValue* _tmp2215_;
						ValaTargetValue* _tmp2216_;
						_tmp2214_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2214_);
						_tmp2215_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2216_ = _tmp2215_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2216_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2217_ = params;
	_tmp2218_ = vala_iterable_iterator ((ValaIterable*) _tmp2217_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2218_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2219_;
		gint _arg_size = 0;
		ValaList* _tmp2220_;
		gint _tmp2221_;
		gint _tmp2222_;
		gint _arg_index = 0;
		_tmp2219_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
		_arg_list = _tmp2219_;
		_tmp2220_ = _arg_list;
		_tmp2221_ = vala_collection_get_size ((ValaCollection*) _tmp2220_);
		_tmp2222_ = _tmp2221_;
		_arg_size = _tmp2222_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2223_;
			gint _tmp2224_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2225_;
			gpointer _tmp2226_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2227_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2230_;
			ValaUnaryExpression* _tmp2231_;
			gboolean _tmp2232_ = FALSE;
			ValaUnaryExpression* _tmp2233_;
			gboolean _tmp2291_ = FALSE;
			ValaUnaryExpression* _tmp2292_;
			ValaUnaryExpression* _tmp2296_;
			ValaExpression* _tmp2297_;
			ValaExpression* _tmp2298_;
			ValaDataType* _tmp2299_;
			ValaDataType* _tmp2300_;
			gboolean _tmp2310_ = FALSE;
			ValaMemberAccess* _tmp2311_;
			ValaSymbol* _tmp2312_;
			ValaSymbol* _tmp2313_;
			ValaUnaryExpression* _tmp2329_;
			ValaExpression* _tmp2330_;
			ValaExpression* _tmp2331_;
			ValaTargetValue* _tmp2332_;
			ValaTargetValue* _tmp2333_;
			ValaUnaryExpression* _tmp2334_;
			ValaTargetValue* _tmp2335_;
			ValaTargetValue* _tmp2336_;
			ValaUnaryExpression* _tmp2337_;
			ValaExpression* _tmp2338_;
			ValaExpression* _tmp2339_;
			ValaDataType* _tmp2340_;
			ValaDataType* _tmp2341_;
			ValaExpression* _tmp2342_;
			ValaTargetValue* _tmp2343_;
			ValaTargetValue* _tmp2344_;
			ValaSourceReference* _tmp2345_;
			ValaSourceReference* _tmp2346_;
			gboolean _tmp2347_ = FALSE;
			ValaParameter* _tmp2348_;
			_arg_index = _arg_index + 1;
			_tmp2223_ = _arg_index;
			_tmp2224_ = _arg_size;
			if (!(_tmp2223_ < _tmp2224_)) {
				break;
			}
			_tmp2225_ = _arg_list;
			_tmp2226_ = vala_list_get (_tmp2225_, _arg_index);
			arg = (ValaExpression*) _tmp2226_;
			param = NULL;
			_tmp2227_ = params_it;
			if (vala_iterator_next (_tmp2227_)) {
				ValaIterator* _tmp2228_;
				gpointer _tmp2229_;
				_tmp2228_ = params_it;
				_tmp2229_ = vala_iterator_get (_tmp2228_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2229_;
			}
			_tmp2230_ = arg;
			_tmp2231_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2230_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2230_) : NULL);
			unary = _tmp2231_;
			_tmp2233_ = unary;
			if (_tmp2233_ != NULL) {
				ValaUnaryExpression* _tmp2234_;
				ValaUnaryOperator _tmp2235_;
				ValaUnaryOperator _tmp2236_;
				_tmp2234_ = unary;
				_tmp2235_ = vala_unary_expression_get_operator (_tmp2234_);
				_tmp2236_ = _tmp2235_;
				_tmp2232_ = _tmp2236_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2232_ = FALSE;
			}
			if (_tmp2232_) {
				gboolean _tmp2237_ = FALSE;
				gboolean _tmp2238_ = FALSE;
				gboolean _tmp2239_ = FALSE;
				gboolean _tmp2240_ = FALSE;
				ValaParameter* _tmp2241_;
				_tmp2241_ = param;
				if (_tmp2241_ != NULL) {
					ValaParameter* _tmp2242_;
					_tmp2242_ = param;
					_tmp2240_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2242_);
				} else {
					_tmp2240_ = FALSE;
				}
				if (_tmp2240_) {
					ValaParameter* _tmp2243_;
					ValaDataType* _tmp2244_;
					ValaDataType* _tmp2245_;
					_tmp2243_ = param;
					_tmp2244_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2243_);
					_tmp2245_ = _tmp2244_;
					_tmp2239_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2245_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2239_ = FALSE;
				}
				if (_tmp2239_) {
					ValaParameter* _tmp2246_;
					ValaDataType* _tmp2247_;
					ValaDataType* _tmp2248_;
					gboolean _tmp2249_;
					gboolean _tmp2250_;
					_tmp2246_ = param;
					_tmp2247_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2246_);
					_tmp2248_ = _tmp2247_;
					_tmp2249_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2248_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2250_ = _tmp2249_;
					_tmp2238_ = !_tmp2250_;
				} else {
					_tmp2238_ = FALSE;
				}
				if (_tmp2238_) {
					ValaParameter* _tmp2251_;
					ValaDataType* _tmp2252_;
					ValaDataType* _tmp2253_;
					gint _tmp2254_;
					gint _tmp2255_;
					_tmp2251_ = param;
					_tmp2252_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2251_);
					_tmp2253_ = _tmp2252_;
					_tmp2254_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2253_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2255_ = _tmp2254_;
					_tmp2237_ = _tmp2255_ == 1;
				} else {
					_tmp2237_ = FALSE;
				}
				if (_tmp2237_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2256_;
					ValaExpression* _tmp2257_;
					ValaExpression* _tmp2258_;
					ValaSymbol* _tmp2259_;
					ValaSymbol* _tmp2260_;
					gboolean _tmp2261_ = FALSE;
					gboolean _tmp2262_ = FALSE;
					gboolean _tmp2263_ = FALSE;
					gboolean _tmp2264_ = FALSE;
					ValaVariable* _tmp2265_;
					_tmp2256_ = unary;
					_tmp2257_ = vala_unary_expression_get_inner (_tmp2256_);
					_tmp2258_ = _tmp2257_;
					_tmp2259_ = vala_expression_get_symbol_reference (_tmp2258_);
					_tmp2260_ = _tmp2259_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2260_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2260_) : NULL;
					_tmp2265_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2265_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2264_ = TRUE;
					} else {
						ValaVariable* _tmp2266_;
						_tmp2266_ = array_var;
						_tmp2264_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2266_, VALA_TYPE_FIELD);
					}
					if (_tmp2264_) {
						ValaVariable* _tmp2267_;
						_tmp2267_ = array_var;
						_tmp2263_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2267_);
					} else {
						_tmp2263_ = FALSE;
					}
					if (_tmp2263_) {
						ValaVariable* _tmp2268_;
						ValaDataType* _tmp2269_;
						ValaDataType* _tmp2270_;
						_tmp2268_ = array_var;
						_tmp2269_ = vala_variable_get_variable_type (_tmp2268_);
						_tmp2270_ = _tmp2269_;
						_tmp2262_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2270_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2262_ = FALSE;
					}
					if (_tmp2262_) {
						ValaVariable* _tmp2271_;
						ValaDataType* _tmp2272_;
						ValaDataType* _tmp2273_;
						gboolean _tmp2274_;
						gboolean _tmp2275_;
						_tmp2271_ = array_var;
						_tmp2272_ = vala_variable_get_variable_type (_tmp2271_);
						_tmp2273_ = _tmp2272_;
						_tmp2274_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2273_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2275_ = _tmp2274_;
						_tmp2261_ = !_tmp2275_;
					} else {
						_tmp2261_ = FALSE;
					}
					if (_tmp2261_) {
						ValaCCodeFunction* _tmp2276_;
						ValaCCodeFunction* _tmp2277_;
						ValaUnaryExpression* _tmp2278_;
						ValaExpression* _tmp2279_;
						ValaExpression* _tmp2280_;
						ValaTargetValue* _tmp2281_;
						ValaTargetValue* _tmp2282_;
						ValaCCodeExpression* _tmp2283_;
						ValaUnaryExpression* _tmp2284_;
						ValaExpression* _tmp2285_;
						ValaExpression* _tmp2286_;
						ValaTargetValue* _tmp2287_;
						ValaTargetValue* _tmp2288_;
						ValaCCodeExpression* _tmp2289_;
						ValaCCodeExpression* _tmp2290_;
						_tmp2276_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2277_ = _tmp2276_;
						_tmp2278_ = unary;
						_tmp2279_ = vala_unary_expression_get_inner (_tmp2278_);
						_tmp2280_ = _tmp2279_;
						_tmp2281_ = vala_expression_get_target_value (_tmp2280_);
						_tmp2282_ = _tmp2281_;
						_tmp2283_ = vala_get_array_size_cvalue (_tmp2282_);
						_tmp2284_ = unary;
						_tmp2285_ = vala_unary_expression_get_inner (_tmp2284_);
						_tmp2286_ = _tmp2285_;
						_tmp2287_ = vala_expression_get_target_value (_tmp2286_);
						_tmp2288_ = _tmp2287_;
						_tmp2289_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2288_, 1);
						_tmp2290_ = _tmp2289_;
						vala_ccode_function_add_assignment (_tmp2277_, _tmp2283_, _tmp2290_);
						_vala_ccode_node_unref0 (_tmp2290_);
					}
				}
			}
			_tmp2292_ = unary;
			if (_tmp2292_ == NULL) {
				_tmp2291_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2293_;
				ValaUnaryOperator _tmp2294_;
				ValaUnaryOperator _tmp2295_;
				_tmp2293_ = unary;
				_tmp2294_ = vala_unary_expression_get_operator (_tmp2293_);
				_tmp2295_ = _tmp2294_;
				_tmp2291_ = _tmp2295_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2291_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2296_ = unary;
			_tmp2297_ = vala_unary_expression_get_inner (_tmp2296_);
			_tmp2298_ = _tmp2297_;
			_tmp2299_ = vala_expression_get_value_type (_tmp2298_);
			_tmp2300_ = _tmp2299_;
			if (vala_ccode_base_module_requires_destroy (_tmp2300_)) {
				ValaCCodeFunction* _tmp2301_;
				ValaCCodeFunction* _tmp2302_;
				ValaUnaryExpression* _tmp2303_;
				ValaExpression* _tmp2304_;
				ValaExpression* _tmp2305_;
				ValaTargetValue* _tmp2306_;
				ValaTargetValue* _tmp2307_;
				ValaCCodeExpression* _tmp2308_;
				ValaCCodeExpression* _tmp2309_;
				_tmp2301_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2302_ = _tmp2301_;
				_tmp2303_ = unary;
				_tmp2304_ = vala_unary_expression_get_inner (_tmp2303_);
				_tmp2305_ = _tmp2304_;
				_tmp2306_ = vala_expression_get_target_value (_tmp2305_);
				_tmp2307_ = _tmp2306_;
				_tmp2308_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2307_, FALSE);
				_tmp2309_ = _tmp2308_;
				vala_ccode_function_add_expression (_tmp2302_, _tmp2309_);
				_vala_ccode_node_unref0 (_tmp2309_);
			}
			_tmp2311_ = ma;
			_tmp2312_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2311_);
			_tmp2313_ = _tmp2312_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2313_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2314_;
				ValaTargetValue* _tmp2315_;
				ValaTargetValue* _tmp2316_;
				ValaDataType* _tmp2317_;
				ValaDataType* _tmp2318_;
				_tmp2314_ = unary;
				_tmp2315_ = vala_expression_get_target_value ((ValaExpression*) _tmp2314_);
				_tmp2316_ = _tmp2315_;
				_tmp2317_ = vala_target_value_get_value_type (_tmp2316_);
				_tmp2318_ = _tmp2317_;
				_tmp2310_ = _tmp2318_ == NULL;
			} else {
				_tmp2310_ = FALSE;
			}
			if (_tmp2310_) {
				ValaUnaryExpression* _tmp2319_;
				ValaTargetValue* _tmp2320_;
				ValaTargetValue* _tmp2321_;
				ValaUnaryExpression* _tmp2322_;
				ValaExpression* _tmp2323_;
				ValaExpression* _tmp2324_;
				ValaDataType* _tmp2325_;
				ValaDataType* _tmp2326_;
				ValaDataType* _tmp2327_;
				ValaDataType* _tmp2328_;
				_tmp2319_ = unary;
				_tmp2320_ = vala_expression_get_target_value ((ValaExpression*) _tmp2319_);
				_tmp2321_ = _tmp2320_;
				_tmp2322_ = unary;
				_tmp2323_ = vala_unary_expression_get_inner (_tmp2322_);
				_tmp2324_ = _tmp2323_;
				_tmp2325_ = vala_expression_get_value_type (_tmp2324_);
				_tmp2326_ = _tmp2325_;
				_tmp2327_ = vala_data_type_copy (_tmp2326_);
				_tmp2328_ = _tmp2327_;
				vala_target_value_set_value_type (_tmp2321_, _tmp2328_);
				_vala_code_node_unref0 (_tmp2328_);
			}
			_tmp2329_ = unary;
			_tmp2330_ = vala_unary_expression_get_inner (_tmp2329_);
			_tmp2331_ = _tmp2330_;
			_tmp2332_ = vala_expression_get_target_value (_tmp2331_);
			_tmp2333_ = _tmp2332_;
			_tmp2334_ = unary;
			_tmp2335_ = vala_expression_get_target_value ((ValaExpression*) _tmp2334_);
			_tmp2336_ = _tmp2335_;
			_tmp2337_ = unary;
			_tmp2338_ = vala_unary_expression_get_inner (_tmp2337_);
			_tmp2339_ = _tmp2338_;
			_tmp2340_ = vala_expression_get_value_type (_tmp2339_);
			_tmp2341_ = _tmp2340_;
			_tmp2342_ = arg;
			_tmp2343_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2336_, _tmp2341_, (ValaCodeNode*) _tmp2342_);
			_tmp2344_ = _tmp2343_;
			_tmp2345_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2346_ = _tmp2345_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2333_, _tmp2344_, _tmp2346_);
			_vala_target_value_unref0 (_tmp2344_);
			_tmp2348_ = param;
			if (_tmp2348_ != NULL) {
				ValaParameter* _tmp2349_;
				_tmp2349_ = param;
				_tmp2347_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2349_);
			} else {
				_tmp2347_ = FALSE;
			}
			if (_tmp2347_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2350_;
				ValaCCodeIdentifier* _tmp2351_;
				ValaCCodeFunctionCall* _tmp2352_;
				ValaCCodeFunctionCall* _tmp2353_;
				ValaCCodeFunctionCall* _tmp2354_;
				ValaUnaryExpression* _tmp2355_;
				ValaExpression* _tmp2356_;
				ValaExpression* _tmp2357_;
				ValaTargetValue* _tmp2358_;
				ValaTargetValue* _tmp2359_;
				ValaCCodeExpression* _tmp2360_;
				ValaCCodeFunction* _tmp2361_;
				ValaCCodeFunction* _tmp2362_;
				ValaUnaryExpression* _tmp2363_;
				ValaExpression* _tmp2364_;
				ValaExpression* _tmp2365_;
				ValaTargetValue* _tmp2366_;
				ValaTargetValue* _tmp2367_;
				ValaCCodeExpression* _tmp2368_;
				ValaCCodeExpression* _tmp2369_;
				ValaCCodeFunctionCall* _tmp2370_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2350_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2351_ = _tmp2350_;
				_tmp2352_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2351_);
				_tmp2353_ = _tmp2352_;
				_vala_ccode_node_unref0 (_tmp2351_);
				len_call = _tmp2353_;
				_tmp2354_ = len_call;
				_tmp2355_ = unary;
				_tmp2356_ = vala_unary_expression_get_inner (_tmp2355_);
				_tmp2357_ = _tmp2356_;
				_tmp2358_ = vala_expression_get_target_value (_tmp2357_);
				_tmp2359_ = _tmp2358_;
				_tmp2360_ = vala_get_cvalue_ (_tmp2359_);
				vala_ccode_function_call_add_argument (_tmp2354_, _tmp2360_);
				_tmp2361_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2362_ = _tmp2361_;
				_tmp2363_ = unary;
				_tmp2364_ = vala_unary_expression_get_inner (_tmp2363_);
				_tmp2365_ = _tmp2364_;
				_tmp2366_ = vala_expression_get_target_value (_tmp2365_);
				_tmp2367_ = _tmp2366_;
				_tmp2368_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2367_, 1);
				_tmp2369_ = _tmp2368_;
				_tmp2370_ = len_call;
				vala_ccode_function_add_assignment (_tmp2362_, _tmp2369_, (ValaCCodeExpression*) _tmp2370_);
				_vala_ccode_node_unref0 (_tmp2369_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp2373_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2373_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2374_;
		ValaSymbol* _tmp2375_;
		ValaSymbol* _tmp2376_;
		_tmp2374_ = m;
		_tmp2375_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2374_);
		_tmp2376_ = _tmp2375_;
		_tmp2372_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2376_, VALA_TYPE_CLASS);
	} else {
		_tmp2372_ = FALSE;
	}
	if (_tmp2372_) {
		gboolean _tmp2377_ = FALSE;
		gboolean _tmp2378_ = FALSE;
		ValaClass* _tmp2379_;
		ValaClass* _tmp2380_;
		gboolean _tmp2381_;
		gboolean _tmp2382_;
		_tmp2379_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2380_ = _tmp2379_;
		_tmp2381_ = vala_class_get_is_compact (_tmp2380_);
		_tmp2382_ = _tmp2381_;
		if (_tmp2382_) {
			ValaClass* _tmp2383_;
			ValaClass* _tmp2384_;
			ValaClass* _tmp2385_;
			ValaClass* _tmp2386_;
			_tmp2383_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2384_ = _tmp2383_;
			_tmp2385_ = vala_class_get_base_class (_tmp2384_);
			_tmp2386_ = _tmp2385_;
			_tmp2378_ = _tmp2386_ != NULL;
		} else {
			_tmp2378_ = FALSE;
		}
		if (_tmp2378_) {
			_tmp2377_ = TRUE;
		} else {
			ValaClass* _tmp2387_;
			ValaClass* _tmp2388_;
			ValaClass* _tmp2389_;
			_tmp2387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2388_ = _tmp2387_;
			_tmp2389_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2377_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2388_, (ValaTypeSymbol*) _tmp2389_);
		}
		_tmp2371_ = _tmp2377_;
	} else {
		_tmp2371_ = FALSE;
	}
	if (_tmp2371_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2390_;
		ValaClass* _tmp2391_;
		gchar* _tmp2392_;
		gchar* _tmp2393_;
		gchar* _tmp2394_;
		gchar* _tmp2395_;
		ValaCCodeIdentifier* _tmp2396_;
		ValaCCodeIdentifier* _tmp2397_;
		ValaCCodeFunctionCall* _tmp2398_;
		ValaCCodeFunctionCall* _tmp2399_;
		ValaCCodeFunctionCall* _tmp2400_;
		ValaCCodeExpression* _tmp2401_;
		ValaCCodeExpression* _tmp2402_;
		ValaClass* _tmp2403_;
		ValaClass* _tmp2404_;
		gboolean _tmp2405_;
		gboolean _tmp2406_;
		ValaCCodeFunction* _tmp2410_;
		ValaCCodeFunction* _tmp2411_;
		ValaCCodeFunctionCall* _tmp2412_;
		_tmp2390_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2391_ = _tmp2390_;
		_tmp2392_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2391_, NULL);
		_tmp2393_ = _tmp2392_;
		_tmp2394_ = g_strdup_printf ("%s_instance_init", _tmp2393_);
		_tmp2395_ = _tmp2394_;
		_tmp2396_ = vala_ccode_identifier_new (_tmp2395_);
		_tmp2397_ = _tmp2396_;
		_tmp2398_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2397_);
		_tmp2399_ = _tmp2398_;
		_vala_ccode_node_unref0 (_tmp2397_);
		_g_free0 (_tmp2395_);
		_g_free0 (_tmp2393_);
		cinitcall = _tmp2399_;
		_tmp2400_ = cinitcall;
		_tmp2401_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2402_ = _tmp2401_;
		vala_ccode_function_call_add_argument (_tmp2400_, _tmp2402_);
		_vala_ccode_node_unref0 (_tmp2402_);
		_tmp2403_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2404_ = _tmp2403_;
		_tmp2405_ = vala_class_get_is_compact (_tmp2404_);
		_tmp2406_ = _tmp2405_;
		if (!_tmp2406_) {
			ValaCCodeFunctionCall* _tmp2407_;
			ValaCCodeConstant* _tmp2408_;
			ValaCCodeConstant* _tmp2409_;
			_tmp2407_ = cinitcall;
			_tmp2408_ = vala_ccode_constant_new ("NULL");
			_tmp2409_ = _tmp2408_;
			vala_ccode_function_call_add_argument (_tmp2407_, (ValaCCodeExpression*) _tmp2409_);
			_vala_ccode_node_unref0 (_tmp2409_);
		}
		_tmp2410_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2411_ = _tmp2410_;
		_tmp2412_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2411_, (ValaCCodeExpression*) _tmp2412_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp26_;
			gpointer _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaEnumValue* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaEnumValue* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			_enum_value_index = _enum_value_index + 1;
			_tmp24_ = _enum_value_index;
			_tmp25_ = _enum_value_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _enum_value_list;
			_tmp27_ = vala_list_get (_tmp26_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp27_;
			_tmp28_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = enum_value;
			_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			vala_ccode_function_add_case (_tmp29_, (ValaCCodeExpression*) _tmp34_);
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = enum_value;
			_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat ("\"", _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "\"", NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_constant_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_vala_code_node_unref0 (enum_value);
		}
	}
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	vala_ccode_function_close (_tmp47_);
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_add_return (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function_declaration (_tmp52_, _tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function (_tmp54_, _tmp55_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp8_;
			gboolean _tmp9_ = FALSE;
			ValaUnaryExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp8_) : NULL;
			_tmp10_ = unary;
			if (_tmp10_ != NULL) {
				gboolean _tmp11_ = FALSE;
				ValaUnaryExpression* _tmp12_;
				ValaUnaryOperator _tmp13_;
				ValaUnaryOperator _tmp14_;
				_tmp12_ = unary;
				_tmp13_ = vala_unary_expression_get_operator (_tmp12_);
				_tmp14_ = _tmp13_;
				if (_tmp14_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp11_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp15_;
					ValaUnaryOperator _tmp16_;
					ValaUnaryOperator _tmp17_;
					_tmp15_ = unary;
					_tmp16_ = vala_unary_expression_get_operator (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp11_ = _tmp17_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp9_ = _tmp11_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_PRINTF);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

