/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};

static gint ValaUnaryExpression_private_offset;
static gpointer vala_unary_expression_parent_class = NULL;

static void vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                         ValaUnaryOperator value);
static void vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                      ValaExpression* value);
static void vala_unary_expression_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                                            ValaExpression* expr);
static void vala_unary_expression_real_get_error_types (ValaCodeNode* base,
                                                 ValaCollection* collection,
                                                 ValaSourceReference* source_reference);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                       ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);
static GType vala_unary_expression_get_type_once (void);

static inline gpointer
vala_unary_expression_get_instance_private (ValaUnaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaUnaryExpression_private_offset);
}

ValaUnaryOperator
vala_unary_expression_get_operator (ValaUnaryExpression* self)
{
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

static void
vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                    ValaUnaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_unary_expression_get_inner (ValaUnaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression*
vala_unary_expression_construct (GType object_type,
                                 ValaUnaryOperator op,
                                 ValaExpression* _inner,
                                 ValaSourceReference* source)
{
	ValaUnaryExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	vala_unary_expression_set_operator (self, op);
	vala_unary_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaUnaryExpression*
vala_unary_expression_new (ValaUnaryOperator op,
                           ValaExpression* _inner,
                           ValaSourceReference* source)
{
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}

static void
vala_unary_expression_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_unary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}

static void
vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_unary_expression_set_inner (self, new_node);
	}
}

static gchar*
vala_unary_expression_real_to_string (ValaCodeNode* base)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	const gchar* _tmp1_;
	ValaExpression* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = self->priv->_operator;
	_tmp1_ = vala_unary_operator_to_string (_tmp0_);
	_tmp2_ = self->priv->_inner;
	_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp1_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static gboolean
vala_unary_expression_real_is_constant (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		gboolean _tmp10_ = FALSE;
		ValaField* _tmp11_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		field = VALA_IS_FIELD (_tmp9_) ? ((ValaField*) _tmp9_) : NULL;
		_tmp11_ = field;
		if (_tmp11_ != NULL) {
			ValaField* _tmp12_;
			ValaMemberBinding _tmp13_;
			ValaMemberBinding _tmp14_;
			_tmp12_ = field;
			_tmp13_ = vala_field_get_binding (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp15_ = vala_unary_expression_get_inner (self);
	_tmp16_ = _tmp15_;
	result = vala_expression_is_constant (_tmp16_);
	return result;
}

static gboolean
vala_unary_expression_real_is_pure (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	result = vala_expression_is_pure (_tmp4_);
	return result;
}

static gboolean
vala_unary_expression_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static gboolean
vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp6_ = FALSE;
	ValaStruct* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = vala_data_type_get_nullable (type);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = st;
	if (vala_struct_is_integer_type (_tmp7_)) {
		_tmp6_ = TRUE;
	} else {
		ValaStruct* _tmp8_;
		_tmp8_ = st;
		_tmp6_ = vala_struct_is_floating_type (_tmp8_);
	}
	result = _tmp6_;
	return result;
}

static gboolean
vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaStruct* _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_type_symbol (type);
	_tmp1_ = _tmp0_;
	st = VALA_IS_STRUCT (_tmp1_) ? ((ValaStruct*) _tmp1_) : NULL;
	_tmp3_ = vala_data_type_get_nullable (type);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		ValaStruct* _tmp5_;
		_tmp5_ = st;
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = st;
	result = vala_struct_is_integer_type (_tmp6_);
	return result;
}

static ValaMemberAccess*
vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                          ValaExpression* expr)
{
	ValaMemberAccess* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaMemberAccess* _tmp0_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (expr, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}

static void
vala_unary_expression_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
}

static gboolean
vala_unary_expression_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaUnaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaUnaryOperator _tmp39_;
	ValaDataType* _tmp175_;
	ValaDataType* _tmp176_;
	gboolean _tmp177_;
	gboolean _tmp178_;
	gboolean result = FALSE;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp19_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp21_ = vala_unary_expression_get_inner (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_expression_get_value_type (_tmp22_);
	_tmp24_ = _tmp23_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp24_)) {
		_tmp20_ = TRUE;
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		_tmp25_ = vala_unary_expression_get_inner (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_expression_get_value_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp20_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp28_);
	}
	if (_tmp20_) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp29_ = vala_unary_expression_get_inner (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_unary_expression_get_inner (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_symbol_get_full_name (_tmp36_);
		_tmp38_ = _tmp37_;
		vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
		_g_free0 (_tmp38_);
		result = FALSE;
		return result;
	}
	_tmp39_ = self->priv->_operator;
	switch (_tmp39_) {
		case VALA_UNARY_OPERATOR_PLUS:
		case VALA_UNARY_OPERATOR_MINUS:
		{
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			ValaDataType* _tmp42_;
			ValaDataType* _tmp43_;
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp40_ = vala_unary_expression_get_inner (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_expression_get_value_type (_tmp41_);
			_tmp43_ = _tmp42_;
			if (!vala_unary_expression_is_numeric_type (self, _tmp43_)) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_unary_expression_get_inner (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_code_node_to_string ((ValaCodeNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				vala_report_error (_tmp45_, "Operator not supported for `%s'", _tmp51_);
				_g_free0 (_tmp51_);
				result = FALSE;
				return result;
			}
			_tmp52_ = vala_unary_expression_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp55_);
			break;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			gboolean _tmp56_ = FALSE;
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			gboolean _tmp61_;
			gboolean _tmp62_;
			ValaExpression* _tmp78_;
			ValaExpression* _tmp79_;
			ValaDataType* _tmp80_;
			ValaDataType* _tmp81_;
			_tmp57_ = vala_unary_expression_get_inner (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_expression_get_value_type (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_nullable (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_) {
				_tmp56_ = TRUE;
			} else {
				ValaExpression* _tmp63_;
				ValaExpression* _tmp64_;
				ValaDataType* _tmp65_;
				ValaDataType* _tmp66_;
				ValaSemanticAnalyzer* _tmp67_;
				ValaSemanticAnalyzer* _tmp68_;
				ValaDataType* _tmp69_;
				_tmp63_ = vala_unary_expression_get_inner (self);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_expression_get_value_type (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = vala_code_context_get_analyzer (context);
				_tmp68_ = _tmp67_;
				_tmp69_ = _tmp68_->bool_type;
				_tmp56_ = !vala_data_type_compatible (_tmp66_, _tmp69_);
			}
			if (_tmp56_) {
				ValaSourceReference* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaExpression* _tmp72_;
				ValaExpression* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_unary_expression_get_inner (self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_expression_get_value_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_code_node_to_string ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp71_, "Operator not supported for `%s'", _tmp77_);
				_g_free0 (_tmp77_);
				result = FALSE;
				return result;
			}
			_tmp78_ = vala_unary_expression_get_inner (self);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_expression_get_value_type (_tmp79_);
			_tmp81_ = _tmp80_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp81_);
			break;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			gboolean _tmp82_ = FALSE;
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			ValaDataType* _tmp85_;
			ValaDataType* _tmp86_;
			ValaExpression* _tmp99_;
			ValaExpression* _tmp100_;
			ValaDataType* _tmp101_;
			ValaDataType* _tmp102_;
			_tmp83_ = vala_unary_expression_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_expression_get_value_type (_tmp84_);
			_tmp86_ = _tmp85_;
			if (!vala_unary_expression_is_integer_type (self, _tmp86_)) {
				ValaExpression* _tmp87_;
				ValaExpression* _tmp88_;
				ValaDataType* _tmp89_;
				ValaDataType* _tmp90_;
				_tmp87_ = vala_unary_expression_get_inner (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_expression_get_value_type (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp82_ = !VALA_IS_ENUM_VALUE_TYPE (_tmp90_);
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				ValaSourceReference* _tmp91_;
				ValaSourceReference* _tmp92_;
				ValaExpression* _tmp93_;
				ValaExpression* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_unary_expression_get_inner (self);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_expression_get_value_type (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = vala_code_node_to_string ((ValaCodeNode*) _tmp96_);
				_tmp98_ = _tmp97_;
				vala_report_error (_tmp92_, "Operator not supported for `%s'", _tmp98_);
				_g_free0 (_tmp98_);
				result = FALSE;
				return result;
			}
			_tmp99_ = vala_unary_expression_get_inner (self);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_expression_get_value_type (_tmp100_);
			_tmp102_ = _tmp101_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp102_);
			break;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			ValaExpression* _tmp103_;
			ValaExpression* _tmp104_;
			ValaDataType* _tmp105_;
			ValaDataType* _tmp106_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp115_;
			ValaExpression* _tmp116_;
			ValaMemberAccess* _tmp117_;
			ValaMemberAccess* _tmp118_;
			ValaExpression* _tmp121_;
			ValaExpression* _tmp122_;
			ValaDataType* _tmp123_;
			ValaDataType* _tmp124_;
			_tmp103_ = vala_unary_expression_get_inner (self);
			_tmp104_ = _tmp103_;
			_tmp105_ = vala_expression_get_value_type (_tmp104_);
			_tmp106_ = _tmp105_;
			if (!vala_unary_expression_is_integer_type (self, _tmp106_)) {
				ValaSourceReference* _tmp107_;
				ValaSourceReference* _tmp108_;
				ValaExpression* _tmp109_;
				ValaExpression* _tmp110_;
				ValaDataType* _tmp111_;
				ValaDataType* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp108_ = _tmp107_;
				_tmp109_ = vala_unary_expression_get_inner (self);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_expression_get_value_type (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp113_ = vala_code_node_to_string ((ValaCodeNode*) _tmp112_);
				_tmp114_ = _tmp113_;
				vala_report_error (_tmp108_, "Operator not supported for `%s'", _tmp114_);
				_g_free0 (_tmp114_);
				result = FALSE;
				return result;
			}
			_tmp115_ = vala_unary_expression_get_inner (self);
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_unary_expression_find_member_access (self, _tmp116_);
			ma = _tmp117_;
			_tmp118_ = ma;
			if (_tmp118_ == NULL) {
				ValaSourceReference* _tmp119_;
				ValaSourceReference* _tmp120_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp120_ = _tmp119_;
				vala_report_error (_tmp120_, "Prefix operators not supported for this expression");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				return result;
			}
			_tmp121_ = vala_unary_expression_get_inner (self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_expression_get_value_type (_tmp122_);
			_tmp124_ = _tmp123_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp124_);
			_vala_code_node_unref0 (ma);
			break;
		}
		case VALA_UNARY_OPERATOR_REF:
		case VALA_UNARY_OPERATOR_OUT:
		{
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp125_;
			ValaExpression* _tmp126_;
			gboolean _tmp127_ = FALSE;
			gboolean _tmp128_ = FALSE;
			gboolean _tmp129_ = FALSE;
			ValaExpression* _tmp130_;
			ValaExpression* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			gboolean _tmp155_ = FALSE;
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			_tmp125_ = vala_unary_expression_get_inner (self);
			_tmp126_ = _tmp125_;
			ea = VALA_IS_ELEMENT_ACCESS (_tmp126_) ? ((ValaElementAccess*) _tmp126_) : NULL;
			_tmp130_ = vala_unary_expression_get_inner (self);
			_tmp131_ = _tmp130_;
			_tmp132_ = vala_expression_get_symbol_reference (_tmp131_);
			_tmp133_ = _tmp132_;
			if (VALA_IS_FIELD (_tmp133_)) {
				_tmp129_ = TRUE;
			} else {
				ValaExpression* _tmp134_;
				ValaExpression* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp134_ = vala_unary_expression_get_inner (self);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_expression_get_symbol_reference (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp129_ = VALA_IS_PARAMETER (_tmp137_);
			}
			if (_tmp129_) {
				_tmp128_ = TRUE;
			} else {
				ValaExpression* _tmp138_;
				ValaExpression* _tmp139_;
				ValaSymbol* _tmp140_;
				ValaSymbol* _tmp141_;
				_tmp138_ = vala_unary_expression_get_inner (self);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_expression_get_symbol_reference (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp128_ = VALA_IS_LOCAL_VARIABLE (_tmp141_);
			}
			if (_tmp128_) {
				_tmp127_ = TRUE;
			} else {
				gboolean _tmp142_ = FALSE;
				ValaElementAccess* _tmp143_;
				_tmp143_ = ea;
				if (_tmp143_ != NULL) {
					ValaElementAccess* _tmp144_;
					ValaExpression* _tmp145_;
					ValaExpression* _tmp146_;
					ValaDataType* _tmp147_;
					ValaDataType* _tmp148_;
					_tmp144_ = ea;
					_tmp145_ = vala_element_access_get_container (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_expression_get_value_type (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp142_ = VALA_IS_ARRAY_TYPE (_tmp148_);
				} else {
					_tmp142_ = FALSE;
				}
				_tmp127_ = _tmp142_;
			}
			if (_tmp127_) {
				ValaExpression* _tmp149_;
				ValaExpression* _tmp150_;
				ValaDataType* _tmp151_;
				ValaDataType* _tmp152_;
				vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
				_tmp149_ = vala_unary_expression_get_inner (self);
				_tmp150_ = _tmp149_;
				_tmp151_ = vala_expression_get_value_type (_tmp150_);
				_tmp152_ = _tmp151_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp152_);
			} else {
				ValaSourceReference* _tmp153_;
				ValaSourceReference* _tmp154_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp154_ = _tmp153_;
				vala_report_error (_tmp154_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
				result = FALSE;
				return result;
			}
			_tmp156_ = vala_unary_expression_get_inner (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_symbol_reference (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaAttribute* _tmp164_;
				_tmp160_ = vala_unary_expression_get_inner (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_symbol_reference (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp163_, "GtkChild");
				_tmp155_ = _tmp164_ != NULL;
			} else {
				_tmp155_ = FALSE;
			}
			if (_tmp155_) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				ValaExpression* _tmp167_;
				ValaExpression* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				gchar* _tmp171_;
				gchar* _tmp172_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				_tmp167_ = vala_unary_expression_get_inner (self);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_expression_get_symbol_reference (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_symbol_get_full_name (_tmp170_);
				_tmp172_ = _tmp171_;
				vala_report_error (_tmp166_, "Assignment of [GtkChild] `%s' is not allowed", _tmp172_);
				_g_free0 (_tmp172_);
				result = FALSE;
				return result;
			}
			break;
		}
		default:
		{
			ValaSourceReference* _tmp173_;
			ValaSourceReference* _tmp174_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp174_ = _tmp173_;
			vala_report_error (_tmp174_, "internal error: unsupported unary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp175_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp176_ = _tmp175_;
	vala_code_node_check ((ValaCodeNode*) _tmp176_, context);
	_tmp177_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp178_ = _tmp177_;
	result = !_tmp178_;
	return result;
}

static void
vala_unary_expression_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryOperator _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp3_ = self->priv->_operator;
	if (_tmp3_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp2_ = TRUE;
	} else {
		ValaUnaryOperator _tmp4_;
		_tmp4_ = self->priv->_operator;
		_tmp2_ = _tmp4_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp2_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		gboolean _tmp15_ = FALSE;
		ValaParameter* _tmp16_;
		_tmp5_ = vala_unary_expression_get_inner (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_symbol_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp8_) ? ((ValaLocalVariable*) _tmp8_) : NULL;
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_symbol_reference (_tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = local;
		if (_tmp13_ != NULL) {
			ValaLocalVariable* _tmp14_;
			_tmp14_ = local;
			vala_collection_add (collection, (ValaVariable*) _tmp14_);
		}
		_tmp16_ = param;
		if (_tmp16_ != NULL) {
			ValaParameter* _tmp17_;
			ValaParameterDirection _tmp18_;
			ValaParameterDirection _tmp19_;
			_tmp17_ = param;
			_tmp18_ = vala_parameter_get_direction (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaParameter* _tmp20_;
			_tmp20_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp20_);
		}
	}
}

static void
vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, collection);
	}
}

static void
vala_unary_expression_class_init (ValaUnaryExpressionClass * klass,
                                  gpointer klass_data)
{
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaUnaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_unary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}

static void
vala_unary_expression_instance_init (ValaUnaryExpression * self,
                                     gpointer klass)
{
	self->priv = vala_unary_expression_get_instance_private (self);
}

static void
vala_unary_expression_finalize (ValaCodeNode * obj)
{
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
static GType
vala_unary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
	GType vala_unary_expression_type_id;
	vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
	ValaUnaryExpression_private_offset = g_type_add_instance_private (vala_unary_expression_type_id, sizeof (ValaUnaryExpressionPrivate));
	return vala_unary_expression_type_id;
}

GType
vala_unary_expression_get_type (void)
{
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = vala_unary_expression_get_type_once ();
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}

const gchar*
vala_unary_operator_to_string (ValaUnaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_unary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
	GType vala_unary_operator_type_id;
	vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
	return vala_unary_operator_type_id;
}

GType
vala_unary_operator_get_type (void)
{
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = vala_unary_operator_get_type_once ();
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}

