/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp638_ = FALSE;
	gboolean _tmp639_ = FALSE;
	gboolean _tmp640_ = FALSE;
	ValaExpression* _tmp641_;
	ValaExpression* _tmp642_;
	ValaSymbol* _tmp669_;
	ValaSymbol* _tmp670_;
	ValaSymbol* _tmp739_;
	ValaSymbol* _tmp740_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp776_;
	ValaSymbol* _tmp777_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp778_;
	ValaSymbol* _tmp779_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1189_;
	ValaSymbol* _tmp1190_;
	ValaSymbol* _tmp1192_;
	ValaVersionAttribute* _tmp1193_;
	ValaVersionAttribute* _tmp1194_;
	ValaSourceReference* _tmp1195_;
	ValaSourceReference* _tmp1196_;
	gboolean _tmp1197_ = FALSE;
	ValaSymbolAccessibility _tmp1198_;
	gboolean _tmp1250_ = FALSE;
	gboolean _tmp1277_ = FALSE;
	gboolean _tmp1278_ = FALSE;
	ValaDataType* _tmp1560_;
	ValaDataType* _tmp1561_;
	gboolean _tmp1564_;
	gboolean _tmp1565_;
	gboolean _tmp1566_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp273_;
			ValaExpression* _tmp274_;
			gboolean _tmp287_ = FALSE;
			ValaExpression* _tmp288_;
			ValaExpression* _tmp289_;
			gboolean _tmp296_ = FALSE;
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			gboolean _tmp319_ = FALSE;
			ValaExpression* _tmp320_;
			ValaExpression* _tmp321_;
			gboolean _tmp340_ = FALSE;
			ValaSymbol* _tmp341_;
			ValaSymbol* _tmp342_;
			gboolean _tmp376_ = FALSE;
			gboolean _tmp377_ = FALSE;
			ValaSymbol* _tmp378_;
			ValaSymbol* _tmp379_;
			gboolean _tmp609_ = FALSE;
			ValaSymbol* _tmp610_;
			ValaSymbol* _tmp611_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaSourceReference* _tmp267_;
					ValaSourceReference* _tmp268_;
					ValaPointerIndirection* _tmp269_;
					ValaPointerIndirection* _tmp270_;
					ValaExpression* _tmp271_;
					ValaExpression* _tmp272_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp268_ = _tmp267_;
					_tmp269_ = vala_pointer_indirection_new (_tmp266_, _tmp268_);
					_tmp270_ = _tmp269_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp270_);
					_vala_code_node_unref0 (_tmp270_);
					_tmp271_ = vala_member_access_get_inner (self);
					_tmp272_ = _tmp271_;
					vala_code_node_check ((ValaCodeNode*) _tmp272_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp273_ = vala_member_access_get_inner (self);
			_tmp274_ = _tmp273_;
			if (VALA_IS_MEMBER_ACCESS (_tmp274_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp275_;
				ValaExpression* _tmp276_;
				ValaMemberAccess* _tmp277_;
				gboolean _tmp278_;
				_tmp275_ = vala_member_access_get_inner (self);
				_tmp276_ = _tmp275_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp276_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp277_ = ma;
				_tmp278_ = _tmp277_->priv->_prototype_access;
				if (_tmp278_) {
					ValaSourceReference* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSymbol* _tmp283_;
					ValaSymbol* _tmp284_;
					gchar* _tmp285_;
					gchar* _tmp286_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_expression_get_symbol_reference (_tmp282_);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_symbol_get_full_name (_tmp284_);
					_tmp286_ = _tmp285_;
					vala_report_error (_tmp280_, "Access to instance member `%s' denied", _tmp286_);
					_g_free0 (_tmp286_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp288_ = vala_member_access_get_inner (self);
			_tmp289_ = _tmp288_;
			if (VALA_IS_CAST_EXPRESSION (_tmp289_)) {
				ValaExpression* _tmp290_;
				ValaExpression* _tmp291_;
				gboolean _tmp292_;
				gboolean _tmp293_;
				_tmp290_ = vala_member_access_get_inner (self);
				_tmp291_ = _tmp290_;
				_tmp292_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp291_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp293_ = _tmp292_;
				_tmp287_ = _tmp293_;
			} else {
				_tmp287_ = FALSE;
			}
			if (_tmp287_) {
				ValaSourceReference* _tmp294_;
				ValaSourceReference* _tmp295_;
				_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp295_ = _tmp294_;
				vala_report_warning (_tmp295_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp297_ = vala_member_access_get_inner (self);
			_tmp298_ = _tmp297_;
			if (VALA_IS_MEMBER_ACCESS (_tmp298_)) {
				_tmp296_ = TRUE;
			} else {
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				_tmp299_ = vala_member_access_get_inner (self);
				_tmp300_ = _tmp299_;
				_tmp296_ = VALA_IS_BASE_ACCESS (_tmp300_);
			}
			if (_tmp296_) {
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaSymbol* _tmp303_;
				ValaSymbol* _tmp304_;
				gboolean _tmp305_ = FALSE;
				ValaSymbol* _tmp306_;
				ValaSymbol* _tmp307_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_expression_get_symbol_reference (_tmp302_);
				_tmp304_ = _tmp303_;
				base_symbol = _tmp304_;
				_tmp306_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp307_ = _tmp306_;
				if (_tmp307_ == NULL) {
					gboolean _tmp308_ = FALSE;
					ValaSymbol* _tmp309_;
					_tmp309_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp309_)) {
						_tmp308_ = TRUE;
					} else {
						ValaSymbol* _tmp310_;
						_tmp310_ = base_symbol;
						_tmp308_ = VALA_IS_TYPESYMBOL (_tmp310_);
					}
					_tmp305_ = _tmp308_;
				} else {
					_tmp305_ = FALSE;
				}
				if (_tmp305_) {
					ValaSymbol* _tmp311_;
					ValaScope* _tmp312_;
					ValaScope* _tmp313_;
					const gchar* _tmp314_;
					ValaSymbol* _tmp315_;
					ValaSymbol* _tmp316_;
					ValaExpression* _tmp317_;
					ValaExpression* _tmp318_;
					_tmp311_ = base_symbol;
					_tmp312_ = vala_symbol_get_scope (_tmp311_);
					_tmp313_ = _tmp312_;
					_tmp314_ = self->priv->_member_name;
					_tmp315_ = vala_scope_lookup (_tmp313_, _tmp314_);
					_tmp316_ = _tmp315_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp316_);
					_vala_code_node_unref0 (_tmp316_);
					_tmp317_ = vala_member_access_get_inner (self);
					_tmp318_ = _tmp317_;
					if (VALA_IS_BASE_ACCESS (_tmp318_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp320_ = vala_member_access_get_inner (self);
			_tmp321_ = _tmp320_;
			if (VALA_IS_MEMBER_ACCESS (_tmp321_)) {
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaSymbol* _tmp324_;
				ValaSymbol* _tmp325_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_symbol_reference (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp319_ = VALA_IS_TYPEPARAMETER (_tmp325_);
			} else {
				_tmp319_ = FALSE;
			}
			if (_tmp319_) {
				ValaExpression* _tmp326_;
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaExpression* _tmp329_;
				ValaSymbol* _tmp330_;
				ValaSymbol* _tmp331_;
				ValaGenericType* _tmp332_;
				ValaGenericType* _tmp333_;
				ValaExpression* _tmp334_;
				ValaExpression* _tmp335_;
				ValaDataType* _tmp336_;
				ValaDataType* _tmp337_;
				ValaSourceReference* _tmp338_;
				ValaSourceReference* _tmp339_;
				_tmp326_ = vala_member_access_get_inner (self);
				_tmp327_ = _tmp326_;
				_tmp328_ = vala_member_access_get_inner (self);
				_tmp329_ = _tmp328_;
				_tmp330_ = vala_expression_get_symbol_reference (_tmp329_);
				_tmp331_ = _tmp330_;
				_tmp332_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp333_ = _tmp332_;
				vala_expression_set_value_type (_tmp327_, (ValaDataType*) _tmp333_);
				_vala_code_node_unref0 (_tmp333_);
				_tmp334_ = vala_member_access_get_inner (self);
				_tmp335_ = _tmp334_;
				_tmp336_ = vala_expression_get_value_type (_tmp335_);
				_tmp337_ = _tmp336_;
				_tmp338_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp339_ = _tmp338_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp337_, _tmp339_);
			}
			_tmp341_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp342_ = _tmp341_;
			if (_tmp342_ == NULL) {
				ValaExpression* _tmp343_;
				ValaExpression* _tmp344_;
				ValaDataType* _tmp345_;
				ValaDataType* _tmp346_;
				_tmp343_ = vala_member_access_get_inner (self);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_expression_get_value_type (_tmp344_);
				_tmp346_ = _tmp345_;
				_tmp340_ = _tmp346_ != NULL;
			} else {
				_tmp340_ = FALSE;
			}
			if (_tmp340_) {
				gboolean _tmp347_;
				ValaSymbol* _tmp374_;
				ValaSymbol* _tmp375_;
				_tmp347_ = self->priv->_pointer_member_access;
				if (_tmp347_) {
					ValaExpression* _tmp348_;
					ValaExpression* _tmp349_;
					ValaDataType* _tmp350_;
					ValaDataType* _tmp351_;
					const gchar* _tmp352_;
					ValaSymbol* _tmp353_;
					ValaSymbol* _tmp354_;
					_tmp348_ = vala_member_access_get_inner (self);
					_tmp349_ = _tmp348_;
					_tmp350_ = vala_expression_get_value_type (_tmp349_);
					_tmp351_ = _tmp350_;
					_tmp352_ = self->priv->_member_name;
					_tmp353_ = vala_data_type_get_pointer_member (_tmp351_, _tmp352_);
					_tmp354_ = _tmp353_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp354_);
					_vala_code_node_unref0 (_tmp354_);
				} else {
					ValaExpression* _tmp355_;
					ValaExpression* _tmp356_;
					ValaDataType* _tmp357_;
					ValaDataType* _tmp358_;
					ValaTypeSymbol* _tmp359_;
					ValaTypeSymbol* _tmp360_;
					ValaExpression* _tmp367_;
					ValaExpression* _tmp368_;
					ValaDataType* _tmp369_;
					ValaDataType* _tmp370_;
					const gchar* _tmp371_;
					ValaSymbol* _tmp372_;
					ValaSymbol* _tmp373_;
					_tmp355_ = vala_member_access_get_inner (self);
					_tmp356_ = _tmp355_;
					_tmp357_ = vala_expression_get_value_type (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_data_type_get_type_symbol (_tmp358_);
					_tmp360_ = _tmp359_;
					if (_tmp360_ != NULL) {
						ValaExpression* _tmp361_;
						ValaExpression* _tmp362_;
						ValaDataType* _tmp363_;
						ValaDataType* _tmp364_;
						ValaTypeSymbol* _tmp365_;
						ValaTypeSymbol* _tmp366_;
						_tmp361_ = vala_member_access_get_inner (self);
						_tmp362_ = _tmp361_;
						_tmp363_ = vala_expression_get_value_type (_tmp362_);
						_tmp364_ = _tmp363_;
						_tmp365_ = vala_data_type_get_type_symbol (_tmp364_);
						_tmp366_ = _tmp365_;
						base_symbol = (ValaSymbol*) _tmp366_;
					}
					_tmp367_ = vala_member_access_get_inner (self);
					_tmp368_ = _tmp367_;
					_tmp369_ = vala_expression_get_value_type (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = self->priv->_member_name;
					_tmp372_ = vala_data_type_get_member (_tmp370_, _tmp371_);
					_tmp373_ = _tmp372_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp373_);
					_vala_code_node_unref0 (_tmp373_);
				}
				_tmp374_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp375_ = _tmp374_;
				if (_tmp375_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp378_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp379_ = _tmp378_;
			if (_tmp379_ == NULL) {
				ValaExpression* _tmp380_;
				ValaExpression* _tmp381_;
				ValaDataType* _tmp382_;
				ValaDataType* _tmp383_;
				_tmp380_ = vala_member_access_get_inner (self);
				_tmp381_ = _tmp380_;
				_tmp382_ = vala_expression_get_value_type (_tmp381_);
				_tmp383_ = _tmp382_;
				_tmp377_ = _tmp383_ != NULL;
			} else {
				_tmp377_ = FALSE;
			}
			if (_tmp377_) {
				ValaExpression* _tmp384_;
				ValaExpression* _tmp385_;
				ValaDataType* _tmp386_;
				ValaDataType* _tmp387_;
				gboolean _tmp388_;
				gboolean _tmp389_;
				_tmp384_ = vala_member_access_get_inner (self);
				_tmp385_ = _tmp384_;
				_tmp386_ = vala_expression_get_value_type (_tmp385_);
				_tmp387_ = _tmp386_;
				_tmp388_ = vala_data_type_get_is_dynamic (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp376_ = _tmp389_;
			} else {
				_tmp376_ = FALSE;
			}
			if (_tmp376_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp390_;
				ValaExpression* _tmp391_;
				ValaDataType* _tmp392_;
				ValaDataType* _tmp393_;
				ValaObjectType* _tmp394_;
				ValaCodeNode* _tmp395_;
				ValaCodeNode* _tmp396_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp607_;
				ValaSymbol* _tmp608_;
				_tmp390_ = vala_member_access_get_inner (self);
				_tmp391_ = _tmp390_;
				_tmp392_ = vala_expression_get_value_type (_tmp391_);
				_tmp393_ = _tmp392_;
				_tmp394_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp393_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp394_;
				_tmp395_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp396_ = _tmp395_;
				if (VALA_IS_METHOD_CALL (_tmp396_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp397_;
					ValaCodeNode* _tmp398_;
					ValaMethodCall* _tmp399_;
					ValaExpression* _tmp400_;
					ValaExpression* _tmp401_;
					_tmp397_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp398_ = _tmp397_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp398_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp399_ = invoc;
					_tmp400_ = vala_method_call_get_call (_tmp399_);
					_tmp401_ = _tmp400_;
					if (_tmp401_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp402_;
						ValaDataType* _tmp403_;
						ValaDataType* _tmp404_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp419_;
						ValaExpression* _tmp420_;
						ValaDataType* _tmp421_;
						ValaDataType* _tmp422_;
						const gchar* _tmp423_;
						ValaDataType* _tmp424_;
						ValaSourceReference* _tmp425_;
						ValaSourceReference* _tmp426_;
						ValaDynamicMethod* _tmp427_;
						ValaDynamicMethod* _tmp428_;
						ValaMethodCall* _tmp429_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp430_;
						ValaErrorType* _tmp431_;
						ValaDynamicMethod* _tmp432_;
						ValaErrorType* _tmp433_;
						ValaDynamicMethod* _tmp434_;
						ValaDynamicMethod* _tmp435_;
						ValaParameter* _tmp436_;
						ValaParameter* _tmp437_;
						ValaDynamicMethod* _tmp438_;
						ValaObjectType* _tmp439_;
						ValaDataType* _tmp440_;
						ValaDataType* _tmp441_;
						ValaParameter* _tmp442_;
						ValaParameter* _tmp443_;
						ValaObjectType* _tmp444_;
						ValaTypeSymbol* _tmp445_;
						ValaTypeSymbol* _tmp446_;
						ValaScope* _tmp447_;
						ValaScope* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						_tmp402_ = invoc;
						_tmp403_ = vala_expression_get_target_type ((ValaExpression*) _tmp402_);
						_tmp404_ = _tmp403_;
						if (_tmp404_ != NULL) {
							ValaMethodCall* _tmp405_;
							ValaDataType* _tmp406_;
							ValaDataType* _tmp407_;
							ValaDataType* _tmp408_;
							ValaDataType* _tmp409_;
							_tmp405_ = invoc;
							_tmp406_ = vala_expression_get_target_type ((ValaExpression*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_data_type_copy (_tmp407_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp408_;
							_tmp409_ = ret_type;
							vala_data_type_set_value_owned (_tmp409_, TRUE);
						} else {
							ValaMethodCall* _tmp410_;
							ValaCodeNode* _tmp411_;
							ValaCodeNode* _tmp412_;
							_tmp410_ = invoc;
							_tmp411_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp410_);
							_tmp412_ = _tmp411_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp412_)) {
								ValaVoidType* _tmp413_;
								_tmp413_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp413_;
							} else {
								ValaExpression* _tmp414_;
								ValaExpression* _tmp415_;
								ValaDataType* _tmp416_;
								ValaDataType* _tmp417_;
								ValaDataType* _tmp418_;
								_tmp414_ = vala_member_access_get_inner (self);
								_tmp415_ = _tmp414_;
								_tmp416_ = vala_expression_get_value_type (_tmp415_);
								_tmp417_ = _tmp416_;
								_tmp418_ = vala_data_type_copy (_tmp417_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp418_;
							}
						}
						_tmp419_ = vala_member_access_get_inner (self);
						_tmp420_ = _tmp419_;
						_tmp421_ = vala_expression_get_value_type (_tmp420_);
						_tmp422_ = _tmp421_;
						_tmp423_ = self->priv->_member_name;
						_tmp424_ = ret_type;
						_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp426_ = _tmp425_;
						_tmp427_ = vala_dynamic_method_new (_tmp422_, _tmp423_, _tmp424_, _tmp426_, NULL);
						m = _tmp427_;
						_tmp428_ = m;
						_tmp429_ = invoc;
						vala_dynamic_method_set_invocation (_tmp428_, _tmp429_);
						_tmp430_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp430_;
						_tmp431_ = err;
						vala_error_type_set_dynamic_error (_tmp431_, TRUE);
						_tmp432_ = m;
						_tmp433_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp432_, (ValaDataType*) _tmp433_);
						_tmp434_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp434_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp435_ = m;
						_tmp436_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp437_ = _tmp436_;
						vala_callable_add_parameter ((ValaCallable*) _tmp435_, _tmp437_);
						_vala_code_node_unref0 (_tmp437_);
						_tmp438_ = m;
						_tmp439_ = dynamic_object_type;
						_tmp440_ = vala_data_type_copy ((ValaDataType*) _tmp439_);
						_tmp441_ = _tmp440_;
						_tmp442_ = vala_parameter_new ("this", _tmp441_, NULL);
						_tmp443_ = _tmp442_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp438_, _tmp443_);
						_vala_code_node_unref0 (_tmp443_);
						_vala_code_node_unref0 (_tmp441_);
						_tmp444_ = dynamic_object_type;
						_tmp445_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp444_);
						_tmp446_ = _tmp445_;
						_tmp447_ = vala_symbol_get_scope ((ValaSymbol*) _tmp446_);
						_tmp448_ = _tmp447_;
						_tmp449_ = m;
						vala_scope_add (_tmp448_, NULL, (ValaSymbol*) _tmp449_);
						_tmp450_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp450_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp451_;
					ValaCodeNode* _tmp452_;
					_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp452_ = _tmp451_;
					if (VALA_IS_ASSIGNMENT (_tmp452_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp453_;
						ValaCodeNode* _tmp454_;
						ValaAssignment* _tmp455_;
						ValaExpression* _tmp456_;
						ValaExpression* _tmp457_;
						_tmp453_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp454_ = _tmp453_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp454_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp455_ = a;
						_tmp456_ = vala_assignment_get_left (_tmp455_);
						_tmp457_ = _tmp456_;
						if (_tmp457_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp458_;
							ValaExpression* _tmp459_;
							ValaDataType* _tmp460_;
							ValaDataType* _tmp461_;
							const gchar* _tmp462_;
							ValaSourceReference* _tmp463_;
							ValaSourceReference* _tmp464_;
							ValaDynamicProperty* _tmp465_;
							ValaDynamicProperty* _tmp466_;
							ValaDynamicProperty* _tmp467_;
							ValaDynamicProperty* _tmp468_;
							ValaSourceReference* _tmp469_;
							ValaSourceReference* _tmp470_;
							ValaPropertyAccessor* _tmp471_;
							ValaPropertyAccessor* _tmp472_;
							ValaDynamicProperty* _tmp473_;
							ValaExpression* _tmp474_;
							ValaExpression* _tmp475_;
							ValaDataType* _tmp476_;
							ValaDataType* _tmp477_;
							ValaTypeSymbol* _tmp478_;
							ValaTypeSymbol* _tmp479_;
							ValaScope* _tmp480_;
							ValaScope* _tmp481_;
							ValaObjectType* _tmp482_;
							ValaTypeSymbol* _tmp483_;
							ValaTypeSymbol* _tmp484_;
							ValaScope* _tmp485_;
							ValaScope* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaDynamicProperty* _tmp488_;
							_tmp458_ = vala_member_access_get_inner (self);
							_tmp459_ = _tmp458_;
							_tmp460_ = vala_expression_get_value_type (_tmp459_);
							_tmp461_ = _tmp460_;
							_tmp462_ = self->priv->_member_name;
							_tmp463_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp464_ = _tmp463_;
							_tmp465_ = vala_dynamic_property_new (_tmp461_, _tmp462_, _tmp464_, NULL);
							prop = _tmp465_;
							_tmp466_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp466_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp467_ = prop;
							_tmp468_ = prop;
							_tmp469_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp468_);
							_tmp470_ = _tmp469_;
							_tmp471_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp470_, NULL);
							_tmp472_ = _tmp471_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp467_, _tmp472_);
							_vala_code_node_unref0 (_tmp472_);
							_tmp473_ = prop;
							_tmp474_ = vala_member_access_get_inner (self);
							_tmp475_ = _tmp474_;
							_tmp476_ = vala_expression_get_value_type (_tmp475_);
							_tmp477_ = _tmp476_;
							_tmp478_ = vala_data_type_get_type_symbol (_tmp477_);
							_tmp479_ = _tmp478_;
							_tmp480_ = vala_symbol_get_scope ((ValaSymbol*) _tmp479_);
							_tmp481_ = _tmp480_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp473_, _tmp481_);
							_tmp482_ = dynamic_object_type;
							_tmp483_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp482_);
							_tmp484_ = _tmp483_;
							_tmp485_ = vala_symbol_get_scope ((ValaSymbol*) _tmp484_);
							_tmp486_ = _tmp485_;
							_tmp487_ = prop;
							vala_scope_add (_tmp486_, NULL, (ValaSymbol*) _tmp487_);
							_tmp488_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp488_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp489_ = FALSE;
						gboolean _tmp490_ = FALSE;
						ValaCodeNode* _tmp491_;
						ValaCodeNode* _tmp492_;
						_tmp491_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp492_ = _tmp491_;
						if (VALA_IS_MEMBER_ACCESS (_tmp492_)) {
							ValaExpression* _tmp493_;
							ValaExpression* _tmp494_;
							_tmp493_ = vala_member_access_get_inner (self);
							_tmp494_ = _tmp493_;
							_tmp490_ = VALA_IS_MEMBER_ACCESS (_tmp494_);
						} else {
							_tmp490_ = FALSE;
						}
						if (_tmp490_) {
							ValaCodeNode* _tmp495_;
							ValaCodeNode* _tmp496_;
							ValaCodeNode* _tmp497_;
							ValaCodeNode* _tmp498_;
							_tmp495_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_code_node_get_parent_node (_tmp496_);
							_tmp498_ = _tmp497_;
							_tmp489_ = VALA_IS_METHOD_CALL (_tmp498_);
						} else {
							_tmp489_ = FALSE;
						}
						if (_tmp489_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp499_;
							ValaCodeNode* _tmp500_;
							gboolean _tmp501_ = FALSE;
							ValaMemberAccess* _tmp502_;
							const gchar* _tmp503_;
							_tmp499_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp500_ = _tmp499_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp500_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp502_ = ma;
							_tmp503_ = _tmp502_->priv->_member_name;
							if (g_strcmp0 (_tmp503_, "connect") == 0) {
								_tmp501_ = TRUE;
							} else {
								ValaMemberAccess* _tmp504_;
								const gchar* _tmp505_;
								_tmp504_ = ma;
								_tmp505_ = _tmp504_->priv->_member_name;
								_tmp501_ = g_strcmp0 (_tmp505_, "connect_after") == 0;
							}
							if (_tmp501_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp506_;
								ValaExpression* _tmp507_;
								ValaDataType* _tmp508_;
								ValaDataType* _tmp509_;
								const gchar* _tmp510_;
								ValaVoidType* _tmp511_;
								ValaVoidType* _tmp512_;
								ValaSourceReference* _tmp513_;
								ValaSourceReference* _tmp514_;
								ValaDynamicSignal* _tmp515_;
								ValaDynamicSignal* _tmp516_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp517_;
								ValaCodeNode* _tmp518_;
								ValaCodeNode* _tmp519_;
								ValaCodeNode* _tmp520_;
								ValaMethodCall* _tmp521_;
								ValaMethodCall* _tmp522_;
								ValaList* _tmp523_;
								gint _tmp524_;
								gint _tmp525_;
								ValaDynamicSignal* _tmp549_;
								ValaObjectType* _tmp550_;
								ValaTypeSymbol* _tmp551_;
								ValaTypeSymbol* _tmp552_;
								ValaScope* _tmp553_;
								ValaScope* _tmp554_;
								ValaDynamicSignal* _tmp555_;
								ValaDynamicSignal* _tmp556_;
								_tmp506_ = vala_member_access_get_inner (self);
								_tmp507_ = _tmp506_;
								_tmp508_ = vala_expression_get_value_type (_tmp507_);
								_tmp509_ = _tmp508_;
								_tmp510_ = self->priv->_member_name;
								_tmp511_ = vala_void_type_new (NULL);
								_tmp512_ = _tmp511_;
								_tmp513_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp514_ = _tmp513_;
								_tmp515_ = vala_dynamic_signal_new (_tmp509_, _tmp510_, (ValaDataType*) _tmp512_, _tmp514_, NULL);
								_tmp516_ = _tmp515_;
								_vala_code_node_unref0 (_tmp512_);
								s = _tmp516_;
								_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp518_ = _tmp517_;
								_tmp519_ = vala_code_node_get_parent_node (_tmp518_);
								_tmp520_ = _tmp519_;
								_tmp521_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp520_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp521_;
								_tmp522_ = mcall;
								_tmp523_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp522_);
								_tmp524_ = vala_collection_get_size ((ValaCollection*) _tmp523_);
								_tmp525_ = _tmp524_;
								if (_tmp525_ > 0) {
									ValaDynamicSignal* _tmp526_;
									ValaMethodCall* _tmp527_;
									ValaList* _tmp528_;
									gpointer _tmp529_;
									ValaExpression* _tmp530_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp531_;
									ValaExpression* _tmp532_;
									ValaExpression* _tmp533_;
									gboolean _tmp534_ = FALSE;
									gboolean _tmp535_ = FALSE;
									ValaMemberAccess* _tmp536_;
									_tmp526_ = s;
									_tmp527_ = mcall;
									_tmp528_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp527_);
									_tmp529_ = vala_list_get (_tmp528_, 0);
									_tmp530_ = (ValaExpression*) _tmp529_;
									vala_dynamic_signal_set_handler (_tmp526_, _tmp530_);
									_vala_code_node_unref0 (_tmp530_);
									_tmp531_ = s;
									_tmp532_ = vala_dynamic_signal_get_handler (_tmp531_);
									_tmp533_ = _tmp532_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp533_) ? ((ValaMemberAccess*) _tmp533_) : NULL;
									_tmp536_ = arg;
									if (_tmp536_ == NULL) {
										_tmp535_ = TRUE;
									} else {
										ValaMemberAccess* _tmp537_;
										_tmp537_ = arg;
										_tmp535_ = !vala_code_node_check ((ValaCodeNode*) _tmp537_, context);
									}
									if (_tmp535_) {
										_tmp534_ = TRUE;
									} else {
										ValaMemberAccess* _tmp538_;
										ValaSymbol* _tmp539_;
										ValaSymbol* _tmp540_;
										_tmp538_ = arg;
										_tmp539_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp538_);
										_tmp540_ = _tmp539_;
										_tmp534_ = !VALA_IS_METHOD (_tmp540_);
									}
									if (_tmp534_) {
										ValaDynamicSignal* _tmp541_;
										ValaExpression* _tmp542_;
										ValaExpression* _tmp543_;
										ValaSourceReference* _tmp544_;
										ValaSourceReference* _tmp545_;
										ValaDynamicSignal* _tmp546_;
										gchar* _tmp547_;
										gchar* _tmp548_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp541_ = s;
										_tmp542_ = vala_dynamic_signal_get_handler (_tmp541_);
										_tmp543_ = _tmp542_;
										_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp543_);
										_tmp545_ = _tmp544_;
										_tmp546_ = s;
										_tmp547_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp546_);
										_tmp548_ = _tmp547_;
										vala_report_error (_tmp545_, "Invalid handler for `%s'", _tmp548_);
										_g_free0 (_tmp548_);
									}
								}
								_tmp549_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp549_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp550_ = dynamic_object_type;
								_tmp551_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp550_);
								_tmp552_ = _tmp551_;
								_tmp553_ = vala_symbol_get_scope ((ValaSymbol*) _tmp552_);
								_tmp554_ = _tmp553_;
								_tmp555_ = s;
								vala_scope_add (_tmp554_, NULL, (ValaSymbol*) _tmp555_);
								_tmp556_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp556_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp557_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp558_ = _tmp557_;
				if (_tmp558_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp559_;
					ValaExpression* _tmp560_;
					ValaDataType* _tmp561_;
					ValaDataType* _tmp562_;
					const gchar* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaDynamicProperty* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					ValaDynamicProperty* _tmp579_;
					ValaDynamicProperty* _tmp580_;
					ValaDynamicProperty* _tmp581_;
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDynamicProperty* _tmp586_;
					ValaSourceReference* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaPropertyAccessor* _tmp589_;
					ValaPropertyAccessor* _tmp590_;
					ValaDynamicProperty* _tmp591_;
					ValaExpression* _tmp592_;
					ValaExpression* _tmp593_;
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					ValaTypeSymbol* _tmp596_;
					ValaTypeSymbol* _tmp597_;
					ValaScope* _tmp598_;
					ValaScope* _tmp599_;
					ValaObjectType* _tmp600_;
					ValaTypeSymbol* _tmp601_;
					ValaTypeSymbol* _tmp602_;
					ValaScope* _tmp603_;
					ValaScope* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDynamicProperty* _tmp606_;
					_tmp559_ = vala_member_access_get_inner (self);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_expression_get_value_type (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = self->priv->_member_name;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_dynamic_property_new (_tmp562_, _tmp563_, _tmp565_, NULL);
					prop = _tmp566_;
					_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp568_ = _tmp567_;
					if (_tmp568_ != NULL) {
						ValaDynamicProperty* _tmp569_;
						ValaDataType* _tmp570_;
						ValaDataType* _tmp571_;
						_tmp569_ = prop;
						_tmp570_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp571_ = _tmp570_;
						vala_property_set_property_type ((ValaProperty*) _tmp569_, _tmp571_);
					} else {
						ValaDynamicProperty* _tmp572_;
						ValaExpression* _tmp573_;
						ValaExpression* _tmp574_;
						ValaDataType* _tmp575_;
						ValaDataType* _tmp576_;
						ValaDataType* _tmp577_;
						ValaDataType* _tmp578_;
						_tmp572_ = prop;
						_tmp573_ = vala_member_access_get_inner (self);
						_tmp574_ = _tmp573_;
						_tmp575_ = vala_expression_get_value_type (_tmp574_);
						_tmp576_ = _tmp575_;
						_tmp577_ = vala_data_type_copy (_tmp576_);
						_tmp578_ = _tmp577_;
						vala_property_set_property_type ((ValaProperty*) _tmp572_, _tmp578_);
						_vala_code_node_unref0 (_tmp578_);
					}
					_tmp579_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp579_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp580_ = prop;
					_tmp581_ = prop;
					_tmp582_ = vala_property_get_property_type ((ValaProperty*) _tmp581_);
					_tmp583_ = _tmp582_;
					_tmp584_ = vala_data_type_copy (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp586_ = prop;
					_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp585_, NULL, _tmp588_, NULL);
					_tmp590_ = _tmp589_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp580_, _tmp590_);
					_vala_code_node_unref0 (_tmp590_);
					_vala_code_node_unref0 (_tmp585_);
					_tmp591_ = prop;
					_tmp592_ = vala_member_access_get_inner (self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_expression_get_value_type (_tmp593_);
					_tmp595_ = _tmp594_;
					_tmp596_ = vala_data_type_get_type_symbol (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp598_ = vala_symbol_get_scope ((ValaSymbol*) _tmp597_);
					_tmp599_ = _tmp598_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp591_, _tmp599_);
					_tmp600_ = dynamic_object_type;
					_tmp601_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_symbol_get_scope ((ValaSymbol*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = prop;
					vala_scope_add (_tmp604_, NULL, (ValaSymbol*) _tmp605_);
					_tmp606_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp606_);
					_vala_code_node_unref0 (prop);
				}
				_tmp607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp608_ = _tmp607_;
				if (_tmp608_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp610_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp611_)) {
				ValaExpression* _tmp612_;
				ValaExpression* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				_tmp612_ = vala_member_access_get_inner (self);
				_tmp613_ = _tmp612_;
				_tmp614_ = vala_expression_get_symbol_reference (_tmp613_);
				_tmp615_ = _tmp614_;
				_tmp609_ = VALA_IS_VARIABLE (_tmp615_);
			} else {
				_tmp609_ = FALSE;
			}
			if (_tmp609_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp616_;
				ValaSemanticAnalyzer* _tmp617_;
				ValaExpression* _tmp618_;
				ValaExpression* _tmp619_;
				ValaSymbol* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaDataType* _tmp622_;
				ValaArrayType* _tmp623_;
				gboolean _tmp624_ = FALSE;
				ValaArrayType* _tmp625_;
				_tmp616_ = vala_code_context_get_analyzer (context);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_member_access_get_inner (self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_expression_get_symbol_reference (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp617_, _tmp621_, TRUE);
				_tmp623_ = VALA_IS_ARRAY_TYPE (_tmp622_) ? ((ValaArrayType*) _tmp622_) : NULL;
				if (_tmp623_ == NULL) {
					_vala_code_node_unref0 (_tmp622_);
				}
				inner_type = _tmp623_;
				_tmp625_ = inner_type;
				if (_tmp625_ != NULL) {
					ValaArrayType* _tmp626_;
					gboolean _tmp627_;
					gboolean _tmp628_;
					_tmp626_ = inner_type;
					_tmp627_ = vala_array_type_get_inline_allocated (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp624_ = _tmp628_;
				} else {
					_tmp624_ = FALSE;
				}
				if (_tmp624_) {
					ValaSourceReference* _tmp629_;
					ValaSourceReference* _tmp630_;
					_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp630_ = _tmp629_;
					vala_report_error (_tmp630_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp631_ = FALSE;
					ValaArrayType* _tmp632_;
					_tmp632_ = inner_type;
					if (_tmp632_ != NULL) {
						ValaArrayType* _tmp633_;
						gboolean _tmp634_;
						gboolean _tmp635_;
						_tmp633_ = inner_type;
						_tmp634_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp633_);
						_tmp635_ = _tmp634_;
						_tmp631_ = !_tmp635_;
					} else {
						_tmp631_ = FALSE;
					}
					if (_tmp631_) {
						ValaSourceReference* _tmp636_;
						ValaSourceReference* _tmp637_;
						_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp637_ = _tmp636_;
						vala_report_error (_tmp637_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp641_ = vala_member_access_get_inner (self);
	_tmp642_ = _tmp641_;
	if (_tmp642_ == NULL) {
		ValaSymbol* _tmp643_;
		ValaSymbol* _tmp644_;
		_tmp643_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp644_ = _tmp643_;
		_tmp640_ = _tmp644_ == NULL;
	} else {
		_tmp640_ = FALSE;
	}
	if (_tmp640_) {
		ValaDataType* _tmp645_;
		ValaDataType* _tmp646_;
		_tmp645_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp646_ = _tmp645_;
		_tmp639_ = _tmp646_ != NULL;
	} else {
		_tmp639_ = FALSE;
	}
	if (_tmp639_) {
		ValaDataType* _tmp647_;
		ValaDataType* _tmp648_;
		ValaTypeSymbol* _tmp649_;
		ValaTypeSymbol* _tmp650_;
		_tmp647_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp648_ = _tmp647_;
		_tmp649_ = vala_data_type_get_type_symbol (_tmp648_);
		_tmp650_ = _tmp649_;
		_tmp638_ = VALA_IS_ENUM (_tmp650_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp651_;
		ValaDataType* _tmp652_;
		ValaTypeSymbol* _tmp653_;
		ValaTypeSymbol* _tmp654_;
		_tmp651_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp652_ = _tmp651_;
		_tmp653_ = vala_data_type_get_type_symbol (_tmp652_);
		_tmp654_ = _tmp653_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp654_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp655_;
			ValaList* _tmp656_;
			gint _val_size = 0;
			ValaList* _tmp657_;
			gint _tmp658_;
			gint _tmp659_;
			gint _val_index = 0;
			_tmp655_ = enum_type;
			_tmp656_ = vala_enum_get_values (_tmp655_);
			_val_list = _tmp656_;
			_tmp657_ = _val_list;
			_tmp658_ = vala_collection_get_size ((ValaCollection*) _tmp657_);
			_tmp659_ = _tmp658_;
			_val_size = _tmp659_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp660_;
				gint _tmp661_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp662_;
				gpointer _tmp663_;
				const gchar* _tmp664_;
				ValaEnumValue* _tmp665_;
				const gchar* _tmp666_;
				const gchar* _tmp667_;
				_val_index = _val_index + 1;
				_tmp660_ = _val_index;
				_tmp661_ = _val_size;
				if (!(_tmp660_ < _tmp661_)) {
					break;
				}
				_tmp662_ = _val_list;
				_tmp663_ = vala_list_get (_tmp662_, _val_index);
				val = (ValaEnumValue*) _tmp663_;
				_tmp664_ = self->priv->_member_name;
				_tmp665_ = val;
				_tmp666_ = vala_symbol_get_name ((ValaSymbol*) _tmp665_);
				_tmp667_ = _tmp666_;
				if (g_strcmp0 (_tmp664_, _tmp667_) == 0) {
					ValaEnumValue* _tmp668_;
					_tmp668_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp668_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp669_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp670_ = _tmp669_;
	if (_tmp670_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp671_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp672_ = FALSE;
		ValaExpression* _tmp673_;
		ValaExpression* _tmp674_;
		gchar* base_type_package = NULL;
		gchar* _tmp694_;
		gboolean _tmp695_ = FALSE;
		ValaSymbol* _tmp696_;
		gchar* visited_types_string = NULL;
		gchar* _tmp711_;
		ValaSourceReference* _tmp727_;
		ValaSourceReference* _tmp728_;
		const gchar* _tmp729_;
		const gchar* _tmp730_;
		const gchar* _tmp731_;
		const gchar* _tmp732_;
		ValaInvalidType* _tmp733_;
		ValaInvalidType* _tmp734_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp671_ = g_strdup ("(null)");
		base_type_name = _tmp671_;
		base_type = NULL;
		_tmp673_ = vala_member_access_get_inner (self);
		_tmp674_ = _tmp673_;
		if (_tmp674_ != NULL) {
			ValaExpression* _tmp675_;
			ValaExpression* _tmp676_;
			ValaDataType* _tmp677_;
			ValaDataType* _tmp678_;
			_tmp675_ = vala_member_access_get_inner (self);
			_tmp676_ = _tmp675_;
			_tmp677_ = vala_expression_get_value_type (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp672_ = _tmp678_ != NULL;
		} else {
			_tmp672_ = FALSE;
		}
		if (_tmp672_) {
			ValaExpression* _tmp679_;
			ValaExpression* _tmp680_;
			ValaDataType* _tmp681_;
			ValaDataType* _tmp682_;
			gchar* _tmp683_;
			ValaExpression* _tmp684_;
			ValaExpression* _tmp685_;
			ValaDataType* _tmp686_;
			ValaDataType* _tmp687_;
			ValaTypeSymbol* _tmp688_;
			ValaTypeSymbol* _tmp689_;
			_tmp679_ = vala_member_access_get_inner (self);
			_tmp680_ = _tmp679_;
			_tmp681_ = vala_expression_get_value_type (_tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = vala_code_node_to_string ((ValaCodeNode*) _tmp682_);
			_g_free0 (base_type_name);
			base_type_name = _tmp683_;
			_tmp684_ = vala_member_access_get_inner (self);
			_tmp685_ = _tmp684_;
			_tmp686_ = vala_expression_get_value_type (_tmp685_);
			_tmp687_ = _tmp686_;
			_tmp688_ = vala_data_type_get_type_symbol (_tmp687_);
			_tmp689_ = _tmp688_;
			base_type = (ValaSymbol*) _tmp689_;
		} else {
			ValaSymbol* _tmp690_;
			_tmp690_ = base_symbol;
			if (_tmp690_ != NULL) {
				ValaSymbol* _tmp691_;
				gchar* _tmp692_;
				ValaSymbol* _tmp693_;
				_tmp691_ = base_symbol;
				_tmp692_ = vala_symbol_get_full_name (_tmp691_);
				_g_free0 (base_type_name);
				base_type_name = _tmp692_;
				_tmp693_ = base_symbol;
				base_type = _tmp693_;
			}
		}
		_tmp694_ = g_strdup ("");
		base_type_package = _tmp694_;
		_tmp696_ = base_type;
		if (_tmp696_ != NULL) {
			ValaSymbol* _tmp697_;
			gboolean _tmp698_;
			gboolean _tmp699_;
			_tmp697_ = base_type;
			_tmp698_ = vala_symbol_get_external_package (_tmp697_);
			_tmp699_ = _tmp698_;
			_tmp695_ = _tmp699_;
		} else {
			_tmp695_ = FALSE;
		}
		if (_tmp695_) {
			ValaSymbol* _tmp700_;
			ValaSourceReference* _tmp701_;
			ValaSourceReference* _tmp702_;
			ValaSourceFile* _tmp703_;
			ValaSourceFile* _tmp704_;
			const gchar* _tmp705_;
			const gchar* _tmp706_;
			gchar* _tmp707_;
			const gchar* _tmp708_;
			_tmp700_ = base_symbol;
			_tmp701_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp700_);
			_tmp702_ = _tmp701_;
			_tmp703_ = vala_source_reference_get_file (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp705_ = vala_source_file_get_package_name (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp707_ = g_strdup (_tmp706_);
			_g_free0 (base_type_package);
			base_type_package = _tmp707_;
			_tmp708_ = base_type_package;
			if (_tmp708_ != NULL) {
				const gchar* _tmp709_;
				gchar* _tmp710_;
				_tmp709_ = base_type_package;
				_tmp710_ = g_strdup_printf (" (%s)", _tmp709_);
				_g_free0 (base_type_package);
				base_type_package = _tmp710_;
			}
		}
		_tmp711_ = g_strdup ("");
		visited_types_string = _tmp711_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp712_;
			gint _type_size = 0;
			ValaArrayList* _tmp713_;
			gint _tmp714_;
			gint _tmp715_;
			gint _type_index = 0;
			_tmp712_ = visited_types;
			_type_list = _tmp712_;
			_tmp713_ = _type_list;
			_tmp714_ = vala_collection_get_size ((ValaCollection*) _tmp713_);
			_tmp715_ = _tmp714_;
			_type_size = _tmp715_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp716_;
				gint _tmp717_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp718_;
				gpointer _tmp719_;
				const gchar* _tmp720_;
				ValaDataType* _tmp721_;
				gchar* _tmp722_;
				gchar* _tmp723_;
				gchar* _tmp724_;
				gchar* _tmp725_;
				gchar* _tmp726_;
				_type_index = _type_index + 1;
				_tmp716_ = _type_index;
				_tmp717_ = _type_size;
				if (!(_tmp716_ < _tmp717_)) {
					break;
				}
				_tmp718_ = _type_list;
				_tmp719_ = vala_list_get ((ValaList*) _tmp718_, _type_index);
				type = (ValaDataType*) _tmp719_;
				_tmp720_ = visited_types_string;
				_tmp721_ = type;
				_tmp722_ = vala_code_node_to_string ((ValaCodeNode*) _tmp721_);
				_tmp723_ = _tmp722_;
				_tmp724_ = g_strdup_printf (" or `%s'", _tmp723_);
				_tmp725_ = _tmp724_;
				_tmp726_ = g_strconcat (_tmp720_, _tmp725_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp726_;
				_g_free0 (_tmp725_);
				_g_free0 (_tmp723_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp727_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp728_ = _tmp727_;
		_tmp729_ = self->priv->_member_name;
		_tmp730_ = base_type_name;
		_tmp731_ = base_type_package;
		_tmp732_ = visited_types_string;
		vala_report_error (_tmp728_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp729_, _tmp730_, _tmp731_, _tmp732_);
		_tmp733_ = vala_invalid_type_new ();
		_tmp734_ = _tmp733_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp734_);
		_vala_code_node_unref0 (_tmp734_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp735_;
		ValaSymbol* _tmp736_;
		gboolean _tmp737_;
		gboolean _tmp738_;
		_tmp735_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp736_ = _tmp735_;
		_tmp737_ = vala_code_node_get_error ((ValaCodeNode*) _tmp736_);
		_tmp738_ = _tmp737_;
		if (_tmp738_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp739_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp740_ = _tmp739_;
	if (VALA_IS_SIGNAL (_tmp740_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp741_;
		ValaSymbol* _tmp742_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp749_;
		ValaCodeNode* _tmp750_;
		ValaCodeNode* _tmp751_;
		gboolean _tmp752_ = FALSE;
		gboolean _tmp753_ = FALSE;
		gboolean _tmp754_ = FALSE;
		ValaCodeNode* _tmp755_;
		_tmp741_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp742_ = _tmp741_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp742_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp743_;
			ValaCodeNode* _tmp744_;
			ValaCodeNode* _tmp745_;
			ValaCodeNode* _tmp746_;
			ValaCodeNode* _tmp747_;
			ValaCodeNode* _tmp748_;
			_tmp743_ = ma;
			_tmp744_ = vala_code_node_get_parent_node (_tmp743_);
			_tmp745_ = _tmp744_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp745_)) {
				break;
			}
			_tmp746_ = ma;
			_tmp747_ = vala_code_node_get_parent_node (_tmp746_);
			_tmp748_ = _tmp747_;
			ma = _tmp748_;
		}
		_tmp749_ = ma;
		_tmp750_ = vala_code_node_get_parent_node (_tmp749_);
		_tmp751_ = _tmp750_;
		parent = _tmp751_;
		_tmp755_ = parent;
		if (_tmp755_ != NULL) {
			ValaCodeNode* _tmp756_;
			_tmp756_ = parent;
			_tmp754_ = !VALA_IS_ELEMENT_ACCESS (_tmp756_);
		} else {
			_tmp754_ = FALSE;
		}
		if (_tmp754_) {
			ValaCodeNode* _tmp757_;
			ValaExpression* _tmp758_;
			ValaExpression* _tmp759_;
			_tmp757_ = ma;
			_tmp758_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp757_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp759_ = _tmp758_;
			_tmp753_ = !VALA_IS_BASE_ACCESS (_tmp759_);
		} else {
			_tmp753_ = FALSE;
		}
		if (_tmp753_) {
			gboolean _tmp760_ = FALSE;
			ValaCodeNode* _tmp761_;
			_tmp761_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp761_)) {
				_tmp760_ = TRUE;
			} else {
				ValaCodeNode* _tmp762_;
				ValaList* _tmp763_;
				_tmp762_ = parent;
				_tmp763_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp762_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp760_ = vala_collection_contains ((ValaCollection*) _tmp763_, (ValaExpression*) self);
			}
			_tmp752_ = _tmp760_;
		} else {
			_tmp752_ = FALSE;
		}
		if (_tmp752_) {
			ValaSignal* _tmp764_;
			ValaAttribute* _tmp765_;
			_tmp764_ = sig;
			_tmp765_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp764_, "HasEmitter");
			if (_tmp765_ != NULL) {
				ValaSignal* _tmp766_;
				ValaSignal* _tmp767_;
				ValaMethod* _tmp768_;
				ValaMethod* _tmp769_;
				_tmp766_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp766_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp767_ = sig;
				_tmp768_ = vala_signal_get_emitter (_tmp767_);
				_tmp769_ = _tmp768_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp769_);
			} else {
				ValaSourceReference* _tmp770_;
				ValaSourceReference* _tmp771_;
				ValaSymbol* _tmp772_;
				ValaSymbol* _tmp773_;
				gchar* _tmp774_;
				gchar* _tmp775_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp770_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp771_ = _tmp770_;
				_tmp772_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp773_ = _tmp772_;
				_tmp774_ = vala_symbol_get_full_name (_tmp773_);
				_tmp775_ = _tmp774_;
				vala_report_error (_tmp771_, "Signal `%s' requires emitter in this context", _tmp775_);
				_g_free0 (_tmp775_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp776_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp777_ = _tmp776_;
	member = _tmp777_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp778_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp778_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp779_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp779_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp780_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp781_;
		ValaSymbol* _tmp782_;
		ValaSymbol* _tmp783_;
		gboolean _tmp784_ = FALSE;
		ValaBlock* _tmp785_;
		_tmp780_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp781_ = local;
		_tmp782_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp781_);
		_tmp783_ = _tmp782_;
		block = VALA_IS_BLOCK (_tmp783_) ? ((ValaBlock*) _tmp783_) : NULL;
		_tmp785_ = block;
		if (_tmp785_ != NULL) {
			ValaBlock* _tmp786_;
			ValaSymbol* _tmp787_;
			ValaSemanticAnalyzer* _tmp788_;
			ValaSemanticAnalyzer* _tmp789_;
			ValaSymbol* _tmp790_;
			ValaSymbol* _tmp791_;
			_tmp786_ = block;
			_tmp787_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp786_);
			_tmp788_ = vala_code_context_get_analyzer (context);
			_tmp789_ = _tmp788_;
			_tmp790_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp789_);
			_tmp791_ = _tmp790_;
			_tmp784_ = _tmp787_ != _tmp791_;
		} else {
			_tmp784_ = FALSE;
		}
		if (_tmp784_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp792_;
			ValaSemanticAnalyzer* _tmp793_;
			ValaSymbol* _tmp794_;
			ValaSymbol* _tmp795_;
			ValaLocalVariable* _tmp806_;
			ValaBlock* _tmp807_;
			ValaLocalVariable* _tmp808_;
			ValaDataType* _tmp809_;
			ValaDataType* _tmp810_;
			ValaTypeSymbol* _tmp811_;
			ValaTypeSymbol* _tmp812_;
			ValaSemanticAnalyzer* _tmp813_;
			ValaSemanticAnalyzer* _tmp814_;
			ValaDataType* _tmp815_;
			ValaTypeSymbol* _tmp816_;
			ValaTypeSymbol* _tmp817_;
			_tmp792_ = vala_code_context_get_analyzer (context);
			_tmp793_ = _tmp792_;
			_tmp794_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp793_);
			_tmp795_ = _tmp794_;
			sym = _tmp795_;
			while (TRUE) {
				ValaSymbol* _tmp796_;
				ValaBlock* _tmp797_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp798_;
				ValaMethod* _tmp799_;
				ValaSymbol* _tmp803_;
				ValaSymbol* _tmp804_;
				ValaSymbol* _tmp805_;
				_tmp796_ = sym;
				_tmp797_ = block;
				if (!(_tmp796_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp797_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp798_ = sym;
				method = VALA_IS_METHOD (_tmp798_) ? ((ValaMethod*) _tmp798_) : NULL;
				_tmp799_ = method;
				if (_tmp799_ != NULL) {
					ValaMethod* _tmp800_;
					ValaMethod* _tmp801_;
					ValaLocalVariable* _tmp802_;
					_tmp800_ = method;
					vala_method_set_closure (_tmp800_, TRUE);
					_tmp801_ = method;
					_tmp802_ = local;
					vala_method_add_captured_variable (_tmp801_, _tmp802_);
				}
				_tmp803_ = sym;
				_tmp804_ = vala_symbol_get_parent_symbol (_tmp803_);
				_tmp805_ = _tmp804_;
				sym = _tmp805_;
			}
			_tmp806_ = local;
			vala_local_variable_set_captured (_tmp806_, TRUE);
			_tmp807_ = block;
			vala_block_set_captured (_tmp807_, TRUE);
			_tmp808_ = local;
			_tmp809_ = vala_variable_get_variable_type ((ValaVariable*) _tmp808_);
			_tmp810_ = _tmp809_;
			_tmp811_ = vala_data_type_get_type_symbol (_tmp810_);
			_tmp812_ = _tmp811_;
			_tmp813_ = vala_code_context_get_analyzer (context);
			_tmp814_ = _tmp813_;
			_tmp815_ = _tmp814_->va_list_type;
			_tmp816_ = vala_data_type_get_type_symbol (_tmp815_);
			_tmp817_ = _tmp816_;
			if (_tmp812_ == _tmp817_) {
				ValaSourceReference* _tmp818_;
				ValaSourceReference* _tmp819_;
				ValaLocalVariable* _tmp820_;
				gchar* _tmp821_;
				gchar* _tmp822_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp818_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp819_ = _tmp818_;
				_tmp820_ = local;
				_tmp821_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp820_);
				_tmp822_ = _tmp821_;
				vala_report_error (_tmp819_, "Capturing `va_list' variable `%s' is not allowed", _tmp822_);
				_g_free0 (_tmp822_);
			}
		}
	} else {
		ValaSymbol* _tmp823_;
		_tmp823_ = member;
		if (VALA_IS_PARAMETER (_tmp823_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp824_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp825_;
			ValaSymbol* _tmp826_;
			ValaSymbol* _tmp827_;
			gboolean _tmp828_ = FALSE;
			gboolean _tmp829_ = FALSE;
			ValaMethod* _tmp830_;
			_tmp824_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp825_ = param;
			_tmp826_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp825_);
			_tmp827_ = _tmp826_;
			m = VALA_IS_METHOD (_tmp827_) ? ((ValaMethod*) _tmp827_) : NULL;
			_tmp830_ = m;
			if (_tmp830_ != NULL) {
				ValaMethod* _tmp831_;
				ValaSemanticAnalyzer* _tmp832_;
				ValaSemanticAnalyzer* _tmp833_;
				ValaSymbol* _tmp834_;
				ValaSymbol* _tmp835_;
				_tmp831_ = m;
				_tmp832_ = vala_code_context_get_analyzer (context);
				_tmp833_ = _tmp832_;
				_tmp834_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp833_);
				_tmp835_ = _tmp834_;
				_tmp829_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp831_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp835_;
			} else {
				_tmp829_ = FALSE;
			}
			if (_tmp829_) {
				ValaParameter* _tmp836_;
				ValaMethod* _tmp837_;
				ValaParameter* _tmp838_;
				ValaParameter* _tmp839_;
				_tmp836_ = param;
				_tmp837_ = m;
				_tmp838_ = vala_method_get_this_parameter (_tmp837_);
				_tmp839_ = _tmp838_;
				_tmp828_ = _tmp836_ != _tmp839_;
			} else {
				_tmp828_ = FALSE;
			}
			if (_tmp828_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp840_;
				ValaSemanticAnalyzer* _tmp841_;
				ValaSymbol* _tmp842_;
				ValaSymbol* _tmp843_;
				ValaParameter* _tmp852_;
				ValaMethod* _tmp853_;
				ValaBlock* _tmp854_;
				ValaBlock* _tmp855_;
				ValaParameter* _tmp856_;
				ValaParameterDirection _tmp857_;
				ValaParameterDirection _tmp858_;
				ValaParameter* _tmp864_;
				ValaDataType* _tmp865_;
				ValaDataType* _tmp866_;
				ValaTypeSymbol* _tmp867_;
				ValaTypeSymbol* _tmp868_;
				ValaSemanticAnalyzer* _tmp869_;
				ValaSemanticAnalyzer* _tmp870_;
				ValaDataType* _tmp871_;
				ValaTypeSymbol* _tmp872_;
				ValaTypeSymbol* _tmp873_;
				_tmp840_ = vala_code_context_get_analyzer (context);
				_tmp841_ = _tmp840_;
				_tmp842_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp841_);
				_tmp843_ = _tmp842_;
				sym = _tmp843_;
				while (TRUE) {
					ValaSymbol* _tmp844_;
					ValaMethod* _tmp845_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp846_;
					ValaMethod* _tmp847_;
					ValaSymbol* _tmp849_;
					ValaSymbol* _tmp850_;
					ValaSymbol* _tmp851_;
					_tmp844_ = sym;
					_tmp845_ = m;
					if (!(_tmp844_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp845_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp846_ = sym;
					method = VALA_IS_METHOD (_tmp846_) ? ((ValaMethod*) _tmp846_) : NULL;
					_tmp847_ = method;
					if (_tmp847_ != NULL) {
						ValaMethod* _tmp848_;
						_tmp848_ = method;
						vala_method_set_closure (_tmp848_, TRUE);
					}
					_tmp849_ = sym;
					_tmp850_ = vala_symbol_get_parent_symbol (_tmp849_);
					_tmp851_ = _tmp850_;
					sym = _tmp851_;
				}
				_tmp852_ = param;
				vala_parameter_set_captured (_tmp852_, TRUE);
				_tmp853_ = m;
				_tmp854_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp853_);
				_tmp855_ = _tmp854_;
				vala_block_set_captured (_tmp855_, TRUE);
				_tmp856_ = param;
				_tmp857_ = vala_parameter_get_direction (_tmp856_);
				_tmp858_ = _tmp857_;
				if (_tmp858_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp859_;
					ValaSourceReference* _tmp860_;
					ValaParameter* _tmp861_;
					gchar* _tmp862_;
					gchar* _tmp863_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp859_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp860_ = _tmp859_;
					_tmp861_ = param;
					_tmp862_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp861_);
					_tmp863_ = _tmp862_;
					vala_report_error (_tmp860_, "Cannot capture reference or output parameter `%s'", _tmp863_);
					_g_free0 (_tmp863_);
				}
				_tmp864_ = param;
				_tmp865_ = vala_variable_get_variable_type ((ValaVariable*) _tmp864_);
				_tmp866_ = _tmp865_;
				_tmp867_ = vala_data_type_get_type_symbol (_tmp866_);
				_tmp868_ = _tmp867_;
				_tmp869_ = vala_code_context_get_analyzer (context);
				_tmp870_ = _tmp869_;
				_tmp871_ = _tmp870_->va_list_type;
				_tmp872_ = vala_data_type_get_type_symbol (_tmp871_);
				_tmp873_ = _tmp872_;
				if (_tmp868_ == _tmp873_) {
					ValaSourceReference* _tmp874_;
					ValaSourceReference* _tmp875_;
					ValaParameter* _tmp876_;
					gchar* _tmp877_;
					gchar* _tmp878_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp874_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp875_ = _tmp874_;
					_tmp876_ = param;
					_tmp877_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp876_);
					_tmp878_ = _tmp877_;
					vala_report_error (_tmp875_, "Capturing `va_list' parameter `%s' is not allowed", _tmp878_);
					_g_free0 (_tmp878_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp879_;
				ValaSymbol* _tmp880_;
				ValaSymbol* _tmp881_;
				ValaSymbol* _tmp882_;
				ValaSymbol* _tmp883_;
				gboolean _tmp884_ = FALSE;
				gboolean _tmp885_ = FALSE;
				ValaPropertyAccessor* _tmp886_;
				_tmp879_ = param;
				_tmp880_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp879_);
				_tmp881_ = _tmp880_;
				_tmp882_ = vala_symbol_get_parent_symbol (_tmp881_);
				_tmp883_ = _tmp882_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp883_) ? ((ValaPropertyAccessor*) _tmp883_) : NULL;
				_tmp886_ = acc;
				if (_tmp886_ != NULL) {
					ValaPropertyAccessor* _tmp887_;
					ValaSemanticAnalyzer* _tmp888_;
					ValaSemanticAnalyzer* _tmp889_;
					ValaSymbol* _tmp890_;
					ValaSymbol* _tmp891_;
					_tmp887_ = acc;
					_tmp888_ = vala_code_context_get_analyzer (context);
					_tmp889_ = _tmp888_;
					_tmp890_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp889_);
					_tmp891_ = _tmp890_;
					_tmp885_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp887_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp891_;
				} else {
					_tmp885_ = FALSE;
				}
				if (_tmp885_) {
					ValaParameter* _tmp892_;
					ValaPropertyAccessor* _tmp893_;
					ValaProperty* _tmp894_;
					ValaProperty* _tmp895_;
					ValaParameter* _tmp896_;
					ValaParameter* _tmp897_;
					_tmp892_ = param;
					_tmp893_ = acc;
					_tmp894_ = vala_property_accessor_get_prop (_tmp893_);
					_tmp895_ = _tmp894_;
					_tmp896_ = vala_property_get_this_parameter (_tmp895_);
					_tmp897_ = _tmp896_;
					_tmp884_ = _tmp892_ != _tmp897_;
				} else {
					_tmp884_ = FALSE;
				}
				if (_tmp884_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp898_;
					ValaSemanticAnalyzer* _tmp899_;
					ValaSymbol* _tmp900_;
					ValaSymbol* _tmp901_;
					ValaParameter* _tmp910_;
					ValaPropertyAccessor* _tmp911_;
					ValaBlock* _tmp912_;
					ValaBlock* _tmp913_;
					_tmp898_ = vala_code_context_get_analyzer (context);
					_tmp899_ = _tmp898_;
					_tmp900_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp899_);
					_tmp901_ = _tmp900_;
					sym = _tmp901_;
					while (TRUE) {
						ValaSymbol* _tmp902_;
						ValaMethod* _tmp903_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp904_;
						ValaMethod* _tmp905_;
						ValaSymbol* _tmp907_;
						ValaSymbol* _tmp908_;
						ValaSymbol* _tmp909_;
						_tmp902_ = sym;
						_tmp903_ = m;
						if (!(_tmp902_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp903_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp904_ = sym;
						method = VALA_IS_METHOD (_tmp904_) ? ((ValaMethod*) _tmp904_) : NULL;
						_tmp905_ = method;
						if (_tmp905_ != NULL) {
							ValaMethod* _tmp906_;
							_tmp906_ = method;
							vala_method_set_closure (_tmp906_, TRUE);
						}
						_tmp907_ = sym;
						_tmp908_ = vala_symbol_get_parent_symbol (_tmp907_);
						_tmp909_ = _tmp908_;
						sym = _tmp909_;
					}
					_tmp910_ = param;
					vala_parameter_set_captured (_tmp910_, TRUE);
					_tmp911_ = acc;
					_tmp912_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp911_);
					_tmp913_ = _tmp912_;
					vala_block_set_captured (_tmp913_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp914_;
			_tmp914_ = member;
			if (VALA_IS_FIELD (_tmp914_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp915_;
				ValaField* _tmp916_;
				ValaSymbolAccessibility _tmp917_;
				ValaSymbolAccessibility _tmp918_;
				ValaField* _tmp919_;
				ValaMemberBinding _tmp920_;
				ValaMemberBinding _tmp921_;
				ValaField* _tmp922_;
				ValaMemberBinding _tmp923_;
				ValaMemberBinding _tmp924_;
				ValaField* _tmp925_;
				ValaDataType* _tmp926_;
				ValaDataType* _tmp927_;
				_tmp915_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp915_, VALA_TYPE_FIELD, ValaField);
				_tmp916_ = f;
				_tmp917_ = vala_symbol_get_access ((ValaSymbol*) _tmp916_);
				_tmp918_ = _tmp917_;
				access = _tmp918_;
				_tmp919_ = f;
				_tmp920_ = vala_field_get_binding (_tmp919_);
				_tmp921_ = _tmp920_;
				instance = _tmp921_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp922_ = f;
				_tmp923_ = vala_field_get_binding (_tmp922_);
				_tmp924_ = _tmp923_;
				klass = _tmp924_ == VALA_MEMBER_BINDING_CLASS;
				_tmp925_ = f;
				_tmp926_ = vala_variable_get_variable_type ((ValaVariable*) _tmp925_);
				_tmp927_ = _tmp926_;
				if (VALA_IS_GENERIC_TYPE (_tmp927_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp928_;
				_tmp928_ = member;
				if (VALA_IS_CONSTANT (_tmp928_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp929_;
					ValaConstant* _tmp930_;
					ValaSymbolAccessibility _tmp931_;
					ValaSymbolAccessibility _tmp932_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp933_;
					ValaSymbol* _tmp934_;
					ValaSymbol* _tmp935_;
					gboolean _tmp936_ = FALSE;
					ValaBlock* _tmp937_;
					_tmp929_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp929_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp930_ = c;
					_tmp931_ = vala_symbol_get_access ((ValaSymbol*) _tmp930_);
					_tmp932_ = _tmp931_;
					access = _tmp932_;
					_tmp933_ = c;
					_tmp934_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp933_);
					_tmp935_ = _tmp934_;
					block = VALA_IS_BLOCK (_tmp935_) ? ((ValaBlock*) _tmp935_) : NULL;
					_tmp937_ = block;
					if (_tmp937_ != NULL) {
						ValaBlock* _tmp938_;
						ValaSymbol* _tmp939_;
						ValaSemanticAnalyzer* _tmp940_;
						ValaSemanticAnalyzer* _tmp941_;
						ValaSymbol* _tmp942_;
						ValaSymbol* _tmp943_;
						_tmp938_ = block;
						_tmp939_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp938_);
						_tmp940_ = vala_code_context_get_analyzer (context);
						_tmp941_ = _tmp940_;
						_tmp942_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp941_);
						_tmp943_ = _tmp942_;
						_tmp936_ = _tmp939_ != _tmp943_;
					} else {
						_tmp936_ = FALSE;
					}
					if (_tmp936_) {
						ValaSourceReference* _tmp944_;
						ValaSourceReference* _tmp945_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp944_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp945_ = _tmp944_;
						vala_report_error (_tmp945_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp946_;
					_tmp946_ = member;
					if (VALA_IS_METHOD (_tmp946_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp947_;
						ValaMethod* _tmp948_;
						gboolean _tmp949_;
						gboolean _tmp950_;
						ValaMethod* _tmp1037_;
						ValaSymbolAccessibility _tmp1038_;
						ValaSymbolAccessibility _tmp1039_;
						ValaMethod* _tmp1040_;
						ValaMethod* _tmp1044_;
						ValaMemberBinding _tmp1045_;
						ValaMemberBinding _tmp1046_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1066_;
						ValaDataType* _tmp1067_;
						ValaDataType* _tmp1068_;
						gboolean _tmp1069_ = FALSE;
						ValaGenericType* _tmp1070_;
						_tmp947_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp947_, VALA_TYPE_METHOD, ValaMethod);
						_tmp948_ = m;
						_tmp949_ = vala_method_get_is_async_callback (_tmp948_);
						_tmp950_ = _tmp949_;
						if (_tmp950_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp951_;
							ValaSemanticAnalyzer* _tmp952_;
							ValaMethod* _tmp953_;
							ValaMethod* _tmp954_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp955_;
							ValaMethod* _tmp982_;
							ValaSemanticAnalyzer* _tmp983_;
							ValaSemanticAnalyzer* _tmp984_;
							ValaMethod* _tmp985_;
							ValaMethod* _tmp986_;
							ValaMethod* _tmp1002_;
							ValaMethod* _tmp1003_;
							ValaMethod* _tmp1004_;
							ValaSymbol* _tmp1005_;
							ValaSymbol* _tmp1006_;
							_tmp951_ = vala_code_context_get_analyzer (context);
							_tmp952_ = _tmp951_;
							_tmp953_ = vala_semantic_analyzer_get_current_async_method (_tmp952_);
							_tmp954_ = _tmp953_;
							async_method = _tmp954_;
							is_valid_access = FALSE;
							_tmp955_ = async_method;
							if (_tmp955_ != NULL) {
								ValaMethod* _tmp956_;
								ValaMethod* _tmp957_;
								ValaMethod* _tmp958_;
								_tmp956_ = m;
								_tmp957_ = async_method;
								_tmp958_ = vala_method_get_callback_method (_tmp957_);
								if (_tmp956_ == _tmp958_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp959_ = FALSE;
									ValaMethod* _tmp960_;
									ValaMethod* _tmp961_;
									ValaMethod* _tmp962_;
									_tmp960_ = async_method;
									_tmp961_ = vala_method_get_base_method (_tmp960_);
									_tmp962_ = _tmp961_;
									if (_tmp962_ != NULL) {
										ValaMethod* _tmp963_;
										ValaMethod* _tmp964_;
										ValaMethod* _tmp965_;
										ValaMethod* _tmp966_;
										ValaMethod* _tmp967_;
										_tmp963_ = m;
										_tmp964_ = async_method;
										_tmp965_ = vala_method_get_base_method (_tmp964_);
										_tmp966_ = _tmp965_;
										_tmp967_ = vala_method_get_callback_method (_tmp966_);
										_tmp959_ = _tmp963_ == _tmp967_;
									} else {
										_tmp959_ = FALSE;
									}
									if (_tmp959_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp968_ = FALSE;
										ValaMethod* _tmp969_;
										ValaMethod* _tmp970_;
										ValaMethod* _tmp971_;
										_tmp969_ = async_method;
										_tmp970_ = vala_method_get_base_interface_method (_tmp969_);
										_tmp971_ = _tmp970_;
										if (_tmp971_ != NULL) {
											ValaMethod* _tmp972_;
											ValaMethod* _tmp973_;
											ValaMethod* _tmp974_;
											ValaMethod* _tmp975_;
											ValaMethod* _tmp976_;
											_tmp972_ = m;
											_tmp973_ = async_method;
											_tmp974_ = vala_method_get_base_interface_method (_tmp973_);
											_tmp975_ = _tmp974_;
											_tmp976_ = vala_method_get_callback_method (_tmp975_);
											_tmp968_ = _tmp972_ == _tmp976_;
										} else {
											_tmp968_ = FALSE;
										}
										if (_tmp968_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp977_;
								ValaSourceReference* _tmp978_;
								ValaMethod* _tmp979_;
								gchar* _tmp980_;
								gchar* _tmp981_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp977_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp978_ = _tmp977_;
								_tmp979_ = m;
								_tmp980_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp979_);
								_tmp981_ = _tmp980_;
								vala_report_error (_tmp978_, "Access to async callback `%s' not allowed in this context", _tmp981_);
								_g_free0 (_tmp981_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp982_ = async_method;
							_tmp983_ = vala_code_context_get_analyzer (context);
							_tmp984_ = _tmp983_;
							_tmp985_ = vala_semantic_analyzer_get_current_method (_tmp984_);
							_tmp986_ = _tmp985_;
							if (_tmp982_ != _tmp986_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp987_;
								ValaSemanticAnalyzer* _tmp988_;
								ValaMethod* _tmp989_;
								ValaMethod* _tmp990_;
								ValaMethod* _tmp999_;
								ValaBlock* _tmp1000_;
								ValaBlock* _tmp1001_;
								_tmp987_ = vala_code_context_get_analyzer (context);
								_tmp988_ = _tmp987_;
								_tmp989_ = vala_semantic_analyzer_get_current_method (_tmp988_);
								_tmp990_ = _tmp989_;
								sym = (ValaSymbol*) _tmp990_;
								while (TRUE) {
									ValaSymbol* _tmp991_;
									ValaMethod* _tmp992_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp993_;
									ValaMethod* _tmp994_;
									ValaSymbol* _tmp996_;
									ValaSymbol* _tmp997_;
									ValaSymbol* _tmp998_;
									_tmp991_ = sym;
									_tmp992_ = async_method;
									if (!(_tmp991_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp992_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp993_ = sym;
									method = VALA_IS_METHOD (_tmp993_) ? ((ValaMethod*) _tmp993_) : NULL;
									_tmp994_ = method;
									if (_tmp994_ != NULL) {
										ValaMethod* _tmp995_;
										_tmp995_ = method;
										vala_method_set_closure (_tmp995_, TRUE);
									}
									_tmp996_ = sym;
									_tmp997_ = vala_symbol_get_parent_symbol (_tmp996_);
									_tmp998_ = _tmp997_;
									sym = _tmp998_;
								}
								_tmp999_ = async_method;
								_tmp1000_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp999_);
								_tmp1001_ = _tmp1000_;
								vala_block_set_captured (_tmp1001_, TRUE);
							}
							_tmp1002_ = async_method;
							_tmp1003_ = vala_method_get_callback_method (_tmp1002_);
							m = _tmp1003_;
							_tmp1004_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1004_);
							_tmp1005_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1006_ = _tmp1005_;
							member = _tmp1006_;
						} else {
							ValaMethod* _tmp1007_;
							ValaMethod* _tmp1008_;
							ValaMethod* _tmp1009_;
							_tmp1007_ = m;
							_tmp1008_ = vala_method_get_base_method (_tmp1007_);
							_tmp1009_ = _tmp1008_;
							if (_tmp1009_ != NULL) {
								ValaMethod* _tmp1010_;
								ValaMethod* _tmp1011_;
								ValaMethod* _tmp1012_;
								ValaMethod* _tmp1013_;
								ValaSignal* _tmp1014_;
								ValaSignal* _tmp1015_;
								ValaSymbol* _tmp1020_;
								ValaSymbol* _tmp1021_;
								_tmp1010_ = m;
								_tmp1011_ = vala_method_get_base_method (_tmp1010_);
								_tmp1012_ = _tmp1011_;
								m = _tmp1012_;
								_tmp1013_ = m;
								_tmp1014_ = vala_method_get_signal_reference (_tmp1013_);
								_tmp1015_ = _tmp1014_;
								if (_tmp1015_ != NULL) {
									ValaMethod* _tmp1016_;
									ValaSignal* _tmp1017_;
									ValaSignal* _tmp1018_;
									_tmp1016_ = m;
									_tmp1017_ = vala_method_get_signal_reference (_tmp1016_);
									_tmp1018_ = _tmp1017_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1018_);
								} else {
									ValaMethod* _tmp1019_;
									_tmp1019_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1019_);
								}
								_tmp1020_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1021_ = _tmp1020_;
								member = _tmp1021_;
							} else {
								ValaMethod* _tmp1022_;
								ValaMethod* _tmp1023_;
								ValaMethod* _tmp1024_;
								_tmp1022_ = m;
								_tmp1023_ = vala_method_get_base_interface_method (_tmp1022_);
								_tmp1024_ = _tmp1023_;
								if (_tmp1024_ != NULL) {
									ValaMethod* _tmp1025_;
									ValaMethod* _tmp1026_;
									ValaMethod* _tmp1027_;
									ValaMethod* _tmp1028_;
									ValaSignal* _tmp1029_;
									ValaSignal* _tmp1030_;
									ValaSymbol* _tmp1035_;
									ValaSymbol* _tmp1036_;
									_tmp1025_ = m;
									_tmp1026_ = vala_method_get_base_interface_method (_tmp1025_);
									_tmp1027_ = _tmp1026_;
									m = _tmp1027_;
									_tmp1028_ = m;
									_tmp1029_ = vala_method_get_signal_reference (_tmp1028_);
									_tmp1030_ = _tmp1029_;
									if (_tmp1030_ != NULL) {
										ValaMethod* _tmp1031_;
										ValaSignal* _tmp1032_;
										ValaSignal* _tmp1033_;
										_tmp1031_ = m;
										_tmp1032_ = vala_method_get_signal_reference (_tmp1031_);
										_tmp1033_ = _tmp1032_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1033_);
									} else {
										ValaMethod* _tmp1034_;
										_tmp1034_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1034_);
									}
									_tmp1035_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1036_ = _tmp1035_;
									member = _tmp1036_;
								}
							}
						}
						_tmp1037_ = m;
						_tmp1038_ = vala_symbol_get_access ((ValaSymbol*) _tmp1037_);
						_tmp1039_ = _tmp1038_;
						access = _tmp1039_;
						_tmp1040_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1040_)) {
							ValaMethod* _tmp1041_;
							ValaMemberBinding _tmp1042_;
							ValaMemberBinding _tmp1043_;
							_tmp1041_ = m;
							_tmp1042_ = vala_method_get_binding (_tmp1041_);
							_tmp1043_ = _tmp1042_;
							instance = _tmp1043_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1044_ = m;
						_tmp1045_ = vala_method_get_binding (_tmp1044_);
						_tmp1046_ = _tmp1045_;
						klass = _tmp1046_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1047_;
							ValaList* _tmp1048_;
							gint _param_size = 0;
							ValaList* _tmp1049_;
							gint _tmp1050_;
							gint _tmp1051_;
							gint _param_index = 0;
							_tmp1047_ = m;
							_tmp1048_ = vala_callable_get_parameters ((ValaCallable*) _tmp1047_);
							_param_list = _tmp1048_;
							_tmp1049_ = _param_list;
							_tmp1050_ = vala_collection_get_size ((ValaCollection*) _tmp1049_);
							_tmp1051_ = _tmp1050_;
							_param_size = _tmp1051_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1052_;
								gint _tmp1053_;
								ValaParameter* param = NULL;
								ValaList* _tmp1054_;
								gpointer _tmp1055_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1056_;
								ValaDataType* _tmp1057_;
								ValaDataType* _tmp1058_;
								gboolean _tmp1059_ = FALSE;
								ValaGenericType* _tmp1060_;
								_param_index = _param_index + 1;
								_tmp1052_ = _param_index;
								_tmp1053_ = _param_size;
								if (!(_tmp1052_ < _tmp1053_)) {
									break;
								}
								_tmp1054_ = _param_list;
								_tmp1055_ = vala_list_get (_tmp1054_, _param_index);
								param = (ValaParameter*) _tmp1055_;
								_tmp1056_ = param;
								_tmp1057_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1056_);
								_tmp1058_ = _tmp1057_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1058_) ? ((ValaGenericType*) _tmp1058_) : NULL;
								_tmp1060_ = generic_type;
								if (_tmp1060_ != NULL) {
									ValaGenericType* _tmp1061_;
									ValaTypeParameter* _tmp1062_;
									ValaTypeParameter* _tmp1063_;
									ValaSymbol* _tmp1064_;
									ValaSymbol* _tmp1065_;
									_tmp1061_ = generic_type;
									_tmp1062_ = vala_generic_type_get_type_parameter (_tmp1061_);
									_tmp1063_ = _tmp1062_;
									_tmp1064_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1063_);
									_tmp1065_ = _tmp1064_;
									_tmp1059_ = VALA_IS_TYPESYMBOL (_tmp1065_);
								} else {
									_tmp1059_ = FALSE;
								}
								if (_tmp1059_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1066_ = m;
						_tmp1067_ = vala_callable_get_return_type ((ValaCallable*) _tmp1066_);
						_tmp1068_ = _tmp1067_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1068_) ? ((ValaGenericType*) _tmp1068_) : NULL;
						_tmp1070_ = generic_type;
						if (_tmp1070_ != NULL) {
							ValaGenericType* _tmp1071_;
							ValaTypeParameter* _tmp1072_;
							ValaTypeParameter* _tmp1073_;
							ValaSymbol* _tmp1074_;
							ValaSymbol* _tmp1075_;
							_tmp1071_ = generic_type;
							_tmp1072_ = vala_generic_type_get_type_parameter (_tmp1071_);
							_tmp1073_ = _tmp1072_;
							_tmp1074_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1073_);
							_tmp1075_ = _tmp1074_;
							_tmp1069_ = VALA_IS_TYPESYMBOL (_tmp1075_);
						} else {
							_tmp1069_ = FALSE;
						}
						if (_tmp1069_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1076_;
						_tmp1076_ = member;
						if (VALA_IS_PROPERTY (_tmp1076_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1077_;
							ValaProperty* _tmp1078_;
							ValaProperty* _tmp1079_;
							ValaProperty* _tmp1080_;
							ValaProperty* _tmp1081_;
							ValaProperty* _tmp1097_;
							ValaSymbolAccessibility _tmp1098_;
							ValaSymbolAccessibility _tmp1099_;
							gboolean _tmp1100_;
							gboolean _tmp1101_;
							ValaProperty* _tmp1162_;
							ValaMemberBinding _tmp1163_;
							ValaMemberBinding _tmp1164_;
							ValaProperty* _tmp1165_;
							ValaDataType* _tmp1166_;
							ValaDataType* _tmp1167_;
							_tmp1077_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1077_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1078_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1078_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1079_ = prop;
							_tmp1080_ = vala_property_get_base_property (_tmp1079_);
							_tmp1081_ = _tmp1080_;
							if (_tmp1081_ != NULL) {
								ValaProperty* _tmp1082_;
								ValaProperty* _tmp1083_;
								ValaProperty* _tmp1084_;
								ValaProperty* _tmp1085_;
								ValaSymbol* _tmp1086_;
								ValaSymbol* _tmp1087_;
								_tmp1082_ = prop;
								_tmp1083_ = vala_property_get_base_property (_tmp1082_);
								_tmp1084_ = _tmp1083_;
								prop = _tmp1084_;
								_tmp1085_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1085_);
								_tmp1086_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1087_ = _tmp1086_;
								member = _tmp1087_;
							} else {
								ValaProperty* _tmp1088_;
								ValaProperty* _tmp1089_;
								ValaProperty* _tmp1090_;
								_tmp1088_ = prop;
								_tmp1089_ = vala_property_get_base_interface_property (_tmp1088_);
								_tmp1090_ = _tmp1089_;
								if (_tmp1090_ != NULL) {
									ValaProperty* _tmp1091_;
									ValaProperty* _tmp1092_;
									ValaProperty* _tmp1093_;
									ValaProperty* _tmp1094_;
									ValaSymbol* _tmp1095_;
									ValaSymbol* _tmp1096_;
									_tmp1091_ = prop;
									_tmp1092_ = vala_property_get_base_interface_property (_tmp1091_);
									_tmp1093_ = _tmp1092_;
									prop = _tmp1093_;
									_tmp1094_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1094_);
									_tmp1095_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1096_ = _tmp1095_;
									member = _tmp1096_;
								}
							}
							_tmp1097_ = prop;
							_tmp1098_ = vala_symbol_get_access ((ValaSymbol*) _tmp1097_);
							_tmp1099_ = _tmp1098_;
							access = _tmp1099_;
							_tmp1100_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1101_ = _tmp1100_;
							if (_tmp1101_) {
								ValaProperty* _tmp1102_;
								ValaPropertyAccessor* _tmp1103_;
								ValaPropertyAccessor* _tmp1104_;
								ValaProperty* _tmp1110_;
								ValaSymbolAccessibility _tmp1111_;
								ValaSymbolAccessibility _tmp1112_;
								_tmp1102_ = prop;
								_tmp1103_ = vala_property_get_set_accessor (_tmp1102_);
								_tmp1104_ = _tmp1103_;
								if (_tmp1104_ == NULL) {
									ValaSourceReference* _tmp1105_;
									ValaSourceReference* _tmp1106_;
									ValaProperty* _tmp1107_;
									gchar* _tmp1108_;
									gchar* _tmp1109_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1106_ = _tmp1105_;
									_tmp1107_ = prop;
									_tmp1108_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1107_);
									_tmp1109_ = _tmp1108_;
									vala_report_error (_tmp1106_, "Property `%s' is read-only", _tmp1109_);
									_g_free0 (_tmp1109_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1110_ = prop;
								_tmp1111_ = vala_symbol_get_access ((ValaSymbol*) _tmp1110_);
								_tmp1112_ = _tmp1111_;
								if (_tmp1112_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1113_;
									ValaPropertyAccessor* _tmp1114_;
									ValaPropertyAccessor* _tmp1115_;
									ValaSymbolAccessibility _tmp1116_;
									ValaSymbolAccessibility _tmp1117_;
									_tmp1113_ = prop;
									_tmp1114_ = vala_property_get_set_accessor (_tmp1113_);
									_tmp1115_ = _tmp1114_;
									_tmp1116_ = vala_symbol_get_access ((ValaSymbol*) _tmp1115_);
									_tmp1117_ = _tmp1116_;
									access = _tmp1117_;
								} else {
									gboolean _tmp1118_ = FALSE;
									ValaProperty* _tmp1119_;
									ValaSymbolAccessibility _tmp1120_;
									ValaSymbolAccessibility _tmp1121_;
									_tmp1119_ = prop;
									_tmp1120_ = vala_symbol_get_access ((ValaSymbol*) _tmp1119_);
									_tmp1121_ = _tmp1120_;
									if (_tmp1121_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1122_;
										ValaPropertyAccessor* _tmp1123_;
										ValaPropertyAccessor* _tmp1124_;
										ValaSymbolAccessibility _tmp1125_;
										ValaSymbolAccessibility _tmp1126_;
										_tmp1122_ = prop;
										_tmp1123_ = vala_property_get_set_accessor (_tmp1122_);
										_tmp1124_ = _tmp1123_;
										_tmp1125_ = vala_symbol_get_access ((ValaSymbol*) _tmp1124_);
										_tmp1126_ = _tmp1125_;
										_tmp1118_ = _tmp1126_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1118_ = FALSE;
									}
									if (_tmp1118_) {
										ValaProperty* _tmp1127_;
										ValaPropertyAccessor* _tmp1128_;
										ValaPropertyAccessor* _tmp1129_;
										ValaSymbolAccessibility _tmp1130_;
										ValaSymbolAccessibility _tmp1131_;
										_tmp1127_ = prop;
										_tmp1128_ = vala_property_get_set_accessor (_tmp1127_);
										_tmp1129_ = _tmp1128_;
										_tmp1130_ = vala_symbol_get_access ((ValaSymbol*) _tmp1129_);
										_tmp1131_ = _tmp1130_;
										access = _tmp1131_;
									}
								}
							} else {
								ValaProperty* _tmp1132_;
								ValaPropertyAccessor* _tmp1133_;
								ValaPropertyAccessor* _tmp1134_;
								ValaProperty* _tmp1140_;
								ValaSymbolAccessibility _tmp1141_;
								ValaSymbolAccessibility _tmp1142_;
								_tmp1132_ = prop;
								_tmp1133_ = vala_property_get_get_accessor (_tmp1132_);
								_tmp1134_ = _tmp1133_;
								if (_tmp1134_ == NULL) {
									ValaSourceReference* _tmp1135_;
									ValaSourceReference* _tmp1136_;
									ValaProperty* _tmp1137_;
									gchar* _tmp1138_;
									gchar* _tmp1139_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1136_ = _tmp1135_;
									_tmp1137_ = prop;
									_tmp1138_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1137_);
									_tmp1139_ = _tmp1138_;
									vala_report_error (_tmp1136_, "Property `%s' is write-only", _tmp1139_);
									_g_free0 (_tmp1139_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1140_ = prop;
								_tmp1141_ = vala_symbol_get_access ((ValaSymbol*) _tmp1140_);
								_tmp1142_ = _tmp1141_;
								if (_tmp1142_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1143_;
									ValaPropertyAccessor* _tmp1144_;
									ValaPropertyAccessor* _tmp1145_;
									ValaSymbolAccessibility _tmp1146_;
									ValaSymbolAccessibility _tmp1147_;
									_tmp1143_ = prop;
									_tmp1144_ = vala_property_get_get_accessor (_tmp1143_);
									_tmp1145_ = _tmp1144_;
									_tmp1146_ = vala_symbol_get_access ((ValaSymbol*) _tmp1145_);
									_tmp1147_ = _tmp1146_;
									access = _tmp1147_;
								} else {
									gboolean _tmp1148_ = FALSE;
									ValaProperty* _tmp1149_;
									ValaSymbolAccessibility _tmp1150_;
									ValaSymbolAccessibility _tmp1151_;
									_tmp1149_ = prop;
									_tmp1150_ = vala_symbol_get_access ((ValaSymbol*) _tmp1149_);
									_tmp1151_ = _tmp1150_;
									if (_tmp1151_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1152_;
										ValaPropertyAccessor* _tmp1153_;
										ValaPropertyAccessor* _tmp1154_;
										ValaSymbolAccessibility _tmp1155_;
										ValaSymbolAccessibility _tmp1156_;
										_tmp1152_ = prop;
										_tmp1153_ = vala_property_get_get_accessor (_tmp1152_);
										_tmp1154_ = _tmp1153_;
										_tmp1155_ = vala_symbol_get_access ((ValaSymbol*) _tmp1154_);
										_tmp1156_ = _tmp1155_;
										_tmp1148_ = _tmp1156_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1148_ = FALSE;
									}
									if (_tmp1148_) {
										ValaProperty* _tmp1157_;
										ValaPropertyAccessor* _tmp1158_;
										ValaPropertyAccessor* _tmp1159_;
										ValaSymbolAccessibility _tmp1160_;
										ValaSymbolAccessibility _tmp1161_;
										_tmp1157_ = prop;
										_tmp1158_ = vala_property_get_get_accessor (_tmp1157_);
										_tmp1159_ = _tmp1158_;
										_tmp1160_ = vala_symbol_get_access ((ValaSymbol*) _tmp1159_);
										_tmp1161_ = _tmp1160_;
										access = _tmp1161_;
									}
								}
							}
							_tmp1162_ = prop;
							_tmp1163_ = vala_property_get_binding (_tmp1162_);
							_tmp1164_ = _tmp1163_;
							instance = _tmp1164_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1165_ = prop;
							_tmp1166_ = vala_property_get_property_type (_tmp1165_);
							_tmp1167_ = _tmp1166_;
							if (VALA_IS_GENERIC_TYPE (_tmp1167_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1168_;
							_tmp1168_ = member;
							if (VALA_IS_SIGNAL (_tmp1168_)) {
								ValaSymbol* _tmp1169_;
								ValaSymbolAccessibility _tmp1170_;
								ValaSymbolAccessibility _tmp1171_;
								instance = TRUE;
								_tmp1169_ = member;
								_tmp1170_ = vala_symbol_get_access (_tmp1169_);
								_tmp1171_ = _tmp1170_;
								access = _tmp1171_;
							} else {
								gboolean _tmp1172_ = FALSE;
								gboolean _tmp1173_;
								_tmp1173_ = self->priv->_creation_member;
								if (!_tmp1173_) {
									ValaSymbol* _tmp1174_;
									_tmp1174_ = member;
									_tmp1172_ = VALA_IS_ERROR_CODE (_tmp1174_);
								} else {
									_tmp1172_ = FALSE;
								}
								if (_tmp1172_) {
									ValaSymbol* _tmp1175_;
									ValaConstant* _tmp1176_;
									ValaConstant* _tmp1177_;
									ValaSymbol* _tmp1178_;
									ValaSymbol* _tmp1179_;
									_tmp1175_ = member;
									_tmp1176_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1175_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1177_ = _tmp1176_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1177_);
									_tmp1178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1179_ = _tmp1178_;
									member = _tmp1179_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1180_;
		ValaSymbol* _tmp1181_;
		ValaCodeNode* _tmp1182_;
		ValaCodeNode* _tmp1183_;
		ValaCodeNode* _tmp1184_;
		gboolean _tmp1185_ = FALSE;
		ValaCodeNode* _tmp1186_;
		_tmp1180_ = parent;
		_tmp1181_ = member;
		if (!(_tmp1180_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1181_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1182_ = parent;
		_tmp1183_ = vala_code_node_get_parent_node (_tmp1182_);
		_tmp1184_ = _tmp1183_;
		parent = _tmp1184_;
		_tmp1186_ = parent;
		if (_tmp1186_ == NULL) {
			_tmp1185_ = TRUE;
		} else {
			ValaCodeNode* _tmp1187_;
			ValaSymbol* _tmp1188_;
			_tmp1187_ = parent;
			_tmp1188_ = member;
			_tmp1185_ = _tmp1187_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1188_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1185_) {
			break;
		}
	}
	_tmp1189_ = parent;
	_tmp1190_ = member;
	if (_tmp1189_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1190_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1191_;
		_tmp1191_ = member;
		vala_symbol_set_used (_tmp1191_, TRUE);
	}
	_tmp1192_ = member;
	_tmp1193_ = vala_symbol_get_version (_tmp1192_);
	_tmp1194_ = _tmp1193_;
	_tmp1195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1196_ = _tmp1195_;
	vala_version_attribute_check (_tmp1194_, context, _tmp1196_);
	_tmp1198_ = access;
	if (_tmp1198_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1199_;
		ValaSymbol* _tmp1200_;
		ValaSymbol* _tmp1201_;
		_tmp1199_ = member;
		_tmp1200_ = vala_symbol_get_parent_symbol (_tmp1199_);
		_tmp1201_ = _tmp1200_;
		_tmp1197_ = VALA_IS_TYPESYMBOL (_tmp1201_);
	} else {
		_tmp1197_ = FALSE;
	}
	if (_tmp1197_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1202_;
		ValaSymbol* _tmp1203_;
		ValaSymbol* _tmp1204_;
		gboolean in_subtype = FALSE;
		_tmp1202_ = member;
		_tmp1203_ = vala_symbol_get_parent_symbol (_tmp1202_);
		_tmp1204_ = _tmp1203_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1204_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1205_;
			ValaSemanticAnalyzer* _tmp1206_;
			ValaSymbol* _tmp1207_;
			ValaSymbol* _tmp1208_;
			ValaSymbol* _tmp1209_;
			_tmp1205_ = vala_code_context_get_analyzer (context);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = vala_semantic_analyzer_get_current_symbol (_tmp1206_);
			_tmp1208_ = _tmp1207_;
			_tmp1209_ = _vala_code_node_ref0 (_tmp1208_);
			this_symbol = _tmp1209_;
			{
				gboolean _tmp1210_ = FALSE;
				_tmp1210_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1215_;
					ValaSymbol* _tmp1216_;
					ValaTypeSymbol* _tmp1217_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1218_;
					gboolean _tmp1219_ = FALSE;
					ValaClass* _tmp1220_;
					if (!_tmp1210_) {
						ValaSymbol* _tmp1211_;
						ValaSymbol* _tmp1212_;
						ValaSymbol* _tmp1213_;
						ValaSymbol* _tmp1214_;
						_tmp1211_ = this_symbol;
						_tmp1212_ = vala_symbol_get_parent_symbol (_tmp1211_);
						_tmp1213_ = _tmp1212_;
						_tmp1214_ = _vala_code_node_ref0 (_tmp1213_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1214_;
					}
					_tmp1210_ = FALSE;
					_tmp1215_ = this_symbol;
					if (!(_tmp1215_ != NULL)) {
						break;
					}
					_tmp1216_ = this_symbol;
					_tmp1217_ = target_type;
					if (_tmp1216_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1217_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1218_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1218_) ? ((ValaClass*) _tmp1218_) : NULL;
					_tmp1220_ = cl;
					if (_tmp1220_ != NULL) {
						ValaClass* _tmp1221_;
						ValaTypeSymbol* _tmp1222_;
						_tmp1221_ = cl;
						_tmp1222_ = target_type;
						_tmp1219_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1221_, _tmp1222_);
					} else {
						_tmp1219_ = FALSE;
					}
					if (_tmp1219_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1223_;
			ValaSourceReference* _tmp1224_;
			ValaSymbol* _tmp1225_;
			gchar* _tmp1226_;
			gchar* _tmp1227_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1224_ = _tmp1223_;
			_tmp1225_ = member;
			_tmp1226_ = vala_symbol_get_full_name (_tmp1225_);
			_tmp1227_ = _tmp1226_;
			vala_report_error (_tmp1224_, "Access to protected member `%s' denied", _tmp1227_);
			_g_free0 (_tmp1227_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1228_;
		_tmp1228_ = access;
		if (_tmp1228_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1229_;
			ValaSymbol* _tmp1230_;
			ValaSymbol* _tmp1231_;
			gboolean in_target_type = FALSE;
			_tmp1229_ = member;
			_tmp1230_ = vala_symbol_get_parent_symbol (_tmp1229_);
			_tmp1231_ = _tmp1230_;
			target_type = _tmp1231_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1232_;
				ValaSemanticAnalyzer* _tmp1233_;
				ValaSymbol* _tmp1234_;
				ValaSymbol* _tmp1235_;
				ValaSymbol* _tmp1236_;
				_tmp1232_ = vala_code_context_get_analyzer (context);
				_tmp1233_ = _tmp1232_;
				_tmp1234_ = vala_semantic_analyzer_get_current_symbol (_tmp1233_);
				_tmp1235_ = _tmp1234_;
				_tmp1236_ = _vala_code_node_ref0 (_tmp1235_);
				this_symbol = _tmp1236_;
				{
					gboolean _tmp1237_ = FALSE;
					_tmp1237_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1242_;
						ValaSymbol* _tmp1243_;
						ValaSymbol* _tmp1244_;
						if (!_tmp1237_) {
							ValaSymbol* _tmp1238_;
							ValaSymbol* _tmp1239_;
							ValaSymbol* _tmp1240_;
							ValaSymbol* _tmp1241_;
							_tmp1238_ = this_symbol;
							_tmp1239_ = vala_symbol_get_parent_symbol (_tmp1238_);
							_tmp1240_ = _tmp1239_;
							_tmp1241_ = _vala_code_node_ref0 (_tmp1240_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1241_;
						}
						_tmp1237_ = FALSE;
						_tmp1242_ = this_symbol;
						if (!(_tmp1242_ != NULL)) {
							break;
						}
						_tmp1243_ = target_type;
						_tmp1244_ = this_symbol;
						if (_tmp1243_ == _tmp1244_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1245_;
				ValaSourceReference* _tmp1246_;
				ValaSymbol* _tmp1247_;
				gchar* _tmp1248_;
				gchar* _tmp1249_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1246_ = _tmp1245_;
				_tmp1247_ = member;
				_tmp1248_ = vala_symbol_get_full_name (_tmp1247_);
				_tmp1249_ = _tmp1248_;
				vala_report_error (_tmp1246_, "Access to private member `%s' denied", _tmp1249_);
				_g_free0 (_tmp1249_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1251_;
		ValaExpression* _tmp1252_;
		_tmp1251_ = vala_member_access_get_inner (self);
		_tmp1252_ = _tmp1251_;
		_tmp1250_ = _tmp1252_ != NULL;
	} else {
		_tmp1250_ = FALSE;
	}
	if (_tmp1250_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1253_;
		ValaExpression* _tmp1254_;
		ValaDataType* _tmp1255_;
		ValaDataType* _tmp1256_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1257_;
		ValaExpression* _tmp1258_;
		ValaDataType* _tmp1259_;
		ValaDataType* _tmp1260_;
		ValaPointerType* _tmp1261_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1265_;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1267_ = FALSE;
		ValaObjectType* _tmp1268_;
		_tmp1253_ = vala_member_access_get_inner (self);
		_tmp1254_ = _tmp1253_;
		_tmp1255_ = vala_expression_get_value_type (_tmp1254_);
		_tmp1256_ = _tmp1255_;
		instance_type = _tmp1256_;
		_tmp1257_ = vala_member_access_get_inner (self);
		_tmp1258_ = _tmp1257_;
		_tmp1259_ = vala_expression_get_value_type (_tmp1258_);
		_tmp1260_ = _tmp1259_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1260_) ? ((ValaPointerType*) _tmp1260_) : NULL;
		_tmp1261_ = pointer_type;
		if (_tmp1261_ != NULL) {
			ValaPointerType* _tmp1262_;
			ValaDataType* _tmp1263_;
			ValaDataType* _tmp1264_;
			_tmp1262_ = pointer_type;
			_tmp1263_ = vala_pointer_type_get_base_type (_tmp1262_);
			_tmp1264_ = _tmp1263_;
			instance_type = _tmp1264_;
		}
		_tmp1265_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1265_) ? ((ValaObjectType*) _tmp1265_) : NULL;
		_tmp1268_ = object_type;
		if (_tmp1268_ != NULL) {
			ValaObjectType* _tmp1269_;
			ValaObjectTypeSymbol* _tmp1270_;
			ValaObjectTypeSymbol* _tmp1271_;
			_tmp1269_ = object_type;
			_tmp1270_ = vala_object_type_get_object_type_symbol (_tmp1269_);
			_tmp1271_ = _tmp1270_;
			_tmp1267_ = vala_object_type_symbol_has_type_parameters (_tmp1271_);
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaDataType* _tmp1272_;
			_tmp1272_ = instance_type;
			_tmp1266_ = !vala_data_type_has_type_arguments (_tmp1272_);
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			ValaExpression* _tmp1273_;
			ValaExpression* _tmp1274_;
			ValaSourceReference* _tmp1275_;
			ValaSourceReference* _tmp1276_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1273_ = vala_member_access_get_inner (self);
			_tmp1274_ = _tmp1273_;
			_tmp1275_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1274_);
			_tmp1276_ = _tmp1275_;
			vala_report_error (_tmp1276_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1278_ = !may_access_instance_members;
	} else {
		_tmp1278_ = FALSE;
	}
	if (_tmp1278_) {
		_tmp1277_ = TRUE;
	} else {
		gboolean _tmp1279_ = FALSE;
		if (klass) {
			_tmp1279_ = !may_access_klass_members;
		} else {
			_tmp1279_ = FALSE;
		}
		_tmp1277_ = _tmp1279_;
	}
	if (_tmp1277_) {
		ValaSymbol* _tmp1280_;
		ValaSymbol* _tmp1281_;
		ValaDataType* _tmp1304_;
		ValaDataType* _tmp1305_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1280_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1281_ = _tmp1280_;
		if (VALA_IS_METHOD (_tmp1281_)) {
			ValaSemanticAnalyzer* _tmp1282_;
			ValaSemanticAnalyzer* _tmp1283_;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			gboolean _tmp1286_;
			gboolean _tmp1287_;
			ValaDataType* _tmp1288_;
			ValaDataType* _tmp1289_;
			_tmp1282_ = vala_code_context_get_analyzer (context);
			_tmp1283_ = _tmp1282_;
			_tmp1284_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1285_ = _tmp1284_;
			_tmp1286_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1287_ = _tmp1286_;
			_tmp1288_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1283_, _tmp1285_, _tmp1287_);
			_tmp1289_ = _tmp1288_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1289_);
			_vala_code_node_unref0 (_tmp1289_);
		} else {
			ValaSymbol* _tmp1290_;
			ValaSymbol* _tmp1291_;
			_tmp1290_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1291_ = _tmp1290_;
			if (VALA_IS_FIELD (_tmp1291_)) {
				ValaSymbol* _tmp1292_;
				ValaSymbol* _tmp1293_;
				ValaFieldPrototype* _tmp1294_;
				ValaFieldPrototype* _tmp1295_;
				_tmp1292_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1293_ = _tmp1292_;
				_tmp1294_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1293_, VALA_TYPE_FIELD, ValaField));
				_tmp1295_ = _tmp1294_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1295_);
				_vala_code_node_unref0 (_tmp1295_);
			} else {
				ValaSymbol* _tmp1296_;
				ValaSymbol* _tmp1297_;
				_tmp1296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1297_ = _tmp1296_;
				if (VALA_IS_PROPERTY (_tmp1297_)) {
					ValaSymbol* _tmp1298_;
					ValaSymbol* _tmp1299_;
					ValaPropertyPrototype* _tmp1300_;
					ValaPropertyPrototype* _tmp1301_;
					_tmp1298_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1299_ = _tmp1298_;
					_tmp1300_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1299_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1301_ = _tmp1300_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1301_);
					_vala_code_node_unref0 (_tmp1301_);
				} else {
					ValaInvalidType* _tmp1302_;
					ValaInvalidType* _tmp1303_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1302_ = vala_invalid_type_new ();
					_tmp1303_ = _tmp1302_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1303_);
					_vala_code_node_unref0 (_tmp1303_);
				}
			}
		}
		_tmp1304_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1305_ = _tmp1304_;
		if (_tmp1305_ != NULL) {
			ValaDataType* _tmp1306_;
			ValaDataType* _tmp1307_;
			ValaDataType* _tmp1308_;
			ValaDataType* _tmp1309_;
			gboolean _tmp1310_;
			gboolean _tmp1311_;
			_tmp1306_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1307_ = _tmp1306_;
			_tmp1308_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1309_ = _tmp1308_;
			_tmp1310_ = vala_data_type_get_value_owned (_tmp1309_);
			_tmp1311_ = _tmp1310_;
			vala_data_type_set_value_owned (_tmp1307_, _tmp1311_);
		}
	} else {
		gboolean _tmp1312_ = FALSE;
		gboolean _tmp1333_ = FALSE;
		gboolean _tmp1334_ = FALSE;
		gboolean _tmp1335_ = FALSE;
		gboolean _tmp1336_ = FALSE;
		gboolean _tmp1376_ = FALSE;
		gboolean _tmp1377_ = FALSE;
		gboolean _tmp1378_ = FALSE;
		gboolean _tmp1379_ = FALSE;
		gboolean _tmp1380_ = FALSE;
		gboolean _tmp1381_;
		gboolean _tmp1382_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1407_;
		ValaSymbol* _tmp1408_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1409_;
		ValaExpression* _tmp1410_;
		gboolean _tmp1411_ = FALSE;
		gboolean _tmp1412_ = FALSE;
		gboolean _tmp1413_ = FALSE;
		gboolean _tmp1414_ = FALSE;
		gboolean _tmp1415_ = FALSE;
		ValaMethod* _tmp1416_;
		ValaSemanticAnalyzer* _tmp1454_;
		ValaSemanticAnalyzer* _tmp1455_;
		ValaSymbol* _tmp1456_;
		ValaSymbol* _tmp1457_;
		gboolean _tmp1458_;
		gboolean _tmp1459_;
		ValaDataType* _tmp1460_;
		ValaDataType* _tmp1461_;
		gboolean _tmp1462_ = FALSE;
		ValaExpression* _tmp1463_;
		ValaExpression* _tmp1464_;
		ValaSymbol* _tmp1477_;
		ValaSymbol* _tmp1478_;
		gboolean _tmp1552_ = FALSE;
		gboolean _tmp1553_ = FALSE;
		ValaExpression* _tmp1554_;
		ValaExpression* _tmp1555_;
		if (instance) {
			ValaExpression* _tmp1313_;
			ValaExpression* _tmp1314_;
			_tmp1313_ = vala_member_access_get_inner (self);
			_tmp1314_ = _tmp1313_;
			_tmp1312_ = _tmp1314_ == NULL;
		} else {
			_tmp1312_ = FALSE;
		}
		if (_tmp1312_) {
			ValaSourceReference* _tmp1315_;
			ValaSourceReference* _tmp1316_;
			ValaMemberAccess* _tmp1317_;
			ValaMemberAccess* _tmp1318_;
			ValaExpression* _tmp1319_;
			ValaExpression* _tmp1320_;
			ValaParameter* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaExpression* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaExpression* _tmp1330_;
			ValaExpression* _tmp1331_;
			ValaParameter* _tmp1332_;
			_tmp1315_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1316_ = _tmp1315_;
			_tmp1317_ = vala_member_access_new (NULL, "this", _tmp1316_);
			_tmp1318_ = _tmp1317_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1318_);
			_vala_code_node_unref0 (_tmp1318_);
			_tmp1319_ = vala_member_access_get_inner (self);
			_tmp1320_ = _tmp1319_;
			_tmp1321_ = this_parameter;
			_tmp1322_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1321_);
			_tmp1323_ = _tmp1322_;
			_tmp1324_ = vala_data_type_copy (_tmp1323_);
			_tmp1325_ = _tmp1324_;
			vala_expression_set_value_type (_tmp1320_, _tmp1325_);
			_vala_code_node_unref0 (_tmp1325_);
			_tmp1326_ = vala_member_access_get_inner (self);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = vala_expression_get_value_type (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			vala_data_type_set_value_owned (_tmp1329_, FALSE);
			_tmp1330_ = vala_member_access_get_inner (self);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1331_, (ValaSymbol*) _tmp1332_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1336_ = !klass;
		} else {
			_tmp1336_ = FALSE;
		}
		if (_tmp1336_) {
			ValaSymbol* _tmp1337_;
			ValaSymbol* _tmp1338_;
			_tmp1337_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1338_ = _tmp1337_;
			_tmp1335_ = !VALA_IS_CREATION_METHOD (_tmp1338_);
		} else {
			_tmp1335_ = FALSE;
		}
		if (_tmp1335_) {
			_tmp1334_ = may_access_instance_members;
		} else {
			_tmp1334_ = FALSE;
		}
		if (_tmp1334_) {
			ValaExpression* _tmp1339_;
			ValaExpression* _tmp1340_;
			_tmp1339_ = vala_member_access_get_inner (self);
			_tmp1340_ = _tmp1339_;
			_tmp1333_ = _tmp1340_ != NULL;
		} else {
			_tmp1333_ = FALSE;
		}
		if (_tmp1333_) {
			ValaExpression* _tmp1341_;
			ValaExpression* _tmp1342_;
			ValaSymbol* _tmp1343_;
			ValaSymbol* _tmp1344_;
			_tmp1341_ = vala_member_access_get_inner (self);
			_tmp1342_ = _tmp1341_;
			_tmp1343_ = vala_expression_get_symbol_reference (_tmp1342_);
			_tmp1344_ = _tmp1343_;
			if (VALA_IS_METHOD (_tmp1344_)) {
			} else {
				ValaSourceReference* _tmp1345_;
				ValaSourceReference* _tmp1346_;
				ValaSymbol* _tmp1347_;
				ValaSymbol* _tmp1348_;
				gchar* _tmp1349_;
				gchar* _tmp1350_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1351_;
				ValaSymbol* _tmp1352_;
				ValaSymbol* _tmp1353_;
				ValaSymbol* _tmp1354_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1374_;
				ValaExpression* _tmp1375_;
				_tmp1345_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1346_ = _tmp1345_;
				_tmp1347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1348_ = _tmp1347_;
				_tmp1349_ = vala_symbol_get_full_name (_tmp1348_);
				_tmp1350_ = _tmp1349_;
				vala_report_warning (_tmp1346_, "Access to static member `%s' with an instance reference", _tmp1350_);
				_g_free0 (_tmp1350_);
				_tmp1351_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1352_ = _tmp1351_;
				_tmp1353_ = vala_symbol_get_parent_symbol (_tmp1352_);
				_tmp1354_ = _tmp1353_;
				inner_sym = _tmp1354_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1355_ = FALSE;
					ValaSymbol* _tmp1356_;
					ValaMemberAccess* _tmp1360_;
					ValaSymbol* _tmp1361_;
					const gchar* _tmp1362_;
					const gchar* _tmp1363_;
					ValaSourceReference* _tmp1364_;
					ValaSourceReference* _tmp1365_;
					ValaMemberAccess* _tmp1366_;
					ValaMemberAccess* _tmp1367_;
					ValaMemberAccess* _tmp1368_;
					ValaExpression* _tmp1369_;
					ValaExpression* _tmp1370_;
					ValaSymbol* _tmp1371_;
					ValaSymbol* _tmp1372_;
					ValaSymbol* _tmp1373_;
					_tmp1356_ = inner_sym;
					if (_tmp1356_ != NULL) {
						ValaSymbol* _tmp1357_;
						const gchar* _tmp1358_;
						const gchar* _tmp1359_;
						_tmp1357_ = inner_sym;
						_tmp1358_ = vala_symbol_get_name (_tmp1357_);
						_tmp1359_ = _tmp1358_;
						_tmp1355_ = _tmp1359_ != NULL;
					} else {
						_tmp1355_ = FALSE;
					}
					if (!_tmp1355_) {
						break;
					}
					_tmp1360_ = inner_ma;
					_tmp1361_ = inner_sym;
					_tmp1362_ = vala_symbol_get_name (_tmp1361_);
					_tmp1363_ = _tmp1362_;
					_tmp1364_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1365_ = _tmp1364_;
					_tmp1366_ = vala_member_access_new (NULL, _tmp1363_, _tmp1365_);
					_tmp1367_ = _tmp1366_;
					vala_member_access_set_inner (_tmp1360_, (ValaExpression*) _tmp1367_);
					_vala_code_node_unref0 (_tmp1367_);
					_tmp1368_ = inner_ma;
					_tmp1369_ = vala_member_access_get_inner (_tmp1368_);
					_tmp1370_ = _tmp1369_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1370_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1371_ = inner_sym;
					_tmp1372_ = vala_symbol_get_parent_symbol (_tmp1371_);
					_tmp1373_ = _tmp1372_;
					inner_sym = _tmp1373_;
				}
				_tmp1374_ = vala_member_access_get_inner (self);
				_tmp1375_ = _tmp1374_;
				vala_code_node_check ((ValaCodeNode*) _tmp1375_, context);
			}
		}
		_tmp1381_ = vala_code_context_get_experimental_non_null (context);
		_tmp1382_ = _tmp1381_;
		if (_tmp1382_) {
			_tmp1380_ = instance;
		} else {
			_tmp1380_ = FALSE;
		}
		if (_tmp1380_) {
			ValaExpression* _tmp1383_;
			ValaExpression* _tmp1384_;
			ValaDataType* _tmp1385_;
			ValaDataType* _tmp1386_;
			gboolean _tmp1387_;
			gboolean _tmp1388_;
			_tmp1383_ = vala_member_access_get_inner (self);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = vala_expression_get_value_type (_tmp1384_);
			_tmp1386_ = _tmp1385_;
			_tmp1387_ = vala_data_type_get_nullable (_tmp1386_);
			_tmp1388_ = _tmp1387_;
			_tmp1379_ = _tmp1388_;
		} else {
			_tmp1379_ = FALSE;
		}
		if (_tmp1379_) {
			ValaExpression* _tmp1389_;
			ValaExpression* _tmp1390_;
			ValaDataType* _tmp1391_;
			ValaDataType* _tmp1392_;
			_tmp1389_ = vala_member_access_get_inner (self);
			_tmp1390_ = _tmp1389_;
			_tmp1391_ = vala_expression_get_value_type (_tmp1390_);
			_tmp1392_ = _tmp1391_;
			_tmp1378_ = !VALA_IS_POINTER_TYPE (_tmp1392_);
		} else {
			_tmp1378_ = FALSE;
		}
		if (_tmp1378_) {
			ValaExpression* _tmp1393_;
			ValaExpression* _tmp1394_;
			ValaDataType* _tmp1395_;
			ValaDataType* _tmp1396_;
			_tmp1393_ = vala_member_access_get_inner (self);
			_tmp1394_ = _tmp1393_;
			_tmp1395_ = vala_expression_get_value_type (_tmp1394_);
			_tmp1396_ = _tmp1395_;
			_tmp1377_ = !VALA_IS_GENERIC_TYPE (_tmp1396_);
		} else {
			_tmp1377_ = FALSE;
		}
		if (_tmp1377_) {
			ValaExpression* _tmp1397_;
			ValaExpression* _tmp1398_;
			ValaDataType* _tmp1399_;
			ValaDataType* _tmp1400_;
			_tmp1397_ = vala_member_access_get_inner (self);
			_tmp1398_ = _tmp1397_;
			_tmp1399_ = vala_expression_get_value_type (_tmp1398_);
			_tmp1400_ = _tmp1399_;
			_tmp1376_ = !VALA_IS_ARRAY_TYPE (_tmp1400_);
		} else {
			_tmp1376_ = FALSE;
		}
		if (_tmp1376_) {
			ValaSourceReference* _tmp1401_;
			ValaSourceReference* _tmp1402_;
			ValaSymbol* _tmp1403_;
			ValaSymbol* _tmp1404_;
			gchar* _tmp1405_;
			gchar* _tmp1406_;
			_tmp1401_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1402_ = _tmp1401_;
			_tmp1403_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1404_ = _tmp1403_;
			_tmp1405_ = vala_symbol_get_full_name (_tmp1404_);
			_tmp1406_ = _tmp1405_;
			vala_report_error (_tmp1402_, "Access to instance member `%s' from nullable reference denied", _tmp1406_);
			_g_free0 (_tmp1406_);
		}
		_tmp1407_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1408_ = _tmp1407_;
		m = VALA_IS_METHOD (_tmp1408_) ? ((ValaMethod*) _tmp1408_) : NULL;
		_tmp1409_ = vala_member_access_get_inner (self);
		_tmp1410_ = _tmp1409_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1410_) ? ((ValaMemberAccess*) _tmp1410_) : NULL;
		_tmp1416_ = m;
		if (_tmp1416_ != NULL) {
			ValaMethod* _tmp1417_;
			ValaMemberBinding _tmp1418_;
			ValaMemberBinding _tmp1419_;
			_tmp1417_ = m;
			_tmp1418_ = vala_method_get_binding (_tmp1417_);
			_tmp1419_ = _tmp1418_;
			_tmp1415_ = _tmp1419_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1415_ = FALSE;
		}
		if (_tmp1415_) {
			ValaMethod* _tmp1420_;
			ValaSymbol* _tmp1421_;
			ValaSymbol* _tmp1422_;
			_tmp1420_ = m;
			_tmp1421_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1420_);
			_tmp1422_ = _tmp1421_;
			_tmp1414_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1422_);
		} else {
			_tmp1414_ = FALSE;
		}
		if (_tmp1414_) {
			ValaExpression* _tmp1423_;
			ValaExpression* _tmp1424_;
			_tmp1423_ = vala_member_access_get_inner (self);
			_tmp1424_ = _tmp1423_;
			_tmp1413_ = _tmp1424_ != NULL;
		} else {
			_tmp1413_ = FALSE;
		}
		if (_tmp1413_) {
			ValaExpression* _tmp1425_;
			ValaExpression* _tmp1426_;
			ValaDataType* _tmp1427_;
			ValaDataType* _tmp1428_;
			_tmp1425_ = vala_member_access_get_inner (self);
			_tmp1426_ = _tmp1425_;
			_tmp1427_ = vala_expression_get_value_type (_tmp1426_);
			_tmp1428_ = _tmp1427_;
			_tmp1412_ = _tmp1428_ == NULL;
		} else {
			_tmp1412_ = FALSE;
		}
		if (_tmp1412_) {
			ValaMemberAccess* _tmp1429_;
			ValaList* _tmp1430_;
			gint _tmp1431_;
			gint _tmp1432_;
			_tmp1429_ = inner_ma;
			_tmp1430_ = _tmp1429_->priv->type_argument_list;
			_tmp1431_ = vala_collection_get_size ((ValaCollection*) _tmp1430_);
			_tmp1432_ = _tmp1431_;
			_tmp1411_ = _tmp1432_ > 0;
		} else {
			_tmp1411_ = FALSE;
		}
		if (_tmp1411_) {
			ValaExpression* _tmp1433_;
			ValaExpression* _tmp1434_;
			ValaMethod* _tmp1435_;
			ValaSymbol* _tmp1436_;
			ValaSymbol* _tmp1437_;
			ValaObjectType* _tmp1438_;
			ValaObjectType* _tmp1439_;
			_tmp1433_ = vala_member_access_get_inner (self);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = m;
			_tmp1436_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1435_);
			_tmp1437_ = _tmp1436_;
			_tmp1438_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1437_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1439_ = _tmp1438_;
			vala_expression_set_value_type (_tmp1434_, (ValaDataType*) _tmp1439_);
			_vala_code_node_unref0 (_tmp1439_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1440_;
				ValaList* _tmp1441_;
				gint _type_argument_size = 0;
				ValaList* _tmp1442_;
				gint _tmp1443_;
				gint _tmp1444_;
				gint _type_argument_index = 0;
				_tmp1440_ = inner_ma;
				_tmp1441_ = _tmp1440_->priv->type_argument_list;
				_type_argument_list = _tmp1441_;
				_tmp1442_ = _type_argument_list;
				_tmp1443_ = vala_collection_get_size ((ValaCollection*) _tmp1442_);
				_tmp1444_ = _tmp1443_;
				_type_argument_size = _tmp1444_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1445_;
					gint _tmp1446_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1447_;
					gpointer _tmp1448_;
					ValaExpression* _tmp1449_;
					ValaExpression* _tmp1450_;
					ValaDataType* _tmp1451_;
					ValaDataType* _tmp1452_;
					ValaDataType* _tmp1453_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1445_ = _type_argument_index;
					_tmp1446_ = _type_argument_size;
					if (!(_tmp1445_ < _tmp1446_)) {
						break;
					}
					_tmp1447_ = _type_argument_list;
					_tmp1448_ = vala_list_get (_tmp1447_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1448_;
					_tmp1449_ = vala_member_access_get_inner (self);
					_tmp1450_ = _tmp1449_;
					_tmp1451_ = vala_expression_get_value_type (_tmp1450_);
					_tmp1452_ = _tmp1451_;
					_tmp1453_ = type_argument;
					vala_data_type_add_type_argument (_tmp1452_, _tmp1453_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1454_ = vala_code_context_get_analyzer (context);
		_tmp1455_ = _tmp1454_;
		_tmp1456_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1457_ = _tmp1456_;
		_tmp1458_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1459_ = _tmp1458_;
		_tmp1460_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1455_, _tmp1457_, _tmp1459_);
		_tmp1461_ = _tmp1460_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1461_);
		_vala_code_node_unref0 (_tmp1461_);
		_tmp1463_ = vala_member_access_get_inner (self);
		_tmp1464_ = _tmp1463_;
		if (_tmp1464_ != NULL) {
			ValaDataType* _tmp1465_;
			ValaDataType* _tmp1466_;
			_tmp1465_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1466_ = _tmp1465_;
			_tmp1462_ = _tmp1466_ != NULL;
		} else {
			_tmp1462_ = FALSE;
		}
		if (_tmp1462_) {
			ValaDataType* _tmp1467_;
			ValaDataType* _tmp1468_;
			ValaExpression* _tmp1469_;
			ValaExpression* _tmp1470_;
			ValaDataType* _tmp1471_;
			ValaDataType* _tmp1472_;
			ValaDataType* _tmp1473_;
			ValaDataType* _tmp1474_;
			_tmp1467_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1468_ = _tmp1467_;
			_tmp1469_ = vala_member_access_get_inner (self);
			_tmp1470_ = _tmp1469_;
			_tmp1471_ = vala_expression_get_value_type (_tmp1470_);
			_tmp1472_ = _tmp1471_;
			_tmp1473_ = vala_data_type_get_actual_type (_tmp1468_, _tmp1472_, NULL, (ValaCodeNode*) self);
			_tmp1474_ = _tmp1473_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1474_);
			_vala_code_node_unref0 (_tmp1474_);
		} else {
			ValaDataType* _tmp1475_;
			ValaDataType* _tmp1476_;
			_tmp1475_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1476_ = _tmp1475_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1476_);
		}
		_tmp1477_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1478_ = _tmp1477_;
		if (VALA_IS_METHOD (_tmp1478_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1479_;
			ValaSymbol* _tmp1480_;
			ValaDataType* _tmp1481_;
			ValaDataType* _tmp1482_;
			gboolean _tmp1489_ = FALSE;
			_tmp1479_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1480_ = _tmp1479_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1480_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1481_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1482_ = _tmp1481_;
			if (_tmp1482_ != NULL) {
				ValaDataType* _tmp1483_;
				ValaDataType* _tmp1484_;
				ValaDataType* _tmp1485_;
				ValaDataType* _tmp1486_;
				gboolean _tmp1487_;
				gboolean _tmp1488_;
				_tmp1483_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1484_ = _tmp1483_;
				_tmp1485_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1486_ = _tmp1485_;
				_tmp1487_ = vala_data_type_get_value_owned (_tmp1486_);
				_tmp1488_ = _tmp1487_;
				vala_data_type_set_value_owned (_tmp1484_, _tmp1488_);
			}
			if (instance) {
				ValaMethod* _tmp1490_;
				ValaSymbol* _tmp1491_;
				ValaSymbol* _tmp1492_;
				_tmp1490_ = method;
				_tmp1491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1490_);
				_tmp1492_ = _tmp1491_;
				_tmp1489_ = VALA_IS_TYPESYMBOL (_tmp1492_);
			} else {
				_tmp1489_ = FALSE;
			}
			if (_tmp1489_) {
				ValaExpression* _tmp1493_;
				ValaExpression* _tmp1494_;
				ValaMethod* _tmp1495_;
				ValaSymbol* _tmp1496_;
				ValaSymbol* _tmp1497_;
				ValaDataType* _tmp1498_;
				ValaDataType* _tmp1499_;
				ValaExpression* _tmp1500_;
				ValaExpression* _tmp1501_;
				ValaDataType* _tmp1502_;
				ValaDataType* _tmp1503_;
				ValaMethod* _tmp1504_;
				ValaParameter* _tmp1505_;
				ValaParameter* _tmp1506_;
				ValaDataType* _tmp1507_;
				ValaDataType* _tmp1508_;
				gboolean _tmp1509_;
				gboolean _tmp1510_;
				_tmp1493_ = vala_member_access_get_inner (self);
				_tmp1494_ = _tmp1493_;
				_tmp1495_ = method;
				_tmp1496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1495_);
				_tmp1497_ = _tmp1496_;
				_tmp1498_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1497_);
				_tmp1499_ = _tmp1498_;
				vala_expression_set_target_type (_tmp1494_, _tmp1499_);
				_vala_code_node_unref0 (_tmp1499_);
				_tmp1500_ = vala_member_access_get_inner (self);
				_tmp1501_ = _tmp1500_;
				_tmp1502_ = vala_expression_get_target_type (_tmp1501_);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = method;
				_tmp1505_ = vala_method_get_this_parameter (_tmp1504_);
				_tmp1506_ = _tmp1505_;
				_tmp1507_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1506_);
				_tmp1508_ = _tmp1507_;
				_tmp1509_ = vala_data_type_get_value_owned (_tmp1508_);
				_tmp1510_ = _tmp1509_;
				vala_data_type_set_value_owned (_tmp1503_, _tmp1510_);
			}
		} else {
			gboolean _tmp1511_ = FALSE;
			gboolean _tmp1512_ = FALSE;
			ValaSymbol* _tmp1513_;
			ValaSymbol* _tmp1514_;
			_tmp1513_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1514_ = _tmp1513_;
			if (VALA_IS_PROPERTY (_tmp1514_)) {
				_tmp1512_ = instance;
			} else {
				_tmp1512_ = FALSE;
			}
			if (_tmp1512_) {
				ValaSymbol* _tmp1515_;
				ValaSymbol* _tmp1516_;
				ValaSymbol* _tmp1517_;
				ValaSymbol* _tmp1518_;
				_tmp1515_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1516_ = _tmp1515_;
				_tmp1517_ = vala_symbol_get_parent_symbol (_tmp1516_);
				_tmp1518_ = _tmp1517_;
				_tmp1511_ = _tmp1518_ != NULL;
			} else {
				_tmp1511_ = FALSE;
			}
			if (_tmp1511_) {
				ValaExpression* _tmp1519_;
				ValaExpression* _tmp1520_;
				ValaSymbol* _tmp1521_;
				ValaSymbol* _tmp1522_;
				ValaSymbol* _tmp1523_;
				ValaSymbol* _tmp1524_;
				ValaDataType* _tmp1525_;
				ValaDataType* _tmp1526_;
				_tmp1519_ = vala_member_access_get_inner (self);
				_tmp1520_ = _tmp1519_;
				_tmp1521_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1522_ = _tmp1521_;
				_tmp1523_ = vala_symbol_get_parent_symbol (_tmp1522_);
				_tmp1524_ = _tmp1523_;
				_tmp1525_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1524_);
				_tmp1526_ = _tmp1525_;
				vala_expression_set_target_type (_tmp1520_, _tmp1526_);
				_vala_code_node_unref0 (_tmp1526_);
			} else {
				gboolean _tmp1527_ = FALSE;
				gboolean _tmp1528_ = FALSE;
				gboolean _tmp1529_ = FALSE;
				ValaSymbol* _tmp1530_;
				ValaSymbol* _tmp1531_;
				_tmp1530_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1531_ = _tmp1530_;
				if (VALA_IS_FIELD (_tmp1531_)) {
					_tmp1529_ = TRUE;
				} else {
					ValaSymbol* _tmp1532_;
					ValaSymbol* _tmp1533_;
					_tmp1532_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1533_ = _tmp1532_;
					_tmp1529_ = VALA_IS_SIGNAL (_tmp1533_);
				}
				if (_tmp1529_) {
					_tmp1528_ = instance;
				} else {
					_tmp1528_ = FALSE;
				}
				if (_tmp1528_) {
					ValaSymbol* _tmp1534_;
					ValaSymbol* _tmp1535_;
					ValaSymbol* _tmp1536_;
					ValaSymbol* _tmp1537_;
					_tmp1534_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1535_ = _tmp1534_;
					_tmp1536_ = vala_symbol_get_parent_symbol (_tmp1535_);
					_tmp1537_ = _tmp1536_;
					_tmp1527_ = _tmp1537_ != NULL;
				} else {
					_tmp1527_ = FALSE;
				}
				if (_tmp1527_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1538_;
					ValaSymbol* _tmp1539_;
					ValaSymbol* _tmp1540_;
					ValaSymbol* _tmp1541_;
					ValaDataType* _tmp1542_;
					ValaExpression* _tmp1543_;
					ValaExpression* _tmp1544_;
					ValaDataType* _tmp1545_;
					ValaExpression* _tmp1546_;
					ValaExpression* _tmp1547_;
					ValaDataType* _tmp1548_;
					ValaDataType* _tmp1549_;
					ValaDataType* _tmp1550_;
					ValaDataType* _tmp1551_;
					_tmp1538_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1539_ = _tmp1538_;
					_tmp1540_ = vala_symbol_get_parent_symbol (_tmp1539_);
					_tmp1541_ = _tmp1540_;
					_tmp1542_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1541_);
					parent_type = _tmp1542_;
					_tmp1543_ = vala_member_access_get_inner (self);
					_tmp1544_ = _tmp1543_;
					_tmp1545_ = parent_type;
					_tmp1546_ = vala_member_access_get_inner (self);
					_tmp1547_ = _tmp1546_;
					_tmp1548_ = vala_expression_get_value_type (_tmp1547_);
					_tmp1549_ = _tmp1548_;
					_tmp1550_ = vala_data_type_get_actual_type (_tmp1545_, _tmp1549_, NULL, (ValaCodeNode*) self);
					_tmp1551_ = _tmp1550_;
					vala_expression_set_target_type (_tmp1544_, _tmp1551_);
					_vala_code_node_unref0 (_tmp1551_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1554_ = vala_member_access_get_inner (self);
		_tmp1555_ = _tmp1554_;
		if (_tmp1555_ == NULL) {
			ValaDataType* _tmp1556_;
			ValaDataType* _tmp1557_;
			_tmp1556_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1557_ = _tmp1556_;
			_tmp1553_ = _tmp1557_ != NULL;
		} else {
			_tmp1553_ = FALSE;
		}
		if (_tmp1553_) {
			ValaProfile _tmp1558_;
			ValaProfile _tmp1559_;
			_tmp1558_ = vala_code_context_get_profile (context);
			_tmp1559_ = _tmp1558_;
			_tmp1552_ = _tmp1559_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1552_ = FALSE;
		}
		if (_tmp1552_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1560_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1561_ = _tmp1560_;
	if (_tmp1561_ != NULL) {
		ValaDataType* _tmp1562_;
		ValaDataType* _tmp1563_;
		_tmp1562_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1563_ = _tmp1562_;
		vala_code_node_check ((ValaCodeNode*) _tmp1563_, context);
	}
	_tmp1564_ = self->priv->_tainted_access;
	if (!_tmp1564_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1565_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1566_ = _tmp1565_;
	result = !_tmp1566_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

