/* valadocdocumentationimporter.c generated by valac, the Vala compiler
 * generated from valadocdocumentationimporter.vala, do not modify */

/* resourcelocator.vala
 *
 * Copyright (C) 2010 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <glib-object.h>
#include <valagee.h>

enum  {
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_0_PROPERTY,
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY,
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_NUM_PROPERTIES
};
static GParamSpec* valadoc_importer_valadoc_documentation_importer_properties[VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_NUM_PROPERTIES];
typedef enum  {
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND,
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_PREPEND,
	VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_REPLACE
} ValadocImporterValadocDocumentationImporterInsertionMode;

#define VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_TYPE_INSERTION_MODE (valadoc_importer_valadoc_documentation_importer_insertion_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValadocImporterValadocDocumentationImporterPrivate {
	ValadocImporterValadocDocumentationScanner* _scanner;
	ValadocDocumentationParser* _doc_parser;
	ValadocParser* _parser;
	GMappedFile* _mapped_file;
	gchar* _filename;
	gchar* _cname;
	GString* _comment;
	ValaSourceLocation _comment_location;
	ValadocErrorReporter* reporter;
};

static gint ValadocImporterValadocDocumentationImporter_private_offset;
static gpointer valadoc_importer_valadoc_documentation_importer_parent_class = NULL;
static ValadocResourceLocatorIface * valadoc_importer_valadoc_documentation_importer_valadoc_resource_locator_parent_iface = NULL;

static GType valadoc_importer_valadoc_documentation_importer_insertion_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void __lambda133_ (ValadocImporterValadocDocumentationImporter* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda133__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void valadoc_importer_valadoc_documentation_importer_add_comment (ValadocImporterValadocDocumentationImporter* self,
                                                                  ValadocToken* token,
                                                                  GError** error);
static void _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action (ValadocToken* token,
                                                                                             gpointer self,
                                                                                             GError** error);
static void __lambda134_ (ValadocImporterValadocDocumentationImporter* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda134__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda135_ (ValadocImporterValadocDocumentationImporter* self,
                   GError** error);
static void valadoc_importer_valadoc_documentation_importer_add_documentation (ValadocImporterValadocDocumentationImporter* self,
                                                                        const gchar* _symbol_name,
                                                                        GString* comment,
                                                                        const gchar* filename,
                                                                        ValaSourceLocation* src_ref);
static void ___lambda135__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda136_ (ValadocImporterValadocDocumentationImporter* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda136__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
 G_GNUC_INTERNAL void valadoc_api_node_set_documentation (ValadocApiNode* self,
                                         ValadocContentComment* value);
static void valadoc_importer_valadoc_documentation_importer_merge_taglets (ValadocImporterValadocDocumentationImporter* self,
                                                                    ValadocContentComment* comment,
                                                                    ValadocContentComment* imported);
static void valadoc_importer_valadoc_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                                   const gchar* filename);
static void valadoc_importer_valadoc_documentation_importer_finalize (GObject * obj);
static GType valadoc_importer_valadoc_documentation_importer_get_type_once (void);
static void _vala_valadoc_importer_valadoc_documentation_importer_get_property (GObject * object,
                                                                         guint property_id,
                                                                         GValue * value,
                                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
valadoc_importer_valadoc_documentation_importer_get_instance_private (ValadocImporterValadocDocumentationImporter* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocImporterValadocDocumentationImporter_private_offset);
}

static GType
valadoc_importer_valadoc_documentation_importer_insertion_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND, "VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND", "append"}, {VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_PREPEND, "VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_PREPEND", "prepend"}, {VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_REPLACE, "VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_REPLACE", "replace"}, {0, NULL, NULL}};
	GType valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id;
	valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id = g_enum_register_static ("ValadocImporterValadocDocumentationImporterInsertionMode", values);
	return valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id;
}

static GType
valadoc_importer_valadoc_documentation_importer_insertion_mode_get_type (void)
{
	static volatile gsize valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id__volatile)) {
		GType valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id;
		valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id = valadoc_importer_valadoc_documentation_importer_insertion_mode_get_type_once ();
		g_once_init_leave (&valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id__volatile, valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id);
	}
	return valadoc_importer_valadoc_documentation_importer_insertion_mode_type_id__volatile;
}

static const gchar*
valadoc_importer_valadoc_documentation_importer_real_get_file_extension (ValadocImporterDocumentationImporter* base)
{
	const gchar* result;
	ValadocImporterValadocDocumentationImporter* self;
	self = (ValadocImporterValadocDocumentationImporter*) base;
	result = "valadoc";
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda133_ (ValadocImporterValadocDocumentationImporter* self,
              ValadocToken* token,
              GError** error)
{
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	g_return_if_fail (token != NULL);
	valadoc_token_get_end (token, &_tmp0_);
	_tmp1_ = _tmp0_;
	self->priv->_comment_location = _tmp1_;
}

static void
___lambda133__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda133_ ((ValadocImporterValadocDocumentationImporter*) self, token, error);
}

static void
_valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action (ValadocToken* token,
                                                                                        gpointer self,
                                                                                        GError** error)
{
	valadoc_importer_valadoc_documentation_importer_add_comment ((ValadocImporterValadocDocumentationImporter*) self, token, error);
}

static void
__lambda134_ (ValadocImporterValadocDocumentationImporter* self,
              ValadocToken* token,
              GError** error)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_cname);
	self->priv->_cname = _tmp1_;
}

static void
___lambda134__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda134_ ((ValadocImporterValadocDocumentationImporter*) self, token, error);
}

static void
__lambda135_ (ValadocImporterValadocDocumentationImporter* self,
              GError** error)
{
	const gchar* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	ValaSourceLocation _tmp3_;
	GString* _tmp4_;
	_tmp0_ = self->priv->_cname;
	_tmp1_ = self->priv->_comment;
	_tmp2_ = self->priv->_filename;
	_tmp3_ = self->priv->_comment_location;
	valadoc_importer_valadoc_documentation_importer_add_documentation (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = self->priv->_comment;
	g_string_erase (_tmp4_, (gssize) 0, (gssize) -1);
	_g_free0 (self->priv->_cname);
	self->priv->_cname = NULL;
}

static void
___lambda135__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda135_ ((ValadocImporterValadocDocumentationImporter*) self, error);
}

static void
__lambda136_ (ValadocImporterValadocDocumentationImporter* self,
              ValadocToken* token,
              GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	_tmp1_ = self->priv->_filename;
	_tmp2_ = self->priv->_comment_location;
	valadoc_importer_valadoc_documentation_importer_add_documentation (self, _tmp0_, NULL, _tmp1_, &_tmp2_);
}

static void
___lambda136__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda136_ ((ValadocImporterValadocDocumentationImporter*) self, token, error);
}

ValadocImporterValadocDocumentationImporter*
valadoc_importer_valadoc_documentation_importer_construct (GType object_type,
                                                           ValadocApiTree* tree,
                                                           ValadocDocumentationParser* parser,
                                                           ValadocModuleLoader* modules,
                                                           ValadocSettings* settings,
                                                           ValadocErrorReporter* reporter)
{
	ValadocImporterValadocDocumentationImporter * self = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocImporterValadocDocumentationScanner* _tmp2_;
	ValadocDocumentationParser* _tmp3_;
	ValadocImporterValadocDocumentationScanner* _tmp4_;
	ValadocImporterValadocDocumentationScanner* _tmp5_;
	ValadocParser* _tmp6_;
	ValadocImporterValadocDocumentationScanner* _tmp7_;
	ValadocParser* _tmp8_;
	GString* _tmp9_;
	ValadocRule* unprinted_spaces = NULL;
	ValadocTokenType* _tmp10_;
	GObject* _tmp11_;
	ValadocTokenType* _tmp12_;
	GObject* _tmp13_;
	GObject** _tmp14_;
	GObject** _tmp15_;
	gint _tmp15__length1;
	ValadocRule* _tmp16_;
	GObject** _tmp17_;
	GObject** _tmp18_;
	gint _tmp18__length1;
	ValadocRule* _tmp19_;
	ValadocRule* _tmp20_;
	ValadocRule* empty_lines = NULL;
	GObject* _tmp21_;
	ValadocTokenType* _tmp22_;
	GObject* _tmp23_;
	GObject** _tmp24_;
	GObject** _tmp25_;
	gint _tmp25__length1;
	ValadocRule* _tmp26_;
	GObject** _tmp27_;
	GObject** _tmp28_;
	gint _tmp28__length1;
	ValadocRule* _tmp29_;
	ValadocRule* _tmp30_;
	ValadocRule* _tmp31_;
	ValadocRule* _tmp32_;
	ValadocRule* optional_empty_lines = NULL;
	GObject* _tmp33_;
	GObject** _tmp34_;
	GObject** _tmp35_;
	gint _tmp35__length1;
	ValadocRule* _tmp36_;
	ValadocRule* _tmp37_;
	ValadocRule* documentation = NULL;
	ValadocTokenType* _tmp38_;
	ValadocTokenType* _tmp39_;
	ValadocTokenType* _tmp40_;
	ValadocTokenType* _tmp41_;
	ValadocTokenType* _tmp42_;
	ValadocTokenType* _tmp43_;
	ValadocTokenType* _tmp44_;
	ValadocTokenType* _tmp45_;
	ValadocTokenType* _tmp46_;
	ValadocTokenType* _tmp47_;
	ValadocTokenType* _tmp48_;
	ValadocTokenType* _tmp49_;
	GObject** _tmp50_;
	GObject** _tmp51_;
	gint _tmp51__length1;
	ValadocRule* _tmp52_;
	GObject** _tmp53_;
	GObject** _tmp54_;
	gint _tmp54__length1;
	ValadocRule* _tmp55_;
	ValadocTokenType* _tmp56_;
	GObject* _tmp57_;
	GObject* _tmp58_;
	ValadocTokenType* _tmp59_;
	ValadocTokenType* _tmp60_;
	GObject** _tmp61_;
	GObject** _tmp62_;
	gint _tmp62__length1;
	ValadocRule* _tmp63_;
	ValadocRule* _tmp64_;
	ValadocRule* _tmp65_;
	ValadocTokenType* _tmp66_;
	ValadocTokenType* _tmp67_;
	GObject** _tmp68_;
	GObject** _tmp69_;
	gint _tmp69__length1;
	ValadocRule* _tmp70_;
	ValadocRule* _tmp71_;
	ValadocRule* _tmp72_;
	ValadocRule* _tmp73_;
	ValadocRule* file = NULL;
	GObject* _tmp74_;
	GObject* _tmp75_;
	GObject** _tmp76_;
	GObject** _tmp77_;
	gint _tmp77__length1;
	ValadocRule* _tmp78_;
	GObject** _tmp79_;
	GObject** _tmp80_;
	gint _tmp80__length1;
	ValadocRule* _tmp81_;
	ValadocRule* _tmp82_;
	ValadocRule* _tmp83_;
	ValadocRule* _tmp84_;
	ValadocParser* _tmp85_;
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocImporterValadocDocumentationImporter*) valadoc_importer_documentation_importer_construct (object_type, tree, modules, settings);
	_tmp0_ = valadoc_content_content_factory_new (settings, (ValadocResourceLocator*) self, modules);
	_g_object_unref0 (self->factory);
	self->factory = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	_tmp2_ = valadoc_importer_valadoc_documentation_scanner_new (settings);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp2_;
	_tmp3_ = _g_object_ref0 (parser);
	_g_object_unref0 (self->priv->_doc_parser);
	self->priv->_doc_parser = _tmp3_;
	_tmp4_ = valadoc_importer_valadoc_documentation_scanner_new (settings);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp4_;
	_tmp5_ = self->priv->_scanner;
	_tmp6_ = valadoc_parser_new (settings, (ValadocScanner*) _tmp5_, reporter);
	_valadoc_parser_unref0 (self->priv->_parser);
	self->priv->_parser = _tmp6_;
	_tmp7_ = self->priv->_scanner;
	_tmp8_ = self->priv->_parser;
	valadoc_scanner_set_parser ((ValadocScanner*) _tmp7_, _tmp8_);
	_tmp9_ = g_string_new ("");
	_g_string_free0 (self->priv->_comment);
	self->priv->_comment = _tmp9_;
	_tmp10_ = valadoc_token_type_VALADOC_SPACE;
	_tmp11_ = _g_object_ref0 ((GObject*) _tmp10_);
	_tmp12_ = valadoc_token_type_VALADOC_TAB;
	_tmp13_ = _g_object_ref0 ((GObject*) _tmp12_);
	_tmp14_ = g_new0 (GObject*, 2 + 1);
	_tmp14_[0] = _tmp11_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = valadoc_rule_one_of (_tmp15_, (gint) 2);
	_tmp17_ = g_new0 (GObject*, 1 + 1);
	_tmp17_[0] = (GObject*) _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	_tmp19_ = valadoc_rule_many (_tmp18_, (gint) 1);
	_tmp20_ = _tmp19_;
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
	unprinted_spaces = _tmp20_;
	_tmp21_ = _g_object_ref0 ((GObject*) unprinted_spaces);
	_tmp22_ = valadoc_token_type_VALADOC_EOL;
	_tmp23_ = _g_object_ref0 ((GObject*) _tmp22_);
	_tmp24_ = g_new0 (GObject*, 2 + 1);
	_tmp24_[0] = _tmp21_;
	_tmp24_[1] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 2;
	_tmp26_ = valadoc_rule_one_of (_tmp25_, (gint) 2);
	_tmp27_ = g_new0 (GObject*, 1 + 1);
	_tmp27_[0] = (GObject*) _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	_tmp29_ = valadoc_rule_many (_tmp28_, (gint) 1);
	_tmp30_ = _tmp29_;
	_tmp31_ = valadoc_rule_set_name (_tmp30_, "EmptyLines");
	_tmp32_ = _tmp31_;
	_g_object_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_object_unref), NULL);
	empty_lines = _tmp32_;
	_tmp33_ = _g_object_ref0 ((GObject*) empty_lines);
	_tmp34_ = g_new0 (GObject*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	_tmp36_ = valadoc_rule_option (_tmp35_, (gint) 1);
	_tmp37_ = _tmp36_;
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_object_unref), NULL);
	optional_empty_lines = _tmp37_;
	_tmp38_ = valadoc_token_type_VALADOC_COMMENT_START;
	_tmp39_ = valadoc_token_type_action (_tmp38_, ___lambda133__valadoc_token_type_action, self);
	_tmp40_ = valadoc_token_type_ANY_WORD;
	_tmp41_ = valadoc_token_type_action (_tmp40_, _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action, self);
	_tmp42_ = valadoc_token_type_VALADOC_COMMENT_START;
	_tmp43_ = valadoc_token_type_action (_tmp42_, _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action, self);
	_tmp44_ = valadoc_token_type_VALADOC_SPACE;
	_tmp45_ = valadoc_token_type_action (_tmp44_, _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action, self);
	_tmp46_ = valadoc_token_type_VALADOC_TAB;
	_tmp47_ = valadoc_token_type_action (_tmp46_, _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action, self);
	_tmp48_ = valadoc_token_type_VALADOC_EOL;
	_tmp49_ = valadoc_token_type_action (_tmp48_, _valadoc_importer_valadoc_documentation_importer_add_comment_valadoc_token_type_action, self);
	_tmp50_ = g_new0 (GObject*, 5 + 1);
	_tmp50_[0] = (GObject*) _tmp41_;
	_tmp50_[1] = (GObject*) _tmp43_;
	_tmp50_[2] = (GObject*) _tmp45_;
	_tmp50_[3] = (GObject*) _tmp47_;
	_tmp50_[4] = (GObject*) _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 5;
	_tmp52_ = valadoc_rule_one_of (_tmp51_, (gint) 5);
	_tmp53_ = g_new0 (GObject*, 1 + 1);
	_tmp53_[0] = (GObject*) _tmp52_;
	_tmp54_ = _tmp53_;
	_tmp54__length1 = 1;
	_tmp55_ = valadoc_rule_many (_tmp54_, (gint) 1);
	_tmp56_ = valadoc_token_type_VALADOC_COMMENT_END;
	_tmp57_ = _g_object_ref0 ((GObject*) _tmp56_);
	_tmp58_ = _g_object_ref0 ((GObject*) optional_empty_lines);
	_tmp59_ = valadoc_token_type_ANY_WORD;
	_tmp60_ = valadoc_token_type_action (_tmp59_, ___lambda134__valadoc_token_type_action, self);
	_tmp61_ = g_new0 (GObject*, 5 + 1);
	_tmp61_[0] = (GObject*) _tmp39_;
	_tmp61_[1] = (GObject*) _tmp55_;
	_tmp61_[2] = _tmp57_;
	_tmp61_[3] = _tmp58_;
	_tmp61_[4] = (GObject*) _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 5;
	_tmp63_ = valadoc_rule_seq (_tmp62_, (gint) 5);
	_tmp64_ = _tmp63_;
	_tmp65_ = valadoc_rule_set_reduce (_tmp64_, ___lambda135__valadoc_rule_action, self);
	_tmp66_ = valadoc_token_type_ANY_WORD;
	_tmp67_ = valadoc_token_type_action (_tmp66_, ___lambda136__valadoc_token_type_action, self);
	_tmp68_ = g_new0 (GObject*, 2 + 1);
	_tmp68_[0] = (GObject*) _tmp65_;
	_tmp68_[1] = (GObject*) _tmp67_;
	_tmp69_ = _tmp68_;
	_tmp69__length1 = 2;
	_tmp70_ = valadoc_rule_one_of (_tmp69_, (gint) 2);
	_tmp71_ = _tmp70_;
	_tmp72_ = valadoc_rule_set_name (_tmp71_, "Documentation");
	_tmp73_ = _tmp72_;
	_g_object_unref0 (_tmp71_);
	_tmp69_ = (_vala_array_free (_tmp69_, _tmp69__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp64_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_object_unref), NULL);
	documentation = _tmp73_;
	_tmp74_ = _g_object_ref0 ((GObject*) documentation);
	_tmp75_ = _g_object_ref0 ((GObject*) optional_empty_lines);
	_tmp76_ = g_new0 (GObject*, 2 + 1);
	_tmp76_[0] = _tmp74_;
	_tmp76_[1] = _tmp75_;
	_tmp77_ = _tmp76_;
	_tmp77__length1 = 2;
	_tmp78_ = valadoc_rule_one_of (_tmp77_, (gint) 2);
	_tmp79_ = g_new0 (GObject*, 1 + 1);
	_tmp79_[0] = (GObject*) _tmp78_;
	_tmp80_ = _tmp79_;
	_tmp80__length1 = 1;
	_tmp81_ = valadoc_rule_many (_tmp80_, (gint) 1);
	_tmp82_ = _tmp81_;
	_tmp83_ = valadoc_rule_set_name (_tmp82_, "ValadocFile");
	_tmp84_ = _tmp83_;
	_g_object_unref0 (_tmp82_);
	_tmp80_ = (_vala_array_free (_tmp80_, _tmp80__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp77_ = (_vala_array_free (_tmp77_, _tmp77__length1, (GDestroyNotify) g_object_unref), NULL);
	file = _tmp84_;
	_tmp85_ = self->priv->_parser;
	valadoc_parser_set_root_rule (_tmp85_, file);
	_g_object_unref0 (file);
	_g_object_unref0 (documentation);
	_g_object_unref0 (optional_empty_lines);
	_g_object_unref0 (empty_lines);
	_g_object_unref0 (unprinted_spaces);
	return self;
}

ValadocImporterValadocDocumentationImporter*
valadoc_importer_valadoc_documentation_importer_new (ValadocApiTree* tree,
                                                     ValadocDocumentationParser* parser,
                                                     ValadocModuleLoader* modules,
                                                     ValadocSettings* settings,
                                                     ValadocErrorReporter* reporter)
{
	return valadoc_importer_valadoc_documentation_importer_construct (VALADOC_IMPORTER_TYPE_VALADOC_DOCUMENTATION_IMPORTER, tree, parser, modules, settings, reporter);
}

static void
valadoc_importer_valadoc_documentation_importer_add_comment (ValadocImporterValadocDocumentationImporter* self,
                                                             ValadocToken* token,
                                                             GError** error)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_comment;
	_tmp1_ = valadoc_token_to_string (token);
	g_string_append (_tmp0_, _tmp1_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
valadoc_importer_valadoc_documentation_importer_add_documentation (ValadocImporterValadocDocumentationImporter* self,
                                                                   const gchar* _symbol_name,
                                                                   GString* comment,
                                                                   const gchar* filename,
                                                                   ValaSourceLocation* src_ref)
{
	ValadocApiNode* symbol = NULL;
	ValadocImporterValadocDocumentationImporterInsertionMode insertion_mode = 0;
	gchar* symbol_name = NULL;
	const gchar* _tmp7_;
	ValadocApiNode* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_symbol_name != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (src_ref != NULL);
	symbol = NULL;
	if (g_str_has_suffix (_symbol_name, "::append")) {
		gint _tmp0_;
		gint _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = strlen (_symbol_name);
		_tmp1_ = _tmp0_;
		_tmp2_ = string_substring (_symbol_name, (glong) 0, (glong) (_tmp1_ - 8));
		_g_free0 (symbol_name);
		symbol_name = _tmp2_;
		insertion_mode = VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND;
	} else {
		if (g_str_has_suffix (_symbol_name, "::prepend")) {
			gint _tmp3_;
			gint _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = strlen (_symbol_name);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_substring (_symbol_name, (glong) 0, (glong) (_tmp4_ - 9));
			_g_free0 (symbol_name);
			symbol_name = _tmp5_;
			insertion_mode = VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_PREPEND;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_symbol_name);
			_g_free0 (symbol_name);
			symbol_name = _tmp6_;
			insertion_mode = VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_REPLACE;
		}
	}
	_tmp7_ = symbol_name;
	if (g_str_has_prefix (_tmp7_, "c::")) {
		ValadocApiTree* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValadocApiNode* _tmp12_;
		_tmp8_ = ((ValadocImporterDocumentationImporter*) self)->tree;
		_tmp9_ = symbol_name;
		_tmp10_ = string_substring (_tmp9_, (glong) 3, (glong) -1);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_api_tree_search_symbol_cstr (_tmp8_, NULL, _tmp11_);
		_g_object_unref0 (symbol);
		symbol = _tmp12_;
		_g_free0 (_tmp11_);
	} else {
		ValadocApiTree* _tmp13_;
		const gchar* _tmp14_;
		ValadocApiNode* _tmp15_;
		_tmp13_ = ((ValadocImporterDocumentationImporter*) self)->tree;
		_tmp14_ = symbol_name;
		_tmp15_ = valadoc_api_tree_search_symbol_str (_tmp13_, NULL, _tmp14_);
		_g_object_unref0 (symbol);
		symbol = _tmp15_;
	}
	_tmp16_ = symbol;
	if (_tmp16_ == NULL) {
		ValadocSettings* _tmp17_;
		_tmp17_ = ((ValadocImporterDocumentationImporter*) self)->settings;
		if (_tmp17_->verbose) {
			ValadocErrorReporter* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = self->priv->reporter;
			_tmp19_ = symbol_name;
			valadoc_error_reporter_simple_warning (_tmp18_, filename, "Node `%s' does not exist", _tmp19_);
		}
		_g_free0 (symbol_name);
		_g_object_unref0 (symbol);
		return;
	}
	if (comment != NULL) {
		ValadocContentComment* docu = NULL;
		ValadocDocumentationParser* _tmp20_;
		ValadocApiNode* _tmp21_;
		const gchar* _tmp22_;
		ValaSourceLocation _tmp23_;
		ValaSourceLocation _tmp24_;
		ValadocContentComment* _tmp25_;
		ValadocContentComment* _tmp26_;
		_tmp20_ = self->priv->_doc_parser;
		_tmp21_ = symbol;
		_tmp22_ = comment->str;
		_tmp23_ = *src_ref;
		_tmp24_ = *src_ref;
		_tmp25_ = valadoc_documentation_parser_parse_comment_str (_tmp20_, _tmp21_, _tmp22_, filename, _tmp23_.line, _tmp24_.column);
		docu = _tmp25_;
		_tmp26_ = docu;
		if (_tmp26_ != NULL) {
			ValadocContentComment* _tmp27_;
			ValadocApiTree* _tmp28_;
			ValadocApiNode* _tmp29_;
			ValadocErrorReporter* _tmp30_;
			ValadocSettings* _tmp31_;
			gboolean _tmp32_ = FALSE;
			ValadocApiNode* _tmp33_;
			ValadocContentComment* _tmp34_;
			ValadocContentComment* _tmp35_;
			_tmp27_ = docu;
			_tmp28_ = ((ValadocImporterDocumentationImporter*) self)->tree;
			_tmp29_ = symbol;
			_tmp30_ = self->priv->reporter;
			_tmp31_ = ((ValadocImporterDocumentationImporter*) self)->settings;
			valadoc_content_content_element_check ((ValadocContentContentElement*) _tmp27_, _tmp28_, _tmp29_, filename, _tmp30_, _tmp31_);
			_tmp33_ = symbol;
			_tmp34_ = valadoc_api_node_get_documentation (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ == NULL) {
				_tmp32_ = TRUE;
			} else {
				_tmp32_ = insertion_mode == VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_REPLACE;
			}
			if (_tmp32_) {
				ValadocApiNode* _tmp42_;
				ValadocContentComment* _tmp43_;
				if (insertion_mode == VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND) {
					ValadocContentComment* _tmp36_;
					ValaList* _tmp37_;
					ValaList* _tmp38_;
					ValadocContentContentFactory* _tmp39_;
					ValadocContentParagraph* _tmp40_;
					ValadocContentParagraph* _tmp41_;
					_tmp36_ = docu;
					_tmp37_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->factory;
					_tmp40_ = valadoc_content_content_factory_create_paragraph (_tmp39_);
					_tmp41_ = _tmp40_;
					vala_list_insert (_tmp38_, 0, (ValadocContentBlock*) _tmp41_);
					_g_object_unref0 (_tmp41_);
				}
				_tmp42_ = symbol;
				_tmp43_ = docu;
				valadoc_api_node_set_documentation (_tmp42_, _tmp43_);
			} else {
				if (insertion_mode == VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_APPEND) {
					ValadocApiNode* _tmp44_;
					ValadocContentComment* _tmp45_;
					ValadocContentComment* _tmp46_;
					ValaList* _tmp47_;
					ValaList* _tmp48_;
					ValadocContentComment* _tmp49_;
					ValaList* _tmp50_;
					ValaList* _tmp51_;
					ValadocApiNode* _tmp52_;
					ValadocContentComment* _tmp53_;
					ValadocContentComment* _tmp54_;
					ValadocContentComment* _tmp55_;
					_tmp44_ = symbol;
					_tmp45_ = valadoc_api_node_get_documentation (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = docu;
					_tmp50_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp49_);
					_tmp51_ = _tmp50_;
					vala_collection_add_all ((ValaCollection*) _tmp48_, (ValaCollection*) _tmp51_);
					_tmp52_ = symbol;
					_tmp53_ = valadoc_api_node_get_documentation (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = docu;
					valadoc_importer_valadoc_documentation_importer_merge_taglets (self, _tmp54_, _tmp55_);
				} else {
					if (insertion_mode == VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_INSERTION_MODE_PREPEND) {
						ValadocApiNode* _tmp56_;
						ValadocContentComment* _tmp57_;
						ValadocContentComment* _tmp58_;
						ValaList* _tmp59_;
						ValaList* _tmp60_;
						ValadocContentComment* _tmp61_;
						ValaList* _tmp62_;
						ValaList* _tmp63_;
						ValadocApiNode* _tmp64_;
						ValadocContentComment* _tmp65_;
						ValadocContentComment* _tmp66_;
						ValadocContentComment* _tmp67_;
						_tmp56_ = symbol;
						_tmp57_ = valadoc_api_node_get_documentation (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp58_);
						_tmp60_ = _tmp59_;
						_tmp61_ = docu;
						_tmp62_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp61_);
						_tmp63_ = _tmp62_;
						vala_list_insert_all (_tmp60_, 0, (ValaCollection*) _tmp63_);
						_tmp64_ = symbol;
						_tmp65_ = valadoc_api_node_get_documentation (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = docu;
						valadoc_importer_valadoc_documentation_importer_merge_taglets (self, _tmp66_, _tmp67_);
					}
				}
			}
		}
		_g_object_unref0 (docu);
	}
	_g_free0 (symbol_name);
	_g_object_unref0 (symbol);
}

static void
valadoc_importer_valadoc_documentation_importer_merge_taglets (ValadocImporterValadocDocumentationImporter* self,
                                                               ValadocContentComment* comment,
                                                               ValadocContentComment* imported)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	g_return_if_fail (imported != NULL);
	{
		ValaList* _taglet_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _taglet_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _taglet_index = 0;
		_tmp0_ = valadoc_content_comment_get_taglets (imported);
		_tmp1_ = _tmp0_;
		_taglet_list = _tmp1_;
		_tmp2_ = _taglet_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_taglet_size = _tmp4_;
		_taglet_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValadocContentTaglet* taglet = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaList* _tmp9_;
			ValaList* _tmp10_;
			ValadocContentTaglet* _tmp11_;
			_taglet_index = _taglet_index + 1;
			_tmp5_ = _taglet_index;
			_tmp6_ = _taglet_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _taglet_list;
			_tmp8_ = vala_list_get (_tmp7_, _taglet_index);
			taglet = (ValadocContentTaglet*) _tmp8_;
			_tmp9_ = valadoc_content_comment_get_taglets (imported);
			_tmp10_ = _tmp9_;
			_tmp11_ = taglet;
			vala_collection_add ((ValaCollection*) _tmp10_, _tmp11_);
			_g_object_unref0 (taglet);
		}
	}
}

static void
valadoc_importer_valadoc_documentation_importer_real_process (ValadocImporterDocumentationImporter* base,
                                                              const gchar* filename)
{
	ValadocImporterValadocDocumentationImporter * self;
	GError* _inner_error0_ = NULL;
	self = (ValadocImporterValadocDocumentationImporter*) base;
	g_return_if_fail (filename != NULL);
	{
		gchar* _tmp0_;
		GMappedFile* _tmp1_ = NULL;
		GMappedFile* _tmp2_;
		GMappedFile* _tmp3_;
		gchar* content = NULL;
		GMappedFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = g_strdup (filename);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		_tmp2_ = g_mapped_file_new (filename, FALSE, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				goto __catch0_valadoc_parser_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_mapped_file_unref0 (self->priv->_mapped_file);
		self->priv->_mapped_file = _tmp3_;
		_tmp4_ = self->priv->_mapped_file;
		_tmp5_ = g_mapped_file_get_contents (_tmp4_);
		content = _tmp5_;
		_tmp6_ = content;
		if (_tmp6_ != NULL) {
			ValadocParser* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_parser;
			_tmp8_ = content;
			valadoc_parser_parse (_tmp7_, (const gchar*) _tmp8_, filename, 0, 0, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (_tmp1_);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					goto __catch0_valadoc_parser_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_mapped_file_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* err = NULL;
		ValadocErrorReporter* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = self->priv->reporter;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		valadoc_error_reporter_simple_error (_tmp9_, NULL, "Unable to map file `%s': %s", filename, _tmp11_);
		_g_error_free0 (err);
	}
	goto __finally0;
	__catch0_valadoc_parser_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
valadoc_importer_valadoc_documentation_importer_class_init (ValadocImporterValadocDocumentationImporterClass * klass,
                                                            gpointer klass_data)
{
	valadoc_importer_valadoc_documentation_importer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocImporterValadocDocumentationImporter_private_offset);
	((ValadocImporterDocumentationImporterClass *) klass)->process = (void (*) (ValadocImporterDocumentationImporter*, const gchar*)) valadoc_importer_valadoc_documentation_importer_real_process;
	VALADOC_IMPORTER_DOCUMENTATION_IMPORTER_CLASS (klass)->get_file_extension = valadoc_importer_valadoc_documentation_importer_real_get_file_extension;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_importer_valadoc_documentation_importer_get_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_importer_valadoc_documentation_importer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY, valadoc_importer_valadoc_documentation_importer_properties[VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY] = g_param_spec_string ("file-extension", "file-extension", "file-extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
valadoc_importer_valadoc_documentation_importer_valadoc_resource_locator_interface_init (ValadocResourceLocatorIface * iface,
                                                                                         gpointer iface_data)
{
	valadoc_importer_valadoc_documentation_importer_valadoc_resource_locator_parent_iface = g_type_interface_peek_parent (iface);
}

static void
valadoc_importer_valadoc_documentation_importer_instance_init (ValadocImporterValadocDocumentationImporter * self,
                                                               gpointer klass)
{
	self->priv = valadoc_importer_valadoc_documentation_importer_get_instance_private (self);
}

static void
valadoc_importer_valadoc_documentation_importer_finalize (GObject * obj)
{
	ValadocImporterValadocDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_IMPORTER_TYPE_VALADOC_DOCUMENTATION_IMPORTER, ValadocImporterValadocDocumentationImporter);
	_g_object_unref0 (self->priv->_scanner);
	_g_object_unref0 (self->priv->_doc_parser);
	_valadoc_parser_unref0 (self->priv->_parser);
	_g_mapped_file_unref0 (self->priv->_mapped_file);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_cname);
	_g_string_free0 (self->priv->_comment);
	_g_object_unref0 (self->factory);
	_g_object_unref0 (self->priv->reporter);
	G_OBJECT_CLASS (valadoc_importer_valadoc_documentation_importer_parent_class)->finalize (obj);
}

static GType
valadoc_importer_valadoc_documentation_importer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocImporterValadocDocumentationImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_importer_valadoc_documentation_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocImporterValadocDocumentationImporter), 0, (GInstanceInitFunc) valadoc_importer_valadoc_documentation_importer_instance_init, NULL };
	static const GInterfaceInfo valadoc_resource_locator_info = { (GInterfaceInitFunc) valadoc_importer_valadoc_documentation_importer_valadoc_resource_locator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_importer_valadoc_documentation_importer_type_id;
	valadoc_importer_valadoc_documentation_importer_type_id = g_type_register_static (VALADOC_IMPORTER_TYPE_DOCUMENTATION_IMPORTER, "ValadocImporterValadocDocumentationImporter", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_importer_valadoc_documentation_importer_type_id, VALADOC_TYPE_RESOURCE_LOCATOR, &valadoc_resource_locator_info);
	ValadocImporterValadocDocumentationImporter_private_offset = g_type_add_instance_private (valadoc_importer_valadoc_documentation_importer_type_id, sizeof (ValadocImporterValadocDocumentationImporterPrivate));
	return valadoc_importer_valadoc_documentation_importer_type_id;
}

GType
valadoc_importer_valadoc_documentation_importer_get_type (void)
{
	static volatile gsize valadoc_importer_valadoc_documentation_importer_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_importer_valadoc_documentation_importer_type_id__volatile)) {
		GType valadoc_importer_valadoc_documentation_importer_type_id;
		valadoc_importer_valadoc_documentation_importer_type_id = valadoc_importer_valadoc_documentation_importer_get_type_once ();
		g_once_init_leave (&valadoc_importer_valadoc_documentation_importer_type_id__volatile, valadoc_importer_valadoc_documentation_importer_type_id);
	}
	return valadoc_importer_valadoc_documentation_importer_type_id__volatile;
}

static void
_vala_valadoc_importer_valadoc_documentation_importer_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec)
{
	ValadocImporterValadocDocumentationImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_IMPORTER_TYPE_VALADOC_DOCUMENTATION_IMPORTER, ValadocImporterValadocDocumentationImporter);
	switch (property_id) {
		case VALADOC_IMPORTER_VALADOC_DOCUMENTATION_IMPORTER_FILE_EXTENSION_PROPERTY:
		g_value_set_string (value, valadoc_importer_documentation_importer_get_file_extension ((ValadocImporterDocumentationImporter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

