// Generated by gmmproc 2.66.0 -- DO NOT MODIFY!
#ifndef _ATKMM_TEXT_H
#define _ATKMM_TEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: text.hg,v 1.7 2005/01/05 18:21:30 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <atkmm/component.h> /* for Atk::CoordType */
#include <glibmm/slisthandle.h>
#include <atk/atktext.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkText = struct _AtkText;
using AtkTextClass = struct _AtkTextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API Text_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{

class ATKMM_API Attribute
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Attribute;
  using BaseObjectType = AtkAttribute;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:


public:
  Attribute();
  Attribute(const Glib::ustring& name, const Glib::ustring& value);
  explicit Attribute(const AtkAttribute* gobject);
  ~Attribute();

  Attribute(const Attribute& other);
  Attribute& operator=(const Attribute& other);

  void swap(Attribute& other);

  Glib::ustring get_name() const;
  Glib::ustring get_value() const;

  /// Provides access to the underlying C GObject.
  AtkAttribute*       gobj()       { return &gobject_; }

  /// Provides access to the underlying C GObject.
  const AtkAttribute* gobj() const { return &gobject_; }

protected:
  AtkAttribute gobject_;


};

/** @relates Atk::Attribute */
inline void swap(Attribute& lhs, Attribute& rhs)
  { lhs.swap(rhs); }

struct AttributeTraits
{
  typedef Atk::Attribute      CppType;
  typedef const AtkAttribute* CType;
  typedef AtkAttribute*       CTypeNonConst;

  static CType to_c_type(CType item)          { return item; }
  static CType to_c_type(const CppType& item) { return item.gobj(); }
  static CppType to_cpp_type(CType item)      { return CppType(item); }
  static void release_c_type(CType item)      { g_free(const_cast<CTypeNonConst>(item)); }
};

typedef Glib::SListHandle<Attribute, AttributeTraits> AttributeSet;


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var BuiltinTextAttribute TEXT_ATTR_INVALID
 * Invalid attribute, like bad spelling or grammar.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_LEFT_MARGIN
 * The pixel width of the left margin.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_RIGHT_MARGIN
 * The pixel width of the right margin.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_INDENT
 * The number of pixels that the text is indented.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_INVISIBLE
 * Either "true" or "false" indicating whether text is visible or not.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_EDITABLE
 * Either "true" or "false" indicating whether text is editable or not.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_PIXELS_ABOVE_LINES
 * Pixels of blank space to leave above each newline-terminated line.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_PIXELS_BELOW_LINES
 * Pixels of blank space to leave below each newline-terminated line.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_PIXELS_INSIDE_WRAP
 * Pixels of blank space to leave between wrapped lines inside the same newline-terminated line (paragraph).
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_BG_FULL_HEIGHT
 * "true" or "false" whether to make the background color for each character the height of the highest font used on the current line, or the height of the font used for the current character.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_RISE
 * Number of pixels that the characters are risen above the baseline.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_UNDERLINE
 * "none", "single", "double", "low", or "error".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_STRIKETHROUGH
 * "true" or "false" whether the text is strikethrough.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_SIZE
 * The size of the characters in points. eg: 10.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_SCALE
 * The scale of the characters. The value is a string representation of a double.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_WEIGHT
 * The weight of the characters.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_LANGUAGE
 * The language used.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_FAMILY_NAME
 * The font family name.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_BG_COLOR
 * The background color. The value is an RGB value of the format "%u,%u,%u".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_FG_COLOR
 * The foreground color. The value is an RGB value of the format "%u,%u,%u".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_BG_STIPPLE
 * "true" if a Gdk::Bitmap is set for stippling the background color.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_FG_STIPPLE
 * "true" if a Gdk::Bitmap is set for stippling the foreground color.
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_WRAP_MODE
 * The wrap mode of the text, if any. Values are "none", "char", "word", or "word_char".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_DIRECTION
 * The direction of the text, if set. Values are "none", "ltr" or "rtl".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_JUSTIFICATION
 * The justification of the text, if set. Values are "left", "right", "center" or "fill".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_STRETCH
 * The stretch of the text, if set. Values are "ultra_condensed", "extra_condensed", "condensed", "semi_condensed", "normal", "semi_expanded", "expanded", "extra_expanded" or "ultra_expanded".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_VARIANT
 * The capitalization variant of the text, if set. Values are "normal" or "small_caps".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_STYLE
 * The slant style of the text, if set. Values are "normal", "oblique" or "italic".
 * 
 *  @var BuiltinTextAttribute TEXT_ATTR_LAST_DEFINED
 * Not a valid text attribute, used for finding end of enumeration.
 * 
 *  @enum BuiltinTextAttribute
 * 
 * Describes the text attributes supported
 *
 * @ingroup atkmmEnums
 */
enum BuiltinTextAttribute
{
  TEXT_ATTR_INVALID,
  TEXT_ATTR_LEFT_MARGIN,
  TEXT_ATTR_RIGHT_MARGIN,
  TEXT_ATTR_INDENT,
  TEXT_ATTR_INVISIBLE,
  TEXT_ATTR_EDITABLE,
  TEXT_ATTR_PIXELS_ABOVE_LINES,
  TEXT_ATTR_PIXELS_BELOW_LINES,
  TEXT_ATTR_PIXELS_INSIDE_WRAP,
  TEXT_ATTR_BG_FULL_HEIGHT,
  TEXT_ATTR_RISE,
  TEXT_ATTR_UNDERLINE,
  TEXT_ATTR_STRIKETHROUGH,
  TEXT_ATTR_SIZE,
  TEXT_ATTR_SCALE,
  TEXT_ATTR_WEIGHT,
  TEXT_ATTR_LANGUAGE,
  TEXT_ATTR_FAMILY_NAME,
  TEXT_ATTR_BG_COLOR,
  TEXT_ATTR_FG_COLOR,
  TEXT_ATTR_BG_STIPPLE,
  TEXT_ATTR_FG_STIPPLE,
  TEXT_ATTR_WRAP_MODE,
  TEXT_ATTR_DIRECTION,
  TEXT_ATTR_JUSTIFICATION,
  TEXT_ATTR_STRETCH,
  TEXT_ATTR_VARIANT,
  TEXT_ATTR_STYLE,
  TEXT_ATTR_LAST_DEFINED
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::BuiltinTextAttribute> : public Glib::Value_Enum<Atk::BuiltinTextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class ATKMM_API TextAttribute
{
private:
  int attribute_;

public:
  TextAttribute() : attribute_ (0) {}
  TextAttribute(BuiltinTextAttribute attribute) : attribute_ (attribute) {}

  // Behave like an ordinary enum.
  explicit TextAttribute(int attribute) : attribute_ (attribute) {}
  operator int() const { return attribute_; }

  static TextAttribute for_name(const Glib::ustring& name);
  static Glib::ustring get_name(TextAttribute attribute);
  static Glib::ustring get_value(TextAttribute attribute, int index);
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::TextAttribute> : public Glib::Value_Enum<Atk::TextAttribute>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** 
 *  @var TextBoundary TEXT_BOUNDARY_CHAR
 * Boundary is the boundary between characters
 * (including non-printing characters).
 * 
 *  @var TextBoundary TEXT_BOUNDARY_WORD_START
 * Boundary is the start (i.e. first character) of a word.
 * 
 *  @var TextBoundary TEXT_BOUNDARY_WORD_END
 * Boundary is the end (i.e. last
 * character) of a word.
 * 
 *  @var TextBoundary TEXT_BOUNDARY_SENTENCE_START
 * Boundary is the first character in a sentence.
 * 
 *  @var TextBoundary TEXT_BOUNDARY_SENTENCE_END
 * Boundary is the last (terminal)
 * character in a sentence; in languages which use "sentence stop"
 * punctuation such as English, the boundary is thus the '.', '?', or
 * similar terminal punctuation character.
 * 
 *  @var TextBoundary TEXT_BOUNDARY_LINE_START
 * Boundary is the initial character of the content or a
 * character immediately following a newline, linefeed, or return character.
 * 
 *  @var TextBoundary TEXT_BOUNDARY_LINE_END
 * Boundary is the linefeed, or return
 * character.
 * 
 *  @enum TextBoundary
 * 
 * Text boundary types used for specifying boundaries for regions of text.
 * This enumerationis deprecated since 2.9.4 and should not be used. Use
 * AtkTextGranularity with #atk_text_get_string_at_offset instead.
 *
 * @ingroup atkmmEnums
 */
enum TextBoundary
{
  TEXT_BOUNDARY_CHAR,
  TEXT_BOUNDARY_WORD_START,
  TEXT_BOUNDARY_WORD_END,
  TEXT_BOUNDARY_SENTENCE_START,
  TEXT_BOUNDARY_SENTENCE_END,
  TEXT_BOUNDARY_LINE_START,
  TEXT_BOUNDARY_LINE_END
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::TextBoundary> : public Glib::Value_Enum<Atk::TextBoundary>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** 
 *  @var TextClipType TEXT_CLIP_NONE
 * No clipping to be done.
 * 
 *  @var TextClipType TEXT_CLIP_MIN
 * Text clipped by min coordinate is omitted.
 * 
 *  @var TextClipType TEXT_CLIP_MAX
 * Text clipped by max coordinate is omitted.
 * 
 *  @var TextClipType TEXT_CLIP_BOTH
 * Only text fully within mix/max bound is retained.
 * 
 *  @enum TextClipType
 * 
 * Describes the type of clipping required.
 *
 * @ingroup atkmmEnums
 */
enum TextClipType
{
  TEXT_CLIP_NONE,
  TEXT_CLIP_MIN,
  TEXT_CLIP_MAX,
  TEXT_CLIP_BOTH
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::TextClipType> : public Glib::Value_Enum<Atk::TextClipType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** 
 *  @var TextGranularity TEXT_GRANULARITY_CHAR
 * Granularity is defined by the boundaries between characters
 * (including non-printing characters).
 * 
 *  @var TextGranularity TEXT_GRANULARITY_WORD
 * Granularity is defined by the boundaries of a word,
 * starting at the beginning of the current word and finishing at the beginning of
 * the following one, if present.
 * 
 *  @var TextGranularity TEXT_GRANULARITY_SENTENCE
 * Granularity is defined by the boundaries of a sentence,
 * starting at the beginning of the current sentence and finishing at the beginning of
 * the following one, if present.
 * 
 *  @var TextGranularity TEXT_GRANULARITY_LINE
 * Granularity is defined by the boundaries of a line,
 * starting at the beginning of the current line and finishing at the beginning of
 * the following one, if present.
 * 
 *  @var TextGranularity TEXT_GRANULARITY_PARAGRAPH
 * Granularity is defined by the boundaries of a paragraph,
 * starting at the beginning of the current paragraph and finishing at the beginning of
 * the following one, if present.
 * 
 *  @enum TextGranularity
 * 
 * Text granularity types used for specifying the granularity of the region of
 * text we are interested in.
 *
 * @ingroup atkmmEnums
 */
enum TextGranularity
{
  TEXT_GRANULARITY_CHAR,
  TEXT_GRANULARITY_WORD,
  TEXT_GRANULARITY_SENTENCE,
  TEXT_GRANULARITY_LINE,
  TEXT_GRANULARITY_PARAGRAPH
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::TextGranularity> : public Glib::Value_Enum<Atk::TextGranularity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


/** The ATK interface implemented by components with text content.
 * This should be implemented by Atk::Objects on behalf of widgets that have text content which is either attributed
 * or otherwise non-trivial. Atk::Objects whose text content is simple, unattributed, and very brief may expose that
 * content via Atk::Object::get_name() instead; however if the text is editable, multi-line, typically longer than
 * three or four words, attributed, selectable, or if the object already uses the 'name' ATK property for other
 * information, this Text interface should be used to expose the text content. In the case of editable text content,
 * Atk::EditableText (a subtype of the Atk::Text interface) should be implemented instead.
 *
 * Atk::Text provides not only traversal facilities and change notification for text content, but also caret tracking
 * and glyph bounding box calculations. Note that the text strings are exposed as UTF-8, and are therefore potentially
 * multi-byte, and caret-to-byte offset mapping makes no assumptions about the character length; also bounding box
 * glyph-to-offset mapping may be complex for languages which use ligatures.
 */

class ATKMM_API Text : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Text;
  using CppClassType = Text_Class;
  using BaseObjectType = AtkText;
  using BaseClassType = AtkTextIface;

  // noncopyable
  Text(const Text&) = delete;
  Text& operator=(const Text&) = delete;

private:
  friend class Text_Class;
  static CppClassType text_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Text();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit Text(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit Text(AtkText* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Text(Text&& src) noexcept;
  Text& operator=(Text&& src) noexcept;

  ~Text() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkText*       gobj()       { return reinterpret_cast<AtkText*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkText* gobj() const { return reinterpret_cast<AtkText*>(gobject_); }

private:


public:
  
  /** Gets the specified text.
   * 
   * @param start_offset Start position.
   * @param end_offset End position, or -1 for the end of the string.
   * @return A newly allocated string containing the text from @a start_offset up
   * to, but not including @a end_offset.
   */
  Glib::ustring get_text(int start_offset, int end_offset) const;
  
  /** Gets the specified text.
   * 
   * @param offset Position.
   * @return The character at @a offset.
   */
  gunichar get_character_at_offset(int offset) const;
  
#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets the specified text.
   * 
   * Deprecated: 2.9.3: Please use get_string_at_offset() instead.
   * 
   * @deprecated Use get_string_at_offset() instead.
   * 
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the
   * returned substring.
   * @return A newly allocated string containing the text after @a offset bounded
   * by the specified @a boundary_type.
   */
  Glib::ustring get_text_after_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
#endif // ATKMM_DISABLE_DEPRECATED


#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets the specified text.
   * 
   * If the boundary_type if ATK_TEXT_BOUNDARY_CHAR the character at the
   * offset is returned.
   * 
   * If the boundary_type is ATK_TEXT_BOUNDARY_WORD_START the returned string
   * is from the word start at or before the offset to the word start after
   * the offset.
   * 
   * The returned string will contain the word at the offset if the offset
   * is inside a word and will contain the word before the offset if the
   * offset is not inside a word.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_SENTENCE_START the returned
   * string is from the sentence start at or before the offset to the sentence
   * start after the offset.
   * 
   * The returned string will contain the sentence at the offset if the offset
   * is inside a sentence and will contain the sentence before the offset
   * if the offset is not inside a sentence.
   * 
   * If the boundary type is ATK_TEXT_BOUNDARY_LINE_START the returned
   * string is from the line start at or before the offset to the line
   * start after the offset.
   * 
   * Deprecated: This method is deprecated since ATK version
   * 2.9.4. Please use get_string_at_offset() instead.
   * 
   * @deprecated Use get_string_at_offset() instead.
   * 
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the
   * returned substring.
   * @return A newly allocated string containing the text at @a offset bounded by
   * the specified @a boundary_type.
   */
  Glib::ustring get_text_at_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
#endif // ATKMM_DISABLE_DEPRECATED


#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets the specified text.
   * 
   * Deprecated: 2.9.3: Please use get_string_at_offset() instead.
   * 
   * @deprecated Use get_string_at_offset() instead.
   * 
   * @param offset Position.
   * @param boundary_type An Atk::TextBoundary.
   * @param start_offset The start offset of the returned string.
   * @param end_offset The offset of the first character after the
   * returned substring.
   * @return A newly allocated string containing the text before @a offset bounded
   * by the specified @a boundary_type.
   */
  Glib::ustring get_text_before_offset(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;
#endif // ATKMM_DISABLE_DEPRECATED


  /** Gets a portion of the text exposed through an Atk::Text according to a given @a offset
   * and a specific @a granularity, along with the start and end offsets defining the
   * boundaries of such a portion of text.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_CHAR the character at the
   * offset is returned.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_WORD the returned string
   * is from the word start at or before the offset to the word start after
   * the offset.
   * 
   * The returned string will contain the word at the offset if the offset
   * is inside a word and will contain the word before the offset if the
   * offset is not inside a word.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_SENTENCE the returned string
   * is from the sentence start at or before the offset to the sentence
   * start after the offset.
   * 
   * The returned string will contain the sentence at the offset if the offset
   * is inside a sentence and will contain the sentence before the offset
   * if the offset is not inside a sentence.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_LINE the returned string
   * is from the line start at or before the offset to the line
   * start after the offset.
   * 
   * If @a granularity is ATK_TEXT_GRANULARITY_PARAGRAPH the returned string
   * is from the start of the paragraph at or before the offset to the start
   * of the following paragraph after the offset.
   * 
   * @newin{2,10}
   * 
   * @param offset Position.
   * @param granularity An Atk::TextGranularity.
   * @param start_offset The start offset of the returned string, or -1
   * if an error has occurred (e.g. invalid offset, not implemented).
   * @param end_offset The offset of the first character after the returned string,
   * or -1 if an error has occurred (e.g. invalid offset, not implemented).
   * @return A newly allocated string containing the text
   * at the @a offset bounded by the specified @a granularity.  Returns <tt>nullptr</tt> if the
   * offset is invalid or no implementation is available.
   */
  Glib::ustring get_string_at_offset(int offset, TextGranularity granularity, int& start_offset, int& end_offset);

  
  /** Gets the offset position of the caret (cursor).
   * 
   * @return The offset position of the caret (cursor).
   */
  int get_caret_offset() const;
  
  /** Get the bounding box containing the glyph representing the character at 
   * a particular text offset.
   * 
   * @param offset The offset of the text character for which bounding information is required.
   * @param x Pointer for the x cordinate of the bounding box.
   * @param y Pointer for the y cordinate of the bounding box.
   * @param width Pointer for the width of the bounding box.
   * @param height Pointer for the height of the bounding box.
   * @param coords Specify whether coordinates are relative to the screen or widget window.
   */
  void get_character_extents(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;
  
  /** Creates an Atk::AttributeSet which consists of the attributes explicitly
   * set at the position @a offset in the text. @a start_offset and @a end_offset are
   * set to the start and end of the range around @a offset where the attributes are
   * invariant. See the enum AtkTextAttribute for types of text attributes that
   * can be returned. Note that other attributes may also be returned.
   * 
   * @param offset The offset at which to get the attributes.
   * @param start_offset The address to put the start offset of the range.
   * @param end_offset The address to put the end offset of the range.
   * @return An Atk::AttributeSet which contains the attributes explicitly set
   * at @a offset.
   */
  AttributeSet get_run_attributes(int offset, int& start_offset, int& end_offset) const;
  
  /** Creates an Atk::AttributeSet which consists of the default values of
   * attributes for the text. See the enum AtkTextAttribute for types of text
   * attributes that can be returned. Note that other attributes may also be
   * returned.
   * 
   * @return An Atk::AttributeSet which contains the default values of attributes.
   * at @a offset.
   */
  AttributeSet get_default_attributes() const;
  
  /** Gets the character count.
   * 
   * @return The number of characters.
   */
  int get_character_count() const;
  
  /** Gets the offset of the character located at coordinates @a x and @a y. @a x and @a y
   * are interpreted as being relative to the screen or this widget's window
   * depending on @a coords.
   * 
   * @param x Screen x-position of character.
   * @param y Screen y-position of character.
   * @param coords Specify whether coordinates are relative to the screen or
   * widget window.
   * @return The offset to the character which is located at
   * the specified @a x and @a y coordinates.
   */
  int get_offset_at_point(int x, int y, CoordType coords) const;
  
  /** Gets the number of selected regions.
   * 
   * @return The number of selected regions, or -1 if a failure
   * occurred.
   */
  int get_n_selections() const;
  
  /** Gets the text from the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset Passes back the start position of the selected region.
   * @param end_offset Passes back the end position of (e.g. offset immediately past)
   * the selected region.
   * @return A newly allocated string containing the selected text.
   */
  Glib::ustring get_selection(int selection_num, int& start_offset, int& end_offset) const;
  
  /** Adds a selection bounded by the specified offsets.
   * 
   * @param start_offset The start position of the selected region.
   * @param end_offset The offset of the first character after the selected region.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool add_selection(int start_offset, int end_offset);
  
  /** Removes the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool remove_selection(int selection_num);
  
  /** Changes the start and end offset of the specified selection.
   * 
   * @param selection_num The selection number.  The selected regions are
   * assigned numbers that correspond to how far the region is from the
   * start of the text.  The selected region closest to the beginning
   * of the text region is assigned the number 0, etc.  Note that adding,
   * moving or deleting a selected region can change the numbering.
   * @param start_offset The new start position of the selection.
   * @param end_offset The new end position of (e.g. offset immediately past) 
   * the selection.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool set_selection(int selection_num, int start_offset, int end_offset);
  
  /** Sets the caret (cursor) position to the specified @a offset.
   * 
   * @param offset Position.
   * @return <tt>true</tt> if success, <tt>false</tt> otherwise.
   */
  bool set_caret_offset(int offset);
  
  typedef AtkTextRectangle Rectangle;
    
  
  /** Get the bounding box for text within the specified range.
   * 
   * @newin{1,3}
   * 
   * @param start_offset The offset of the first text character for which boundary 
   * information is required.
   * @param end_offset The offset of the text character after the last character 
   * for which boundary information is required.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param rect A pointer to a AtkTextRectangle which is filled in by this function.
   */
  void get_range_extents(int start_offset, int end_offset, CoordType coord_type, Rectangle& rect);
  
  /** Get the ranges of text in the specified bounding box.
   * 
   * @newin{1,3}
   * 
   * @param rect An AtkTextRectangle giving the dimensions of the bounding box.
   * @param coord_type Specify whether coordinates are relative to the screen or widget window.
   * @param x_clip_type Specify the horizontal clip type.
   * @param y_clip_type Specify the vertical clip type.
   * @return Array of AtkTextRange. The last
   * element of the array returned by this function will be <tt>nullptr</tt>.
   */
  AtkTextRange** get_bounded_ranges(const Rectangle& rect, CoordType coord_type, TextClipType x_clip_type, TextClipType y_clip_type);
                                                           

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_changed(int position, int length)</tt>
   *
   * Flags: Run Last
   *
   * The "text-changed" signal is emitted when the text of the
   * object which implements the AtkText interface changes, This
   * signal will have a detail which is either "insert" or
   * "delete" which identifies whether the text change was an
   * insertion or a deletion.
   * 
   * Deprecated: 2.9.4: Use Atk::Object::signal_text_insert() or
   * Atk::Object::signal_text_remove() instead.
   * 
   * @param position The position (character offset) of the insertion or deletion.
   * @param length The length (in characters) of text inserted or deleted.
   */

  Glib::SignalProxy< void,int,int > signal_text_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_caret_moved(int location)</tt>
   *
   * Flags: Run Last
   *
   * The "text-caret-moved" signal is emitted when the caret
   * position of the text of an object which implements AtkText
   * changes.
   * 
   * @param location The new position of the text caret.
   */

  Glib::SignalProxy< void,int > signal_text_caret_moved();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_selection_changed()</tt>
   *
   * Flags: Run Last
   *
   * The "text-selection-changed" signal is emitted when the
   * selected text of an object which implements AtkText changes.
   */

  Glib::SignalProxy< void > signal_text_selection_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%text_attributes_changed()</tt>
   *
   * Flags: Run Last
   *
   * The "text-attributes-changed" signal is emitted when the text
   * attributes of the text of an object which implements AtkText
   * changes.
   */

  Glib::SignalProxy< void > signal_text_attributes_changed();


protected:
 

    virtual Glib::ustring get_text_vfunc(int start_offset, int end_offset) const;

    virtual gunichar get_character_at_offset_vfunc(int offset) const;


  /** @deprecated This virtual function is deprecated and it should not be overridden.
   */
    virtual Glib::ustring get_text_after_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;


    virtual Glib::ustring get_text_at_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;


  /** @deprecated This virtual function is deprecated and it should not be overridden.
   */
    virtual Glib::ustring get_text_before_offset_vfunc(int offset, TextBoundary boundary_type, int& start_offset, int& end_offset) const;


    virtual int get_caret_offset_vfunc() const;

    virtual void get_character_extents_vfunc(int offset, int& x, int& y, int& width, int& height, CoordType coords) const;

    virtual AtkAttributeSet* get_run_attributes_vfunc(int offset, int& start_offset, int& end_offset) const;

    virtual AtkAttributeSet* get_default_attributes_vfunc() const;

    virtual int get_character_count_vfunc() const;

    virtual int get_offset_at_point_vfunc(int x, int y, CoordType coords) const;

    virtual int get_n_selections_vfunc() const;

    virtual Glib::ustring get_selection_vfunc(int selection_num, int& start_offset, int& end_offset) const;

    virtual bool add_selection_vfunc(int start_offset, int end_offset);

    virtual bool remove_selection_vfunc(int selection_num);

    virtual bool set_selection_vfunc(int selection_num, int start_offset, int end_offset);

    virtual bool set_caret_offset_vfunc(int offset);

  
  //TODO: Add get_range_extents(), and get_bounded_ranges() vfuncs when we can break ABI.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_text_changed().
  virtual void on_text_changed(int position, int length);
  /// This is a default handler for the signal signal_text_caret_moved().
  virtual void on_text_caret_moved(int location);
  /// This is a default handler for the signal signal_text_selection_changed().
  virtual void on_text_selection_changed();
  /// This is a default handler for the signal signal_text_attributes_changed().
  virtual void on_text_attributes_changed();


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Text
   */
  ATKMM_API
  Glib::RefPtr<Atk::Text> wrap(AtkText* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_TEXT_H */

