// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#![allow(non_camel_case_types, non_upper_case_globals, non_snake_case)]
#![allow(
    clippy::approx_constant,
    clippy::type_complexity,
    clippy::unreadable_literal
)]

extern crate glib_sys as glib;
extern crate gobject_sys as gobject;
extern crate libc;

#[allow(unused_imports)]
use libc::{
    c_char, c_double, c_float, c_int, c_long, c_short, c_uchar, c_uint, c_ulong, c_ushort, c_void,
    intptr_t, size_t, ssize_t, time_t, uintptr_t, FILE,
};

#[allow(unused_imports)]
use glib::{gboolean, gconstpointer, gpointer, GType};

// Aliases
pub type AtkAttributeSet = glib::GSList;
pub type AtkState = u64;

// Enums
pub type AtkCoordType = c_int;
pub const ATK_XY_SCREEN: AtkCoordType = 0;
pub const ATK_XY_WINDOW: AtkCoordType = 1;
pub const ATK_XY_PARENT: AtkCoordType = 2;

pub type AtkKeyEventType = c_int;
pub const ATK_KEY_EVENT_PRESS: AtkKeyEventType = 0;
pub const ATK_KEY_EVENT_RELEASE: AtkKeyEventType = 1;
pub const ATK_KEY_EVENT_LAST_DEFINED: AtkKeyEventType = 2;

pub type AtkLayer = c_int;
pub const ATK_LAYER_INVALID: AtkLayer = 0;
pub const ATK_LAYER_BACKGROUND: AtkLayer = 1;
pub const ATK_LAYER_CANVAS: AtkLayer = 2;
pub const ATK_LAYER_WIDGET: AtkLayer = 3;
pub const ATK_LAYER_MDI: AtkLayer = 4;
pub const ATK_LAYER_POPUP: AtkLayer = 5;
pub const ATK_LAYER_OVERLAY: AtkLayer = 6;
pub const ATK_LAYER_WINDOW: AtkLayer = 7;

pub type AtkRelationType = c_int;
pub const ATK_RELATION_NULL: AtkRelationType = 0;
pub const ATK_RELATION_CONTROLLED_BY: AtkRelationType = 1;
pub const ATK_RELATION_CONTROLLER_FOR: AtkRelationType = 2;
pub const ATK_RELATION_LABEL_FOR: AtkRelationType = 3;
pub const ATK_RELATION_LABELLED_BY: AtkRelationType = 4;
pub const ATK_RELATION_MEMBER_OF: AtkRelationType = 5;
pub const ATK_RELATION_NODE_CHILD_OF: AtkRelationType = 6;
pub const ATK_RELATION_FLOWS_TO: AtkRelationType = 7;
pub const ATK_RELATION_FLOWS_FROM: AtkRelationType = 8;
pub const ATK_RELATION_SUBWINDOW_OF: AtkRelationType = 9;
pub const ATK_RELATION_EMBEDS: AtkRelationType = 10;
pub const ATK_RELATION_EMBEDDED_BY: AtkRelationType = 11;
pub const ATK_RELATION_POPUP_FOR: AtkRelationType = 12;
pub const ATK_RELATION_PARENT_WINDOW_OF: AtkRelationType = 13;
pub const ATK_RELATION_DESCRIBED_BY: AtkRelationType = 14;
pub const ATK_RELATION_DESCRIPTION_FOR: AtkRelationType = 15;
pub const ATK_RELATION_NODE_PARENT_OF: AtkRelationType = 16;
pub const ATK_RELATION_DETAILS: AtkRelationType = 17;
pub const ATK_RELATION_DETAILS_FOR: AtkRelationType = 18;
pub const ATK_RELATION_ERROR_MESSAGE: AtkRelationType = 19;
pub const ATK_RELATION_ERROR_FOR: AtkRelationType = 20;
pub const ATK_RELATION_LAST_DEFINED: AtkRelationType = 21;

pub type AtkRole = c_int;
pub const ATK_ROLE_INVALID: AtkRole = 0;
pub const ATK_ROLE_ACCEL_LABEL: AtkRole = 1;
pub const ATK_ROLE_ALERT: AtkRole = 2;
pub const ATK_ROLE_ANIMATION: AtkRole = 3;
pub const ATK_ROLE_ARROW: AtkRole = 4;
pub const ATK_ROLE_CALENDAR: AtkRole = 5;
pub const ATK_ROLE_CANVAS: AtkRole = 6;
pub const ATK_ROLE_CHECK_BOX: AtkRole = 7;
pub const ATK_ROLE_CHECK_MENU_ITEM: AtkRole = 8;
pub const ATK_ROLE_COLOR_CHOOSER: AtkRole = 9;
pub const ATK_ROLE_COLUMN_HEADER: AtkRole = 10;
pub const ATK_ROLE_COMBO_BOX: AtkRole = 11;
pub const ATK_ROLE_DATE_EDITOR: AtkRole = 12;
pub const ATK_ROLE_DESKTOP_ICON: AtkRole = 13;
pub const ATK_ROLE_DESKTOP_FRAME: AtkRole = 14;
pub const ATK_ROLE_DIAL: AtkRole = 15;
pub const ATK_ROLE_DIALOG: AtkRole = 16;
pub const ATK_ROLE_DIRECTORY_PANE: AtkRole = 17;
pub const ATK_ROLE_DRAWING_AREA: AtkRole = 18;
pub const ATK_ROLE_FILE_CHOOSER: AtkRole = 19;
pub const ATK_ROLE_FILLER: AtkRole = 20;
pub const ATK_ROLE_FONT_CHOOSER: AtkRole = 21;
pub const ATK_ROLE_FRAME: AtkRole = 22;
pub const ATK_ROLE_GLASS_PANE: AtkRole = 23;
pub const ATK_ROLE_HTML_CONTAINER: AtkRole = 24;
pub const ATK_ROLE_ICON: AtkRole = 25;
pub const ATK_ROLE_IMAGE: AtkRole = 26;
pub const ATK_ROLE_INTERNAL_FRAME: AtkRole = 27;
pub const ATK_ROLE_LABEL: AtkRole = 28;
pub const ATK_ROLE_LAYERED_PANE: AtkRole = 29;
pub const ATK_ROLE_LIST: AtkRole = 30;
pub const ATK_ROLE_LIST_ITEM: AtkRole = 31;
pub const ATK_ROLE_MENU: AtkRole = 32;
pub const ATK_ROLE_MENU_BAR: AtkRole = 33;
pub const ATK_ROLE_MENU_ITEM: AtkRole = 34;
pub const ATK_ROLE_OPTION_PANE: AtkRole = 35;
pub const ATK_ROLE_PAGE_TAB: AtkRole = 36;
pub const ATK_ROLE_PAGE_TAB_LIST: AtkRole = 37;
pub const ATK_ROLE_PANEL: AtkRole = 38;
pub const ATK_ROLE_PASSWORD_TEXT: AtkRole = 39;
pub const ATK_ROLE_POPUP_MENU: AtkRole = 40;
pub const ATK_ROLE_PROGRESS_BAR: AtkRole = 41;
pub const ATK_ROLE_PUSH_BUTTON: AtkRole = 42;
pub const ATK_ROLE_RADIO_BUTTON: AtkRole = 43;
pub const ATK_ROLE_RADIO_MENU_ITEM: AtkRole = 44;
pub const ATK_ROLE_ROOT_PANE: AtkRole = 45;
pub const ATK_ROLE_ROW_HEADER: AtkRole = 46;
pub const ATK_ROLE_SCROLL_BAR: AtkRole = 47;
pub const ATK_ROLE_SCROLL_PANE: AtkRole = 48;
pub const ATK_ROLE_SEPARATOR: AtkRole = 49;
pub const ATK_ROLE_SLIDER: AtkRole = 50;
pub const ATK_ROLE_SPLIT_PANE: AtkRole = 51;
pub const ATK_ROLE_SPIN_BUTTON: AtkRole = 52;
pub const ATK_ROLE_STATUSBAR: AtkRole = 53;
pub const ATK_ROLE_TABLE: AtkRole = 54;
pub const ATK_ROLE_TABLE_CELL: AtkRole = 55;
pub const ATK_ROLE_TABLE_COLUMN_HEADER: AtkRole = 56;
pub const ATK_ROLE_TABLE_ROW_HEADER: AtkRole = 57;
pub const ATK_ROLE_TEAR_OFF_MENU_ITEM: AtkRole = 58;
pub const ATK_ROLE_TERMINAL: AtkRole = 59;
pub const ATK_ROLE_TEXT: AtkRole = 60;
pub const ATK_ROLE_TOGGLE_BUTTON: AtkRole = 61;
pub const ATK_ROLE_TOOL_BAR: AtkRole = 62;
pub const ATK_ROLE_TOOL_TIP: AtkRole = 63;
pub const ATK_ROLE_TREE: AtkRole = 64;
pub const ATK_ROLE_TREE_TABLE: AtkRole = 65;
pub const ATK_ROLE_UNKNOWN: AtkRole = 66;
pub const ATK_ROLE_VIEWPORT: AtkRole = 67;
pub const ATK_ROLE_WINDOW: AtkRole = 68;
pub const ATK_ROLE_HEADER: AtkRole = 69;
pub const ATK_ROLE_FOOTER: AtkRole = 70;
pub const ATK_ROLE_PARAGRAPH: AtkRole = 71;
pub const ATK_ROLE_RULER: AtkRole = 72;
pub const ATK_ROLE_APPLICATION: AtkRole = 73;
pub const ATK_ROLE_AUTOCOMPLETE: AtkRole = 74;
pub const ATK_ROLE_EDITBAR: AtkRole = 75;
pub const ATK_ROLE_EMBEDDED: AtkRole = 76;
pub const ATK_ROLE_ENTRY: AtkRole = 77;
pub const ATK_ROLE_CHART: AtkRole = 78;
pub const ATK_ROLE_CAPTION: AtkRole = 79;
pub const ATK_ROLE_DOCUMENT_FRAME: AtkRole = 80;
pub const ATK_ROLE_HEADING: AtkRole = 81;
pub const ATK_ROLE_PAGE: AtkRole = 82;
pub const ATK_ROLE_SECTION: AtkRole = 83;
pub const ATK_ROLE_REDUNDANT_OBJECT: AtkRole = 84;
pub const ATK_ROLE_FORM: AtkRole = 85;
pub const ATK_ROLE_LINK: AtkRole = 86;
pub const ATK_ROLE_INPUT_METHOD_WINDOW: AtkRole = 87;
pub const ATK_ROLE_TABLE_ROW: AtkRole = 88;
pub const ATK_ROLE_TREE_ITEM: AtkRole = 89;
pub const ATK_ROLE_DOCUMENT_SPREADSHEET: AtkRole = 90;
pub const ATK_ROLE_DOCUMENT_PRESENTATION: AtkRole = 91;
pub const ATK_ROLE_DOCUMENT_TEXT: AtkRole = 92;
pub const ATK_ROLE_DOCUMENT_WEB: AtkRole = 93;
pub const ATK_ROLE_DOCUMENT_EMAIL: AtkRole = 94;
pub const ATK_ROLE_COMMENT: AtkRole = 95;
pub const ATK_ROLE_LIST_BOX: AtkRole = 96;
pub const ATK_ROLE_GROUPING: AtkRole = 97;
pub const ATK_ROLE_IMAGE_MAP: AtkRole = 98;
pub const ATK_ROLE_NOTIFICATION: AtkRole = 99;
pub const ATK_ROLE_INFO_BAR: AtkRole = 100;
pub const ATK_ROLE_LEVEL_BAR: AtkRole = 101;
pub const ATK_ROLE_TITLE_BAR: AtkRole = 102;
pub const ATK_ROLE_BLOCK_QUOTE: AtkRole = 103;
pub const ATK_ROLE_AUDIO: AtkRole = 104;
pub const ATK_ROLE_VIDEO: AtkRole = 105;
pub const ATK_ROLE_DEFINITION: AtkRole = 106;
pub const ATK_ROLE_ARTICLE: AtkRole = 107;
pub const ATK_ROLE_LANDMARK: AtkRole = 108;
pub const ATK_ROLE_LOG: AtkRole = 109;
pub const ATK_ROLE_MARQUEE: AtkRole = 110;
pub const ATK_ROLE_MATH: AtkRole = 111;
pub const ATK_ROLE_RATING: AtkRole = 112;
pub const ATK_ROLE_TIMER: AtkRole = 113;
pub const ATK_ROLE_DESCRIPTION_LIST: AtkRole = 114;
pub const ATK_ROLE_DESCRIPTION_TERM: AtkRole = 115;
pub const ATK_ROLE_DESCRIPTION_VALUE: AtkRole = 116;
pub const ATK_ROLE_STATIC: AtkRole = 117;
pub const ATK_ROLE_MATH_FRACTION: AtkRole = 118;
pub const ATK_ROLE_MATH_ROOT: AtkRole = 119;
pub const ATK_ROLE_SUBSCRIPT: AtkRole = 120;
pub const ATK_ROLE_SUPERSCRIPT: AtkRole = 121;
pub const ATK_ROLE_FOOTNOTE: AtkRole = 122;
pub const ATK_ROLE_CONTENT_DELETION: AtkRole = 123;
pub const ATK_ROLE_CONTENT_INSERTION: AtkRole = 124;
pub const ATK_ROLE_LAST_DEFINED: AtkRole = 125;

pub type AtkScrollType = c_int;
pub const ATK_SCROLL_TOP_LEFT: AtkScrollType = 0;
pub const ATK_SCROLL_BOTTOM_RIGHT: AtkScrollType = 1;
pub const ATK_SCROLL_TOP_EDGE: AtkScrollType = 2;
pub const ATK_SCROLL_BOTTOM_EDGE: AtkScrollType = 3;
pub const ATK_SCROLL_LEFT_EDGE: AtkScrollType = 4;
pub const ATK_SCROLL_RIGHT_EDGE: AtkScrollType = 5;
pub const ATK_SCROLL_ANYWHERE: AtkScrollType = 6;

pub type AtkStateType = c_int;
pub const ATK_STATE_INVALID: AtkStateType = 0;
pub const ATK_STATE_ACTIVE: AtkStateType = 1;
pub const ATK_STATE_ARMED: AtkStateType = 2;
pub const ATK_STATE_BUSY: AtkStateType = 3;
pub const ATK_STATE_CHECKED: AtkStateType = 4;
pub const ATK_STATE_DEFUNCT: AtkStateType = 5;
pub const ATK_STATE_EDITABLE: AtkStateType = 6;
pub const ATK_STATE_ENABLED: AtkStateType = 7;
pub const ATK_STATE_EXPANDABLE: AtkStateType = 8;
pub const ATK_STATE_EXPANDED: AtkStateType = 9;
pub const ATK_STATE_FOCUSABLE: AtkStateType = 10;
pub const ATK_STATE_FOCUSED: AtkStateType = 11;
pub const ATK_STATE_HORIZONTAL: AtkStateType = 12;
pub const ATK_STATE_ICONIFIED: AtkStateType = 13;
pub const ATK_STATE_MODAL: AtkStateType = 14;
pub const ATK_STATE_MULTI_LINE: AtkStateType = 15;
pub const ATK_STATE_MULTISELECTABLE: AtkStateType = 16;
pub const ATK_STATE_OPAQUE: AtkStateType = 17;
pub const ATK_STATE_PRESSED: AtkStateType = 18;
pub const ATK_STATE_RESIZABLE: AtkStateType = 19;
pub const ATK_STATE_SELECTABLE: AtkStateType = 20;
pub const ATK_STATE_SELECTED: AtkStateType = 21;
pub const ATK_STATE_SENSITIVE: AtkStateType = 22;
pub const ATK_STATE_SHOWING: AtkStateType = 23;
pub const ATK_STATE_SINGLE_LINE: AtkStateType = 24;
pub const ATK_STATE_STALE: AtkStateType = 25;
pub const ATK_STATE_TRANSIENT: AtkStateType = 26;
pub const ATK_STATE_VERTICAL: AtkStateType = 27;
pub const ATK_STATE_VISIBLE: AtkStateType = 28;
pub const ATK_STATE_MANAGES_DESCENDANTS: AtkStateType = 29;
pub const ATK_STATE_INDETERMINATE: AtkStateType = 30;
pub const ATK_STATE_TRUNCATED: AtkStateType = 31;
pub const ATK_STATE_REQUIRED: AtkStateType = 32;
pub const ATK_STATE_INVALID_ENTRY: AtkStateType = 33;
pub const ATK_STATE_SUPPORTS_AUTOCOMPLETION: AtkStateType = 34;
pub const ATK_STATE_SELECTABLE_TEXT: AtkStateType = 35;
pub const ATK_STATE_DEFAULT: AtkStateType = 36;
pub const ATK_STATE_ANIMATED: AtkStateType = 37;
pub const ATK_STATE_VISITED: AtkStateType = 38;
pub const ATK_STATE_CHECKABLE: AtkStateType = 39;
pub const ATK_STATE_HAS_POPUP: AtkStateType = 40;
pub const ATK_STATE_HAS_TOOLTIP: AtkStateType = 41;
pub const ATK_STATE_READ_ONLY: AtkStateType = 42;
pub const ATK_STATE_LAST_DEFINED: AtkStateType = 43;

pub type AtkTextAttribute = c_int;
pub const ATK_TEXT_ATTR_INVALID: AtkTextAttribute = 0;
pub const ATK_TEXT_ATTR_LEFT_MARGIN: AtkTextAttribute = 1;
pub const ATK_TEXT_ATTR_RIGHT_MARGIN: AtkTextAttribute = 2;
pub const ATK_TEXT_ATTR_INDENT: AtkTextAttribute = 3;
pub const ATK_TEXT_ATTR_INVISIBLE: AtkTextAttribute = 4;
pub const ATK_TEXT_ATTR_EDITABLE: AtkTextAttribute = 5;
pub const ATK_TEXT_ATTR_PIXELS_ABOVE_LINES: AtkTextAttribute = 6;
pub const ATK_TEXT_ATTR_PIXELS_BELOW_LINES: AtkTextAttribute = 7;
pub const ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP: AtkTextAttribute = 8;
pub const ATK_TEXT_ATTR_BG_FULL_HEIGHT: AtkTextAttribute = 9;
pub const ATK_TEXT_ATTR_RISE: AtkTextAttribute = 10;
pub const ATK_TEXT_ATTR_UNDERLINE: AtkTextAttribute = 11;
pub const ATK_TEXT_ATTR_STRIKETHROUGH: AtkTextAttribute = 12;
pub const ATK_TEXT_ATTR_SIZE: AtkTextAttribute = 13;
pub const ATK_TEXT_ATTR_SCALE: AtkTextAttribute = 14;
pub const ATK_TEXT_ATTR_WEIGHT: AtkTextAttribute = 15;
pub const ATK_TEXT_ATTR_LANGUAGE: AtkTextAttribute = 16;
pub const ATK_TEXT_ATTR_FAMILY_NAME: AtkTextAttribute = 17;
pub const ATK_TEXT_ATTR_BG_COLOR: AtkTextAttribute = 18;
pub const ATK_TEXT_ATTR_FG_COLOR: AtkTextAttribute = 19;
pub const ATK_TEXT_ATTR_BG_STIPPLE: AtkTextAttribute = 20;
pub const ATK_TEXT_ATTR_FG_STIPPLE: AtkTextAttribute = 21;
pub const ATK_TEXT_ATTR_WRAP_MODE: AtkTextAttribute = 22;
pub const ATK_TEXT_ATTR_DIRECTION: AtkTextAttribute = 23;
pub const ATK_TEXT_ATTR_JUSTIFICATION: AtkTextAttribute = 24;
pub const ATK_TEXT_ATTR_STRETCH: AtkTextAttribute = 25;
pub const ATK_TEXT_ATTR_VARIANT: AtkTextAttribute = 26;
pub const ATK_TEXT_ATTR_STYLE: AtkTextAttribute = 27;
pub const ATK_TEXT_ATTR_LAST_DEFINED: AtkTextAttribute = 28;

pub type AtkTextBoundary = c_int;
pub const ATK_TEXT_BOUNDARY_CHAR: AtkTextBoundary = 0;
pub const ATK_TEXT_BOUNDARY_WORD_START: AtkTextBoundary = 1;
pub const ATK_TEXT_BOUNDARY_WORD_END: AtkTextBoundary = 2;
pub const ATK_TEXT_BOUNDARY_SENTENCE_START: AtkTextBoundary = 3;
pub const ATK_TEXT_BOUNDARY_SENTENCE_END: AtkTextBoundary = 4;
pub const ATK_TEXT_BOUNDARY_LINE_START: AtkTextBoundary = 5;
pub const ATK_TEXT_BOUNDARY_LINE_END: AtkTextBoundary = 6;

pub type AtkTextClipType = c_int;
pub const ATK_TEXT_CLIP_NONE: AtkTextClipType = 0;
pub const ATK_TEXT_CLIP_MIN: AtkTextClipType = 1;
pub const ATK_TEXT_CLIP_MAX: AtkTextClipType = 2;
pub const ATK_TEXT_CLIP_BOTH: AtkTextClipType = 3;

pub type AtkTextGranularity = c_int;
pub const ATK_TEXT_GRANULARITY_CHAR: AtkTextGranularity = 0;
pub const ATK_TEXT_GRANULARITY_WORD: AtkTextGranularity = 1;
pub const ATK_TEXT_GRANULARITY_SENTENCE: AtkTextGranularity = 2;
pub const ATK_TEXT_GRANULARITY_LINE: AtkTextGranularity = 3;
pub const ATK_TEXT_GRANULARITY_PARAGRAPH: AtkTextGranularity = 4;

pub type AtkValueType = c_int;
pub const ATK_VALUE_VERY_WEAK: AtkValueType = 0;
pub const ATK_VALUE_WEAK: AtkValueType = 1;
pub const ATK_VALUE_ACCEPTABLE: AtkValueType = 2;
pub const ATK_VALUE_STRONG: AtkValueType = 3;
pub const ATK_VALUE_VERY_STRONG: AtkValueType = 4;
pub const ATK_VALUE_VERY_LOW: AtkValueType = 5;
pub const ATK_VALUE_LOW: AtkValueType = 6;
pub const ATK_VALUE_MEDIUM: AtkValueType = 7;
pub const ATK_VALUE_HIGH: AtkValueType = 8;
pub const ATK_VALUE_VERY_HIGH: AtkValueType = 9;
pub const ATK_VALUE_VERY_BAD: AtkValueType = 10;
pub const ATK_VALUE_BAD: AtkValueType = 11;
pub const ATK_VALUE_GOOD: AtkValueType = 12;
pub const ATK_VALUE_VERY_GOOD: AtkValueType = 13;
pub const ATK_VALUE_BEST: AtkValueType = 14;
pub const ATK_VALUE_LAST_DEFINED: AtkValueType = 15;

// Constants

// Flags
pub type AtkHyperlinkStateFlags = c_uint;
pub const ATK_HYPERLINK_IS_INLINE: AtkHyperlinkStateFlags = 1;

// Callbacks
pub type AtkEventListener = Option<unsafe extern "C" fn(*mut AtkObject)>;
pub type AtkEventListenerInit = Option<unsafe extern "C" fn()>;
pub type AtkFocusHandler = Option<unsafe extern "C" fn(*mut AtkObject, gboolean)>;
pub type AtkFunction = Option<unsafe extern "C" fn(gpointer) -> gboolean>;
pub type AtkKeySnoopFunc = Option<unsafe extern "C" fn(*mut AtkKeyEventStruct, gpointer) -> c_int>;
pub type AtkPropertyChangeHandler =
    Option<unsafe extern "C" fn(*mut AtkObject, *mut AtkPropertyValues)>;

// Records
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkActionIface {
    pub parent: gobject::GTypeInterface,
    pub do_action: Option<unsafe extern "C" fn(*mut AtkAction, c_int) -> gboolean>,
    pub get_n_actions: Option<unsafe extern "C" fn(*mut AtkAction) -> c_int>,
    pub get_description: Option<unsafe extern "C" fn(*mut AtkAction, c_int) -> *const c_char>,
    pub get_name: Option<unsafe extern "C" fn(*mut AtkAction, c_int) -> *const c_char>,
    pub get_keybinding: Option<unsafe extern "C" fn(*mut AtkAction, c_int) -> *const c_char>,
    pub set_description:
        Option<unsafe extern "C" fn(*mut AtkAction, c_int, *const c_char) -> gboolean>,
    pub get_localized_name: Option<unsafe extern "C" fn(*mut AtkAction, c_int) -> *const c_char>,
}

impl ::std::fmt::Debug for AtkActionIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkActionIface @ {:?}", self as *const _))
            .field("do_action", &self.do_action)
            .field("get_n_actions", &self.get_n_actions)
            .field("get_description", &self.get_description)
            .field("get_name", &self.get_name)
            .field("get_keybinding", &self.get_keybinding)
            .field("set_description", &self.set_description)
            .field("get_localized_name", &self.get_localized_name)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkAttribute {
    pub name: *mut c_char,
    pub value: *mut c_char,
}

impl ::std::fmt::Debug for AtkAttribute {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkAttribute @ {:?}", self as *const _))
            .field("name", &self.name)
            .field("value", &self.value)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkComponentIface {
    pub parent: gobject::GTypeInterface,
    pub add_focus_handler:
        Option<unsafe extern "C" fn(*mut AtkComponent, AtkFocusHandler) -> c_uint>,
    pub contains:
        Option<unsafe extern "C" fn(*mut AtkComponent, c_int, c_int, AtkCoordType) -> gboolean>,
    pub ref_accessible_at_point: Option<
        unsafe extern "C" fn(*mut AtkComponent, c_int, c_int, AtkCoordType) -> *mut AtkObject,
    >,
    pub get_extents: Option<
        unsafe extern "C" fn(
            *mut AtkComponent,
            *mut c_int,
            *mut c_int,
            *mut c_int,
            *mut c_int,
            AtkCoordType,
        ),
    >,
    pub get_position:
        Option<unsafe extern "C" fn(*mut AtkComponent, *mut c_int, *mut c_int, AtkCoordType)>,
    pub get_size: Option<unsafe extern "C" fn(*mut AtkComponent, *mut c_int, *mut c_int)>,
    pub grab_focus: Option<unsafe extern "C" fn(*mut AtkComponent) -> gboolean>,
    pub remove_focus_handler: Option<unsafe extern "C" fn(*mut AtkComponent, c_uint)>,
    pub set_extents: Option<
        unsafe extern "C" fn(
            *mut AtkComponent,
            c_int,
            c_int,
            c_int,
            c_int,
            AtkCoordType,
        ) -> gboolean,
    >,
    pub set_position:
        Option<unsafe extern "C" fn(*mut AtkComponent, c_int, c_int, AtkCoordType) -> gboolean>,
    pub set_size: Option<unsafe extern "C" fn(*mut AtkComponent, c_int, c_int) -> gboolean>,
    pub get_layer: Option<unsafe extern "C" fn(*mut AtkComponent) -> AtkLayer>,
    pub get_mdi_zorder: Option<unsafe extern "C" fn(*mut AtkComponent) -> c_int>,
    pub bounds_changed: Option<unsafe extern "C" fn(*mut AtkComponent, *mut AtkRectangle)>,
    pub get_alpha: Option<unsafe extern "C" fn(*mut AtkComponent) -> c_double>,
    pub scroll_to: Option<unsafe extern "C" fn(*mut AtkComponent, AtkScrollType) -> gboolean>,
    pub scroll_to_point:
        Option<unsafe extern "C" fn(*mut AtkComponent, AtkCoordType, c_int, c_int) -> gboolean>,
}

impl ::std::fmt::Debug for AtkComponentIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkComponentIface @ {:?}", self as *const _))
            .field("add_focus_handler", &self.add_focus_handler)
            .field("contains", &self.contains)
            .field("ref_accessible_at_point", &self.ref_accessible_at_point)
            .field("get_extents", &self.get_extents)
            .field("get_position", &self.get_position)
            .field("get_size", &self.get_size)
            .field("grab_focus", &self.grab_focus)
            .field("remove_focus_handler", &self.remove_focus_handler)
            .field("set_extents", &self.set_extents)
            .field("set_position", &self.set_position)
            .field("set_size", &self.set_size)
            .field("get_layer", &self.get_layer)
            .field("get_mdi_zorder", &self.get_mdi_zorder)
            .field("bounds_changed", &self.bounds_changed)
            .field("get_alpha", &self.get_alpha)
            .field("scroll_to", &self.scroll_to)
            .field("scroll_to_point", &self.scroll_to_point)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkDocumentIface {
    pub parent: gobject::GTypeInterface,
    pub get_document_type: Option<unsafe extern "C" fn(*mut AtkDocument) -> *const c_char>,
    pub get_document: Option<unsafe extern "C" fn(*mut AtkDocument) -> gpointer>,
    pub get_document_locale: Option<unsafe extern "C" fn(*mut AtkDocument) -> *const c_char>,
    pub get_document_attributes:
        Option<unsafe extern "C" fn(*mut AtkDocument) -> *mut AtkAttributeSet>,
    pub get_document_attribute_value:
        Option<unsafe extern "C" fn(*mut AtkDocument, *const c_char) -> *const c_char>,
    pub set_document_attribute:
        Option<unsafe extern "C" fn(*mut AtkDocument, *const c_char, *const c_char) -> gboolean>,
    pub get_current_page_number: Option<unsafe extern "C" fn(*mut AtkDocument) -> c_int>,
    pub get_page_count: Option<unsafe extern "C" fn(*mut AtkDocument) -> c_int>,
}

impl ::std::fmt::Debug for AtkDocumentIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkDocumentIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_document_type", &self.get_document_type)
            .field("get_document", &self.get_document)
            .field("get_document_locale", &self.get_document_locale)
            .field("get_document_attributes", &self.get_document_attributes)
            .field(
                "get_document_attribute_value",
                &self.get_document_attribute_value,
            )
            .field("set_document_attribute", &self.set_document_attribute)
            .field("get_current_page_number", &self.get_current_page_number)
            .field("get_page_count", &self.get_page_count)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkEditableTextIface {
    pub parent_interface: gobject::GTypeInterface,
    pub set_run_attributes: Option<
        unsafe extern "C" fn(*mut AtkEditableText, *mut AtkAttributeSet, c_int, c_int) -> gboolean,
    >,
    pub set_text_contents: Option<unsafe extern "C" fn(*mut AtkEditableText, *const c_char)>,
    pub insert_text:
        Option<unsafe extern "C" fn(*mut AtkEditableText, *const c_char, c_int, *mut c_int)>,
    pub copy_text: Option<unsafe extern "C" fn(*mut AtkEditableText, c_int, c_int)>,
    pub cut_text: Option<unsafe extern "C" fn(*mut AtkEditableText, c_int, c_int)>,
    pub delete_text: Option<unsafe extern "C" fn(*mut AtkEditableText, c_int, c_int)>,
    pub paste_text: Option<unsafe extern "C" fn(*mut AtkEditableText, c_int)>,
}

impl ::std::fmt::Debug for AtkEditableTextIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkEditableTextIface @ {:?}", self as *const _))
            .field("parent_interface", &self.parent_interface)
            .field("set_run_attributes", &self.set_run_attributes)
            .field("set_text_contents", &self.set_text_contents)
            .field("insert_text", &self.insert_text)
            .field("copy_text", &self.copy_text)
            .field("cut_text", &self.cut_text)
            .field("delete_text", &self.delete_text)
            .field("paste_text", &self.paste_text)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkGObjectAccessibleClass {
    pub parent_class: AtkObjectClass,
    pub pad1: AtkFunction,
    pub pad2: AtkFunction,
}

impl ::std::fmt::Debug for AtkGObjectAccessibleClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!(
            "AtkGObjectAccessibleClass @ {:?}",
            self as *const _
        ))
        .field("parent_class", &self.parent_class)
        .field("pad1", &self.pad1)
        .field("pad2", &self.pad2)
        .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkHyperlinkClass {
    pub parent: gobject::GObjectClass,
    pub get_uri: Option<unsafe extern "C" fn(*mut AtkHyperlink, c_int) -> *mut c_char>,
    pub get_object: Option<unsafe extern "C" fn(*mut AtkHyperlink, c_int) -> *mut AtkObject>,
    pub get_end_index: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> c_int>,
    pub get_start_index: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> c_int>,
    pub is_valid: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> gboolean>,
    pub get_n_anchors: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> c_int>,
    pub link_state: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> c_uint>,
    pub is_selected_link: Option<unsafe extern "C" fn(*mut AtkHyperlink) -> gboolean>,
    pub link_activated: Option<unsafe extern "C" fn(*mut AtkHyperlink)>,
    pub pad1: AtkFunction,
}

impl ::std::fmt::Debug for AtkHyperlinkClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkHyperlinkClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_uri", &self.get_uri)
            .field("get_object", &self.get_object)
            .field("get_end_index", &self.get_end_index)
            .field("get_start_index", &self.get_start_index)
            .field("is_valid", &self.is_valid)
            .field("get_n_anchors", &self.get_n_anchors)
            .field("link_state", &self.link_state)
            .field("is_selected_link", &self.is_selected_link)
            .field("link_activated", &self.link_activated)
            .field("pad1", &self.pad1)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkHyperlinkImplIface {
    pub parent: gobject::GTypeInterface,
    pub get_hyperlink: Option<unsafe extern "C" fn(*mut AtkHyperlinkImpl) -> *mut AtkHyperlink>,
}

impl ::std::fmt::Debug for AtkHyperlinkImplIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkHyperlinkImplIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_hyperlink", &self.get_hyperlink)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkHypertextIface {
    pub parent: gobject::GTypeInterface,
    pub get_link: Option<unsafe extern "C" fn(*mut AtkHypertext, c_int) -> *mut AtkHyperlink>,
    pub get_n_links: Option<unsafe extern "C" fn(*mut AtkHypertext) -> c_int>,
    pub get_link_index: Option<unsafe extern "C" fn(*mut AtkHypertext, c_int) -> c_int>,
    pub link_selected: Option<unsafe extern "C" fn(*mut AtkHypertext, c_int)>,
}

impl ::std::fmt::Debug for AtkHypertextIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkHypertextIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_link", &self.get_link)
            .field("get_n_links", &self.get_n_links)
            .field("get_link_index", &self.get_link_index)
            .field("link_selected", &self.link_selected)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkImageIface {
    pub parent: gobject::GTypeInterface,
    pub get_image_position:
        Option<unsafe extern "C" fn(*mut AtkImage, *mut c_int, *mut c_int, AtkCoordType)>,
    pub get_image_description: Option<unsafe extern "C" fn(*mut AtkImage) -> *const c_char>,
    pub get_image_size: Option<unsafe extern "C" fn(*mut AtkImage, *mut c_int, *mut c_int)>,
    pub set_image_description:
        Option<unsafe extern "C" fn(*mut AtkImage, *const c_char) -> gboolean>,
    pub get_image_locale: Option<unsafe extern "C" fn(*mut AtkImage) -> *const c_char>,
}

impl ::std::fmt::Debug for AtkImageIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkImageIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_image_position", &self.get_image_position)
            .field("get_image_description", &self.get_image_description)
            .field("get_image_size", &self.get_image_size)
            .field("set_image_description", &self.set_image_description)
            .field("get_image_locale", &self.get_image_locale)
            .finish()
    }
}

#[repr(C)]
pub struct _AtkImplementor(c_void);

pub type AtkImplementor = *mut _AtkImplementor;

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkKeyEventStruct {
    pub type_: c_int,
    pub state: c_uint,
    pub keyval: c_uint,
    pub length: c_int,
    pub string: *mut c_char,
    pub keycode: u16,
    pub timestamp: u32,
}

impl ::std::fmt::Debug for AtkKeyEventStruct {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkKeyEventStruct @ {:?}", self as *const _))
            .field("type_", &self.type_)
            .field("state", &self.state)
            .field("keyval", &self.keyval)
            .field("length", &self.length)
            .field("string", &self.string)
            .field("keycode", &self.keycode)
            .field("timestamp", &self.timestamp)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkMiscClass {
    pub parent: gobject::GObjectClass,
    pub threads_enter: Option<unsafe extern "C" fn(*mut AtkMisc)>,
    pub threads_leave: Option<unsafe extern "C" fn(*mut AtkMisc)>,
    pub vfuncs: [gpointer; 32],
}

impl ::std::fmt::Debug for AtkMiscClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkMiscClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("threads_enter", &self.threads_enter)
            .field("threads_leave", &self.threads_leave)
            .field("vfuncs", &self.vfuncs)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkNoOpObjectClass {
    pub parent_class: AtkObjectClass,
}

impl ::std::fmt::Debug for AtkNoOpObjectClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkNoOpObjectClass @ {:?}", self as *const _))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkNoOpObjectFactoryClass {
    pub parent_class: AtkObjectFactoryClass,
}

impl ::std::fmt::Debug for AtkNoOpObjectFactoryClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!(
            "AtkNoOpObjectFactoryClass @ {:?}",
            self as *const _
        ))
        .field("parent_class", &self.parent_class)
        .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkObjectClass {
    pub parent: gobject::GObjectClass,
    pub get_name: Option<unsafe extern "C" fn(*mut AtkObject) -> *const c_char>,
    pub get_description: Option<unsafe extern "C" fn(*mut AtkObject) -> *const c_char>,
    pub get_parent: Option<unsafe extern "C" fn(*mut AtkObject) -> *mut AtkObject>,
    pub get_n_children: Option<unsafe extern "C" fn(*mut AtkObject) -> c_int>,
    pub ref_child: Option<unsafe extern "C" fn(*mut AtkObject, c_int) -> *mut AtkObject>,
    pub get_index_in_parent: Option<unsafe extern "C" fn(*mut AtkObject) -> c_int>,
    pub ref_relation_set: Option<unsafe extern "C" fn(*mut AtkObject) -> *mut AtkRelationSet>,
    pub get_role: Option<unsafe extern "C" fn(*mut AtkObject) -> AtkRole>,
    pub get_layer: Option<unsafe extern "C" fn(*mut AtkObject) -> AtkLayer>,
    pub get_mdi_zorder: Option<unsafe extern "C" fn(*mut AtkObject) -> c_int>,
    pub ref_state_set: Option<unsafe extern "C" fn(*mut AtkObject) -> *mut AtkStateSet>,
    pub set_name: Option<unsafe extern "C" fn(*mut AtkObject, *const c_char)>,
    pub set_description: Option<unsafe extern "C" fn(*mut AtkObject, *const c_char)>,
    pub set_parent: Option<unsafe extern "C" fn(*mut AtkObject, *mut AtkObject)>,
    pub set_role: Option<unsafe extern "C" fn(*mut AtkObject, AtkRole)>,
    pub connect_property_change_handler:
        Option<unsafe extern "C" fn(*mut AtkObject, *mut AtkPropertyChangeHandler) -> c_uint>,
    pub remove_property_change_handler: Option<unsafe extern "C" fn(*mut AtkObject, c_uint)>,
    pub initialize: Option<unsafe extern "C" fn(*mut AtkObject, *mut gpointer)>,
    pub children_changed: Option<unsafe extern "C" fn(*mut AtkObject, c_uint, gpointer)>,
    pub focus_event: Option<unsafe extern "C" fn(*mut AtkObject, gboolean)>,
    pub property_change: Option<unsafe extern "C" fn(*mut AtkObject, *mut AtkPropertyValues)>,
    pub state_change: Option<unsafe extern "C" fn(*mut AtkObject, *const c_char, gboolean)>,
    pub visible_data_changed: Option<unsafe extern "C" fn(*mut AtkObject)>,
    pub active_descendant_changed: Option<unsafe extern "C" fn(*mut AtkObject, *mut gpointer)>,
    pub get_attributes: Option<unsafe extern "C" fn(*mut AtkObject) -> *mut AtkAttributeSet>,
    pub get_object_locale: Option<unsafe extern "C" fn(*mut AtkObject) -> *const c_char>,
    pub pad1: AtkFunction,
}

impl ::std::fmt::Debug for AtkObjectClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkObjectClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_name", &self.get_name)
            .field("get_description", &self.get_description)
            .field("get_parent", &self.get_parent)
            .field("get_n_children", &self.get_n_children)
            .field("ref_child", &self.ref_child)
            .field("get_index_in_parent", &self.get_index_in_parent)
            .field("ref_relation_set", &self.ref_relation_set)
            .field("get_role", &self.get_role)
            .field("get_layer", &self.get_layer)
            .field("get_mdi_zorder", &self.get_mdi_zorder)
            .field("ref_state_set", &self.ref_state_set)
            .field("set_name", &self.set_name)
            .field("set_description", &self.set_description)
            .field("set_parent", &self.set_parent)
            .field("set_role", &self.set_role)
            .field(
                "connect_property_change_handler",
                &self.connect_property_change_handler,
            )
            .field(
                "remove_property_change_handler",
                &self.remove_property_change_handler,
            )
            .field("initialize", &self.initialize)
            .field("children_changed", &self.children_changed)
            .field("focus_event", &self.focus_event)
            .field("property_change", &self.property_change)
            .field("state_change", &self.state_change)
            .field("visible_data_changed", &self.visible_data_changed)
            .field("active_descendant_changed", &self.active_descendant_changed)
            .field("get_attributes", &self.get_attributes)
            .field("get_object_locale", &self.get_object_locale)
            .field("pad1", &self.pad1)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkObjectFactoryClass {
    pub parent_class: gobject::GObjectClass,
    pub create_accessible: Option<unsafe extern "C" fn(*mut gobject::GObject) -> *mut AtkObject>,
    pub invalidate: Option<unsafe extern "C" fn(*mut AtkObjectFactory)>,
    pub get_accessible_type: Option<unsafe extern "C" fn() -> GType>,
    pub pad1: AtkFunction,
    pub pad2: AtkFunction,
}

impl ::std::fmt::Debug for AtkObjectFactoryClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkObjectFactoryClass @ {:?}", self as *const _))
            .field("parent_class", &self.parent_class)
            .field("create_accessible", &self.create_accessible)
            .field("invalidate", &self.invalidate)
            .field("get_accessible_type", &self.get_accessible_type)
            .field("pad1", &self.pad1)
            .field("pad2", &self.pad2)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkPlugClass {
    pub parent_class: AtkObjectClass,
    pub get_object_id: Option<unsafe extern "C" fn(*mut AtkPlug) -> *mut c_char>,
}

impl ::std::fmt::Debug for AtkPlugClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkPlugClass @ {:?}", self as *const _))
            .field("parent_class", &self.parent_class)
            .field("get_object_id", &self.get_object_id)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkPropertyValues {
    pub property_name: *const c_char,
    pub old_value: gobject::GValue,
    pub new_value: gobject::GValue,
}

impl ::std::fmt::Debug for AtkPropertyValues {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkPropertyValues @ {:?}", self as *const _))
            .field("property_name", &self.property_name)
            .field("old_value", &self.old_value)
            .field("new_value", &self.new_value)
            .finish()
    }
}

#[repr(C)]
pub struct AtkRange(c_void);

impl ::std::fmt::Debug for AtkRange {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRange @ {:?}", self as *const _))
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRectangle {
    pub x: c_int,
    pub y: c_int,
    pub width: c_int,
    pub height: c_int,
}

impl ::std::fmt::Debug for AtkRectangle {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRectangle @ {:?}", self as *const _))
            .field("x", &self.x)
            .field("y", &self.y)
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRegistryClass {
    pub parent_class: gobject::GObjectClass,
}

impl ::std::fmt::Debug for AtkRegistryClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRegistryClass @ {:?}", self as *const _))
            .field("parent_class", &self.parent_class)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRelationClass {
    pub parent: gobject::GObjectClass,
}

impl ::std::fmt::Debug for AtkRelationClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRelationClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRelationSetClass {
    pub parent: gobject::GObjectClass,
    pub pad1: AtkFunction,
    pub pad2: AtkFunction,
}

impl ::std::fmt::Debug for AtkRelationSetClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRelationSetClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("pad1", &self.pad1)
            .field("pad2", &self.pad2)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkSelectionIface {
    pub parent: gobject::GTypeInterface,
    pub add_selection: Option<unsafe extern "C" fn(*mut AtkSelection, c_int) -> gboolean>,
    pub clear_selection: Option<unsafe extern "C" fn(*mut AtkSelection) -> gboolean>,
    pub ref_selection: Option<unsafe extern "C" fn(*mut AtkSelection, c_int) -> *mut AtkObject>,
    pub get_selection_count: Option<unsafe extern "C" fn(*mut AtkSelection) -> c_int>,
    pub is_child_selected: Option<unsafe extern "C" fn(*mut AtkSelection, c_int) -> gboolean>,
    pub remove_selection: Option<unsafe extern "C" fn(*mut AtkSelection, c_int) -> gboolean>,
    pub select_all_selection: Option<unsafe extern "C" fn(*mut AtkSelection) -> gboolean>,
    pub selection_changed: Option<unsafe extern "C" fn(*mut AtkSelection)>,
}

impl ::std::fmt::Debug for AtkSelectionIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkSelectionIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("add_selection", &self.add_selection)
            .field("clear_selection", &self.clear_selection)
            .field("ref_selection", &self.ref_selection)
            .field("get_selection_count", &self.get_selection_count)
            .field("is_child_selected", &self.is_child_selected)
            .field("remove_selection", &self.remove_selection)
            .field("select_all_selection", &self.select_all_selection)
            .field("selection_changed", &self.selection_changed)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkSocketClass {
    pub parent_class: AtkObjectClass,
    pub embed: Option<unsafe extern "C" fn(*mut AtkSocket, *const c_char)>,
}

impl ::std::fmt::Debug for AtkSocketClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkSocketClass @ {:?}", self as *const _))
            .field("parent_class", &self.parent_class)
            .field("embed", &self.embed)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkStateSetClass {
    pub parent: gobject::GObjectClass,
}

impl ::std::fmt::Debug for AtkStateSetClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkStateSetClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkStreamableContentIface {
    pub parent: gobject::GTypeInterface,
    pub get_n_mime_types: Option<unsafe extern "C" fn(*mut AtkStreamableContent) -> c_int>,
    pub get_mime_type:
        Option<unsafe extern "C" fn(*mut AtkStreamableContent, c_int) -> *const c_char>,
    pub get_stream: Option<
        unsafe extern "C" fn(*mut AtkStreamableContent, *const c_char) -> *mut glib::GIOChannel,
    >,
    pub get_uri:
        Option<unsafe extern "C" fn(*mut AtkStreamableContent, *const c_char) -> *const c_char>,
    pub pad1: AtkFunction,
    pub pad2: AtkFunction,
    pub pad3: AtkFunction,
}

impl ::std::fmt::Debug for AtkStreamableContentIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!(
            "AtkStreamableContentIface @ {:?}",
            self as *const _
        ))
        .field("parent", &self.parent)
        .field("get_n_mime_types", &self.get_n_mime_types)
        .field("get_mime_type", &self.get_mime_type)
        .field("get_stream", &self.get_stream)
        .field("get_uri", &self.get_uri)
        .field("pad1", &self.pad1)
        .field("pad2", &self.pad2)
        .field("pad3", &self.pad3)
        .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkTableCellIface {
    pub parent: gobject::GTypeInterface,
    pub get_column_span: Option<unsafe extern "C" fn(*mut AtkTableCell) -> c_int>,
    pub get_column_header_cells:
        Option<unsafe extern "C" fn(*mut AtkTableCell) -> *mut glib::GPtrArray>,
    pub get_position:
        Option<unsafe extern "C" fn(*mut AtkTableCell, *mut c_int, *mut c_int) -> gboolean>,
    pub get_row_span: Option<unsafe extern "C" fn(*mut AtkTableCell) -> c_int>,
    pub get_row_header_cells:
        Option<unsafe extern "C" fn(*mut AtkTableCell) -> *mut glib::GPtrArray>,
    pub get_row_column_span: Option<
        unsafe extern "C" fn(
            *mut AtkTableCell,
            *mut c_int,
            *mut c_int,
            *mut c_int,
            *mut c_int,
        ) -> gboolean,
    >,
    pub get_table: Option<unsafe extern "C" fn(*mut AtkTableCell) -> *mut AtkObject>,
}

impl ::std::fmt::Debug for AtkTableCellIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkTableCellIface @ {:?}", self as *const _))
            .field("get_column_span", &self.get_column_span)
            .field("get_column_header_cells", &self.get_column_header_cells)
            .field("get_position", &self.get_position)
            .field("get_row_span", &self.get_row_span)
            .field("get_row_header_cells", &self.get_row_header_cells)
            .field("get_row_column_span", &self.get_row_column_span)
            .field("get_table", &self.get_table)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkTableIface {
    pub parent: gobject::GTypeInterface,
    pub ref_at: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int) -> *mut AtkObject>,
    pub get_index_at: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int) -> c_int>,
    pub get_column_at_index: Option<unsafe extern "C" fn(*mut AtkTable, *mut *mut c_int) -> c_int>,
    pub get_row_at_index: Option<unsafe extern "C" fn(*mut AtkTable, *mut *mut c_int) -> c_int>,
    pub get_n_columns: Option<unsafe extern "C" fn(*mut AtkTable) -> c_int>,
    pub get_n_rows: Option<unsafe extern "C" fn(*mut AtkTable) -> c_int>,
    pub get_column_extent_at: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int) -> c_int>,
    pub get_row_extent_at: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int) -> c_int>,
    pub get_caption: Option<unsafe extern "C" fn(*mut AtkTable) -> *mut AtkObject>,
    pub get_column_description: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> *const c_char>,
    pub get_column_header: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> *mut AtkObject>,
    pub get_row_description: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> *const c_char>,
    pub get_row_header: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> *mut AtkObject>,
    pub get_summary: Option<unsafe extern "C" fn(*mut AtkTable) -> *mut AtkObject>,
    pub set_caption: Option<unsafe extern "C" fn(*mut AtkTable, *mut AtkObject)>,
    pub set_column_description: Option<unsafe extern "C" fn(*mut AtkTable, c_int, *const c_char)>,
    pub set_column_header: Option<unsafe extern "C" fn(*mut AtkTable, c_int, *mut AtkObject)>,
    pub set_row_description: Option<unsafe extern "C" fn(*mut AtkTable, c_int, *const c_char)>,
    pub set_row_header: Option<unsafe extern "C" fn(*mut AtkTable, c_int, *mut AtkObject)>,
    pub set_summary: Option<unsafe extern "C" fn(*mut AtkTable, *mut AtkObject)>,
    pub get_selected_columns: Option<unsafe extern "C" fn(*mut AtkTable, *mut *mut c_int) -> c_int>,
    pub get_selected_rows: Option<unsafe extern "C" fn(*mut AtkTable, *mut *mut c_int) -> c_int>,
    pub is_column_selected: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub is_row_selected: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub is_selected: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int) -> gboolean>,
    pub add_row_selection: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub remove_row_selection: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub add_column_selection: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub remove_column_selection: Option<unsafe extern "C" fn(*mut AtkTable, c_int) -> gboolean>,
    pub row_inserted: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int)>,
    pub column_inserted: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int)>,
    pub row_deleted: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int)>,
    pub column_deleted: Option<unsafe extern "C" fn(*mut AtkTable, c_int, c_int)>,
    pub row_reordered: Option<unsafe extern "C" fn(*mut AtkTable)>,
    pub column_reordered: Option<unsafe extern "C" fn(*mut AtkTable)>,
    pub model_changed: Option<unsafe extern "C" fn(*mut AtkTable)>,
}

impl ::std::fmt::Debug for AtkTableIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkTableIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("ref_at", &self.ref_at)
            .field("get_index_at", &self.get_index_at)
            .field("get_column_at_index", &self.get_column_at_index)
            .field("get_row_at_index", &self.get_row_at_index)
            .field("get_n_columns", &self.get_n_columns)
            .field("get_n_rows", &self.get_n_rows)
            .field("get_column_extent_at", &self.get_column_extent_at)
            .field("get_row_extent_at", &self.get_row_extent_at)
            .field("get_caption", &self.get_caption)
            .field("get_column_description", &self.get_column_description)
            .field("get_column_header", &self.get_column_header)
            .field("get_row_description", &self.get_row_description)
            .field("get_row_header", &self.get_row_header)
            .field("get_summary", &self.get_summary)
            .field("set_caption", &self.set_caption)
            .field("set_column_description", &self.set_column_description)
            .field("set_column_header", &self.set_column_header)
            .field("set_row_description", &self.set_row_description)
            .field("set_row_header", &self.set_row_header)
            .field("set_summary", &self.set_summary)
            .field("get_selected_columns", &self.get_selected_columns)
            .field("get_selected_rows", &self.get_selected_rows)
            .field("is_column_selected", &self.is_column_selected)
            .field("is_row_selected", &self.is_row_selected)
            .field("is_selected", &self.is_selected)
            .field("add_row_selection", &self.add_row_selection)
            .field("remove_row_selection", &self.remove_row_selection)
            .field("add_column_selection", &self.add_column_selection)
            .field("remove_column_selection", &self.remove_column_selection)
            .field("row_inserted", &self.row_inserted)
            .field("column_inserted", &self.column_inserted)
            .field("row_deleted", &self.row_deleted)
            .field("column_deleted", &self.column_deleted)
            .field("row_reordered", &self.row_reordered)
            .field("column_reordered", &self.column_reordered)
            .field("model_changed", &self.model_changed)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkTextIface {
    pub parent: gobject::GTypeInterface,
    pub get_text: Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int) -> *mut c_char>,
    pub get_text_after_offset: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            c_int,
            AtkTextBoundary,
            *mut c_int,
            *mut c_int,
        ) -> *mut c_char,
    >,
    pub get_text_at_offset: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            c_int,
            AtkTextBoundary,
            *mut c_int,
            *mut c_int,
        ) -> *mut c_char,
    >,
    pub get_character_at_offset: Option<unsafe extern "C" fn(*mut AtkText, c_int) -> u32>,
    pub get_text_before_offset: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            c_int,
            AtkTextBoundary,
            *mut c_int,
            *mut c_int,
        ) -> *mut c_char,
    >,
    pub get_caret_offset: Option<unsafe extern "C" fn(*mut AtkText) -> c_int>,
    pub get_run_attributes: Option<
        unsafe extern "C" fn(*mut AtkText, c_int, *mut c_int, *mut c_int) -> *mut AtkAttributeSet,
    >,
    pub get_default_attributes: Option<unsafe extern "C" fn(*mut AtkText) -> *mut AtkAttributeSet>,
    pub get_character_extents: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            c_int,
            *mut c_int,
            *mut c_int,
            *mut c_int,
            *mut c_int,
            AtkCoordType,
        ),
    >,
    pub get_character_count: Option<unsafe extern "C" fn(*mut AtkText) -> c_int>,
    pub get_offset_at_point:
        Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int, AtkCoordType) -> c_int>,
    pub get_n_selections: Option<unsafe extern "C" fn(*mut AtkText) -> c_int>,
    pub get_selection:
        Option<unsafe extern "C" fn(*mut AtkText, c_int, *mut c_int, *mut c_int) -> *mut c_char>,
    pub add_selection: Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int) -> gboolean>,
    pub remove_selection: Option<unsafe extern "C" fn(*mut AtkText, c_int) -> gboolean>,
    pub set_selection: Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int, c_int) -> gboolean>,
    pub set_caret_offset: Option<unsafe extern "C" fn(*mut AtkText, c_int) -> gboolean>,
    pub text_changed: Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int)>,
    pub text_caret_moved: Option<unsafe extern "C" fn(*mut AtkText, c_int)>,
    pub text_selection_changed: Option<unsafe extern "C" fn(*mut AtkText)>,
    pub text_attributes_changed: Option<unsafe extern "C" fn(*mut AtkText)>,
    pub get_range_extents: Option<
        unsafe extern "C" fn(*mut AtkText, c_int, c_int, AtkCoordType, *mut AtkTextRectangle),
    >,
    pub get_bounded_ranges: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            *mut AtkTextRectangle,
            AtkCoordType,
            AtkTextClipType,
            AtkTextClipType,
        ) -> *mut *mut AtkTextRange,
    >,
    pub get_string_at_offset: Option<
        unsafe extern "C" fn(
            *mut AtkText,
            c_int,
            AtkTextGranularity,
            *mut c_int,
            *mut c_int,
        ) -> *mut c_char,
    >,
    pub scroll_substring_to:
        Option<unsafe extern "C" fn(*mut AtkText, c_int, c_int, AtkScrollType) -> gboolean>,
    pub scroll_substring_to_point: Option<
        unsafe extern "C" fn(*mut AtkText, c_int, c_int, AtkCoordType, c_int, c_int) -> gboolean,
    >,
}

impl ::std::fmt::Debug for AtkTextIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkTextIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_text", &self.get_text)
            .field("get_text_after_offset", &self.get_text_after_offset)
            .field("get_text_at_offset", &self.get_text_at_offset)
            .field("get_character_at_offset", &self.get_character_at_offset)
            .field("get_text_before_offset", &self.get_text_before_offset)
            .field("get_caret_offset", &self.get_caret_offset)
            .field("get_run_attributes", &self.get_run_attributes)
            .field("get_default_attributes", &self.get_default_attributes)
            .field("get_character_extents", &self.get_character_extents)
            .field("get_character_count", &self.get_character_count)
            .field("get_offset_at_point", &self.get_offset_at_point)
            .field("get_n_selections", &self.get_n_selections)
            .field("get_selection", &self.get_selection)
            .field("add_selection", &self.add_selection)
            .field("remove_selection", &self.remove_selection)
            .field("set_selection", &self.set_selection)
            .field("set_caret_offset", &self.set_caret_offset)
            .field("text_changed", &self.text_changed)
            .field("text_caret_moved", &self.text_caret_moved)
            .field("text_selection_changed", &self.text_selection_changed)
            .field("text_attributes_changed", &self.text_attributes_changed)
            .field("get_range_extents", &self.get_range_extents)
            .field("get_bounded_ranges", &self.get_bounded_ranges)
            .field("get_string_at_offset", &self.get_string_at_offset)
            .field("scroll_substring_to", &self.scroll_substring_to)
            .field("scroll_substring_to_point", &self.scroll_substring_to_point)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkTextRange {
    pub bounds: AtkTextRectangle,
    pub start_offset: c_int,
    pub end_offset: c_int,
    pub content: *mut c_char,
}

impl ::std::fmt::Debug for AtkTextRange {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkTextRange @ {:?}", self as *const _))
            .field("bounds", &self.bounds)
            .field("start_offset", &self.start_offset)
            .field("end_offset", &self.end_offset)
            .field("content", &self.content)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkTextRectangle {
    pub x: c_int,
    pub y: c_int,
    pub width: c_int,
    pub height: c_int,
}

impl ::std::fmt::Debug for AtkTextRectangle {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkTextRectangle @ {:?}", self as *const _))
            .field("x", &self.x)
            .field("y", &self.y)
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkUtilClass {
    pub parent: gobject::GObjectClass,
    pub add_global_event_listener:
        Option<unsafe extern "C" fn(gobject::GSignalEmissionHook, *const c_char) -> c_uint>,
    pub remove_global_event_listener: Option<unsafe extern "C" fn(c_uint)>,
    pub add_key_event_listener: Option<unsafe extern "C" fn(AtkKeySnoopFunc, gpointer) -> c_uint>,
    pub remove_key_event_listener: Option<unsafe extern "C" fn(c_uint)>,
    pub get_root: Option<unsafe extern "C" fn() -> *mut AtkObject>,
    pub get_toolkit_name: Option<unsafe extern "C" fn() -> *const c_char>,
    pub get_toolkit_version: Option<unsafe extern "C" fn() -> *const c_char>,
}

impl ::std::fmt::Debug for AtkUtilClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkUtilClass @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("add_global_event_listener", &self.add_global_event_listener)
            .field(
                "remove_global_event_listener",
                &self.remove_global_event_listener,
            )
            .field("add_key_event_listener", &self.add_key_event_listener)
            .field("remove_key_event_listener", &self.remove_key_event_listener)
            .field("get_root", &self.get_root)
            .field("get_toolkit_name", &self.get_toolkit_name)
            .field("get_toolkit_version", &self.get_toolkit_version)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkValueIface {
    pub parent: gobject::GTypeInterface,
    pub get_current_value: Option<unsafe extern "C" fn(*mut AtkValue, *mut gobject::GValue)>,
    pub get_maximum_value: Option<unsafe extern "C" fn(*mut AtkValue, *mut gobject::GValue)>,
    pub get_minimum_value: Option<unsafe extern "C" fn(*mut AtkValue, *mut gobject::GValue)>,
    pub set_current_value:
        Option<unsafe extern "C" fn(*mut AtkValue, *const gobject::GValue) -> gboolean>,
    pub get_minimum_increment: Option<unsafe extern "C" fn(*mut AtkValue, *mut gobject::GValue)>,
    pub get_value_and_text:
        Option<unsafe extern "C" fn(*mut AtkValue, *mut c_double, *mut *mut c_char)>,
    pub get_range: Option<unsafe extern "C" fn(*mut AtkValue) -> *mut AtkRange>,
    pub get_increment: Option<unsafe extern "C" fn(*mut AtkValue) -> c_double>,
    pub get_sub_ranges: Option<unsafe extern "C" fn(*mut AtkValue) -> *mut glib::GSList>,
    pub set_value: Option<unsafe extern "C" fn(*mut AtkValue, c_double)>,
}

impl ::std::fmt::Debug for AtkValueIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkValueIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("get_current_value", &self.get_current_value)
            .field("get_maximum_value", &self.get_maximum_value)
            .field("get_minimum_value", &self.get_minimum_value)
            .field("set_current_value", &self.set_current_value)
            .field("get_minimum_increment", &self.get_minimum_increment)
            .field("get_value_and_text", &self.get_value_and_text)
            .field("get_range", &self.get_range)
            .field("get_increment", &self.get_increment)
            .field("get_sub_ranges", &self.get_sub_ranges)
            .field("set_value", &self.set_value)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkWindowIface {
    pub parent: gobject::GTypeInterface,
}

impl ::std::fmt::Debug for AtkWindowIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkWindowIface @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

// Classes
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkGObjectAccessible {
    pub parent: AtkObject,
}

impl ::std::fmt::Debug for AtkGObjectAccessible {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkGObjectAccessible @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkHyperlink {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for AtkHyperlink {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkHyperlink @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkMisc {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for AtkMisc {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkMisc @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkNoOpObject {
    pub parent: AtkObject,
}

impl ::std::fmt::Debug for AtkNoOpObject {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkNoOpObject @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkNoOpObjectFactory {
    pub parent: AtkObjectFactory,
}

impl ::std::fmt::Debug for AtkNoOpObjectFactory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkNoOpObjectFactory @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkObject {
    pub parent: gobject::GObject,
    pub description: *mut c_char,
    pub name: *mut c_char,
    pub accessible_parent: *mut AtkObject,
    pub role: AtkRole,
    pub relation_set: *mut AtkRelationSet,
    pub layer: AtkLayer,
}

impl ::std::fmt::Debug for AtkObject {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkObject @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("description", &self.description)
            .field("name", &self.name)
            .field("accessible_parent", &self.accessible_parent)
            .field("role", &self.role)
            .field("relation_set", &self.relation_set)
            .field("layer", &self.layer)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkObjectFactory {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for AtkObjectFactory {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkObjectFactory @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkPlug {
    pub parent: AtkObject,
}

impl ::std::fmt::Debug for AtkPlug {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkPlug @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRegistry {
    pub parent: gobject::GObject,
    pub factory_type_registry: *mut glib::GHashTable,
    pub factory_singleton_cache: *mut glib::GHashTable,
}

impl ::std::fmt::Debug for AtkRegistry {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRegistry @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("factory_type_registry", &self.factory_type_registry)
            .field("factory_singleton_cache", &self.factory_singleton_cache)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRelation {
    pub parent: gobject::GObject,
    pub target: *mut glib::GPtrArray,
    pub relationship: AtkRelationType,
}

impl ::std::fmt::Debug for AtkRelation {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRelation @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("target", &self.target)
            .field("relationship", &self.relationship)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkRelationSet {
    pub parent: gobject::GObject,
    pub relations: *mut glib::GPtrArray,
}

impl ::std::fmt::Debug for AtkRelationSet {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkRelationSet @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .field("relations", &self.relations)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkSocket {
    pub parent: AtkObject,
    pub embedded_plug_id: *mut c_char,
}

impl ::std::fmt::Debug for AtkSocket {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkSocket @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkStateSet {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for AtkStateSet {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkStateSet @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct AtkUtil {
    pub parent: gobject::GObject,
}

impl ::std::fmt::Debug for AtkUtil {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        f.debug_struct(&format!("AtkUtil @ {:?}", self as *const _))
            .field("parent", &self.parent)
            .finish()
    }
}

// Interfaces
#[repr(C)]
pub struct AtkAction(c_void);

impl ::std::fmt::Debug for AtkAction {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkAction @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkComponent(c_void);

impl ::std::fmt::Debug for AtkComponent {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkComponent @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkDocument(c_void);

impl ::std::fmt::Debug for AtkDocument {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkDocument @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkEditableText(c_void);

impl ::std::fmt::Debug for AtkEditableText {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkEditableText @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkHyperlinkImpl(c_void);

impl ::std::fmt::Debug for AtkHyperlinkImpl {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkHyperlinkImpl @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkHypertext(c_void);

impl ::std::fmt::Debug for AtkHypertext {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkHypertext @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkImage(c_void);

impl ::std::fmt::Debug for AtkImage {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkImage @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkImplementorIface(c_void);

impl ::std::fmt::Debug for AtkImplementorIface {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkImplementorIface @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkSelection(c_void);

impl ::std::fmt::Debug for AtkSelection {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkSelection @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkStreamableContent(c_void);

impl ::std::fmt::Debug for AtkStreamableContent {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkStreamableContent @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkTable(c_void);

impl ::std::fmt::Debug for AtkTable {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkTable @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkTableCell(c_void);

impl ::std::fmt::Debug for AtkTableCell {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkTableCell @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkText(c_void);

impl ::std::fmt::Debug for AtkText {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkText @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkValue(c_void);

impl ::std::fmt::Debug for AtkValue {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkValue @ {:?}", self as *const _)
    }
}

#[repr(C)]
pub struct AtkWindow(c_void);

impl ::std::fmt::Debug for AtkWindow {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "AtkWindow @ {:?}", self as *const _)
    }
}

extern "C" {

    //=========================================================================
    // AtkCoordType
    //=========================================================================
    pub fn atk_coord_type_get_type() -> GType;

    //=========================================================================
    // AtkKeyEventType
    //=========================================================================
    pub fn atk_key_event_type_get_type() -> GType;

    //=========================================================================
    // AtkLayer
    //=========================================================================
    pub fn atk_layer_get_type() -> GType;

    //=========================================================================
    // AtkRelationType
    //=========================================================================
    pub fn atk_relation_type_get_type() -> GType;
    pub fn atk_relation_type_for_name(name: *const c_char) -> AtkRelationType;
    pub fn atk_relation_type_get_name(type_: AtkRelationType) -> *const c_char;
    pub fn atk_relation_type_register(name: *const c_char) -> AtkRelationType;

    //=========================================================================
    // AtkRole
    //=========================================================================
    pub fn atk_role_get_type() -> GType;
    pub fn atk_role_for_name(name: *const c_char) -> AtkRole;
    pub fn atk_role_get_localized_name(role: AtkRole) -> *const c_char;
    pub fn atk_role_get_name(role: AtkRole) -> *const c_char;
    pub fn atk_role_register(name: *const c_char) -> AtkRole;

    //=========================================================================
    // AtkScrollType
    //=========================================================================
    #[cfg(any(feature = "v2_30", feature = "dox"))]
    pub fn atk_scroll_type_get_type() -> GType;

    //=========================================================================
    // AtkStateType
    //=========================================================================
    pub fn atk_state_type_get_type() -> GType;
    pub fn atk_state_type_for_name(name: *const c_char) -> AtkStateType;
    pub fn atk_state_type_get_name(type_: AtkStateType) -> *const c_char;
    pub fn atk_state_type_register(name: *const c_char) -> AtkStateType;

    //=========================================================================
    // AtkTextAttribute
    //=========================================================================
    pub fn atk_text_attribute_get_type() -> GType;
    pub fn atk_text_attribute_for_name(name: *const c_char) -> AtkTextAttribute;
    pub fn atk_text_attribute_get_name(attr: AtkTextAttribute) -> *const c_char;
    pub fn atk_text_attribute_get_value(attr: AtkTextAttribute, index_: c_int) -> *const c_char;
    pub fn atk_text_attribute_register(name: *const c_char) -> AtkTextAttribute;

    //=========================================================================
    // AtkTextBoundary
    //=========================================================================
    pub fn atk_text_boundary_get_type() -> GType;

    //=========================================================================
    // AtkTextClipType
    //=========================================================================
    pub fn atk_text_clip_type_get_type() -> GType;

    //=========================================================================
    // AtkTextGranularity
    //=========================================================================
    pub fn atk_text_granularity_get_type() -> GType;

    //=========================================================================
    // AtkValueType
    //=========================================================================
    pub fn atk_value_type_get_type() -> GType;
    pub fn atk_value_type_get_localized_name(value_type: AtkValueType) -> *const c_char;
    pub fn atk_value_type_get_name(value_type: AtkValueType) -> *const c_char;

    //=========================================================================
    // AtkHyperlinkStateFlags
    //=========================================================================
    pub fn atk_hyperlink_state_flags_get_type() -> GType;

    //=========================================================================
    // AtkAttribute
    //=========================================================================
    pub fn atk_attribute_set_free(attrib_set: *mut AtkAttributeSet);

    //=========================================================================
    // AtkImplementor
    //=========================================================================
    pub fn atk_implementor_ref_accessible(implementor: *mut AtkImplementor) -> *mut AtkObject;

    //=========================================================================
    // AtkRange
    //=========================================================================
    pub fn atk_range_get_type() -> GType;
    pub fn atk_range_new(
        lower_limit: c_double,
        upper_limit: c_double,
        description: *const c_char,
    ) -> *mut AtkRange;
    pub fn atk_range_copy(src: *mut AtkRange) -> *mut AtkRange;
    pub fn atk_range_free(range: *mut AtkRange);
    pub fn atk_range_get_description(range: *mut AtkRange) -> *const c_char;
    pub fn atk_range_get_lower_limit(range: *mut AtkRange) -> c_double;
    pub fn atk_range_get_upper_limit(range: *mut AtkRange) -> c_double;

    //=========================================================================
    // AtkRectangle
    //=========================================================================
    pub fn atk_rectangle_get_type() -> GType;

    //=========================================================================
    // AtkTextRange
    //=========================================================================
    pub fn atk_text_range_get_type() -> GType;

    //=========================================================================
    // AtkGObjectAccessible
    //=========================================================================
    pub fn atk_gobject_accessible_get_type() -> GType;
    pub fn atk_gobject_accessible_for_object(obj: *mut gobject::GObject) -> *mut AtkObject;
    pub fn atk_gobject_accessible_get_object(
        obj: *mut AtkGObjectAccessible,
    ) -> *mut gobject::GObject;

    //=========================================================================
    // AtkHyperlink
    //=========================================================================
    pub fn atk_hyperlink_get_type() -> GType;
    pub fn atk_hyperlink_get_end_index(link_: *mut AtkHyperlink) -> c_int;
    pub fn atk_hyperlink_get_n_anchors(link_: *mut AtkHyperlink) -> c_int;
    pub fn atk_hyperlink_get_object(link_: *mut AtkHyperlink, i: c_int) -> *mut AtkObject;
    pub fn atk_hyperlink_get_start_index(link_: *mut AtkHyperlink) -> c_int;
    pub fn atk_hyperlink_get_uri(link_: *mut AtkHyperlink, i: c_int) -> *mut c_char;
    pub fn atk_hyperlink_is_inline(link_: *mut AtkHyperlink) -> gboolean;
    pub fn atk_hyperlink_is_selected_link(link_: *mut AtkHyperlink) -> gboolean;
    pub fn atk_hyperlink_is_valid(link_: *mut AtkHyperlink) -> gboolean;

    //=========================================================================
    // AtkMisc
    //=========================================================================
    pub fn atk_misc_get_type() -> GType;
    pub fn atk_misc_get_instance() -> *const AtkMisc;
    pub fn atk_misc_threads_enter(misc: *mut AtkMisc);
    pub fn atk_misc_threads_leave(misc: *mut AtkMisc);

    //=========================================================================
    // AtkNoOpObject
    //=========================================================================
    pub fn atk_no_op_object_get_type() -> GType;
    pub fn atk_no_op_object_new(obj: *mut gobject::GObject) -> *mut AtkObject;

    //=========================================================================
    // AtkNoOpObjectFactory
    //=========================================================================
    pub fn atk_no_op_object_factory_get_type() -> GType;
    pub fn atk_no_op_object_factory_new() -> *mut AtkObjectFactory;

    //=========================================================================
    // AtkObject
    //=========================================================================
    pub fn atk_object_get_type() -> GType;
    pub fn atk_object_add_relationship(
        object: *mut AtkObject,
        relationship: AtkRelationType,
        target: *mut AtkObject,
    ) -> gboolean;
    pub fn atk_object_connect_property_change_handler(
        accessible: *mut AtkObject,
        handler: *mut AtkPropertyChangeHandler,
    ) -> c_uint;
    #[cfg(any(feature = "v2_34", feature = "dox"))]
    pub fn atk_object_get_accessible_id(accessible: *mut AtkObject) -> *const c_char;
    pub fn atk_object_get_attributes(accessible: *mut AtkObject) -> *mut AtkAttributeSet;
    pub fn atk_object_get_description(accessible: *mut AtkObject) -> *const c_char;
    pub fn atk_object_get_index_in_parent(accessible: *mut AtkObject) -> c_int;
    pub fn atk_object_get_layer(accessible: *mut AtkObject) -> AtkLayer;
    pub fn atk_object_get_mdi_zorder(accessible: *mut AtkObject) -> c_int;
    pub fn atk_object_get_n_accessible_children(accessible: *mut AtkObject) -> c_int;
    pub fn atk_object_get_name(accessible: *mut AtkObject) -> *const c_char;
    pub fn atk_object_get_object_locale(accessible: *mut AtkObject) -> *const c_char;
    pub fn atk_object_get_parent(accessible: *mut AtkObject) -> *mut AtkObject;
    pub fn atk_object_get_role(accessible: *mut AtkObject) -> AtkRole;
    pub fn atk_object_initialize(accessible: *mut AtkObject, data: gpointer);
    pub fn atk_object_notify_state_change(
        accessible: *mut AtkObject,
        state: AtkState,
        value: gboolean,
    );
    pub fn atk_object_peek_parent(accessible: *mut AtkObject) -> *mut AtkObject;
    pub fn atk_object_ref_accessible_child(accessible: *mut AtkObject, i: c_int) -> *mut AtkObject;
    pub fn atk_object_ref_relation_set(accessible: *mut AtkObject) -> *mut AtkRelationSet;
    pub fn atk_object_ref_state_set(accessible: *mut AtkObject) -> *mut AtkStateSet;
    pub fn atk_object_remove_property_change_handler(
        accessible: *mut AtkObject,
        handler_id: c_uint,
    );
    pub fn atk_object_remove_relationship(
        object: *mut AtkObject,
        relationship: AtkRelationType,
        target: *mut AtkObject,
    ) -> gboolean;
    #[cfg(any(feature = "v2_34", feature = "dox"))]
    pub fn atk_object_set_accessible_id(accessible: *mut AtkObject, name: *const c_char);
    pub fn atk_object_set_description(accessible: *mut AtkObject, description: *const c_char);
    pub fn atk_object_set_name(accessible: *mut AtkObject, name: *const c_char);
    pub fn atk_object_set_parent(accessible: *mut AtkObject, parent: *mut AtkObject);
    pub fn atk_object_set_role(accessible: *mut AtkObject, role: AtkRole);

    //=========================================================================
    // AtkObjectFactory
    //=========================================================================
    pub fn atk_object_factory_get_type() -> GType;
    pub fn atk_object_factory_create_accessible(
        factory: *mut AtkObjectFactory,
        obj: *mut gobject::GObject,
    ) -> *mut AtkObject;
    pub fn atk_object_factory_get_accessible_type(factory: *mut AtkObjectFactory) -> GType;
    pub fn atk_object_factory_invalidate(factory: *mut AtkObjectFactory);

    //=========================================================================
    // AtkPlug
    //=========================================================================
    pub fn atk_plug_get_type() -> GType;
    pub fn atk_plug_new() -> *mut AtkObject;
    pub fn atk_plug_get_id(plug: *mut AtkPlug) -> *mut c_char;

    //=========================================================================
    // AtkRegistry
    //=========================================================================
    pub fn atk_registry_get_type() -> GType;
    pub fn atk_registry_get_factory(
        registry: *mut AtkRegistry,
        type_: GType,
    ) -> *mut AtkObjectFactory;
    pub fn atk_registry_get_factory_type(registry: *mut AtkRegistry, type_: GType) -> GType;
    pub fn atk_registry_set_factory_type(
        registry: *mut AtkRegistry,
        type_: GType,
        factory_type: GType,
    );

    //=========================================================================
    // AtkRelation
    //=========================================================================
    pub fn atk_relation_get_type() -> GType;
    pub fn atk_relation_new(
        targets: *mut *mut AtkObject,
        n_targets: c_int,
        relationship: AtkRelationType,
    ) -> *mut AtkRelation;
    pub fn atk_relation_add_target(relation: *mut AtkRelation, target: *mut AtkObject);
    pub fn atk_relation_get_relation_type(relation: *mut AtkRelation) -> AtkRelationType;
    pub fn atk_relation_get_target(relation: *mut AtkRelation) -> *mut glib::GPtrArray;
    pub fn atk_relation_remove_target(
        relation: *mut AtkRelation,
        target: *mut AtkObject,
    ) -> gboolean;

    //=========================================================================
    // AtkRelationSet
    //=========================================================================
    pub fn atk_relation_set_get_type() -> GType;
    pub fn atk_relation_set_new() -> *mut AtkRelationSet;
    pub fn atk_relation_set_add(set: *mut AtkRelationSet, relation: *mut AtkRelation);
    pub fn atk_relation_set_add_relation_by_type(
        set: *mut AtkRelationSet,
        relationship: AtkRelationType,
        target: *mut AtkObject,
    );
    pub fn atk_relation_set_contains(
        set: *mut AtkRelationSet,
        relationship: AtkRelationType,
    ) -> gboolean;
    pub fn atk_relation_set_contains_target(
        set: *mut AtkRelationSet,
        relationship: AtkRelationType,
        target: *mut AtkObject,
    ) -> gboolean;
    pub fn atk_relation_set_get_n_relations(set: *mut AtkRelationSet) -> c_int;
    pub fn atk_relation_set_get_relation(set: *mut AtkRelationSet, i: c_int) -> *mut AtkRelation;
    pub fn atk_relation_set_get_relation_by_type(
        set: *mut AtkRelationSet,
        relationship: AtkRelationType,
    ) -> *mut AtkRelation;
    pub fn atk_relation_set_remove(set: *mut AtkRelationSet, relation: *mut AtkRelation);

    //=========================================================================
    // AtkSocket
    //=========================================================================
    pub fn atk_socket_get_type() -> GType;
    pub fn atk_socket_new() -> *mut AtkObject;
    pub fn atk_socket_embed(obj: *mut AtkSocket, plug_id: *const c_char);
    pub fn atk_socket_is_occupied(obj: *mut AtkSocket) -> gboolean;

    //=========================================================================
    // AtkStateSet
    //=========================================================================
    pub fn atk_state_set_get_type() -> GType;
    pub fn atk_state_set_new() -> *mut AtkStateSet;
    pub fn atk_state_set_add_state(set: *mut AtkStateSet, type_: AtkStateType) -> gboolean;
    pub fn atk_state_set_add_states(
        set: *mut AtkStateSet,
        types: *mut AtkStateType,
        n_types: c_int,
    );
    pub fn atk_state_set_and_sets(
        set: *mut AtkStateSet,
        compare_set: *mut AtkStateSet,
    ) -> *mut AtkStateSet;
    pub fn atk_state_set_clear_states(set: *mut AtkStateSet);
    pub fn atk_state_set_contains_state(set: *mut AtkStateSet, type_: AtkStateType) -> gboolean;
    pub fn atk_state_set_contains_states(
        set: *mut AtkStateSet,
        types: *mut AtkStateType,
        n_types: c_int,
    ) -> gboolean;
    pub fn atk_state_set_is_empty(set: *mut AtkStateSet) -> gboolean;
    pub fn atk_state_set_or_sets(
        set: *mut AtkStateSet,
        compare_set: *mut AtkStateSet,
    ) -> *mut AtkStateSet;
    pub fn atk_state_set_remove_state(set: *mut AtkStateSet, type_: AtkStateType) -> gboolean;
    pub fn atk_state_set_xor_sets(
        set: *mut AtkStateSet,
        compare_set: *mut AtkStateSet,
    ) -> *mut AtkStateSet;

    //=========================================================================
    // AtkUtil
    //=========================================================================
    pub fn atk_util_get_type() -> GType;

    //=========================================================================
    // AtkAction
    //=========================================================================
    pub fn atk_action_get_type() -> GType;
    pub fn atk_action_do_action(action: *mut AtkAction, i: c_int) -> gboolean;
    pub fn atk_action_get_description(action: *mut AtkAction, i: c_int) -> *const c_char;
    pub fn atk_action_get_keybinding(action: *mut AtkAction, i: c_int) -> *const c_char;
    pub fn atk_action_get_localized_name(action: *mut AtkAction, i: c_int) -> *const c_char;
    pub fn atk_action_get_n_actions(action: *mut AtkAction) -> c_int;
    pub fn atk_action_get_name(action: *mut AtkAction, i: c_int) -> *const c_char;
    pub fn atk_action_set_description(
        action: *mut AtkAction,
        i: c_int,
        desc: *const c_char,
    ) -> gboolean;

    //=========================================================================
    // AtkComponent
    //=========================================================================
    pub fn atk_component_get_type() -> GType;
    pub fn atk_component_add_focus_handler(
        component: *mut AtkComponent,
        handler: AtkFocusHandler,
    ) -> c_uint;
    pub fn atk_component_contains(
        component: *mut AtkComponent,
        x: c_int,
        y: c_int,
        coord_type: AtkCoordType,
    ) -> gboolean;
    pub fn atk_component_get_alpha(component: *mut AtkComponent) -> c_double;
    pub fn atk_component_get_extents(
        component: *mut AtkComponent,
        x: *mut c_int,
        y: *mut c_int,
        width: *mut c_int,
        height: *mut c_int,
        coord_type: AtkCoordType,
    );
    pub fn atk_component_get_layer(component: *mut AtkComponent) -> AtkLayer;
    pub fn atk_component_get_mdi_zorder(component: *mut AtkComponent) -> c_int;
    pub fn atk_component_get_position(
        component: *mut AtkComponent,
        x: *mut c_int,
        y: *mut c_int,
        coord_type: AtkCoordType,
    );
    pub fn atk_component_get_size(
        component: *mut AtkComponent,
        width: *mut c_int,
        height: *mut c_int,
    );
    pub fn atk_component_grab_focus(component: *mut AtkComponent) -> gboolean;
    pub fn atk_component_ref_accessible_at_point(
        component: *mut AtkComponent,
        x: c_int,
        y: c_int,
        coord_type: AtkCoordType,
    ) -> *mut AtkObject;
    pub fn atk_component_remove_focus_handler(component: *mut AtkComponent, handler_id: c_uint);
    #[cfg(any(feature = "v2_30", feature = "dox"))]
    pub fn atk_component_scroll_to(component: *mut AtkComponent, type_: AtkScrollType) -> gboolean;
    #[cfg(any(feature = "v2_30", feature = "dox"))]
    pub fn atk_component_scroll_to_point(
        component: *mut AtkComponent,
        coords: AtkCoordType,
        x: c_int,
        y: c_int,
    ) -> gboolean;
    pub fn atk_component_set_extents(
        component: *mut AtkComponent,
        x: c_int,
        y: c_int,
        width: c_int,
        height: c_int,
        coord_type: AtkCoordType,
    ) -> gboolean;
    pub fn atk_component_set_position(
        component: *mut AtkComponent,
        x: c_int,
        y: c_int,
        coord_type: AtkCoordType,
    ) -> gboolean;
    pub fn atk_component_set_size(
        component: *mut AtkComponent,
        width: c_int,
        height: c_int,
    ) -> gboolean;

    //=========================================================================
    // AtkDocument
    //=========================================================================
    pub fn atk_document_get_type() -> GType;
    pub fn atk_document_get_attribute_value(
        document: *mut AtkDocument,
        attribute_name: *const c_char,
    ) -> *const c_char;
    pub fn atk_document_get_attributes(document: *mut AtkDocument) -> *mut AtkAttributeSet;
    pub fn atk_document_get_current_page_number(document: *mut AtkDocument) -> c_int;
    pub fn atk_document_get_document(document: *mut AtkDocument) -> gpointer;
    pub fn atk_document_get_document_type(document: *mut AtkDocument) -> *const c_char;
    pub fn atk_document_get_locale(document: *mut AtkDocument) -> *const c_char;
    pub fn atk_document_get_page_count(document: *mut AtkDocument) -> c_int;
    pub fn atk_document_set_attribute_value(
        document: *mut AtkDocument,
        attribute_name: *const c_char,
        attribute_value: *const c_char,
    ) -> gboolean;

    //=========================================================================
    // AtkEditableText
    //=========================================================================
    pub fn atk_editable_text_get_type() -> GType;
    pub fn atk_editable_text_copy_text(
        text: *mut AtkEditableText,
        start_pos: c_int,
        end_pos: c_int,
    );
    pub fn atk_editable_text_cut_text(text: *mut AtkEditableText, start_pos: c_int, end_pos: c_int);
    pub fn atk_editable_text_delete_text(
        text: *mut AtkEditableText,
        start_pos: c_int,
        end_pos: c_int,
    );
    pub fn atk_editable_text_insert_text(
        text: *mut AtkEditableText,
        string: *const c_char,
        length: c_int,
        position: *mut c_int,
    );
    pub fn atk_editable_text_paste_text(text: *mut AtkEditableText, position: c_int);
    pub fn atk_editable_text_set_run_attributes(
        text: *mut AtkEditableText,
        attrib_set: *mut AtkAttributeSet,
        start_offset: c_int,
        end_offset: c_int,
    ) -> gboolean;
    pub fn atk_editable_text_set_text_contents(text: *mut AtkEditableText, string: *const c_char);

    //=========================================================================
    // AtkHyperlinkImpl
    //=========================================================================
    pub fn atk_hyperlink_impl_get_type() -> GType;
    pub fn atk_hyperlink_impl_get_hyperlink(impl_: *mut AtkHyperlinkImpl) -> *mut AtkHyperlink;

    //=========================================================================
    // AtkHypertext
    //=========================================================================
    pub fn atk_hypertext_get_type() -> GType;
    pub fn atk_hypertext_get_link(
        hypertext: *mut AtkHypertext,
        link_index: c_int,
    ) -> *mut AtkHyperlink;
    pub fn atk_hypertext_get_link_index(hypertext: *mut AtkHypertext, char_index: c_int) -> c_int;
    pub fn atk_hypertext_get_n_links(hypertext: *mut AtkHypertext) -> c_int;

    //=========================================================================
    // AtkImage
    //=========================================================================
    pub fn atk_image_get_type() -> GType;
    pub fn atk_image_get_image_description(image: *mut AtkImage) -> *const c_char;
    pub fn atk_image_get_image_locale(image: *mut AtkImage) -> *const c_char;
    pub fn atk_image_get_image_position(
        image: *mut AtkImage,
        x: *mut c_int,
        y: *mut c_int,
        coord_type: AtkCoordType,
    );
    pub fn atk_image_get_image_size(image: *mut AtkImage, width: *mut c_int, height: *mut c_int);
    pub fn atk_image_set_image_description(
        image: *mut AtkImage,
        description: *const c_char,
    ) -> gboolean;

    //=========================================================================
    // AtkImplementorIface
    //=========================================================================
    pub fn atk_implementor_get_type() -> GType;

    //=========================================================================
    // AtkSelection
    //=========================================================================
    pub fn atk_selection_get_type() -> GType;
    pub fn atk_selection_add_selection(selection: *mut AtkSelection, i: c_int) -> gboolean;
    pub fn atk_selection_clear_selection(selection: *mut AtkSelection) -> gboolean;
    pub fn atk_selection_get_selection_count(selection: *mut AtkSelection) -> c_int;
    pub fn atk_selection_is_child_selected(selection: *mut AtkSelection, i: c_int) -> gboolean;
    pub fn atk_selection_ref_selection(selection: *mut AtkSelection, i: c_int) -> *mut AtkObject;
    pub fn atk_selection_remove_selection(selection: *mut AtkSelection, i: c_int) -> gboolean;
    pub fn atk_selection_select_all_selection(selection: *mut AtkSelection) -> gboolean;

    //=========================================================================
    // AtkStreamableContent
    //=========================================================================
    pub fn atk_streamable_content_get_type() -> GType;
    pub fn atk_streamable_content_get_mime_type(
        streamable: *mut AtkStreamableContent,
        i: c_int,
    ) -> *const c_char;
    pub fn atk_streamable_content_get_n_mime_types(streamable: *mut AtkStreamableContent) -> c_int;
    pub fn atk_streamable_content_get_stream(
        streamable: *mut AtkStreamableContent,
        mime_type: *const c_char,
    ) -> *mut glib::GIOChannel;
    pub fn atk_streamable_content_get_uri(
        streamable: *mut AtkStreamableContent,
        mime_type: *const c_char,
    ) -> *const c_char;

    //=========================================================================
    // AtkTable
    //=========================================================================
    pub fn atk_table_get_type() -> GType;
    pub fn atk_table_add_column_selection(table: *mut AtkTable, column: c_int) -> gboolean;
    pub fn atk_table_add_row_selection(table: *mut AtkTable, row: c_int) -> gboolean;
    pub fn atk_table_get_caption(table: *mut AtkTable) -> *mut AtkObject;
    pub fn atk_table_get_column_at_index(table: *mut AtkTable, index_: c_int) -> c_int;
    pub fn atk_table_get_column_description(table: *mut AtkTable, column: c_int) -> *const c_char;
    pub fn atk_table_get_column_extent_at(table: *mut AtkTable, row: c_int, column: c_int)
        -> c_int;
    pub fn atk_table_get_column_header(table: *mut AtkTable, column: c_int) -> *mut AtkObject;
    pub fn atk_table_get_index_at(table: *mut AtkTable, row: c_int, column: c_int) -> c_int;
    pub fn atk_table_get_n_columns(table: *mut AtkTable) -> c_int;
    pub fn atk_table_get_n_rows(table: *mut AtkTable) -> c_int;
    pub fn atk_table_get_row_at_index(table: *mut AtkTable, index_: c_int) -> c_int;
    pub fn atk_table_get_row_description(table: *mut AtkTable, row: c_int) -> *const c_char;
    pub fn atk_table_get_row_extent_at(table: *mut AtkTable, row: c_int, column: c_int) -> c_int;
    pub fn atk_table_get_row_header(table: *mut AtkTable, row: c_int) -> *mut AtkObject;
    pub fn atk_table_get_selected_columns(table: *mut AtkTable, selected: *mut *mut c_int)
        -> c_int;
    pub fn atk_table_get_selected_rows(table: *mut AtkTable, selected: *mut *mut c_int) -> c_int;
    pub fn atk_table_get_summary(table: *mut AtkTable) -> *mut AtkObject;
    pub fn atk_table_is_column_selected(table: *mut AtkTable, column: c_int) -> gboolean;
    pub fn atk_table_is_row_selected(table: *mut AtkTable, row: c_int) -> gboolean;
    pub fn atk_table_is_selected(table: *mut AtkTable, row: c_int, column: c_int) -> gboolean;
    pub fn atk_table_ref_at(table: *mut AtkTable, row: c_int, column: c_int) -> *mut AtkObject;
    pub fn atk_table_remove_column_selection(table: *mut AtkTable, column: c_int) -> gboolean;
    pub fn atk_table_remove_row_selection(table: *mut AtkTable, row: c_int) -> gboolean;
    pub fn atk_table_set_caption(table: *mut AtkTable, caption: *mut AtkObject);
    pub fn atk_table_set_column_description(
        table: *mut AtkTable,
        column: c_int,
        description: *const c_char,
    );
    pub fn atk_table_set_column_header(table: *mut AtkTable, column: c_int, header: *mut AtkObject);
    pub fn atk_table_set_row_description(
        table: *mut AtkTable,
        row: c_int,
        description: *const c_char,
    );
    pub fn atk_table_set_row_header(table: *mut AtkTable, row: c_int, header: *mut AtkObject);
    pub fn atk_table_set_summary(table: *mut AtkTable, accessible: *mut AtkObject);

    //=========================================================================
    // AtkTableCell
    //=========================================================================
    pub fn atk_table_cell_get_type() -> GType;
    pub fn atk_table_cell_get_column_header_cells(cell: *mut AtkTableCell) -> *mut glib::GPtrArray;
    pub fn atk_table_cell_get_column_span(cell: *mut AtkTableCell) -> c_int;
    pub fn atk_table_cell_get_position(
        cell: *mut AtkTableCell,
        row: *mut c_int,
        column: *mut c_int,
    ) -> gboolean;
    pub fn atk_table_cell_get_row_column_span(
        cell: *mut AtkTableCell,
        row: *mut c_int,
        column: *mut c_int,
        row_span: *mut c_int,
        column_span: *mut c_int,
    ) -> gboolean;
    pub fn atk_table_cell_get_row_header_cells(cell: *mut AtkTableCell) -> *mut glib::GPtrArray;
    pub fn atk_table_cell_get_row_span(cell: *mut AtkTableCell) -> c_int;
    pub fn atk_table_cell_get_table(cell: *mut AtkTableCell) -> *mut AtkObject;

    //=========================================================================
    // AtkText
    //=========================================================================
    pub fn atk_text_get_type() -> GType;
    pub fn atk_text_free_ranges(ranges: *mut *mut AtkTextRange);
    pub fn atk_text_add_selection(
        text: *mut AtkText,
        start_offset: c_int,
        end_offset: c_int,
    ) -> gboolean;
    pub fn atk_text_get_bounded_ranges(
        text: *mut AtkText,
        rect: *mut AtkTextRectangle,
        coord_type: AtkCoordType,
        x_clip_type: AtkTextClipType,
        y_clip_type: AtkTextClipType,
    ) -> *mut *mut AtkTextRange;
    pub fn atk_text_get_caret_offset(text: *mut AtkText) -> c_int;
    pub fn atk_text_get_character_at_offset(text: *mut AtkText, offset: c_int) -> u32;
    pub fn atk_text_get_character_count(text: *mut AtkText) -> c_int;
    pub fn atk_text_get_character_extents(
        text: *mut AtkText,
        offset: c_int,
        x: *mut c_int,
        y: *mut c_int,
        width: *mut c_int,
        height: *mut c_int,
        coords: AtkCoordType,
    );
    pub fn atk_text_get_default_attributes(text: *mut AtkText) -> *mut AtkAttributeSet;
    pub fn atk_text_get_n_selections(text: *mut AtkText) -> c_int;
    pub fn atk_text_get_offset_at_point(
        text: *mut AtkText,
        x: c_int,
        y: c_int,
        coords: AtkCoordType,
    ) -> c_int;
    pub fn atk_text_get_range_extents(
        text: *mut AtkText,
        start_offset: c_int,
        end_offset: c_int,
        coord_type: AtkCoordType,
        rect: *mut AtkTextRectangle,
    );
    pub fn atk_text_get_run_attributes(
        text: *mut AtkText,
        offset: c_int,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut AtkAttributeSet;
    pub fn atk_text_get_selection(
        text: *mut AtkText,
        selection_num: c_int,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut c_char;
    pub fn atk_text_get_string_at_offset(
        text: *mut AtkText,
        offset: c_int,
        granularity: AtkTextGranularity,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut c_char;
    pub fn atk_text_get_text(
        text: *mut AtkText,
        start_offset: c_int,
        end_offset: c_int,
    ) -> *mut c_char;
    pub fn atk_text_get_text_after_offset(
        text: *mut AtkText,
        offset: c_int,
        boundary_type: AtkTextBoundary,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut c_char;
    pub fn atk_text_get_text_at_offset(
        text: *mut AtkText,
        offset: c_int,
        boundary_type: AtkTextBoundary,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut c_char;
    pub fn atk_text_get_text_before_offset(
        text: *mut AtkText,
        offset: c_int,
        boundary_type: AtkTextBoundary,
        start_offset: *mut c_int,
        end_offset: *mut c_int,
    ) -> *mut c_char;
    pub fn atk_text_remove_selection(text: *mut AtkText, selection_num: c_int) -> gboolean;
    #[cfg(any(feature = "v2_32", feature = "dox"))]
    pub fn atk_text_scroll_substring_to(
        text: *mut AtkText,
        start_offset: c_int,
        end_offset: c_int,
        type_: AtkScrollType,
    ) -> gboolean;
    #[cfg(any(feature = "v2_32", feature = "dox"))]
    pub fn atk_text_scroll_substring_to_point(
        text: *mut AtkText,
        start_offset: c_int,
        end_offset: c_int,
        coords: AtkCoordType,
        x: c_int,
        y: c_int,
    ) -> gboolean;
    pub fn atk_text_set_caret_offset(text: *mut AtkText, offset: c_int) -> gboolean;
    pub fn atk_text_set_selection(
        text: *mut AtkText,
        selection_num: c_int,
        start_offset: c_int,
        end_offset: c_int,
    ) -> gboolean;

    //=========================================================================
    // AtkValue
    //=========================================================================
    pub fn atk_value_get_type() -> GType;
    pub fn atk_value_get_current_value(obj: *mut AtkValue, value: *mut gobject::GValue);
    pub fn atk_value_get_increment(obj: *mut AtkValue) -> c_double;
    pub fn atk_value_get_maximum_value(obj: *mut AtkValue, value: *mut gobject::GValue);
    pub fn atk_value_get_minimum_increment(obj: *mut AtkValue, value: *mut gobject::GValue);
    pub fn atk_value_get_minimum_value(obj: *mut AtkValue, value: *mut gobject::GValue);
    pub fn atk_value_get_range(obj: *mut AtkValue) -> *mut AtkRange;
    pub fn atk_value_get_sub_ranges(obj: *mut AtkValue) -> *mut glib::GSList;
    pub fn atk_value_get_value_and_text(
        obj: *mut AtkValue,
        value: *mut c_double,
        text: *mut *mut c_char,
    );
    pub fn atk_value_set_current_value(
        obj: *mut AtkValue,
        value: *const gobject::GValue,
    ) -> gboolean;
    pub fn atk_value_set_value(obj: *mut AtkValue, new_value: c_double);

    //=========================================================================
    // AtkWindow
    //=========================================================================
    pub fn atk_window_get_type() -> GType;

    //=========================================================================
    // Other functions
    //=========================================================================
    pub fn atk_add_focus_tracker(focus_tracker: AtkEventListener) -> c_uint;
    pub fn atk_add_global_event_listener(
        listener: gobject::GSignalEmissionHook,
        event_type: *const c_char,
    ) -> c_uint;
    pub fn atk_add_key_event_listener(listener: AtkKeySnoopFunc, data: gpointer) -> c_uint;
    pub fn atk_focus_tracker_init(init: AtkEventListenerInit);
    pub fn atk_focus_tracker_notify(object: *mut AtkObject);
    pub fn atk_get_binary_age() -> c_uint;
    pub fn atk_get_default_registry() -> *mut AtkRegistry;
    pub fn atk_get_focus_object() -> *mut AtkObject;
    pub fn atk_get_interface_age() -> c_uint;
    pub fn atk_get_major_version() -> c_uint;
    pub fn atk_get_micro_version() -> c_uint;
    pub fn atk_get_minor_version() -> c_uint;
    pub fn atk_get_root() -> *mut AtkObject;
    pub fn atk_get_toolkit_name() -> *const c_char;
    pub fn atk_get_toolkit_version() -> *const c_char;
    pub fn atk_get_version() -> *const c_char;
    pub fn atk_remove_focus_tracker(tracker_id: c_uint);
    pub fn atk_remove_global_event_listener(listener_id: c_uint);
    pub fn atk_remove_key_event_listener(listener_id: c_uint);

}
