/* testsortedset.c generated by valac 0.18.0.32-44bf7, the Vala compiler
 * generated from testsortedset.vala, do not modify */

/* testsortedset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_SET_TESTS (set_tests_get_type ())
#define SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_TESTS, SetTests))
#define SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_TESTS, SetTestsClass))
#define IS_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_TESTS))
#define IS_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_TESTS))
#define SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_TESTS, SetTestsClass))

typedef struct _SetTests SetTests;
typedef struct _SetTestsClass SetTestsClass;
typedef struct _SetTestsPrivate SetTestsPrivate;

#define TYPE_SORTED_SET_TESTS (sorted_set_tests_get_type ())
#define SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_SET_TESTS, SortedSetTests))
#define SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))
#define IS_SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_SET_TESTS))
#define IS_SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_SET_TESTS))
#define SORTED_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))

typedef struct _SortedSetTests SortedSetTests;
typedef struct _SortedSetTestsClass SortedSetTestsClass;
typedef struct _SortedSetTestsPrivate SortedSetTestsPrivate;

#define SORTED_SET_TESTS_SUB_SET_TYPE_TYPE (sorted_set_tests_sub_set_type_get_type ())

#define SORTED_SET_TESTS_TYPE_SUB_SET (sorted_set_tests_sub_set_get_type ())
#define SORTED_SET_TESTS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSet))
#define SORTED_SET_TESTS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))
#define SORTED_SET_TESTS_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))

typedef struct _SortedSetTestsSubSet SortedSetTestsSubSet;
typedef struct _SortedSetTestsSubSetClass SortedSetTestsSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SortedSetTestsSubSetPrivate SortedSetTestsSubSetPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SetTests {
	CollectionTests parent_instance;
	SetTestsPrivate * priv;
};

struct _SetTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_ignored) (SetTests* self);
};

struct _SortedSetTests {
	SetTests parent_instance;
	SortedSetTestsPrivate * priv;
};

struct _SortedSetTestsClass {
	SetTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
typedef enum  {
	SORTED_SET_TESTS_SUB_SET_TYPE_HEAD,
	SORTED_SET_TESTS_SUB_SET_TYPE_TAIL,
	SORTED_SET_TESTS_SUB_SET_TYPE_SUB,
	SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY
} SortedSetTestsSubSetType;

struct _SortedSetTestsSubSet {
	GeeTestCase parent_instance;
	SortedSetTestsSubSetPrivate * priv;
};

struct _SortedSetTestsSubSetClass {
	GeeTestCaseClass parent_class;
};

struct _SortedSetTestsSubSetPrivate {
	GeeSortedSet* master;
	GeeSortedSet* subset;
	SortedSetTests* test;
	SortedSetTestsSubSetType type;
};


static gpointer sorted_set_tests_parent_class = NULL;
static gpointer sorted_set_tests_sub_set_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType set_tests_get_type (void) G_GNUC_CONST;
GType sorted_set_tests_get_type (void) G_GNUC_CONST;
enum  {
	SORTED_SET_TESTS_DUMMY_PROPERTY
};
SortedSetTests* sorted_set_tests_construct (GType object_type, const gchar* name);
SetTests* set_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void sorted_set_tests_test_first (SortedSetTests* self);
static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_last (SortedSetTests* self);
static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ordering (SortedSetTests* self);
static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_iterator_at (SortedSetTests* self);
static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_lower (SortedSetTests* self);
static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_higher (SortedSetTests* self);
static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_floor (SortedSetTests* self);
static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ceil (SortedSetTests* self);
static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self);
static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self);
GTestSuite* gee_test_case_get_suite (GeeTestCase* self);
GType sorted_set_tests_sub_set_type_get_type (void) G_GNUC_CONST;
SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type);
SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type);
GType sorted_set_tests_sub_set_get_type (void) G_GNUC_CONST;
#define SORTED_SET_TESTS_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetPrivate))
enum  {
	SORTED_SET_TESTS_SUB_SET_DUMMY_PROPERTY
};
const gchar* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self);
static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base);
void gee_test_case_set_up (GeeTestCase* self);
static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base);
void gee_test_case_tear_down (GeeTestCase* self);
static void sorted_set_tests_sub_set_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_first (self);
}


static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_last (self);
}


static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ordering (self);
}


static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_iterator_at (self);
}


static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_lower (self);
}


static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_higher (self);
}


static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_floor (self);
}


static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ceil (self);
}


static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_can_go_backward (self);
}


static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_mutable_bidir_iterator (self);
}


static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_last (self);
}


SortedSetTests* sorted_set_tests_construct (GType object_type, const gchar* name) {
	SortedSetTests * self = NULL;
	const gchar* _tmp0_;
	GTestSuite* _tmp1_ = NULL;
	SortedSetTestsSubSet* _tmp2_;
	SortedSetTestsSubSet* _tmp3_;
	GTestSuite* _tmp4_ = NULL;
	GTestSuite* _tmp5_ = NULL;
	SortedSetTestsSubSet* _tmp6_;
	SortedSetTestsSubSet* _tmp7_;
	GTestSuite* _tmp8_ = NULL;
	GTestSuite* _tmp9_ = NULL;
	SortedSetTestsSubSet* _tmp10_;
	SortedSetTestsSubSet* _tmp11_;
	GTestSuite* _tmp12_ = NULL;
	GTestSuite* _tmp13_ = NULL;
	SortedSetTestsSubSet* _tmp14_;
	SortedSetTestsSubSet* _tmp15_;
	GTestSuite* _tmp16_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	self = (SortedSetTests*) set_tests_construct (object_type, _tmp0_);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] first", _sorted_set_tests_test_first_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] last", _sorted_set_tests_test_last_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ordering", _sorted_set_tests_test_ordering_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can go backward", _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators are mutable", _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can to end", _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method, self);
	_tmp1_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp2_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_HEAD);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_test_case_get_suite ((GeeTestCase*) _tmp3_);
	g_test_suite_add_suite (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp6_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_TAIL);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_test_case_get_suite ((GeeTestCase*) _tmp7_);
	g_test_suite_add_suite (_tmp5_, _tmp8_);
	_g_object_unref0 (_tmp7_);
	_tmp9_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp10_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_SUB);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_test_case_get_suite ((GeeTestCase*) _tmp11_);
	g_test_suite_add_suite (_tmp9_, _tmp12_);
	_g_object_unref0 (_tmp11_);
	_tmp13_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp14_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_test_case_get_suite ((GeeTestCase*) _tmp15_);
	g_test_suite_add_suite (_tmp13_, _tmp16_);
	_g_object_unref0 (_tmp15_);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sorted_set_tests_test_ordering (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	gboolean _tmp3_ = FALSE;
	gpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gboolean _tmp24_ = FALSE;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_ = FALSE;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gpointer _tmp34_ = NULL;
	gchar* _tmp35_;
	gboolean _tmp36_ = FALSE;
	gpointer _tmp37_ = NULL;
	gchar* _tmp38_;
	gboolean _tmp39_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_vala_assert (test_set != NULL, "test_set != null");
	gee_collection_add ((GeeCollection*) test_set, "one");
	gee_collection_add ((GeeCollection*) test_set, "two");
	gee_collection_add ((GeeCollection*) test_set, "three");
	gee_collection_add ((GeeCollection*) test_set, "four");
	gee_collection_add ((GeeCollection*) test_set, "five");
	gee_collection_add ((GeeCollection*) test_set, "six");
	gee_collection_add ((GeeCollection*) test_set, "seven");
	gee_collection_add ((GeeCollection*) test_set, "eight");
	gee_collection_add ((GeeCollection*) test_set, "nine");
	gee_collection_add ((GeeCollection*) test_set, "ten");
	gee_collection_add ((GeeCollection*) test_set, "eleven");
	gee_collection_add ((GeeCollection*) test_set, "twelve");
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) test_set);
	iterator = _tmp2_;
	_tmp3_ = gee_iterator_next (iterator);
	_vala_assert (_tmp3_, "iterator.next ()");
	_tmp4_ = gee_iterator_get (iterator);
	_tmp5_ = (gchar*) _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "eight") == 0, "iterator.get () == \"eight\"");
	_g_free0 (_tmp5_);
	_tmp6_ = gee_iterator_next (iterator);
	_vala_assert (_tmp6_, "iterator.next ()");
	_tmp7_ = gee_iterator_get (iterator);
	_tmp8_ = (gchar*) _tmp7_;
	_vala_assert (g_strcmp0 (_tmp8_, "eleven") == 0, "iterator.get () == \"eleven\"");
	_g_free0 (_tmp8_);
	_tmp9_ = gee_iterator_next (iterator);
	_vala_assert (_tmp9_, "iterator.next ()");
	_tmp10_ = gee_iterator_get (iterator);
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_iterator_next (iterator);
	_vala_assert (_tmp12_, "iterator.next ()");
	_tmp13_ = gee_iterator_get (iterator);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp14_);
	_tmp15_ = gee_iterator_next (iterator);
	_vala_assert (_tmp15_, "iterator.next ()");
	_tmp16_ = gee_iterator_get (iterator);
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "nine") == 0, "iterator.get () == \"nine\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_iterator_next (iterator);
	_vala_assert (_tmp18_, "iterator.next ()");
	_tmp19_ = gee_iterator_get (iterator);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp20_);
	_tmp21_ = gee_iterator_next (iterator);
	_vala_assert (_tmp21_, "iterator.next ()");
	_tmp22_ = gee_iterator_get (iterator);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "seven") == 0, "iterator.get () == \"seven\"");
	_g_free0 (_tmp23_);
	_tmp24_ = gee_iterator_next (iterator);
	_vala_assert (_tmp24_, "iterator.next ()");
	_tmp25_ = gee_iterator_get (iterator);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp26_, "six") == 0, "iterator.get () == \"six\"");
	_g_free0 (_tmp26_);
	_tmp27_ = gee_iterator_next (iterator);
	_vala_assert (_tmp27_, "iterator.next ()");
	_tmp28_ = gee_iterator_get (iterator);
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "ten") == 0, "iterator.get () == \"ten\"");
	_g_free0 (_tmp29_);
	_tmp30_ = gee_iterator_next (iterator);
	_vala_assert (_tmp30_, "iterator.next ()");
	_tmp31_ = gee_iterator_get (iterator);
	_tmp32_ = (gchar*) _tmp31_;
	_vala_assert (g_strcmp0 (_tmp32_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp32_);
	_tmp33_ = gee_iterator_next (iterator);
	_vala_assert (_tmp33_, "iterator.next ()");
	_tmp34_ = gee_iterator_get (iterator);
	_tmp35_ = (gchar*) _tmp34_;
	_vala_assert (g_strcmp0 (_tmp35_, "twelve") == 0, "iterator.get () == \"twelve\"");
	_g_free0 (_tmp35_);
	_tmp36_ = gee_iterator_next (iterator);
	_vala_assert (_tmp36_, "iterator.next ()");
	_tmp37_ = gee_iterator_get (iterator);
	_tmp38_ = (gchar*) _tmp37_;
	_vala_assert (g_strcmp0 (_tmp38_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp38_);
	_tmp39_ = gee_iterator_next (iterator);
	_vala_assert (_tmp39_ == FALSE, "iterator.next () == false");
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_first (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeSortedSet* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeSortedSet* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeSortedSet* _tmp18_;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		GeeSortedSet* _tmp3_;
		gpointer _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp3_ = test_set;
		_tmp4_ = gee_sorted_set_first (_tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_g_free0 (_tmp5_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_set;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "test_set.add (\"one\")");
	_tmp8_ = test_set;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "test_set.add (\"two\")");
	_tmp10_ = test_set;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "three");
	_vala_assert (_tmp11_, "test_set.add (\"three\")");
	_tmp12_ = test_set;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "four");
	_vala_assert (_tmp13_, "test_set.add (\"four\")");
	_tmp14_ = test_set;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "five");
	_vala_assert (_tmp15_, "test_set.add (\"five\")");
	_tmp16_ = test_set;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "six");
	_vala_assert (_tmp17_, "test_set.add (\"six\")");
	_tmp18_ = test_set;
	_tmp19_ = gee_sorted_set_first (_tmp18_);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "five") == 0, "test_set.first () == \"five\"");
	_g_free0 (_tmp20_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeSortedSet* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeSortedSet* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeSortedSet* _tmp18_;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		GeeSortedSet* _tmp3_;
		gpointer _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp3_ = test_set;
		_tmp4_ = gee_sorted_set_last (_tmp3_);
		_tmp5_ = (gchar*) _tmp4_;
		_g_free0 (_tmp5_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp6_ = test_set;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "test_set.add (\"one\")");
	_tmp8_ = test_set;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "test_set.add (\"two\")");
	_tmp10_ = test_set;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "three");
	_vala_assert (_tmp11_, "test_set.add (\"three\")");
	_tmp12_ = test_set;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "four");
	_vala_assert (_tmp13_, "test_set.add (\"four\")");
	_tmp14_ = test_set;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "five");
	_vala_assert (_tmp15_, "test_set.add (\"five\")");
	_tmp16_ = test_set;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "six");
	_vala_assert (_tmp17_, "test_set.add (\"six\")");
	_tmp18_ = test_set;
	_tmp19_ = gee_sorted_set_last (_tmp18_);
	_tmp20_ = (gchar*) _tmp19_;
	_vala_assert (g_strcmp0 (_tmp20_, "two") == 0, "test_set.last () == \"two\"");
	_g_free0 (_tmp20_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_iterator_at (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeBidirIterator* _tmp5_ = NULL;
	GeeBidirIterator* iter;
	GeeBidirIterator* _tmp6_;
	GeeBidirIterator* _tmp7_;
	gpointer _tmp8_ = NULL;
	gchar* _tmp9_;
	GeeBidirIterator* _tmp10_ = NULL;
	GeeBidirIterator* _tmp11_;
	GeeBidirIterator* _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	GeeBidirIterator* _tmp15_ = NULL;
	GeeBidirIterator* _tmp16_;
	GeeBidirIterator* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	GeeBidirIterator* _tmp20_ = NULL;
	GeeBidirIterator* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp2_, "test_set.add (\"one\")");
	_tmp3_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp3_, "test_set.add (\"two\")");
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp4_, "test_set.add (\"three\")");
	_tmp5_ = gee_sorted_set_iterator_at (test_set, "one");
	iter = _tmp5_;
	_tmp6_ = iter;
	_vala_assert (_tmp6_ != NULL, "iter != null");
	_tmp7_ = iter;
	_tmp8_ = gee_iterator_get ((GeeIterator*) _tmp7_);
	_tmp9_ = (gchar*) _tmp8_;
	_vala_assert (g_strcmp0 (_tmp9_, "one") == 0, "iter.get () == \"one\"");
	_g_free0 (_tmp9_);
	_tmp10_ = gee_sorted_set_iterator_at (test_set, "two");
	_g_object_unref0 (iter);
	iter = _tmp10_;
	_tmp11_ = iter;
	_vala_assert (_tmp11_ != NULL, "iter != null");
	_tmp12_ = iter;
	_tmp13_ = gee_iterator_get ((GeeIterator*) _tmp12_);
	_tmp14_ = (gchar*) _tmp13_;
	_vala_assert (g_strcmp0 (_tmp14_, "two") == 0, "iter.get () == \"two\"");
	_g_free0 (_tmp14_);
	_tmp15_ = gee_sorted_set_iterator_at (test_set, "three");
	_g_object_unref0 (iter);
	iter = _tmp15_;
	_tmp16_ = iter;
	_vala_assert (_tmp16_ != NULL, "iter != null");
	_tmp17_ = iter;
	_tmp18_ = gee_iterator_get ((GeeIterator*) _tmp17_);
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "three") == 0, "iter.get () == \"three\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_iterator_at (test_set, "zero");
	_g_object_unref0 (iter);
	iter = _tmp20_;
	_tmp21_ = iter;
	_vala_assert (_tmp21_ == NULL, "iter == null");
	_g_object_unref0 (iter);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_lower (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_lower (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.lower (\"one\") == null");
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp4_, "test_set.add (\"one\")");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp5_, "test_set.add (\"two\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp6_, "test_set.add (\"three\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp7_, "test_set.add (\"four\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp8_, "test_set.add (\"five\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp9_, "test_set.add (\"six\")");
	_tmp10_ = gee_sorted_set_lower (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "four") == 0, "test_set.lower (\"one\") == \"four\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_lower (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "four") == 0, "test_set.lower (\"o\") == \"four\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_lower (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "three") == 0, "test_set.lower (\"two\") == \"three\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_lower (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "six") == 0, "test_set.lower (\"t\") == \"six\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_lower (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "six") == 0, "test_set.lower (\"three\") == \"six\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_lower (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "five") == 0, "test_set.lower (\"four\") == \"five\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_lower (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (_tmp23_ == NULL, "test_set.lower (\"f\") == null");
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_lower (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (_tmp25_ == NULL, "test_set.lower (\"five\") == null");
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_lower (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "one") == 0, "test_set.lower (\"six\") == \"one\"");
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_lower (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "one") == 0, "test_set.lower (\"s\") == \"one\"");
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_higher (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_higher (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.higher (\"one\") == null");
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp4_, "test_set.add (\"one\")");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp5_, "test_set.add (\"two\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp6_, "test_set.add (\"three\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp7_, "test_set.add (\"four\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp8_, "test_set.add (\"five\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp9_, "test_set.add (\"six\")");
	_tmp10_ = gee_sorted_set_higher (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "six") == 0, "test_set.higher (\"one\") == \"six\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_higher (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "one") == 0, "test_set.higher (\"o\") == \"one\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_higher (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (_tmp15_ == NULL, "test_set.higher (\"two\") == null");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_higher (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "three") == 0, "test_set.higher (\"t\") == \"three\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_higher (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "two") == 0, "test_set.higher (\"three\") == \"two\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_higher (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "one") == 0, "test_set.higher (\"four\") == \"one\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_higher (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "five") == 0, "test_set.higher (\"f\") == \"five\"");
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_higher (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "four") == 0, "test_set.higher (\"five\") == \"four\"");
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_higher (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "three") == 0, "test_set.higher (\"six\") == \"three\"");
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_higher (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "six") == 0, "test_set.higher (\"s\") == \"six\"");
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_floor (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_floor (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.floor (\"one\") == null");
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp4_, "test_set.add (\"one\")");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp5_, "test_set.add (\"two\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp6_, "test_set.add (\"three\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp7_, "test_set.add (\"four\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp8_, "test_set.add (\"five\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp9_, "test_set.add (\"six\")");
	_tmp10_ = gee_sorted_set_floor (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_set.floor (\"one\") == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_floor (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "four") == 0, "test_set.floor (\"o\") == \"four\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_floor (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "two") == 0, "test_set.floor (\"two\") == \"two\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_floor (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "six") == 0, "test_set.floor (\"t\") == \"six\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_floor (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "three") == 0, "test_set.floor (\"three\") == \"three\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_floor (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "four") == 0, "test_set.floor (\"four\") == \"four\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_floor (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (_tmp23_ == NULL, "test_set.floor (\"f\") == null");
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_floor (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "five") == 0, "test_set.floor (\"five\") == \"five\"");
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_floor (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "six") == 0, "test_set.floor (\"six\") == \"six\"");
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_floor (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "one") == 0, "test_set.floor (\"s\") == \"one\"");
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_ceil (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_ceil (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	_vala_assert (_tmp3_ == NULL, "test_set.ceil (\"one\") == null");
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp4_, "test_set.add (\"one\")");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp5_, "test_set.add (\"two\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp6_, "test_set.add (\"three\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp7_, "test_set.add (\"four\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp8_, "test_set.add (\"five\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp9_, "test_set.add (\"six\")");
	_tmp10_ = gee_sorted_set_ceil (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	_vala_assert (g_strcmp0 (_tmp11_, "one") == 0, "test_set.ceil (\"one\") == \"one\"");
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_ceil (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	_vala_assert (g_strcmp0 (_tmp13_, "one") == 0, "test_set.ceil (\"o\") == \"one\"");
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_ceil (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	_vala_assert (g_strcmp0 (_tmp15_, "two") == 0, "test_set.ceil (\"two\") == \"two\"");
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_ceil (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	_vala_assert (g_strcmp0 (_tmp17_, "three") == 0, "test_set.ceil (\"t\") == \"three\"");
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_ceil (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	_vala_assert (g_strcmp0 (_tmp19_, "three") == 0, "test_set.ceil (\"three\") == \"three\"");
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_ceil (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	_vala_assert (g_strcmp0 (_tmp21_, "four") == 0, "test_set.ceil (\"four\") == \"four\"");
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_ceil (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "five") == 0, "test_set.ceil (\"f\") == \"five\"");
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_ceil (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	_vala_assert (g_strcmp0 (_tmp25_, "five") == 0, "test_set.ceil (\"five\") == \"five\"");
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_ceil (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	_vala_assert (g_strcmp0 (_tmp27_, "six") == 0, "test_set.ceil (\"six\") == \"six\"");
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_ceil (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	_vala_assert (g_strcmp0 (_tmp29_, "six") == 0, "test_set.ceil (\"s\") == \"six\"");
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeBidirIterator* _tmp2_ = NULL;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GeeBidirIterator* _tmp11_ = NULL;
	GeeBidirIterator* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeBidirIterator* _tmp14_;
	gpointer _tmp15_ = NULL;
	gchar* _tmp16_;
	GeeBidirIterator* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GeeBidirIterator* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GeeBidirIterator* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	GeeBidirIterator* _tmp24_;
	gboolean _tmp25_ = FALSE;
	GeeBidirIterator* _tmp26_;
	gboolean _tmp27_ = FALSE;
	GeeBidirIterator* _tmp28_;
	gpointer _tmp29_ = NULL;
	gchar* _tmp30_;
	GeeBidirIterator* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GeeBidirIterator* _tmp33_;
	gboolean _tmp34_ = FALSE;
	GeeBidirIterator* _tmp35_;
	gpointer _tmp36_ = NULL;
	gchar* _tmp37_;
	GeeBidirIterator* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeBidirIterator* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeBidirIterator* _tmp42_;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_;
	GeeBidirIterator* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GeeBidirIterator* _tmp47_;
	gboolean _tmp48_ = FALSE;
	GeeBidirIterator* _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	GeeBidirIterator* _tmp52_;
	gboolean _tmp53_ = FALSE;
	GeeBidirIterator* _tmp54_;
	gboolean _tmp55_ = FALSE;
	GeeBidirIterator* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GeeBidirIterator* _tmp58_;
	gpointer _tmp59_ = NULL;
	gchar* _tmp60_;
	GeeBidirIterator* _tmp61_;
	gboolean _tmp62_ = FALSE;
	GeeBidirIterator* _tmp63_;
	gpointer _tmp64_ = NULL;
	gchar* _tmp65_;
	GeeBidirIterator* _tmp66_;
	gboolean _tmp67_ = FALSE;
	GeeBidirIterator* _tmp68_;
	gpointer _tmp69_ = NULL;
	gchar* _tmp70_;
	GeeBidirIterator* _tmp71_;
	gboolean _tmp72_ = FALSE;
	GeeBidirIterator* _tmp73_;
	gpointer _tmp74_ = NULL;
	gchar* _tmp75_;
	GeeBidirIterator* _tmp76_;
	gboolean _tmp77_ = FALSE;
	GeeBidirIterator* _tmp78_;
	gpointer _tmp79_ = NULL;
	gchar* _tmp80_;
	GeeBidirIterator* _tmp81_;
	gboolean _tmp82_ = FALSE;
	GeeBidirIterator* _tmp83_;
	gpointer _tmp84_ = NULL;
	gchar* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_bidir_iterator (test_set);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_bidir_iterator_has_previous (_tmp3_);
	_vala_assert (!_tmp4_, "!iterator.has_previous ()");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp5_, "test_set.add (\"one\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp6_, "test_set.add (\"two\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp7_, "test_set.add (\"three\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp8_, "test_set.add (\"four\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp9_, "test_set.add (\"five\")");
	_tmp10_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp10_, "test_set.add (\"six\")");
	_tmp11_ = gee_sorted_set_bidir_iterator (test_set);
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = iterator;
	_tmp13_ = gee_iterator_next ((GeeIterator*) _tmp12_);
	_vala_assert (_tmp13_, "iterator.next ()");
	_tmp14_ = iterator;
	_tmp15_ = gee_iterator_get ((GeeIterator*) _tmp14_);
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp16_);
	_tmp17_ = iterator;
	_tmp18_ = gee_bidir_iterator_has_previous (_tmp17_);
	_vala_assert (!_tmp18_, "!iterator.has_previous ()");
	_tmp19_ = iterator;
	_tmp20_ = gee_iterator_next ((GeeIterator*) _tmp19_);
	_vala_assert (_tmp20_, "iterator.next ()");
	_tmp21_ = iterator;
	_tmp22_ = gee_iterator_get ((GeeIterator*) _tmp21_);
	_tmp23_ = (gchar*) _tmp22_;
	_vala_assert (g_strcmp0 (_tmp23_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp23_);
	_tmp24_ = iterator;
	_tmp25_ = gee_bidir_iterator_has_previous (_tmp24_);
	_vala_assert (_tmp25_, "iterator.has_previous ()");
	_tmp26_ = iterator;
	_tmp27_ = gee_iterator_next ((GeeIterator*) _tmp26_);
	_vala_assert (_tmp27_, "iterator.next ()");
	_tmp28_ = iterator;
	_tmp29_ = gee_iterator_get ((GeeIterator*) _tmp28_);
	_tmp30_ = (gchar*) _tmp29_;
	_vala_assert (g_strcmp0 (_tmp30_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp30_);
	_tmp31_ = iterator;
	_tmp32_ = gee_bidir_iterator_has_previous (_tmp31_);
	_vala_assert (_tmp32_, "iterator.has_previous ()");
	_tmp33_ = iterator;
	_tmp34_ = gee_iterator_next ((GeeIterator*) _tmp33_);
	_vala_assert (_tmp34_, "iterator.next ()");
	_tmp35_ = iterator;
	_tmp36_ = gee_iterator_get ((GeeIterator*) _tmp35_);
	_tmp37_ = (gchar*) _tmp36_;
	_vala_assert (g_strcmp0 (_tmp37_, "six") == 0, "iterator.get () == \"six\"");
	_g_free0 (_tmp37_);
	_tmp38_ = iterator;
	_tmp39_ = gee_bidir_iterator_has_previous (_tmp38_);
	_vala_assert (_tmp39_, "iterator.has_previous ()");
	_tmp40_ = iterator;
	_tmp41_ = gee_iterator_next ((GeeIterator*) _tmp40_);
	_vala_assert (_tmp41_, "iterator.next ()");
	_tmp42_ = iterator;
	_tmp43_ = gee_iterator_get ((GeeIterator*) _tmp42_);
	_tmp44_ = (gchar*) _tmp43_;
	_vala_assert (g_strcmp0 (_tmp44_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp44_);
	_tmp45_ = iterator;
	_tmp46_ = gee_bidir_iterator_has_previous (_tmp45_);
	_vala_assert (_tmp46_, "iterator.has_previous ()");
	_tmp47_ = iterator;
	_tmp48_ = gee_iterator_next ((GeeIterator*) _tmp47_);
	_vala_assert (_tmp48_, "iterator.next ()");
	_tmp49_ = iterator;
	_tmp50_ = gee_iterator_get ((GeeIterator*) _tmp49_);
	_tmp51_ = (gchar*) _tmp50_;
	_vala_assert (g_strcmp0 (_tmp51_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp51_);
	_tmp52_ = iterator;
	_tmp53_ = gee_bidir_iterator_has_previous (_tmp52_);
	_vala_assert (_tmp53_, "iterator.has_previous ()");
	_tmp54_ = iterator;
	_tmp55_ = gee_iterator_next ((GeeIterator*) _tmp54_);
	_vala_assert (!_tmp55_, "!iterator.next ()");
	_tmp56_ = iterator;
	_tmp57_ = gee_bidir_iterator_previous (_tmp56_);
	_vala_assert (_tmp57_, "iterator.previous ()");
	_tmp58_ = iterator;
	_tmp59_ = gee_iterator_get ((GeeIterator*) _tmp58_);
	_tmp60_ = (gchar*) _tmp59_;
	_vala_assert (g_strcmp0 (_tmp60_, "three") == 0, "iterator.get () == \"three\"");
	_g_free0 (_tmp60_);
	_tmp61_ = iterator;
	_tmp62_ = gee_bidir_iterator_previous (_tmp61_);
	_vala_assert (_tmp62_, "iterator.previous ()");
	_tmp63_ = iterator;
	_tmp64_ = gee_iterator_get ((GeeIterator*) _tmp63_);
	_tmp65_ = (gchar*) _tmp64_;
	_vala_assert (g_strcmp0 (_tmp65_, "six") == 0, "iterator.get () == \"six\"");
	_g_free0 (_tmp65_);
	_tmp66_ = iterator;
	_tmp67_ = gee_bidir_iterator_previous (_tmp66_);
	_vala_assert (_tmp67_, "iterator.previous ()");
	_tmp68_ = iterator;
	_tmp69_ = gee_iterator_get ((GeeIterator*) _tmp68_);
	_tmp70_ = (gchar*) _tmp69_;
	_vala_assert (g_strcmp0 (_tmp70_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp70_);
	_tmp71_ = iterator;
	_tmp72_ = gee_bidir_iterator_previous (_tmp71_);
	_vala_assert (_tmp72_, "iterator.previous ()");
	_tmp73_ = iterator;
	_tmp74_ = gee_iterator_get ((GeeIterator*) _tmp73_);
	_tmp75_ = (gchar*) _tmp74_;
	_vala_assert (g_strcmp0 (_tmp75_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp75_);
	_tmp76_ = iterator;
	_tmp77_ = gee_bidir_iterator_previous (_tmp76_);
	_vala_assert (_tmp77_, "iterator.previous ()");
	_tmp78_ = iterator;
	_tmp79_ = gee_iterator_get ((GeeIterator*) _tmp78_);
	_tmp80_ = (gchar*) _tmp79_;
	_vala_assert (g_strcmp0 (_tmp80_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp80_);
	_tmp81_ = iterator;
	_tmp82_ = gee_bidir_iterator_previous (_tmp81_);
	_vala_assert (!_tmp82_, "!iterator.previous ()");
	_tmp83_ = iterator;
	_tmp84_ = gee_iterator_get ((GeeIterator*) _tmp83_);
	_tmp85_ = (gchar*) _tmp84_;
	_vala_assert (g_strcmp0 (_tmp85_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp85_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeBidirIterator* _tmp2_ = NULL;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GeeBidirIterator* _tmp11_ = NULL;
	GeeBidirIterator* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeBidirIterator* _tmp14_;
	gpointer _tmp15_ = NULL;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_bidir_iterator (test_set);
	iterator = _tmp2_;
	_tmp3_ = iterator;
	_tmp4_ = gee_bidir_iterator_last (_tmp3_);
	_vala_assert (!_tmp4_, "!iterator.last ()");
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "one");
	_vala_assert (_tmp5_, "test_set.add (\"one\")");
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "two");
	_vala_assert (_tmp6_, "test_set.add (\"two\")");
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "three");
	_vala_assert (_tmp7_, "test_set.add (\"three\")");
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "four");
	_vala_assert (_tmp8_, "test_set.add (\"four\")");
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "five");
	_vala_assert (_tmp9_, "test_set.add (\"five\")");
	_tmp10_ = gee_collection_add ((GeeCollection*) test_set, "six");
	_vala_assert (_tmp10_, "test_set.add (\"six\")");
	_tmp11_ = gee_sorted_set_bidir_iterator (test_set);
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = iterator;
	_tmp13_ = gee_bidir_iterator_last (_tmp12_);
	_vala_assert (_tmp13_, "iterator.last ()");
	_tmp14_ = iterator;
	_tmp15_ = gee_iterator_get ((GeeIterator*) _tmp14_);
	_tmp16_ = (gchar*) _tmp15_;
	_vala_assert (g_strcmp0 (_tmp16_, "two") == 0, "iterator.get () == \"two\"");
	_g_free0 (_tmp16_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeSortedSet* _tmp2_;
	GeeBidirIterator* _tmp3_ = NULL;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeSortedSet* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeSortedSet* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeSortedSet* _tmp18_;
	GeeBidirIterator* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GeeBidirIterator* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GeeBidirIterator* _tmp24_;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	GeeBidirIterator* _tmp27_;
	GeeSortedSet* _tmp28_;
	gboolean _tmp29_ = FALSE;
	GeeBidirIterator* _tmp30_;
	gboolean _tmp31_ = FALSE;
	GeeBidirIterator* _tmp32_;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	GeeBidirIterator* _tmp38_;
	gboolean _tmp39_ = FALSE;
	GeeBidirIterator* _tmp40_;
	gboolean _tmp41_ = FALSE;
	GeeBidirIterator* _tmp42_;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_;
	GeeBidirIterator* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GeeBidirIterator* _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* _tmp49_;
	GeeBidirIterator* _tmp50_;
	GeeSortedSet* _tmp51_;
	gboolean _tmp52_ = FALSE;
	GeeBidirIterator* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GeeBidirIterator* _tmp55_;
	gboolean _tmp56_ = FALSE;
	GeeBidirIterator* _tmp57_;
	gboolean _tmp58_ = FALSE;
	GeeBidirIterator* _tmp59_;
	gpointer _tmp60_ = NULL;
	gchar* _tmp61_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((CollectionTests*) self)->test_collection;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp0_) : NULL);
	test_set = _tmp1_;
	_tmp2_ = test_set;
	_tmp3_ = gee_sorted_set_bidir_iterator (_tmp2_);
	iterator = _tmp3_;
	_tmp4_ = iterator;
	_tmp5_ = gee_bidir_iterator_has_previous (_tmp4_);
	_vala_assert (!_tmp5_, "!iterator.has_previous ()");
	_tmp6_ = test_set;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "test_set.add (\"one\")");
	_tmp8_ = test_set;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "test_set.add (\"two\")");
	_tmp10_ = test_set;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "three");
	_vala_assert (_tmp11_, "test_set.add (\"three\")");
	_tmp12_ = test_set;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "four");
	_vala_assert (_tmp13_, "test_set.add (\"four\")");
	_tmp14_ = test_set;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "five");
	_vala_assert (_tmp15_, "test_set.add (\"five\")");
	_tmp16_ = test_set;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "six");
	_vala_assert (_tmp17_, "test_set.add (\"six\")");
	_tmp18_ = test_set;
	_tmp19_ = gee_sorted_set_bidir_iterator (_tmp18_);
	_g_object_unref0 (iterator);
	iterator = _tmp19_;
	_tmp20_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp20_) {
		GeeBidirIterator* _tmp21_;
		_tmp21_ = iterator;
		gee_iterator_remove ((GeeIterator*) _tmp21_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp22_ = iterator;
	_tmp23_ = gee_iterator_next ((GeeIterator*) _tmp22_);
	_vala_assert (_tmp23_, "iterator.next ()");
	_tmp24_ = iterator;
	_tmp25_ = gee_iterator_get ((GeeIterator*) _tmp24_);
	_tmp26_ = (gchar*) _tmp25_;
	_vala_assert (g_strcmp0 (_tmp26_, "five") == 0, "iterator.get () == \"five\"");
	_g_free0 (_tmp26_);
	_tmp27_ = iterator;
	gee_iterator_remove ((GeeIterator*) _tmp27_);
	_tmp28_ = test_set;
	_tmp29_ = gee_collection_contains ((GeeCollection*) _tmp28_, "five");
	_vala_assert (!_tmp29_, "!test_set.contains (\"five\")");
	_tmp30_ = iterator;
	_tmp31_ = gee_iterator_has_next ((GeeIterator*) _tmp30_);
	_vala_assert (_tmp31_, "iterator.has_next ()");
	_tmp32_ = iterator;
	_tmp33_ = gee_bidir_iterator_has_previous (_tmp32_);
	_vala_assert (!_tmp33_, "!iterator.has_previous ()");
	_tmp34_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp34_) {
		GeeBidirIterator* _tmp35_;
		gpointer _tmp36_ = NULL;
		gchar* _tmp37_;
		_tmp35_ = iterator;
		_tmp36_ = gee_iterator_get ((GeeIterator*) _tmp35_);
		_tmp37_ = (gchar*) _tmp36_;
		_g_free0 (_tmp37_);
		exit (0);
	}
	_tmp38_ = iterator;
	_tmp39_ = gee_bidir_iterator_previous (_tmp38_);
	_vala_assert (!_tmp39_, "!iterator.previous ()");
	_tmp40_ = iterator;
	_tmp41_ = gee_iterator_next ((GeeIterator*) _tmp40_);
	_vala_assert (_tmp41_, "iterator.next ()");
	_tmp42_ = iterator;
	_tmp43_ = gee_iterator_get ((GeeIterator*) _tmp42_);
	_tmp44_ = (gchar*) _tmp43_;
	_vala_assert (g_strcmp0 (_tmp44_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp44_);
	_tmp45_ = iterator;
	_tmp46_ = gee_iterator_next ((GeeIterator*) _tmp45_);
	_vala_assert (_tmp46_, "iterator.next ()");
	_tmp47_ = iterator;
	_tmp48_ = gee_iterator_get ((GeeIterator*) _tmp47_);
	_tmp49_ = (gchar*) _tmp48_;
	_vala_assert (g_strcmp0 (_tmp49_, "one") == 0, "iterator.get () == \"one\"");
	_g_free0 (_tmp49_);
	_tmp50_ = iterator;
	gee_iterator_remove ((GeeIterator*) _tmp50_);
	_tmp51_ = test_set;
	_tmp52_ = gee_collection_contains ((GeeCollection*) _tmp51_, "one");
	_vala_assert (!_tmp52_, "!test_set.contains (\"one\")");
	_tmp53_ = iterator;
	_tmp54_ = gee_iterator_has_next ((GeeIterator*) _tmp53_);
	_vala_assert (_tmp54_, "iterator.has_next ()");
	_tmp55_ = iterator;
	_tmp56_ = gee_bidir_iterator_has_previous (_tmp55_);
	_vala_assert (_tmp56_, "iterator.has_previous ()");
	_tmp57_ = iterator;
	_tmp58_ = gee_bidir_iterator_previous (_tmp57_);
	_vala_assert (_tmp58_, "iterator.previous ()");
	_tmp59_ = iterator;
	_tmp60_ = gee_iterator_get ((GeeIterator*) _tmp59_);
	_tmp61_ = (gchar*) _tmp60_;
	_vala_assert (g_strcmp0 (_tmp61_, "four") == 0, "iterator.get () == \"four\"");
	_g_free0 (_tmp61_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


const gchar* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self) {
	const gchar* result = NULL;
	switch (self) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			result = "Head";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			result = "Tail";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			result = "Range";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			result = "Empty";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType sorted_set_tests_sub_set_type_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SORTED_SET_TESTS_SUB_SET_TYPE_HEAD, "SORTED_SET_TESTS_SUB_SET_TYPE_HEAD", "head"}, {SORTED_SET_TESTS_SUB_SET_TYPE_TAIL, "SORTED_SET_TESTS_SUB_SET_TYPE_TAIL", "tail"}, {SORTED_SET_TESTS_SUB_SET_TYPE_SUB, "SORTED_SET_TESTS_SUB_SET_TYPE_SUB", "sub"}, {SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY, "SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY", "empty"}, {0, NULL, NULL}};
		GType sorted_set_tests_sub_set_type_type_id;
		sorted_set_tests_sub_set_type_type_id = g_enum_register_static ("SortedSetTestsSubSetType", values);
		g_once_init_leave (&sorted_set_tests_sub_set_type_type_id__volatile, sorted_set_tests_sub_set_type_type_id);
	}
	return sorted_set_tests_sub_set_type_type_id__volatile;
}


static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_size (self);
}


static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_contains (self);
}


static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_add (self);
}


static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_remove (self);
}


static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator (self);
}


static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_clear (self);
}


static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator_at (self);
}


static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_lower (self);
}


static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_higher (self);
}


static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_ceil (self);
}


static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_floor (self);
}


static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_subsets (self);
}


static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_boundaries (self);
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type) {
	SortedSetTestsSubSet * self = NULL;
	SortedSetTestsSubSetType _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	SortedSetTests* _tmp4_;
	SortedSetTests* _tmp5_;
	SortedSetTestsSubSetType _tmp6_;
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = type;
	_tmp1_ = sorted_set_tests_sub_set_type_to_string (_tmp0_);
	_tmp2_ = g_strdup_printf ("%s Subset", _tmp1_);
	_tmp3_ = _tmp2_;
	self = (SortedSetTestsSubSet*) gee_test_case_construct (object_type, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = test;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->test);
	self->priv->test = _tmp5_;
	_tmp6_ = type;
	self->priv->type = _tmp6_;
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] size", _sorted_set_tests_sub_set_test_size_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains", _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add", _sorted_set_tests_sub_set_test_add_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove", _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator", _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] subsets", _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] boundaries", _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method, self);
	return self;
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type) {
	return sorted_set_tests_sub_set_construct (SORTED_SET_TESTS_TYPE_SUB_SET, test, type);
}


static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	SortedSetTests* _tmp0_;
	SortedSetTests* _tmp1_;
	GeeCollection* _tmp2_;
	GeeSortedSet* _tmp3_;
	SortedSetTestsSubSetType _tmp4_;
	self = (SortedSetTestsSubSet*) base;
	_tmp0_ = self->priv->test;
	gee_test_case_set_up ((GeeTestCase*) _tmp0_);
	_tmp1_ = self->priv->test;
	_tmp2_ = ((CollectionTests*) _tmp1_)->test_collection;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GEE_TYPE_SORTED_SET) ? ((GeeSortedSet*) _tmp2_) : NULL);
	_g_object_unref0 (self->priv->master);
	self->priv->master = _tmp3_;
	_tmp4_ = self->priv->type;
	switch (_tmp4_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp5_;
			GeeSortedSet* _tmp6_ = NULL;
			_tmp5_ = self->priv->master;
			_tmp6_ = gee_sorted_set_head_set (_tmp5_, "one");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp6_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp7_;
			GeeSortedSet* _tmp8_ = NULL;
			_tmp7_ = self->priv->master;
			_tmp8_ = gee_sorted_set_tail_set (_tmp7_, "six");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp8_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp9_;
			GeeSortedSet* _tmp10_ = NULL;
			_tmp9_ = self->priv->master;
			_tmp10_ = gee_sorted_set_sub_set (_tmp9_, "four", "three");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp10_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp11_;
			GeeSortedSet* _tmp12_ = NULL;
			_tmp11_ = self->priv->master;
			_tmp12_ = gee_sorted_set_sub_set (_tmp11_, "three", "four");
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp12_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	SortedSetTests* _tmp0_;
	self = (SortedSetTestsSubSet*) base;
	_tmp0_ = self->priv->test;
	gee_test_case_tear_down ((GeeTestCase*) _tmp0_);
}


void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeSortedSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GeeSortedSet* _tmp14_;
	gboolean _tmp15_ = FALSE;
	GeeSortedSet* _tmp16_;
	gboolean _tmp17_ = FALSE;
	GeeSortedSet* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	SortedSetTestsSubSetType _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subset;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "subset.is_empty");
	_tmp3_ = self->priv->subset;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_assert (_tmp5_ == 0, "subset.size == 0");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "one");
	_vala_assert (_tmp7_, "master.add (\"one\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "two");
	_vala_assert (_tmp9_, "master.add (\"two\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "three");
	_vala_assert (_tmp11_, "master.add (\"three\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_add ((GeeCollection*) _tmp12_, "four");
	_vala_assert (_tmp13_, "master.add (\"four\")");
	_tmp14_ = self->priv->master;
	_tmp15_ = gee_collection_add ((GeeCollection*) _tmp14_, "five");
	_vala_assert (_tmp15_, "master.add (\"five\")");
	_tmp16_ = self->priv->master;
	_tmp17_ = gee_collection_add ((GeeCollection*) _tmp16_, "six");
	_vala_assert (_tmp17_, "master.add (\"six\")");
	_tmp18_ = self->priv->master;
	_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_vala_assert (_tmp20_ == 6, "master.size == 6");
	_tmp21_ = self->priv->type;
	switch (_tmp21_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			GeeSortedSet* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_collection_get_is_empty ((GeeCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_vala_assert (!_tmp24_, "!subset.is_empty");
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_vala_assert (_tmp27_ == 2, "subset.size == 2");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			GeeSortedSet* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_collection_get_is_empty ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_vala_assert (!_tmp30_, "!subset.is_empty");
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_collection_get_size ((GeeCollection*) _tmp31_);
			_tmp33_ = _tmp32_;
			_vala_assert (_tmp33_ == 3, "subset.size == 3");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			GeeSortedSet* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_collection_get_is_empty ((GeeCollection*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_assert (!_tmp36_, "!subset.is_empty");
			_tmp37_ = self->priv->subset;
			_tmp38_ = gee_collection_get_size ((GeeCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			_vala_assert (_tmp39_ == 3, "subset.size == 3");
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			GeeSortedSet* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			_tmp40_ = self->priv->subset;
			_tmp41_ = gee_collection_get_is_empty ((GeeCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_vala_assert (_tmp42_, "subset.is_empty");
			_tmp43_ = self->priv->subset;
			_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_vala_assert (_tmp45_ == 0, "subset.size == 0");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar** _tmp53_;
	gint _tmp53__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_ = NULL;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("five");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp18_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp19_ = g_strdup ("one");
			_tmp20_ = g_strdup ("two");
			_tmp21_ = g_strdup ("three");
			_tmp22_ = g_strdup ("six");
			_tmp23_ = g_new0 (gchar*, 4 + 1);
			_tmp23_[0] = _tmp19_;
			_tmp23_[1] = _tmp20_;
			_tmp23_[2] = _tmp21_;
			_tmp23_[3] = _tmp22_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp23_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_ = NULL;
			_tmp24_ = g_strdup ("two");
			_tmp25_ = g_strdup ("three");
			_tmp26_ = g_strdup ("six");
			_tmp27_ = g_new0 (gchar*, 3 + 1);
			_tmp27_[0] = _tmp24_;
			_tmp27_[1] = _tmp25_;
			_tmp27_[2] = _tmp26_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp27_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp28_ = g_strdup ("one");
			_tmp29_ = g_strdup ("four");
			_tmp30_ = g_strdup ("five");
			_tmp31_ = g_new0 (gchar*, 3 + 1);
			_tmp31_[0] = _tmp28_;
			_tmp31_[1] = _tmp29_;
			_tmp31_[2] = _tmp30_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp31_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_ = NULL;
			_tmp32_ = g_strdup ("one");
			_tmp33_ = g_strdup ("four");
			_tmp34_ = g_strdup ("six");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp35_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp36_ = g_strdup ("two");
			_tmp37_ = g_strdup ("three");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_new0 (gchar*, 3 + 1);
			_tmp39_[0] = _tmp36_;
			_tmp39_[1] = _tmp37_;
			_tmp39_[2] = _tmp38_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp39_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar** _tmp47_ = NULL;
			_tmp40_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp40_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp41_ = g_strdup ("one");
			_tmp42_ = g_strdup ("two");
			_tmp43_ = g_strdup ("three");
			_tmp44_ = g_strdup ("four");
			_tmp45_ = g_strdup ("five");
			_tmp46_ = g_strdup ("six");
			_tmp47_ = g_new0 (gchar*, 6 + 1);
			_tmp47_[0] = _tmp41_;
			_tmp47_[1] = _tmp42_;
			_tmp47_[2] = _tmp43_;
			_tmp47_[3] = _tmp44_;
			_tmp47_[4] = _tmp45_;
			_tmp47_[5] = _tmp46_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp47_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp48_ = contains;
	_tmp48__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp48_;
		s_collection_length1 = _tmp48__length1;
		for (s_it = 0; s_it < _tmp48__length1; s_it = s_it + 1) {
			gchar* _tmp49_;
			gchar* s = NULL;
			_tmp49_ = g_strdup (s_collection[s_it]);
			s = _tmp49_;
			{
				GeeSortedSet* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				_tmp50_ = self->priv->subset;
				_tmp51_ = s;
				_tmp52_ = gee_collection_contains ((GeeCollection*) _tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "subset.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp53_ = not_contains;
	_tmp53__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp53_;
		s_collection_length1 = _tmp53__length1;
		for (s_it = 0; s_it < _tmp53__length1; s_it = s_it + 1) {
			gchar* _tmp54_;
			gchar* s = NULL;
			_tmp54_ = g_strdup (s_collection[s_it]);
			s = _tmp54_;
			{
				GeeSortedSet* _tmp55_;
				const gchar* _tmp56_;
				gboolean _tmp57_ = FALSE;
				_tmp55_ = self->priv->subset;
				_tmp56_ = s;
				_tmp57_ = gee_collection_contains ((GeeCollection*) _tmp55_, _tmp56_);
				_vala_assert (!_tmp57_, "!subset.contains (s)");
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** success = NULL;
	gint success_length1 = 0;
	gint _success_size_ = 0;
	gchar** fail = NULL;
	gint fail_length1 = 0;
	gint _fail_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar** _tmp51_;
	gint _tmp51__length1;
	GeeSortedSet* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar** _tmp21_ = NULL;
			_tmp16_ = g_strdup ("a");
			_tmp17_ = g_strdup ("o");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp18_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp19_ = g_strdup ("oz");
			_tmp20_ = g_strdup ("z");
			_tmp21_ = g_new0 (gchar*, 2 + 1);
			_tmp21_[0] = _tmp19_;
			_tmp21_[1] = _tmp20_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp21_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar** _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			_tmp22_ = g_strdup ("siz");
			_tmp23_ = g_strdup ("z");
			_tmp24_ = g_new0 (gchar*, 2 + 1);
			_tmp24_[0] = _tmp22_;
			_tmp24_[1] = _tmp23_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp24_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp25_ = g_strdup ("sia");
			_tmp26_ = g_strdup ("a");
			_tmp27_ = g_new0 (gchar*, 2 + 1);
			_tmp27_[0] = _tmp25_;
			_tmp27_[1] = _tmp26_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp27_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar** _tmp33_ = NULL;
			_tmp28_ = g_strdup ("o");
			_tmp29_ = g_strdup ("th");
			_tmp30_ = g_new0 (gchar*, 2 + 1);
			_tmp30_[0] = _tmp28_;
			_tmp30_[1] = _tmp29_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp30_;
			success_length1 = 2;
			_success_size_ = success_length1;
			_tmp31_ = g_strdup ("f");
			_tmp32_ = g_strdup ("u");
			_tmp33_ = g_new0 (gchar*, 2 + 1);
			_tmp33_[0] = _tmp31_;
			_tmp33_[1] = _tmp32_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp33_;
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_ = NULL;
			_tmp34_ = g_new0 (gchar*, 0 + 1);
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success = _tmp34_;
			success_length1 = 0;
			_success_size_ = success_length1;
			_tmp35_ = g_strdup ("o");
			_tmp36_ = g_strdup ("th");
			_tmp37_ = g_strdup ("f");
			_tmp38_ = g_strdup ("u");
			_tmp39_ = g_new0 (gchar*, 4 + 1);
			_tmp39_[0] = _tmp35_;
			_tmp39_[1] = _tmp36_;
			_tmp39_[2] = _tmp37_;
			_tmp39_[3] = _tmp38_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail = _tmp39_;
			fail_length1 = 4;
			_fail_size_ = fail_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp40_ = success;
	_tmp40__length1 = success_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp40_;
		s_collection_length1 = _tmp40__length1;
		for (s_it = 0; s_it < _tmp40__length1; s_it = s_it + 1) {
			gchar* _tmp41_;
			gchar* s = NULL;
			_tmp41_ = g_strdup (s_collection[s_it]);
			s = _tmp41_;
			{
				GeeSortedSet* _tmp42_;
				const gchar* _tmp43_;
				gboolean _tmp44_ = FALSE;
				GeeSortedSet* _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp47_ = FALSE;
				GeeSortedSet* _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp50_ = FALSE;
				_tmp42_ = self->priv->subset;
				_tmp43_ = s;
				_tmp44_ = gee_collection_add ((GeeCollection*) _tmp42_, _tmp43_);
				_vala_assert (_tmp44_, "subset.add (s)");
				_tmp45_ = self->priv->subset;
				_tmp46_ = s;
				_tmp47_ = gee_collection_contains ((GeeCollection*) _tmp45_, _tmp46_);
				_vala_assert (_tmp47_, "subset.contains (s)");
				_tmp48_ = self->priv->master;
				_tmp49_ = s;
				_tmp50_ = gee_collection_contains ((GeeCollection*) _tmp48_, _tmp49_);
				_vala_assert (_tmp50_, "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp51_ = fail;
	_tmp51__length1 = fail_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp51_;
		s_collection_length1 = _tmp51__length1;
		for (s_it = 0; s_it < _tmp51__length1; s_it = s_it + 1) {
			gchar* _tmp52_;
			gchar* s = NULL;
			_tmp52_ = g_strdup (s_collection[s_it]);
			s = _tmp52_;
			{
				GeeSortedSet* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				GeeSortedSet* _tmp56_;
				const gchar* _tmp57_;
				gboolean _tmp58_ = FALSE;
				GeeSortedSet* _tmp59_;
				const gchar* _tmp60_;
				gboolean _tmp61_ = FALSE;
				_tmp53_ = self->priv->subset;
				_tmp54_ = s;
				_tmp55_ = gee_collection_add ((GeeCollection*) _tmp53_, _tmp54_);
				_vala_assert (!_tmp55_, "!subset.add (s)");
				_tmp56_ = self->priv->subset;
				_tmp57_ = s;
				_tmp58_ = gee_collection_contains ((GeeCollection*) _tmp56_, _tmp57_);
				_vala_assert (!_tmp58_, "!subset.contains (s)");
				_tmp59_ = self->priv->master;
				_tmp60_ = s;
				_tmp61_ = gee_collection_contains ((GeeCollection*) _tmp59_, _tmp60_);
				_vala_assert (!_tmp61_, "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp62_ = self->priv->master;
	_tmp63_ = gee_collection_get_size ((GeeCollection*) _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = success;
	_tmp65__length1 = success_length1;
	_vala_assert (_tmp64_ == (6 + _tmp65__length1), "master.size == 6 + success.length");
	fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
	success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar** _tmp56_;
	gint _tmp56__length1;
	GeeSortedSet* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_ = NULL;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("five");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp18_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp19_ = g_strdup ("one");
			_tmp20_ = g_strdup ("two");
			_tmp21_ = g_strdup ("three");
			_tmp22_ = g_strdup ("six");
			_tmp23_ = g_new0 (gchar*, 4 + 1);
			_tmp23_[0] = _tmp19_;
			_tmp23_[1] = _tmp20_;
			_tmp23_[2] = _tmp21_;
			_tmp23_[3] = _tmp22_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp23_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_ = NULL;
			_tmp24_ = g_strdup ("two");
			_tmp25_ = g_strdup ("three");
			_tmp26_ = g_strdup ("six");
			_tmp27_ = g_new0 (gchar*, 3 + 1);
			_tmp27_[0] = _tmp24_;
			_tmp27_[1] = _tmp25_;
			_tmp27_[2] = _tmp26_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp27_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp28_ = g_strdup ("one");
			_tmp29_ = g_strdup ("four");
			_tmp30_ = g_strdup ("five");
			_tmp31_ = g_new0 (gchar*, 3 + 1);
			_tmp31_[0] = _tmp28_;
			_tmp31_[1] = _tmp29_;
			_tmp31_[2] = _tmp30_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp31_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_ = NULL;
			_tmp32_ = g_strdup ("one");
			_tmp33_ = g_strdup ("four");
			_tmp34_ = g_strdup ("six");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp35_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp36_ = g_strdup ("two");
			_tmp37_ = g_strdup ("three");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_new0 (gchar*, 3 + 1);
			_tmp39_[0] = _tmp36_;
			_tmp39_[1] = _tmp37_;
			_tmp39_[2] = _tmp38_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp39_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar** _tmp47_ = NULL;
			_tmp40_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp40_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp41_ = g_strdup ("one");
			_tmp42_ = g_strdup ("two");
			_tmp43_ = g_strdup ("three");
			_tmp44_ = g_strdup ("four");
			_tmp45_ = g_strdup ("five");
			_tmp46_ = g_strdup ("six");
			_tmp47_ = g_new0 (gchar*, 6 + 1);
			_tmp47_[0] = _tmp41_;
			_tmp47_[1] = _tmp42_;
			_tmp47_[2] = _tmp43_;
			_tmp47_[3] = _tmp44_;
			_tmp47_[4] = _tmp45_;
			_tmp47_[5] = _tmp46_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp47_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp48_ = contains;
	_tmp48__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp48_;
		s_collection_length1 = _tmp48__length1;
		for (s_it = 0; s_it < _tmp48__length1; s_it = s_it + 1) {
			gchar* _tmp49_;
			gchar* s = NULL;
			_tmp49_ = g_strdup (s_collection[s_it]);
			s = _tmp49_;
			{
				GeeSortedSet* _tmp50_;
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				GeeSortedSet* _tmp53_;
				const gchar* _tmp54_;
				gboolean _tmp55_ = FALSE;
				_tmp50_ = self->priv->subset;
				_tmp51_ = s;
				_tmp52_ = gee_collection_remove ((GeeCollection*) _tmp50_, _tmp51_);
				_vala_assert (_tmp52_, "subset.remove (s)");
				_tmp53_ = self->priv->master;
				_tmp54_ = s;
				_tmp55_ = gee_collection_contains ((GeeCollection*) _tmp53_, _tmp54_);
				_vala_assert (!_tmp55_, "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp56_ = not_contains;
	_tmp56__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp56_;
		s_collection_length1 = _tmp56__length1;
		for (s_it = 0; s_it < _tmp56__length1; s_it = s_it + 1) {
			gchar* _tmp57_;
			gchar* s = NULL;
			_tmp57_ = g_strdup (s_collection[s_it]);
			s = _tmp57_;
			{
				GeeSortedSet* _tmp58_;
				const gchar* _tmp59_;
				gboolean _tmp60_ = FALSE;
				GeeSortedSet* _tmp61_;
				const gchar* _tmp62_;
				gboolean _tmp63_ = FALSE;
				_tmp58_ = self->priv->subset;
				_tmp59_ = s;
				_tmp60_ = gee_collection_remove ((GeeCollection*) _tmp58_, _tmp59_);
				_vala_assert (!_tmp60_, "!subset.remove (s)");
				_tmp61_ = self->priv->master;
				_tmp62_ = s;
				_tmp63_ = gee_collection_contains ((GeeCollection*) _tmp61_, _tmp62_);
				_vala_assert (_tmp63_, "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp64_ = self->priv->master;
	_tmp65_ = gee_collection_get_size ((GeeCollection*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = contains;
	_tmp67__length1 = contains_length1;
	_vala_assert (_tmp66_ == (6 - _tmp67__length1), "master.size == 6 - contains.length");
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	guint i;
	guint _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	GeeSortedSet* _tmp40_;
	GeeBidirIterator* _tmp41_ = NULL;
	GeeBidirIterator* iter;
	SortedSetTestsSubSetType _tmp42_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			_tmp16_ = g_strdup ("five");
			_tmp17_ = g_strdup ("four");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp18_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar** _tmp22_ = NULL;
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_strdup ("three");
			_tmp21_ = g_strdup ("two");
			_tmp22_ = g_new0 (gchar*, 3 + 1);
			_tmp22_[0] = _tmp19_;
			_tmp22_[1] = _tmp20_;
			_tmp22_[2] = _tmp21_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp22_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar** _tmp26_ = NULL;
			_tmp23_ = g_strdup ("four");
			_tmp24_ = g_strdup ("one");
			_tmp25_ = g_strdup ("six");
			_tmp26_ = g_new0 (gchar*, 3 + 1);
			_tmp26_[0] = _tmp23_;
			_tmp26_[1] = _tmp24_;
			_tmp26_[2] = _tmp25_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp26_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp27_ = NULL;
			_tmp27_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp27_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	i = (guint) 0;
	{
		GeeSortedSet* _tmp28_;
		GeeIterator* _tmp29_ = NULL;
		GeeIterator* _e_it;
		_tmp28_ = self->priv->subset;
		_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
		_e_it = _tmp29_;
		while (TRUE) {
			GeeIterator* _tmp30_;
			gboolean _tmp31_ = FALSE;
			GeeIterator* _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* e;
			const gchar* _tmp34_;
			gchar** _tmp35_;
			gint _tmp35__length1;
			guint _tmp36_;
			const gchar* _tmp37_;
			_tmp30_ = _e_it;
			_tmp31_ = gee_iterator_next (_tmp30_);
			if (!_tmp31_) {
				break;
			}
			_tmp32_ = _e_it;
			_tmp33_ = gee_iterator_get (_tmp32_);
			e = (gchar*) _tmp33_;
			_tmp34_ = e;
			_tmp35_ = contains;
			_tmp35__length1 = contains_length1;
			_tmp36_ = i;
			i = _tmp36_ + 1;
			_tmp37_ = _tmp35_[_tmp36_];
			_vala_assert (g_strcmp0 (_tmp34_, _tmp37_) == 0, "e == contains[i++]");
			_g_free0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	_tmp38_ = i;
	_tmp39_ = contains;
	_tmp39__length1 = contains_length1;
	_vala_assert (_tmp38_ == ((guint) _tmp39__length1), "i == contains.length");
	_tmp40_ = self->priv->subset;
	_tmp41_ = gee_sorted_set_bidir_iterator (_tmp40_);
	iter = _tmp41_;
	_tmp42_ = self->priv->type;
	if (_tmp42_ != SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY) {
		GeeBidirIterator* _tmp43_;
		gboolean _tmp44_ = FALSE;
		GeeBidirIterator* _tmp45_;
		gpointer _tmp46_ = NULL;
		gchar* _tmp47_;
		gchar** _tmp48_;
		gint _tmp48__length1;
		gchar** _tmp49_;
		gint _tmp49__length1;
		const gchar* _tmp50_;
		GeeBidirIterator* _tmp51_;
		gboolean _tmp52_ = FALSE;
		GeeBidirIterator* _tmp53_;
		gpointer _tmp54_ = NULL;
		gchar* _tmp55_;
		gchar** _tmp56_;
		gint _tmp56__length1;
		const gchar* _tmp57_;
		GeeBidirIterator* _tmp58_;
		gboolean _tmp59_ = FALSE;
		GeeBidirIterator* _tmp60_;
		gboolean _tmp61_ = FALSE;
		GeeBidirIterator* _tmp62_;
		gpointer _tmp63_ = NULL;
		gchar* _tmp64_;
		gchar** _tmp65_;
		gint _tmp65__length1;
		const gchar* _tmp66_;
		GeeBidirIterator* _tmp67_;
		gboolean _tmp68_ = FALSE;
		GeeBidirIterator* _tmp69_;
		GeeBidirIterator* _tmp70_;
		gboolean _tmp71_ = FALSE;
		SortedSetTestsSubSetType _tmp72_;
		GeeBidirIterator* _tmp77_;
		gboolean _tmp78_ = FALSE;
		GeeBidirIterator* _tmp79_;
		gpointer _tmp80_ = NULL;
		gchar* _tmp81_;
		gchar** _tmp82_;
		gint _tmp82__length1;
		const gchar* _tmp83_;
		_tmp43_ = iter;
		_tmp44_ = gee_bidir_iterator_last (_tmp43_);
		_vala_assert (_tmp44_, "iter.last ()");
		_tmp45_ = iter;
		_tmp46_ = gee_iterator_get ((GeeIterator*) _tmp45_);
		_tmp47_ = (gchar*) _tmp46_;
		_tmp48_ = contains;
		_tmp48__length1 = contains_length1;
		_tmp49_ = contains;
		_tmp49__length1 = contains_length1;
		_tmp50_ = _tmp48_[_tmp49__length1 - 1];
		_vala_assert (g_strcmp0 (_tmp47_, _tmp50_) == 0, "iter.get () == contains[contains.length - 1]");
		_g_free0 (_tmp47_);
		_tmp51_ = iter;
		_tmp52_ = gee_iterator_first ((GeeIterator*) _tmp51_);
		_vala_assert (_tmp52_, "iter.first ()");
		_tmp53_ = iter;
		_tmp54_ = gee_iterator_get ((GeeIterator*) _tmp53_);
		_tmp55_ = (gchar*) _tmp54_;
		_tmp56_ = contains;
		_tmp56__length1 = contains_length1;
		_tmp57_ = _tmp56_[0];
		_vala_assert (g_strcmp0 (_tmp55_, _tmp57_) == 0, "iter.get () == contains[0]");
		_g_free0 (_tmp55_);
		_tmp58_ = iter;
		_tmp59_ = gee_iterator_has_next ((GeeIterator*) _tmp58_);
		_vala_assert (_tmp59_, "iter.has_next ()");
		_tmp60_ = iter;
		_tmp61_ = gee_iterator_next ((GeeIterator*) _tmp60_);
		_vala_assert (_tmp61_, "iter.next ()");
		_tmp62_ = iter;
		_tmp63_ = gee_iterator_get ((GeeIterator*) _tmp62_);
		_tmp64_ = (gchar*) _tmp63_;
		_tmp65_ = contains;
		_tmp65__length1 = contains_length1;
		_tmp66_ = _tmp65_[1];
		_vala_assert (g_strcmp0 (_tmp64_, _tmp66_) == 0, "iter.get () == contains[1]");
		_g_free0 (_tmp64_);
		_tmp67_ = iter;
		_tmp68_ = gee_bidir_iterator_has_previous (_tmp67_);
		_vala_assert (_tmp68_, "iter.has_previous ()");
		_tmp69_ = iter;
		gee_iterator_remove ((GeeIterator*) _tmp69_);
		_tmp70_ = iter;
		_tmp71_ = gee_bidir_iterator_has_previous (_tmp70_);
		_vala_assert (_tmp71_, "iter.has_previous ()");
		_tmp72_ = self->priv->type;
		if (_tmp72_ != SORTED_SET_TESTS_SUB_SET_TYPE_HEAD) {
			GeeBidirIterator* _tmp73_;
			gboolean _tmp74_ = FALSE;
			_tmp73_ = iter;
			_tmp74_ = gee_iterator_has_next ((GeeIterator*) _tmp73_);
			_vala_assert (_tmp74_, "iter.has_next ()");
		} else {
			GeeBidirIterator* _tmp75_;
			gboolean _tmp76_ = FALSE;
			_tmp75_ = iter;
			_tmp76_ = gee_iterator_has_next ((GeeIterator*) _tmp75_);
			_vala_assert (!_tmp76_, "!iter.has_next ()");
		}
		_tmp77_ = iter;
		_tmp78_ = gee_bidir_iterator_previous (_tmp77_);
		_vala_assert (_tmp78_, "iter.previous ()");
		_tmp79_ = iter;
		_tmp80_ = gee_iterator_get ((GeeIterator*) _tmp79_);
		_tmp81_ = (gchar*) _tmp80_;
		_tmp82_ = contains;
		_tmp82__length1 = contains_length1;
		_tmp83_ = _tmp82_[0];
		_vala_assert (g_strcmp0 (_tmp81_, _tmp83_) == 0, "iter.get () == contains[0]");
		_g_free0 (_tmp81_);
	} else {
		GeeBidirIterator* _tmp84_;
		gboolean _tmp85_ = FALSE;
		gboolean _tmp86_ = FALSE;
		_tmp84_ = iter;
		_tmp85_ = gee_iterator_first ((GeeIterator*) _tmp84_);
		_vala_assert (!_tmp85_, "!iter.first ()");
		_tmp86_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
		if (_tmp86_) {
			GeeBidirIterator* _tmp87_;
			_tmp87_ = iter;
			gee_iterator_remove ((GeeIterator*) _tmp87_);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_g_object_unref0 (iter);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	GeeSortedSet* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp54_;
	gint _tmp54__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_ = NULL;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("five");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp18_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp19_ = g_strdup ("one");
			_tmp20_ = g_strdup ("two");
			_tmp21_ = g_strdup ("three");
			_tmp22_ = g_strdup ("six");
			_tmp23_ = g_new0 (gchar*, 4 + 1);
			_tmp23_[0] = _tmp19_;
			_tmp23_[1] = _tmp20_;
			_tmp23_[2] = _tmp21_;
			_tmp23_[3] = _tmp22_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp23_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_ = NULL;
			_tmp24_ = g_strdup ("two");
			_tmp25_ = g_strdup ("three");
			_tmp26_ = g_strdup ("six");
			_tmp27_ = g_new0 (gchar*, 3 + 1);
			_tmp27_[0] = _tmp24_;
			_tmp27_[1] = _tmp25_;
			_tmp27_[2] = _tmp26_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp27_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp28_ = g_strdup ("one");
			_tmp29_ = g_strdup ("four");
			_tmp30_ = g_strdup ("five");
			_tmp31_ = g_new0 (gchar*, 3 + 1);
			_tmp31_[0] = _tmp28_;
			_tmp31_[1] = _tmp29_;
			_tmp31_[2] = _tmp30_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp31_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_ = NULL;
			_tmp32_ = g_strdup ("one");
			_tmp33_ = g_strdup ("four");
			_tmp34_ = g_strdup ("six");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp35_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp36_ = g_strdup ("two");
			_tmp37_ = g_strdup ("three");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_new0 (gchar*, 3 + 1);
			_tmp39_[0] = _tmp36_;
			_tmp39_[1] = _tmp37_;
			_tmp39_[2] = _tmp38_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp39_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar** _tmp47_ = NULL;
			_tmp40_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp40_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp41_ = g_strdup ("one");
			_tmp42_ = g_strdup ("two");
			_tmp43_ = g_strdup ("three");
			_tmp44_ = g_strdup ("four");
			_tmp45_ = g_strdup ("five");
			_tmp46_ = g_strdup ("six");
			_tmp47_ = g_new0 (gchar*, 6 + 1);
			_tmp47_[0] = _tmp41_;
			_tmp47_[1] = _tmp42_;
			_tmp47_[2] = _tmp43_;
			_tmp47_[3] = _tmp44_;
			_tmp47_[4] = _tmp45_;
			_tmp47_[5] = _tmp46_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp47_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp48_ = self->priv->subset;
	gee_collection_clear ((GeeCollection*) _tmp48_);
	_tmp49_ = contains;
	_tmp49__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp49_;
		s_collection_length1 = _tmp49__length1;
		for (s_it = 0; s_it < _tmp49__length1; s_it = s_it + 1) {
			gchar* _tmp50_;
			gchar* s = NULL;
			_tmp50_ = g_strdup (s_collection[s_it]);
			s = _tmp50_;
			{
				GeeSortedSet* _tmp51_;
				const gchar* _tmp52_;
				gboolean _tmp53_ = FALSE;
				_tmp51_ = self->priv->master;
				_tmp52_ = s;
				_tmp53_ = gee_collection_contains ((GeeCollection*) _tmp51_, _tmp52_);
				_vala_assert (!_tmp53_, "!master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	_tmp54_ = not_contains;
	_tmp54__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp54_;
		s_collection_length1 = _tmp54__length1;
		for (s_it = 0; s_it < _tmp54__length1; s_it = s_it + 1) {
			gchar* _tmp55_;
			gchar* s = NULL;
			_tmp55_ = g_strdup (s_collection[s_it]);
			s = _tmp55_;
			{
				GeeSortedSet* _tmp56_;
				const gchar* _tmp57_;
				gboolean _tmp58_ = FALSE;
				_tmp56_ = self->priv->master;
				_tmp57_ = s;
				_tmp58_ = gee_collection_contains ((GeeCollection*) _tmp56_, _tmp57_);
				_vala_assert (_tmp58_, "master.contains (s)");
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			GeeSortedSet* _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_first (_tmp16_);
			_tmp18_ = (gchar*) _tmp17_;
			_vala_assert (g_strcmp0 (_tmp18_, "five") == 0, "subset.first () == \"five\"");
			_g_free0 (_tmp18_);
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_last (_tmp19_);
			_tmp21_ = (gchar*) _tmp20_;
			_vala_assert (g_strcmp0 (_tmp21_, "four") == 0, "subset.last () == \"four\"");
			_g_free0 (_tmp21_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			GeeSortedSet* _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_sorted_set_first (_tmp22_);
			_tmp24_ = (gchar*) _tmp23_;
			_vala_assert (g_strcmp0 (_tmp24_, "six") == 0, "subset.first () == \"six\"");
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_sorted_set_last (_tmp25_);
			_tmp27_ = (gchar*) _tmp26_;
			_vala_assert (g_strcmp0 (_tmp27_, "two") == 0, "subset.last () == \"two\"");
			_g_free0 (_tmp27_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			GeeSortedSet* _tmp31_;
			gpointer _tmp32_ = NULL;
			gchar* _tmp33_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_sorted_set_first (_tmp28_);
			_tmp30_ = (gchar*) _tmp29_;
			_vala_assert (g_strcmp0 (_tmp30_, "four") == 0, "subset.first () == \"four\"");
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_last (_tmp31_);
			_tmp33_ = (gchar*) _tmp32_;
			_vala_assert (g_strcmp0 (_tmp33_, "six") == 0, "subset.last () == \"six\"");
			_g_free0 (_tmp33_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gboolean _tmp34_ = FALSE;
			gboolean _tmp38_ = FALSE;
			_tmp34_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
			if (_tmp34_) {
				GeeSortedSet* _tmp35_;
				gpointer _tmp36_ = NULL;
				gchar* _tmp37_;
				_tmp35_ = self->priv->subset;
				_tmp36_ = gee_sorted_set_first (_tmp35_);
				_tmp37_ = (gchar*) _tmp36_;
				_g_free0 (_tmp37_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			_tmp38_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
			if (_tmp38_) {
				GeeSortedSet* _tmp39_;
				gpointer _tmp40_ = NULL;
				gchar* _tmp41_;
				_tmp39_ = self->priv->subset;
				_tmp40_ = gee_sorted_set_last (_tmp39_);
				_tmp41_ = (gchar*) _tmp40_;
				_g_free0 (_tmp41_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	SortedSetTestsSubSetType _tmp15_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar** _tmp58_;
	gint _tmp58__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar** _tmp23_ = NULL;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("five");
			_tmp18_ = g_new0 (gchar*, 2 + 1);
			_tmp18_[0] = _tmp16_;
			_tmp18_[1] = _tmp17_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp18_;
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			_tmp19_ = g_strdup ("one");
			_tmp20_ = g_strdup ("two");
			_tmp21_ = g_strdup ("three");
			_tmp22_ = g_strdup ("six");
			_tmp23_ = g_new0 (gchar*, 4 + 1);
			_tmp23_[0] = _tmp19_;
			_tmp23_[1] = _tmp20_;
			_tmp23_[2] = _tmp21_;
			_tmp23_[3] = _tmp22_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp23_;
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar** _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar** _tmp31_ = NULL;
			_tmp24_ = g_strdup ("two");
			_tmp25_ = g_strdup ("three");
			_tmp26_ = g_strdup ("six");
			_tmp27_ = g_new0 (gchar*, 3 + 1);
			_tmp27_[0] = _tmp24_;
			_tmp27_[1] = _tmp25_;
			_tmp27_[2] = _tmp26_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp27_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp28_ = g_strdup ("one");
			_tmp29_ = g_strdup ("four");
			_tmp30_ = g_strdup ("five");
			_tmp31_ = g_new0 (gchar*, 3 + 1);
			_tmp31_[0] = _tmp28_;
			_tmp31_[1] = _tmp29_;
			_tmp31_[2] = _tmp30_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp31_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar** _tmp39_ = NULL;
			_tmp32_ = g_strdup ("one");
			_tmp33_ = g_strdup ("four");
			_tmp34_ = g_strdup ("six");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp35_;
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			_tmp36_ = g_strdup ("two");
			_tmp37_ = g_strdup ("three");
			_tmp38_ = g_strdup ("five");
			_tmp39_ = g_new0 (gchar*, 3 + 1);
			_tmp39_[0] = _tmp36_;
			_tmp39_[1] = _tmp37_;
			_tmp39_[2] = _tmp38_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp39_;
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp40_ = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar** _tmp47_ = NULL;
			_tmp40_ = g_new0 (gchar*, 0 + 1);
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains = _tmp40_;
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			_tmp41_ = g_strdup ("one");
			_tmp42_ = g_strdup ("two");
			_tmp43_ = g_strdup ("three");
			_tmp44_ = g_strdup ("four");
			_tmp45_ = g_strdup ("five");
			_tmp46_ = g_strdup ("six");
			_tmp47_ = g_new0 (gchar*, 6 + 1);
			_tmp47_[0] = _tmp41_;
			_tmp47_[1] = _tmp42_;
			_tmp47_[2] = _tmp43_;
			_tmp47_[3] = _tmp44_;
			_tmp47_[4] = _tmp45_;
			_tmp47_[5] = _tmp46_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains = _tmp47_;
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp48_ = contains;
	_tmp48__length1 = contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp48_;
		s_collection_length1 = _tmp48__length1;
		for (s_it = 0; s_it < _tmp48__length1; s_it = s_it + 1) {
			gchar* _tmp49_;
			gchar* s = NULL;
			_tmp49_ = g_strdup (s_collection[s_it]);
			s = _tmp49_;
			{
				GeeSortedSet* _tmp50_;
				const gchar* _tmp51_;
				GeeBidirIterator* _tmp52_ = NULL;
				GeeBidirIterator* iter;
				GeeBidirIterator* _tmp53_;
				GeeBidirIterator* _tmp54_;
				gpointer _tmp55_ = NULL;
				gchar* _tmp56_;
				const gchar* _tmp57_;
				_tmp50_ = self->priv->subset;
				_tmp51_ = s;
				_tmp52_ = gee_sorted_set_iterator_at (_tmp50_, _tmp51_);
				iter = _tmp52_;
				_tmp53_ = iter;
				_vala_assert (_tmp53_ != NULL, "iter != null");
				_tmp54_ = iter;
				_tmp55_ = gee_iterator_get ((GeeIterator*) _tmp54_);
				_tmp56_ = (gchar*) _tmp55_;
				_tmp57_ = s;
				_vala_assert (g_strcmp0 (_tmp56_, _tmp57_) == 0, "iter.get () == s");
				_g_free0 (_tmp56_);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	_tmp58_ = not_contains;
	_tmp58__length1 = not_contains_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp58_;
		s_collection_length1 = _tmp58__length1;
		for (s_it = 0; s_it < _tmp58__length1; s_it = s_it + 1) {
			gchar* _tmp59_;
			gchar* s = NULL;
			_tmp59_ = g_strdup (s_collection[s_it]);
			s = _tmp59_;
			{
				GeeSortedSet* _tmp60_;
				const gchar* _tmp61_;
				GeeBidirIterator* _tmp62_ = NULL;
				GeeBidirIterator* iter;
				GeeBidirIterator* _tmp63_;
				_tmp60_ = self->priv->subset;
				_tmp61_ = s;
				_tmp62_ = gee_sorted_set_iterator_at (_tmp60_, _tmp61_);
				iter = _tmp62_;
				_tmp63_ = iter;
				_vala_assert (_tmp63_ == NULL, "iter == null");
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			GeeSortedSet* _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* _tmp21_;
			GeeSortedSet* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			GeeSortedSet* _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_lower (_tmp16_, "a");
			_tmp18_ = (gchar*) _tmp17_;
			_vala_assert (_tmp18_ == NULL, "subset.lower (\"a\") == null");
			_g_free0 (_tmp18_);
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_lower (_tmp19_, "five");
			_tmp21_ = (gchar*) _tmp20_;
			_vala_assert (_tmp21_ == NULL, "subset.lower (\"five\") == null");
			_g_free0 (_tmp21_);
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_sorted_set_lower (_tmp22_, "four");
			_tmp24_ = (gchar*) _tmp23_;
			_vala_assert (g_strcmp0 (_tmp24_, "five") == 0, "subset.lower (\"four\") == \"five\"");
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_sorted_set_lower (_tmp25_, "six");
			_tmp27_ = (gchar*) _tmp26_;
			_vala_assert (g_strcmp0 (_tmp27_, "four") == 0, "subset.lower (\"six\") == \"four\"");
			_g_free0 (_tmp27_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			GeeSortedSet* _tmp31_;
			gpointer _tmp32_ = NULL;
			gchar* _tmp33_;
			GeeSortedSet* _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			GeeSortedSet* _tmp37_;
			gpointer _tmp38_ = NULL;
			gchar* _tmp39_;
			GeeSortedSet* _tmp40_;
			gpointer _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_sorted_set_lower (_tmp28_, "one");
			_tmp30_ = (gchar*) _tmp29_;
			_vala_assert (_tmp30_ == NULL, "subset.lower (\"one\") == null");
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_lower (_tmp31_, "six");
			_tmp33_ = (gchar*) _tmp32_;
			_vala_assert (_tmp33_ == NULL, "subset.lower (\"six\") == null");
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_sorted_set_lower (_tmp34_, "three");
			_tmp36_ = (gchar*) _tmp35_;
			_vala_assert (g_strcmp0 (_tmp36_, "six") == 0, "subset.lower (\"three\") == \"six\"");
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->subset;
			_tmp38_ = gee_sorted_set_lower (_tmp37_, "two");
			_tmp39_ = (gchar*) _tmp38_;
			_vala_assert (g_strcmp0 (_tmp39_, "three") == 0, "subset.lower (\"two\") == \"three\"");
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->subset;
			_tmp41_ = gee_sorted_set_lower (_tmp40_, "z");
			_tmp42_ = (gchar*) _tmp41_;
			_vala_assert (g_strcmp0 (_tmp42_, "two") == 0, "subset.lower (\"z\") == \"two\"");
			_g_free0 (_tmp42_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp43_;
			gpointer _tmp44_ = NULL;
			gchar* _tmp45_;
			GeeSortedSet* _tmp46_;
			gpointer _tmp47_ = NULL;
			gchar* _tmp48_;
			GeeSortedSet* _tmp49_;
			gpointer _tmp50_ = NULL;
			gchar* _tmp51_;
			GeeSortedSet* _tmp52_;
			gpointer _tmp53_ = NULL;
			gchar* _tmp54_;
			GeeSortedSet* _tmp55_;
			gpointer _tmp56_ = NULL;
			gchar* _tmp57_;
			_tmp43_ = self->priv->subset;
			_tmp44_ = gee_sorted_set_lower (_tmp43_, "five");
			_tmp45_ = (gchar*) _tmp44_;
			_vala_assert (_tmp45_ == NULL, "subset.lower (\"five\") == null");
			_g_free0 (_tmp45_);
			_tmp46_ = self->priv->subset;
			_tmp47_ = gee_sorted_set_lower (_tmp46_, "four");
			_tmp48_ = (gchar*) _tmp47_;
			_vala_assert (_tmp48_ == NULL, "subset.lower (\"four\") == null");
			_g_free0 (_tmp48_);
			_tmp49_ = self->priv->subset;
			_tmp50_ = gee_sorted_set_lower (_tmp49_, "one");
			_tmp51_ = (gchar*) _tmp50_;
			_vala_assert (g_strcmp0 (_tmp51_, "four") == 0, "subset.lower (\"one\") == \"four\"");
			_g_free0 (_tmp51_);
			_tmp52_ = self->priv->subset;
			_tmp53_ = gee_sorted_set_lower (_tmp52_, "six");
			_tmp54_ = (gchar*) _tmp53_;
			_vala_assert (g_strcmp0 (_tmp54_, "one") == 0, "subset.lower (\"six\") == \"one\"");
			_g_free0 (_tmp54_);
			_tmp55_ = self->priv->subset;
			_tmp56_ = gee_sorted_set_lower (_tmp55_, "three");
			_tmp57_ = (gchar*) _tmp56_;
			_vala_assert (g_strcmp0 (_tmp57_, "six") == 0, "subset.lower (\"three\") == \"six\"");
			_g_free0 (_tmp57_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp58_;
			gpointer _tmp59_ = NULL;
			gchar* _tmp60_;
			_tmp58_ = self->priv->subset;
			_tmp59_ = gee_sorted_set_lower (_tmp58_, "six");
			_tmp60_ = (gchar*) _tmp59_;
			_vala_assert (_tmp60_ == NULL, "subset.lower (\"six\") == null");
			_g_free0 (_tmp60_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			GeeSortedSet* _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* _tmp21_;
			GeeSortedSet* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			GeeSortedSet* _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_higher (_tmp16_, "a");
			_tmp18_ = (gchar*) _tmp17_;
			_vala_assert (g_strcmp0 (_tmp18_, "five") == 0, "subset.higher (\"a\") == \"five\"");
			_g_free0 (_tmp18_);
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_higher (_tmp19_, "five");
			_tmp21_ = (gchar*) _tmp20_;
			_vala_assert (g_strcmp0 (_tmp21_, "four") == 0, "subset.higher (\"five\") == \"four\"");
			_g_free0 (_tmp21_);
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_sorted_set_higher (_tmp22_, "four");
			_tmp24_ = (gchar*) _tmp23_;
			_vala_assert (_tmp24_ == NULL, "subset.higher (\"four\") == null");
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_sorted_set_higher (_tmp25_, "six");
			_tmp27_ = (gchar*) _tmp26_;
			_vala_assert (_tmp27_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp27_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			GeeSortedSet* _tmp31_;
			gpointer _tmp32_ = NULL;
			gchar* _tmp33_;
			GeeSortedSet* _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			GeeSortedSet* _tmp37_;
			gpointer _tmp38_ = NULL;
			gchar* _tmp39_;
			GeeSortedSet* _tmp40_;
			gpointer _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_sorted_set_higher (_tmp28_, "one");
			_tmp30_ = (gchar*) _tmp29_;
			_vala_assert (g_strcmp0 (_tmp30_, "six") == 0, "subset.higher (\"one\") == \"six\"");
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_higher (_tmp31_, "six");
			_tmp33_ = (gchar*) _tmp32_;
			_vala_assert (g_strcmp0 (_tmp33_, "three") == 0, "subset.higher (\"six\") == \"three\"");
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_sorted_set_higher (_tmp34_, "three");
			_tmp36_ = (gchar*) _tmp35_;
			_vala_assert (g_strcmp0 (_tmp36_, "two") == 0, "subset.higher (\"three\") == \"two\"");
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->subset;
			_tmp38_ = gee_sorted_set_higher (_tmp37_, "two");
			_tmp39_ = (gchar*) _tmp38_;
			_vala_assert (_tmp39_ == NULL, "subset.higher (\"two\") == null");
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->subset;
			_tmp41_ = gee_sorted_set_higher (_tmp40_, "z");
			_tmp42_ = (gchar*) _tmp41_;
			_vala_assert (_tmp42_ == NULL, "subset.higher (\"z\") == null");
			_g_free0 (_tmp42_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp43_;
			gpointer _tmp44_ = NULL;
			gchar* _tmp45_;
			GeeSortedSet* _tmp46_;
			gpointer _tmp47_ = NULL;
			gchar* _tmp48_;
			GeeSortedSet* _tmp49_;
			gpointer _tmp50_ = NULL;
			gchar* _tmp51_;
			GeeSortedSet* _tmp52_;
			gpointer _tmp53_ = NULL;
			gchar* _tmp54_;
			GeeSortedSet* _tmp55_;
			gpointer _tmp56_ = NULL;
			gchar* _tmp57_;
			_tmp43_ = self->priv->subset;
			_tmp44_ = gee_sorted_set_higher (_tmp43_, "five");
			_tmp45_ = (gchar*) _tmp44_;
			_vala_assert (g_strcmp0 (_tmp45_, "four") == 0, "subset.higher (\"five\") == \"four\"");
			_g_free0 (_tmp45_);
			_tmp46_ = self->priv->subset;
			_tmp47_ = gee_sorted_set_higher (_tmp46_, "four");
			_tmp48_ = (gchar*) _tmp47_;
			_vala_assert (g_strcmp0 (_tmp48_, "one") == 0, "subset.higher (\"four\") == \"one\"");
			_g_free0 (_tmp48_);
			_tmp49_ = self->priv->subset;
			_tmp50_ = gee_sorted_set_higher (_tmp49_, "one");
			_tmp51_ = (gchar*) _tmp50_;
			_vala_assert (g_strcmp0 (_tmp51_, "six") == 0, "subset.higher (\"one\") == \"six\"");
			_g_free0 (_tmp51_);
			_tmp52_ = self->priv->subset;
			_tmp53_ = gee_sorted_set_higher (_tmp52_, "six");
			_tmp54_ = (gchar*) _tmp53_;
			_vala_assert (_tmp54_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp54_);
			_tmp55_ = self->priv->subset;
			_tmp56_ = gee_sorted_set_higher (_tmp55_, "three");
			_tmp57_ = (gchar*) _tmp56_;
			_vala_assert (_tmp57_ == NULL, "subset.higher (\"three\") == null");
			_g_free0 (_tmp57_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp58_;
			gpointer _tmp59_ = NULL;
			gchar* _tmp60_;
			_tmp58_ = self->priv->subset;
			_tmp59_ = gee_sorted_set_higher (_tmp58_, "six");
			_tmp60_ = (gchar*) _tmp59_;
			_vala_assert (_tmp60_ == NULL, "subset.higher (\"six\") == null");
			_g_free0 (_tmp60_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			GeeSortedSet* _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* _tmp21_;
			GeeSortedSet* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			GeeSortedSet* _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_floor (_tmp16_, "a");
			_tmp18_ = (gchar*) _tmp17_;
			_vala_assert (_tmp18_ == NULL, "subset.floor (\"a\") == null");
			_g_free0 (_tmp18_);
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_floor (_tmp19_, "five");
			_tmp21_ = (gchar*) _tmp20_;
			_vala_assert (g_strcmp0 (_tmp21_, "five") == 0, "subset.floor (\"five\") == \"five\"");
			_g_free0 (_tmp21_);
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_sorted_set_floor (_tmp22_, "four");
			_tmp24_ = (gchar*) _tmp23_;
			_vala_assert (g_strcmp0 (_tmp24_, "four") == 0, "subset.floor (\"four\") == \"four\"");
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_sorted_set_floor (_tmp25_, "six");
			_tmp27_ = (gchar*) _tmp26_;
			_vala_assert (g_strcmp0 (_tmp27_, "four") == 0, "subset.floor (\"six\") == \"four\"");
			_g_free0 (_tmp27_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			GeeSortedSet* _tmp31_;
			gpointer _tmp32_ = NULL;
			gchar* _tmp33_;
			GeeSortedSet* _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			GeeSortedSet* _tmp37_;
			gpointer _tmp38_ = NULL;
			gchar* _tmp39_;
			GeeSortedSet* _tmp40_;
			gpointer _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_sorted_set_floor (_tmp28_, "one");
			_tmp30_ = (gchar*) _tmp29_;
			_vala_assert (_tmp30_ == NULL, "subset.floor (\"one\") == null");
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_floor (_tmp31_, "six");
			_tmp33_ = (gchar*) _tmp32_;
			_vala_assert (g_strcmp0 (_tmp33_, "six") == 0, "subset.floor (\"six\") == \"six\"");
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_sorted_set_floor (_tmp34_, "three");
			_tmp36_ = (gchar*) _tmp35_;
			_vala_assert (g_strcmp0 (_tmp36_, "three") == 0, "subset.floor (\"three\") == \"three\"");
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->subset;
			_tmp38_ = gee_sorted_set_floor (_tmp37_, "two");
			_tmp39_ = (gchar*) _tmp38_;
			_vala_assert (g_strcmp0 (_tmp39_, "two") == 0, "subset.floor (\"two\") == \"two\"");
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->subset;
			_tmp41_ = gee_sorted_set_floor (_tmp40_, "z");
			_tmp42_ = (gchar*) _tmp41_;
			_vala_assert (g_strcmp0 (_tmp42_, "two") == 0, "subset.floor (\"z\") == \"two\"");
			_g_free0 (_tmp42_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp43_;
			gpointer _tmp44_ = NULL;
			gchar* _tmp45_;
			GeeSortedSet* _tmp46_;
			gpointer _tmp47_ = NULL;
			gchar* _tmp48_;
			GeeSortedSet* _tmp49_;
			gpointer _tmp50_ = NULL;
			gchar* _tmp51_;
			GeeSortedSet* _tmp52_;
			gpointer _tmp53_ = NULL;
			gchar* _tmp54_;
			GeeSortedSet* _tmp55_;
			gpointer _tmp56_ = NULL;
			gchar* _tmp57_;
			_tmp43_ = self->priv->subset;
			_tmp44_ = gee_sorted_set_floor (_tmp43_, "five");
			_tmp45_ = (gchar*) _tmp44_;
			_vala_assert (_tmp45_ == NULL, "subset.floor (\"five\") == null");
			_g_free0 (_tmp45_);
			_tmp46_ = self->priv->subset;
			_tmp47_ = gee_sorted_set_floor (_tmp46_, "four");
			_tmp48_ = (gchar*) _tmp47_;
			_vala_assert (g_strcmp0 (_tmp48_, "four") == 0, "subset.floor (\"four\") == \"four\"");
			_g_free0 (_tmp48_);
			_tmp49_ = self->priv->subset;
			_tmp50_ = gee_sorted_set_floor (_tmp49_, "one");
			_tmp51_ = (gchar*) _tmp50_;
			_vala_assert (g_strcmp0 (_tmp51_, "one") == 0, "subset.floor (\"one\") == \"one\"");
			_g_free0 (_tmp51_);
			_tmp52_ = self->priv->subset;
			_tmp53_ = gee_sorted_set_floor (_tmp52_, "six");
			_tmp54_ = (gchar*) _tmp53_;
			_vala_assert (g_strcmp0 (_tmp54_, "six") == 0, "subset.floor (\"six\") == \"six\"");
			_g_free0 (_tmp54_);
			_tmp55_ = self->priv->subset;
			_tmp56_ = gee_sorted_set_floor (_tmp55_, "three");
			_tmp57_ = (gchar*) _tmp56_;
			_vala_assert (g_strcmp0 (_tmp57_, "six") == 0, "subset.floor (\"three\") == \"six\"");
			_g_free0 (_tmp57_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp58_;
			gpointer _tmp59_ = NULL;
			gchar* _tmp60_;
			_tmp58_ = self->priv->subset;
			_tmp59_ = gee_sorted_set_floor (_tmp58_, "six");
			_tmp60_ = (gchar*) _tmp59_;
			_vala_assert (_tmp60_ == NULL, "subset.floor (\"six\") == null");
			_g_free0 (_tmp60_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			GeeSortedSet* _tmp19_;
			gpointer _tmp20_ = NULL;
			gchar* _tmp21_;
			GeeSortedSet* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			GeeSortedSet* _tmp25_;
			gpointer _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_ceil (_tmp16_, "a");
			_tmp18_ = (gchar*) _tmp17_;
			_vala_assert (g_strcmp0 (_tmp18_, "five") == 0, "subset.ceil (\"a\") == \"five\"");
			_g_free0 (_tmp18_);
			_tmp19_ = self->priv->subset;
			_tmp20_ = gee_sorted_set_ceil (_tmp19_, "five");
			_tmp21_ = (gchar*) _tmp20_;
			_vala_assert (g_strcmp0 (_tmp21_, "five") == 0, "subset.ceil (\"five\") == \"five\"");
			_g_free0 (_tmp21_);
			_tmp22_ = self->priv->subset;
			_tmp23_ = gee_sorted_set_ceil (_tmp22_, "four");
			_tmp24_ = (gchar*) _tmp23_;
			_vala_assert (g_strcmp0 (_tmp24_, "four") == 0, "subset.ceil (\"four\") == \"four\"");
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->subset;
			_tmp26_ = gee_sorted_set_ceil (_tmp25_, "six");
			_tmp27_ = (gchar*) _tmp26_;
			_vala_assert (_tmp27_ == NULL, "subset.ceil (\"six\") == null");
			_g_free0 (_tmp27_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			GeeSortedSet* _tmp31_;
			gpointer _tmp32_ = NULL;
			gchar* _tmp33_;
			GeeSortedSet* _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			GeeSortedSet* _tmp37_;
			gpointer _tmp38_ = NULL;
			gchar* _tmp39_;
			GeeSortedSet* _tmp40_;
			gpointer _tmp41_ = NULL;
			gchar* _tmp42_;
			_tmp28_ = self->priv->subset;
			_tmp29_ = gee_sorted_set_ceil (_tmp28_, "one");
			_tmp30_ = (gchar*) _tmp29_;
			_vala_assert (g_strcmp0 (_tmp30_, "six") == 0, "subset.ceil (\"one\") == \"six\"");
			_g_free0 (_tmp30_);
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_ceil (_tmp31_, "six");
			_tmp33_ = (gchar*) _tmp32_;
			_vala_assert (g_strcmp0 (_tmp33_, "six") == 0, "subset.ceil (\"six\") == \"six\"");
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->subset;
			_tmp35_ = gee_sorted_set_ceil (_tmp34_, "three");
			_tmp36_ = (gchar*) _tmp35_;
			_vala_assert (g_strcmp0 (_tmp36_, "three") == 0, "subset.ceil (\"three\") == \"three\"");
			_g_free0 (_tmp36_);
			_tmp37_ = self->priv->subset;
			_tmp38_ = gee_sorted_set_ceil (_tmp37_, "two");
			_tmp39_ = (gchar*) _tmp38_;
			_vala_assert (g_strcmp0 (_tmp39_, "two") == 0, "subset.ceil (\"two\") == \"two\"");
			_g_free0 (_tmp39_);
			_tmp40_ = self->priv->subset;
			_tmp41_ = gee_sorted_set_ceil (_tmp40_, "z");
			_tmp42_ = (gchar*) _tmp41_;
			_vala_assert (_tmp42_ == NULL, "subset.ceil (\"z\") == null");
			_g_free0 (_tmp42_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp43_;
			gpointer _tmp44_ = NULL;
			gchar* _tmp45_;
			GeeSortedSet* _tmp46_;
			gpointer _tmp47_ = NULL;
			gchar* _tmp48_;
			GeeSortedSet* _tmp49_;
			gpointer _tmp50_ = NULL;
			gchar* _tmp51_;
			GeeSortedSet* _tmp52_;
			gpointer _tmp53_ = NULL;
			gchar* _tmp54_;
			GeeSortedSet* _tmp55_;
			gpointer _tmp56_ = NULL;
			gchar* _tmp57_;
			_tmp43_ = self->priv->subset;
			_tmp44_ = gee_sorted_set_ceil (_tmp43_, "five");
			_tmp45_ = (gchar*) _tmp44_;
			_vala_assert (g_strcmp0 (_tmp45_, "four") == 0, "subset.ceil (\"five\") == \"four\"");
			_g_free0 (_tmp45_);
			_tmp46_ = self->priv->subset;
			_tmp47_ = gee_sorted_set_ceil (_tmp46_, "four");
			_tmp48_ = (gchar*) _tmp47_;
			_vala_assert (g_strcmp0 (_tmp48_, "four") == 0, "subset.ceil (\"four\") == \"four\"");
			_g_free0 (_tmp48_);
			_tmp49_ = self->priv->subset;
			_tmp50_ = gee_sorted_set_ceil (_tmp49_, "one");
			_tmp51_ = (gchar*) _tmp50_;
			_vala_assert (g_strcmp0 (_tmp51_, "one") == 0, "subset.ceil (\"one\") == \"one\"");
			_g_free0 (_tmp51_);
			_tmp52_ = self->priv->subset;
			_tmp53_ = gee_sorted_set_ceil (_tmp52_, "six");
			_tmp54_ = (gchar*) _tmp53_;
			_vala_assert (g_strcmp0 (_tmp54_, "six") == 0, "subset.ceil (\"six\") == \"six\"");
			_g_free0 (_tmp54_);
			_tmp55_ = self->priv->subset;
			_tmp56_ = gee_sorted_set_ceil (_tmp55_, "three");
			_tmp57_ = (gchar*) _tmp56_;
			_vala_assert (_tmp57_ == NULL, "subset.ceil (\"three\") == null");
			_g_free0 (_tmp57_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp58_;
			gpointer _tmp59_ = NULL;
			gchar* _tmp60_;
			_tmp58_ = self->priv->subset;
			_tmp59_ = gee_sorted_set_ceil (_tmp58_, "six");
			_tmp60_ = (gchar*) _tmp59_;
			_vala_assert (_tmp60_ == NULL, "subset.ceil (\"six\") == null");
			_g_free0 (_tmp60_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self) {
	GeeSortedSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSortedSet* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeSortedSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeSortedSet* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GeeSortedSet* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeSortedSet* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeSortedSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SortedSetTestsSubSetType _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->master;
	_tmp1_ = gee_collection_add ((GeeCollection*) _tmp0_, "one");
	_vala_assert (_tmp1_, "master.add (\"one\")");
	_tmp2_ = self->priv->master;
	_tmp3_ = gee_collection_add ((GeeCollection*) _tmp2_, "two");
	_vala_assert (_tmp3_, "master.add (\"two\")");
	_tmp4_ = self->priv->master;
	_tmp5_ = gee_collection_add ((GeeCollection*) _tmp4_, "three");
	_vala_assert (_tmp5_, "master.add (\"three\")");
	_tmp6_ = self->priv->master;
	_tmp7_ = gee_collection_add ((GeeCollection*) _tmp6_, "four");
	_vala_assert (_tmp7_, "master.add (\"four\")");
	_tmp8_ = self->priv->master;
	_tmp9_ = gee_collection_add ((GeeCollection*) _tmp8_, "five");
	_vala_assert (_tmp9_, "master.add (\"five\")");
	_tmp10_ = self->priv->master;
	_tmp11_ = gee_collection_add ((GeeCollection*) _tmp10_, "six");
	_vala_assert (_tmp11_, "master.add (\"six\")");
	_tmp12_ = self->priv->master;
	_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_vala_assert (_tmp14_ == 6, "master.size == 6");
	_tmp15_ = self->priv->type;
	switch (_tmp15_) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp16_;
			GeeSortedSet* _tmp17_ = NULL;
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			GeeSortedSet* _tmp21_;
			GeeSortedSet* _tmp22_ = NULL;
			GeeSortedSet* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeSortedSet* _tmp26_;
			GeeSortedSet* _tmp27_ = NULL;
			GeeSortedSet* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			GeeSortedSet* _tmp31_;
			GeeSortedSet* _tmp32_ = NULL;
			GeeSortedSet* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			_tmp16_ = self->priv->subset;
			_tmp17_ = gee_sorted_set_head_set (_tmp16_, "four");
			subsubset = _tmp17_;
			_tmp18_ = subsubset;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_vala_assert (_tmp20_ == 1, "subsubset.size == 1");
			_tmp21_ = self->priv->subset;
			_tmp22_ = gee_sorted_set_tail_set (_tmp21_, "four");
			_g_object_unref0 (subsubset);
			subsubset = _tmp22_;
			_tmp23_ = subsubset;
			_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_vala_assert (_tmp25_ == 1, "subsubset.size == 1");
			_tmp26_ = self->priv->subset;
			_tmp27_ = gee_sorted_set_sub_set (_tmp26_, "four", "one");
			_g_object_unref0 (subsubset);
			subsubset = _tmp27_;
			_tmp28_ = subsubset;
			_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_vala_assert (_tmp30_ == 1, "subsubset.size == 1");
			_tmp31_ = self->priv->subset;
			_tmp32_ = gee_sorted_set_sub_set (_tmp31_, "four", "four");
			_g_object_unref0 (subsubset);
			subsubset = _tmp32_;
			_tmp33_ = subsubset;
			_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_vala_assert (_tmp35_ == 0, "subsubset.size == 0");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp36_;
			GeeSortedSet* _tmp37_ = NULL;
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			GeeSortedSet* _tmp41_;
			GeeSortedSet* _tmp42_ = NULL;
			GeeSortedSet* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			GeeSortedSet* _tmp46_;
			GeeSortedSet* _tmp47_ = NULL;
			GeeSortedSet* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			_tmp36_ = self->priv->subset;
			_tmp37_ = gee_sorted_set_head_set (_tmp36_, "two");
			subsubset = _tmp37_;
			_tmp38_ = subsubset;
			_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			_vala_assert (_tmp40_ == 2, "subsubset.size == 2");
			_tmp41_ = self->priv->subset;
			_tmp42_ = gee_sorted_set_tail_set (_tmp41_, "three");
			_g_object_unref0 (subsubset);
			subsubset = _tmp42_;
			_tmp43_ = subsubset;
			_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_vala_assert (_tmp45_ == 2, "subsubset.size == 2");
			_tmp46_ = self->priv->subset;
			_tmp47_ = gee_sorted_set_sub_set (_tmp46_, "three", "two");
			_g_object_unref0 (subsubset);
			subsubset = _tmp47_;
			_tmp48_ = subsubset;
			_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_vala_assert (_tmp50_ == 1, "subsubset.size == 1");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp51_;
			GeeSortedSet* _tmp52_ = NULL;
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			GeeSortedSet* _tmp56_;
			GeeSortedSet* _tmp57_ = NULL;
			GeeSortedSet* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			GeeSortedSet* _tmp61_;
			GeeSortedSet* _tmp62_ = NULL;
			GeeSortedSet* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			GeeSortedSet* _tmp66_;
			GeeSortedSet* _tmp67_ = NULL;
			GeeSortedSet* _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			_tmp51_ = self->priv->subset;
			_tmp52_ = gee_sorted_set_head_set (_tmp51_, "six");
			subsubset = _tmp52_;
			_tmp53_ = subsubset;
			_tmp54_ = gee_collection_get_size ((GeeCollection*) _tmp53_);
			_tmp55_ = _tmp54_;
			_vala_assert (_tmp55_ == 2, "subsubset.size == 2");
			_tmp56_ = self->priv->subset;
			_tmp57_ = gee_sorted_set_tail_set (_tmp56_, "one");
			_g_object_unref0 (subsubset);
			subsubset = _tmp57_;
			_tmp58_ = subsubset;
			_tmp59_ = gee_collection_get_size ((GeeCollection*) _tmp58_);
			_tmp60_ = _tmp59_;
			_vala_assert (_tmp60_ == 2, "subsubset.size == 2");
			_tmp61_ = self->priv->subset;
			_tmp62_ = gee_sorted_set_sub_set (_tmp61_, "one", "six");
			_g_object_unref0 (subsubset);
			subsubset = _tmp62_;
			_tmp63_ = subsubset;
			_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_vala_assert (_tmp65_ == 1, "subsubset.size == 1");
			_tmp66_ = self->priv->subset;
			_tmp67_ = gee_sorted_set_sub_set (_tmp66_, "five", "two");
			_g_object_unref0 (subsubset);
			subsubset = _tmp67_;
			_tmp68_ = subsubset;
			_tmp69_ = gee_collection_get_size ((GeeCollection*) _tmp68_);
			_tmp70_ = _tmp69_;
			_vala_assert (_tmp70_ == 3, "subsubset.size == 3");
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp71_;
			GeeSortedSet* _tmp72_ = NULL;
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			GeeSortedSet* _tmp76_;
			GeeSortedSet* _tmp77_ = NULL;
			GeeSortedSet* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			GeeSortedSet* _tmp81_;
			GeeSortedSet* _tmp82_ = NULL;
			GeeSortedSet* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			_tmp71_ = self->priv->subset;
			_tmp72_ = gee_sorted_set_head_set (_tmp71_, "six");
			subsubset = _tmp72_;
			_tmp73_ = subsubset;
			_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
			_tmp75_ = _tmp74_;
			_vala_assert (_tmp75_ == 0, "subsubset.size == 0");
			_tmp76_ = self->priv->subset;
			_tmp77_ = gee_sorted_set_tail_set (_tmp76_, "three");
			_g_object_unref0 (subsubset);
			subsubset = _tmp77_;
			_tmp78_ = subsubset;
			_tmp79_ = gee_collection_get_size ((GeeCollection*) _tmp78_);
			_tmp80_ = _tmp79_;
			_vala_assert (_tmp80_ == 0, "subsubset.size == 0");
			_tmp81_ = self->priv->subset;
			_tmp82_ = gee_sorted_set_sub_set (_tmp81_, "one", "six");
			_g_object_unref0 (subsubset);
			subsubset = _tmp82_;
			_tmp83_ = subsubset;
			_tmp84_ = gee_collection_get_size ((GeeCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			_vala_assert (_tmp85_ == 0, "subsubset.size == 0");
			_g_object_unref0 (subsubset);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_class_init (SortedSetTestsSubSetClass * klass) {
	sorted_set_tests_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SortedSetTestsSubSetPrivate));
	GEE_TEST_CASE_CLASS (klass)->set_up = sorted_set_tests_sub_set_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = sorted_set_tests_sub_set_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = sorted_set_tests_sub_set_finalize;
}


static void sorted_set_tests_sub_set_instance_init (SortedSetTestsSubSet * self) {
	self->priv = SORTED_SET_TESTS_SUB_SET_GET_PRIVATE (self);
}


static void sorted_set_tests_sub_set_finalize (GObject* obj) {
	SortedSetTestsSubSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSet);
	_g_object_unref0 (self->priv->master);
	_g_object_unref0 (self->priv->subset);
	_g_object_unref0 (self->priv->test);
	G_OBJECT_CLASS (sorted_set_tests_sub_set_parent_class)->finalize (obj);
}


GType sorted_set_tests_sub_set_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTestsSubSet), 0, (GInstanceInitFunc) sorted_set_tests_sub_set_instance_init, NULL };
		GType sorted_set_tests_sub_set_type_id;
		sorted_set_tests_sub_set_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "SortedSetTestsSubSet", &g_define_type_info, 0);
		g_once_init_leave (&sorted_set_tests_sub_set_type_id__volatile, sorted_set_tests_sub_set_type_id);
	}
	return sorted_set_tests_sub_set_type_id__volatile;
}


static void sorted_set_tests_class_init (SortedSetTestsClass * klass) {
	sorted_set_tests_parent_class = g_type_class_peek_parent (klass);
}


static void sorted_set_tests_instance_init (SortedSetTests * self) {
}


GType sorted_set_tests_get_type (void) {
	static volatile gsize sorted_set_tests_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTests), 0, (GInstanceInitFunc) sorted_set_tests_instance_init, NULL };
		GType sorted_set_tests_type_id;
		sorted_set_tests_type_id = g_type_register_static (TYPE_SET_TESTS, "SortedSetTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sorted_set_tests_type_id__volatile, sorted_set_tests_type_id);
	}
	return sorted_set_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



