/* tpf-persona.c generated by valac 0.17.6.4-590d, the Vala compiler
 * generated from tpf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <telepathy-glib/telepathy-glib.h>
#include <glib/gi18n-lib.h>
#include <folks-internal.h>
#include <zeitgeist.h>


#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;
typedef struct _TpfPersonaPrivate TpfPersonaPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaChangeFullNameData TpfPersonaChangeFullNameData;
typedef struct _TpfPersonaChangeBirthdayData TpfPersonaChangeBirthdayData;
typedef struct _TpfPersonaChangeAliasData TpfPersonaChangeAliasData;
typedef struct _TpfPersonaChangeIsFavouriteData TpfPersonaChangeIsFavouriteData;
typedef struct _TpfPersonaChangeEmailAddressesData TpfPersonaChangeEmailAddressesData;
typedef struct _TpfPersonaChangeGroupData TpfPersonaChangeGroupData;
typedef struct _TpfPersonaChangeGroupsData TpfPersonaChangeGroupsData;
typedef struct _TpfPersonaChangePhoneNumbersData TpfPersonaChangePhoneNumbersData;
typedef struct _TpfPersonaChangeUrlsData TpfPersonaChangeUrlsData;
typedef struct _TpfPersonaChangeDetailsData TpfPersonaChangeDetailsData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TpfPersona {
	FolksPersona parent_instance;
	TpfPersonaPrivate * priv;
	GDateTime* _last_im_interaction_datetime;
	GDateTime* _last_call_interaction_datetime;
};

struct _TpfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TpfPersonaPrivate {
	gchar** _writeable_properties;
	gint _writeable_properties_length1;
	gint __writeable_properties_size_;
	gboolean _is_constructed;
	gboolean _is_in_contact_list;
	GLoadableIcon* _avatar;
	gchar* _full_name;
	GDateTime* _birthday;
	FolksPresenceType _presence_type;
	gchar* _presence_status;
	gchar* _presence_message;
	gchar* _alias;
	gboolean _is_favourite;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	GeeHashMultiMap* _im_addresses;
	guint _im_interaction_count;
	guint _call_interaction_count;
	GeeHashSet* _groups;
	GeeSet* _groups_ro;
	GWeakRef _contact;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
};

struct _TpfPersonaChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* full_name;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	TpfPersonaStore* _tmp6_;
	const gchar* _tmp7_;
	GError* e1;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GError* e2;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError* e3;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeBirthdayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GDateTime* birthday;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gboolean _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	TpfPersonaStore* _tmp13_;
	GDateTime* _tmp14_;
	GError* e1;
	GError* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	GError* e2;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError* e3;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* alias;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gboolean is_favourite;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeEmailAddressesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* email_addresses;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeGroupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	gchar* group;
	gboolean is_member;
	GObject* _tmp0_;
	TpContact* contact;
	TpContact* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GeeHashSet* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	TpContact* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GeeHashSet* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	TpContact* _tmp19_;
	const gchar* _tmp20_;
	GError* e;
	const gchar* _tmp21_;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _tmp24_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeGroupsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* groups;
	GObject* _tmp0_;
	TpContact* contact;
	TpContact* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	TpContact* _tmp5_;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gpointer* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GError* e;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_;
};

struct _TpfPersonaChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* phone_numbers;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeUrlsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* urls;
	GeeSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GError * _inner_error_;
};

struct _TpfPersonaChangeDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersona* self;
	GeeSet* details;
	GeeSet* member_set;
	gchar* field_name;
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	gboolean _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	TpfPersonaStore* _tmp10_;
	GeeSet* _tmp11_;
	const gchar* _tmp12_;
	GError* e1;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError* e2;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError* e3;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _tmp21_;
	GError * _inner_error_;
};


static gpointer tpf_persona_parent_class = NULL;
static FolksAliasDetailsIface* tpf_persona_folks_alias_details_parent_iface = NULL;
static FolksAvatarDetailsIface* tpf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* tpf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* tpf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* tpf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGroupDetailsIface* tpf_persona_folks_group_details_parent_iface = NULL;
static FolksInteractionDetailsIface* tpf_persona_folks_interaction_details_parent_iface = NULL;
static FolksImDetailsIface* tpf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* tpf_persona_folks_name_details_parent_iface = NULL;
static FolksPhoneDetailsIface* tpf_persona_folks_phone_details_parent_iface = NULL;
static FolksPresenceDetailsIface* tpf_persona_folks_presence_details_parent_iface = NULL;
static FolksUrlDetailsIface* tpf_persona_folks_url_details_parent_iface = NULL;

GType tpf_persona_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA, TpfPersonaPrivate))
enum  {
	TPF_PERSONA_DUMMY_PROPERTY,
	TPF_PERSONA_IS_IN_CONTACT_LIST,
	TPF_PERSONA_AVATAR,
	TPF_PERSONA_STRUCTURED_NAME,
	TPF_PERSONA_FULL_NAME,
	TPF_PERSONA_NICKNAME,
	TPF_PERSONA_CALENDAR_EVENT_ID,
	TPF_PERSONA_BIRTHDAY,
	TPF_PERSONA_PRESENCE_TYPE,
	TPF_PERSONA_PRESENCE_STATUS,
	TPF_PERSONA_PRESENCE_MESSAGE,
	TPF_PERSONA_LINKABLE_PROPERTIES,
	TPF_PERSONA_WRITEABLE_PROPERTIES,
	TPF_PERSONA_ALIAS,
	TPF_PERSONA_IS_FAVOURITE,
	TPF_PERSONA_EMAIL_ADDRESSES,
	TPF_PERSONA_IM_ADDRESSES,
	TPF_PERSONA_IM_INTERACTION_COUNT,
	TPF_PERSONA_LAST_IM_INTERACTION_DATETIME,
	TPF_PERSONA_CALL_INTERACTION_COUNT,
	TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME,
	TPF_PERSONA_GROUPS,
	TPF_PERSONA_CONTACT,
	TPF_PERSONA_PHONE_NUMBERS,
	TPF_PERSONA_URLS
};
static void _tpf_persona_contact_weak_notify_cb (TpfPersona* self, GObject* obj);
static void __tpf_persona_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object);
static void tpf_persona_real_change_full_name_data_free (gpointer _data);
static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_);
GType tpf_persona_store_get_type (void) G_GNUC_CONST;
void tpf_persona_store_change_user_full_name (TpfPersonaStore* self, TpfPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_full_name_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_birthday_data_free (gpointer _data);
static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_);
void tpf_persona_store_change_user_birthday (TpfPersonaStore* self, TpfPersona* persona, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_user_birthday_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_alias_data_free (gpointer _data);
static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_is_favourite_data_free (gpointer _data);
static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite);
void _tpf_persona_store_set_cache_needs_update (TpfPersonaStore* self);
static void tpf_persona_real_change_email_addresses_data_free (gpointer _data);
static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_);
static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_group_data_free (gpointer _data);
static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_);
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_contact_groups_changed (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void tpf_persona_real_change_groups_data_free (gpointer _data);
static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_);
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data);
static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_);
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_real_change_urls_data_free (gpointer _data);
static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_);
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_change_details_data_free (gpointer _data);
static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_);
void _tpf_persona_store_change_user_details (TpfPersonaStore* self, TpfPersona* persona, GeeSet* details, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_user_details_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static void tpf_persona_real_constructed (GObject* base);
static void _tpf_persona_update_writeable_properties (TpfPersona* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
GeeSet* tpf_persona_store_get_supported_fields (TpfPersonaStore* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _tpf_persona_contact_notify_contact_info (TpfPersona* self, gboolean create_if_not_exists, gboolean emit_notification);
static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1);
TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls);
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
void _tpf_persona_store_update_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid, GFile* avatar_file);
static void _tpf_persona_contact_notify_presence_message (TpfPersona* self);
static void _tpf_persona_contact_notify_presence_type (TpfPersona* self);
static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type);
static void _tpf_persona_contact_notify_presence_status (TpfPersona* self);
static void _tpf_persona_contact_notify_avatar (TpfPersona* self);
GFile* _tpf_persona_store_query_avatar_cache (TpfPersonaStore* self, const gchar* persona_iid);
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact);
TpfPersonaStore* tpf_persona_store_dup_for_account (TpAccount* account);
TpfPersona* _tpf_persona_store_ensure_persona_for_contact (TpfPersonaStore* self, TpContact* contact);
void _tpf_persona_increase_counter (TpfPersona* self, const gchar* id, const gchar* interaction_type, ZeitgeistEvent* event);
void _tpf_persona_reset_interaction (TpfPersona* self);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
static void tpf_persona_set_contact (TpfPersona* self, TpContact* value);
static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _tpf_persona___lambda12_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda13_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda14_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda15_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda16_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda17_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda18_ (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona___lambda18__tp_contact_contact_groups_changed (TpContact* _sender, gchar** added, gchar** removed, gpointer self);
static void _tpf_persona____lambda19_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona____lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona___lambda20_ (TpfPersona* self, GObject* s, GParamSpec* p);
static void __tpf_persona___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tpf_persona_finalize (GObject* obj);
static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TPF_PERSONA__linkable_properties[1] = {"im-addresses"};

static void __tpf_persona_contact_weak_notify_cb_gweak_notify (gpointer self, GObject* object) {
	_tpf_persona_contact_weak_notify_cb (self, object);
}


static void tpf_persona_real_change_full_name_data_free (gpointer _data) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeFullNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_real_change_full_name (FolksNameDetails* base, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeFullNameData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->full_name = _tmp2_;
	tpf_persona_real_change_full_name_co (_data_);
}


static void tpf_persona_real_change_full_name_finish (FolksNameDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_full_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeFullNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_full_name_co (_data_);
}


static gboolean tpf_persona_real_change_full_name_co (TpfPersonaChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->full_name;
	_data_->_tmp4_ = _data_->self->priv->_full_name;
	if (g_strcmp0 (_data_->_tmp3_, _data_->_tmp4_) == 0) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp5_) {
		{
			_data_->_tmp6_ = _data_->tpf_store;
			_data_->_tmp7_ = _data_->full_name;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_full_name (_data_->_tmp6_, _data_->self, _data_->_tmp7_, tpf_persona_change_full_name_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_full_name_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch0_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch0_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch0_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally0;
		__catch0_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp8_ = _data_->e1;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			_data_->_tmp10_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e1);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp11_ = _data_->e2;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			_data_->_tmp13_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp12_);
			_data_->_inner_error_ = _data_->_tmp13_;
			_g_error_free0 (_data_->e2);
			goto __finally0;
		}
		goto __finally0;
		__catch0_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp14_ = _data_->e3;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			_data_->_tmp16_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp15_);
			_data_->_inner_error_ = _data_->_tmp16_;
			_g_error_free0 (_data_->e3);
			goto __finally0;
		}
		__finally0:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_birthday_data_free (gpointer _data) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _data;
	_g_date_time_unref0 (_data_->birthday);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeBirthdayData, _data_);
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void tpf_persona_real_change_birthday (FolksBirthdayDetails* base, GDateTime* birthday, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeBirthdayData* _data_;
	TpfPersona* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeBirthdayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_birthday);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_birthday_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = birthday;
	_tmp2_ = _g_date_time_ref0 (_tmp1_);
	_data_->birthday = _tmp2_;
	tpf_persona_real_change_birthday_co (_data_);
}


static void tpf_persona_real_change_birthday_finish (FolksBirthdayDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeBirthdayData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_birthday_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeBirthdayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_birthday_co (_data_);
}


static gboolean tpf_persona_real_change_birthday_co (TpfPersonaChangeBirthdayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp5_ = _data_->birthday;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = _data_->self->priv->_birthday;
		_data_->_tmp4_ = _data_->_tmp6_ != NULL;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp4_;
	if (_data_->_tmp7_) {
		_data_->_tmp8_ = _data_->birthday;
		_data_->_tmp9_ = _data_->self->priv->_birthday;
		_data_->_tmp10_ = FALSE;
		_data_->_tmp10_ = g_date_time_equal (_data_->_tmp8_, _data_->_tmp9_);
		_data_->_tmp3_ = _data_->_tmp10_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp11_ = _data_->_tmp3_;
	if (_data_->_tmp11_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp12_) {
		{
			_data_->_tmp13_ = _data_->tpf_store;
			_data_->_tmp14_ = _data_->birthday;
			_data_->_state_ = 1;
			tpf_persona_store_change_user_birthday (_data_->_tmp13_, _data_->self, _data_->_tmp14_, tpf_persona_change_birthday_ready, _data_);
			return FALSE;
			_state_1:
			tpf_persona_store_change_user_birthday_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch1_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch1_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch1_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally1;
		__catch1_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp15_ = _data_->e1;
			_data_->_tmp16_ = _data_->_tmp15_->message;
			_data_->_tmp17_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp16_);
			_data_->_inner_error_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e1);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp18_ = _data_->e2;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			_data_->_tmp20_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp19_);
			_data_->_inner_error_ = _data_->_tmp20_;
			_g_error_free0 (_data_->e2);
			goto __finally1;
		}
		goto __finally1;
		__catch1_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp21_ = _data_->e3;
			_data_->_tmp22_ = _data_->_tmp21_->message;
			_data_->_tmp23_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp22_);
			_data_->_inner_error_ = _data_->_tmp23_;
			_g_error_free0 (_data_->e3);
			goto __finally1;
		}
		__finally1:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_alias_data_free (gpointer _data) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _data;
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeAliasData, _data_);
}


static void tpf_persona_real_change_alias (FolksAliasDetails* base, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeAliasData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = alias;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->alias = _tmp2_;
	tpf_persona_real_change_alias_co (_data_);
}


static void tpf_persona_real_change_alias_finish (FolksAliasDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeAliasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_alias_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeAliasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_alias_co (_data_);
}


static gboolean tpf_persona_real_change_alias_co (TpfPersonaChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_alias;
	_data_->_tmp1_ = _data_->alias;
	if (g_strcmp0 (_data_->_tmp0_, _data_->_tmp1_) == 0) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->alias;
		_data_->_state_ = 1;
		tpf_persona_store_change_alias (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->self, _data_->_tmp5_, tpf_persona_change_alias_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_alias_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeIsFavouriteData, _data_);
}


static void tpf_persona_real_change_is_favourite (FolksFavouriteDetails* base, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeIsFavouriteData* _data_;
	TpfPersona* _tmp0_;
	gboolean _tmp1_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = is_favourite;
	_data_->is_favourite = _tmp1_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static void tpf_persona_real_change_is_favourite_finish (FolksFavouriteDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeIsFavouriteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_real_change_is_favourite_co (TpfPersonaChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_favourite;
	_data_->_tmp1_ = _data_->is_favourite;
	if (_data_->_tmp0_ == _data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = folks_persona_get_store ((FolksPersona*) _data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->is_favourite;
		_data_->_state_ = 1;
		tpf_persona_store_change_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), (FolksPersona*) _data_->self, _data_->_tmp5_, tpf_persona_change_is_favourite_ready, _data_);
		return FALSE;
		_state_1:
		tpf_persona_store_change_is_favourite_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void _tpf_persona_set_is_favourite (TpfPersona* self, gboolean is_favourite) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_favourite;
	_tmp1_ = is_favourite;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = is_favourite;
	self->priv->_is_favourite = _tmp2_;
	g_object_notify ((GObject*) self, "is-favourite");
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp4_ = _tmp3_;
	_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
}


static void tpf_persona_real_change_email_addresses_data_free (gpointer _data) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_addresses);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeEmailAddressesData, _data_);
}


static void tpf_persona_real_change_email_addresses (FolksEmailDetails* base, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeEmailAddressesData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeEmailAddressesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_email_addresses);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_email_addresses_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = email_addresses;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->email_addresses = _tmp2_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static void tpf_persona_real_change_email_addresses_finish (FolksEmailDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeEmailAddressesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_email_addresses_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeEmailAddressesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_email_addresses_co (_data_);
}


static gboolean tpf_persona_real_change_email_addresses_co (TpfPersonaChangeEmailAddressesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->email_addresses;
	_data_->_tmp1_ = _data_->self->priv->_email_addresses;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "email", tpf_persona_change_email_addresses_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_group_data_free (gpointer _data) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _data;
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupData, _data_);
}


static void tpf_persona_real_change_group (FolksGroupDetails* base, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupData* _data_;
	TpfPersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_group);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_group_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->group = _tmp2_;
	_tmp3_ = is_member;
	_data_->is_member = _tmp3_;
	tpf_persona_real_change_group_co (_data_);
}


static void tpf_persona_real_change_group_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Add or remove the Persona from the specified group.
   *
   * See {@link Folks.GroupDetails.change_group}.
   *
   * @throws Folks.PropertyError.UNKNOWN_ERROR if changing group membership
   * failed
   */
static void tpf_persona_change_group_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_group_co (_data_);
}


static gboolean tpf_persona_real_change_group_co (TpfPersonaChangeGroupData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_weak_ref_get (&_data_->self->priv->_contact);
	_data_->contact = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, tp_contact_get_type (), TpContact);
	_data_->_tmp1_ = _data_->contact;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Failed to change group membership: %s");
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Account is offline.");
		_data_->_tmp4_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNAVAILABLE, _data_->_tmp2_, _data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp6_ = _data_->is_member;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->_groups;
			_data_->_tmp8_ = _data_->group;
			_data_->_tmp9_ = FALSE;
			_data_->_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp7_, _data_->_tmp8_);
			_data_->_tmp5_ = !_data_->_tmp9_;
		} else {
			_data_->_tmp5_ = FALSE;
		}
		_data_->_tmp10_ = _data_->_tmp5_;
		if (_data_->_tmp10_) {
			_data_->_tmp11_ = _data_->contact;
			_data_->_tmp12_ = _data_->group;
			_data_->_state_ = 1;
			tp_contact_add_to_group_async (_data_->_tmp11_, _data_->_tmp12_, tpf_persona_change_group_ready, _data_);
			return FALSE;
			_state_1:
			tp_contact_add_to_group_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		} else {
			_data_->_tmp14_ = _data_->is_member;
			if (!_data_->_tmp14_) {
				_data_->_tmp15_ = _data_->self->priv->_groups;
				_data_->_tmp16_ = _data_->group;
				_data_->_tmp17_ = FALSE;
				_data_->_tmp17_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp15_, _data_->_tmp16_);
				_data_->_tmp13_ = _data_->_tmp17_;
			} else {
				_data_->_tmp13_ = FALSE;
			}
			_data_->_tmp18_ = _data_->_tmp13_;
			if (_data_->_tmp18_) {
				_data_->_tmp19_ = _data_->contact;
				_data_->_tmp20_ = _data_->group;
				_data_->_state_ = 2;
				tp_contact_remove_from_group_async (_data_->_tmp19_, _data_->_tmp20_, tpf_persona_change_group_ready, _data_);
				return FALSE;
				_state_2:
				tp_contact_remove_from_group_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch2_g_error;
				}
			}
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _ ("Failed to change group membership: %s");
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp21_, _data_->_tmp23_);
		_data_->_inner_error_ = _data_->_tmp24_;
		_g_error_free0 (_data_->e);
		goto __finally2;
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->contact);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_contact_groups_changed (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gboolean changed;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	changed = FALSE;
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp0_;
		group_collection_length1 = _tmp0__length1;
		for (group_it = 0; group_it < _tmp0__length1; group_it = group_it + 1) {
			gchar* _tmp1_;
			gchar* group = NULL;
			_tmp1_ = g_strdup (group_collection[group_it]);
			group = _tmp1_;
			{
				GeeHashSet* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_ = FALSE;
				_tmp2_ = self->priv->_groups;
				_tmp3_ = group;
				_tmp4_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp3_);
				if (_tmp4_ == TRUE) {
					const gchar* _tmp5_;
					changed = TRUE;
					_tmp5_ = group;
					g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp5_, TRUE);
				}
				_g_free0 (group);
			}
		}
	}
	_tmp6_ = removed;
	_tmp6__length1 = removed_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp6_;
		group_collection_length1 = _tmp6__length1;
		for (group_it = 0; group_it < _tmp6__length1; group_it = group_it + 1) {
			gchar* _tmp7_;
			gchar* group = NULL;
			_tmp7_ = g_strdup (group_collection[group_it]);
			group = _tmp7_;
			{
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = self->priv->_groups;
				_tmp9_ = group;
				_tmp10_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				if (_tmp10_ == TRUE) {
					const gchar* _tmp11_;
					changed = TRUE;
					_tmp11_ = group;
					g_signal_emit_by_name ((FolksGroupDetails*) self, "group-changed", _tmp11_, FALSE);
				}
				_g_free0 (group);
			}
		}
	}
	_tmp12_ = changed;
	if (_tmp12_ == TRUE) {
		FolksPersonaStore* _tmp13_;
		FolksPersonaStore* _tmp14_;
		g_object_notify ((GObject*) self, "groups");
		_tmp13_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp14_ = _tmp13_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
}


static void tpf_persona_real_change_groups_data_free (gpointer _data) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->groups);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeGroupsData, _data_);
}


static void tpf_persona_real_change_groups (FolksGroupDetails* base, GeeSet* groups, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeGroupsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeGroupsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_groups);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_groups_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = groups;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->groups = _tmp2_;
	tpf_persona_real_change_groups_co (_data_);
}


static void tpf_persona_real_change_groups_finish (FolksGroupDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeGroupsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.2
   */
static void tpf_persona_change_groups_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeGroupsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_groups_co (_data_);
}


static gboolean tpf_persona_real_change_groups_co (TpfPersonaChangeGroupsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_weak_ref_get (&_data_->self->priv->_contact);
	_data_->contact = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, tp_contact_get_type (), TpContact);
	_data_->_tmp1_ = _data_->contact;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Failed to change group membership: %s");
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _ ("Account is offline.");
		_data_->_tmp4_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNAVAILABLE, _data_->_tmp2_, _data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp4_;
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->contact);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->contact);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp5_ = _data_->contact;
		_data_->_tmp6_ = _data_->groups;
		_data_->_tmp7_ = 0;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp6_, &_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp9__length1 = _data_->_tmp7_;
		_data_->_state_ = 1;
		tp_contact_set_contact_groups_async (_data_->_tmp5_, _data_->_tmp7_, _data_->_tmp9_, tpf_persona_change_groups_ready, _data_);
		return FALSE;
		_state_1:
		tp_contact_set_contact_groups_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = (_vala_array_free (_data_->_tmp9_, _data_->_tmp9__length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _ ("Failed to change group membership: %s");
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		_data_->_tmp13_ = g_error_new (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp10_, _data_->_tmp12_);
		_data_->_inner_error_ = _data_->_tmp13_;
		_g_error_free0 (_data_->e);
		goto __finally3;
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->contact);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->contact);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->contact);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_contact_weak_notify_cb (TpfPersona* self, GObject* obj) {
	GObject* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	g_debug ("tpf-persona.vala:604: TpContact %p destroyed; setting ._contact = null" \
" in Persona %p", _tmp0_, self);
	g_object_notify ((GObject*) self, "contact");
}


static void tpf_persona_real_change_phone_numbers_data_free (gpointer _data) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangePhoneNumbersData, _data_);
}


static void tpf_persona_real_change_phone_numbers (FolksPhoneDetails* base, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangePhoneNumbersData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->phone_numbers = _tmp2_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static void tpf_persona_real_change_phone_numbers_finish (FolksPhoneDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_phone_numbers_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangePhoneNumbersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_phone_numbers_co (_data_);
}


static gboolean tpf_persona_real_change_phone_numbers_co (TpfPersonaChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->phone_numbers;
	_data_->_tmp1_ = _data_->self->priv->_phone_numbers;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "tel", tpf_persona_change_phone_numbers_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_real_change_urls_data_free (gpointer _data) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->urls);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeUrlsData, _data_);
}


static void tpf_persona_real_change_urls (FolksUrlDetails* base, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersona * self;
	TpfPersonaChangeUrlsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	self = (TpfPersona*) base;
	_data_ = g_slice_new0 (TpfPersonaChangeUrlsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_real_change_urls);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_real_change_urls_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = urls;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->urls = _tmp2_;
	tpf_persona_real_change_urls_co (_data_);
}


static void tpf_persona_real_change_urls_finish (FolksUrlDetails* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeUrlsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.4
   */
static void tpf_persona_change_urls_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeUrlsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_real_change_urls_co (_data_);
}


static gboolean tpf_persona_real_change_urls_co (TpfPersonaChangeUrlsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->urls;
	_data_->_tmp1_ = _data_->self->priv->_urls;
	_data_->_state_ = 1;
	_tpf_persona_change_details (_data_->self, FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, "url", tpf_persona_change_urls_ready, _data_);
	return FALSE;
	_state_1:
	_tpf_persona_change_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_change_details_data_free (gpointer _data) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->details);
	_g_object_unref0 (_data_->member_set);
	_g_free0 (_data_->field_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaChangeDetailsData, _data_);
}


static void _tpf_persona_change_details (TpfPersona* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeSet* details, GeeSet* member_set, const gchar* field_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	TpfPersona* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_data_ = g_slice_new0 (TpfPersonaChangeDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_change_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_change_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	_tmp3_ = member_set;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data_->member_set = _tmp4_;
	_tmp5_ = field_name;
	_tmp6_ = g_strdup (_tmp5_);
	_data_->field_name = _tmp6_;
	_data_->t_type = t_type;
	_data_->t_dup_func = t_dup_func;
	_data_->t_destroy_func = t_destroy_func;
	_tpf_persona_change_details_co (_data_);
}


static void _tpf_persona_change_details_finish (TpfPersona* self, GAsyncResult* _res_, GError** error) {
	TpfPersonaChangeDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_change_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaChangeDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_change_details_co (_data_);
}


static gboolean _tpf_persona_change_details_co (TpfPersonaChangeDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = folks_persona_get_store ((FolksPersona*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _data_->_tmp1_) : NULL);
	_data_->tpf_store = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->member_set;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->details;
		_data_->_tmp6_ = _data_->member_set;
		_data_->_tmp7_ = FALSE;
		_data_->_tmp7_ = folks_internal_equal_sets (_data_->t_type, (GBoxedCopyFunc) _data_->t_dup_func, _data_->t_destroy_func, _data_->_tmp5_, _data_->_tmp6_);
		_data_->_tmp3_ = _data_->_tmp7_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp8_ = _data_->_tmp3_;
	if (_data_->_tmp8_) {
		_g_object_unref0 (_data_->tpf_store);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->self->priv->_is_constructed;
	if (_data_->_tmp9_) {
		{
			_data_->_tmp10_ = _data_->tpf_store;
			_data_->_tmp11_ = _data_->details;
			_data_->_tmp12_ = _data_->field_name;
			_data_->_state_ = 1;
			_tpf_persona_store_change_user_details (_data_->_tmp10_, _data_->self, _data_->_tmp11_, _data_->_tmp12_, _tpf_persona_change_details_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_change_user_details_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT)) {
					goto __catch4_folks_persona_store_error_invalid_argument;
				}
				if (g_error_matches (_data_->_inner_error_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
					goto __catch4_folks_persona_store_error_store_offline;
				}
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					goto __catch4_folks_persona_store_error;
				}
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		goto __finally4;
		__catch4_folks_persona_store_error_invalid_argument:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp13_ = _data_->e1;
			_data_->_tmp14_ = _data_->_tmp13_->message;
			_data_->_tmp15_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp14_);
			_data_->_inner_error_ = _data_->_tmp15_;
			_g_error_free0 (_data_->e1);
			goto __finally4;
		}
		goto __finally4;
		__catch4_folks_persona_store_error_store_offline:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp16_ = _data_->e2;
			_data_->_tmp17_ = _data_->_tmp16_->message;
			_data_->_tmp18_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp17_);
			_data_->_inner_error_ = _data_->_tmp18_;
			_g_error_free0 (_data_->e2);
			goto __finally4;
		}
		goto __finally4;
		__catch4_folks_persona_store_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp19_ = _data_->e3;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			_data_->_tmp21_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR, _data_->_tmp20_);
			_data_->_inner_error_ = _data_->_tmp21_;
			_g_error_free0 (_data_->e3);
			goto __finally4;
		}
		__finally4:
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->tpf_store);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->tpf_store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_g_object_unref0 (_data_->tpf_store);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * the Telepathy contact given by ``contact``.
   *
   * @param contact the Telepathy contact being represented by the persona
   * @param store the persona store to place the persona in
   */
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store) {
	TpfPersona * self = NULL;
	TpContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* id;
	TpContact* _tmp2_;
	TpConnection* _tmp3_;
	TpConnection* _tmp4_;
	TpConnection* _tmp5_;
	TpConnection* connection;
	TpAccount* _tmp6_ = NULL;
	TpAccount* _tmp7_;
	TpAccount* account;
	TpfPersonaStore* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	TpfPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* uid;
	TpContact* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	TpfPersonaStore* _tmp21_;
	TpContact* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	guint _tmp26_;
	g_return_val_if_fail (contact != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_identifier (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = tp_contact_get_connection (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	connection = _tmp5_;
	_tmp6_ = tp_connection_get_account (connection);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	account = _tmp7_;
	_tmp8_ = store;
	_tmp9_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = store;
	_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_persona_build_uid (_tmp10_, _tmp13_, id);
	uid = _tmp14_;
	_tmp15_ = contact;
	_tmp16_ = tp_account_get_protocol (account);
	_tmp17_ = g_strconcat (_tmp16_, ":", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, id, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = store;
	_tmp22_ = contact;
	_tmp23_ = tp_contact_get_handle (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = tp_connection_get_self_handle (connection);
	_tmp26_ = _tmp25_;
	self = (TpfPersona*) g_object_new (object_type, "contact", _tmp15_, "display-id", id, "iid", _tmp20_, "uid", uid, "store", _tmp21_, "is-user", _tmp24_ == _tmp26_, NULL);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	g_debug ("tpf-persona.vala:777: Created new Tpf.Persona '%s' for service-specifi" \
"c UID '%s': %p", uid, id, self);
	_g_free0 (uid);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	return self;
}


TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store) {
	return tpf_persona_construct (TPF_TYPE_PERSONA, contact, store);
}


static void tpf_persona_real_constructed (GObject* base) {
	TpfPersona * self;
	self = (TpfPersona*) base;
	self->priv->_is_constructed = TRUE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _tpf_persona_update_writeable_properties (TpfPersona* self) {
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	TpfPersonaStore* _tmp2_;
	TpfPersonaStore* tpf_store;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp1_) : NULL);
	tpf_store = _tmp2_;
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_persona_store_get_always_writeable_properties (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup1 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp7_;
	self->priv->_writeable_properties_length1 = _tmp7__length1;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_tmp8_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		TpfPersonaStore* _tmp10_;
		GeeSet* _tmp11_;
		GeeSet* _tmp12_;
		gboolean _tmp13_ = FALSE;
		TpfPersonaStore* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		gboolean _tmp19_ = FALSE;
		TpfPersonaStore* _tmp22_;
		GeeSet* _tmp23_;
		GeeSet* _tmp24_;
		gboolean _tmp25_ = FALSE;
		TpfPersonaStore* _tmp28_;
		GeeSet* _tmp29_;
		GeeSet* _tmp30_;
		gboolean _tmp31_ = FALSE;
		TpfPersonaStore* _tmp34_;
		GeeSet* _tmp35_;
		GeeSet* _tmp36_;
		gboolean _tmp37_ = FALSE;
		_tmp10_ = tpf_store;
		_tmp11_ = tpf_persona_store_get_supported_fields (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_collection_contains ((GeeCollection*) _tmp12_, "bday");
		if (_tmp13_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar* _tmp15_;
			_tmp14_ = self->priv->_writeable_properties;
			_tmp14__length1 = self->priv->_writeable_properties_length1;
			_tmp15_ = g_strdup ("birthday");
			_vala_array_add1 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp15_);
		}
		_tmp16_ = tpf_store;
		_tmp17_ = tpf_persona_store_get_supported_fields (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_collection_contains ((GeeCollection*) _tmp18_, "email");
		if (_tmp19_) {
			gchar** _tmp20_;
			gint _tmp20__length1;
			gchar* _tmp21_;
			_tmp20_ = self->priv->_writeable_properties;
			_tmp20__length1 = self->priv->_writeable_properties_length1;
			_tmp21_ = g_strdup ("email-addresses");
			_vala_array_add2 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp21_);
		}
		_tmp22_ = tpf_store;
		_tmp23_ = tpf_persona_store_get_supported_fields (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_collection_contains ((GeeCollection*) _tmp24_, "fn");
		if (_tmp25_) {
			gchar** _tmp26_;
			gint _tmp26__length1;
			gchar* _tmp27_;
			_tmp26_ = self->priv->_writeable_properties;
			_tmp26__length1 = self->priv->_writeable_properties_length1;
			_tmp27_ = g_strdup ("full-name");
			_vala_array_add3 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp27_);
		}
		_tmp28_ = tpf_store;
		_tmp29_ = tpf_persona_store_get_supported_fields (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = gee_collection_contains ((GeeCollection*) _tmp30_, "tel");
		if (_tmp31_) {
			gchar** _tmp32_;
			gint _tmp32__length1;
			gchar* _tmp33_;
			_tmp32_ = self->priv->_writeable_properties;
			_tmp32__length1 = self->priv->_writeable_properties_length1;
			_tmp33_ = g_strdup ("phone-numbers");
			_vala_array_add4 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp33_);
		}
		_tmp34_ = tpf_store;
		_tmp35_ = tpf_persona_store_get_supported_fields (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gee_collection_contains ((GeeCollection*) _tmp36_, "url");
		if (_tmp37_) {
			gchar** _tmp38_;
			gint _tmp38__length1;
			gchar* _tmp39_;
			_tmp38_ = self->priv->_writeable_properties;
			_tmp38__length1 = self->priv->_writeable_properties_length1;
			_tmp39_ = g_strdup ("urls");
			_vala_array_add5 (&self->priv->_writeable_properties, &self->priv->_writeable_properties_length1, &self->priv->__writeable_properties_size_, _tmp39_);
		}
	}
	_g_object_unref0 (tpf_store);
}


static void _tpf_persona_contact_notify_contact_info (TpfPersona* self, gboolean create_if_not_exists, gboolean emit_notification) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeHashSet* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp15_;
	gboolean _tmp16_ = FALSE;
	GeeHashSet* _tmp17_;
	gboolean _tmp19_;
	GObject* _tmp34_ = NULL;
	TpContact* contact;
	TpContact* _tmp35_;
	gboolean changed;
	gchar* _tmp36_;
	gchar* new_birthday_str;
	gchar* _tmp37_;
	gchar* new_full_name;
	GeeHashSet* _tmp38_;
	GeeHashSet* new_email_addresses;
	GeeHashSet* _tmp39_;
	GeeHashSet* new_phone_numbers;
	GeeHashSet* _tmp40_;
	GeeHashSet* new_urls;
	TpContact* _tmp41_;
	GList* _tmp42_ = NULL;
	GList* contact_info;
	GList* _tmp43_;
	const gchar* _tmp107_;
	GeeHashSet* _tmp129_;
	GeeHashSet* _tmp130_;
	gboolean _tmp131_ = FALSE;
	const gchar* _tmp138_;
	const gchar* _tmp139_;
	GeeHashSet* _tmp142_;
	GeeHashSet* _tmp143_;
	gboolean _tmp144_ = FALSE;
	GeeHashSet* _tmp151_;
	GeeHashSet* _tmp152_;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp159_;
	g_return_if_fail (self != NULL);
	_tmp3_ = self->priv->_email_addresses;
	if (_tmp3_ == NULL) {
		GeeHashSet* _tmp4_;
		_tmp4_ = self->priv->_phone_numbers;
		_tmp2_ = _tmp4_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		GeeHashSet* _tmp6_;
		_tmp6_ = self->priv->_urls;
		_tmp1_ = _tmp6_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		GeeHashSet* _tmp10_;
		gboolean _tmp12_;
		gboolean _tmp14_;
		_tmp10_ = self->priv->_email_addresses;
		if (_tmp10_ != NULL) {
			GeeHashSet* _tmp11_;
			_tmp11_ = self->priv->_phone_numbers;
			_tmp9_ = _tmp11_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp12_ = _tmp9_;
		if (_tmp12_) {
			GeeHashSet* _tmp13_;
			_tmp13_ = self->priv->_urls;
			_tmp8_ = _tmp13_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp14_ = _tmp8_;
		_tmp0_ = _tmp14_;
	}
	_tmp15_ = _tmp0_;
	_vala_assert (_tmp15_, "(           (this._email_addresses == null) &&           (this._phone_numbers == null) &&           (this._urls == null)         ) || (           (this._email_addresses != null) &&           (this._phone_numbers != null) &&           (this._urls != null)         )");
	_tmp17_ = self->priv->_urls;
	if (_tmp17_ == NULL) {
		gboolean _tmp18_;
		_tmp18_ = create_if_not_exists;
		_tmp16_ = _tmp18_ == FALSE;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		gboolean _tmp20_;
		_tmp20_ = emit_notification;
		if (_tmp20_) {
			g_object_notify ((GObject*) self, "email-addresses");
			g_object_notify ((GObject*) self, "phone-numbers");
			g_object_notify ((GObject*) self, "urls");
		}
		return;
	} else {
		GeeHashSet* _tmp21_;
		_tmp21_ = self->priv->_urls;
		if (_tmp21_ == NULL) {
			GeeHashSet* _tmp22_;
			GeeHashSet* _tmp23_;
			GeeSet* _tmp24_;
			GeeSet* _tmp25_;
			GeeHashSet* _tmp26_;
			GeeHashSet* _tmp27_;
			GeeSet* _tmp28_;
			GeeSet* _tmp29_;
			GeeHashSet* _tmp30_;
			GeeHashSet* _tmp31_;
			GeeSet* _tmp32_;
			GeeSet* _tmp33_;
			_tmp22_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
			_g_object_unref0 (self->priv->_urls);
			self->priv->_urls = _tmp22_;
			_tmp23_ = self->priv->_urls;
			_tmp24_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp23_);
			_tmp25_ = _tmp24_;
			_g_object_unref0 (self->priv->_urls_ro);
			self->priv->_urls_ro = _tmp25_;
			_tmp26_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
			_g_object_unref0 (self->priv->_email_addresses);
			self->priv->_email_addresses = _tmp26_;
			_tmp27_ = self->priv->_email_addresses;
			_tmp28_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp27_);
			_tmp29_ = _tmp28_;
			_g_object_unref0 (self->priv->_email_addresses_ro);
			self->priv->_email_addresses_ro = _tmp29_;
			_tmp30_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
			_g_object_unref0 (self->priv->_phone_numbers);
			self->priv->_phone_numbers = _tmp30_;
			_tmp31_ = self->priv->_phone_numbers;
			_tmp32_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (self->priv->_phone_numbers_ro);
			self->priv->_phone_numbers_ro = _tmp33_;
		}
	}
	_tmp34_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, tp_contact_get_type (), TpContact);
	_tmp35_ = contact;
	if (_tmp35_ == NULL) {
		_g_object_unref0 (contact);
		return;
	}
	changed = FALSE;
	_tmp36_ = g_strdup ("");
	new_birthday_str = _tmp36_;
	_tmp37_ = g_strdup ("");
	new_full_name = _tmp37_;
	_tmp38_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_email_addresses = _tmp38_;
	_tmp39_ = gee_hash_set_new (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_phone_numbers = _tmp39_;
	_tmp40_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	new_urls = _tmp40_;
	_tmp41_ = contact;
	_tmp42_ = tp_contact_get_contact_info (_tmp41_);
	contact_info = _tmp42_;
	_tmp43_ = contact_info;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp43_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			TpContactInfoField* info = NULL;
			info = (TpContactInfoField*) info_it->data;
			{
				TpContactInfoField* _tmp44_;
				const gchar* _tmp45_;
				_tmp44_ = info;
				_tmp45_ = _tmp44_->field_name;
				if (g_strcmp0 (_tmp45_, "") == 0) {
				} else {
					TpContactInfoField* _tmp46_;
					const gchar* _tmp47_;
					_tmp46_ = info;
					_tmp47_ = _tmp46_->field_name;
					if (g_strcmp0 (_tmp47_, "bday") == 0) {
						TpContactInfoField* _tmp48_;
						gchar** _tmp49_;
						gint _tmp49__length1;
						const gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						const gchar* _tmp53_;
						const gchar* _tmp55_;
						gchar* _tmp56_;
						_tmp48_ = info;
						_tmp49_ = _tmp48_->field_value;
						_tmp49__length1 = _vala_array_length (_tmp48_->field_value);
						_tmp50_ = _tmp49_[0];
						_tmp51_ = g_strdup (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _tmp52_;
						if (_tmp53_ == NULL) {
							gchar* _tmp54_;
							_tmp54_ = g_strdup ("");
							_g_free0 (_tmp52_);
							_tmp52_ = _tmp54_;
						}
						_tmp55_ = _tmp52_;
						_tmp56_ = g_strdup (_tmp55_);
						_g_free0 (new_birthday_str);
						new_birthday_str = _tmp56_;
						_g_free0 (_tmp52_);
					} else {
						TpContactInfoField* _tmp57_;
						const gchar* _tmp58_;
						_tmp57_ = info;
						_tmp58_ = _tmp57_->field_name;
						if (g_strcmp0 (_tmp58_, "email") == 0) {
							TpContactInfoField* _tmp59_;
							gchar** _tmp60_;
							gint _tmp60__length1;
							_tmp59_ = info;
							_tmp60_ = _tmp59_->field_value;
							_tmp60__length1 = _vala_array_length (_tmp59_->field_value);
							{
								gchar** email_addr_collection = NULL;
								gint email_addr_collection_length1 = 0;
								gint _email_addr_collection_size_ = 0;
								gint email_addr_it = 0;
								email_addr_collection = _tmp60_;
								email_addr_collection_length1 = _tmp60__length1;
								for (email_addr_it = 0; email_addr_it < _tmp60__length1; email_addr_it = email_addr_it + 1) {
									gchar* _tmp61_;
									gchar* email_addr = NULL;
									_tmp61_ = g_strdup (email_addr_collection[email_addr_it]);
									email_addr = _tmp61_;
									{
										const gchar* _tmp62_;
										_tmp62_ = email_addr;
										if (g_strcmp0 (_tmp62_, "") != 0) {
											TpContactInfoField* _tmp63_;
											gchar** _tmp64_;
											gint _tmp64__length1;
											GeeMultiMap* _tmp65_ = NULL;
											GeeMultiMap* parameters;
											const gchar* _tmp66_;
											GeeMultiMap* _tmp67_;
											FolksEmailFieldDetails* _tmp68_;
											FolksEmailFieldDetails* email_fd;
											GeeHashSet* _tmp69_;
											FolksEmailFieldDetails* _tmp70_;
											_tmp63_ = info;
											_tmp64_ = _tmp63_->parameters;
											_tmp64__length1 = _vala_array_length (_tmp63_->parameters);
											_tmp65_ = _tpf_persona_afd_params_from_strv (self, _tmp64_, _tmp64__length1);
											parameters = _tmp65_;
											_tmp66_ = email_addr;
											_tmp67_ = parameters;
											_tmp68_ = folks_email_field_details_new (_tmp66_, _tmp67_);
											email_fd = _tmp68_;
											_tmp69_ = new_email_addresses;
											_tmp70_ = email_fd;
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, _tmp70_);
											_g_object_unref0 (email_fd);
											_g_object_unref0 (parameters);
										}
										_g_free0 (email_addr);
									}
								}
							}
						} else {
							TpContactInfoField* _tmp71_;
							const gchar* _tmp72_;
							_tmp71_ = info;
							_tmp72_ = _tmp71_->field_name;
							if (g_strcmp0 (_tmp72_, "fn") == 0) {
								TpContactInfoField* _tmp73_;
								gchar** _tmp74_;
								gint _tmp74__length1;
								const gchar* _tmp75_;
								gchar* _tmp76_;
								const gchar* _tmp77_;
								_tmp73_ = info;
								_tmp74_ = _tmp73_->field_value;
								_tmp74__length1 = _vala_array_length (_tmp73_->field_value);
								_tmp75_ = _tmp74_[0];
								_tmp76_ = g_strdup (_tmp75_);
								_g_free0 (new_full_name);
								new_full_name = _tmp76_;
								_tmp77_ = new_full_name;
								if (_tmp77_ == NULL) {
									gchar* _tmp78_;
									_tmp78_ = g_strdup ("");
									_g_free0 (new_full_name);
									new_full_name = _tmp78_;
								}
							} else {
								TpContactInfoField* _tmp79_;
								const gchar* _tmp80_;
								_tmp79_ = info;
								_tmp80_ = _tmp79_->field_name;
								if (g_strcmp0 (_tmp80_, "tel") == 0) {
									TpContactInfoField* _tmp81_;
									gchar** _tmp82_;
									gint _tmp82__length1;
									_tmp81_ = info;
									_tmp82_ = _tmp81_->field_value;
									_tmp82__length1 = _vala_array_length (_tmp81_->field_value);
									{
										gchar** phone_num_collection = NULL;
										gint phone_num_collection_length1 = 0;
										gint _phone_num_collection_size_ = 0;
										gint phone_num_it = 0;
										phone_num_collection = _tmp82_;
										phone_num_collection_length1 = _tmp82__length1;
										for (phone_num_it = 0; phone_num_it < _tmp82__length1; phone_num_it = phone_num_it + 1) {
											gchar* _tmp83_;
											gchar* phone_num = NULL;
											_tmp83_ = g_strdup (phone_num_collection[phone_num_it]);
											phone_num = _tmp83_;
											{
												const gchar* _tmp84_;
												_tmp84_ = phone_num;
												if (g_strcmp0 (_tmp84_, "") != 0) {
													TpContactInfoField* _tmp85_;
													gchar** _tmp86_;
													gint _tmp86__length1;
													GeeMultiMap* _tmp87_ = NULL;
													GeeMultiMap* parameters;
													const gchar* _tmp88_;
													GeeMultiMap* _tmp89_;
													FolksPhoneFieldDetails* _tmp90_;
													FolksPhoneFieldDetails* phone_fd;
													GeeHashSet* _tmp91_;
													FolksPhoneFieldDetails* _tmp92_;
													_tmp85_ = info;
													_tmp86_ = _tmp85_->parameters;
													_tmp86__length1 = _vala_array_length (_tmp85_->parameters);
													_tmp87_ = _tpf_persona_afd_params_from_strv (self, _tmp86_, _tmp86__length1);
													parameters = _tmp87_;
													_tmp88_ = phone_num;
													_tmp89_ = parameters;
													_tmp90_ = folks_phone_field_details_new (_tmp88_, _tmp89_);
													phone_fd = _tmp90_;
													_tmp91_ = new_phone_numbers;
													_tmp92_ = phone_fd;
													gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
													_g_object_unref0 (phone_fd);
													_g_object_unref0 (parameters);
												}
												_g_free0 (phone_num);
											}
										}
									}
								} else {
									TpContactInfoField* _tmp93_;
									const gchar* _tmp94_;
									_tmp93_ = info;
									_tmp94_ = _tmp93_->field_name;
									if (g_strcmp0 (_tmp94_, "url") == 0) {
										TpContactInfoField* _tmp95_;
										gchar** _tmp96_;
										gint _tmp96__length1;
										_tmp95_ = info;
										_tmp96_ = _tmp95_->field_value;
										_tmp96__length1 = _vala_array_length (_tmp95_->field_value);
										{
											gchar** url_collection = NULL;
											gint url_collection_length1 = 0;
											gint _url_collection_size_ = 0;
											gint url_it = 0;
											url_collection = _tmp96_;
											url_collection_length1 = _tmp96__length1;
											for (url_it = 0; url_it < _tmp96__length1; url_it = url_it + 1) {
												gchar* _tmp97_;
												gchar* url = NULL;
												_tmp97_ = g_strdup (url_collection[url_it]);
												url = _tmp97_;
												{
													const gchar* _tmp98_;
													_tmp98_ = url;
													if (g_strcmp0 (_tmp98_, "") != 0) {
														TpContactInfoField* _tmp99_;
														gchar** _tmp100_;
														gint _tmp100__length1;
														GeeMultiMap* _tmp101_ = NULL;
														GeeMultiMap* parameters;
														const gchar* _tmp102_;
														GeeMultiMap* _tmp103_;
														FolksUrlFieldDetails* _tmp104_;
														FolksUrlFieldDetails* url_fd;
														GeeHashSet* _tmp105_;
														FolksUrlFieldDetails* _tmp106_;
														_tmp99_ = info;
														_tmp100_ = _tmp99_->parameters;
														_tmp100__length1 = _vala_array_length (_tmp99_->parameters);
														_tmp101_ = _tpf_persona_afd_params_from_strv (self, _tmp100_, _tmp100__length1);
														parameters = _tmp101_;
														_tmp102_ = url;
														_tmp103_ = parameters;
														_tmp104_ = folks_url_field_details_new (_tmp102_, _tmp103_);
														url_fd = _tmp104_;
														_tmp105_ = new_urls;
														_tmp106_ = url_fd;
														gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp106_);
														_g_object_unref0 (url_fd);
														_g_object_unref0 (parameters);
													}
													_g_free0 (url);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp107_ = new_birthday_str;
	if (g_strcmp0 (_tmp107_, "") != 0) {
		GTimeVal timeval = {0};
		const gchar* _tmp108_;
		gboolean _tmp109_ = FALSE;
		g_get_current_time (&timeval);
		_tmp108_ = new_birthday_str;
		_tmp109_ = g_time_val_from_iso8601 (_tmp108_, &timeval);
		if (_tmp109_) {
			GTimeVal _tmp110_;
			GDateTime* _tmp111_;
			GDateTime* d;
			gboolean _tmp112_ = FALSE;
			GDateTime* _tmp113_;
			gboolean _tmp122_;
			_tmp110_ = timeval;
			_tmp111_ = g_date_time_new_from_timeval_utc (&_tmp110_);
			d = _tmp111_;
			_tmp113_ = self->priv->_birthday;
			if (_tmp113_ == NULL) {
				_tmp112_ = TRUE;
			} else {
				gboolean _tmp114_ = FALSE;
				GDateTime* _tmp115_;
				gboolean _tmp121_;
				_tmp115_ = self->priv->_birthday;
				if (_tmp115_ != NULL) {
					GDateTime* _tmp116_;
					GDateTime* _tmp117_;
					GDateTime* _tmp118_ = NULL;
					GDateTime* _tmp119_;
					gboolean _tmp120_ = FALSE;
					_tmp116_ = self->priv->_birthday;
					_tmp117_ = d;
					_tmp118_ = g_date_time_to_utc (_tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = g_date_time_equal (_tmp116_, _tmp119_);
					_tmp114_ = !_tmp120_;
					_g_date_time_unref0 (_tmp119_);
				} else {
					_tmp114_ = FALSE;
				}
				_tmp121_ = _tmp114_;
				_tmp112_ = _tmp121_;
			}
			_tmp122_ = _tmp112_;
			if (_tmp122_) {
				GDateTime* _tmp123_;
				GDateTime* _tmp124_ = NULL;
				gboolean _tmp125_;
				_tmp123_ = d;
				_tmp124_ = g_date_time_to_utc (_tmp123_);
				_g_date_time_unref0 (self->priv->_birthday);
				self->priv->_birthday = _tmp124_;
				_tmp125_ = emit_notification;
				if (_tmp125_) {
					g_object_notify ((GObject*) self, "birthday");
				}
				changed = TRUE;
			}
			_g_date_time_unref0 (d);
		} else {
			const gchar* _tmp126_;
			_tmp126_ = new_birthday_str;
			g_debug ("tpf-persona.vala:1047: Failed to parse new birthday string '%s'", _tmp126_);
		}
	} else {
		GDateTime* _tmp127_;
		_tmp127_ = self->priv->_birthday;
		if (_tmp127_ != NULL) {
			gboolean _tmp128_;
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			_tmp128_ = emit_notification;
			if (_tmp128_) {
				g_object_notify ((GObject*) self, "birthday");
			}
			changed = TRUE;
		}
	}
	_tmp129_ = new_email_addresses;
	_tmp130_ = self->priv->_email_addresses;
	_tmp131_ = folks_internal_equal_sets (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp129_, (GeeSet*) _tmp130_);
	if (!_tmp131_) {
		GeeHashSet* _tmp132_;
		GeeHashSet* _tmp133_;
		GeeHashSet* _tmp134_;
		GeeSet* _tmp135_;
		GeeSet* _tmp136_;
		gboolean _tmp137_;
		_tmp132_ = new_email_addresses;
		_tmp133_ = _g_object_ref0 (_tmp132_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp133_;
		_tmp134_ = new_email_addresses;
		_tmp135_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp134_);
		_tmp136_ = _tmp135_;
		_g_object_unref0 (self->priv->_email_addresses_ro);
		self->priv->_email_addresses_ro = _tmp136_;
		_tmp137_ = emit_notification;
		if (_tmp137_) {
			g_object_notify ((GObject*) self, "email-addresses");
		}
		changed = TRUE;
	}
	_tmp138_ = new_full_name;
	_tmp139_ = self->priv->_full_name;
	if (g_strcmp0 (_tmp138_, _tmp139_) != 0) {
		const gchar* _tmp140_;
		gchar* _tmp141_;
		_tmp140_ = new_full_name;
		_tmp141_ = g_strdup (_tmp140_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp141_;
		g_object_notify ((GObject*) self, "full-name");
		changed = TRUE;
	}
	_tmp142_ = new_phone_numbers;
	_tmp143_ = self->priv->_phone_numbers;
	_tmp144_ = folks_internal_equal_sets (FOLKS_TYPE_PHONE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp142_, (GeeSet*) _tmp143_);
	if (!_tmp144_) {
		GeeHashSet* _tmp145_;
		GeeHashSet* _tmp146_;
		GeeHashSet* _tmp147_;
		GeeSet* _tmp148_;
		GeeSet* _tmp149_;
		gboolean _tmp150_;
		_tmp145_ = new_phone_numbers;
		_tmp146_ = _g_object_ref0 (_tmp145_);
		_g_object_unref0 (self->priv->_phone_numbers);
		self->priv->_phone_numbers = _tmp146_;
		_tmp147_ = new_phone_numbers;
		_tmp148_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp147_);
		_tmp149_ = _tmp148_;
		_g_object_unref0 (self->priv->_phone_numbers_ro);
		self->priv->_phone_numbers_ro = _tmp149_;
		_tmp150_ = emit_notification;
		if (_tmp150_) {
			g_object_notify ((GObject*) self, "phone-numbers");
		}
		changed = TRUE;
	}
	_tmp151_ = new_urls;
	_tmp152_ = self->priv->_urls;
	_tmp153_ = folks_internal_equal_sets (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeSet*) _tmp151_, (GeeSet*) _tmp152_);
	if (!_tmp153_) {
		GeeHashSet* _tmp154_;
		GeeHashSet* _tmp155_;
		GeeHashSet* _tmp156_;
		GeeSet* _tmp157_;
		GeeSet* _tmp158_;
		_tmp154_ = new_urls;
		_tmp155_ = _g_object_ref0 (_tmp154_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp155_;
		_tmp156_ = new_urls;
		_tmp157_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp156_);
		_tmp158_ = _tmp157_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp158_;
		g_object_notify ((GObject*) self, "urls");
		changed = TRUE;
	}
	_tmp159_ = changed;
	if (_tmp159_ == TRUE) {
		FolksPersonaStore* _tmp160_;
		FolksPersonaStore* _tmp161_;
		_tmp160_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp161_ = _tmp160_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
	_g_list_free0 (contact_info);
	_g_object_unref0 (new_urls);
	_g_object_unref0 (new_phone_numbers);
	_g_object_unref0 (new_email_addresses);
	_g_free0 (new_full_name);
	_g_free0 (new_birthday_str);
	_g_object_unref0 (contact);
}


static GeeMultiMap* _tpf_persona_afd_params_from_strv (TpfPersona* self, gchar** parameters, int parameters_length1) {
	GeeMultiMap* result = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* retval;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	retval = _tmp0_;
	_tmp1_ = parameters;
	_tmp1__length1 = parameters_length1;
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp1_;
		entry_collection_length1 = _tmp1__length1;
		for (entry_it = 0; entry_it < _tmp1__length1; entry_it = entry_it + 1) {
			gchar* _tmp2_;
			gchar* entry = NULL;
			_tmp2_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp2_;
			{
				const gchar* _tmp3_;
				gchar** _tmp4_;
				gchar** _tmp5_ = NULL;
				gchar** tokens;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp6_;
				gint _tmp6__length1;
				_tmp3_ = entry;
				_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "=", 2);
				tokens = _tmp5_;
				tokens_length1 = _vala_array_length (_tmp4_);
				_tokens_size_ = tokens_length1;
				_tmp6_ = tokens;
				_tmp6__length1 = tokens_length1;
				if (_tmp6__length1 == 2) {
					GeeHashMultiMap* _tmp7_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					const gchar* _tmp11_;
					_tmp7_ = retval;
					_tmp8_ = tokens;
					_tmp8__length1 = tokens_length1;
					_tmp9_ = _tmp8_[0];
					_tmp10_ = tokens;
					_tmp10__length1 = tokens_length1;
					_tmp11_ = _tmp10_[1];
					gee_multi_map_set ((GeeMultiMap*) _tmp7_, _tmp9_, _tmp11_);
				} else {
					const gchar* _tmp12_;
					_tmp12_ = entry;
					g_warning ("tpf-persona.vala:1123: Failed to parse vCard parameter from string '%s" \
"'", _tmp12_);
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	result = (GeeMultiMap*) retval;
	return result;
}


/**
   * Create a new persona for the {@link PersonaStore} ``store``, representing
   * a cached contact for which we currently have no Telepathy contact.
   *
   * @param store The persona store to place the persona in.
   * @param uid The cached UID of the persona.
   * @param iid The cached IID of the persona.
   * @param im_address The cached IM address of the persona (excluding
   * protocol).
   * @param protocol The cached protocol of the persona.
   * @param groups The cached set of groups the persona is in.
   * @param is_favourite Whether the persona is a favourite.
   * @param alias The cached alias for the persona.
   * @param is_in_contact_list Whether the persona is in the user's contact
   * list.
   * @param is_user Whether the persona is the user.
   * @param avatar The icon for the persona's cached avatar, or ``null`` if they
   * have no avatar.
   * @param birthday The date/time of birth of the persona, or ``null`` if it's
   * unknown.
   * @param full_name The persona's full name, or the empty string if it's
   * unknown.
   * @param email_addresses A set of the persona's e-mail addresses, which may
   * be empty (but may not be ``null``).
   * @param phone_numbers A set of the persona's phone numbers, which may be
   * empty (but may not be ``null``).
   * @param urls A set of the persona's URLs, which may be empty (but may not be
   * ``null``).
   * @return A new {@link Tpf.Persona} representing the cached persona.
   *
   * @since 0.6.0
   */
TpfPersona* tpf_persona_construct_from_cache (GType object_type, TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls) {
	TpfPersona * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	TpfPersonaStore* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksImFieldDetails* _tmp7_;
	FolksImFieldDetails* im_fd;
	GeeHashMultiMap* _tmp8_;
	const gchar* _tmp9_;
	FolksImFieldDetails* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeSet* _tmp15_;
	GeeHashSet* _tmp16_;
	GeeHashSet* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeSet* _tmp19_;
	GeeSet* _tmp20_;
	GeeHashSet* _tmp21_;
	GeeHashSet* _tmp22_;
	GeeHashSet* _tmp23_;
	GeeSet* _tmp24_;
	GeeSet* _tmp25_;
	GeeHashSet* _tmp26_;
	GeeHashSet* _tmp27_;
	GeeHashSet* _tmp28_;
	GeeSet* _tmp29_;
	GeeSet* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GDateTime* _tmp37_;
	GDateTime* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GLoadableIcon* _tmp41_;
	GLoadableIcon* _tmp42_;
	GFile* _tmp43_ = NULL;
	GLoadableIcon* _tmp44_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	GFile* avatar_file;
	TpfPersonaStore* _tmp49_;
	const gchar* _tmp50_;
	gchar** _tmp51_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (iid != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (groups != NULL, NULL);
	g_return_val_if_fail (alias != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	g_return_val_if_fail (email_addresses != NULL, NULL);
	g_return_val_if_fail (phone_numbers != NULL, NULL);
	g_return_val_if_fail (urls != NULL, NULL);
	_tmp0_ = im_address;
	_tmp1_ = iid;
	_tmp2_ = uid;
	_tmp3_ = store;
	_tmp4_ = is_user;
	self = (TpfPersona*) g_object_new (object_type, "contact", NULL, "display-id", _tmp0_, "iid", _tmp1_, "uid", _tmp2_, "store", _tmp3_, "is-user", _tmp4_, NULL);
	_tmp5_ = uid;
	g_debug ("tpf-persona.vala:1177: Created new Tpf.Persona '%s' from cache: %p", _tmp5_, self);
	_tmp6_ = im_address;
	_tmp7_ = folks_im_field_details_new (_tmp6_, NULL);
	im_fd = _tmp7_;
	_tmp8_ = self->priv->_im_addresses;
	_tmp9_ = protocol;
	_tmp10_ = im_fd;
	gee_multi_map_set ((GeeMultiMap*) _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = groups;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp12_;
	_tmp13_ = self->priv->_groups;
	_tmp14_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp15_;
	_tmp16_ = email_addresses;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp17_;
	_tmp18_ = self->priv->_email_addresses;
	_tmp19_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp20_;
	_tmp21_ = phone_numbers;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp22_;
	_tmp23_ = self->priv->_phone_numbers;
	_tmp24_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp25_;
	_tmp26_ = urls;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp27_;
	_tmp28_ = self->priv->_urls;
	_tmp29_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp28_);
	_tmp30_ = _tmp29_;
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp30_;
	_tmp31_ = alias;
	if (_tmp31_ == NULL) {
		alias = "";
	}
	_tmp32_ = full_name;
	if (_tmp32_ == NULL) {
		full_name = "";
	}
	_tmp33_ = alias;
	_tmp34_ = g_strdup (_tmp33_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp34_;
	_tmp35_ = is_favourite;
	self->priv->_is_favourite = _tmp35_;
	_tmp36_ = is_in_contact_list;
	tpf_persona_set_is_in_contact_list (self, _tmp36_);
	_tmp37_ = birthday;
	_tmp38_ = _g_date_time_ref0 (_tmp37_);
	_g_date_time_unref0 (self->priv->_birthday);
	self->priv->_birthday = _tmp38_;
	_tmp39_ = full_name;
	_tmp40_ = g_strdup (_tmp39_);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp40_;
	_tmp41_ = avatar;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp42_;
	_tmp44_ = avatar;
	if (_tmp44_ != NULL) {
		GLoadableIcon* _tmp45_;
		GFile* _tmp46_ = NULL;
		_tmp45_ = avatar;
		_tmp46_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, g_file_icon_get_type (), GFileIcon));
		_tmp43_ = _tmp46_;
	} else {
		_tmp43_ = NULL;
	}
	_tmp47_ = _tmp43_;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	avatar_file = _tmp48_;
	_tmp49_ = store;
	_tmp50_ = iid;
	_tpf_persona_store_update_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp50_, avatar_file);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, FOLKS_PRESENCE_TYPE_OFFLINE);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, "");
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, "offline");
	_tmp51_ = g_new0 (gchar*, 0 + 1);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp51_;
	self->priv->_writeable_properties_length1 = 0;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_g_object_unref0 (avatar_file);
	_g_object_unref0 (im_fd);
	return self;
}


TpfPersona* tpf_persona_new_from_cache (TpfPersonaStore* store, const gchar* uid, const gchar* iid, const gchar* im_address, const gchar* protocol, GeeHashSet* groups, gboolean is_favourite, const gchar* alias, gboolean is_in_contact_list, gboolean is_user, GLoadableIcon* avatar, GDateTime* birthday, const gchar* full_name, GeeHashSet* email_addresses, GeeHashSet* phone_numbers, GeeHashSet* urls) {
	return tpf_persona_construct_from_cache (TPF_TYPE_PERSONA, store, uid, iid, im_address, protocol, groups, is_favourite, alias, is_in_contact_list, is_user, avatar, birthday, full_name, email_addresses, phone_numbers, urls);
}


static void _tpf_persona_contact_notify_presence_message (TpfPersona* self) {
	GObject* _tmp0_ = NULL;
	TpContact* contact;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_vala_assert (contact != NULL, "contact != null");
	_tmp1_ = tp_contact_get_presence_message (contact);
	folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, _tmp1_);
	_g_object_unref0 (contact);
}


static void _tpf_persona_contact_notify_presence_type (TpfPersona* self) {
	GObject* _tmp0_ = NULL;
	TpContact* contact;
	TpConnectionPresenceType _tmp1_ = 0;
	FolksPresenceType _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_vala_assert (contact != NULL, "contact != null");
	_tmp1_ = tp_contact_get_presence_type (contact);
	_tmp2_ = _tpf_persona_folks_presence_type_from_tp (_tmp1_);
	folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, _tmp2_);
	_g_object_unref0 (contact);
}


static void _tpf_persona_contact_notify_presence_status (TpfPersona* self) {
	GObject* _tmp0_ = NULL;
	TpContact* contact;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_vala_assert (contact != NULL, "contact != null");
	_tmp1_ = tp_contact_get_presence_status (contact);
	folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, _tmp1_);
	_g_object_unref0 (contact);
}


static FolksPresenceType _tpf_persona_folks_presence_type_from_tp (TpConnectionPresenceType type) {
	FolksPresenceType result = 0;
	TpConnectionPresenceType _tmp0_;
	_tmp0_ = type;
	switch (_tmp0_) {
		case TP_CONNECTION_PRESENCE_TYPE_AVAILABLE:
		{
			result = FOLKS_PRESENCE_TYPE_AVAILABLE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_BUSY:
		{
			result = FOLKS_PRESENCE_TYPE_BUSY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_ERROR:
		{
			result = FOLKS_PRESENCE_TYPE_ERROR;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_EXTENDED_AWAY:
		{
			result = FOLKS_PRESENCE_TYPE_EXTENDED_AWAY;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_HIDDEN:
		{
			result = FOLKS_PRESENCE_TYPE_HIDDEN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_OFFLINE:
		{
			result = FOLKS_PRESENCE_TYPE_OFFLINE;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNKNOWN:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
		case TP_CONNECTION_PRESENCE_TYPE_UNSET:
		{
			result = FOLKS_PRESENCE_TYPE_UNSET;
			return result;
		}
		default:
		{
			result = FOLKS_PRESENCE_TYPE_UNKNOWN;
			return result;
		}
	}
}


static void _tpf_persona_contact_notify_avatar (TpfPersona* self) {
	GObject* _tmp0_ = NULL;
	TpContact* contact;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* file;
	TpContact* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* token;
	GIcon* icon;
	gboolean from_cache;
	const gchar* _tmp10_;
	GFile* _tmp20_;
	gboolean _tmp23_ = FALSE;
	GLoadableIcon* _tmp24_;
	GIcon* _tmp25_;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_tmp1_ = contact;
	_vala_assert (_tmp1_ != NULL, "contact != null");
	_tmp2_ = contact;
	_tmp3_ = tp_contact_get_avatar_file (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	file = _tmp5_;
	_tmp6_ = contact;
	_tmp7_ = tp_contact_get_avatar_token (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	token = _tmp9_;
	icon = NULL;
	from_cache = FALSE;
	_tmp10_ = token;
	if (g_strcmp0 (_tmp10_, "") == 0) {
		_g_object_unref0 (file);
		file = NULL;
		from_cache = FALSE;
	} else {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		gboolean _tmp14_;
		_tmp12_ = token;
		if (_tmp12_ != NULL) {
			GFile* _tmp13_;
			_tmp13_ = file;
			_tmp11_ = _tmp13_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		_tmp14_ = _tmp11_;
		if (_tmp14_) {
			from_cache = FALSE;
		} else {
			FolksPersonaStore* _tmp15_;
			FolksPersonaStore* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GFile* _tmp19_ = NULL;
			_tmp15_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = folks_persona_get_iid ((FolksPersona*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tpf_persona_store_query_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp18_);
			_g_object_unref0 (file);
			file = _tmp19_;
			from_cache = TRUE;
		}
	}
	_tmp20_ = file;
	if (_tmp20_ != NULL) {
		GFile* _tmp21_;
		GFileIcon* _tmp22_;
		_tmp21_ = file;
		_tmp22_ = (GFileIcon*) g_file_icon_new (_tmp21_);
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp22_;
	}
	_tmp24_ = self->priv->_avatar;
	_tmp25_ = icon;
	if ((_tmp24_ == NULL) != (_tmp25_ == NULL)) {
		_tmp23_ = TRUE;
	} else {
		GLoadableIcon* _tmp26_;
		GIcon* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp26_ = self->priv->_avatar;
		_tmp27_ = icon;
		_tmp28_ = g_icon_equal ((GIcon*) _tmp26_, _tmp27_);
		_tmp23_ = !_tmp28_;
	}
	_tmp29_ = _tmp23_;
	if (_tmp29_) {
		GIcon* _tmp30_;
		GLoadableIcon* _tmp31_;
		gboolean _tmp32_;
		_tmp30_ = icon;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, g_loadable_icon_get_type (), GLoadableIcon));
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = _tmp31_;
		g_object_notify ((GObject*) self, "avatar");
		_tmp32_ = from_cache;
		if (_tmp32_ == FALSE) {
			FolksPersonaStore* _tmp33_;
			FolksPersonaStore* _tmp34_;
			FolksPersonaStore* _tmp35_;
			FolksPersonaStore* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			GFile* _tmp39_;
			_tmp33_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp34_ = _tmp33_;
			_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
			_tmp35_ = folks_persona_get_store ((FolksPersona*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = folks_persona_get_iid ((FolksPersona*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = file;
			_tpf_persona_store_update_avatar_cache (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore), _tmp38_, _tmp39_);
		}
	}
	_g_object_unref0 (icon);
	_g_free0 (token);
	_g_object_unref0 (file);
	_g_object_unref0 (contact);
}


/**
   * Look up a {@link Tpf.Persona} by its {@link TelepathyGLib.Contact}.
   *
   * If the {@link TelepathyGLib.Account} for the contact's
   * {@link TelepathyGLib.Connection} is ``null``, or if a
   * {@link Tpf.PersonaStore} can't be found for that account, ``null`` will be
   * returned. Otherwise, if a {@link Tpf.Persona} already exists for the given
   * contact, that will be returned; if one doesn't exist a new one will be
   * created and returned. In this case, the {@link Tpf.Persona} will be added
   * to the {@link PersonaStore} associated with the account, and will be
   * removed when ``contact`` is destroyed.
   *
   * @param contact the Telepathy contact of the persona
   * @return the persona associated with the contact, or ``null``
   * @since 0.6.6
   */
TpfPersona* tpf_persona_dup_for_contact (TpContact* contact) {
	TpfPersona* result = NULL;
	TpContact* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* _tmp2_;
	TpAccount* _tmp3_ = NULL;
	TpAccount* _tmp4_;
	TpAccount* account;
	TpContact* _tmp5_;
	TpAccount* _tmp6_;
	TpAccount* _tmp7_;
	TpAccount* _tmp8_;
	TpfPersonaStore* _tmp9_ = NULL;
	TpfPersonaStore* store;
	TpfPersonaStore* _tmp10_;
	TpContact* _tmp11_;
	TpfPersona* _tmp12_ = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_connection (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tp_connection_get_account (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	account = _tmp4_;
	_tmp5_ = contact;
	_tmp6_ = account;
	g_debug ("tpf-persona.vala:1364: Tpf.Persona.dup_for_contact (%p): got account %" \
"p", _tmp5_, _tmp6_);
	_tmp7_ = account;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (account);
		return result;
	}
	_tmp8_ = account;
	_tmp9_ = tpf_persona_store_dup_for_account (_tmp8_);
	store = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = contact;
	_tmp12_ = _tpf_persona_store_ensure_persona_for_contact (_tmp10_, _tmp11_);
	result = _tmp12_;
	_g_object_unref0 (store);
	_g_object_unref0 (account);
	return result;
}


void _tpf_persona_increase_counter (TpfPersona* self, const gchar* id, const gchar* interaction_type, ZeitgeistEvent* event) {
	ZeitgeistEvent* _tmp0_;
	gint64 _tmp1_ = 0LL;
	guint timestamp;
	guint _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* converted_datetime;
	ZeitgeistEvent* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* interpretation;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (interaction_type != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_timestamp (_tmp0_);
	timestamp = (guint) (_tmp1_ / 1000);
	_tmp2_ = timestamp;
	_tmp3_ = g_date_time_new_from_unix_utc ((gint64) _tmp2_);
	converted_datetime = _tmp3_;
	_tmp4_ = event;
	_tmp5_ = zeitgeist_event_get_interpretation (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	interpretation = _tmp6_;
	_tmp8_ = interaction_type;
	if (g_strcmp0 (_tmp8_, ZEITGEIST_NMO_IMMESSAGE) == 0) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gboolean _tmp12_;
		_tmp10_ = interpretation;
		if (g_strcmp0 (_tmp10_, ZEITGEIST_ZG_SEND_EVENT) == 0) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = interpretation;
			_tmp9_ = g_strcmp0 (_tmp11_, ZEITGEIST_ZG_RECEIVE_EVENT) == 0;
		}
		_tmp12_ = _tmp9_;
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		guint _tmp14_;
		gboolean _tmp15_ = FALSE;
		GDateTime* _tmp16_;
		gboolean _tmp20_;
		const gchar* _tmp23_;
		guint _tmp24_;
		GDateTime* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		_tmp14_ = self->priv->_im_interaction_count;
		self->priv->_im_interaction_count = _tmp14_ + 1;
		g_object_notify ((GObject*) self, "im-interaction-count");
		_tmp16_ = self->_last_im_interaction_datetime;
		if (_tmp16_ == NULL) {
			_tmp15_ = TRUE;
		} else {
			GDateTime* _tmp17_;
			GDateTime* _tmp18_;
			gint _tmp19_ = 0;
			_tmp17_ = self->_last_im_interaction_datetime;
			_tmp18_ = converted_datetime;
			_tmp19_ = g_date_time_compare (_tmp17_, _tmp18_);
			_tmp15_ = _tmp19_ == (-1);
		}
		_tmp20_ = _tmp15_;
		if (_tmp20_) {
			GDateTime* _tmp21_;
			GDateTime* _tmp22_;
			_tmp21_ = converted_datetime;
			_tmp22_ = _g_date_time_ref0 (_tmp21_);
			_g_date_time_unref0 (self->_last_im_interaction_datetime);
			self->_last_im_interaction_datetime = _tmp22_;
			g_object_notify ((GObject*) self, "last-im-interaction-datetime");
		}
		_tmp23_ = id;
		_tmp24_ = self->priv->_im_interaction_count;
		_tmp25_ = self->_last_im_interaction_datetime;
		_tmp26_ = g_date_time_format (_tmp25_, "%H %M %S - %d %m %y");
		_tmp27_ = _tmp26_;
		g_debug ("tpf-persona.vala:1396: Persona %s IM interaction details changed:\n" \
" - count: %u \n" \
" - timestamp: %lld\n", _tmp23_, _tmp24_, _tmp27_);
		_g_free0 (_tmp27_);
	} else {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		gboolean _tmp31_;
		_tmp29_ = interaction_type;
		if (g_strcmp0 (_tmp29_, ZEITGEIST_NFO_AUDIO) == 0) {
			const gchar* _tmp30_;
			_tmp30_ = interpretation;
			_tmp28_ = g_strcmp0 (_tmp30_, ZEITGEIST_ZG_LEAVE_EVENT) == 0;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp31_ = _tmp28_;
		if (_tmp31_) {
			guint _tmp32_;
			gboolean _tmp33_ = FALSE;
			GDateTime* _tmp34_;
			gboolean _tmp38_;
			const gchar* _tmp41_;
			guint _tmp42_;
			GDateTime* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_;
			_tmp32_ = self->priv->_call_interaction_count;
			self->priv->_call_interaction_count = _tmp32_ + 1;
			g_object_notify ((GObject*) self, "call-interaction-count");
			_tmp34_ = self->_last_call_interaction_datetime;
			if (_tmp34_ == NULL) {
				_tmp33_ = TRUE;
			} else {
				GDateTime* _tmp35_;
				GDateTime* _tmp36_;
				gint _tmp37_ = 0;
				_tmp35_ = self->_last_call_interaction_datetime;
				_tmp36_ = converted_datetime;
				_tmp37_ = g_date_time_compare (_tmp35_, _tmp36_);
				_tmp33_ = _tmp37_ == (-1);
			}
			_tmp38_ = _tmp33_;
			if (_tmp38_) {
				GDateTime* _tmp39_;
				GDateTime* _tmp40_;
				_tmp39_ = converted_datetime;
				_tmp40_ = _g_date_time_ref0 (_tmp39_);
				_g_date_time_unref0 (self->_last_call_interaction_datetime);
				self->_last_call_interaction_datetime = _tmp40_;
				g_object_notify ((GObject*) self, "last-call-interaction-datetime");
			}
			_tmp41_ = id;
			_tmp42_ = self->priv->_call_interaction_count;
			_tmp43_ = self->_last_call_interaction_datetime;
			_tmp44_ = g_date_time_format (_tmp43_, "%H %M %S - %d %m %y");
			_tmp45_ = _tmp44_;
			g_debug ("tpf-persona.vala:1411: Persona %s Call interaction details changed:\n" \
" - count: %u \n" \
" - timestamp: %lld\n", _tmp41_, _tmp42_, _tmp45_);
			_g_free0 (_tmp45_);
		}
	}
	_g_free0 (interpretation);
	_g_date_time_unref0 (converted_datetime);
}


void _tpf_persona_reset_interaction (TpfPersona* self) {
	g_return_if_fail (self != NULL);
	self->priv->_call_interaction_count = (guint) 0;
	self->priv->_im_interaction_count = (guint) 0;
	_g_date_time_unref0 (self->_last_call_interaction_datetime);
	self->_last_call_interaction_datetime = NULL;
	_g_date_time_unref0 (self->_last_im_interaction_datetime);
	self->_last_im_interaction_datetime = NULL;
}


gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_in_contact_list;
	result = _tmp0_;
	return result;
}


void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_in_contact_list = _tmp0_;
	g_object_notify ((GObject *) self, "is-in-contact-list");
}


static GLoadableIcon* tpf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	TpfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* tpf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TpfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = "";
	return result;
}


static void tpf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* tpf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TpfPersona* self;
	self = (TpfPersona*) base;
	result = NULL;
	return result;
}


static void tpf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_calendar_event_id ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static GDateTime* tpf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_birthday;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_birthday_details_change_birthday ((FolksBirthdayDetails*) self, _tmp0_, NULL, NULL);
}


static FolksPresenceType tpf_persona_real_get_presence_type (FolksPresenceDetails* base) {
	FolksPresenceType result;
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_type;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_type (FolksPresenceDetails* base, FolksPresenceType value) {
	TpfPersona* self;
	FolksPresenceType _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	self->priv->_presence_type = _tmp0_;
	g_object_notify ((GObject *) self, "presence-type");
}


static const gchar* tpf_persona_real_get_presence_status (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_status;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_status (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_status);
	self->priv->_presence_status = _tmp1_;
	g_object_notify ((GObject *) self, "presence-status");
}


static const gchar* tpf_persona_real_get_presence_message (FolksPresenceDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_presence_message;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_presence_message (FolksPresenceDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_presence_message);
	self->priv->_presence_message = _tmp1_;
	g_object_notify ((GObject *) self, "presence-message");
}


static gchar** tpf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (TpfPersona*) base;
	_tmp0_ = TPF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (TPF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** tpf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TpfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_writeable_properties;
	_tmp0__length1 = self->priv->_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static const gchar* tpf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_alias;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	TpfPersona* self;
	const gchar* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_alias_details_change_alias ((FolksAliasDetails*) self, _tmp0_, NULL, NULL);
}


static gboolean tpf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TpfPersona* self;
	gboolean _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_is_favourite;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TpfPersona* self;
	gboolean _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_favourite_details_change_is_favourite ((FolksFavouriteDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_email_addresses_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_email_details_change_email_addresses ((FolksEmailDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* tpf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TpfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void tpf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TpfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static guint tpf_persona_real_get_im_interaction_count (FolksInteractionDetails* base) {
	guint result;
	TpfPersona* self;
	guint _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_im_interaction_count;
	result = _tmp0_;
	return result;
}


static GDateTime* tpf_persona_real_get_last_im_interaction_datetime (FolksInteractionDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->_last_im_interaction_datetime;
	result = _tmp0_;
	return result;
}


static guint tpf_persona_real_get_call_interaction_count (FolksInteractionDetails* base) {
	guint result;
	TpfPersona* self;
	guint _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_call_interaction_count;
	result = _tmp0_;
	return result;
}


static GDateTime* tpf_persona_real_get_last_call_interaction_datetime (FolksInteractionDetails* base) {
	GDateTime* result;
	TpfPersona* self;
	GDateTime* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->_last_call_interaction_datetime;
	result = _tmp0_;
	return result;
}


static GeeSet* tpf_persona_real_get_groups (FolksGroupDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = self->priv->_groups_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_groups (FolksGroupDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_group_details_change_groups ((FolksGroupDetails*) self, _tmp0_, NULL, NULL);
}


TpContact* tpf_persona_get_contact (TpfPersona* self) {
	TpContact* result;
	GObject* _tmp0_ = NULL;
	TpContact* contact;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_tmp1_ = contact;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (contact);
		return result;
	}
	_tmp2_ = contact;
	result = G_TYPE_CHECK_INSTANCE_CAST ((void*) _tmp2_, tp_contact_get_type (), TpContact);
	_g_object_unref0 (contact);
	return result;
}


static void tpf_persona_set_contact (TpfPersona* self, TpContact* value) {
	TpContact* _tmp0_;
	TpContact* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		TpContact* _tmp1_;
		_tmp1_ = value;
		g_object_weak_ref ((GObject*) _tmp1_, __tpf_persona_contact_weak_notify_cb_gweak_notify, self);
	}
	_tmp2_ = value;
	g_weak_ref_set (&self->priv->_contact, (GObject*) _tmp2_);
	g_object_notify ((GObject *) self, "contact");
}


static GeeSet* tpf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_phone_numbers_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_phone_details_change_phone_numbers ((FolksPhoneDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* tpf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tpf_persona_contact_notify_contact_info (self, TRUE, FALSE);
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void tpf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TpfPersona* self;
	GeeSet* _tmp0_;
	self = (TpfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static void _tpf_persona___lambda12_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	TpContact* c;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	TpContact* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = g_weak_ref_get (&self->priv->_contact);
	c = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, tp_contact_get_type (), TpContact);
	_tmp1_ = c;
	_vala_assert (_tmp1_ != NULL, "c != null");
	_tmp2_ = c;
	_tmp3_ = tp_contact_get_alias (_tmp2_);
	_tmp4_ = _tmp3_;
	_vala_assert (_tmp4_ != NULL, "c.alias != null");
	_tmp5_ = self->priv->_alias;
	_tmp6_ = c;
	_tmp7_ = tp_contact_get_alias (_tmp6_);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp5_, _tmp8_) != 0) {
		TpContact* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		FolksPersonaStore* _tmp13_;
		FolksPersonaStore* _tmp14_;
		_tmp9_ = c;
		_tmp10_ = tp_contact_get_alias (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp12_;
		g_object_notify ((GObject*) self, "alias");
		_tmp13_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp14_ = _tmp13_;
		_tpf_persona_store_set_cache_needs_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TPF_TYPE_PERSONA_STORE, TpfPersonaStore));
	}
	_g_object_unref0 (c);
}


static void __tpf_persona___lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda12_ (self, _sender, pspec);
}


static void _tpf_persona___lambda13_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_avatar (self);
}


static void __tpf_persona___lambda13__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda13_ (self, _sender, pspec);
}


static void _tpf_persona___lambda14_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_message (self);
}


static void __tpf_persona___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda14_ (self, _sender, pspec);
}


static void _tpf_persona___lambda15_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_type (self);
}


static void __tpf_persona___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda15_ (self, _sender, pspec);
}


static void _tpf_persona___lambda16_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_presence_status (self);
}


static void __tpf_persona___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda16_ (self, _sender, pspec);
}


static void _tpf_persona___lambda17_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_contact_notify_contact_info (self, FALSE, TRUE);
}


static void __tpf_persona___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda17_ (self, _sender, pspec);
}


static void _tpf_persona___lambda18_ (TpfPersona* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	_tmp0_ = added;
	_tmp0__length1 = added_length1;
	_tmp1_ = removed;
	_tmp1__length1 = removed_length1;
	_tpf_persona_contact_groups_changed (self, _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1);
}


static void __tpf_persona___lambda18__tp_contact_contact_groups_changed (TpContact* _sender, gchar** added, gchar** removed, gpointer self) {
	_tpf_persona___lambda18_ (self, added, _vala_array_length (added), removed, _vala_array_length (removed));
}


static void _tpf_persona____lambda19_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_update_writeable_properties (self);
}


static void __tpf_persona____lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona____lambda19_ (self, _sender, pspec);
}


static void _tpf_persona___lambda20_ (TpfPersona* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tpf_persona_update_writeable_properties (self);
}


static void __tpf_persona___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona___lambda20_ (self, _sender, pspec);
}


static GObject * tpf_persona_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	TpfPersona * self;
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GObject* _tmp3_ = NULL;
	TpContact* contact;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	TpContact* _tmp8_;
	TpContact* _tmp9_;
	TpConnection* _tmp10_;
	TpConnection* _tmp11_;
	TpConnection* _tmp12_;
	TpConnection* connection;
	TpConnection* _tmp13_;
	TpAccount* _tmp14_ = NULL;
	TpAccount* _tmp15_;
	TpAccount* account;
	TpContact* _tmp29_;
	TpContact* _tmp30_;
	TpContact* _tmp31_;
	TpContact* _tmp32_;
	TpContact* _tmp33_;
	TpContact* _tmp34_;
	TpContact* _tmp35_;
	gchar** _tmp36_;
	gchar** _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gchar** _tmp39_;
	gint _tmp39__length1;
	FolksPersonaStore* _tmp40_;
	FolksPersonaStore* _tmp41_;
	TpfPersonaStore* _tmp42_;
	TpfPersonaStore* tpf_store;
	gboolean _tmp43_;
	gboolean _tmp44_;
	TpfPersonaStore* _tmp46_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (tpf_persona_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA, TpfPersona);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->_groups_ro);
	self->priv->_groups_ro = _tmp2_;
	_tmp3_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, tp_contact_get_type (), TpContact);
	_tmp4_ = contact;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (contact);
		return obj;
	}
	_tmp5_ = contact;
	_tmp6_ = tp_contact_get_alias (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp7_;
	_tmp8_ = contact;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::alias", (GCallback) __tpf_persona___lambda12__g_object_notify, self, 0);
	_tmp9_ = contact;
	_tmp10_ = tp_contact_get_connection (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	connection = _tmp12_;
	_tmp13_ = connection;
	_tmp14_ = tp_connection_get_account (_tmp13_);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	account = _tmp15_;
	{
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		TpAccount* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* im_addr;
		const gchar* _tmp21_;
		FolksImFieldDetails* _tmp22_;
		FolksImFieldDetails* im_fd;
		GeeHashMultiMap* _tmp23_;
		TpAccount* _tmp24_;
		const gchar* _tmp25_ = NULL;
		FolksImFieldDetails* _tmp26_;
		_tmp16_ = folks_persona_get_display_id ((FolksPersona*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = account;
		_tmp19_ = tp_account_get_protocol (_tmp18_);
		_tmp20_ = folks_im_details_normalise_im_address (_tmp17_, _tmp19_, &_inner_error_);
		im_addr = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
				goto __catch5_folks_im_details_error;
			}
			_g_object_unref0 (account);
			_g_object_unref0 (connection);
			_g_object_unref0 (contact);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_tmp21_ = im_addr;
		_tmp22_ = folks_im_field_details_new (_tmp21_, NULL);
		im_fd = _tmp22_;
		_tmp23_ = self->priv->_im_addresses;
		_tmp24_ = account;
		_tmp25_ = tp_account_get_protocol (_tmp24_);
		_tmp26_ = im_fd;
		gee_multi_map_set ((GeeMultiMap*) _tmp23_, _tmp25_, _tmp26_);
		_g_object_unref0 (im_fd);
		_g_free0 (im_addr);
	}
	goto __finally5;
	__catch5_folks_im_details_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_warning ("tpf-persona.vala:829: %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (account);
		_g_object_unref0 (connection);
		_g_object_unref0 (contact);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp29_ = contact;
	g_signal_connect_object ((GObject*) _tmp29_, "notify::avatar-file", (GCallback) __tpf_persona___lambda13__g_object_notify, self, 0);
	_tpf_persona_contact_notify_avatar (self);
	_tmp30_ = contact;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::presence-message", (GCallback) __tpf_persona___lambda14__g_object_notify, self, 0);
	_tmp31_ = contact;
	g_signal_connect_object ((GObject*) _tmp31_, "notify::presence-type", (GCallback) __tpf_persona___lambda15__g_object_notify, self, 0);
	_tmp32_ = contact;
	g_signal_connect_object ((GObject*) _tmp32_, "notify::presence-status", (GCallback) __tpf_persona___lambda16__g_object_notify, self, 0);
	_tpf_persona_contact_notify_presence_message (self);
	_tpf_persona_contact_notify_presence_type (self);
	_tpf_persona_contact_notify_presence_status (self);
	_tmp33_ = contact;
	g_signal_connect_object ((GObject*) _tmp33_, "notify::contact-info", (GCallback) __tpf_persona___lambda17__g_object_notify, self, 0);
	_tpf_persona_contact_notify_contact_info (self, FALSE, TRUE);
	_tmp34_ = contact;
	g_signal_connect_object (_tmp34_, "contact-groups-changed", (GCallback) __tpf_persona___lambda18__tp_contact_contact_groups_changed, self, 0);
	_tmp35_ = contact;
	_tmp37_ = _tmp36_ = tp_contact_get_contact_groups (_tmp35_);
	_tmp38_ = g_new0 (gchar*, 0 + 1);
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 0;
	_tpf_persona_contact_groups_changed (self, _tmp37_, _vala_array_length (_tmp36_), _tmp39_, 0);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp41_) : NULL);
	tpf_store = _tmp42_;
	_tmp43_ = folks_persona_get_is_user ((FolksPersona*) self);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		TpfPersonaStore* _tmp45_;
		_tmp45_ = tpf_store;
		g_signal_connect_object ((GObject*) _tmp45_, "notify::supported-fields", (GCallback) __tpf_persona____lambda19__g_object_notify, self, 0);
	}
	_tmp46_ = tpf_store;
	g_signal_connect_object ((GObject*) _tmp46_, "notify::always-writeable-properties", (GCallback) __tpf_persona___lambda20__g_object_notify, self, 0);
	_tpf_persona_update_writeable_properties (self);
	_g_object_unref0 (tpf_store);
	_g_object_unref0 (account);
	_g_object_unref0 (connection);
	_g_object_unref0 (contact);
	return obj;
}


static void tpf_persona_class_init (TpfPersonaClass * klass) {
	tpf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaPrivate));
	G_OBJECT_CLASS (klass)->constructed = tpf_persona_real_constructed;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = tpf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = tpf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_set_property;
	G_OBJECT_CLASS (klass)->constructor = tpf_persona_constructor;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_finalize;
	/**
	   * Whether the Persona is in the user's contact list.
	   *
	   * This will be true for most {@link Folks.Persona}s, but may not be true for
	   * personas where {@link Folks.Persona.is_user} is true. If it's false in
	   * this case, it means that the persona has been retrieved from the Telepathy
	   * connection, but has not been added to the user's contact list.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_IN_CONTACT_LIST, g_param_spec_boolean ("is-in-contact-list", "is-in-contact-list", "is-in-contact-list", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_AVATAR, g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STRUCTURED_NAME, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_FULL_NAME, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_NICKNAME, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * ContactInfo has no equivalent field, so this is unsupported.
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CALENDAR_EVENT_ID, g_param_spec_string ("calendar-event-id", "calendar-event-id", "calendar-event-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_BIRTHDAY, g_param_spec_boxed ("birthday", "birthday", "birthday", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence type.
	   *
	   * See {@link Folks.PresenceDetails.presence_type}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_TYPE, g_param_spec_enum ("presence-type", "presence-type", "presence-type", FOLKS_TYPE_PRESENCE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence status.
	   *
	   * See {@link Folks.PresenceDetails.presence_status}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_STATUS, g_param_spec_string ("presence-status", "presence-status", "presence-status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Persona's presence message.
	   *
	   * See {@link Folks.PresenceDetails.presence_message}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PRESENCE_MESSAGE, g_param_spec_string ("presence-message", "presence-message", "presence-message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.AliasDetails.alias}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_ALIAS, g_param_spec_string ("alias", "alias", "alias", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this Persona is a user-defined favourite.
	   *
	   * See {@link Folks.FavouriteDetails.is_favourite}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IS_FAVOURITE, g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_EMAIL_ADDRESSES, g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A mapping of IM protocol to an (unordered) set of IM addresses.
	   *
	   * See {@link Folks.ImDetails.im_addresses}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_ADDRESSES, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * A counter for IM interactions (send/receive message) with the persona.
	   *
	   * See {@link Folks.InteractionDetails.im_interaction_count}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_IM_INTERACTION_COUNT, g_param_spec_uint ("im-interaction-count", "im-interaction-count", "im-interaction-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The latest datetime for IM interactions (send/receive message) with the
	   * persona.
	   *
	   * See {@link Folks.InteractionDetails.last_im_interaction_datetime}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LAST_IM_INTERACTION_DATETIME, g_param_spec_boxed ("last-im-interaction-datetime", "last-im-interaction-datetime", "last-im-interaction-datetime", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A counter for call interactions (only successful calls) with the persona.
	   *
	   * See {@link Folks.InteractionDetails.call_interaction_count}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CALL_INTERACTION_COUNT, g_param_spec_uint ("call-interaction-count", "call-interaction-count", "call-interaction-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The latest datetime for call interactions (only successful calls) with the
	   * persona.
	   *
	   * See {@link Folks.InteractionDetails.last_call_interaction_datetime}
	   *
	   * @since 0.7.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME, g_param_spec_boxed ("last-call-interaction-datetime", "last-call-interaction-datetime", "last-call-interaction-datetime", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * A set group IDs for the groups the contact is a member of.
	   *
	   * See {@link Folks.GroupDetails.groups}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_GROUPS, g_param_spec_object ("groups", "groups", "groups", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The Telepathy contact represented by this persona.
	   *
	   * Note that this may be ``null`` if the {@link PersonaStore} providing this
	   * {@link Persona} isn't currently available (e.g. due to not being connected
	   * to the network). In this case, most other properties of the {@link Persona}
	   * are being retrieved from a cache and may not be current (though there's no
	   * way to tell this).
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_CONTACT, g_param_spec_object ("contact", "contact", "contact", tp_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_PHONE_NUMBERS, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.4
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_URLS, g_param_spec_object ("urls", "urls", "urls", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tpf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	tpf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_alias = (void (*)(FolksAliasDetails*, const gchar*, GError**)) tpf_persona_real_change_alias;
	iface->change_alias_finish = tpf_persona_real_change_alias_finish;
	iface->get_alias = tpf_persona_real_get_alias;
	iface->set_alias = tpf_persona_real_set_alias;
}


static void tpf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	tpf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = tpf_persona_real_get_avatar;
	iface->set_avatar = tpf_persona_real_set_avatar;
}


static void tpf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	tpf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_birthday = (void (*)(FolksBirthdayDetails*, GDateTime*, GError**)) tpf_persona_real_change_birthday;
	iface->change_birthday_finish = tpf_persona_real_change_birthday_finish;
	iface->get_calendar_event_id = tpf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = tpf_persona_real_set_calendar_event_id;
	iface->get_birthday = tpf_persona_real_get_birthday;
	iface->set_birthday = tpf_persona_real_set_birthday;
}


static void tpf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	tpf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_email_addresses = (void (*)(FolksEmailDetails*, GeeSet*, GError**)) tpf_persona_real_change_email_addresses;
	iface->change_email_addresses_finish = tpf_persona_real_change_email_addresses_finish;
	iface->get_email_addresses = tpf_persona_real_get_email_addresses;
	iface->set_email_addresses = tpf_persona_real_set_email_addresses;
}


static void tpf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	tpf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_is_favourite = (void (*)(FolksFavouriteDetails*, gboolean, GError**)) tpf_persona_real_change_is_favourite;
	iface->change_is_favourite_finish = tpf_persona_real_change_is_favourite_finish;
	iface->get_is_favourite = tpf_persona_real_get_is_favourite;
	iface->set_is_favourite = tpf_persona_real_set_is_favourite;
}


static void tpf_persona_folks_group_details_interface_init (FolksGroupDetailsIface * iface) {
	tpf_persona_folks_group_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = (void (*)(FolksGroupDetails*, const gchar*, gboolean, GError**)) tpf_persona_real_change_group;
	iface->change_group_finish = tpf_persona_real_change_group_finish;
	iface->change_groups = (void (*)(FolksGroupDetails*, GeeSet*, GError**)) tpf_persona_real_change_groups;
	iface->change_groups_finish = tpf_persona_real_change_groups_finish;
	iface->get_groups = tpf_persona_real_get_groups;
	iface->set_groups = tpf_persona_real_set_groups;
}


static void tpf_persona_folks_interaction_details_interface_init (FolksInteractionDetailsIface * iface) {
	tpf_persona_folks_interaction_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_interaction_count = tpf_persona_real_get_im_interaction_count;
	iface->get_last_im_interaction_datetime = tpf_persona_real_get_last_im_interaction_datetime;
	iface->get_call_interaction_count = tpf_persona_real_get_call_interaction_count;
	iface->get_last_call_interaction_datetime = tpf_persona_real_get_last_call_interaction_datetime;
}


static void tpf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	tpf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = tpf_persona_real_get_im_addresses;
	iface->set_im_addresses = tpf_persona_real_set_im_addresses;
}


static void tpf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	tpf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_full_name = (void (*)(FolksNameDetails*, const gchar*, GError**)) tpf_persona_real_change_full_name;
	iface->change_full_name_finish = tpf_persona_real_change_full_name_finish;
	iface->get_structured_name = tpf_persona_real_get_structured_name;
	iface->set_structured_name = tpf_persona_real_set_structured_name;
	iface->get_full_name = tpf_persona_real_get_full_name;
	iface->set_full_name = tpf_persona_real_set_full_name;
	iface->get_nickname = tpf_persona_real_get_nickname;
	iface->set_nickname = tpf_persona_real_set_nickname;
}


static void tpf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	tpf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_phone_numbers = (void (*)(FolksPhoneDetails*, GeeSet*, GError**)) tpf_persona_real_change_phone_numbers;
	iface->change_phone_numbers_finish = tpf_persona_real_change_phone_numbers_finish;
	iface->get_phone_numbers = tpf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = tpf_persona_real_set_phone_numbers;
}


static void tpf_persona_folks_presence_details_interface_init (FolksPresenceDetailsIface * iface) {
	tpf_persona_folks_presence_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = tpf_persona_real_get_presence_type;
	iface->set_presence_type = tpf_persona_real_set_presence_type;
	iface->get_presence_status = tpf_persona_real_get_presence_status;
	iface->set_presence_status = tpf_persona_real_set_presence_status;
	iface->get_presence_message = tpf_persona_real_get_presence_message;
	iface->set_presence_message = tpf_persona_real_set_presence_message;
}


static void tpf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	tpf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_urls = (void (*)(FolksUrlDetails*, GeeSet*, GError**)) tpf_persona_real_change_urls;
	iface->change_urls_finish = tpf_persona_real_change_urls_finish;
	iface->get_urls = tpf_persona_real_get_urls;
	iface->set_urls = tpf_persona_real_set_urls;
}


static void tpf_persona_instance_init (TpfPersona * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashSet* _tmp3_;
	GWeakRef _tmp4_ = {0};
	self->priv = TPF_PERSONA_GET_PRIVATE (self);
	self->priv->_writeable_properties = NULL;
	self->priv->_is_constructed = FALSE;
	self->priv->_avatar = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	self->priv->_birthday = NULL;
	_tmp1_ = g_strdup ("");
	self->priv->_alias = _tmp1_;
	self->priv->_is_favourite = FALSE;
	self->priv->_email_addresses = NULL;
	self->priv->_email_addresses_ro = NULL;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp2_;
	self->priv->_im_interaction_count = (guint) 0;
	self->_last_im_interaction_datetime = NULL;
	self->priv->_call_interaction_count = (guint) 0;
	self->_last_call_interaction_datetime = NULL;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	self->priv->_groups = _tmp3_;
	g_weak_ref_init (&_tmp4_, NULL);
	self->priv->_contact = _tmp4_;
	self->priv->_phone_numbers = NULL;
	self->priv->_phone_numbers_ro = NULL;
	self->priv->_urls = NULL;
	self->priv->_urls_ro = NULL;
}


static void tpf_persona_finalize (GObject* obj) {
	TpfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GObject* _tmp2_ = NULL;
	TpContact* contact;
	TpContact* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TPF_TYPE_PERSONA, TpfPersona);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("tpf-persona.vala:1234: Destroying Tpf.Persona '%s': %p", _tmp1_, self);
	_tmp2_ = g_weak_ref_get (&self->priv->_contact);
	contact = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, tp_contact_get_type (), TpContact);
	_tmp3_ = contact;
	if (_tmp3_ != NULL) {
		TpContact* _tmp4_;
		_tmp4_ = contact;
		g_object_weak_unref ((GObject*) _tmp4_, __tpf_persona_contact_weak_notify_cb_gweak_notify, self);
	}
	_g_object_unref0 (contact);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_full_name);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_free0 (self->priv->_presence_status);
	_g_free0 (self->priv->_presence_message);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_date_time_unref0 (self->_last_im_interaction_datetime);
	_g_date_time_unref0 (self->_last_call_interaction_datetime);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_groups_ro);
	g_weak_ref_clear (&self->priv->_contact);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	G_OBJECT_CLASS (tpf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single instant messaging contact from
 * Telepathy.
 *
 * There is a one-to-one correspondence between {@link Tpf.Persona}s and
 * {@link TelepathyGLib.Contact}s, although at any time the
 * {@link Tpf.Persona.contact} property of a persona may be ``null`` if the
 * contact's Telepathy connection isn't available (e.g. due to being offline).
 * In this case, the persona's properties persist from a local cache.
 */
GType tpf_persona_get_type (void) {
	static volatile gsize tpf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersona), 0, (GInstanceInitFunc) tpf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) tpf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) tpf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) tpf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) tpf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) tpf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_group_details_info = { (GInterfaceInitFunc) tpf_persona_folks_group_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_interaction_details_info = { (GInterfaceInitFunc) tpf_persona_folks_interaction_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) tpf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) tpf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) tpf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_details_info = { (GInterfaceInitFunc) tpf_persona_folks_presence_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) tpf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tpf_persona_type_id;
		tpf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TpfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_GROUP_DETAILS, &folks_group_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_INTERACTION_DETAILS, &folks_interaction_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_PRESENCE_DETAILS, &folks_presence_details_info);
		g_type_add_interface_static (tpf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_once_init_leave (&tpf_persona_type_id__volatile, tpf_persona_type_id);
	}
	return tpf_persona_type_id__volatile;
}


static void _vala_tpf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA, TpfPersona);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		g_value_set_boolean (value, tpf_persona_get_is_in_contact_list (self));
		break;
		case TPF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_details_get_presence_type ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		g_value_set_string (value, folks_presence_details_get_presence_status ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_details_get_presence_message ((FolksPresenceDetails*) self));
		break;
		case TPF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case TPF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TPF_PERSONA_IM_INTERACTION_COUNT:
		g_value_set_uint (value, folks_interaction_details_get_im_interaction_count ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_LAST_IM_INTERACTION_DATETIME:
		g_value_set_boxed (value, folks_interaction_details_get_last_im_interaction_datetime ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_CALL_INTERACTION_COUNT:
		g_value_set_uint (value, folks_interaction_details_get_call_interaction_count ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_LAST_CALL_INTERACTION_DATETIME:
		g_value_set_boxed (value, folks_interaction_details_get_last_call_interaction_datetime ((FolksInteractionDetails*) self));
		break;
		case TPF_PERSONA_GROUPS:
		g_value_set_object (value, folks_group_details_get_groups ((FolksGroupDetails*) self));
		break;
		case TPF_PERSONA_CONTACT:
		g_value_set_object (value, tpf_persona_get_contact (self));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TPF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TPF_TYPE_PERSONA, TpfPersona);
	switch (property_id) {
		case TPF_PERSONA_IS_IN_CONTACT_LIST:
		tpf_persona_set_is_in_contact_list (self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TPF_PERSONA_PRESENCE_TYPE:
		folks_presence_details_set_presence_type ((FolksPresenceDetails*) self, g_value_get_enum (value));
		break;
		case TPF_PERSONA_PRESENCE_STATUS:
		folks_presence_details_set_presence_status ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_PRESENCE_MESSAGE:
		folks_presence_details_set_presence_message ((FolksPresenceDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case TPF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TPF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_GROUPS:
		folks_group_details_set_groups ((FolksGroupDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_CONTACT:
		tpf_persona_set_contact (self, g_value_get_object (value));
		break;
		case TPF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TPF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



