// -*- c++ -*-
// Generated by gmmproc 2.45.80 -- DO NOT MODIFY!
#ifndef _GTKMM_ENTRY_H
#define _GTKMM_ENTRY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>
#include <gtkmm/editable.h>
#include <gtkmm/menu.h>
#include <gtkmm/celleditable.h>
#include <gtkmm/entrycompletion.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/image.h> //For ImageType.
#include <gtkmm/border.h>
#include <gtkmm/entrybuffer.h>
#include <pangomm/attrlist.h>
#include <pangomm/tabarray.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEntry GtkEntry;
typedef struct _GtkEntryClass GtkEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Entry_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var EntryIconPosition ENTRY_ICON_PRIMARY
 * At the beginning of the entry (depending on the text direction).
 * 
 *  @var EntryIconPosition ENTRY_ICON_SECONDARY
 * At the end of the entry (depending on the text direction).
 * 
 *  @enum EntryIconPosition
 * 
 * Specifies the side of the entry at which an icon is placed.
 * 
 * @newin{2,16}
 *
 * @ingroup gtkmmEnums
 */
enum EntryIconPosition
{
  ENTRY_ICON_PRIMARY,
  ENTRY_ICON_SECONDARY
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::EntryIconPosition> : public Glib::Value_Enum<Gtk::EntryIconPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A single line text entry field.
 *
 * The Gtk::Entry widget is a single line text entry widget. A fairly large
 * set of key bindings are supported by default. If the entered text is
 * longer than the allocation of the widget, the widget will scroll so that
 * the cursor position is visible.
 *
 * The Entry widget looks like this:
 * @image html entry1.png
 *
 * @ingroup Widgets
 */

class Entry
: public Widget,
  public Editable,
  public CellEditable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Entry CppObjectType;
  typedef Entry_Class CppClassType;
  typedef GtkEntry BaseObjectType;
  typedef GtkEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Entry(Entry&& src) noexcept;
  Entry& operator=(Entry&& src) noexcept;

  virtual ~Entry() noexcept;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Entry_Class;
  static CppClassType entry_class_;

  // noncopyable
  Entry(const Entry&);
  Entry& operator=(const Entry&);

protected:
  explicit Entry(const Glib::ConstructParams& construct_params);
  explicit Entry(GtkEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkEntry*       gobj()       { return reinterpret_cast<GtkEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkEntry* gobj() const { return reinterpret_cast<GtkEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_populate_popup().
  virtual void on_populate_popup(Menu* menu);
  /// This is a default handler for the signal signal_insert_at_cursor().
  virtual void on_insert_at_cursor(const Glib::ustring& str);
  /// This is a default handler for the signal signal_activate().
  virtual void on_activate();


private:

  
public:

  Entry();
    explicit Entry(const Glib::RefPtr<EntryBuffer>& buffer);


  /** Get the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * 
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<EntryBuffer> get_buffer();
  
  /** Get the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * 
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<const EntryBuffer> get_buffer() const;

  /** Returns the area where the entry's text is drawn.
   * This function is useful when drawing something to the entry in a draw callback.
   *
   * See also get_icon_area().
   *
   * @result The location for the text area.
   *
   * @newin{3,0}
   **/
  Gdk::Rectangle get_text_area() const;
  

  /** Set the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * 
   * @param buffer A Gtk::EntryBuffer.
   */
  void set_buffer(const Glib::RefPtr<EntryBuffer>& buffer);
  
  /** Sets whether the contents of the entry are visible or not.
   * When visibility is set to <tt>false</tt>, characters are displayed
   * as the invisible char, and will also appear that way when
   * the text in the entry widget is copied elsewhere.
   * 
   * By default, GTK+ picks the best invisible character available
   * in the current font, but it can be changed with
   * set_invisible_char().
   * 
   * Note that you probably want to set Gtk::Entry::property_input_purpose()
   * to Gtk::INPUT_PURPOSE_PASSWORD or Gtk::INPUT_PURPOSE_PIN to
   * inform input methods about the purpose of this entry,
   * in addition to setting visibility to <tt>false</tt>.
   * 
   * @param visible <tt>true</tt> if the contents of the entry are displayed
   * as plaintext.
   */
  void set_visibility(bool visible =  true);
  
  /** Retrieves whether the text in @a entry is visible. See
   * set_visibility().
   * 
   * @return <tt>true</tt> if the text is currently visible.
   */
  bool get_visibility() const;
  
  /** Sets the character to use in place of the actual text when
   * set_visibility() has been called to set text visibility
   * to <tt>false</tt>. i.e. this is the character used in “password mode” to
   * show the user how many characters have been typed. By default, GTK+
   * picks the best invisible char available in the current font. If you
   * set the invisible char to 0, then the user will get no feedback
   * at all; there will be no text on the screen as they type.
   * 
   * @param ch A Unicode character.
   */
  void set_invisible_char(gunichar ch);
  
  /** Unsets the invisible char previously set with
   * set_invisible_char(). So that the
   * default invisible char is used again.
   * 
   * @newin{2,16}
   */
  void unset_invisible_char();
  
  /** Retrieves the character displayed in place of the real characters
   * for entries with visibility set to false. See set_invisible_char().
   * 
   * @return The current invisible char, or 0, if the entry does not
   * show invisible text at all.
   */
  gunichar get_invisible_char() const;
  
  /** Sets whether the entry has a beveled frame around it.
   * 
   * @param setting New value.
   */
  void set_has_frame(bool setting =  true);
  
  /** Gets the value set by set_has_frame().
   * 
   * @return Whether the entry has a beveled frame.
   */
  bool get_has_frame() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets %entry’s inner-border property to @a border, or clears it if <tt>0</tt>
   * is passed. The inner-border is the area around the entry’s text, but
   * inside its frame.
   * 
   * If set, this property overrides the inner-border style property.
   * Overriding the style-provided border is useful when you want to do
   * in-place editing of some text in a canvas or list widget, where
   * pixel-exact positioning of the entry is important.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 3.4: Use the standard border and padding CSS properties (through
   * objects like Gtk::StyleContext and Gtk::CssProvider); the value set with
   * this function is ignored by Gtk::Entry.
   * 
   * @deprecated Use the standard border and padding CSS properties instead (through classes like StyleContext and CssProvider).
   * 
   * @param border A Gtk::Border, or <tt>0</tt>.
   */
  void set_inner_border(const Border& border);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** This function returns the entry’s Gtk::Entry::property_inner_border() property. See
   * set_inner_border() for more information.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 3.4: Use the standard border and padding CSS properties (through
   * objects like Gtk::StyleContext and Gtk::CssProvider); the value returned by
   * this function is ignored by Gtk::Entry.
   * 
   * @deprecated Use the standard border and padding CSS properties instead (through classes like StyleContext and CssProvider).
   * 
   * @return The entry’s Gtk::Border, or
   * <tt>0</tt> if none was set.
   */
  Border get_inner_border() const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets whether the text is overwritten when typing in the Gtk::Entry.
   * 
   * @newin{2,14}
   * 
   * @param overwrite New value.
   */
  void set_overwrite_mode(bool overwrite =  true);
  
  /** Gets the value set by set_overwrite_mode().
   * 
   * @newin{2,14}
   * 
   * @return Whether the text is overwritten when typing.
   */
  bool get_overwrite_mode() const;
  
  /** Sets the maximum allowed length of the contents of the widget. If
   * the current contents are longer than the given length, then they
   * will be truncated to fit.
   * 
   * This is equivalent to:
   * 
   * 
   * [C example ellipted]
   * 
   * @param max The maximum length of the entry, or 0 for no maximum.
   * (other than the maximum length of entries.) The value passed in will
   * be clamped to the range 0-65536.
   */
  void set_max_length(int max);
  
  /** Retrieves the maximum allowed length of the text in
   *  @a entry. See set_max_length().
   * 
   * This is equivalent to:
   * 
   * 
   * [C example ellipted]
   * 
   * @return The maximum allowed number of characters
   * in Gtk::Entry, or 0 if there is no maximum.
   */
  int get_max_length() const;
  
  /** Retrieves the current length of the text in
   *  @a entry. 
   * 
   * This is equivalent to:
   * 
   * 
   * [C example ellipted]
   * 
   * @newin{2,14}
   * 
   * @return The current number of characters
   * in Gtk::Entry, or 0 if there are none.
   */
  guint16 get_text_length() const;
  
  /** If @a setting is <tt>true</tt>, pressing Enter in the @a entry will activate the default
   * widget for the window containing the entry. This usually means that
   * the dialog box containing the entry will be closed, since the default
   * widget is usually one of the dialog buttons.
   * 
   * (For experts: if @a setting is <tt>true</tt>, the entry calls
   * Gtk::Window::activate_default() on the window containing the entry, in
   * the default handler for the Gtk::Entry::signal_activate() signal.)
   * 
   * @param setting <tt>true</tt> to activate window’s default widget on Enter keypress.
   */
  void set_activates_default(bool setting =  true);
  
  /** Retrieves the value set by set_activates_default().
   * 
   * @return <tt>true</tt> if the entry will activate the default widget.
   */
  gboolean get_activates_default() const;
  
  /** Changes the size request of the entry to be about the right size
   * for @a n_chars characters. Note that it changes the size
   * request, the size can still be affected by
   * how you pack the widget into containers. If @a n_chars is -1, the
   * size reverts to the default entry size.
   * 
   * @param n_chars Width in chars.
   */
  void set_width_chars(int n_chars);
  
  /** Gets the value set by set_width_chars().
   * 
   * @return Number of chars to request space for, or negative if unset.
   */
  int get_width_chars() const;
  
  /** Sets the desired maximum width in characters of @a entry.
   * 
   * @newin{3,12}
   * 
   * @param n_chars The new desired maximum width, in characters.
   */
  void set_max_width_chars(int n_chars);
  
  /** Retrieves the desired maximum width of @a entry, in characters.
   * See set_max_width_chars().
   * 
   * @newin{3,12}
   * 
   * @return The maximum width of the entry, in characters.
   */
  int get_max_width_chars() const;
  
  /** Sets the text in the widget to the given
   * value, replacing the current contents.
   * 
   * See Gtk::EntryBuffer::set_text().
   * 
   * @param text The new text.
   */
  void set_text(const Glib::ustring & text);
  
  /** Retrieves the contents of the entry widget.
   * See also Gtk::Editable::get_chars().
   * 
   * @return The contents of the entry widget.
   */
  Glib::ustring get_text() const;
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the entry and must not be 
   * modified or freed by the caller.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * 
   * @return The Pango::Layout for this entry.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the entry and must not be 
   * modified or freed by the caller.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * 
   * @return The Pango::Layout for this entry.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;
  
  /** Obtains the position of the Pango::Layout used to render text
   * in the entry, in widget coordinates. Useful if you want to line
   * up the text in an entry with some other text, e.g. when using the
   * entry to implement editable cells in a sheet widget.
   * 
   * Also useful to convert mouse events into coordinates inside the
   * Pango::Layout, e.g. to take some action if some part of the entry text
   * is clicked.
   * 
   * Note that as the user scrolls around in the entry the offsets will
   * change; you’ll need to connect to the “notify::scroll-offset”
   * signal to track this. Remember when using the Pango::Layout
   * functions you need to convert to and from pixels using
   * PANGO_PIXELS() or Pango::SCALE.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * 
   * @param x Location to store X offset of layout, or <tt>0</tt>.
   * @param y Location to store Y offset of layout, or <tt>0</tt>.
   */
  void get_layout_offsets(int& x, int& y);

  
  /** Converts from a position in the entry contents (returned
   * by get_text()) to a position in the
   * entry’s Pango::Layout (returned by get_layout(),
   * with text retrieved via pango_layout_get_text()).
   * 
   * @param layout_index Byte index into the entry layout text.
   * @return Byte index into the entry contents.
   */
  int layout_index_to_text_index(int layout_index) const;
  
  /** Converts from a position in the entry’s Pango::Layout (returned by
   * get_layout()) to a position in the entry contents
   * (returned by get_text()).
   * 
   * @param text_index Byte index into the entry contents.
   * @return Byte index into the entry layout text.
   */
  int text_index_to_layout_index(int text_index) const;

  
  /** Hooks up an adjustment to the cursor position in an entry, so that when 
   * the cursor is moved, the adjustment is scrolled to show that position. 
   * See Gtk::ScrolledWindow::get_hadjustment() for a typical way of obtaining 
   * the adjustment.
   * 
   * The adjustment has to be in pixel units and in the same coordinate system 
   * as the entry. 
   * 
   * @newin{2,12}
   * 
   * @param adjustment An adjustment which should be adjusted when the cursor 
   * is moved, or <tt>0</tt>.
   */
  void set_cursor_hadjustment(const Glib::RefPtr<Adjustment>& adjustment);
  
  /** Retrieves the horizontal cursor adjustment for the entry. 
   * See set_cursor_hadjustment().
   * 
   * @newin{2,12}
   * 
   * @return The horizontal cursor adjustment, or <tt>0</tt>
   * if none has been set.
   */
  Glib::RefPtr<Adjustment> get_cursor_hadjustment();
  
  /** Retrieves the horizontal cursor adjustment for the entry. 
   * See set_cursor_hadjustment().
   * 
   * @newin{2,12}
   * 
   * @return The horizontal cursor adjustment, or <tt>0</tt>
   * if none has been set.
   */
  Glib::RefPtr<const Adjustment> get_cursor_hadjustment() const;

  
  /** Sets the alignment for the contents of the entry. This controls
   * the horizontal positioning of the contents when the displayed
   * text is shorter than the width of the entry.
   * 
   * @newin{2,4}
   * 
   * @param xalign The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   */
  void set_alignment(float xalign);
  
  /** Sets the alignment for the contents of the entry. This controls
   * the horizontal positioning of the contents when the displayed
   * text is shorter than the width of the entry.
   * 
   * @newin{2,4}
   * 
   * @param xalign The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   */
  void set_alignment(Align xalign);
  
  /** Gets the value set by set_alignment().
   * 
   * @newin{2,4}
   * 
   * @return The alignment.
   */
  float get_alignment() const;

  
  /** Sets @a completion to be the auxiliary completion object to use with @a entry.
   * All further configuration of the completion mechanism is done on
   *  @a completion using the Gtk::EntryCompletion API. Completion is disabled if
   *  @a completion is set to <tt>0</tt>.
   * 
   * @newin{2,4}
   * 
   * @param completion The Gtk::EntryCompletion or <tt>0</tt>.
   */
  void set_completion(const Glib::RefPtr<EntryCompletion>& completion);
  
  /** Returns the auxiliary completion object currently in use by @a entry.
   * 
   * @newin{2,4}
   * 
   * @return The auxiliary completion object currently
   * in use by @a entry.
   */
  Glib::RefPtr<EntryCompletion> get_completion();
  
  /** Returns the auxiliary completion object currently in use by @a entry.
   * 
   * @newin{2,4}
   * 
   * @return The auxiliary completion object currently
   * in use by @a entry.
   */
  Glib::RefPtr<const EntryCompletion> get_completion() const;

  
  /** Causes the entry’s progress indicator to “fill in” the given
   * fraction of the bar. The fraction should be between 0.0 and 1.0,
   * inclusive.
   * 
   * @newin{2,16}
   * 
   * @param fraction Fraction of the task that’s been completed.
   */
  void set_progress_fraction(double fraction);
  
  /** Returns the current fraction of the task that’s been completed.
   * See set_progress_fraction().
   * 
   * @newin{2,16}
   * 
   * @return A fraction from 0.0 to 1.0.
   */
  double get_progress_fraction() const;
  
  /** Sets the fraction of total entry width to move the progress
   * bouncing block for each call to progress_pulse().
   * 
   * @newin{2,16}
   * 
   * @param fraction Fraction between 0.0 and 1.0.
   */
  void set_progress_pulse_step(double fraction);
  
  /** Retrieves the pulse step set with set_progress_pulse_step().
   * 
   * @newin{2,16}
   * 
   * @return A fraction from 0.0 to 1.0.
   */
  double get_progress_pulse_step();
  
  /** Indicates that some progress is made, but you don’t know how much.
   * Causes the entry’s progress indicator to enter “activity mode,”
   * where a block bounces back and forth. Each call to
   * progress_pulse() causes the block to move by a little bit
   * (the amount of movement per pulse is determined by
   * set_progress_pulse_step()).
   * 
   * @newin{2,16}
   */
  void progress_pulse();

  
  /** Retrieves the text that will be displayed when @a entry is empty and unfocused
   * 
   * @newin{3,2}
   * 
   * @return A pointer to the placeholder text as a string. This string points to internally allocated
   * storage in the widget and must not be freed, modified or stored.
   */
  Glib::ustring get_placeholder_text() const;
  
  /** Sets text to be displayed in @a entry when it is empty and unfocused.
   * This can be used to give a visual hint of the expected contents of
   * the Gtk::Entry.
   * 
   * Note that since the placeholder text gets removed when the entry
   * received focus, using this feature is a bit problematic if the entry
   * is given the initial focus in a window. Sometimes this can be
   * worked around by delaying the initial focus setting until the
   * first key event arrives.
   * 
   * @newin{3,2}
   * 
   * @param text A string to be displayed when @a entry is empty an unfocused, or <tt>0</tt>.
   */
  void set_placeholder_text(const Glib::ustring& text);

  //We hand-code these so we can change the parameter order, so we can have a default parameter value:
  
  /** Sets the icon shown in the specified position using a pixbuf.
   * 
   * If @a pixbuf is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @param pixbuf A Gdk::Pixbuf, or <tt>0</tt>.
   */

  void set_icon_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the icon shown in the entry at the specified position from
   * a stock image.
   * 
   * If @a stock_id is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use set_icon_from_icon_name() instead.
   * 
   * @deprecated Use set_icon_from_icon_name() instead.
   * 
   * @param icon_pos Icon position.
   * @param stock_id The name of the stock item, or <tt>0</tt>.
   */
  void set_icon_from_stock(const StockID& stock_id, EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the icon shown in the entry at the specified position
   * from the current icon theme.
   * 
   * If the icon name isn’t known, a “broken image” icon will be displayed
   * instead.
   * 
   * If @a icon_name is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The position at which to set the icon.
   * @param icon_name An icon name, or <tt>0</tt>.
   */

  void set_icon_from_icon_name(const Glib::ustring& icon_name, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Sets the icon shown in the entry at the specified position
   * from the current icon theme.
   * If the icon isn’t known, a “broken image” icon will be displayed
   * instead.
   * 
   * If @a icon is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The position at which to set the icon.
   * @param icon The icon to set, or <tt>0</tt>.
   */

  void set_icon_from_gicon(const Glib::RefPtr<Gio::Icon>& icon, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Do not show any icon in the specified position.
   * See set_icon_from_pixbuf(), set_icon_from_stock(), set_icon_from_icon_name(),
   * and set_icon_from_gicon().
   *
   * @param icon_pos The icon position.
   *
   * @newin{3,0}
   */
  void unset_icon(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);

  
  /** Gets the type of representation being used by the icon
   * to store image data. If the icon has no image data,
   * the return value will be Gtk::IMAGE_EMPTY.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return Image representation being used.
   */
  ImageType get_icon_storage_type(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the image used for the icon.
   * 
   * Unlike the other methods of setting and getting icon data, this
   * method will work regardless of whether the icon was set using a
   * Gdk::Pixbuf, a Icon, a stock item, or an icon name.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return A Gdk::Pixbuf, or <tt>0</tt> if no icon is
   * set for this position.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_icon_pixbuf(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY);
  
  /** Retrieves the image used for the icon.
   * 
   * Unlike the other methods of setting and getting icon data, this
   * method will work regardless of whether the icon was set using a
   * Gdk::Pixbuf, a Icon, a stock item, or an icon name.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return A Gdk::Pixbuf, or <tt>0</tt> if no icon is
   * set for this position.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_icon_pixbuf(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Retrieves the stock id used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * pixbuf, icon name or gicon).
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use get_icon_name() instead.
   * 
   * @deprecated Use get_icon_name() instead.
   * 
   * @param icon_pos Icon position.
   * @return A stock id, or <tt>0</tt> if no icon is set or if the icon
   * wasn’t set from a stock id.
   */
  StockID get_icon_stock(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Retrieves the icon name used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * pixbuf, stock or gicon).
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return An icon name, or <tt>0</tt> if no icon is set or if the icon
   * wasn’t set from an icon name.
   */
  Glib::ustring get_icon_name(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the Icon used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * stock, pixbuf, or icon name).
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return A Icon, or <tt>0</tt> if no icon is set
   * or if the icon is not a Icon.
   */
  Glib::RefPtr<Gio::Icon> get_icon_gicon(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY);
  
  /** Retrieves the Icon used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * stock, pixbuf, or icon name).
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return A Icon, or <tt>0</tt> if no icon is set
   * or if the icon is not a Icon.
   */
  Glib::RefPtr<const Gio::Icon> get_icon_gicon(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;

  
  /** Sets whether the icon is activatable.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @param activatable <tt>true</tt> if the icon should be activatable.
   */

  void set_icon_activatable(bool activatable = true, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Returns whether the icon is activatable.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return <tt>true</tt> if the icon is activatable.
   */
  bool get_icon_activatable(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;
  
  /** Sets the sensitivity for the specified icon.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @param sensitive Specifies whether the icon should appear
   * sensitive or insensitive.
   */
  void set_icon_sensitive(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY, bool sensitive =  true);
  
  /** Returns whether the icon appears sensitive or insensitive.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @return <tt>true</tt> if the icon is sensitive.
   */
  bool get_icon_sensitive(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY);
  
  /** Finds the icon at the given position and return its index. The
   * position’s coordinates are relative to the @a entry’s top left corner.
   * If @a x, @a y doesn’t lie inside an icon, -1 is returned.
   * This function is intended for use in a Gtk::Widget::signal_query_tooltip()
   * signal handler.
   * 
   * @newin{2,16}
   * 
   * @param x The x coordinate of the position to find.
   * @param y The y coordinate of the position to find.
   * @return The index of the icon at the given position, or -1.
   */
  int get_icon_at_pos(int x, int y) const;

  
  /** Sets @a tooltip as the contents of the tooltip for the icon
   * at the specified position.
   * 
   * Use <tt>0</tt> for @a tooltip to remove an existing tooltip.
   * 
   * See also Gtk::Widget::set_tooltip_text() and 
   * set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The icon position.
   * @param tooltip The contents of the tooltip for the icon, or <tt>0</tt>.
   */

  void set_icon_tooltip_text(const Glib::ustring& tooltip, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Gets the contents of the tooltip on the icon at the specified 
   * position in @a entry.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The icon position.
   * @return The tooltip text, or <tt>0</tt>. Free the returned
   * string with Glib::free() when done.
   */
  Glib::ustring get_icon_tooltip_text(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;

  
  /** Sets @a tooltip as the contents of the tooltip for the icon at
   * the specified position. @a tooltip is assumed to be marked up with
   * the [Pango text markup language][PangoMarkupFormat].
   * 
   * Use <tt>0</tt> for @a tooltip to remove an existing tooltip.
   * 
   * See also Gtk::Widget::set_tooltip_markup() and 
   * set_icon_tooltip_text().
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The icon position.
   * @param tooltip The contents of the tooltip for the icon, or <tt>0</tt>.
   */

  void set_icon_tooltip_markup(const Glib::ustring& tooltip, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Gets the contents of the tooltip on the icon at the specified 
   * position in @a entry.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos The icon position.
   * @return The tooltip text, or <tt>0</tt>. Free the returned
   * string with Glib::free() when done.
   */
  Glib::ustring get_icon_tooltip_markup(EntryIconPosition icon_pos =  ENTRY_ICON_PRIMARY) const;

  
  /** Sets up the icon at the given position so that GTK+ will start a drag
   * operation when the user clicks and drags the icon.
   * 
   * To handle the drag operation, you need to connect to the usual
   * Gtk::Widget::signal_drag_data_get() (or possibly Gtk::Widget::signal_drag_data_delete())
   * signal, and use get_current_icon_drag_source() in
   * your signal handler to find out if the drag was started from
   * an icon.
   * 
   * By default, GTK+ uses the icon as the drag icon. You can use the 
   * Gtk::Widget::signal_drag_begin() signal to set a different icon. Note that you 
   * have to use Glib::signal_connect_after() to ensure that your signal handler
   * gets executed after the default handler.
   * 
   * @newin{2,16}
   * 
   * @param icon_pos Icon position.
   * @param target_list The targets (data formats) in which the data can be provided.
   * @param actions A bitmask of the allowed drag actions.
   */

  void set_icon_drag_source(const Glib::RefPtr<TargetList>& target_list, Gdk::DragAction actions = Gdk::ACTION_COPY, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Returns the area where entry's icon at @a icon_pos is drawn.
   * This function is useful when drawing something to the
   * entry in a draw callback.
   *
   * See also get_text_area().
   *
   * @param icon_pos Icon position.
   * @result The location for the icon area.
   *
   * @newin{3,0}
   */
  Gdk::Rectangle get_icon_area(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  

  /** Returns the index of the icon which is the source of the current
   * DND operation, or -1.
   * 
   * This function is meant to be used in a Gtk::Widget::signal_drag_data_get()
   * callback.
   * 
   * @newin{2,16}
   * 
   * @return Index of the icon which is the source of the current
   * DND operation, or -1.
   */
  int get_current_icon_drag_source();
  
  /** Allow the Gtk::Entry input method to internally handle key press
   * and release events. If this function returns <tt>true</tt>, then no further
   * processing should be done for this key event. See
   * gtk_im_context_filter_keypress().
   * 
   * Note that you are expected to call this function from your handler
   * when overriding key event handling. This is needed in the case when
   * you need to insert your own key handling between the input method
   * and the default key event handling of the Gtk::Entry.
   * See Gtk::TextView::reset_im_context() for an example of use.
   * 
   * @newin{2,22}
   * 
   * @param gdk_event The key event.
   * @return <tt>true</tt> if the input method handled the key event.
   */
  bool im_context_filter_keypress(GdkEventKey* gdk_event);
  
  /** Reset the input method context of the entry if needed.
   * 
   * This can be necessary in the case where modifying the buffer
   * would confuse on-going input method behavior.
   * 
   * @newin{2,22}
   */
  void reset_im_context();

  
  /** Sets the Gtk::Entry::property_input_purpose() property which
   * can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * @newin{3,6}
   * 
   * @param purpose The purpose.
   */
  void set_input_purpose(InputPurpose purpose);
  
  /** Gets the value of the Gtk::Entry::property_input_purpose() property.
   * 
   * @newin{3,6}
   */
  InputPurpose get_input_purpose() const;

  
  /** Sets the Gtk::Entry::property_input_hints() property, which
   * allows input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   * 
   * @param hints The hints.
   */
  void set_input_hints(InputHints hints);
  
  /** Gets the value of the Gtk::Entry::property_input_hints() property.
   * 
   * @newin{3,6}
   */
  InputHints get_input_hints() const;

  
  /** Sets a Pango::AttrList; the attributes in the list are applied to the
   * entry text.
   * 
   * @newin{3,6}
   * 
   * @param attrs A Pango::AttrList.
   */
  void set_attributes(Pango::AttrList& attrs);
  
  /** Gets the attribute list that was set on the entry using
   * set_attributes(), if any.
   * 
   * @newin{3,6}
   * 
   * @return The attribute list, or <tt>0</tt>
   * if none was set.
   */
  Pango::AttrList get_attributes() const;

 
  /** Sets a Pango::TabArray; the tabstops in the array are applied to the entry
   * text.
   * 
   * @newin{3,10}
   * 
   * @param tabs A Pango::TabArray.
   */
  void set_tabs(const Pango::TabArray& tabs);
  
  /** Gets the tabstops that were set on the entry using set_tabs(), if
   * any.
   * 
   * @newin{3,10}
   * 
   * @return The tabstops, or <tt>0</tt> if none was set.
   */
  Pango::TabArray get_tabs() const;

  
  /** Causes @a entry to have keyboard focus.
   * 
   * It behaves like Gtk::Widget::grab_focus(),
   * except that it doesn't select the contents of the entry.
   * You only want to call this on some special entries
   * which the user usually doesn't want to replace all text in,
   * such as search-as-you-type entries.
   * 
   * @newin{3,16}
   */
  void grab_focus_without_selecting();

  //TODO: This signal now takes a GtkWidget* instead of just a GtkMenu*,
  //so change that when we can break ABI.
  //See https://git.gnome.org/browse/gtk+/commit/?id=88623b98a7ca0afca08ac21bc3aa662c6ed3ab7f
 

  /**
   * @par Slot Prototype:
   * <tt>void on_my_%populate_popup(Menu* menu)</tt>
   *
   * The signal_populate_popup() signal gets emitted before showing the
   * context menu of the entry.
   * 
   * If you need to add items to the context menu, connect
   * to this signal and append your items to the @a widget, which
   * will be a Gtk::Menu in this case.
   * 
   * If Gtk::Entry::property_populate_all() is <tt>true</tt>, this signal will
   * also be emitted to populate touch popups. In this case,
   *  @a widget will be a different container, e.g. a Gtk::Toolbar.
   * The signal handler should not make assumptions about the
   * type of @a widget.
   * 
   * @param menu The container that is being populated.
   */

  Glib::SignalProxy1< void,Menu* > signal_populate_popup();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%insert_at_cursor(const Glib::ustring& str)</tt>
   *
   * The signal_insert_at_cursor() signal is a
   * [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user initiates the insertion of a
   * fixed string at the cursor.
   * 
   * This signal has no default bindings.
   * 
   * @param str The string to insert.
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_insert_at_cursor();


  //Note that the GTK+ C documentation for the activate signal says (as of 2012-06) that it should be used by applications even though it is a keybinding signal.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%activate()</tt>
   *
   * The signal_activate() signal is emitted when the user hits
   * the Enter key.
   * 
   * While this signal is used as a
   * [keybinding signal][GtkBindingSignal],
   * it is also commonly used by applications to intercept
   * activation of entries.
   * 
   * The default bindings for this signal are all forms of the Enter key.
   */

  Glib::SignalProxy0< void > signal_activate();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%icon_release(EntryIconPosition icon_position, const GdkEventButton* event)</tt>
   *
   * The signal_icon_release() signal is emitted on the button release from a
   * mouse click over an activatable icon.
   * 
   * @newin{2,16}
   * 
   * @param icon_position The position of the clicked icon.
   * @param event The button release event.
   */

  Glib::SignalProxy2< void,EntryIconPosition,const GdkEventButton* > signal_icon_release();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%icon_press(EntryIconPosition icon_position, const GdkEventButton* event)</tt>
   *
   * The signal_icon_press() signal is emitted when an activatable icon
   * is clicked.
   * 
   * @newin{2,16}
   * 
   * @param icon_position The position of the clicked icon.
   * @param event The button press event.
   */

  Glib::SignalProxy2< void,EntryIconPosition,const GdkEventButton* > signal_icon_press();


  /** Text buffer object which actually stores entry text.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<EntryBuffer> > property_buffer() ;

/** Text buffer object which actually stores entry text.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryBuffer> > property_buffer() const;

  /** The current position of the insertion cursor in chars.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_cursor_position() const;


  /** The position of the opposite end of the selection from the cursor in chars.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_selection_bound() const;


  /** Whether the entry contents can be edited.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_editable() ;

/** Whether the entry contents can be edited.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_editable() const;

  /** Maximum number of characters for this entry. Zero if no maximum.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_max_length() ;

/** Maximum number of characters for this entry. Zero if no maximum.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_length() const;

  /** FALSE displays the 'invisible char' instead of the actual text (password mode).
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_visibility() ;

/** FALSE displays the 'invisible char' instead of the actual text (password mode).
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_visibility() const;

  /** FALSE removes outside bevel from entry.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_frame() ;

/** FALSE removes outside bevel from entry.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_frame() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** Sets the text area's border between the text and the frame.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 3.4: Use the standard border and padding CSS properties
   * (through objects like Gtk::StyleContext and Gtk::CssProvider); the value
   * of this style property is ignored.
   * 
   * @deprecated Use the standard border and padding CSS properties (through objects like StyleContext and CssProvider); the value of this style property is ignored.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Border > property_inner_border() ;

/** Sets the text area's border between the text and the frame.
   * 
   * @newin{2,10}
   * 
   * Deprecated: 3.4: Use the standard border and padding CSS properties
   * (through objects like Gtk::StyleContext and Gtk::CssProvider); the value
   * of this style property is ignored.
   * 
   * @deprecated Use the standard border and padding CSS properties (through objects like StyleContext and CssProvider); the value of this style property is ignored.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Border > property_inner_border() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** The invisible character is used when masking entry contents (in
   * \\"password mode\\")"). When it is not explicitly set with the
   * Gtk::Entry::property_invisible_char() property, GTK+ determines the character
   * to use from a list of possible candidates, depending on availability
   * in the current font.
   * 
   * This style property allows the theme to prepend a character
   * to the list of candidates.
   * 
   * @newin{2,18}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gunichar > property_invisible_char() ;

/** The invisible character is used when masking entry contents (in
   * \\"password mode\\")"). When it is not explicitly set with the
   * Gtk::Entry::property_invisible_char() property, GTK+ determines the character
   * to use from a list of possible candidates, depending on availability
   * in the current font.
   * 
   * This style property allows the theme to prepend a character
   * to the list of candidates.
   * 
   * @newin{2,18}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gunichar > property_invisible_char() const;

  /** Whether the invisible char has been set for the Gtk::Entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_invisible_char_set() ;

/** Whether the invisible char has been set for the Gtk::Entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_invisible_char_set() const;

  /** Whether to activate the default widget (such as the default button in a dialog) when Enter is pressed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_activates_default() ;

/** Whether to activate the default widget (such as the default button in a dialog) when Enter is pressed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_activates_default() const;

  /** Number of characters to leave space for in the entry.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width_chars() ;

/** Number of characters to leave space for in the entry.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width_chars() const;

  /** The desired maximum width of the entry, in characters.
   * If this property is set to -1, the width will be calculated
   * automatically.
   * 
   * @newin{3,12}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_max_width_chars() ;

/** The desired maximum width of the entry, in characters.
   * If this property is set to -1, the width will be calculated
   * automatically.
   * 
   * @newin{3,12}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_max_width_chars() const;

  /** Number of pixels of the entry scrolled off the screen to the left.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_scroll_offset() const;


  /** Which kind of shadow to draw around the entry when
   * Gtk::Entry::property_has_frame() is set to <tt>true</tt>.
   * 
   * @newin{2,12}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ShadowType > property_shadow_type() ;

/** Which kind of shadow to draw around the entry when
   * Gtk::Entry::property_has_frame() is set to <tt>true</tt>.
   * 
   * @newin{2,12}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ShadowType > property_shadow_type() const;

  /** The contents of the entry.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_text() ;

/** The contents of the entry.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_text() const;

  /** The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< float > property_xalign() ;

/** The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   * 
   * @newin{2,4}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< float > property_xalign() const;

  /** When <tt>true</tt>, pasted multi-line text is truncated to the first line.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_truncate_multiline() ;

/** When <tt>true</tt>, pasted multi-line text is truncated to the first line.
   * 
   * @newin{2,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_truncate_multiline() const;

  /** If text is overwritten when typing in the Gtk::Entry.
   * 
   * @newin{2,14}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_overwrite_mode() ;

/** If text is overwritten when typing in the Gtk::Entry.
   * 
   * @newin{2,14}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_overwrite_mode() const;

  /** The length of the text in the Gtk::Entry.
   * 
   * @newin{2,14}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint > property_text_length() const;


  /** Whether password entries will show a warning when Caps Lock is on.
   * 
   * Note that the warning is shown using a secondary icon, and thus
   * does not work if you are using the secondary icon position for some
   * other purpose.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_caps_lock_warning() ;

/** Whether password entries will show a warning when Caps Lock is on.
   * 
   * Note that the warning is shown using a secondary icon, and thus
   * does not work if you are using the secondary icon position for some
   * other purpose.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_caps_lock_warning() const;

  /** The current fraction of the task that's been completed.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_progress_fraction() ;

/** The current fraction of the task that's been completed.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_progress_fraction() const;

  /** The fraction of total entry width to move the progress
   * bouncing block for each call to Gtk::Entry::progress_pulse().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_progress_pulse_step() ;

/** The fraction of total entry width to move the progress
   * bouncing block for each call to Gtk::Entry::progress_pulse().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_progress_pulse_step() const;

  /** A pixbuf to use as the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_primary_icon_pixbuf() ;

/** A pixbuf to use as the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_primary_icon_pixbuf() const;

  /** An pixbuf to use as the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_secondary_icon_pixbuf() ;

/** An pixbuf to use as the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_secondary_icon_pixbuf() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** The stock id to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use Gtk::Entry::property_primary_icon_name() instead.
   * 
   * @deprecated Use property_primary_icon_name() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< StockID > property_primary_icon_stock() ;

/** The stock id to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use Gtk::Entry::property_primary_icon_name() instead.
   * 
   * @deprecated Use property_primary_icon_name() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< StockID > property_primary_icon_stock() const;

#endif // GTKMM_DISABLE_DEPRECATED

  
#ifndef GTKMM_DISABLE_DEPRECATED

/** The stock id to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use Gtk::Entry::property_secondary_icon_name() instead.
   * 
   * @deprecated Use property_secondary_icon_name() instead.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< StockID > property_secondary_icon_stock() ;

/** The stock id to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   * 
   * Deprecated: 3.10: Use Gtk::Entry::property_secondary_icon_name() instead.
   * 
   * @deprecated Use property_secondary_icon_name() instead.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< StockID > property_secondary_icon_stock() const;

#endif // GTKMM_DISABLE_DEPRECATED

  /** The icon name to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_primary_icon_name() ;

/** The icon name to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_primary_icon_name() const;

  /** The icon name to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_secondary_icon_name() ;

/** The icon name to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_secondary_icon_name() const;

  /** The Icon to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_primary_icon_gicon() ;

/** The Icon to use for the primary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_primary_icon_gicon() const;

  /** The Icon to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_secondary_icon_gicon() ;

/** The Icon to use for the secondary icon for the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_secondary_icon_gicon() const;

  /** The representation which is used for the primary icon of the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ImageType > property_primary_icon_storage_type() const;


  /** The representation which is used for the secondary icon of the entry.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ImageType > property_secondary_icon_storage_type() const;


  /** Whether the primary icon is activatable.
   * 
   * GTK+ emits the Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release()
   * signals only on sensitive, activatable icons.
   * 
   * Sensitive, but non-activatable icons can be used for purely
   * informational purposes.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_primary_icon_activatable() ;

/** Whether the primary icon is activatable.
   * 
   * GTK+ emits the Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release()
   * signals only on sensitive, activatable icons.
   * 
   * Sensitive, but non-activatable icons can be used for purely
   * informational purposes.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_primary_icon_activatable() const;

  /** Whether the secondary icon is activatable.
   * 
   * GTK+ emits the Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release()
   * signals only on sensitive, activatable icons.
   * 
   * Sensitive, but non-activatable icons can be used for purely
   * informational purposes.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_secondary_icon_activatable() ;

/** Whether the secondary icon is activatable.
   * 
   * GTK+ emits the Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release()
   * signals only on sensitive, activatable icons.
   * 
   * Sensitive, but non-activatable icons can be used for purely
   * informational purposes.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_secondary_icon_activatable() const;

  /** Whether the primary icon is sensitive.
   * 
   * An insensitive icon appears grayed out. GTK+ does not emit the
   * Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release() signals and
   * does not allow DND from insensitive icons.
   * 
   * An icon should be set insensitive if the action that would trigger
   * when clicked is currently not available.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_primary_icon_sensitive() ;

/** Whether the primary icon is sensitive.
   * 
   * An insensitive icon appears grayed out. GTK+ does not emit the
   * Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release() signals and
   * does not allow DND from insensitive icons.
   * 
   * An icon should be set insensitive if the action that would trigger
   * when clicked is currently not available.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_primary_icon_sensitive() const;

  /** Whether the secondary icon is sensitive.
   * 
   * An insensitive icon appears grayed out. GTK+ does not emit the
   * Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release() signals and
   * does not allow DND from insensitive icons.
   * 
   * An icon should be set insensitive if the action that would trigger
   * when clicked is currently not available.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_secondary_icon_sensitive() ;

/** Whether the secondary icon is sensitive.
   * 
   * An insensitive icon appears grayed out. GTK+ does not emit the
   * Gtk::Entry::signal_icon_press() and Gtk::Entry::signal_icon_release() signals and
   * does not allow DND from insensitive icons.
   * 
   * An icon should be set insensitive if the action that would trigger
   * when clicked is currently not available.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_secondary_icon_sensitive() const;

  /** The contents of the tooltip on the primary icon.
   * 
   * Also see Gtk::Entry::set_icon_tooltip_text().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_primary_icon_tooltip_text() ;

/** The contents of the tooltip on the primary icon.
   * 
   * Also see Gtk::Entry::set_icon_tooltip_text().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_primary_icon_tooltip_text() const;

  /** The contents of the tooltip on the secondary icon.
   * 
   * Also see Gtk::Entry::set_icon_tooltip_text().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_secondary_icon_tooltip_text() ;

/** The contents of the tooltip on the secondary icon.
   * 
   * Also see Gtk::Entry::set_icon_tooltip_text().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_secondary_icon_tooltip_text() const;

  /** The contents of the tooltip on the primary icon, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * 
   * Also see Gtk::Entry::set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_primary_icon_tooltip_markup() ;

/** The contents of the tooltip on the primary icon, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * 
   * Also see Gtk::Entry::set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_primary_icon_tooltip_markup() const;

  /** The contents of the tooltip on the secondary icon, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * 
   * Also see Gtk::Entry::set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_secondary_icon_tooltip_markup() ;

/** The contents of the tooltip on the secondary icon, which is marked up
   * with the [Pango text markup language][PangoMarkupFormat].
   * 
   * Also see Gtk::Entry::set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_secondary_icon_tooltip_markup() const;

  /** Which IM (input method) module should be used for this entry.
   * See Gtk::IMContext.
   * 
   * Setting this to a non-<tt>0</tt> value overrides the
   * system-wide IM module setting. See the GtkSettings
   * Gtk::Settings::property_gtk_im_module() property.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_im_module() ;

/** Which IM (input method) module should be used for this entry.
   * See Gtk::IMContext.
   * 
   * Setting this to a non-<tt>0</tt> value overrides the
   * system-wide IM module setting. See the GtkSettings
   * Gtk::Settings::property_gtk_im_module() property.
   * 
   * @newin{2,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_im_module() const;

  /** The text that will be displayed in the Gtk::Entry when it is empty
   * and unfocused.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_placeholder_text() ;

/** The text that will be displayed in the Gtk::Entry when it is empty
   * and unfocused.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_placeholder_text() const;

  /** The auxiliary completion object to use with the entry.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<EntryCompletion> > property_completion() ;

/** The auxiliary completion object to use with the entry.
   * 
   * @newin{3,2}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryCompletion> > property_completion() const;

  /** The purpose of this text field.
   * 
   * This property can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * Note that setting the purpose to Gtk::INPUT_PURPOSE_PASSWORD or
   * Gtk::INPUT_PURPOSE_PIN is independent from setting
   * Gtk::Entry::property_visibility().
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputPurpose > property_input_purpose() ;

/** The purpose of this text field.
   * 
   * This property can be used by on-screen keyboards and other input
   * methods to adjust their behaviour.
   * 
   * Note that setting the purpose to Gtk::INPUT_PURPOSE_PASSWORD or
   * Gtk::INPUT_PURPOSE_PIN is independent from setting
   * Gtk::Entry::property_visibility().
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputPurpose > property_input_purpose() const;

  /** Additional hints (beyond Gtk::Entry::property_input_purpose()) that
   * allow input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< InputHints > property_input_hints() ;

/** Additional hints (beyond Gtk::Entry::property_input_purpose()) that
   * allow input methods to fine-tune their behaviour.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< InputHints > property_input_hints() const;

  /** A list of Pango attributes to apply to the text of the entry.
   * 
   * This is mainly useful to change the size or weight of the text.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::AttrList > property_attributes() ;

/** A list of Pango attributes to apply to the text of the entry.
   * 
   * This is mainly useful to change the size or weight of the text.
   * 
   * @newin{3,6}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::AttrList > property_attributes() const;

  /** If :populate-all is <tt>true</tt>, the Gtk::Entry::signal_populate_popup()
   * signal is also emitted for touch popups.
   * 
   * @newin{3,8}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_populate_all() ;

/** If :populate-all is <tt>true</tt>, the Gtk::Entry::signal_populate_popup()
   * signal is also emitted for touch popups.
   * 
   * @newin{3,8}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_populate_all() const;

  /** A list of tabstop locations to apply to the text of the entry.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Pango::TabArray > property_tabs() ;

/** A list of tabstop locations to apply to the text of the entry.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Pango::TabArray > property_tabs() const;


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Entry
   */
  Gtk::Entry* wrap(GtkEntry* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_ENTRY_H */

