/* math-equation.c generated by valac 0.29.1.2-108a0, the Vala compiler
 * generated from math-equation.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <langinfo.h>
#include <gdk/gdk.h>


#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_MATH_EQUATION_STATE (math_equation_state_get_type ())
#define MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION_STATE, MathEquationState))
#define MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))
#define IS_MATH_EQUATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION_STATE))
#define IS_MATH_EQUATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION_STATE))
#define MATH_EQUATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION_STATE, MathEquationStateClass))

typedef struct _MathEquationState MathEquationState;
typedef struct _MathEquationStateClass MathEquationStateClass;
typedef struct _MathEquationStatePrivate MathEquationStatePrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SOLVE_DATA (solve_data_get_type ())
#define SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_DATA, SolveData))
#define SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_DATA, SolveDataClass))
#define IS_SOLVE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_DATA))
#define IS_SOLVE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_DATA))
#define SOLVE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_DATA, SolveDataClass))

typedef struct _SolveData SolveData;
typedef struct _SolveDataClass SolveDataClass;
typedef struct _SolveDataPrivate SolveDataPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
typedef struct _MathEquationPrivate MathEquationPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_MATH_VARIABLES (math_variables_get_type ())
#define MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLES, MathVariables))
#define MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLES, MathVariablesClass))
#define IS_MATH_VARIABLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLES))
#define IS_MATH_VARIABLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLES))
#define MATH_VARIABLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLES, MathVariablesClass))

typedef struct _MathVariables MathVariables;
typedef struct _MathVariablesClass MathVariablesClass;

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;

#define TYPE_MEQUATION (mequation_get_type ())
#define MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEQUATION, MEquation))
#define MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEQUATION, MEquationClass))
#define IS_MEQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEQUATION))
#define IS_MEQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEQUATION))
#define MEQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEQUATION, MEquationClass))

typedef struct _MEquation MEquation;
typedef struct _MEquationClass MEquationClass;
typedef struct _EquationPrivate EquationPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _MEquationPrivate MEquationPrivate;

#define TYPE_UNIT_MANAGER (unit_manager_get_type ())
#define UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT_MANAGER, UnitManager))
#define UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT_MANAGER, UnitManagerClass))
#define IS_UNIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT_MANAGER))
#define IS_UNIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT_MANAGER))
#define UNIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT_MANAGER, UnitManagerClass))

typedef struct _UnitManager UnitManager;
typedef struct _UnitManagerClass UnitManagerClass;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;

struct _MathEquationState {
	GObject parent_instance;
	MathEquationStatePrivate * priv;
	Number* ans;
	guint ans_base;
	gchar* expression;
	gint ans_start;
	gint ans_end;
	gint cursor;
	NumberMode number_mode;
	gboolean can_super_minus;
	gboolean entered_multiply;
	gchar* status;
	guint error_token_start;
	guint error_token_end;
};

struct _MathEquationStateClass {
	GObjectClass parent_class;
};

struct _SolveData {
	GObject parent_instance;
	SolveDataPrivate * priv;
	Number* number_result;
	gchar* text_result;
	gchar* error;
	guint error_start;
	guint error_end;
	guint representation_base;
};

struct _SolveDataClass {
	GObjectClass parent_class;
};

struct _MathEquation {
	GtkSourceBuffer parent_instance;
	MathEquationPrivate * priv;
};

struct _MathEquationClass {
	GtkSourceBufferClass parent_class;
};

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _MathEquationPrivate {
	GtkTextTag* ans_tag;
	gint _word_size;
	gchar* _source_currency;
	gchar* _target_currency;
	gchar* _source_units;
	gchar* _target_units;
	AngleUnit _angle_units;
	NumberMode _number_mode;
	gboolean can_super_minus;
	gunichar digits[16];
	GtkTextMark* ans_start_mark;
	GtkTextMark* ans_end_mark;
	MathEquationState* state;
	GList* undo_stack;
	GList* redo_stack;
	gboolean in_undo_operation;
	gboolean in_reformat;
	gboolean in_delete;
	gboolean _in_solve;
	MathVariables* _variables;
	Serializer* _serializer;
	GAsyncQueue* queue;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

struct _Equation {
	GObject parent_instance;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GObjectClass parent_class;
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _MEquation {
	Equation parent_instance;
	MEquationPrivate * priv;
};

struct _MEquationClass {
	EquationClass parent_class;
};

struct _MEquationPrivate {
	MathEquation* m_equation;
};


static gpointer math_equation_state_parent_class = NULL;
static gpointer solve_data_parent_class = NULL;
static gpointer math_equation_parent_class = NULL;
static gpointer mequation_parent_class = NULL;

GType number_mode_get_type (void) G_GNUC_CONST;
GType math_equation_state_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
enum  {
	MATH_EQUATION_STATE_DUMMY_PROPERTY
};
MathEquationState* math_equation_state_new (void);
MathEquationState* math_equation_state_construct (GType object_type);
static void math_equation_state_finalize (GObject* obj);
GType solve_data_get_type (void) G_GNUC_CONST;
enum  {
	SOLVE_DATA_DUMMY_PROPERTY
};
SolveData* solve_data_new (void);
SolveData* solve_data_construct (GType object_type);
static void solve_data_finalize (GObject* obj);
GType math_equation_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
GType math_variables_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define MATH_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_EQUATION, MathEquationPrivate))
enum  {
	MATH_EQUATION_DUMMY_PROPERTY,
	MATH_EQUATION_WORD_SIZE,
	MATH_EQUATION_SOURCE_CURRENCY,
	MATH_EQUATION_TARGET_CURRENCY,
	MATH_EQUATION_SOURCE_UNITS,
	MATH_EQUATION_TARGET_UNITS,
	MATH_EQUATION_DISPLAY,
	MATH_EQUATION_IN_SOLVE,
	MATH_EQUATION_VARIABLES,
	MATH_EQUATION_SERIALIZER,
	MATH_EQUATION_ACCURACY,
	MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS,
	MATH_EQUATION_SHOW_TRAILING_ZEROES,
	MATH_EQUATION_NUMBER_FORMAT,
	MATH_EQUATION_NUMBER_BASE,
	MATH_EQUATION_ANGLE_UNITS,
	MATH_EQUATION_STATUS,
	MATH_EQUATION_ERROR_TOKEN_START,
	MATH_EQUATION_ERROR_TOKEN_END,
	MATH_EQUATION_IS_EMPTY,
	MATH_EQUATION_IS_RESULT,
	MATH_EQUATION_EQUATION,
	MATH_EQUATION_NUMBER,
	MATH_EQUATION_NUMBER_MODE,
	MATH_EQUATION_ANSWER
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathEquation* math_equation_new (void);
MathEquation* math_equation_construct (GType object_type);
MathVariables* math_variables_new (void);
MathVariables* math_variables_construct (GType object_type);
void math_equation_set_word_size (MathEquation* self, gint value);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
void math_equation_display_selected (MathEquation* self, const gchar* selected);
static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end);
static void math_equation_reformat_ans (MathEquation* self);
Serializer* math_equation_get_serializer (MathEquation* self);
gchar* serializer_to_string (Serializer* self, Number* x);
static void math_equation_reformat_separators (MathEquation* self);
gchar* math_equation_get_display (MathEquation* self);
gint math_equation_get_number_base (MathEquation* self);
gboolean serializer_get_show_thousands_separators (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index);
gunichar serializer_get_thousands_separator (Serializer* self);
gunichar serializer_get_radix (Serializer* self);
static void math_equation_reformat_display (MathEquation* self);
static MathEquationState* math_equation_get_current_state (MathEquation* self);
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_equation_push_undo_stack (MathEquation* self);
void math_equation_set_status (MathEquation* self, const gchar* value);
static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag);
static void math_equation_apply_state (MathEquation* self, MathEquationState* s);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_equation_copy (MathEquation* self);
void math_equation_paste (MathEquation* self);
static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text);
static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self);
void math_equation_insert (MathEquation* self, const gchar* text);
static void math_equation_real_undo (GtkSourceBuffer* base);
static void math_equation_real_redo (GtkSourceBuffer* base);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
void math_equation_store (MathEquation* self, const gchar* name);
Number* math_equation_get_number (MathEquation* self);
MathVariables* math_equation_get_variables (MathEquation* self);
void math_variables_set (MathVariables* self, const gchar* name, Number* value);
void math_equation_recall (MathEquation* self, const gchar* name);
void math_equation_set (MathEquation* self, const gchar* text);
void math_equation_set_number (MathEquation* self, Number* x, guint representation_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
gint serializer_get_base (Serializer* self);
const gchar* serializer_get_error (Serializer* self);
void serializer_set_error (Serializer* self, const gchar* value);
void math_equation_insert_selected (MathEquation* self, const gchar* answer);
void math_equation_insert_square (MathEquation* self);
void math_equation_insert_digit (MathEquation* self, guint digit);
void math_equation_insert_numeric_point (MathEquation* self);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_insert_exponent (MathEquation* self);
void math_equation_insert_subtract (MathEquation* self);
GType error_code_get_type (void) G_GNUC_CONST;
static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint** error_start, guint* error_end);
GType equation_get_type (void) G_GNUC_CONST;
GType mequation_get_type (void) G_GNUC_CONST;
MEquation* mequation_new (MathEquation* m_equation, const gchar* equation);
MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation);
gint math_equation_get_word_size (MathEquation* self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint** error_start, guint** error_end);
static void* math_equation_solve_real (MathEquation* self);
gchar* math_equation_get_equation (MathEquation* self);
const gchar* number_get_error (void);
static gboolean math_equation_show_in_progress (MathEquation* self);
gboolean math_equation_get_in_solve (MathEquation* self);
static gboolean math_equation_look_for_answer (MathEquation* self);
static void math_equation_error_token_fix_thousands_separator (MathEquation* self);
static void math_equation_error_token_fix_parenthesis (MathEquation* self);
void math_equation_solve (MathEquation* self);
gboolean math_equation_get_is_empty (MathEquation* self);
gboolean math_equation_get_is_result (MathEquation* self);
static gpointer _math_equation_solve_real_gthread_func (gpointer self);
static gboolean _math_equation_look_for_answer_gsource_func (gpointer self);
static gboolean _math_equation_show_in_progress_gsource_func (gpointer self);
guint math_equation_get_error_token_start (MathEquation* self);
guint math_equation_get_error_token_end (MathEquation* self);
static void* math_equation_factorize_real (MathEquation* self);
GList* number_factorize (Number* self);
void math_equation_factorize (MathEquation* self);
gboolean number_is_integer (Number* self);
static gpointer _math_equation_factorize_real_gthread_func (gpointer self);
void math_equation_delete_next (MathEquation* self);
void math_equation_backspace (MathEquation* self);
void math_equation_clear (MathEquation* self);
void math_equation_shift (MathEquation* self, gint count);
Number* number_shift (Number* self, gint count);
void math_equation_toggle_bit (MathEquation* self, guint bit);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
guint64 number_to_unsigned_integer (Number* self);
static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len);
static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end);
static gboolean __lambda10_ (MathEquation* self);
static gboolean ___lambda10__gsource_func (gpointer self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gint math_equation_get_accuracy (MathEquation* self);
gint serializer_get_trailing_digits (Serializer* self);
void math_equation_set_accuracy (MathEquation* self, gint value);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
DisplayFormat math_equation_get_number_format (MathEquation* self);
DisplayFormat serializer_get_number_format (Serializer* self);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
void math_equation_set_number_base (MathEquation* self, gint value);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_base (Serializer* self, gint number_base);
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
gchar* math_equation_get_status (MathEquation* self);
Number* math_equation_get_answer (MathEquation* self);
Number* serializer_from_string (Serializer* self, const gchar* str);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void math_equation_finalize (GObject* obj);
static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define MEQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEQUATION, MEquationPrivate))
enum  {
	MEQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name);
Number* math_variables_get (MathVariables* self, const gchar* name);
static Number* mequation_real_get_variable (Equation* base, const gchar* name);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x);
static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
GType unit_manager_get_type (void) G_GNUC_CONST;
UnitManager* unit_manager_get_default (void);
Number* unit_manager_convert_by_symbol (UnitManager* self, Number* x, const gchar* x_symbol, const gchar* z_symbol);
static void mequation_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType number_mode_get_type (void) {
	static volatile gsize number_mode_type_id__volatile = 0;
	if (g_once_init_enter (&number_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{NUMBER_MODE_NORMAL, "NUMBER_MODE_NORMAL", "normal"}, {NUMBER_MODE_SUPERSCRIPT, "NUMBER_MODE_SUPERSCRIPT", "superscript"}, {NUMBER_MODE_SUBSCRIPT, "NUMBER_MODE_SUBSCRIPT", "subscript"}, {0, NULL, NULL}};
		GType number_mode_type_id;
		number_mode_type_id = g_enum_register_static ("NumberMode", values);
		g_once_init_leave (&number_mode_type_id__volatile, number_mode_type_id);
	}
	return number_mode_type_id__volatile;
}


MathEquationState* math_equation_state_construct (GType object_type) {
	MathEquationState * self = NULL;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquationState*) g_object_new (object_type, NULL);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return self;
#line 499 "math-equation.c"
}


MathEquationState* math_equation_state_new (void) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return math_equation_state_construct (TYPE_MATH_EQUATION_STATE);
#line 506 "math-equation.c"
}


static void math_equation_state_class_init (MathEquationStateClass * klass) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_state_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->finalize = math_equation_state_finalize;
#line 515 "math-equation.c"
}


static void math_equation_state_instance_init (MathEquationState * self) {
}


static void math_equation_state_finalize (GObject* obj) {
	MathEquationState * self;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION_STATE, MathEquationState);
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->ans);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->expression);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->status);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (math_equation_state_parent_class)->finalize (obj);
#line 535 "math-equation.c"
}


GType math_equation_state_get_type (void) {
	static volatile gsize math_equation_state_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquationState), 0, (GInstanceInitFunc) math_equation_state_instance_init, NULL };
		GType math_equation_state_type_id;
		math_equation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "MathEquationState", &g_define_type_info, 0);
		g_once_init_leave (&math_equation_state_type_id__volatile, math_equation_state_type_id);
	}
	return math_equation_state_type_id__volatile;
}


SolveData* solve_data_construct (GType object_type) {
	SolveData * self = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (SolveData*) g_object_new (object_type, NULL);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return self;
#line 557 "math-equation.c"
}


SolveData* solve_data_new (void) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return solve_data_construct (TYPE_SOLVE_DATA);
#line 564 "math-equation.c"
}


static void solve_data_class_init (SolveDataClass * klass) {
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	solve_data_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->finalize = solve_data_finalize;
#line 573 "math-equation.c"
}


static void solve_data_instance_init (SolveData * self) {
}


static void solve_data_finalize (GObject* obj) {
	SolveData * self;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOLVE_DATA, SolveData);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->number_result);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->text_result);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->error);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (solve_data_parent_class)->finalize (obj);
#line 593 "math-equation.c"
}


GType solve_data_get_type (void) {
	static volatile gsize solve_data_type_id__volatile = 0;
	if (g_once_init_enter (&solve_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveData), 0, (GInstanceInitFunc) solve_data_instance_init, NULL };
		GType solve_data_type_id;
		solve_data_type_id = g_type_register_static (G_TYPE_OBJECT, "SolveData", &g_define_type_info, 0);
		g_once_init_leave (&solve_data_type_id__volatile, solve_data_type_id);
	}
	return solve_data_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 612 "math-equation.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_list_free (self);
#line 621 "math-equation.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1026 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 639 "math-equation.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return self ? g_object_ref (self) : NULL;
#line 646 "math-equation.c"
}


MathEquation* math_equation_construct (GType object_type) {
	MathEquation * self = NULL;
	gboolean use_default_digits = FALSE;
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	static const gunichar default_digits[] = {(gunichar) '0', (gunichar) '1', (gunichar) '2', (gunichar) '3', (gunichar) '4', (gunichar) '5', (gunichar) '6', (gunichar) '7', (gunichar) '8', (gunichar) '9', (gunichar) 'A', (gunichar) 'B', (gunichar) 'C', (gunichar) 'D', (gunichar) 'E', (gunichar) 'F'};
#line 655 "math-equation.c"
	gchar** ds = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint ds_length1 = 0;
	gint _ds_size_ = 0;
	MathVariables* _tmp21_ = NULL;
	MathEquationState* _tmp22_ = NULL;
	MathEquationState* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	Serializer* _tmp25_ = NULL;
	GAsyncQueue* _tmp26_ = NULL;
	MathEquationState* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	MathEquationState* _tmp29_ = NULL;
	GtkTextTag* _tmp30_ = NULL;
	GtkTextTag* _tmp31_ = NULL;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquation*) g_object_new (object_type, NULL);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (self->priv->undo_stack);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->undo_stack = NULL;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->redo_stack = NULL;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	use_default_digits = TRUE;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = _ ("0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F");
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", -1);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ds = _tmp2_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ds_length1 = _vala_array_length (_tmp1_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_ds_size_ = ds_length1;
#line 695 "math-equation.c"
	{
		gint i = 0;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = 0;
#line 700 "math-equation.c"
		{
			gboolean _tmp3_ = FALSE;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp3_ = TRUE;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			while (TRUE) {
#line 707 "math-equation.c"
				gint _tmp5_ = 0;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp3_) {
#line 713 "math-equation.c"
					gint _tmp4_ = 0;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp4_ = i;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					i = _tmp4_ + 1;
#line 719 "math-equation.c"
				}
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp3_ = FALSE;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp5_ = i;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!(_tmp5_ < 16)) {
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 729 "math-equation.c"
				}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp7_ = use_default_digits;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp7_) {
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp6_ = TRUE;
#line 737 "math-equation.c"
				} else {
					gchar** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					gint _tmp9_ = 0;
					const gchar* _tmp10_ = NULL;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp8_ = ds;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp8__length1 = ds_length1;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp9_ = i;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp10_ = _tmp8_[_tmp9_];
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp6_ = _tmp10_ == NULL;
#line 753 "math-equation.c"
				}
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp6_) {
#line 757 "math-equation.c"
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gunichar _tmp13_ = 0U;
					gunichar _tmp14_ = 0U;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					use_default_digits = TRUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp11_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp12_ = i;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp13_ = default_digits[_tmp12_];
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					self->priv->digits[_tmp11_] = _tmp13_;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp14_ = self->priv->digits[_tmp11_];
#line 774 "math-equation.c"
				} else {
					gint _tmp15_ = 0;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					const gchar* _tmp18_ = NULL;
					gunichar _tmp19_ = 0U;
					gunichar _tmp20_ = 0U;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp15_ = i;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp16_ = ds;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp16__length1 = ds_length1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp17_ = i;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp18_ = _tmp16_[_tmp17_];
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp19_ = string_get_char (_tmp18_, (glong) 0);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					self->priv->digits[_tmp15_] = _tmp19_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp20_ = self->priv->digits[_tmp15_];
#line 799 "math-equation.c"
				}
			}
		}
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp21_ = math_variables_new ();
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->_variables);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_variables = _tmp21_;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp22_ = math_equation_state_new ();
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->state);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->state = _tmp22_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_ = self->priv->state;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp24_ = g_strdup ("");
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp23_->status);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_->status = _tmp24_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_word_size (self, 32);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_angle_units = ANGLE_UNIT_DEGREES;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_source_currency (self, "");
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_target_currency (self, "");
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_source_units (self, "");
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_target_units (self, "");
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp25_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->_serializer);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_serializer = _tmp25_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp26_ = g_async_queue_new_full (_g_object_unref0_);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_async_queue_unref0 (self->priv->queue);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->queue = _tmp26_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp27_ = self->priv->state;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp28_ = number_new_integer ((gint64) 0);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp27_->ans);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp27_->ans = _tmp28_;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp29_ = self->priv->state;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp29_->ans_base = (guint) 10;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp30_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self, NULL, "weight", PANGO_WEIGHT_BOLD, NULL, NULL);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_tag);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_tag = _tmp31_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ds = (_vala_array_free (ds, ds_length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return self;
#line 872 "math-equation.c"
}


MathEquation* math_equation_new (void) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return math_equation_construct (TYPE_MATH_EQUATION);
#line 879 "math-equation.c"
}


void math_equation_display_selected (MathEquation* self, const gchar* selected) {
	const gchar* _tmp0_ = NULL;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (selected != NULL);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = selected;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp0_, -1);
#line 893 "math-equation.c"
}


static void math_equation_get_ans_offsets (MathEquation* self, gint* start, gint* end) {
	gint _vala_start = 0;
	gint _vala_end = 0;
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->ans_start_mark;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == NULL) {
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_vala_start = -1;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_vala_end = -1;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (start) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			*start = _vala_start;
#line 922 "math-equation.c"
		}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (end) {
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			*end = _vala_end;
#line 928 "math-equation.c"
		}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 932 "math-equation.c"
	}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = self->priv->ans_start_mark;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	iter = _tmp2_;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = gtk_text_iter_get_offset (&iter);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_start = _tmp3_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = self->priv->ans_end_mark;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	iter = _tmp5_;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = gtk_text_iter_get_offset (&iter);
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_end = _tmp6_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (start) {
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*start = _vala_start;
#line 958 "math-equation.c"
	}
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (end) {
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*end = _vala_end;
#line 964 "math-equation.c"
	}
}


static void math_equation_reformat_ans (MathEquation* self) {
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter ans_start = {0};
	GtkTextIter ans_end = {0};
	GtkTextMark* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	gchar* orig_ans_text = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	gchar* ans_text = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	MathEquationState* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkTextMark* _tmp33_ = NULL;
	GtkTextIter _tmp34_ = {0};
	GtkTextMark* _tmp35_ = NULL;
	GtkTextIter _tmp36_ = {0};
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->ans_start_mark;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == NULL) {
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 1001 "math-equation.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = self->priv->ans_start_mark;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = _tmp2_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = self->priv->ans_end_mark;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp4_, _tmp3_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = _tmp4_;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = ans_start;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = ans_end;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	orig_ans_text = _tmp7_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = math_equation_get_serializer (self);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = _tmp8_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = self->priv->state;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = _tmp10_->ans;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = serializer_to_string (_tmp9_, _tmp11_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_text = _tmp12_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = orig_ans_text;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = ans_text;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
#line 1041 "math-equation.c"
		GtkTextMark* _tmp15_ = NULL;
		GtkTextIter _tmp16_ = {0};
		GtkTextMark* _tmp17_ = NULL;
		GtkTextIter _tmp18_ = {0};
		const gchar* _tmp19_ = NULL;
		GtkTextTag* _tmp20_ = NULL;
		GtkTextMark* _tmp21_ = NULL;
		GtkTextIter _tmp22_ = {0};
		GtkTextMark* _tmp23_ = NULL;
		GtkTextIter _tmp24_ = {0};
		GtkTextMark* _tmp25_ = NULL;
		GtkTextMark* _tmp26_ = NULL;
		GtkTextIter _tmp27_ = {0};
		GtkTextMark* _tmp28_ = NULL;
		GtkTextMark* _tmp29_ = NULL;
		GtkTextIter _tmp30_ = {0};
		GtkTextMark* _tmp31_ = NULL;
		GtkTextMark* _tmp32_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->in_undo_operation = TRUE;
#line 239 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->in_reformat = TRUE;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &ans_start, &ans_end);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = self->priv->ans_start_mark;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp16_, _tmp15_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp16_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp17_ = self->priv->ans_end_mark;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp18_, _tmp17_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp18_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = ans_text;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp20_ = self->priv->ans_tag;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_insert_with_tags ((GtkTextBuffer*) self, &ans_end, _tmp19_, -1, _tmp20_, NULL);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp21_ = self->priv->ans_start_mark;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp22_, _tmp21_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp22_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp23_ = self->priv->ans_end_mark;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp24_, _tmp23_);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp24_;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp25_ = self->priv->ans_start_mark;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp25_);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp26_ = self->priv->ans_end_mark;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp26_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp27_ = ans_end;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp27_, FALSE);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = _g_object_ref0 (_tmp28_);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (self->priv->ans_start_mark);
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->ans_start_mark = _tmp29_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp30_ = ans_start;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp31_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp30_, TRUE);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp32_ = _g_object_ref0 (_tmp31_);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (self->priv->ans_end_mark);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->ans_end_mark = _tmp32_;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->in_reformat = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->in_undo_operation = FALSE;
#line 1128 "math-equation.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp33_ = self->priv->ans_start_mark;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp34_, _tmp33_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = _tmp34_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp35_ = self->priv->ans_end_mark;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp36_, _tmp35_);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = _tmp36_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (ans_text);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (orig_ans_text);
#line 1146 "math-equation.c"
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1016 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1017 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 1168 "math-equation.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1018 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1183 "math-equation.c"
		}
#line 1019 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1187 "math-equation.c"
	} else {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1195 "math-equation.c"
		}
#line 1021 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 1199 "math-equation.c"
	}
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (c) {
#line 1015 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 1205 "math-equation.c"
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 857 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 858 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = str;
#line 859 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1227 "math-equation.c"
}


static void math_equation_reformat_separators (MathEquation* self) {
	gboolean in_number = FALSE;
	gboolean in_radix = FALSE;
	gboolean last_is_tsep = FALSE;
	gint digit_offset = 0;
	gchar* text = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint offset = 0;
	gint index = 0;
	gunichar c = 0U;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	in_number = FALSE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	in_radix = FALSE;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	last_is_tsep = FALSE;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	digit_offset = 0;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_undo_operation = TRUE;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_reformat = TRUE;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_display (self);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp1_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_get_ans_offsets (self, &_tmp2_, &_tmp3_);
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = _tmp2_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = _tmp3_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	offset = -1;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	index = 0;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 1278 "math-equation.c"
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gboolean expect_tsep = FALSE;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gunichar _tmp33_ = 0U;
		gboolean _tmp34_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = text;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		c = _tmp5_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp6_) {
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 1307 "math-equation.c"
		}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = offset;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		offset = _tmp7_ + 1;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = math_equation_get_number_base (self);
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = _tmp14_;
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp15_ == 10) {
#line 1319 "math-equation.c"
			Serializer* _tmp16_ = NULL;
			Serializer* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp16_ = math_equation_get_serializer (self);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp17_ = _tmp16_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp18_ = serializer_get_show_thousands_separators (_tmp17_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp13_ = _tmp18_;
#line 1331 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp13_ = FALSE;
#line 1335 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp13_) {
#line 1339 "math-equation.c"
			gboolean _tmp19_ = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp19_ = in_number;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp12_ = _tmp19_;
#line 1345 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp12_ = FALSE;
#line 1349 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp12_) {
#line 1353 "math-equation.c"
			gboolean _tmp20_ = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp20_ = in_radix;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp11_ = !_tmp20_;
#line 1359 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp11_ = FALSE;
#line 1363 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp11_) {
#line 1367 "math-equation.c"
			gboolean _tmp21_ = FALSE;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp21_ = last_is_tsep;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp10_ = !_tmp21_;
#line 1373 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp10_ = FALSE;
#line 1377 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp10_) {
#line 1381 "math-equation.c"
			gint _tmp22_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp22_ = digit_offset;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp9_ = _tmp22_ > 0;
#line 1387 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp9_ = FALSE;
#line 1391 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp9_) {
#line 1395 "math-equation.c"
			gint _tmp23_ = 0;
			Serializer* _tmp24_ = NULL;
			Serializer* _tmp25_ = NULL;
			gint _tmp26_ = 0;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp23_ = digit_offset;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp24_ = math_equation_get_serializer (self);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp25_ = _tmp24_;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp26_ = serializer_get_thousands_separator_count (_tmp25_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = (_tmp23_ % _tmp26_) == 0;
#line 1410 "math-equation.c"
		} else {
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = FALSE;
#line 1414 "math-equation.c"
		}
#line 286 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		expect_tsep = _tmp8_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		last_is_tsep = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = offset;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = ans_start;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp28_ >= _tmp29_) {
#line 1426 "math-equation.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp30_ = offset;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp31_ = ans_end;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = _tmp30_ <= _tmp31_;
#line 1435 "math-equation.c"
		} else {
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = FALSE;
#line 1439 "math-equation.c"
		}
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp27_) {
#line 1443 "math-equation.c"
			gboolean _tmp32_ = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			in_radix = FALSE;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp32_ = in_radix;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			in_number = _tmp32_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			continue;
#line 1453 "math-equation.c"
		}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp33_ = c;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp34_ = g_unichar_isdigit (_tmp33_);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp34_) {
#line 1461 "math-equation.c"
			gboolean _tmp35_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gint _tmp48_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp35_ = in_number;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (!_tmp35_) {
#line 1469 "math-equation.c"
				const gchar* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp36_ = text;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp37_ = index;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp38_ = math_equation_count_digits (self, _tmp36_, _tmp37_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				digit_offset = _tmp38_ + 1;
#line 1481 "math-equation.c"
			}
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			in_number = TRUE;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp39_ = expect_tsep;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp39_) {
#line 1489 "math-equation.c"
				GtkTextIter iter = {0};
				gint _tmp40_ = 0;
				GtkTextIter _tmp41_ = {0};
				Serializer* _tmp42_ = NULL;
				Serializer* _tmp43_ = NULL;
				gunichar _tmp44_ = 0U;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp40_ = offset;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp41_, _tmp40_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				iter = _tmp41_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp42_ = math_equation_get_serializer (self);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp43_ = _tmp42_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp44_ = serializer_get_thousands_separator (_tmp43_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp45_ = g_unichar_to_string (_tmp44_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp46_ = _tmp45_;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				gtk_text_buffer_insert (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &iter, _tmp46_, -1);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp46_);
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp47_ = offset;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				offset = _tmp47_ + 1;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				last_is_tsep = TRUE;
#line 1525 "math-equation.c"
			}
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp48_ = digit_offset;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			digit_offset = _tmp48_ - 1;
#line 1531 "math-equation.c"
		} else {
			gunichar _tmp49_ = 0U;
			Serializer* _tmp50_ = NULL;
			Serializer* _tmp51_ = NULL;
			gunichar _tmp52_ = 0U;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp49_ = c;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp50_ = math_equation_get_serializer (self);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp51_ = _tmp50_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp52_ = serializer_get_radix (_tmp51_);
#line 316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp49_ == _tmp52_) {
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				in_number = TRUE;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				in_radix = TRUE;
#line 1551 "math-equation.c"
			} else {
				gunichar _tmp53_ = 0U;
				Serializer* _tmp54_ = NULL;
				Serializer* _tmp55_ = NULL;
				gunichar _tmp56_ = 0U;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp53_ = c;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp54_ = math_equation_get_serializer (self);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp55_ = _tmp54_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp56_ = serializer_get_thousands_separator (_tmp55_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp53_ == _tmp56_) {
#line 1567 "math-equation.c"
					gboolean _tmp57_ = FALSE;
					gboolean _tmp58_ = FALSE;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp58_ = expect_tsep;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					if (!_tmp58_) {
#line 1574 "math-equation.c"
						gboolean _tmp59_ = FALSE;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp59_ = in_number;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp57_ = _tmp59_;
#line 1580 "math-equation.c"
					} else {
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp57_ = FALSE;
#line 1584 "math-equation.c"
					}
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					if (_tmp57_) {
#line 1588 "math-equation.c"
						GtkTextIter start = {0};
						GtkTextIter end = {0};
						gint _tmp60_ = 0;
						GtkTextIter _tmp61_ = {0};
						gint _tmp62_ = 0;
						GtkTextIter _tmp63_ = {0};
						gint _tmp64_ = 0;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp60_ = offset;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp61_, _tmp60_);
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						start = _tmp61_;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp62_ = offset;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp63_, _tmp62_ + 1);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						end = _tmp63_;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp64_ = offset;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						offset = _tmp64_ - 1;
#line 1614 "math-equation.c"
					} else {
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						last_is_tsep = TRUE;
#line 1618 "math-equation.c"
					}
				} else {
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					in_number = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					in_radix = FALSE;
#line 1625 "math-equation.c"
				}
			}
		}
	}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_reformat = FALSE;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_undo_operation = FALSE;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 1636 "math-equation.c"
}


static gint math_equation_count_digits (MathEquation* self, const gchar* text, gint index) {
	gint result = 0;
	gint count = 0;
	gboolean following_separator = FALSE;
	gunichar c = 0U;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (text != NULL, 0);
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	count = 0;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	following_separator = FALSE;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 1655 "math-equation.c"
		const gchar* _tmp0_ = NULL;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gunichar _tmp3_ = 0U;
		Serializer* _tmp4_ = NULL;
		Serializer* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = text;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		c = _tmp1_;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp2_) {
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 1673 "math-equation.c"
		}
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = c;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = math_equation_get_serializer (self);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = _tmp4_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = serializer_get_thousands_separator (_tmp5_);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp3_ == _tmp6_) {
#line 1685 "math-equation.c"
			gboolean _tmp7_ = FALSE;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp7_ = following_separator;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp7_) {
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				result = count;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				return result;
#line 1695 "math-equation.c"
			}
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			following_separator = TRUE;
#line 1699 "math-equation.c"
		} else {
			gunichar _tmp8_ = 0U;
			gboolean _tmp9_ = FALSE;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = c;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp9_ = g_unichar_isdigit (_tmp8_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp9_) {
#line 1709 "math-equation.c"
				gint _tmp10_ = 0;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				following_separator = FALSE;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp10_ = count;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				count = _tmp10_ + 1;
#line 1717 "math-equation.c"
			} else {
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				result = count;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				return result;
#line 1723 "math-equation.c"
			}
		}
	}
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = count;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 1731 "math-equation.c"
}


static void math_equation_reformat_display (MathEquation* self) {
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_ans (self);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_separators (self);
#line 1742 "math-equation.c"
}


static MathEquationState* math_equation_get_current_state (MathEquation* self) {
	MathEquationState* result = NULL;
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp0_ = NULL;
	MathEquationState* s = NULL;
	MathEquationState* _tmp7_ = NULL;
	MathEquationState* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	MathEquationState* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	NumberMode _tmp17_ = 0;
	NumberMode _tmp18_ = 0;
	gboolean _tmp19_ = FALSE;
	MathEquationState* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	MathEquationState* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = -1;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = -1;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->ans_start_mark;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ != NULL) {
#line 1780 "math-equation.c"
		GtkTextIter iter = {0};
		GtkTextMark* _tmp1_ = NULL;
		GtkTextIter _tmp2_ = {0};
		gint _tmp3_ = 0;
		GtkTextMark* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = self->priv->ans_start_mark;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		iter = _tmp2_;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = gtk_text_iter_get_offset (&iter);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp3_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = self->priv->ans_end_mark;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		iter = _tmp5_;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = gtk_text_iter_get_offset (&iter);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp6_;
#line 1808 "math-equation.c"
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = math_equation_state_new ();
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s = _tmp7_;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = self->priv->state;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = _tmp8_->ans;
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (s->ans);
#line 395 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->ans = _tmp10_;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = self->priv->state;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = _tmp11_->ans_base;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->ans_base = _tmp12_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = math_equation_get_display (self);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = _tmp13_;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (s->expression);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->expression = _tmp14_;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = ans_start;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->ans_start = _tmp15_;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = ans_end;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->ans_end = _tmp16_;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_get ((GObject*) self, "cursor-position", &s->cursor, NULL, NULL);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp17_ = math_equation_get_number_mode (self);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp18_ = _tmp17_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->number_mode = _tmp18_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp19_ = self->priv->can_super_minus;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->can_super_minus = _tmp19_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp20_ = self->priv->state;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp21_ = _tmp20_->entered_multiply;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->entered_multiply = _tmp21_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp22_ = self->priv->state;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_ = _tmp22_->status;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp24_ = g_strdup (_tmp23_);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (s->status);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	s->status = _tmp24_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = s;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 1878 "math-equation.c"
}


static void math_equation_push_undo_stack (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	MathEquationState* _tmp1_ = NULL;
	MathEquationState* _tmp2_ = NULL;
	MathEquationState* _tmp3_ = NULL;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->in_undo_operation;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 1895 "math-equation.c"
	}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_status (self, "");
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->redo_stack = NULL;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = math_equation_get_current_state (self);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->state);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->state = _tmp1_;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = self->priv->state;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp3_);
#line 1915 "math-equation.c"
}


static void math_equation_clear_ans (MathEquation* self, gboolean do_remove_tag) {
	GtkTextMark* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkTextMark* _tmp9_ = NULL;
	GtkTextMark* _tmp10_ = NULL;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->ans_start_mark;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == NULL) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 1932 "math-equation.c"
	}
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = do_remove_tag;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 1938 "math-equation.c"
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		GtkTextMark* _tmp2_ = NULL;
		GtkTextIter _tmp3_ = {0};
		GtkTextMark* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		GtkTextTag* _tmp6_ = NULL;
		GtkTextIter _tmp7_ = {0};
		GtkTextIter _tmp8_ = {0};
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = self->priv->ans_start_mark;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		start = _tmp3_;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = self->priv->ans_end_mark;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		end = _tmp5_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = self->priv->ans_tag;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = start;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = end;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp6_, &_tmp7_, &_tmp8_);
#line 1968 "math-equation.c"
	}
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = self->priv->ans_start_mark;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp9_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = self->priv->ans_end_mark;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp10_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_start_mark);
#line 438 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_start_mark = NULL;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_end_mark);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_end_mark = NULL;
#line 1986 "math-equation.c"
}


static void math_equation_apply_state (MathEquation* self, MathEquationState* s) {
	MathEquationState* _tmp0_ = NULL;
	MathEquationState* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	MathEquationState* _tmp4_ = NULL;
	MathEquationState* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	MathEquationState* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkTextIter cursor = {0};
	MathEquationState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_ = {0};
	MathEquationState* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	MathEquationState* _tmp30_ = NULL;
	NumberMode _tmp31_ = 0;
	MathEquationState* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	MathEquationState* _tmp34_ = NULL;
	MathEquationState* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	MathEquationState* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (s != NULL);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_undo_operation = TRUE;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->state;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = s;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_->ans;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp0_->ans);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_->ans = _tmp3_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = self->priv->state;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = s;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_->ans_base;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_->ans_base = _tmp6_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = s;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = _tmp7_->expression;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp8_, -1);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = s;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = _tmp9_->cursor;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	cursor = _tmp11_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = cursor;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp12_);
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_clear_ans (self, FALSE);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = s;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = _tmp13_->ans_start;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp14_ >= 0) {
#line 2068 "math-equation.c"
		GtkTextIter start = {0};
		MathEquationState* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		GtkTextIter _tmp17_ = {0};
		GtkTextIter _tmp18_ = {0};
		GtkTextMark* _tmp19_ = NULL;
		GtkTextMark* _tmp20_ = NULL;
		GtkTextIter end = {0};
		MathEquationState* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		GtkTextIter _tmp23_ = {0};
		GtkTextIter _tmp24_ = {0};
		GtkTextMark* _tmp25_ = NULL;
		GtkTextMark* _tmp26_ = NULL;
		GtkTextTag* _tmp27_ = NULL;
		GtkTextIter _tmp28_ = {0};
		GtkTextIter _tmp29_ = {0};
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = s;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp16_ = _tmp15_->ans_start;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp17_, _tmp16_);
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		start = _tmp17_;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_ = start;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp18_, FALSE);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp20_ = _g_object_ref0 (_tmp19_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (self->priv->ans_start_mark);
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->ans_start_mark = _tmp20_;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp21_ = s;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp22_ = _tmp21_->ans_end;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp23_, _tmp22_);
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		end = _tmp23_;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp24_ = end;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp25_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp24_, TRUE);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp26_ = _g_object_ref0 (_tmp25_);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (self->priv->ans_end_mark);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->ans_end_mark = _tmp26_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp27_ = self->priv->ans_tag;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = start;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = end;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp27_, &_tmp28_, &_tmp29_);
#line 2130 "math-equation.c"
	}
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp30_ = s;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp31_ = _tmp30_->number_mode;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number_mode (self, _tmp31_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp32_ = s;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp33_ = _tmp32_->can_super_minus;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->can_super_minus = _tmp33_;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp34_ = self->priv->state;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp35_ = s;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp36_ = _tmp35_->entered_multiply;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp34_->entered_multiply = _tmp36_;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp37_ = s;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp38_ = _tmp37_->status;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_status (self, _tmp38_);
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_undo_operation = FALSE;
#line 2160 "math-equation.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2173 "math-equation.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2204 "math-equation.c"
				goto __catch7_g_regex_error;
			}
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 2213 "math-equation.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2229 "math-equation.c"
				goto __catch7_g_regex_error;
			}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 2240 "math-equation.c"
		}
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2254 "math-equation.c"
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2268 "math-equation.c"
	}
	__finally7:
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return NULL;
#line 2279 "math-equation.c"
	}
}


void math_equation_copy (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* text = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	gchar* tsep_string = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GdkAtom _tmp17_ = 0U;
	GtkClipboard* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	start = _tmp0_;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	end = _tmp1_;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (!_tmp2_) {
#line 2315 "math-equation.c"
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		start = _tmp3_;
#line 477 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		end = _tmp4_;
#line 2324 "math-equation.c"
	}
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = start;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = end;
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
#line 479 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp7_;
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = nl_langinfo (THOUSEP);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	tsep_string = _tmp9_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = tsep_string;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp11_ == NULL) {
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = TRUE;
#line 2346 "math-equation.c"
	} else {
		const gchar* _tmp12_ = NULL;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp12_ = tsep_string;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
#line 2353 "math-equation.c"
	}
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp10_) {
#line 2357 "math-equation.c"
		gchar* _tmp13_ = NULL;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = g_strdup (" ");
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (tsep_string);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		tsep_string = _tmp13_;
#line 2365 "math-equation.c"
	}
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = text;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = tsep_string;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = string_replace (_tmp14_, _tmp15_, "");
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp16_;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp17_ = GDK_NONE;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp18_ = gtk_clipboard_get (_tmp17_);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp19_ = text;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_clipboard_set_text (_tmp18_, _tmp19_, -1);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (tsep_string);
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 2389 "math-equation.c"
}


static void _math_equation_on_paste_gtk_clipboard_text_received_func (GtkClipboard* clipboard, const gchar* text, gpointer self) {
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_on_paste ((MathEquation*) self, clipboard, text);
#line 2396 "math-equation.c"
}


void math_equation_paste (MathEquation* self) {
	GdkAtom _tmp0_ = 0U;
	GtkClipboard* _tmp1_ = NULL;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = GDK_NONE;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = gtk_clipboard_get (_tmp0_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_clipboard_request_text (_tmp1_, _math_equation_on_paste_gtk_clipboard_text_received_func, self);
#line 2411 "math-equation.c"
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
#line 1123 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1123 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (delimiters != NULL, NULL);
#line 1124 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1124 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1125 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1125 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = delimiters;
#line 1125 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = new_delimiter;
#line 1125 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
#line 1126 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _result_;
#line 1126 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2442 "math-equation.c"
}


static void math_equation_on_paste (MathEquation* self, GtkClipboard* clipboard, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (clipboard != NULL);
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = text;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ != NULL) {
#line 2456 "math-equation.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = text;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = string_delimit (_tmp1_, "\n", ' ');
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = _tmp2_;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, _tmp3_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_tmp3_);
#line 2470 "math-equation.c"
	}
}


static void math_equation_real_undo (GtkSourceBuffer* base) {
	MathEquation * self;
	GList* _tmp0_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	MathEquationState* _tmp4_ = NULL;
	MathEquationState* _tmp5_ = NULL;
	MathEquationState* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	MathEquationState* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	MathEquationState* _tmp14_ = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquation*) base;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->undo_stack;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == NULL) {
#line 2496 "math-equation.c"
		const gchar* _tmp1_ = NULL;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = _ ("No undo history");
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp1_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 2504 "math-equation.c"
	}
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = self->priv->undo_stack;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _g_object_ref0 ((MathEquationState*) _tmp3_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->state);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->state = _tmp4_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_status (self, "");
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = self->priv->state;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->undo_stack = g_list_remove (self->priv->undo_stack, _tmp5_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = math_equation_get_current_state (self);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->redo_stack = g_list_prepend (self->priv->redo_stack, _tmp6_);
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = self->priv->undo_stack;
#line 513 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp7_ == NULL) {
#line 2530 "math-equation.c"
		MathEquationState* _tmp8_ = NULL;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = self->priv->state;
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_apply_state (self, _tmp8_);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 2538 "math-equation.c"
	}
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = self->priv->state;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = self->priv->undo_stack;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = g_list_nth_data (_tmp10_, (guint) 0);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = ((MathEquationState*) _tmp11_)->ans;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp9_->ans);
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_->ans = _tmp13_;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = self->priv->state;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_apply_state (self, _tmp14_);
#line 2558 "math-equation.c"
}


static void math_equation_real_redo (GtkSourceBuffer* base) {
	MathEquation * self;
	GList* _tmp0_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	MathEquationState* _tmp4_ = NULL;
	MathEquationState* _tmp5_ = NULL;
	MathEquationState* _tmp6_ = NULL;
	MathEquationState* _tmp7_ = NULL;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquation*) base;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->redo_stack;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == NULL) {
#line 2577 "math-equation.c"
		const gchar* _tmp1_ = NULL;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = _ ("No redo history");
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp1_);
#line 529 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 2585 "math-equation.c"
	}
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = self->priv->redo_stack;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _g_object_ref0 ((MathEquationState*) _tmp3_);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->state);
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->state = _tmp4_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = self->priv->state;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->redo_stack = g_list_remove (self->priv->redo_stack, _tmp5_);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = math_equation_get_current_state (self);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->undo_stack = g_list_prepend (self->priv->undo_stack, _tmp6_);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = self->priv->state;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_apply_state (self, _tmp7_);
#line 2609 "math-equation.c"
}


gunichar math_equation_get_digit_text (MathEquation* self, guint digit) {
	gunichar result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = digit;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ >= ((guint) 16)) {
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = (gunichar) '?';
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 2628 "math-equation.c"
	}
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = digit;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = self->priv->digits[_tmp1_];
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 543 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 2638 "math-equation.c"
}


void math_equation_store (MathEquation* self, const gchar* name) {
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (name != NULL);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_number (self);
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 749 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	t = _tmp1_;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = t;
#line 750 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == NULL) {
#line 2661 "math-equation.c"
		const gchar* _tmp3_ = NULL;
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = _ ("No sane value to store");
#line 751 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp3_);
#line 2667 "math-equation.c"
	} else {
		MathVariables* _tmp4_ = NULL;
		MathVariables* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = math_equation_get_variables (self);
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = _tmp4_;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = name;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = t;
#line 753 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_variables_set (_tmp5_, _tmp6_, _tmp7_);
#line 2683 "math-equation.c"
	}
#line 747 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (t);
#line 2687 "math-equation.c"
}


void math_equation_recall (MathEquation* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 756 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (name != NULL);
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = name;
#line 758 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_insert (self, _tmp0_);
#line 2701 "math-equation.c"
}


void math_equation_set (MathEquation* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 761 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (text != NULL);
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = text;
#line 763 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp0_, -1);
#line 764 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_clear_ans (self, FALSE);
#line 2717 "math-equation.c"
}


void math_equation_set_number (MathEquation* self, Number* x, guint representation_base) {
	guint _tmp0_ = 0U;
	gchar* text = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	MathEquationState* _tmp14_ = NULL;
	MathEquationState* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Serializer* _tmp18_ = NULL;
	Serializer* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	guint _tmp21_ = 0U;
	const gchar* _tmp22_ = NULL;
	MathEquationState* _tmp23_ = NULL;
	Number* _tmp24_ = NULL;
	Number* _tmp25_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp26_ = {0};
	GtkTextIter _tmp27_ = {0};
	GtkTextIter _tmp28_ = {0};
	GtkTextMark* _tmp29_ = NULL;
	GtkTextMark* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextMark* _tmp32_ = NULL;
	GtkTextMark* _tmp33_ = NULL;
	GtkTextTag* _tmp34_ = NULL;
	GtkTextIter _tmp35_ = {0};
	GtkTextIter _tmp36_ = {0};
	Serializer* _tmp37_ = NULL;
	Serializer* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (x != NULL);
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = representation_base;
#line 769 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2766 "math-equation.c"
		Serializer* _tmp1_ = NULL;
		Serializer* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = math_equation_get_serializer (self);
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = _tmp1_;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = representation_base;
#line 770 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		serializer_set_representation_base (_tmp2_, _tmp3_);
#line 2778 "math-equation.c"
	}
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_serializer (self);
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = x;
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = serializer_to_string (_tmp5_, _tmp6_);
#line 773 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp7_;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = representation_base;
#line 775 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp8_ != ((guint) 0)) {
#line 2794 "math-equation.c"
		Serializer* _tmp9_ = NULL;
		Serializer* _tmp10_ = NULL;
		Serializer* _tmp11_ = NULL;
		Serializer* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = math_equation_get_serializer (self);
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = _tmp9_;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = math_equation_get_serializer (self);
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp12_ = _tmp11_;
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = serializer_get_base (_tmp12_);
#line 776 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		serializer_set_representation_base (_tmp10_, (guint) _tmp13_);
#line 2812 "math-equation.c"
	}
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = math_equation_get_current_state (self);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = _tmp14_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = _tmp15_->expression;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp17_ = x;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp18_ = math_equation_get_serializer (self);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp19_ = _tmp18_;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp20_ = serializer_get_base (_tmp19_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp21_ = representation_base;
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_signal_emit_by_name (self, "history-signal", _tmp16_, _tmp17_, _tmp20_, _tmp21_);
#line 777 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp15_);
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp22_ = text;
#line 778 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp22_, -1);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_ = self->priv->state;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp24_ = x;
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp23_->ans);
#line 779 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_->ans = _tmp25_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp26_, &_tmp27_);
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	start = _tmp26_;
#line 783 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	end = _tmp27_;
#line 784 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_clear_ans (self, FALSE);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp28_ = start;
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp29_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp28_, FALSE);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp30_ = _g_object_ref0 (_tmp29_);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_start_mark);
#line 785 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_start_mark = _tmp30_;
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp31_ = end;
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp32_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp31_, TRUE);
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp33_ = _g_object_ref0 (_tmp32_);
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_end_mark);
#line 786 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_end_mark = _tmp33_;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp34_ = self->priv->ans_tag;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp35_ = start;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp36_ = end;
#line 787 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp34_, &_tmp35_, &_tmp36_);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp37_ = math_equation_get_serializer (self);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp38_ = _tmp37_;
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp39_ = serializer_get_error (_tmp38_);
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp40_ = _tmp39_;
#line 789 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp40_ != NULL) {
#line 2894 "math-equation.c"
		Serializer* _tmp41_ = NULL;
		Serializer* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		Serializer* _tmp45_ = NULL;
		Serializer* _tmp46_ = NULL;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp41_ = math_equation_get_serializer (self);
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp42_ = _tmp41_;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp43_ = serializer_get_error (_tmp42_);
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp44_ = _tmp43_;
#line 791 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp44_);
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp45_ = math_equation_get_serializer (self);
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp46_ = _tmp45_;
#line 792 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		serializer_set_error (_tmp46_, NULL);
#line 2917 "math-equation.c"
	}
#line 767 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 2921 "math-equation.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 900 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 900 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 901 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 901 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 901 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 901 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 903 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 903 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2948 "math-equation.c"
		gchar* _tmp4_ = NULL;
#line 904 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 904 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 904 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2956 "math-equation.c"
	} else {
#line 906 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = -1;
#line 906 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 2962 "math-equation.c"
	}
}


void math_equation_insert (MathEquation* self, const gchar* text) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	const gchar* _tmp16_ = NULL;
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 796 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (text != NULL);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (!_tmp3_) {
#line 2988 "math-equation.c"
		const gchar* _tmp4_ = NULL;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = text;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = g_strcmp0 (_tmp4_, "×") == 0;
#line 2994 "math-equation.c"
	} else {
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = FALSE;
#line 2998 "math-equation.c"
	}
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 3002 "math-equation.c"
		MathEquationState* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = self->priv->state;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = _tmp5_->entered_multiply;
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = _tmp6_;
#line 3011 "math-equation.c"
	} else {
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = FALSE;
#line 3015 "math-equation.c"
	}
#line 799 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 3019 "math-equation.c"
		GtkTextIter iter = {0};
		GtkTextMark* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		GtkTextIter _tmp9_ = {0};
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp8_, _tmp7_);
#line 802 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		iter = _tmp8_;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = iter;
#line 803 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &_tmp9_, TRUE, TRUE);
#line 804 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, "^", -1);
#line 805 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 3038 "math-equation.c"
	}
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = text;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = string_index_of ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp11_, 0);
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp12_ >= 0) {
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = TRUE;
#line 3048 "math-equation.c"
	} else {
		const gchar* _tmp13_ = NULL;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = text;
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = g_strcmp0 (_tmp13_, "⁻") == 0;
#line 3055 "math-equation.c"
	}
#line 809 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp10_) {
#line 810 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->can_super_minus = FALSE;
#line 3061 "math-equation.c"
	}
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = text;
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = string_index_of ("⁻⁰¹²³⁴⁵⁶⁷⁸⁹₀₁₂₃₄₅₆₇₈₉", _tmp14_, 0);
#line 813 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp15_ < 0) {
#line 814 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
#line 3071 "math-equation.c"
	}
#line 816 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = text;
#line 817 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self, _tmp16_, -1);
#line 3079 "math-equation.c"
}


void math_equation_insert_selected (MathEquation* self, const gchar* answer) {
	const gchar* _tmp0_ = NULL;
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 820 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (answer != NULL);
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = answer;
#line 822 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_insert (self, _tmp0_);
#line 3093 "math-equation.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 920 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 921 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 923 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 3118 "math-equation.c"
		gchar* _tmp4_ = NULL;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 924 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3126 "math-equation.c"
	} else {
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = -1;
#line 926 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3132 "math-equation.c"
	}
}


void math_equation_insert_square (MathEquation* self) {
	gboolean space_required = FALSE;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
#line 825 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 827 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	space_required = FALSE;
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
#line 829 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	iter = _tmp1_;
#line 832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = gtk_text_iter_backward_char (&iter);
#line 832 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_) {
#line 3158 "math-equation.c"
		gunichar previous_character = 0U;
		gunichar _tmp3_ = 0U;
		gunichar _tmp4_ = 0U;
		gint _tmp5_ = 0;
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = gtk_text_iter_get_char (&iter);
#line 834 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		previous_character = _tmp3_;
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = previous_character;
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = string_index_of_char ("⁰¹²³⁴⁵⁶⁷⁸⁹", _tmp4_, 0);
#line 835 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp5_ >= 0) {
#line 837 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			space_required = TRUE;
#line 3175 "math-equation.c"
		}
	}
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = space_required;
#line 841 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp6_) {
#line 843 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, " ²");
#line 3184 "math-equation.c"
	} else {
#line 847 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, "²");
#line 3188 "math-equation.c"
	}
}


void math_equation_insert_digit (MathEquation* self, guint digit) {
#line 853 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	static const gunichar subscript_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
#line 854 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	static const gunichar superscript_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
#line 3198 "math-equation.c"
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	NumberMode _tmp2_ = 0;
	NumberMode _tmp3_ = 0;
#line 851 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = digit;
#line 856 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ >= ((guint) 16)) {
#line 857 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 3211 "math-equation.c"
	}
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = math_equation_get_number_mode (self);
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ == NUMBER_MODE_NORMAL) {
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = TRUE;
#line 3221 "math-equation.c"
	} else {
		guint _tmp4_ = 0U;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = digit;
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = _tmp4_ >= ((guint) 10);
#line 3228 "math-equation.c"
	}
#line 859 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 3232 "math-equation.c"
		guint _tmp5_ = 0U;
		gunichar _tmp6_ = 0U;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = digit;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = math_equation_get_digit_text (self, _tmp5_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = g_unichar_to_string (_tmp6_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _tmp7_;
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, _tmp8_);
#line 860 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_tmp8_);
#line 3249 "math-equation.c"
	} else {
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = math_equation_get_number_mode (self);
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = _tmp9_;
#line 861 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
#line 3259 "math-equation.c"
			guint _tmp11_ = 0U;
			gunichar _tmp12_ = 0U;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp11_ = digit;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp12_ = superscript_digits[_tmp11_];
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp13_ = g_unichar_to_string (_tmp12_);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp14_ = _tmp13_;
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			math_equation_insert (self, _tmp14_);
#line 862 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp14_);
#line 3276 "math-equation.c"
		} else {
			NumberMode _tmp15_ = 0;
			NumberMode _tmp16_ = 0;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp15_ = math_equation_get_number_mode (self);
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp16_ = _tmp15_;
#line 863 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp16_ == NUMBER_MODE_SUBSCRIPT) {
#line 3286 "math-equation.c"
				guint _tmp17_ = 0U;
				gunichar _tmp18_ = 0U;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp17_ = digit;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp18_ = subscript_digits[_tmp17_];
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp19_ = g_unichar_to_string (_tmp18_);
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp20_ = _tmp19_;
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				math_equation_insert (self, _tmp20_);
#line 864 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp20_);
#line 3303 "math-equation.c"
			}
		}
	}
}


void math_equation_insert_numeric_point (MathEquation* self) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 867 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_radix (_tmp1_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_unichar_to_string (_tmp2_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _tmp3_;
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_insert (self, _tmp4_);
#line 869 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp4_);
#line 3332 "math-equation.c"
}


void math_equation_insert_number (MathEquation* self, Number* x) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 872 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (x != NULL);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = x;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = serializer_to_string (_tmp1_, _tmp2_);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _tmp3_;
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_insert (self, _tmp4_);
#line 874 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp4_);
#line 3360 "math-equation.c"
}


void math_equation_insert_exponent (MathEquation* self) {
#line 877 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 879 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_insert (self, "×10");
#line 880 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number_mode (self, NUMBER_MODE_SUPERSCRIPT);
#line 3371 "math-equation.c"
}


void math_equation_insert_subtract (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
#line 883 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = math_equation_get_number_mode (self);
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == NUMBER_MODE_SUPERSCRIPT) {
#line 3387 "math-equation.c"
		gboolean _tmp3_ = FALSE;
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = self->priv->can_super_minus;
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = _tmp3_;
#line 3393 "math-equation.c"
	} else {
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = FALSE;
#line 3397 "math-equation.c"
	}
#line 885 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 887 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, "⁻");
#line 888 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		self->priv->can_super_minus = FALSE;
#line 3405 "math-equation.c"
	} else {
#line 892 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_insert (self, "−");
#line 893 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
#line 3411 "math-equation.c"
	}
}


static Number* math_equation_parse (MathEquation* self, const gchar* text, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint** error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint* _vala_error_start = NULL;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	MEquation* equation = NULL;
	const gchar* _tmp0_ = NULL;
	MEquation* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	AngleUnit _tmp7_ = 0;
	AngleUnit _tmp8_ = 0;
	guint _tmp9_ = 0U;
	ErrorCode _tmp10_ = 0;
	gchar* _tmp11_ = NULL;
	guint* _tmp12_ = NULL;
	guint* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	guint* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 897 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = text;
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = mequation_new (self, _tmp0_);
#line 899 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	equation = _tmp1_;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = math_equation_get_serializer (self);
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = serializer_get_base (_tmp3_);
#line 900 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((Equation*) equation)->base = _tmp4_;
#line 901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = math_equation_get_word_size (self);
#line 901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_;
#line 901 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((Equation*) equation)->wordlen = _tmp6_;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = math_equation_get_angle_units (self);
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = _tmp7_;
#line 902 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((Equation*) equation)->angle_units = _tmp8_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = equation_parse ((Equation*) equation, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_representation_base = _tmp9_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_error_code = _tmp10_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_vala_error_token);
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_error_token = _tmp11_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_vala_error_start);
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_error_start = _tmp12_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = _tmp13_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_vala_error_end = *_tmp15_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = _tmp14_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp15_);
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp16_;
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (equation);
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (representation_base) {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*representation_base = _vala_representation_base;
#line 3501 "math-equation.c"
	}
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (error_code) {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*error_code = _vala_error_code;
#line 3507 "math-equation.c"
	}
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (error_token) {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*error_token = _vala_error_token;
#line 3513 "math-equation.c"
	} else {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_vala_error_token);
#line 3517 "math-equation.c"
	}
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (error_start) {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*error_start = _vala_error_start;
#line 3523 "math-equation.c"
	} else {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_vala_error_start);
#line 3527 "math-equation.c"
	}
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (error_end) {
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*error_end = _vala_error_end;
#line 3533 "math-equation.c"
	}
#line 904 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 3537 "math-equation.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 3555 "math-equation.c"
}


static void* math_equation_solve_real (MathEquation* self) {
	void* result = NULL;
	SolveData* solvedata = NULL;
	SolveData* _tmp0_ = NULL;
	gchar* text = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint n_brackets = 0;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	guint representation_base = 0U;
	Number* z = NULL;
	const gchar* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	ErrorCode _tmp22_ = 0;
	gchar* _tmp23_ = NULL;
	guint* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	Number* _tmp26_ = NULL;
	guint* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	SolveData* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	ErrorCode _tmp31_ = 0;
	GAsyncQueue* _tmp78_ = NULL;
	SolveData* _tmp79_ = NULL;
	SolveData* _tmp80_ = NULL;
#line 911 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = solve_data_new ();
#line 913 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	solvedata = _tmp0_;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = math_equation_get_equation (self);
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 915 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp2_;
#line 917 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	n_brackets = 0;
#line 3602 "math-equation.c"
	{
		gint i = 0;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = 0;
#line 3607 "math-equation.c"
		{
			gboolean _tmp3_ = FALSE;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp3_ = TRUE;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			while (TRUE) {
#line 3614 "math-equation.c"
				const gchar* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gchar _tmp7_ = '\0';
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gchar _tmp10_ = '\0';
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp3_) {
#line 3623 "math-equation.c"
					gint _tmp4_ = 0;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp4_ = i;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					i = _tmp4_ + 1;
#line 3629 "math-equation.c"
				}
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp3_ = FALSE;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp5_ = text;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp6_ = i;
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp7_ = string_get (_tmp5_, (glong) _tmp6_);
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!(_tmp7_ != '\0')) {
#line 918 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 3643 "math-equation.c"
				}
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp8_ = text;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp9_ = i;
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
#line 920 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp10_ == '(') {
#line 3653 "math-equation.c"
					gint _tmp11_ = 0;
#line 921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp11_ = n_brackets;
#line 921 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					n_brackets = _tmp11_ + 1;
#line 3659 "math-equation.c"
				} else {
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gchar _tmp14_ = '\0';
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp12_ = text;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp13_ = i;
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 922 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					if (_tmp14_ == ')') {
#line 3672 "math-equation.c"
						gint _tmp15_ = 0;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						_tmp15_ = n_brackets;
#line 923 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
						n_brackets = _tmp15_ - 1;
#line 3678 "math-equation.c"
					}
				}
			}
		}
	}
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 3686 "math-equation.c"
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp16_ = n_brackets;
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!(_tmp16_ > 0)) {
#line 925 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3697 "math-equation.c"
		}
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp17_ = text;
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_ = g_strconcat (_tmp17_, ")", NULL);
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (text);
#line 927 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		text = _tmp18_;
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = n_brackets;
#line 928 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		n_brackets = _tmp19_ - 1;
#line 3711 "math-equation.c"
	}
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp20_ = text;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp26_ = math_equation_parse (self, _tmp20_, &_tmp21_, &_tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	representation_base = _tmp21_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	error_code = _tmp22_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (error_token);
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	error_token = _tmp23_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp27_ = _tmp24_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	error_start = *_tmp27_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	error_end = _tmp25_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp28_ = _tmp26_;
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp27_);
#line 934 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	z = _tmp28_;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp29_ = solvedata;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp30_ = representation_base;
#line 935 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp29_->representation_base = _tmp30_;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp31_ = error_code;
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	switch (_tmp31_) {
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_NONE:
#line 3749 "math-equation.c"
		{
			SolveData* _tmp32_ = NULL;
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp32_ = solvedata;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp33_ = z;
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_object_unref0 (_tmp32_->number_result);
#line 939 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp32_->number_result = _tmp34_;
#line 940 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3766 "math-equation.c"
		}
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_OVERFLOW:
#line 3770 "math-equation.c"
		{
			SolveData* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp35_ = solvedata;
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp36_ = _ ("Overflow. Try a bigger word size");
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp37_ = g_strdup (_tmp36_);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp35_->error);
#line 943 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp35_->error = _tmp37_;
#line 945 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3787 "math-equation.c"
		}
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_UNKNOWN_VARIABLE:
#line 3791 "math-equation.c"
		{
			SolveData* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			SolveData* _tmp42_ = NULL;
			guint _tmp43_ = 0U;
			SolveData* _tmp44_ = NULL;
			guint _tmp45_ = 0U;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp38_ = solvedata;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp39_ = _ ("Unknown variable '%s'");
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp40_ = error_token;
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp41_ = g_strdup_printf (_tmp39_, _tmp40_);
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp38_->error);
#line 948 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp38_->error = _tmp41_;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp42_ = solvedata;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp43_ = error_start;
#line 950 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp42_->error_start = _tmp43_;
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp44_ = solvedata;
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp45_ = error_end;
#line 951 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp44_->error_end = _tmp45_;
#line 952 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3827 "math-equation.c"
		}
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_UNKNOWN_FUNCTION:
#line 3831 "math-equation.c"
		{
			SolveData* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			SolveData* _tmp50_ = NULL;
			guint _tmp51_ = 0U;
			SolveData* _tmp52_ = NULL;
			guint _tmp53_ = 0U;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp46_ = solvedata;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp47_ = _ ("Function '%s' is not defined");
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp48_ = error_token;
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp49_ = g_strdup_printf (_tmp47_, _tmp48_);
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp46_->error);
#line 955 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp46_->error = _tmp49_;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp50_ = solvedata;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp51_ = error_start;
#line 957 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp50_->error_start = _tmp51_;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp52_ = solvedata;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp53_ = error_end;
#line 958 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp52_->error_end = _tmp53_;
#line 959 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3867 "math-equation.c"
		}
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_UNKNOWN_CONVERSION:
#line 3871 "math-equation.c"
		{
			SolveData* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp54_ = solvedata;
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp55_ = _ ("Unknown conversion");
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp56_ = g_strdup (_tmp55_);
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp54_->error);
#line 962 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp54_->error = _tmp56_;
#line 964 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3888 "math-equation.c"
		}
#line 936 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case ERROR_CODE_MP:
#line 3892 "math-equation.c"
		{
			const gchar* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp57_ = number_get_error ();
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp58_ = _tmp57_;
#line 967 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp58_ != NULL) {
#line 3902 "math-equation.c"
				SolveData* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				gchar* _tmp62_ = NULL;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp59_ = solvedata;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp60_ = number_get_error ();
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp61_ = _tmp60_;
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp62_ = g_strdup (_tmp61_);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp59_->error);
#line 969 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp59_->error = _tmp62_;
#line 3919 "math-equation.c"
			} else {
				const gchar* _tmp63_ = NULL;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp63_ = error_token;
#line 971 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp63_ != NULL) {
#line 3926 "math-equation.c"
					SolveData* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					SolveData* _tmp68_ = NULL;
					guint _tmp69_ = 0U;
					SolveData* _tmp70_ = NULL;
					guint _tmp71_ = 0U;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp64_ = solvedata;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp65_ = _ ("%s");
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp66_ = error_token;
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp67_ = g_strdup_printf (_tmp65_, _tmp66_);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_g_free0 (_tmp64_->error);
#line 973 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp64_->error = _tmp67_;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp68_ = solvedata;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp69_ = error_start;
#line 974 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp68_->error_start = _tmp69_;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp70_ = solvedata;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp71_ = error_end;
#line 975 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp70_->error_end = _tmp71_;
#line 3959 "math-equation.c"
				} else {
					SolveData* _tmp72_ = NULL;
					const gchar* _tmp73_ = NULL;
					gchar* _tmp74_ = NULL;
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp72_ = solvedata;
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp73_ = _ ("Malformed expression");
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp74_ = g_strdup (_tmp73_);
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_g_free0 (_tmp72_->error);
#line 978 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp72_->error = _tmp74_;
#line 3974 "math-equation.c"
				}
			}
#line 979 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3979 "math-equation.c"
		}
		default:
		{
			SolveData* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gchar* _tmp77_ = NULL;
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp75_ = solvedata;
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp76_ = _ ("Malformed expression");
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp77_ = g_strdup (_tmp76_);
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp75_->error);
#line 982 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp75_->error = _tmp77_;
#line 984 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 3998 "math-equation.c"
		}
	}
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp78_ = self->priv->queue;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp79_ = solvedata;
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp80_ = _g_object_ref0 (_tmp79_);
#line 986 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_async_queue_push (_tmp78_, _tmp80_);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = NULL;
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (z);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (error_token);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (solvedata);
#line 988 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4021 "math-equation.c"
}


static gboolean math_equation_show_in_progress (MathEquation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 991 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_in_solve (self);
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 993 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 4037 "math-equation.c"
		const gchar* _tmp2_ = NULL;
#line 994 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = _ ("Calculating");
#line 994 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp2_);
#line 4043 "math-equation.c"
	}
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = FALSE;
#line 995 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4049 "math-equation.c"
}


static gboolean math_equation_look_for_answer (MathEquation* self) {
	gboolean result = FALSE;
	SolveData* _result_ = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	SolveData* _tmp2_ = NULL;
	SolveData* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	SolveData* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 998 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->queue;
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_async_queue_try_pop (_tmp0_);
#line 1000 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_result_ = (SolveData*) _tmp1_;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _result_;
#line 1002 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == NULL) {
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = TRUE;
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (_result_);
#line 1003 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 4081 "math-equation.c"
	}
#line 1005 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_in_solve = FALSE;
#line 1007 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _result_;
#line 1007 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _tmp3_->error;
#line 1007 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp4_ == NULL) {
#line 1008 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, "");
#line 4093 "math-equation.c"
	}
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _result_;
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_->error;
#line 1010 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp6_ != NULL) {
#line 4101 "math-equation.c"
		SolveData* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		MathEquationState* _tmp9_ = NULL;
		SolveData* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		MathEquationState* _tmp12_ = NULL;
		SolveData* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = _result_;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _tmp7_->error;
#line 1012 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp8_);
#line 1013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = self->priv->state;
#line 1013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = _result_;
#line 1013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = _tmp10_->error_start;
#line 1013 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_->error_token_start = _tmp11_;
#line 1014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp12_ = self->priv->state;
#line 1014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = _result_;
#line 1014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = _tmp13_->error_end;
#line 1014 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp12_->error_token_end = _tmp14_;
#line 1017 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_error_token_fix_thousands_separator (self);
#line 1019 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_error_token_fix_parenthesis (self);
#line 1022 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_object_notify ((GObject*) self, "error-token-end");
#line 4138 "math-equation.c"
	} else {
		SolveData* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = _result_;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp16_ = _tmp15_->number_result;
#line 1024 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp16_ != NULL) {
#line 4148 "math-equation.c"
			SolveData* _tmp17_ = NULL;
			Number* _tmp18_ = NULL;
			SolveData* _tmp19_ = NULL;
			guint _tmp20_ = 0U;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp17_ = _result_;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp18_ = _tmp17_->number_result;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp19_ = _result_;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp20_ = _tmp19_->representation_base;
#line 1025 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			math_equation_set_number (self, _tmp18_, _tmp20_);
#line 4163 "math-equation.c"
		} else {
			SolveData* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp21_ = _result_;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp22_ = _tmp21_->text_result;
#line 1026 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp22_ != NULL) {
#line 4173 "math-equation.c"
				SolveData* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp23_ = _result_;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp24_ = _tmp23_->text_result;
#line 1027 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				math_equation_set (self, _tmp24_);
#line 4182 "math-equation.c"
			}
		}
	}
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = FALSE;
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_result_);
#line 1029 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4192 "math-equation.c"
}


static gpointer _math_equation_solve_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_solve_real ((MathEquation*) self);
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_unref (self);
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4203 "math-equation.c"
}


static gboolean _math_equation_look_for_answer_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_look_for_answer ((MathEquation*) self);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4212 "math-equation.c"
}


static gboolean _math_equation_show_in_progress_gsource_func (gpointer self) {
	gboolean result;
	result = math_equation_show_in_progress ((MathEquation*) self);
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 4221 "math-equation.c"
}


void math_equation_solve (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GThread* _tmp6_ = NULL;
	GThread* _tmp7_ = NULL;
#line 1032 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_in_solve (self);
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1035 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 1036 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 4244 "math-equation.c"
	}
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = math_equation_get_is_empty (self);
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 1038 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_) {
#line 1039 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 4254 "math-equation.c"
	}
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_is_result (self);
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 1043 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp5_) {
#line 1045 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_source_buffer_undo ((GtkSourceBuffer*) self);
#line 1046 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 4266 "math-equation.c"
	}
#line 1049 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_in_solve = TRUE;
#line 1051 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = g_thread_new ("", _math_equation_solve_real_gthread_func, g_object_ref (self));
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = _tmp6_;
#line 1053 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_thread_unref0 (_tmp7_);
#line 1055 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
#line 1056 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
#line 4282 "math-equation.c"
}


static void math_equation_error_token_fix_thousands_separator (MathEquation* self) {
	GtkTextIter start = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter temp = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gchar* str = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	gunichar _tmp9_ = 0U;
	gchar* _tmp10_ = NULL;
	gint length = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTextIter _tmp27_ = {0};
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
#line 1063 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	start = _tmp0_;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = start;
#line 1064 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	temp = _tmp1_;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = start;
#line 1065 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	end = _tmp2_;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = math_equation_get_error_token_start (self);
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _tmp3_;
#line 1067 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_iter_set_offset (&start, (gint) _tmp4_);
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = math_equation_get_error_token_end (self);
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_;
#line 1068 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_iter_set_offset (&end, (gint) _tmp6_);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = math_equation_get_serializer (self);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = _tmp7_;
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = serializer_get_thousands_separator (_tmp8_);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = g_unichar_to_string (_tmp9_);
#line 1070 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	str = _tmp10_;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = str;
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = g_utf8_strlen (_tmp11_, (gssize) (-1));
#line 1071 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	length = _tmp12_;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 4350 "math-equation.c"
		const gchar* _tmp13_ = NULL;
		GtkTextIter _tmp14_ = {0};
		GtkTextIter _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		MathEquationState* _tmp17_ = NULL;
		MathEquationState* _tmp18_ = NULL;
		guint _tmp19_ = 0U;
		gint _tmp20_ = 0;
		MathEquationState* _tmp21_ = NULL;
		MathEquationState* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = str;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = start;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp16_ = gtk_text_iter_forward_search (&temp, _tmp13_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp15_, &_tmp14_);
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		temp = _tmp15_;
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp16_) {
#line 1074 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 4377 "math-equation.c"
		}
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp17_ = self->priv->state;
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_ = self->priv->state;
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = _tmp18_->error_token_start;
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp20_ = length;
#line 1076 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_->error_token_start = _tmp19_ + _tmp20_;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp21_ = self->priv->state;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp22_ = self->priv->state;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp23_ = _tmp22_->error_token_end;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp24_ = length;
#line 1077 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp22_->error_token_end = _tmp23_ + _tmp24_;
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp25_ = length;
#line 1078 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_iter_forward_chars (&start, _tmp25_);
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp26_ = length;
#line 1079 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_iter_forward_chars (&start, _tmp26_);
#line 4407 "math-equation.c"
	}
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp27_ = start;
#line 1083 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	temp = _tmp27_;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 4415 "math-equation.c"
		const gchar* _tmp28_ = NULL;
		GtkTextIter _tmp29_ = {0};
		GtkTextIter _tmp30_ = {0};
		gboolean _tmp31_ = FALSE;
		MathEquationState* _tmp32_ = NULL;
		MathEquationState* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = str;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = end;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp31_ = gtk_text_iter_forward_search (&temp, _tmp28_, GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp30_, &_tmp29_);
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		temp = _tmp30_;
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp31_) {
#line 1084 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 4437 "math-equation.c"
		}
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp32_ = self->priv->state;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp33_ = self->priv->state;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp34_ = _tmp33_->error_token_end;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp35_ = length;
#line 1086 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp33_->error_token_end = _tmp34_ + _tmp35_;
#line 1087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp36_ = length;
#line 1087 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_iter_forward_chars (&end, _tmp36_);
#line 4453 "math-equation.c"
	}
#line 1060 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (str);
#line 4457 "math-equation.c"
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
#line 1046 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1047 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = c;
#line 1047 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
#line 1047 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = (gint) (_tmp1_ - ((gchar*) self));
#line 1047 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 4475 "math-equation.c"
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1055 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (0 < _tmp0_) {
#line 4489 "math-equation.c"
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = *index;
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
#line 1056 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp2_ - ((gchar*) self));
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
#line 1057 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_vala_c = _tmp4_;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 4512 "math-equation.c"
		}
#line 1058 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4516 "math-equation.c"
	} else {
#line 1060 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		if (c) {
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 4526 "math-equation.c"
		}
#line 1061 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 4530 "math-equation.c"
	}
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (c) {
#line 1054 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 4536 "math-equation.c"
	}
}


static void math_equation_error_token_fix_parenthesis (MathEquation* self) {
	gunichar c = 0U;
	gint count = 0;
	gint real_end = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint real_start = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	guint _tmp72_ = 0U;
	guint _tmp73_ = 0U;
	gint _tmp74_ = 0;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_ = NULL;
	guint _tmp78_ = 0U;
	guint _tmp79_ = 0U;
	gint _tmp80_ = 0;
	gunichar d = 0U;
#line 1092 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1095 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	count = 0;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_display (self);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = math_equation_get_error_token_end (self);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = _tmp3_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = string_index_of_nth_char (_tmp2_, (glong) _tmp4_);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_;
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp2_);
#line 1096 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	real_end = _tmp6_;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = math_equation_get_display (self);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = _tmp7_;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = _tmp8_;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = math_equation_get_error_token_start (self);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = _tmp10_;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = string_index_of_nth_char (_tmp9_, (glong) _tmp11_);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = _tmp12_;
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp9_);
#line 1097 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	real_start = _tmp13_;
#line 4613 "math-equation.c"
	{
		gint i = 0;
		gint _tmp14_ = 0;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = real_start;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = _tmp14_;
#line 4621 "math-equation.c"
		{
			gboolean _tmp15_ = FALSE;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp15_ = TRUE;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			while (TRUE) {
#line 4628 "math-equation.c"
				gboolean _tmp16_ = FALSE;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gunichar _tmp20_ = 0U;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gunichar _tmp25_ = 0U;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
				gboolean _tmp28_ = FALSE;
				gunichar _tmp30_ = 0U;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				gboolean _tmp33_ = FALSE;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp15_) {
#line 4646 "math-equation.c"
				}
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp15_ = FALSE;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp17_ = math_equation_get_display (self);
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp18_ = _tmp17_;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp19_ = _tmp18_;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp21_ = string_get_next_char (_tmp19_, &i, &_tmp20_);
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				c = _tmp20_;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp22_ = _tmp21_;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp19_);
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp22_) {
#line 4666 "math-equation.c"
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp23_ = i;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp24_ = real_end;
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp16_ = _tmp23_ <= _tmp24_;
#line 4675 "math-equation.c"
				} else {
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp16_ = FALSE;
#line 4679 "math-equation.c"
				}
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp16_) {
#line 1100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 4685 "math-equation.c"
				}
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp25_ = c;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp26_ = g_unichar_to_string (_tmp25_);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp27_ = _tmp26_;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp28_ = g_strcmp0 (_tmp27_, "(") == 0;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp27_);
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp28_) {
#line 4699 "math-equation.c"
					gint _tmp29_ = 0;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp29_ = count;
#line 1102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					count = _tmp29_ + 1;
#line 4705 "math-equation.c"
				}
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp30_ = c;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp31_ = g_unichar_to_string (_tmp30_);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp32_ = _tmp31_;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp33_ = g_strcmp0 (_tmp32_, ")") == 0;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp32_);
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp33_) {
#line 4719 "math-equation.c"
					gint _tmp34_ = 0;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp34_ = count;
#line 1103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					count = _tmp34_ - 1;
#line 4725 "math-equation.c"
				}
			}
		}
	}
	{
		gint i = 0;
		gint _tmp35_ = 0;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp35_ = real_end;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = _tmp35_;
#line 4737 "math-equation.c"
		{
			gboolean _tmp36_ = FALSE;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp36_ = TRUE;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			while (TRUE) {
#line 4744 "math-equation.c"
				gboolean _tmp37_ = FALSE;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gunichar _tmp41_ = 0U;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gunichar _tmp45_ = 0U;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gboolean _tmp48_ = FALSE;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp36_) {
#line 4758 "math-equation.c"
				}
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp36_ = FALSE;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp38_ = math_equation_get_display (self);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp39_ = _tmp38_;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp40_ = _tmp39_;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp42_ = string_get_next_char (_tmp40_, &i, &_tmp41_);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				c = _tmp41_;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp43_ = _tmp42_;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp40_);
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp43_) {
#line 4778 "math-equation.c"
					gint _tmp44_ = 0;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp44_ = count;
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp37_ = _tmp44_ > 0;
#line 4784 "math-equation.c"
				} else {
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp37_ = FALSE;
#line 4788 "math-equation.c"
				}
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp37_) {
#line 1108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 4794 "math-equation.c"
				}
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp45_ = c;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp46_ = g_unichar_to_string (_tmp45_);
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp47_ = _tmp46_;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp48_ = g_strcmp0 (_tmp47_, ")") == 0;
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp47_);
#line 1110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp48_) {
#line 4808 "math-equation.c"
					MathEquationState* _tmp49_ = NULL;
					guint _tmp50_ = 0U;
					gint _tmp51_ = 0;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp49_ = self->priv->state;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp50_ = _tmp49_->error_token_end;
#line 1112 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp49_->error_token_end = _tmp50_ + 1;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp51_ = count;
#line 1113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					count = _tmp51_ - 1;
#line 4822 "math-equation.c"
				} else {
#line 1117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 4826 "math-equation.c"
				}
			}
		}
	}
	{
		gint i = 0;
		gint _tmp52_ = 0;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp52_ = real_start;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = _tmp52_;
#line 4838 "math-equation.c"
		{
			gboolean _tmp53_ = FALSE;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp53_ = TRUE;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			while (TRUE) {
#line 4845 "math-equation.c"
				gboolean _tmp54_ = FALSE;
				gchar* _tmp55_ = NULL;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gunichar _tmp58_ = 0U;
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				gunichar _tmp62_ = 0U;
				gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				gboolean _tmp65_ = FALSE;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp53_) {
#line 4859 "math-equation.c"
				}
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp53_ = FALSE;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp55_ = math_equation_get_display (self);
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp56_ = _tmp55_;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp57_ = _tmp56_;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp59_ = string_get_prev_char (_tmp57_, &i, &_tmp58_);
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				c = _tmp58_;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp60_ = _tmp59_;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp57_);
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp60_) {
#line 4879 "math-equation.c"
					gint _tmp61_ = 0;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp61_ = count;
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp54_ = _tmp61_ < 0;
#line 4885 "math-equation.c"
				} else {
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp54_ = FALSE;
#line 4889 "math-equation.c"
				}
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (!_tmp54_) {
#line 1122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 4895 "math-equation.c"
				}
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp62_ = c;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp63_ = g_unichar_to_string (_tmp62_);
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp64_ = _tmp63_;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp65_ = g_strcmp0 (_tmp64_, "(") == 0;
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp64_);
#line 1124 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp65_) {
#line 4909 "math-equation.c"
					MathEquationState* _tmp66_ = NULL;
					guint _tmp67_ = 0U;
					gint _tmp68_ = 0;
#line 1126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp66_ = self->priv->state;
#line 1126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp67_ = _tmp66_->error_token_start;
#line 1126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp66_->error_token_start = _tmp67_ - 1;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp68_ = count;
#line 1127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					count = _tmp68_ + 1;
#line 4923 "math-equation.c"
				} else {
#line 1131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					break;
#line 4927 "math-equation.c"
				}
			}
		}
	}
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp69_ = math_equation_get_display (self);
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp70_ = _tmp69_;
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp71_ = _tmp70_;
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp72_ = math_equation_get_error_token_end (self);
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp73_ = _tmp72_;
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp74_ = string_index_of_nth_char (_tmp71_, (glong) _tmp73_);
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	real_end = _tmp74_;
#line 1135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp71_);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp75_ = math_equation_get_display (self);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp76_ = _tmp75_;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp77_ = _tmp76_;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp78_ = math_equation_get_error_token_start (self);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp79_ = _tmp78_;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp80_ = string_index_of_nth_char (_tmp77_, (glong) _tmp79_);
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	real_start = _tmp80_;
#line 1136 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp77_);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 4966 "math-equation.c"
		gboolean _tmp81_ = FALSE;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gunichar _tmp85_ = 0U;
		gboolean _tmp86_ = FALSE;
		gboolean _tmp87_ = FALSE;
		gboolean _tmp93_ = FALSE;
		gunichar _tmp94_ = 0U;
		gchar* _tmp95_ = NULL;
		gchar* _tmp96_ = NULL;
		gboolean _tmp97_ = FALSE;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp82_ = math_equation_get_display (self);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp83_ = _tmp82_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp84_ = _tmp83_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp86_ = string_get_next_char (_tmp84_, &real_end, &_tmp85_);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		d = _tmp85_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp87_ = _tmp86_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_tmp84_);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp87_) {
#line 4995 "math-equation.c"
			gchar* _tmp88_ = NULL;
			gchar* _tmp89_ = NULL;
			gchar* _tmp90_ = NULL;
			gunichar _tmp91_ = 0U;
			gboolean _tmp92_ = FALSE;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp88_ = math_equation_get_display (self);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp89_ = _tmp88_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp90_ = _tmp89_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp92_ = string_get_prev_char (_tmp90_, &real_start, &_tmp91_);
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			c = _tmp91_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp81_ = _tmp92_;
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp90_);
#line 5015 "math-equation.c"
		} else {
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp81_ = FALSE;
#line 5019 "math-equation.c"
		}
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp81_) {
#line 1141 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 5025 "math-equation.c"
		}
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp94_ = c;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp95_ = g_unichar_to_string (_tmp94_);
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp96_ = _tmp95_;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp97_ = g_strcmp0 (_tmp96_, "(") == 0;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_tmp96_);
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp97_) {
#line 5039 "math-equation.c"
			gunichar _tmp98_ = 0U;
			gchar* _tmp99_ = NULL;
			gchar* _tmp100_ = NULL;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp98_ = d;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp99_ = g_unichar_to_string (_tmp98_);
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp100_ = _tmp99_;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp93_ = g_strcmp0 (_tmp100_, ")") == 0;
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (_tmp100_);
#line 5053 "math-equation.c"
		} else {
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp93_ = FALSE;
#line 5057 "math-equation.c"
		}
#line 1143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp93_) {
#line 5061 "math-equation.c"
			MathEquationState* _tmp101_ = NULL;
			guint _tmp102_ = 0U;
			MathEquationState* _tmp103_ = NULL;
			guint _tmp104_ = 0U;
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp101_ = self->priv->state;
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp102_ = _tmp101_->error_token_start;
#line 1145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp101_->error_token_start = _tmp102_ - 1;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp103_ = self->priv->state;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp104_ = _tmp103_->error_token_end;
#line 1146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp103_->error_token_end = _tmp104_ + 1;
#line 5078 "math-equation.c"
		} else {
#line 1150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 5082 "math-equation.c"
		}
	}
}


static void* math_equation_factorize_real (MathEquation* self) {
	void* result = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	GList* factors = NULL;
	Number* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gchar* text = NULL;
	gchar* _tmp4_ = NULL;
	gint i = 0;
	GList* _tmp5_ = NULL;
	SolveData* _result_ = NULL;
	SolveData* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GAsyncQueue* _tmp21_ = NULL;
	SolveData* _tmp22_ = NULL;
#line 1155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_number (self);
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1157 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	x = _tmp1_;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = x;
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = number_factorize (_tmp2_);
#line 1158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	factors = _tmp3_;
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = g_strdup ("");
#line 1160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp4_;
#line 1161 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	i = 0;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = factors;
#line 5128 "math-equation.c"
	{
		GList* factor_collection = NULL;
		GList* factor_it = NULL;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		factor_collection = _tmp5_;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		for (factor_it = factor_collection; factor_it != NULL; factor_it = factor_it->next) {
#line 5136 "math-equation.c"
			Number* _tmp6_ = NULL;
			Number* factor = NULL;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp6_ = _g_object_ref0 ((Number*) factor_it->data);
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			factor = _tmp6_;
#line 5143 "math-equation.c"
			{
				gint _tmp7_ = 0;
				const gchar* _tmp10_ = NULL;
				Serializer* _tmp11_ = NULL;
				Serializer* _tmp12_ = NULL;
				Number* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gint _tmp17_ = 0;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp7_ = i;
#line 1164 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp7_ != 0) {
#line 5158 "math-equation.c"
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp8_ = text;
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp9_ = g_strconcat (_tmp8_, "×", NULL);
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_g_free0 (text);
#line 1165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					text = _tmp9_;
#line 5169 "math-equation.c"
				}
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp10_ = text;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp11_ = math_equation_get_serializer (self);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp12_ = _tmp11_;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp13_ = factor;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp14_ = serializer_to_string (_tmp12_, _tmp13_);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp15_ = _tmp14_;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp16_ = g_strconcat (_tmp10_, _tmp15_, NULL);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (text);
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				text = _tmp16_;
#line 1166 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp15_);
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp17_ = i;
#line 1167 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				i = _tmp17_ + 1;
#line 1162 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_object_unref0 (factor);
#line 5197 "math-equation.c"
			}
		}
	}
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp18_ = solve_data_new ();
#line 1170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_result_ = _tmp18_;
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp19_ = text;
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_result_->text_result);
#line 1171 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_result_->text_result = _tmp20_;
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp21_ = self->priv->queue;
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp22_ = _g_object_ref0 (_result_);
#line 1172 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_async_queue_push (_tmp21_, _tmp22_);
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = NULL;
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_result_);
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (factors);
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (x);
#line 1174 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 5231 "math-equation.c"
}


static gpointer _math_equation_factorize_real_gthread_func (gpointer self) {
	gpointer result;
	result = math_equation_factorize_real ((MathEquation*) self);
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_unref (self);
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 5242 "math-equation.c"
}


void math_equation_factorize (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* x = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_ = NULL;
	GThread* _tmp9_ = NULL;
	GThread* _tmp10_ = NULL;
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_in_solve (self);
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 1181 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5266 "math-equation.c"
	}
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = math_equation_get_number (self);
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 1183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	x = _tmp3_;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = x;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp5_ == NULL) {
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = TRUE;
#line 5280 "math-equation.c"
	} else {
		Number* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = x;
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = number_is_integer (_tmp6_);
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = !_tmp7_;
#line 5290 "math-equation.c"
	}
#line 1184 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp4_) {
#line 5294 "math-equation.c"
		const gchar* _tmp8_ = NULL;
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _ ("Need an integer to factorize");
#line 1187 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp8_);
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (x);
#line 1188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5304 "math-equation.c"
	}
#line 1191 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_in_solve = TRUE;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = g_thread_new ("", _math_equation_factorize_real_gthread_func, g_object_ref (self));
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = _tmp9_;
#line 1193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_thread_unref0 (_tmp10_);
#line 1195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _math_equation_look_for_answer_gsource_func, g_object_ref (self), g_object_unref);
#line 1196 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _math_equation_show_in_progress_gsource_func, g_object_ref (self), g_object_unref);
#line 1177 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (x);
#line 5320 "math-equation.c"
}


void math_equation_delete_next (MathEquation* self) {
	gint cursor = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	gint _tmp2_ = 0;
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkTextIter _tmp5_ = {0};
#line 1199 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1202 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = cursor;
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
#line 1203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ >= _tmp1_) {
#line 1204 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5346 "math-equation.c"
	}
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = cursor;
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
#line 1207 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	start = _tmp3_;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = cursor;
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_offset ((GtkTextBuffer*) self, &_tmp5_, _tmp4_ + 1);
#line 1208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	end = _tmp5_;
#line 1209 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 5362 "math-equation.c"
}


void math_equation_backspace (MathEquation* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 1212 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_is_empty (self);
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 1216 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5381 "math-equation.c"
	}
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = _tmp2_;
#line 1218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_) {
#line 1219 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_delete_selection ((GtkTextBuffer*) self, FALSE, FALSE);
#line 5391 "math-equation.c"
	} else {
		GtkTextIter iter = {0};
		GtkTextMark* _tmp4_ = NULL;
		GtkTextIter _tmp5_ = {0};
		GtkTextIter _tmp6_ = {0};
#line 1223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
#line 1223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
#line 1223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		iter = _tmp5_;
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = iter;
#line 1224 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_backspace (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_buffer_get_type ()) ? ((GtkTextBuffer*) self) : NULL, &_tmp6_, TRUE, TRUE);
#line 5407 "math-equation.c"
	}
}


void math_equation_clear (MathEquation* self) {
#line 1228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number_mode (self, NUMBER_MODE_NORMAL);
#line 1231 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
#line 1232 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_clear_ans (self, FALSE);
#line 5421 "math-equation.c"
}


void math_equation_shift (MathEquation* self, gint count) {
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_number (self);
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1237 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	z = _tmp1_;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = z;
#line 1238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == NULL) {
#line 5446 "math-equation.c"
		const gchar* _tmp3_ = NULL;
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = _ ("No sane value to bitwise shift");
#line 1241 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp3_);
#line 1242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (z);
#line 1242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5456 "math-equation.c"
	}
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = z;
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = count;
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = number_shift (_tmp4_, _tmp5_);
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = _tmp6_;
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number (self, _tmp7_, (guint) 0);
#line 1245 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp7_);
#line 1235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (z);
#line 5472 "math-equation.c"
}


void math_equation_toggle_bit (MathEquation* self, guint bit) {
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* max = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_ = NULL;
	guint64 bits = 0ULL;
	Number* _tmp12_ = NULL;
	guint64 _tmp13_ = 0ULL;
	guint64 _tmp14_ = 0ULL;
	guint _tmp15_ = 0U;
	guint64 _tmp16_ = 0ULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_number (self);
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1250 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	x = _tmp1_;
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = number_new_unsigned_integer (G_MAXUINT64);
#line 1251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	max = _tmp2_;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = x;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp5_ == NULL) {
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = TRUE;
#line 5511 "math-equation.c"
	} else {
		Number* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = x;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = number_is_negative (_tmp6_);
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = _tmp7_;
#line 5521 "math-equation.c"
	}
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp4_) {
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = TRUE;
#line 5527 "math-equation.c"
	} else {
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = x;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = max;
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = number_compare (_tmp8_, _tmp9_);
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = _tmp10_ > 0;
#line 5540 "math-equation.c"
	}
#line 1252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_) {
#line 5544 "math-equation.c"
		const gchar* _tmp11_ = NULL;
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = _ ("Displayed value not an integer");
#line 1255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, _tmp11_);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (max);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_object_unref0 (x);
#line 1256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5556 "math-equation.c"
	}
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = x;
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = number_to_unsigned_integer (_tmp12_);
#line 1259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	bits = _tmp13_;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = bits;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = bit;
#line 1260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	bits = _tmp14_ ^ (1LL << (63 - _tmp15_));
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp16_ = bits;
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp17_ = number_new_unsigned_integer (_tmp16_);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (x);
#line 1261 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	x = _tmp17_;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp18_ = x;
#line 1264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_set_number (self, _tmp18_, (guint) 0);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (max);
#line 1248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (x);
#line 5586 "math-equation.c"
}


static void math_equation_real_insert_text (GtkTextBuffer* base, GtkTextIter* location, const gchar* text, gint len) {
	MathEquation * self;
	gboolean _tmp0_ = FALSE;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextMark* _tmp4_ = NULL;
	GtkTextMark* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gunichar c = 0U;
	const gchar* _tmp7_ = NULL;
	gunichar _tmp8_ = 0U;
	gint cursor = 0;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gunichar _tmp12_ = 0U;
	gboolean _tmp13_ = FALSE;
	GtkTextMark* _tmp23_ = NULL;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	MathEquationState* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	GtkTextMark* _tmp36_ = NULL;
	GtkTextIter _tmp37_ = {0};
	GtkTextMark* _tmp38_ = NULL;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquation*) base;
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (location != NULL);
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (text != NULL);
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->in_reformat;
#line 1269 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 5625 "math-equation.c"
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = text;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = len;
#line 1271 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, _tmp1_, _tmp2_);
#line 1272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5636 "math-equation.c"
	}
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = *location;
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self, NULL, &_tmp3_, FALSE);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 1275 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	mark = _tmp5_;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = self->priv->in_delete;
#line 1278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (!_tmp6_) {
#line 1279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_push_undo_stack (self);
#line 5652 "math-equation.c"
	}
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = text;
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = string_get_char (_tmp7_, (glong) 0);
#line 1282 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	c = _tmp8_;
#line 1284 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_get ((GObject*) self, "cursor-position", &cursor, NULL, NULL);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = c;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = g_unichar_isdigit (_tmp12_);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp13_) {
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = TRUE;
#line 5670 "math-equation.c"
	} else {
		gunichar _tmp14_ = 0U;
		Serializer* _tmp15_ = NULL;
		Serializer* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = c;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = math_equation_get_serializer (self);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp16_ = _tmp15_;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp17_ = serializer_get_radix (_tmp16_);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = _tmp14_ == _tmp17_;
#line 5686 "math-equation.c"
	}
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp11_) {
#line 5690 "math-equation.c"
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_ = math_equation_get_is_result (self);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = _tmp18_;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = _tmp19_;
#line 5699 "math-equation.c"
	} else {
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = FALSE;
#line 5703 "math-equation.c"
	}
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp10_) {
#line 5707 "math-equation.c"
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp20_ = cursor;
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp21_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = _tmp20_ >= _tmp21_;
#line 5716 "math-equation.c"
	} else {
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = FALSE;
#line 5720 "math-equation.c"
	}
#line 1285 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp9_) {
#line 5724 "math-equation.c"
		GtkTextIter _tmp22_ = {0};
#line 1287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_set_text ((GtkTextBuffer*) self, "", -1);
#line 1288 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_clear_ans (self, FALSE);
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp22_);
#line 1289 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		*location = _tmp22_;
#line 5734 "math-equation.c"
	}
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp23_ = self->priv->ans_start_mark;
#line 1292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp23_ != NULL) {
#line 5740 "math-equation.c"
		gint offset = 0;
		gint _tmp24_ = 0;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gboolean _tmp27_ = FALSE;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp24_ = gtk_text_iter_get_offset (location);
#line 1294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		offset = _tmp24_;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_get_ans_offsets (self, &_tmp25_, &_tmp26_);
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp25_;
#line 1296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp26_;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = offset;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = ans_start;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp28_ > _tmp29_) {
#line 5766 "math-equation.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp30_ = offset;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp31_ = ans_end;
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = _tmp30_ < _tmp31_;
#line 5775 "math-equation.c"
		} else {
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = FALSE;
#line 5779 "math-equation.c"
		}
#line 1299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp27_) {
#line 1300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			math_equation_clear_ans (self, TRUE);
#line 5785 "math-equation.c"
		}
	}
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp32_ = text;
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp33_ = len;
#line 1303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->insert_text ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), location, _tmp32_, _tmp33_);
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp34_ = self->priv->state;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp35_ = text;
#line 1305 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp34_->entered_multiply = g_strcmp0 (_tmp35_, "×") == 0;
#line 1308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_separators (self);
#line 1309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp36_ = mark;
#line 1309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp37_, _tmp36_);
#line 1309 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	*location = _tmp37_;
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp38_ = mark;
#line 1311 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) self, _tmp38_);
#line 1313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject*) self, "display");
#line 1267 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (mark);
#line 5816 "math-equation.c"
}


static gboolean __lambda10_ (MathEquation* self) {
	gboolean result = FALSE;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_delete = FALSE;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = FALSE;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 5828 "math-equation.c"
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ ((MathEquation*) self);
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 5837 "math-equation.c"
}


static void math_equation_real_delete_range (GtkTextBuffer* base, GtkTextIter* start, GtkTextIter* end) {
	MathEquation * self;
	gboolean _tmp0_ = FALSE;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter _tmp13_ = {0};
	GtkTextIter _tmp14_ = {0};
	MathEquationState* _tmp15_ = NULL;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MathEquation*) base;
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (start != NULL);
#line 1316 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (end != NULL);
#line 1318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->in_reformat;
#line 1318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 5858 "math-equation.c"
		GtkTextIter _tmp1_ = {0};
		GtkTextIter _tmp2_ = {0};
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp1_ = *start;
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = *end;
#line 1320 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp1_, &_tmp2_);
#line 1321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5869 "math-equation.c"
	}
#line 1324 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_push_undo_stack (self);
#line 1326 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->in_delete = TRUE;
#line 1327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, g_object_ref (self), g_object_unref);
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = self->priv->ans_start_mark;
#line 1329 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ != NULL) {
#line 5881 "math-equation.c"
		gint start_offset = 0;
		gint _tmp4_ = 0;
		gint end_offset = 0;
		gint _tmp5_ = 0;
		gint ans_start = 0;
		gint ans_end = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = gtk_text_iter_get_offset (start);
#line 1331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		start_offset = _tmp4_;
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = gtk_text_iter_get_offset (end);
#line 1332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		end_offset = _tmp5_;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_get_ans_offsets (self, &_tmp6_, &_tmp7_);
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp6_;
#line 1334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp7_;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = start_offset;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = ans_end;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp9_ < _tmp10_) {
#line 5913 "math-equation.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp11_ = end_offset;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp12_ = ans_start;
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = _tmp11_ > _tmp12_;
#line 5922 "math-equation.c"
		} else {
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = FALSE;
#line 5926 "math-equation.c"
		}
#line 1337 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp8_) {
#line 1338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			math_equation_clear_ans (self, TRUE);
#line 5932 "math-equation.c"
		}
	}
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = *start;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = *end;
#line 1341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	GTK_TEXT_BUFFER_CLASS (math_equation_parent_class)->delete_range ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), &_tmp13_, &_tmp14_);
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_ = self->priv->state;
#line 1343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp15_->entered_multiply = FALSE;
#line 1346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_separators (self);
#line 1349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject*) self, "display");
#line 5949 "math-equation.c"
}


gint math_equation_get_word_size (MathEquation* self) {
	gint result;
	gint _tmp0_ = 0;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_word_size;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 5964 "math-equation.c"
}


void math_equation_set_word_size (MathEquation* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_word_size;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == _tmp1_) {
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 5982 "math-equation.c"
	}
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_word_size = _tmp2_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "word-size");
#line 5990 "math-equation.c"
}


gchar* math_equation_get_source_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_source_currency;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp1_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6008 "math-equation.c"
}


void math_equation_set_source_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_source_currency;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6027 "math-equation.c"
	}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_source_currency);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_source_currency = _tmp3_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "source-currency");
#line 6039 "math-equation.c"
}


gchar* math_equation_get_target_currency (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_target_currency;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp1_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6057 "math-equation.c"
}


void math_equation_set_target_currency (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_target_currency;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6076 "math-equation.c"
	}
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_target_currency);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_target_currency = _tmp3_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "target-currency");
#line 6088 "math-equation.c"
}


gchar* math_equation_get_source_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_source_units;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp1_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6106 "math-equation.c"
}


void math_equation_set_source_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_source_units;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6125 "math-equation.c"
	}
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_source_units);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_source_units = _tmp3_;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "source-units");
#line 6137 "math-equation.c"
}


gchar* math_equation_get_target_units (MathEquation* self) {
	gchar* result;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_target_units;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp1_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6155 "math-equation.c"
}


void math_equation_set_target_units (MathEquation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_target_units;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6174 "math-equation.c"
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_target_units);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_target_units = _tmp3_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "target-units");
#line 6186 "math-equation.c"
}


gchar* math_equation_get_display (MathEquation* self) {
	gchar* result;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	start = _tmp0_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	end = _tmp1_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = start;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = end;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_, FALSE);
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp4_;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6217 "math-equation.c"
}


gboolean math_equation_get_in_solve (MathEquation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_in_solve;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6232 "math-equation.c"
}


MathVariables* math_equation_get_variables (MathEquation* self) {
	MathVariables* result;
	MathVariables* _tmp0_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_variables;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6247 "math-equation.c"
}


Serializer* math_equation_get_serializer (MathEquation* self) {
	Serializer* result;
	Serializer* _tmp0_ = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_serializer;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6262 "math-equation.c"
}


gint math_equation_get_accuracy (MathEquation* self) {
	gint result;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 548 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6283 "math-equation.c"
}


void math_equation_set_accuracy (MathEquation* self, gint value) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_trailing_digits (_tmp1_);
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = value;
#line 551 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == _tmp3_) {
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6309 "math-equation.c"
	}
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_serializer (self);
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = value;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_trailing_digits (_tmp5_, _tmp6_);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_display (self);
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "accuracy");
#line 6323 "math-equation.c"
}


gboolean math_equation_get_show_thousands_separators (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6344 "math-equation.c"
}


void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_show_thousands_separators (_tmp1_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = value;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == _tmp3_) {
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6370 "math-equation.c"
	}
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_serializer (self);
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = value;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_show_thousands_separators (_tmp5_, _tmp6_);
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_display (self);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "show-thousands-separators");
#line 6384 "math-equation.c"
}


gboolean math_equation_get_show_trailing_zeroes (MathEquation* self) {
	gboolean result;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6405 "math-equation.c"
}


void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_show_trailing_zeroes (_tmp1_);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = value;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == _tmp3_) {
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6431 "math-equation.c"
	}
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_serializer (self);
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = value;
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_show_trailing_zeroes (_tmp5_, _tmp6_);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_display (self);
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "show-trailing-zeroes");
#line 6445 "math-equation.c"
}


DisplayFormat math_equation_get_number_format (MathEquation* self) {
	DisplayFormat result;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	DisplayFormat _tmp2_ = 0;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_number_format (_tmp1_);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6466 "math-equation.c"
}


void math_equation_set_number_format (MathEquation* self, DisplayFormat value) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	DisplayFormat _tmp2_ = 0;
	DisplayFormat _tmp3_ = 0;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	DisplayFormat _tmp6_ = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_number_format (_tmp1_);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = value;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_ == _tmp3_) {
#line 590 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6492 "math-equation.c"
	}
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = math_equation_get_serializer (self);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = _tmp4_;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = value;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_number_format (_tmp5_, _tmp6_);
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_display (self);
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "number-format");
#line 6506 "math-equation.c"
}


gint math_equation_get_number_base (MathEquation* self) {
	gint result;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_serializer (self);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = serializer_get_base (_tmp1_);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6527 "math-equation.c"
}


void math_equation_set_number_base (MathEquation* self, gint value) {
	gboolean _tmp0_ = FALSE;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	Serializer* _tmp12_ = NULL;
	Serializer* _tmp13_ = NULL;
	gint _tmp14_ = 0;
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = math_equation_get_serializer (self);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = serializer_get_base (_tmp2_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = value;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ == _tmp4_) {
#line 6555 "math-equation.c"
		Serializer* _tmp5_ = NULL;
		Serializer* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		gint _tmp8_ = 0;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = math_equation_get_serializer (self);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = _tmp5_;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = serializer_get_representation_base (_tmp6_);
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = value;
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = _tmp7_ == ((guint) _tmp8_);
#line 6570 "math-equation.c"
	} else {
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp0_ = FALSE;
#line 6574 "math-equation.c"
	}
#line 602 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_) {
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6580 "math-equation.c"
	}
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = math_equation_get_serializer (self);
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = _tmp9_;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = value;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_base (_tmp10_, _tmp11_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = math_equation_get_serializer (self);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp13_ = _tmp12_;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp14_ = value;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	serializer_set_representation_base (_tmp13_, (guint) _tmp14_);
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_reformat_display (self);
#line 600 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "number-base");
#line 6602 "math-equation.c"
}


AngleUnit math_equation_get_angle_units (MathEquation* self) {
	AngleUnit result;
	AngleUnit _tmp0_ = 0;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_angle_units;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6617 "math-equation.c"
}


void math_equation_set_angle_units (MathEquation* self, AngleUnit value) {
	AngleUnit _tmp0_ = 0;
	AngleUnit _tmp1_ = 0;
	AngleUnit _tmp2_ = 0;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_angle_units;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == _tmp1_) {
#line 617 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6635 "math-equation.c"
	}
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 619 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_angle_units = _tmp2_;
#line 614 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "angle-units");
#line 6643 "math-equation.c"
}


gchar* math_equation_get_status (MathEquation* self) {
	gchar* result;
	MathEquationState* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->state;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_->status;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp2_;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6664 "math-equation.c"
}


void math_equation_set_status (MathEquation* self, const gchar* value) {
	MathEquationState* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	MathEquationState* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->state;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_->status;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 628 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
#line 629 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 6687 "math-equation.c"
	}
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = self->priv->state;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = value;
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp3_->status);
#line 631 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_->status = _tmp5_;
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "status");
#line 6701 "math-equation.c"
}


guint math_equation_get_error_token_start (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	MathEquationState* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = _tmp0_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = _tmp1_;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = ans_start;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ != (-1)) {
#line 6727 "math-equation.c"
		gint _tmp4_ = 0;
		MathEquationState* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = ans_start;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = self->priv->state;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = _tmp5_->error_token_start;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
#line 6739 "math-equation.c"
	} else {
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = FALSE;
#line 6743 "math-equation.c"
	}
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_) {
#line 6747 "math-equation.c"
		MathEquationState* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = self->priv->state;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _tmp7_->error_token_start;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = ans_end;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = ans_start;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = ((_tmp8_ + _tmp9_) - _tmp10_) - 3;
#line 644 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 6764 "math-equation.c"
	}
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = self->priv->state;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = _tmp11_->error_token_start;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp12_;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6774 "math-equation.c"
}


guint math_equation_get_error_token_end (MathEquation* self) {
	guint result;
	gint ans_start = 0;
	gint ans_end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	MathEquationState* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
#line 652 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_get_ans_offsets (self, &_tmp0_, &_tmp1_);
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = _tmp0_;
#line 657 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = _tmp1_;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = ans_start;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ != (-1)) {
#line 6800 "math-equation.c"
		gint _tmp4_ = 0;
		MathEquationState* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = ans_start;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = self->priv->state;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = _tmp5_->error_token_end;
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = ((guint) _tmp4_) < _tmp6_;
#line 6812 "math-equation.c"
	} else {
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = FALSE;
#line 6816 "math-equation.c"
	}
#line 658 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_) {
#line 6820 "math-equation.c"
		MathEquationState* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = self->priv->state;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _tmp7_->error_token_end;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = ans_end;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = ans_start;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = ((_tmp8_ + _tmp9_) - _tmp10_) - 3;
#line 659 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 6837 "math-equation.c"
	}
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = self->priv->state;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp12_ = _tmp11_->error_token_end;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp12_;
#line 661 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6847 "math-equation.c"
}


gboolean math_equation_get_is_empty (MathEquation* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = gtk_text_buffer_get_char_count ((GtkTextBuffer*) self);
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_ == 0;
#line 667 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6862 "math-equation.c"
}


gboolean math_equation_get_is_result (MathEquation* self) {
	gboolean result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_equation (self);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, "ans") == 0;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (_tmp2_);
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp3_;
#line 672 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 6888 "math-equation.c"
}


static gchar* string_splice (const gchar* self, glong start, glong end, const gchar* str) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	gsize str_size = 0UL;
	const gchar* _tmp18_ = NULL;
	const gchar* _result_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	glong _tmp24_ = 0L;
	glong _tmp25_ = 0L;
	gsize _tmp26_ = 0UL;
	void* _tmp27_ = NULL;
	gchar* dest = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	glong _tmp30_ = 0L;
	gchar* _tmp31_ = NULL;
	glong _tmp32_ = 0L;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gsize _tmp35_ = 0UL;
	gchar* _tmp36_ = NULL;
	gsize _tmp37_ = 0UL;
	gchar* _tmp38_ = NULL;
	glong _tmp39_ = 0L;
	glong _tmp40_ = 0L;
	glong _tmp41_ = 0L;
	const gchar* _tmp42_ = NULL;
#line 1244 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1245 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1245 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1245 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1246 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1246 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 6942 "math-equation.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1247 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1247 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1247 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 6951 "math-equation.c"
	}
#line 1249 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1249 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 6957 "math-equation.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1250 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1250 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1250 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 6966 "math-equation.c"
	}
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 6972 "math-equation.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 6981 "math-equation.c"
	} else {
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 6985 "math-equation.c"
	}
#line 1252 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 6993 "math-equation.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 7002 "math-equation.c"
	} else {
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 7006 "math-equation.c"
	}
#line 1253 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1254 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1254 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1254 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1257 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = str;
#line 1257 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp18_ == NULL) {
#line 1258 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		str_size = (gsize) 0;
#line 7022 "math-equation.c"
	} else {
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
#line 1260 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp19_ = str;
#line 1260 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp20_ = strlen ((const gchar*) _tmp19_);
#line 1260 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp21_ = _tmp20_;
#line 1260 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
		str_size = (gsize) _tmp21_;
#line 7035 "math-equation.c"
	}
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp22_ = strlen (self);
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp23_ = _tmp22_;
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp24_ = end;
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp25_ = start;
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp26_ = str_size;
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp27_ = g_malloc0 (((_tmp23_ - (_tmp24_ - _tmp25_)) + _tmp26_) + 1);
#line 1263 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = _tmp27_;
#line 1265 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp28_ = _result_;
#line 1265 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	dest = (gchar*) _tmp28_;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp29_ = dest;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp30_ = start;
#line 1267 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	memcpy (_tmp29_, self, (gsize) _tmp30_);
#line 1268 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp31_ = dest;
#line 1268 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp32_ = start;
#line 1268 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	dest = _tmp31_ + _tmp32_;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp33_ = dest;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp34_ = str;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp35_ = str_size;
#line 1270 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	memcpy (_tmp33_, _tmp34_, _tmp35_);
#line 1271 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp36_ = dest;
#line 1271 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp37_ = str_size;
#line 1271 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	dest = _tmp36_ + _tmp37_;
#line 1273 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp38_ = dest;
#line 1273 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp39_ = end;
#line 1273 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp40_ = string_length;
#line 1273 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp41_ = end;
#line 1273 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	memcpy (_tmp38_, ((gchar*) self) + _tmp39_, (gsize) (_tmp40_ - _tmp41_));
#line 1275 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp42_ = _result_;
#line 1275 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	_result_ = NULL;
#line 1275 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	result = (gchar*) _tmp42_;
#line 1275 "/home/mcatanzaro/jhbuild/install/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 7099 "math-equation.c"
}


gchar* math_equation_get_equation (MathEquation* self) {
	gchar* result;
	gchar* text = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* eq_text = NULL;
	gchar* _tmp2_ = NULL;
	gint ans_start = 0;
	gint ans_end = 0;
	GtkTextMark* _tmp3_ = NULL;
	gint _tmp6_ = 0;
	gboolean last_is_digit = FALSE;
	gint index = 0;
	gunichar c = 0U;
#line 677 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_display (self);
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 679 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	text = _tmp1_;
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = g_strdup ("");
#line 680 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	eq_text = _tmp2_;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_start = -1;
#line 682 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	ans_end = -1;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = self->priv->ans_start_mark;
#line 683 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp3_ != NULL) {
#line 7137 "math-equation.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_get_ans_offsets (self, &_tmp4_, &_tmp5_);
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_start = _tmp4_;
#line 684 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		ans_end = _tmp5_;
#line 7146 "math-equation.c"
	}
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = ans_start;
#line 685 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp6_ >= 0) {
#line 7152 "math-equation.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = text;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = text;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = ans_start;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = text;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp12_ = ans_end;
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp13_ = string_index_of_nth_char (_tmp11_, (glong) _tmp12_);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp14_ = string_splice (_tmp7_, (glong) _tmp10_, (glong) _tmp13_, "ans");
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (text);
#line 686 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		text = _tmp14_;
#line 7181 "math-equation.c"
	}
#line 688 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	last_is_digit = FALSE;
#line 689 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	index = 0;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	while (TRUE) {
#line 7189 "math-equation.c"
		const gchar* _tmp15_ = NULL;
		gunichar _tmp16_ = 0U;
		gboolean _tmp17_ = FALSE;
		gboolean is_digit = FALSE;
		gunichar _tmp18_ = 0U;
		gboolean _tmp19_ = FALSE;
		gboolean next_is_digit = FALSE;
		gunichar next_char = 0U;
		gint i = 0;
		gint _tmp20_ = 0;
		const gchar* _tmp21_ = NULL;
		gunichar _tmp22_ = 0U;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gunichar _tmp28_ = 0U;
		Serializer* _tmp29_ = NULL;
		Serializer* _tmp30_ = NULL;
		gunichar _tmp31_ = 0U;
		gboolean _tmp49_ = FALSE;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp15_ = text;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp17_ = string_get_next_char (_tmp15_, &index, &_tmp16_);
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		c = _tmp16_;
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (!_tmp17_) {
#line 691 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			break;
#line 7220 "math-equation.c"
		}
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp18_ = c;
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp19_ = g_unichar_isdigit (_tmp18_);
#line 693 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		is_digit = _tmp19_;
#line 694 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		next_is_digit = FALSE;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp20_ = index;
#line 696 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		i = _tmp20_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp21_ = text;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp23_ = string_get_next_char (_tmp21_, &i, &_tmp22_);
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		next_char = _tmp22_;
#line 697 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp23_) {
#line 7242 "math-equation.c"
			gunichar _tmp24_ = 0U;
			gboolean _tmp25_ = FALSE;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp24_ = next_char;
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp25_ = g_unichar_isdigit (_tmp24_);
#line 698 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			next_is_digit = _tmp25_;
#line 7251 "math-equation.c"
		}
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp28_ = c;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp29_ = math_equation_get_serializer (self);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp30_ = _tmp29_;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp31_ = serializer_get_thousands_separator (_tmp30_);
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp28_ != _tmp31_) {
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = TRUE;
#line 7265 "math-equation.c"
		} else {
			gboolean _tmp32_ = FALSE;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp32_ = last_is_digit;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp27_ = !_tmp32_;
#line 7272 "math-equation.c"
		}
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp27_) {
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp26_ = TRUE;
#line 7278 "math-equation.c"
		} else {
			gboolean _tmp33_ = FALSE;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp33_ = next_is_digit;
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp26_ = !_tmp33_;
#line 7285 "math-equation.c"
		}
#line 701 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (_tmp26_) {
#line 7289 "math-equation.c"
			gboolean _tmp34_ = FALSE;
			gunichar _tmp35_ = 0U;
			Serializer* _tmp36_ = NULL;
			Serializer* _tmp37_ = NULL;
			gunichar _tmp38_ = 0U;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp35_ = c;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp36_ = math_equation_get_serializer (self);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp37_ = _tmp36_;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp38_ = serializer_get_radix (_tmp37_);
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp35_ == _tmp38_) {
#line 7305 "math-equation.c"
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp40_ = last_is_digit;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				if (_tmp40_) {
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp39_ = TRUE;
#line 7314 "math-equation.c"
				} else {
					gboolean _tmp41_ = FALSE;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp41_ = next_is_digit;
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
					_tmp39_ = _tmp41_;
#line 7321 "math-equation.c"
				}
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp34_ = _tmp39_;
#line 7325 "math-equation.c"
			} else {
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp34_ = FALSE;
#line 7329 "math-equation.c"
			}
#line 704 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			if (_tmp34_) {
#line 7333 "math-equation.c"
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp42_ = eq_text;
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp43_ = g_strconcat (_tmp42_, ".", NULL);
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (eq_text);
#line 705 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				eq_text = _tmp43_;
#line 7344 "math-equation.c"
			} else {
				const gchar* _tmp44_ = NULL;
				gunichar _tmp45_ = 0U;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp44_ = eq_text;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp45_ = c;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp46_ = g_unichar_to_string (_tmp45_);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp47_ = _tmp46_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_tmp48_ = g_strconcat (_tmp44_, _tmp47_, NULL);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (eq_text);
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				eq_text = _tmp48_;
#line 707 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
				_g_free0 (_tmp47_);
#line 7367 "math-equation.c"
			}
		}
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp49_ = is_digit;
#line 710 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		last_is_digit = _tmp49_;
#line 7374 "math-equation.c"
	}
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = eq_text;
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (text);
#line 713 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 7382 "math-equation.c"
}


Number* math_equation_get_number (MathEquation* self) {
	Number* result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 719 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = math_equation_get_is_result (self);
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 721 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp1_) {
#line 7398 "math-equation.c"
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = math_equation_get_answer (self);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = _tmp2_;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = _tmp4_;
#line 722 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 7412 "math-equation.c"
	} else {
		Serializer* _tmp5_ = NULL;
		Serializer* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp5_ = math_equation_get_serializer (self);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp6_ = _tmp5_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp7_ = math_equation_get_equation (self);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp8_ = _tmp7_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp9_ = _tmp8_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp10_ = serializer_from_string (_tmp6_, _tmp9_);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp11_ = _tmp10_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (_tmp9_);
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = _tmp11_;
#line 724 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 7441 "math-equation.c"
	}
}


NumberMode math_equation_get_number_mode (MathEquation* self) {
	NumberMode result;
	NumberMode _tmp0_ = 0;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_number_mode;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp0_;
#line 730 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 7457 "math-equation.c"
}


void math_equation_set_number_mode (MathEquation* self, NumberMode value) {
	NumberMode _tmp0_ = 0;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	NumberMode _tmp3_ = 0;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (self != NULL);
#line 733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->_number_mode;
#line 733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = value;
#line 733 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp0_ == _tmp1_) {
#line 734 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return;
#line 7476 "math-equation.c"
	}
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = value;
#line 736 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->can_super_minus = _tmp2_ == NUMBER_MODE_SUPERSCRIPT;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = value;
#line 738 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->_number_mode = _tmp3_;
#line 731 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_notify ((GObject *) self, "number-mode");
#line 7488 "math-equation.c"
}


Number* math_equation_get_answer (MathEquation* self) {
	Number* result;
	MathEquationState* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->state;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_->ans;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp1_;
#line 744 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 7506 "math-equation.c"
}


static void g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, guint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT_INT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (n_param_values == 5);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		data1 = closure->data;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		data2 = param_values->data[0].v_pointer;
#line 7525 "math-equation.c"
	} else {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		data1 = param_values->data[0].v_pointer;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		data2 = closure->data;
#line 7531 "math-equation.c"
	}
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	callback = (GMarshalFunc_VOID__STRING_OBJECT_INT_UINT) (marshal_data ? marshal_data : cc->callback);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), g_value_get_uint (param_values + 4), data2);
#line 7537 "math-equation.c"
}


static void math_equation_class_init (MathEquationClass * klass) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_equation_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_type_class_add_private (klass, sizeof (MathEquationPrivate));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((GtkSourceBufferClass *) klass)->undo = math_equation_real_undo;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((GtkSourceBufferClass *) klass)->redo = math_equation_real_redo;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((GtkTextBufferClass *) klass)->insert_text = math_equation_real_insert_text;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((GtkTextBufferClass *) klass)->delete_range = math_equation_real_delete_range;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_math_equation_get_property;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_math_equation_set_property;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->finalize = math_equation_finalize;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_WORD_SIZE, g_param_spec_int ("word-size", "word-size", "word-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_CURRENCY, g_param_spec_string ("source-currency", "source-currency", "source-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_CURRENCY, g_param_spec_string ("target-currency", "target-currency", "target-currency", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SOURCE_UNITS, g_param_spec_string ("source-units", "source-units", "source-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_TARGET_UNITS, g_param_spec_string ("target-units", "target-units", "target-units", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_DISPLAY, g_param_spec_string ("display", "display", "display", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IN_SOLVE, g_param_spec_boolean ("in-solve", "in-solve", "in-solve", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_VARIABLES, g_param_spec_object ("variables", "variables", "variables", TYPE_MATH_VARIABLES, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SERIALIZER, g_param_spec_object ("serializer", "serializer", "serializer", TYPE_SERIALIZER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ACCURACY, g_param_spec_int ("accuracy", "accuracy", "accuracy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS, g_param_spec_boolean ("show-thousands-separators", "show-thousands-separators", "show-thousands-separators", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_SHOW_TRAILING_ZEROES, g_param_spec_boolean ("show-trailing-zeroes", "show-trailing-zeroes", "show-trailing-zeroes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_FORMAT, g_param_spec_enum ("number-format", "number-format", "number-format", TYPE_DISPLAY_FORMAT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_BASE, g_param_spec_int ("number-base", "number-base", "number-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANGLE_UNITS, g_param_spec_enum ("angle-units", "angle-units", "angle-units", TYPE_ANGLE_UNIT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_STATUS, g_param_spec_string ("status", "status", "status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_START, g_param_spec_uint ("error-token-start", "error-token-start", "error-token-start", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ERROR_TOKEN_END, g_param_spec_uint ("error-token-end", "error-token-end", "error-token-end", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_IS_RESULT, g_param_spec_boolean ("is-result", "is-result", "is-result", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_EQUATION, g_param_spec_string ("equation", "equation", "equation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER, g_param_spec_object ("number", "number", "number", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_NUMBER_MODE, g_param_spec_enum ("number-mode", "number-mode", "number-mode", TYPE_NUMBER_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_EQUATION_ANSWER, g_param_spec_object ("answer", "answer", "answer", TYPE_NUMBER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_signal_new ("history_signal", TYPE_MATH_EQUATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT_INT_UINT, G_TYPE_NONE, 4, G_TYPE_STRING, TYPE_NUMBER, G_TYPE_INT, G_TYPE_UINT);
#line 7610 "math-equation.c"
}


static void math_equation_instance_init (MathEquation * self) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv = MATH_EQUATION_GET_PRIVATE (self);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_start_mark = NULL;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->ans_end_mark = NULL;
#line 7621 "math-equation.c"
}


static void math_equation_finalize (GObject* obj) {
	MathEquation * self;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_EQUATION, MathEquation);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_tag);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_source_currency);
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_target_currency);
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_source_units);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (self->priv->_target_units);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_start_mark);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->ans_end_mark);
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->state);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (self->priv->undo_stack);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	__g_list_free__g_object_unref0_0 (self->priv->redo_stack);
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->_variables);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->_serializer);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_async_queue_unref0 (self->priv->queue);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (math_equation_parent_class)->finalize (obj);
#line 7657 "math-equation.c"
}


GType math_equation_get_type (void) {
	static volatile gsize math_equation_type_id__volatile = 0;
	if (g_once_init_enter (&math_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathEquation), 0, (GInstanceInitFunc) math_equation_instance_init, NULL };
		GType math_equation_type_id;
		math_equation_type_id = g_type_register_static (gtk_source_buffer_get_type (), "MathEquation", &g_define_type_info, 0);
		g_once_init_leave (&math_equation_type_id__volatile, math_equation_type_id);
	}
	return math_equation_type_id__volatile;
}


static void _vala_math_equation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	switch (property_id) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_WORD_SIZE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_int (value, math_equation_get_word_size (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SOURCE_CURRENCY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_source_currency (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_TARGET_CURRENCY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_target_currency (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SOURCE_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_source_units (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_TARGET_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_target_units (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_DISPLAY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_display (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_IN_SOLVE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_boolean (value, math_equation_get_in_solve (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_VARIABLES:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_object (value, math_equation_get_variables (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SERIALIZER:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_object (value, math_equation_get_serializer (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ACCURACY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_int (value, math_equation_get_accuracy (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_boolean (value, math_equation_get_show_thousands_separators (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_boolean (value, math_equation_get_show_trailing_zeroes (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_FORMAT:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_enum (value, math_equation_get_number_format (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_BASE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_int (value, math_equation_get_number_base (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ANGLE_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_enum (value, math_equation_get_angle_units (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_STATUS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_status (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ERROR_TOKEN_START:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_uint (value, math_equation_get_error_token_start (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ERROR_TOKEN_END:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_uint (value, math_equation_get_error_token_end (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_IS_EMPTY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_boolean (value, math_equation_get_is_empty (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_IS_RESULT:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_boolean (value, math_equation_get_is_result (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_EQUATION:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_string (value, math_equation_get_equation (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_take_object (value, math_equation_get_number (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_MODE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_enum (value, math_equation_get_number_mode (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ANSWER:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		g_value_set_object (value, math_equation_get_answer (self));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 7822 "math-equation.c"
		default:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 7828 "math-equation.c"
	}
}


static void _vala_math_equation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathEquation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_EQUATION, MathEquation);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	switch (property_id) {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_WORD_SIZE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_word_size (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SOURCE_CURRENCY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_source_currency (self, g_value_get_string (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_TARGET_CURRENCY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_target_currency (self, g_value_get_string (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SOURCE_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_source_units (self, g_value_get_string (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_TARGET_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_target_units (self, g_value_get_string (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ACCURACY:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_accuracy (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SHOW_THOUSANDS_SEPARATORS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_show_thousands_separators (self, g_value_get_boolean (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_SHOW_TRAILING_ZEROES:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_show_trailing_zeroes (self, g_value_get_boolean (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_FORMAT:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_number_format (self, g_value_get_enum (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_BASE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_number_base (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_ANGLE_UNITS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_angle_units (self, g_value_get_enum (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_STATUS:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_status (self, g_value_get_string (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		case MATH_EQUATION_NUMBER_MODE:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		math_equation_set_number_mode (self, g_value_get_enum (value));
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 7916 "math-equation.c"
		default:
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		break;
#line 7922 "math-equation.c"
	}
}


MEquation* mequation_construct (GType object_type, MathEquation* m_equation, const gchar* equation) {
	MEquation * self = NULL;
	const gchar* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (m_equation != NULL, NULL);
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = equation;
#line 1359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MEquation*) equation_construct (object_type, _tmp0_);
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = m_equation;
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->m_equation);
#line 1360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv->m_equation = _tmp2_;
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return self;
#line 7950 "math-equation.c"
}


MEquation* mequation_new (MathEquation* m_equation, const gchar* equation) {
#line 1357 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return mequation_construct (TYPE_MEQUATION, m_equation, equation);
#line 7957 "math-equation.c"
}


static gboolean mequation_real_variable_is_defined (Equation* base, const gchar* name) {
	MEquation * self;
	gboolean result = FALSE;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	MathEquation* _tmp5_ = NULL;
	MathVariables* _tmp6_ = NULL;
	MathVariables* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MEquation*) base;
#line 1363 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = name;
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
#line 1365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	lower_name = _tmp1_;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = lower_name;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp3_, "rand") == 0) {
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = TRUE;
#line 7992 "math-equation.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = lower_name;
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "ans") == 0;
#line 7999 "math-equation.c"
	}
#line 1367 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (_tmp2_) {
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = TRUE;
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (lower_name);
#line 1368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 8009 "math-equation.c"
	}
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = self->priv->m_equation;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = math_equation_get_variables (_tmp5_);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp7_ = _tmp6_;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp8_ = name;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp9_ = math_variables_get (_tmp7_, _tmp8_);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp10_ = _tmp9_;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp11_ = _tmp10_ != NULL;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp10_);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp11_;
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (lower_name);
#line 1370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 8033 "math-equation.c"
}


static Number* mequation_real_get_variable (Equation* base, const gchar* name) {
	MEquation * self;
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MEquation*) base;
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = name;
#line 1375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
#line 1375 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	lower_name = _tmp1_;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = lower_name;
#line 1377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	if (g_strcmp0 (_tmp2_, "rand") == 0) {
#line 8058 "math-equation.c"
		Number* _tmp3_ = NULL;
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp3_ = number_new_random ();
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		result = _tmp3_;
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_g_free0 (lower_name);
#line 1378 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		return result;
#line 8068 "math-equation.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		_tmp4_ = lower_name;
#line 1379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
		if (g_strcmp0 (_tmp4_, "ans") == 0) {
#line 8075 "math-equation.c"
			MathEquation* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			Number* _tmp8_ = NULL;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp5_ = self->priv->m_equation;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp6_ = math_equation_get_answer (_tmp5_);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp7_ = _tmp6_;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp8_ = _g_object_ref0 (_tmp7_);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			result = _tmp8_;
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (lower_name);
#line 1380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			return result;
#line 8094 "math-equation.c"
		} else {
			MathEquation* _tmp9_ = NULL;
			MathVariables* _tmp10_ = NULL;
			MathVariables* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp9_ = self->priv->m_equation;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp10_ = math_equation_get_variables (_tmp9_);
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp11_ = _tmp10_;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp12_ = name;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_tmp13_ = math_variables_get (_tmp11_, _tmp12_);
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			result = _tmp13_;
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			_g_free0 (lower_name);
#line 1382 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
			return result;
#line 8117 "math-equation.c"
		}
	}
#line 1373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_free0 (lower_name);
#line 8122 "math-equation.c"
}


static void mequation_real_set_variable (Equation* base, const gchar* name, Number* x) {
	MEquation * self;
	MathEquation* _tmp0_ = NULL;
	MathVariables* _tmp1_ = NULL;
	MathVariables* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MEquation*) base;
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (name != NULL);
#line 1385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_if_fail (x != NULL);
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = self->priv->m_equation;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = math_equation_get_variables (_tmp0_);
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = _tmp1_;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = name;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = x;
#line 1388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	math_variables_set (_tmp2_, _tmp3_, _tmp4_);
#line 8151 "math-equation.c"
}


static Number* mequation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	MEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
#line 1391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = (MEquation*) base;
#line 1391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 1391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (x_units != NULL, NULL);
#line 1391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_return_val_if_fail (z_units != NULL, NULL);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp0_ = unit_manager_get_default ();
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp1_ = _tmp0_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp2_ = x;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp3_ = x_units;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp4_ = z_units;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_tmp6_ = _tmp5_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (_tmp1_);
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	result = _tmp6_;
#line 1393 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	return result;
#line 8193 "math-equation.c"
}


static void mequation_class_init (MEquationClass * klass) {
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	mequation_parent_class = g_type_class_peek_parent (klass);
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	g_type_class_add_private (klass, sizeof (MEquationPrivate));
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((EquationClass *) klass)->variable_is_defined = mequation_real_variable_is_defined;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((EquationClass *) klass)->get_variable = mequation_real_get_variable;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((EquationClass *) klass)->set_variable = mequation_real_set_variable;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	((EquationClass *) klass)->convert = mequation_real_convert;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (klass)->finalize = mequation_finalize;
#line 8212 "math-equation.c"
}


static void mequation_instance_init (MEquation * self) {
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self->priv = MEQUATION_GET_PRIVATE (self);
#line 8219 "math-equation.c"
}


static void mequation_finalize (GObject* obj) {
	MEquation * self;
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEQUATION, MEquation);
#line 1355 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	_g_object_unref0 (self->priv->m_equation);
#line 1353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/lib/math-equation.vala"
	G_OBJECT_CLASS (mequation_parent_class)->finalize (obj);
#line 8231 "math-equation.c"
}


GType mequation_get_type (void) {
	static volatile gsize mequation_type_id__volatile = 0;
	if (g_once_init_enter (&mequation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mequation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MEquation), 0, (GInstanceInitFunc) mequation_instance_init, NULL };
		GType mequation_type_id;
		mequation_type_id = g_type_register_static (TYPE_EQUATION, "MEquation", &g_define_type_info, 0);
		g_once_init_leave (&mequation_type_id__volatile, mequation_type_id);
	}
	return mequation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



