// -*- c++ -*-
// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!
#ifndef _GTKMM_APPLICATIONWINDOW_H
#define _GTKMM_APPLICATIONWINDOW_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2012 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/window.h>
#include <giomm/actiongroup.h>
#include <giomm/actionmap.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkApplicationWindow GtkApplicationWindow;
typedef struct _GtkApplicationWindowClass GtkApplicationWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ApplicationWindow_Class; } // namespace Gtk
namespace Gtk
{

/** A Gtk::Window subclass with Gtk::Application support.
 *
 * ApplicationWindow is a Gtk::Window subclass that offers some
 * extra functionality for better integration with Gtk::Application
 * features.  Notably, it can handle both the application menu as well
 * as the menubar. See set_app_menu() and
 * set_menubar().
 *
 * This class derives from Gio::ActionGroup and Gio::ActionMap,
 * to let you add window-specific actions that will be exported by the
 * associated Gtk::Application, together with its application-wide
 * actions.  Window-specific actions are prefixed with the "win."
 * prefix and application-wide actions are prefixed with the "app."
 * prefix.  Actions must be addressed with the prefixed name when
 * referring to them from a Gio::MenuModel.
 *
 * Note that widgets that are placed inside a Gtk::ApplicationWindow
 * can also activate these actions, if they implement the
 * Gtk::Actionable interface.
 *
 * As with Gtk::Application, the GDK lock will be acquired when
 * processing actions arriving from other processes and should therefore
 * be held when activating actions locally (if GDK threads are enabled).
 *
 * The settings Gtk::Settings::property_gtk_shell_shows_app_menu() and
 * Gtk::Settings::property_gtk_shell_shows_menubar() tell GTK+ whether the
 * desktop environment is showing the application menu and menubar
 * models outside the application as part of the desktop shell.
 * For instance, on OS X, both menus will be displayed remotely;
 * on Windows neither will be. gnome-shell (starting with version 3.4)
 * will display the application menu, but not the menubar.
 *
 * If the desktop environment does not display the menubar, then
 * Gtk::ApplicationWindow will automatically show a Gtk::MenuBar for it.
 * (see the <a href="http://developer.gnome.org/gtk3/stable/GtkApplication.html#GtkApplication.description">GtkApplication documentation</a> for some screenshots of how this
 * looks on different platforms).
 * This behaviour can be overridden with the Gtk::ApplicationWindow::property_show_menubar()
 * property. If the desktop environment does not display the application
 * menu, then it will automatically be included in the menubar.
 */

class ApplicationWindow
: public Gtk::Window,
  public Gio::ActionGroup,
  public Gio::ActionMap
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ApplicationWindow CppObjectType;
  typedef ApplicationWindow_Class CppClassType;
  typedef GtkApplicationWindow BaseObjectType;
  typedef GtkApplicationWindowClass BaseClassType;

private:  friend class ApplicationWindow_Class;
  static CppClassType applicationwindow_class_;

private:
  // noncopyable
  ApplicationWindow(const ApplicationWindow&);
  ApplicationWindow& operator=(const ApplicationWindow&);

protected:
  explicit ApplicationWindow(const Glib::ConstructParams& construct_params);
  explicit ApplicationWindow(GtkApplicationWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ApplicationWindow();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkApplicationWindow*       gobj()       { return reinterpret_cast<GtkApplicationWindow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkApplicationWindow* gobj() const { return reinterpret_cast<GtkApplicationWindow*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkApplicationWindow* gobj_copy();

private:

  
public:
  ApplicationWindow();
    explicit ApplicationWindow(const Glib::RefPtr<Application>& application);


  /** Sets whether the window will display a menubar for the app menu
   * and menubar as needed.
   * 
   * @newin{3,4}
   * @param show_menubar Whether to show a menubar when needed.
   */
  void set_show_menubar(bool show_menubar =  true);
  
  /** Returns whether the window will display a menubar for the app menu
   * and menubar as needed.
   * 
   * @newin{3,4}
   * @return <tt>true</tt> if @a window will display a menubar when needed.
   */
  bool get_show_menubar() const;

  
  /** Returns the unique ID of the window. If the window has not yet been added to
   * a Gtk::Application, returns `0`.
   * 
   * @newin{3,6}
   * @return The unique ID for @a window, or `0` if the window
   * has not yet been added to a Gtk::Application.
   */
  guint get_id() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the window should show a menubar at the top of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_menubar() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** TRUE if the window should show a menubar at the top of the window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_menubar() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::ApplicationWindow
   */
  Glib::RefPtr<Gtk::ApplicationWindow> wrap(GtkApplicationWindow* object, bool take_copy = false);
}


#endif /* _GTKMM_APPLICATIONWINDOW_H */

