// -*- c++ -*-
// Generated by gmmproc 2.39.3 -- DO NOT MODIFY!
#ifndef _GTKMM_STACK_H
#define _GTKMM_STACK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/container.h>
#include <gtkmm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkStack GtkStack;
typedef struct _GtkStackClass GtkStackClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Stack_Class; } // namespace Gtk
namespace Gtk
{


/** A container that shows only one child at a time.
 *
 * Gtk::Stack does not provide a means for users to change the visible
 * child. Instead, the Gtk::StackSwitcher widget can be used with
 * Gtk::Stack to provide this functionality.
 *
 * @ingroup Widgets
 * @newin{3,10}
 */

class Stack
  : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Stack CppObjectType;
  typedef Stack_Class CppClassType;
  typedef GtkStack BaseObjectType;
  typedef GtkStackClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Stack();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Stack_Class;
  static CppClassType stack_class_;

  // noncopyable
  Stack(const Stack&);
  Stack& operator=(const Stack&);

protected:
  explicit Stack(const Glib::ConstructParams& construct_params);
  explicit Stack(GtkStack* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkStack*       gobj()       { return reinterpret_cast<GtkStack*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkStack* gobj() const { return reinterpret_cast<GtkStack*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:
  Stack();

  
  /** Adds a child to @a stack.
   * The child is identified by the @a name.
   * 
   * @newin{3,10}
   * @param child The widget to add.
   * @param name The name for @a child.
   */
  void add(Widget& child, const Glib::ustring& name);

  
  /** Adds a child to @a stack.
   * The child is identified by the @a name. The @a title
   * will be used by Gtk::StackSwitcher to represent
   *  @a child in a tab bar, so it should be short.
   * 
   * @newin{3,10}
   * @param child The widget to add.
   * @param name The name for @a child.
   * @param title A human-readable title for @a child.
   */
  void add(Widget& child, const Glib::ustring& name, const Glib::ustring& title);

  
  /** Makes @a child the visible child of @a stack.
   * 
   * If @a child is different from the currently
   * visible child, the transition between the
   * two will be animated with the current
   * transition type of @a stack.
   * 
   * @newin{3,10}
   * @param child A child of @a stack.
   */
  void set_visible_child(Widget& child);

  
  /** Gets the currently visible child of @a stack, or <tt>0</tt> if
   * there are no visible children.
   * 
   * @newin{3,10}
   * @return The visible child of the Gtk::Stack.
   */
  Widget* get_visible_child();
  
  /** Gets the currently visible child of @a stack, or <tt>0</tt> if
   * there are no visible children.
   * 
   * @newin{3,10}
   * @return The visible child of the Gtk::Stack.
   */
  const Widget* get_visible_child() const;

  
  /** Makes the child with the given name visible.
   * 
   * If @a child is different from the currently
   * visible child, the transition between the
   * two will be animated with the current
   * transition type of @a stack.
   * 
   * @newin{3,10}
   * @param name The name of the child to make visible.
   */
  void set_visible_child(const Glib::ustring& name);
  
  /** Makes the child with the given name visible.
   * 
   * @newin{3,10}
   * @param name The name of the child to make visible.
   * @param transition The transition type to use.
   */
  void set_visible_child(const Glib::ustring& name, StackTransitionType transition);
  
  /** Returns the name of the currently visible child of @a stack, or
   * <tt>0</tt> if there is no visible child.
   * 
   * @newin{3,10}
   * @return The name of the visible child of the Gtk::Stack.
   */
  Glib::ustring get_visible_child_name() const;

  
  /** Sets the Gtk::Stack to be homogeneous or not. If it
   * is homogeneous, the Gtk::Stack will request the same
   * size for all its children. If it isn't, the stack
   * may change size when a different child becomes visible.
   * 
   * @newin{3,10}
   * @param homogeneous <tt>true</tt> to make @a stack homogeneous.
   */
  void set_homogeneous(bool homogeneous =  true);
  
  /** Gets whether @a stack is homogeneous.
   * See set_homogeneous().
   * 
   * @newin{3,10}
   * @return Whether @a stack is homogeneous.
   */
  bool get_homogeneous() const;

  
  /** Sets the duration that transitions between pages in @a stack
   * will take.
   * 
   * @newin{3,10}
   * @param duration The new duration, in milliseconds.
   */
  void set_transition_duration(guint duration);
  
  /** Returns the amount of time (in milliseconds) that
   * transitions between pages in @a stack will take.
   * 
   * @newin{3,10}
   * @return The transition duration.
   */
  guint get_transition_duration() const;

  
  /** Sets the type of animation that will be used for
   * transitions between pages in @a stack. Available
   * types include various kinds of fades and slides.
   * 
   * The transition type can be changed without problems
   * at runtime, so it is possible to change the animation
   * based on the page that is about to become current.
   * 
   * @newin{3,10}
   * @param transition The new transition type.
   */
  void set_transition_type(StackTransitionType transition);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Gets the type of animation that will be used
   * for transitions between pages in @a stack.
   * 
   * @newin{3,10}
   * @deprecated Use the const method instead.
   * @return The current transition type of @a stack.
   */
  StackTransitionType get_transition_type();
#endif // GTKMM_DISABLE_DEPRECATED


  /** Gets the type of animation that will be used
   * for transitions between pages in @a stack.
   * 
   * @newin{3,10}
   * @return The current transition type of @a stack.
   */
  StackTransitionType get_transition_type() const;

  
  /** Returns whether the @a stack is currently in a transition from one page to
   * another.
   * 
   * @newin{3,12}
   * @return <tt>true</tt> if the transition is currently running, <tt>false</tt> otherwise.
   */
  bool get_transition_running() const;

  
  /** Finds the child of the Gtk::Stack with the name given as
   * the argument. Returns <tt>0</tt> if there is no child with this
   * name.
   * 
   * @newin{3,12}
   * @param name The name of the child to find.
   * @return The requested child of the Gtk::Stack.
   */
  Widget* get_child_by_name(const Glib::ustring& name);
  
  /** Finds the child of the Gtk::Stack with the name given as
   * the argument. Returns <tt>0</tt> if there is no child with this
   * name.
   * 
   * @newin{3,12}
   * @param name The name of the child to find.
   * @return The requested child of the Gtk::Stack.
   */
  const Widget* get_child_by_name(const Glib::ustring& name) const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Homogeneous sizing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_homogeneous() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Homogeneous sizing.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_homogeneous() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The animation duration, in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< unsigned int > property_transition_duration() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The animation duration, in milliseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< unsigned int > property_transition_duration() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether or not the transition is currently running.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_transition_running() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of animation used to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< StackTransitionType > property_transition_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The type of animation used to transition.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< StackTransitionType > property_transition_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The widget currently visible in the stack.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_visible_child() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The widget currently visible in the stack.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_visible_child() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the widget currently visible in the stack.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_visible_child_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the widget currently visible in the stack.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_visible_child_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} //namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Stack
   */
  Gtk::Stack* wrap(GtkStack* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_STACK_H */

