/* hashset.c generated by valac 0.23.1.16-ce7f, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _GeeHashSetPrivate GeeHashSetPrivate;
typedef struct _GeeHashSetNode GeeHashSetNode;

#define GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE (gee_functions_hash_data_func_closure_get_type ())
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosure))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))

typedef struct _GeeFunctionsHashDataFuncClosure GeeFunctionsHashDataFuncClosure;
typedef struct _GeeFunctionsHashDataFuncClosureClass GeeFunctionsHashDataFuncClosureClass;

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
#define _gee_functions_hash_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_hash_data_func_closure_unref (var), NULL)))
#define _gee_functions_equal_data_func_closure_unref0(var) ((var == NULL) ? NULL : (var = (gee_functions_equal_data_func_closure_unref (var), NULL)))

#define GEE_HASH_SET_TYPE_ITERATOR (gee_hash_set_iterator_get_type ())
#define GEE_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator))
#define GEE_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))
#define GEE_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))

typedef struct _GeeHashSetIterator GeeHashSetIterator;
typedef struct _GeeHashSetIteratorClass GeeHashSetIteratorClass;
#define _gee_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_hash_set_node_free (var), NULL)))
typedef struct _GeeFunctionsHashDataFuncClosurePrivate GeeFunctionsHashDataFuncClosurePrivate;
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeHashSetIteratorPrivate GeeHashSetIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeSet* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeSet* self);
	GDestroyNotify (*get_g_destroy_func) (GeeSet* self);
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	void (*reserved0) (GeeAbstractSet* self);
	void (*reserved1) (GeeAbstractSet* self);
	void (*reserved2) (GeeAbstractSet* self);
	void (*reserved3) (GeeAbstractSet* self);
	void (*reserved4) (GeeAbstractSet* self);
	void (*reserved5) (GeeAbstractSet* self);
	void (*reserved6) (GeeAbstractSet* self);
	void (*reserved7) (GeeAbstractSet* self);
	void (*reserved8) (GeeAbstractSet* self);
	void (*reserved9) (GeeAbstractSet* self);
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeHashSet {
	GeeAbstractSet parent_instance;
	GeeHashSetPrivate * priv;
};

struct _GeeHashSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _array_size;
	gint _nnodes;
	GeeHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	GeeFunctionsHashDataFuncClosure* _hash_func;
	GeeFunctionsEqualDataFuncClosure* _equal_func;
	gint _stamp;
};

struct _GeeHashSetNode {
	gpointer key;
	GeeHashSetNode* next;
	guint key_hash;
};

struct _GeeFunctionsHashDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsHashDataFuncClosurePrivate * priv;
	GeeHashDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsHashDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsHashDataFuncClosure *self);
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeHashSetIterator {
	GObject parent_instance;
	GeeHashSetIteratorPrivate * priv;
};

struct _GeeHashSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashSet* _set;
	gint _index;
	GeeHashSetNode* _node;
	GeeHashSetNode* _next;
	gint _stamp;
};


static gpointer gee_hash_set_parent_class = NULL;
static gpointer gee_hash_set_iterator_parent_class = NULL;
static GeeTraversableIface* gee_hash_set_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_hash_set_iterator_gee_iterator_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
static void gee_hash_set_node_free (GeeHashSetNode* self);
gpointer gee_functions_hash_data_func_closure_ref (gpointer instance);
void gee_functions_hash_data_func_closure_unref (gpointer instance);
GParamSpec* gee_functions_param_spec_hash_data_func_closure (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_functions_value_set_hash_data_func_closure (GValue* value, gpointer v_object);
void gee_functions_value_take_hash_data_func_closure (GValue* value, gpointer v_object);
gpointer gee_functions_value_get_hash_data_func_closure (const GValue* value);
GType gee_functions_hash_data_func_closure_get_type (void) G_GNUC_CONST;
gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
void gee_functions_equal_data_func_closure_unref (gpointer instance);
GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_functions_value_set_equal_data_func_closure (GValue* value, gpointer v_object);
void gee_functions_value_take_equal_data_func_closure (GValue* value, gpointer v_object);
gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value);
GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST;
#define GEE_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_HASH_SET, GeeHashSetPrivate))
enum  {
	GEE_HASH_SET_DUMMY_PROPERTY,
	GEE_HASH_SET_G_TYPE,
	GEE_HASH_SET_G_DUP_FUNC,
	GEE_HASH_SET_G_DESTROY_FUNC,
	GEE_HASH_SET_SIZE,
	GEE_HASH_SET_READ_ONLY
};
void gee_abstract_collection_clear (GeeAbstractCollection* self);
#define GEE_HASH_SET_MIN_SIZE 11
#define GEE_HASH_SET_MAX_SIZE 13845163
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeHashDataFunc gee_functions_get_hash_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeHashSet* gee_hash_set_new_with_closures (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFunctionsHashDataFuncClosure* hash_func, GeeFunctionsEqualDataFuncClosure* equal_func);
GeeHashSet* gee_hash_set_construct_with_closures (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFunctionsHashDataFuncClosure* hash_func, GeeFunctionsEqualDataFuncClosure* equal_func);
static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key);
GeeHashDataFunc gee_hash_set_get_hash_func (GeeHashSet* self, gpointer* result_target);
GeeEqualDataFunc gee_hash_set_get_equal_func (GeeHashSet* self, gpointer* result_target);
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key);
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GType gee_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static void gee_hash_set_resize (GeeHashSet* self);
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key);
static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key);
static void gee_hash_set_real_clear (GeeAbstractCollection* base);
static gboolean gee_hash_set_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target);
static void gee_hash_set_set_hash_func (GeeHashSet* self, GeeHashDataFunc value, gpointer value_target);
static void gee_hash_set_set_equal_func (GeeHashSet* self, GeeEqualDataFunc value, gpointer value_target);
static void gee_hash_set_node_instance_init (GeeHashSetNode * self);
#define GEE_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorPrivate))
enum  {
	GEE_HASH_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_HASH_SET_ITERATOR_G_TYPE,
	GEE_HASH_SET_ITERATOR_G_DUP_FUNC,
	GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC,
	GEE_HASH_SET_ITERATOR_READ_ONLY,
	GEE_HASH_SET_ITERATOR_VALID
};
static gboolean gee_hash_set_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base);
static gpointer gee_hash_set_iterator_real_get (GeeIterator* base);
static void gee_hash_set_iterator_real_remove (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static void gee_hash_set_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_hash_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Constructs a new, empty hash set.
 *
 * If not provided, the functions parameters are requested to the
 * {@link Functions} function factory methods.
 *
 * @param hash_func an optional hash function
 * @param equal_func an optional equality testing function
 */
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeHashSet * self = NULL;
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GeeHashDataFunc _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GDestroyNotify _tmp8__target_destroy_notify = NULL;
	GeeFunctionsHashDataFuncClosure* _tmp9_ = NULL;
	GeeEqualDataFunc _tmp10_ = NULL;
	void* _tmp10__target = NULL;
	GDestroyNotify _tmp10__target_destroy_notify = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GeeHashSetNode** _tmp13_ = NULL;
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = hash_func;
	_tmp0__target = hash_func_target;
	if (_tmp0_ == NULL) {
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeHashDataFunc _tmp3_ = NULL;
		_tmp3_ = gee_functions_get_hash_func_for (g_type, &_tmp1_, &_tmp2_);
		(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
		hash_func = NULL;
		hash_func_target = NULL;
		hash_func_target_destroy_notify = NULL;
		hash_func = _tmp3_;
		hash_func_target = _tmp1_;
		hash_func_target_destroy_notify = _tmp2_;
	}
	_tmp4_ = equal_func;
	_tmp4__target = equal_func_target;
	if (_tmp4_ == NULL) {
		void* _tmp5_ = NULL;
		GDestroyNotify _tmp6_ = NULL;
		GeeEqualDataFunc _tmp7_ = NULL;
		_tmp7_ = gee_functions_get_equal_func_for (g_type, &_tmp5_, &_tmp6_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp7_;
		equal_func_target = _tmp5_;
		equal_func_target_destroy_notify = _tmp6_;
	}
	_tmp8_ = hash_func;
	_tmp8__target = hash_func_target;
	_tmp8__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func_target_destroy_notify = NULL;
	_tmp9_ = gee_functions_hash_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	self->priv->_hash_func = _tmp9_;
	_tmp10_ = equal_func;
	_tmp10__target = equal_func_target;
	_tmp10__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func_target_destroy_notify = NULL;
	_tmp11_ = gee_functions_equal_data_func_closure_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp10_, _tmp10__target, _tmp10__target_destroy_notify);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp11_;
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
	_tmp12_ = self->priv->_array_size;
	_tmp13_ = g_new0 (GeeHashSetNode*, _tmp12_ + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp13_;
	self->priv->_nodes_length1 = _tmp12_;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}


GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	return gee_hash_set_construct (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify);
}


static gpointer _gee_functions_hash_data_func_closure_ref0 (gpointer self) {
	return self ? gee_functions_hash_data_func_closure_ref (self) : NULL;
}


static gpointer _gee_functions_equal_data_func_closure_ref0 (gpointer self) {
	return self ? gee_functions_equal_data_func_closure_ref (self) : NULL;
}


GeeHashSet* gee_hash_set_construct_with_closures (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFunctionsHashDataFuncClosure* hash_func, GeeFunctionsEqualDataFuncClosure* equal_func) {
	GeeHashSet * self = NULL;
	GeeFunctionsHashDataFuncClosure* _tmp0_ = NULL;
	GeeFunctionsHashDataFuncClosure* _tmp1_ = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp2_ = NULL;
	GeeFunctionsEqualDataFuncClosure* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeHashSetNode** _tmp5_ = NULL;
	g_return_val_if_fail (hash_func != NULL, NULL);
	g_return_val_if_fail (equal_func != NULL, NULL);
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = hash_func;
	_tmp1_ = _gee_functions_hash_data_func_closure_ref0 (_tmp0_);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	self->priv->_hash_func = _tmp1_;
	_tmp2_ = equal_func;
	_tmp3_ = _gee_functions_equal_data_func_closure_ref0 (_tmp2_);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	self->priv->_equal_func = _tmp3_;
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
	_tmp4_ = self->priv->_array_size;
	_tmp5_ = g_new0 (GeeHashSetNode*, _tmp4_ + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp5_;
	self->priv->_nodes_length1 = _tmp4_;
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
	_gee_functions_hash_data_func_closure_unref0 (hash_func);
	_gee_functions_equal_data_func_closure_unref0 (equal_func);
	return self;
}


GeeHashSet* gee_hash_set_new_with_closures (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFunctionsHashDataFuncClosure* hash_func, GeeFunctionsEqualDataFuncClosure* equal_func) {
	return gee_hash_set_construct_with_closures (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}


static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key) {
	GeeHashSetNode** result = NULL;
	guint hash_value = 0U;
	GeeHashDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeHashDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	gconstpointer _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GeeHashSetNode** node = NULL;
	GeeHashSetNode** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	gint _tmp6_ = 0;
	GeeHashSetNode** _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_set_get_hash_func (self, &_tmp0__target);
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	_tmp2_ = key;
	_tmp3_ = _tmp1_ (_tmp2_, _tmp1__target);
	hash_value = _tmp3_;
	_tmp4_ = self->priv->_nodes;
	_tmp4__length1 = self->priv->_nodes_length1;
	_tmp5_ = hash_value;
	_tmp6_ = self->priv->_array_size;
	node = &_tmp4_[_tmp5_ % _tmp6_];
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeHashSetNode** _tmp8_ = NULL;
		gboolean _tmp20_ = FALSE;
		GeeHashSetNode** _tmp21_ = NULL;
		_tmp8_ = node;
		if ((*_tmp8_) != NULL) {
			gboolean _tmp9_ = FALSE;
			guint _tmp10_ = 0U;
			GeeHashSetNode** _tmp11_ = NULL;
			guint _tmp12_ = 0U;
			gboolean _tmp19_ = FALSE;
			_tmp10_ = hash_value;
			_tmp11_ = node;
			_tmp12_ = (*_tmp11_)->key_hash;
			if (_tmp10_ != _tmp12_) {
				_tmp9_ = TRUE;
			} else {
				GeeEqualDataFunc _tmp13_ = NULL;
				void* _tmp13__target = NULL;
				GeeEqualDataFunc _tmp14_ = NULL;
				void* _tmp14__target = NULL;
				GeeHashSetNode** _tmp15_ = NULL;
				gconstpointer _tmp16_ = NULL;
				gconstpointer _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp13_ = gee_hash_set_get_equal_func (self, &_tmp13__target);
				_tmp14_ = _tmp13_;
				_tmp14__target = _tmp13__target;
				_tmp15_ = node;
				_tmp16_ = (*_tmp15_)->key;
				_tmp17_ = key;
				_tmp18_ = _tmp14_ (_tmp16_, _tmp17_, _tmp14__target);
				_tmp9_ = !_tmp18_;
			}
			_tmp19_ = _tmp9_;
			_tmp7_ = _tmp19_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp20_ = _tmp7_;
		if (!_tmp20_) {
			break;
		}
		_tmp21_ = node;
		node = &(*_tmp21_)->next;
	}
	_tmp22_ = node;
	result = _tmp22_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
	self = (GeeHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	result = (*node) != NULL;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base) {
	GeeHashSet * self;
	GeeIterator* result = NULL;
	GeeHashSetIterator* _tmp0_ = NULL;
	self = (GeeHashSet*) base;
	_tmp0_ = gee_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (GeeIterator*) _tmp0_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** _tmp2_ = NULL;
	self = (GeeHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	_tmp2_ = node;
	if ((*_tmp2_) != NULL) {
		result = FALSE;
		return result;
	} else {
		guint hash_value = 0U;
		GeeHashDataFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		GeeHashDataFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		gconstpointer _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		GeeHashSetNode** _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GeeHashSetNode* _tmp11_ = NULL;
		GeeHashSetNode* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp3_ = gee_hash_set_get_hash_func (self, &_tmp3__target);
		_tmp4_ = _tmp3_;
		_tmp4__target = _tmp3__target;
		_tmp5_ = key;
		_tmp6_ = _tmp4_ (_tmp5_, _tmp4__target);
		hash_value = _tmp6_;
		_tmp7_ = node;
		_tmp8_ = key;
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
		_tmp10_ = hash_value;
		_tmp11_ = gee_hash_set_node_new (_tmp9_, _tmp10_);
		*_tmp7_ = _tmp11_;
		_tmp12_ = *_tmp7_;
		_tmp13_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp13_ + 1;
		gee_hash_set_resize (self);
		_tmp14_ = self->priv->_stamp;
		self->priv->_stamp = _tmp14_ + 1;
		result = TRUE;
		return result;
	}
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	gboolean b = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (GeeHashSet*) base;
	_tmp0_ = key;
	_tmp1_ = gee_hash_set_remove_helper (self, _tmp0_);
	b = _tmp1_;
	_tmp2_ = b;
	if (_tmp2_) {
		gee_hash_set_resize (self);
	}
	result = b;
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_hash_set_real_clear (GeeAbstractCollection* base) {
	GeeHashSet * self;
	self = (GeeHashSet*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				GeeHashSetNode* node = NULL;
				GeeHashSetNode** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp6_ = 0;
				GeeHashSetNode* _tmp7_ = NULL;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_array_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->_nodes;
				_tmp5__length1 = self->priv->_nodes_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp5_[_tmp6_] = NULL;
				node = _tmp7_;
				while (TRUE) {
					GeeHashSetNode* _tmp8_ = NULL;
					GeeHashSetNode* next = NULL;
					GeeHashSetNode* _tmp9_ = NULL;
					GeeHashSetNode* _tmp10_ = NULL;
					GeeHashSetNode* _tmp11_ = NULL;
					GeeHashSetNode* _tmp12_ = NULL;
					_tmp8_ = node;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp9_ = node;
					_tmp10_ = _tmp9_->next;
					_tmp9_->next = NULL;
					next = _tmp10_;
					_tmp11_ = node;
					((_tmp11_->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_->key = (self->priv->g_destroy_func (_tmp11_->key), NULL));
					_tmp11_->key = NULL;
					_tmp12_ = next;
					next = NULL;
					_gee_hash_set_node_free0 (node);
					node = _tmp12_;
					_gee_hash_set_node_free0 (next);
				}
				_gee_hash_set_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	gee_hash_set_resize (self);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_foreach (GeeAbstractCollection* base, GeeForallFunc f, void* f_target) {
	GeeHashSet * self;
	gboolean result = FALSE;
	self = (GeeHashSet*) base;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->_array_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				{
					GeeHashSetNode* current = NULL;
					GeeHashSetNode** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					gint _tmp6_ = 0;
					GeeHashSetNode* _tmp7_ = NULL;
					_tmp5_ = self->priv->_nodes;
					_tmp5__length1 = self->priv->_nodes_length1;
					_tmp6_ = i;
					_tmp7_ = _tmp5_[_tmp6_];
					current = _tmp7_;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_ = FALSE;
							GeeHashSetNode* _tmp12_ = NULL;
							GeeForallFunc _tmp13_ = NULL;
							void* _tmp13__target = NULL;
							GeeHashSetNode* _tmp14_ = NULL;
							gconstpointer _tmp15_ = NULL;
							gpointer _tmp16_ = NULL;
							gboolean _tmp17_ = FALSE;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								GeeHashSetNode* _tmp10_ = NULL;
								GeeHashSetNode* _tmp11_ = NULL;
								_tmp10_ = current;
								_tmp11_ = _tmp10_->next;
								current = _tmp11_;
							}
							_tmp8_ = FALSE;
							_tmp12_ = current;
							if (!(_tmp12_ != NULL)) {
								break;
							}
							_tmp13_ = f;
							_tmp13__target = f_target;
							_tmp14_ = current;
							_tmp15_ = _tmp14_->key;
							_tmp16_ = ((_tmp15_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp15_) : ((gpointer) _tmp15_);
							_tmp17_ = _tmp13_ (_tmp16_, _tmp13__target);
							if (!_tmp17_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key) {
	gboolean result = FALSE;
	GeeHashSetNode** node = NULL;
	gconstpointer _tmp0_ = NULL;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = key;
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
	node = _tmp1_;
	_tmp2_ = node;
	if ((*_tmp2_) != NULL) {
		GeeHashSetNode** _tmp3_ = NULL;
		GeeHashSetNode* next = NULL;
		GeeHashSetNode** _tmp4_ = NULL;
		GeeHashSetNode* _tmp5_ = NULL;
		GeeHashSetNode** _tmp6_ = NULL;
		GeeHashSetNode** _tmp7_ = NULL;
		GeeHashSetNode** _tmp8_ = NULL;
		GeeHashSetNode* _tmp9_ = NULL;
		GeeHashSetNode* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp3_ = node;
		_vala_assert ((*_tmp3_) != NULL, "*node != null");
		_tmp4_ = node;
		_tmp5_ = (*_tmp4_)->next;
		(*_tmp4_)->next = NULL;
		next = _tmp5_;
		_tmp6_ = node;
		(((*_tmp6_)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp6_)->key = (self->priv->g_destroy_func ((*_tmp6_)->key), NULL));
		(*_tmp6_)->key = NULL;
		_tmp7_ = node;
		gee_hash_set_node_free (*_tmp7_);
		_tmp8_ = node;
		_tmp9_ = next;
		next = NULL;
		*_tmp8_ = _tmp9_;
		_tmp10_ = *_tmp8_;
		_tmp11_ = self->priv->_nnodes;
		self->priv->_nnodes = _tmp11_ - 1;
		_tmp12_ = self->priv->_stamp;
		self->priv->_stamp = _tmp12_ + 1;
		result = TRUE;
		_gee_hash_set_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}


static void gee_hash_set_resize (GeeHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_array_size;
	_tmp3_ = self->priv->_nnodes;
	if (_tmp2_ >= (3 * _tmp3_)) {
		gint _tmp4_ = 0;
		_tmp4_ = self->priv->_array_size;
		_tmp1_ = _tmp4_ >= GEE_HASH_SET_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = self->priv->_array_size;
		_tmp8_ = self->priv->_nnodes;
		if ((3 * _tmp7_) <= _tmp8_) {
			gint _tmp9_ = 0;
			_tmp9_ = self->priv->_array_size;
			_tmp6_ = _tmp9_ < GEE_HASH_SET_MAX_SIZE;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp10_ = _tmp6_;
		_tmp0_ = _tmp10_;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		gint new_array_size = 0;
		gint _tmp12_ = 0;
		guint _tmp13_ = 0U;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		GeeHashSetNode** new_nodes = NULL;
		gint _tmp16_ = 0;
		GeeHashSetNode** _tmp17_ = NULL;
		gint new_nodes_length1 = 0;
		gint _new_nodes_size_ = 0;
		GeeHashSetNode** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gint _tmp44_ = 0;
		_tmp12_ = self->priv->_nnodes;
		_tmp13_ = g_spaced_primes_closest ((guint) _tmp12_);
		new_array_size = (gint) _tmp13_;
		_tmp14_ = new_array_size;
		_tmp15_ = CLAMP (_tmp14_, GEE_HASH_SET_MIN_SIZE, GEE_HASH_SET_MAX_SIZE);
		new_array_size = _tmp15_;
		_tmp16_ = new_array_size;
		_tmp17_ = g_new0 (GeeHashSetNode*, _tmp16_ + 1);
		new_nodes = _tmp17_;
		new_nodes_length1 = _tmp16_;
		_new_nodes_size_ = new_nodes_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_ = FALSE;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					GeeHashSetNode* node = NULL;
					GeeHashSetNode* next = NULL;
					_tmp19_ = _tmp18_;
					if (!_tmp19_) {
						gint _tmp20_ = 0;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = self->priv->_array_size;
					if (!(_tmp21_ < _tmp22_)) {
						break;
					}
					next = NULL;
					{
						GeeHashSetNode** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						gint _tmp24_ = 0;
						GeeHashSetNode* _tmp25_ = NULL;
						gboolean _tmp26_ = FALSE;
						_tmp23_ = self->priv->_nodes;
						_tmp23__length1 = self->priv->_nodes_length1;
						_tmp24_ = i;
						_tmp25_ = _tmp23_[_tmp24_];
						_tmp23_[_tmp24_] = NULL;
						_gee_hash_set_node_free0 (node);
						node = _tmp25_;
						_tmp26_ = TRUE;
						while (TRUE) {
							gboolean _tmp27_ = FALSE;
							GeeHashSetNode* _tmp29_ = NULL;
							GeeHashSetNode* _tmp30_ = NULL;
							GeeHashSetNode* _tmp31_ = NULL;
							guint hash_val = 0U;
							GeeHashSetNode* _tmp32_ = NULL;
							guint _tmp33_ = 0U;
							gint _tmp34_ = 0;
							GeeHashSetNode* _tmp35_ = NULL;
							GeeHashSetNode** _tmp36_ = NULL;
							gint _tmp36__length1 = 0;
							guint _tmp37_ = 0U;
							GeeHashSetNode* _tmp38_ = NULL;
							GeeHashSetNode** _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							guint _tmp40_ = 0U;
							GeeHashSetNode* _tmp41_ = NULL;
							GeeHashSetNode* _tmp42_ = NULL;
							_tmp27_ = _tmp26_;
							if (!_tmp27_) {
								GeeHashSetNode* _tmp28_ = NULL;
								_tmp28_ = next;
								next = NULL;
								_gee_hash_set_node_free0 (node);
								node = _tmp28_;
							}
							_tmp26_ = FALSE;
							_tmp29_ = node;
							if (!(_tmp29_ != NULL)) {
								break;
							}
							_tmp30_ = node;
							_tmp31_ = _tmp30_->next;
							_tmp30_->next = NULL;
							_gee_hash_set_node_free0 (next);
							next = _tmp31_;
							_tmp32_ = node;
							_tmp33_ = _tmp32_->key_hash;
							_tmp34_ = new_array_size;
							hash_val = _tmp33_ % _tmp34_;
							_tmp35_ = node;
							_tmp36_ = new_nodes;
							_tmp36__length1 = new_nodes_length1;
							_tmp37_ = hash_val;
							_tmp38_ = _tmp36_[_tmp37_];
							_tmp36_[_tmp37_] = NULL;
							_gee_hash_set_node_free0 (_tmp35_->next);
							_tmp35_->next = _tmp38_;
							_tmp39_ = new_nodes;
							_tmp39__length1 = new_nodes_length1;
							_tmp40_ = hash_val;
							_tmp41_ = node;
							node = NULL;
							_gee_hash_set_node_free0 (_tmp39_[_tmp40_]);
							_tmp39_[_tmp40_] = _tmp41_;
							_tmp42_ = _tmp39_[_tmp40_];
						}
					}
					_gee_hash_set_node_free0 (next);
					_gee_hash_set_node_free0 (node);
				}
			}
		}
		_tmp43_ = new_nodes;
		_tmp43__length1 = new_nodes_length1;
		new_nodes = NULL;
		new_nodes_length1 = 0;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
		self->priv->_nodes = _tmp43_;
		self->priv->_nodes_length1 = _tmp43__length1;
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
		_tmp44_ = new_array_size;
		self->priv->_array_size = _tmp44_;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	}
}


static gint gee_hash_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeHashSet* self;
	gint _tmp0_ = 0;
	self = (GeeHashSet*) base;
	_tmp0_ = self->priv->_nnodes;
	result = _tmp0_;
	return result;
}


static gboolean gee_hash_set_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeHashSet* self;
	self = (GeeHashSet*) base;
	result = FALSE;
	return result;
}


GeeHashDataFunc gee_hash_set_get_hash_func (GeeHashSet* self, gpointer* result_target) {
	GeeHashDataFunc result;
	GeeFunctionsHashDataFuncClosure* _tmp0_ = NULL;
	GeeHashDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GeeHashDataFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}


static void gee_hash_set_set_hash_func (GeeHashSet* self, GeeHashDataFunc value, gpointer value_target) {
	g_return_if_fail (self != NULL);
}


GeeEqualDataFunc gee_hash_set_get_equal_func (GeeHashSet* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeFunctionsEqualDataFuncClosure* _tmp0_ = NULL;
	GeeEqualDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GeeEqualDataFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp1_ = _tmp0_->func;
	_tmp1__target = _tmp0_->func_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}


static void gee_hash_set_set_equal_func (GeeHashSet* self, GeeEqualDataFunc value, gpointer value_target) {
	g_return_if_fail (self != NULL);
}


static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash) {
	GeeHashSetNode* self;
	gpointer _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = g_slice_new0 (GeeHashSetNode);
	gee_hash_set_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	_tmp1_ = hash;
	self->key_hash = _tmp1_;
	return self;
}


static void gee_hash_set_node_instance_init (GeeHashSetNode * self) {
}


static void gee_hash_set_node_free (GeeHashSetNode* self) {
	_gee_hash_set_node_free0 (self->next);
	g_slice_free (GeeHashSetNode, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	GeeHashSetIterator * self = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	GeeHashSet* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (set != NULL, NULL);
	self = (GeeHashSetIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = set;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_set);
	self->priv->_set = _tmp1_;
	_tmp2_ = self->priv->_set;
	_tmp3_ = _tmp2_->priv->_stamp;
	self->priv->_stamp = _tmp3_;
	return self;
}


static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	return gee_hash_set_iterator_construct (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static gboolean gee_hash_set_iterator_real_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GeeHashSetNode* _tmp4_ = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_next;
	self->priv->_node = _tmp4_;
	self->priv->_next = NULL;
	_tmp5_ = self->priv->_node;
	result = _tmp5_ != NULL;
	return result;
}


static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* _tmp19_ = NULL;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = self->priv->_next;
	if (_tmp3_ == NULL) {
		GeeHashSetNode* _tmp4_ = NULL;
		GeeHashSetNode* _tmp5_ = NULL;
		_tmp4_ = self->priv->_node;
		self->priv->_next = _tmp4_;
		_tmp5_ = self->priv->_next;
		if (_tmp5_ != NULL) {
			GeeHashSetNode* _tmp6_ = NULL;
			GeeHashSetNode* _tmp7_ = NULL;
			_tmp6_ = self->priv->_next;
			_tmp7_ = _tmp6_->next;
			self->priv->_next = _tmp7_;
		}
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			GeeHashSetNode* _tmp9_ = NULL;
			gboolean _tmp13_ = FALSE;
			gint _tmp14_ = 0;
			GeeHashSet* _tmp15_ = NULL;
			GeeHashSetNode** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp17_ = 0;
			GeeHashSetNode* _tmp18_ = NULL;
			_tmp9_ = self->priv->_next;
			if (_tmp9_ == NULL) {
				gint _tmp10_ = 0;
				GeeHashSet* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				_tmp10_ = self->priv->_index;
				_tmp11_ = self->priv->_set;
				_tmp12_ = _tmp11_->priv->_array_size;
				_tmp8_ = (_tmp10_ + 1) < _tmp12_;
			} else {
				_tmp8_ = FALSE;
			}
			_tmp13_ = _tmp8_;
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = self->priv->_index;
			self->priv->_index = _tmp14_ + 1;
			_tmp15_ = self->priv->_set;
			_tmp16_ = _tmp15_->priv->_nodes;
			_tmp16__length1 = _tmp15_->priv->_nodes_length1;
			_tmp17_ = self->priv->_index;
			_tmp18_ = _tmp16_[_tmp17_];
			self->priv->_next = _tmp18_;
		}
	}
	_tmp19_ = self->priv->_next;
	result = _tmp19_ != NULL;
	return result;
}


static gpointer gee_hash_set_iterator_real_get (GeeIterator* base) {
	GeeHashSetIterator * self;
	gpointer result = NULL;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = self->priv->_node;
	_vala_assert (_tmp3_ != NULL, "_node != null");
	_tmp4_ = self->priv->_node;
	_tmp5_ = _tmp4_->key;
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
	result = _tmp6_;
	return result;
}


static void gee_hash_set_iterator_real_remove (GeeIterator* base) {
	GeeHashSetIterator * self;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSet* _tmp4_ = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	GeeHashSet* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = self->priv->_node;
	_vala_assert (_tmp3_ != NULL, "_node != null");
	gee_iterator_has_next ((GeeIterator*) self);
	_tmp4_ = self->priv->_set;
	_tmp5_ = self->priv->_node;
	_tmp6_ = _tmp5_->key;
	gee_hash_set_remove_helper (_tmp4_, _tmp6_);
	self->priv->_node = NULL;
	_tmp7_ = self->priv->_set;
	_tmp8_ = _tmp7_->priv->_stamp;
	self->priv->_stamp = _tmp8_;
}


static gboolean gee_hash_set_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeeHashSetNode* node = NULL;
	GeeHashSetNode* _tmp3_ = NULL;
	GeeHashSetNode* next = NULL;
	GeeHashSetNode* _tmp4_ = NULL;
	GeeHashSetNode* current = NULL;
	GeeHashSetNode* prev = NULL;
	GeeHashSetNode* _tmp5_ = NULL;
	GeeHashSetNode* _tmp14_ = NULL;
	GeeHashSetNode* _tmp48_ = NULL;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_stamp;
	_tmp1_ = self->priv->_set;
	_tmp2_ = _tmp1_->priv->_stamp;
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
	_tmp3_ = self->priv->_node;
	node = _tmp3_;
	_tmp4_ = self->priv->_next;
	next = _tmp4_;
	current = NULL;
	prev = NULL;
	_tmp5_ = node;
	if (_tmp5_ != NULL) {
		GeeForallFunc _tmp6_ = NULL;
		void* _tmp6__target = NULL;
		GeeHashSetNode* _tmp7_ = NULL;
		gconstpointer _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		GeeHashSetNode* _tmp11_ = NULL;
		GeeHashSetNode* _tmp12_ = NULL;
		GeeHashSetNode* _tmp13_ = NULL;
		_tmp6_ = f;
		_tmp6__target = f_target;
		_tmp7_ = node;
		_tmp8_ = _tmp7_->key;
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
		_tmp10_ = _tmp6_ (_tmp9_, _tmp6__target);
		if (!_tmp10_) {
			result = FALSE;
			return result;
		}
		_tmp11_ = node;
		prev = _tmp11_;
		_tmp12_ = node;
		_tmp13_ = _tmp12_->next;
		current = _tmp13_;
	}
	_tmp14_ = next;
	if (_tmp14_ != NULL) {
		GeeForallFunc _tmp15_ = NULL;
		void* _tmp15__target = NULL;
		GeeHashSetNode* _tmp16_ = NULL;
		gconstpointer _tmp17_ = NULL;
		gpointer _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GeeHashSetNode* _tmp21_ = NULL;
		GeeHashSetNode* _tmp22_ = NULL;
		GeeHashSetNode* _tmp23_ = NULL;
		_tmp15_ = f;
		_tmp15__target = f_target;
		_tmp16_ = next;
		_tmp17_ = _tmp16_->key;
		_tmp18_ = ((_tmp17_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp17_) : ((gpointer) _tmp17_);
		_tmp19_ = _tmp15_ (_tmp18_, _tmp15__target);
		if (!_tmp19_) {
			GeeHashSetNode* _tmp20_ = NULL;
			_tmp20_ = next;
			self->priv->_node = _tmp20_;
			self->priv->_next = NULL;
			result = FALSE;
			return result;
		}
		_tmp21_ = next;
		prev = _tmp21_;
		_tmp22_ = next;
		_tmp23_ = _tmp22_->next;
		current = _tmp23_;
	}
	{
		gboolean _tmp24_ = FALSE;
		_tmp24_ = TRUE;
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			_tmp25_ = _tmp24_;
			if (!_tmp25_) {
				GeeHashSetNode* _tmp26_ = NULL;
				_tmp26_ = current;
				if (!(_tmp26_ != NULL)) {
					break;
				}
			}
			_tmp24_ = FALSE;
			while (TRUE) {
				GeeHashSetNode* _tmp27_ = NULL;
				GeeForallFunc _tmp28_ = NULL;
				void* _tmp28__target = NULL;
				GeeHashSetNode* _tmp29_ = NULL;
				gconstpointer _tmp30_ = NULL;
				gpointer _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				GeeHashSetNode* _tmp34_ = NULL;
				GeeHashSetNode* _tmp35_ = NULL;
				GeeHashSetNode* _tmp36_ = NULL;
				_tmp27_ = current;
				if (!(_tmp27_ != NULL)) {
					break;
				}
				_tmp28_ = f;
				_tmp28__target = f_target;
				_tmp29_ = current;
				_tmp30_ = _tmp29_->key;
				_tmp31_ = ((_tmp30_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp30_) : ((gpointer) _tmp30_);
				_tmp32_ = _tmp28_ (_tmp31_, _tmp28__target);
				if (!_tmp32_) {
					GeeHashSetNode* _tmp33_ = NULL;
					_tmp33_ = current;
					self->priv->_node = _tmp33_;
					self->priv->_next = NULL;
					result = FALSE;
					return result;
				}
				_tmp34_ = current;
				prev = _tmp34_;
				_tmp35_ = current;
				_tmp36_ = _tmp35_->next;
				current = _tmp36_;
			}
			while (TRUE) {
				gboolean _tmp37_ = FALSE;
				GeeHashSetNode* _tmp38_ = NULL;
				gboolean _tmp42_ = FALSE;
				gint _tmp43_ = 0;
				GeeHashSet* _tmp44_ = NULL;
				GeeHashSetNode** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				GeeHashSetNode* _tmp47_ = NULL;
				_tmp38_ = current;
				if (_tmp38_ == NULL) {
					gint _tmp39_ = 0;
					GeeHashSet* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					_tmp39_ = self->priv->_index;
					_tmp40_ = self->priv->_set;
					_tmp41_ = _tmp40_->priv->_array_size;
					_tmp37_ = (_tmp39_ + 1) < _tmp41_;
				} else {
					_tmp37_ = FALSE;
				}
				_tmp42_ = _tmp37_;
				if (!_tmp42_) {
					break;
				}
				_tmp43_ = self->priv->_index;
				self->priv->_index = _tmp43_ + 1;
				_tmp44_ = self->priv->_set;
				_tmp45_ = _tmp44_->priv->_nodes;
				_tmp45__length1 = _tmp44_->priv->_nodes_length1;
				_tmp46_ = self->priv->_index;
				_tmp47_ = _tmp45_[_tmp46_];
				current = _tmp47_;
			}
		}
	}
	_tmp48_ = prev;
	self->priv->_node = _tmp48_;
	self->priv->_next = NULL;
	result = TRUE;
	return result;
}


static gboolean gee_hash_set_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeHashSetIterator* self;
	self = (GeeHashSetIterator*) base;
	result = FALSE;
	return result;
}


static gboolean gee_hash_set_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeHashSetIterator* self;
	GeeHashSetNode* _tmp0_ = NULL;
	self = (GeeHashSetIterator*) base;
	_tmp0_ = self->priv->_node;
	result = _tmp0_ != NULL;
	return result;
}


static void gee_hash_set_iterator_class_init (GeeHashSetIteratorClass * klass) {
	gee_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeHashSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType gee_hash_set_iterator_gee_traversable_get_g_type (GeeHashSetIterator* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_hash_set_iterator_gee_traversable_get_g_dup_func (GeeHashSetIterator* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_hash_set_iterator_gee_traversable_get_g_destroy_func (GeeHashSetIterator* self) {
	return self->priv->g_destroy_func;
}


static void gee_hash_set_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
	gee_hash_set_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_hash_set_iterator_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_hash_set_iterator_gee_traversable_get_g_destroy_func;
}


static void gee_hash_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_hash_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_has_next;
	iface->get = (gpointer (*)(GeeIterator*)) gee_hash_set_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_hash_set_iterator_real_remove;
	iface->get_read_only = gee_hash_set_iterator_real_get_read_only;
	iface->get_valid = gee_hash_set_iterator_real_get_valid;
}


static void gee_hash_set_iterator_instance_init (GeeHashSetIterator * self) {
	self->priv = GEE_HASH_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_stamp = 0;
}


static void gee_hash_set_iterator_finalize (GObject* obj) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_hash_set_iterator_parent_class)->finalize (obj);
}


static GType gee_hash_set_iterator_get_type (void) {
	static volatile gsize gee_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSetIterator), 0, (GInstanceInitFunc) gee_hash_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_hash_set_iterator_type_id;
		gee_hash_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeHashSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_hash_set_iterator_type_id__volatile, gee_hash_set_iterator_type_id);
	}
	return gee_hash_set_iterator_type_id__volatile;
}


static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	switch (property_id) {
		case GEE_HASH_SET_ITERATOR_READ_ONLY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		case GEE_HASH_SET_ITERATOR_VALID:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
	switch (property_id) {
		case GEE_HASH_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_hash_set_class_init (GeeHashSetClass * klass) {
	gee_hash_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeHashSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_hash_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_hash_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_hash_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_hash_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_hash_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->foreach = gee_hash_set_real_foreach;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_hash_set_real_get_size;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_hash_set_real_get_read_only;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_hash_set_instance_init (GeeHashSet * self) {
	self->priv = GEE_HASH_SET_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void gee_hash_set_finalize (GObject* obj) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_HASH_SET, GeeHashSet);
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
	_gee_functions_hash_data_func_closure_unref0 (self->priv->_hash_func);
	_gee_functions_equal_data_func_closure_unref0 (self->priv->_equal_func);
	G_OBJECT_CLASS (gee_hash_set_parent_class)->finalize (obj);
}


/**
 * Hash table implementation of the {@link Set} interface.
 *
 * This implementation is better fit for highly heterogenous values.
 * In case of high value hashes redundancy or higher amount of data prefer using
 * tree implementation like {@link TreeSet}.
 *
 * @see TreeSet
 */
GType gee_hash_set_get_type (void) {
	static volatile gsize gee_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSet), 0, (GInstanceInitFunc) gee_hash_set_instance_init, NULL };
		GType gee_hash_set_type_id;
		gee_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeHashSet", &g_define_type_info, 0);
		g_once_init_leave (&gee_hash_set_type_id__volatile, gee_hash_set_type_id);
	}
	return gee_hash_set_type_id__volatile;
}


static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
	switch (property_id) {
		case GEE_HASH_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_HASH_SET_READ_ONLY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
	switch (property_id) {
		case GEE_HASH_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_HASH_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_HASH_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



