// -*- c++ -*-
// Generated by gmmproc 2.39.3 -- DO NOT MODIFY!
#ifndef _GTKMM_PLACESSIDEBAR_H
#define _GTKMM_PLACESSIDEBAR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <gtkmm/scrolledwindow.h>
#include <gtkmm/menu.h>
#include <giomm/file.h>
#include <giomm/volume.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPlacesSidebar GtkPlacesSidebar;
typedef struct _GtkPlacesSidebarClass GtkPlacesSidebarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PlacesSidebar_Class; } // namespace Gtk
namespace Gtk
{

/** Sidebar that displays frequently-used places in the file system.
 *
 * Gtk::PlacesSidebar is a widget that displays a list of frequently-used places in the
 * file system:  the user's home directory, the user's bookmarks, and volumes and drives.
 * This widget is used as a sidebar in Gtk::FileChooser and may be used by file managers
 * and similar programs.
 *
 * The places sidebar displays drives and volumes, and will automatically mount
 * or unmount them when the user selects them.
 *
 * Applications can hook to various signals in the places sidebar to customize
 * its behavior.  For example, they can add extra commands to the context menu
 * of the sidebar.
 *
 * While bookmarks are completely in control of the user, the places sidebar also
 * allows individual applications to provide extra shortcut folders that are unique
 * to each application.  For example, a Paint program may want to add a shortcut
 * for a Clipart folder.  You can do this with Gtk::PlacesSidebar::add_shortcut().
 *
 * To make use of the places sidebar, an application at least needs to connect
 * to the Gtk::PlacesSidebar::open-location signal.  This is emitted when the
 * user selects in the sidebar a location to open.  The application should also
 * call Gtk::PlacesSidebar::set_location() when it changes the currently-viewed
 * location.
 *
 * @ingroup Widgets
 * @newin{3,10}
 */


class PlacesSidebar
  : public ScrolledWindow
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef PlacesSidebar CppObjectType;
  typedef PlacesSidebar_Class CppClassType;
  typedef GtkPlacesSidebar BaseObjectType;
  typedef GtkPlacesSidebarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~PlacesSidebar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class PlacesSidebar_Class;
  static CppClassType placessidebar_class_;

  // noncopyable
  PlacesSidebar(const PlacesSidebar&);
  PlacesSidebar& operator=(const PlacesSidebar&);

protected:
  explicit PlacesSidebar(const Glib::ConstructParams& construct_params);
  explicit PlacesSidebar(GtkPlacesSidebar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkPlacesSidebar*       gobj()       { return reinterpret_cast<GtkPlacesSidebar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkPlacesSidebar* gobj() const { return reinterpret_cast<GtkPlacesSidebar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  /** Creates a new Gtk::PlacesSidebar widget.
   *
   * The application should connect to at least the "open-location" signal to be notified when the user makes a selection in the sidebar.
   *
   */
  PlacesSidebar();


  /** Sets the way in which the calling application can open new locations from
   * the places sidebar.  For example, some applications only open locations
   * "directly" into their main view, while others may support opening locations
   * in a new notebook tab or a new window.
   * 
   * This function is used to tell the places @a sidebar about the ways in which the
   * application can open new locations, so that the sidebar can display (or not)
   * the "Open in new tab" and "Open in new window" menu items as appropriate.
   * 
   * When the Gtk::PlacesSidebar::signal_open_location() signal is emitted, its flags
   * argument will be set to one of the @a flags that was passed in
   * set_open_flags().
   * 
   * Passing 0 for @a flags will cause Gtk::PLACES_OPEN_NORMAL to always be sent
   * to callbacks for the "open-location" signal.
   * 
   * @newin{3,10}
   * @param flags Bitmask of modes in which the calling application can open locations.
   */
  void set_open_flags(PlacesOpenFlags flags =  PLACES_OPEN_NORMAL);
  
  /** Gets the open flags.
   * 
   * @newin{3,10}
   * @return The Gtk::PlacesOpenFlags of @a sidebar.
   */
  PlacesOpenFlags get_open_flags() const;

  
  /** Sets the location that is being shown in the widgets surrounding the
   *  @a sidebar, for example, in a folder view in a file manager.  In turn, the
   *  @a sidebar will highlight that location if it is being shown in the list of
   * places, or it will unhighlight everything if the @a location is not among the
   * places in the list.
   * 
   * @newin{3,10}
   * @param location Location to select, or #<tt>0</tt> for no current path.
   */
  void set_location(const Glib::RefPtr<const Gio::File>& location);

  // transfer full
  // get_location returns a new Gio::File; modifiying the returned value does not modify the places sidebar
  
  /** Gets the currently-selected location in the @a sidebar.  This can be #<tt>0</tt> when
   * nothing is selected, for example, when set_location() has
   * been called with a location that is not among the sidebar's list of places to
   * show.
   * 
   * You can use this function to get the selection in the @a sidebar.  Also, if you
   * connect to the Gtk::PlacesSidebar::signal_popup_menu() signal, you can use this
   * function to get the location that is being referred to during the callbacks
   * for your menu items.
   * 
   * @newin{3,10}
   * @return A GFile with the selected location, or #<tt>0</tt> if nothing is visually
   * selected.
   */
  Glib::RefPtr<Gio::File> get_location() const; 

  
  /** Sets whether the @a sidebar should show an item for the Desktop folder.
   * The default value for this option is determined by the desktop
   * environment and the user's configuration, but this function can be
   * used to override it on a per-application basis.
   * 
   * @newin{3,10}
   * @param show_desktop Whether to show an item for the Desktop folder.
   */
  void set_show_desktop(bool show_desktop =  true);
  
  /** Returns the value previously set with set_show_desktop()
   * 
   * @newin{3,10}
   * @return <tt>true</tt> if the sidebar will display a builtin shortcut to the desktop folder.
   */
  bool get_show_desktop() const;

  
  /** Applications may want to present some folders in the places sidebar if
   * they could be immediately useful to users.  For example, a drawing
   * program could add a "/usr/share/clipart" location when the sidebar is
   * being used in an "Insert Clipart" dialog box.
   * 
   * This function adds the specified @a location to a special place for immutable
   * shortcuts.  The shortcuts are application-specific; they are not shared
   * across applications, and they are not persistent.  If this function
   * is called multiple times with different locations, then they are added
   * to the sidebar's list in the same order as the function is called.
   * 
   * @newin{3,10}
   * @param location Location to add as an application-specific shortcut.
   */
  void add_shortcut(const Glib::RefPtr<Gio::File>& location);
  
  /** Removes an application-specific shortcut that has been previously been
   * inserted with add_shortcut().  If the @a location is not a
   * shortcut in the sidebar, then nothing is done.
   * 
   * @newin{3,10}
   * @param location Location to remove.
   */
  void remove_shortcut(const Glib::RefPtr<Gio::File>& location);

  // transfer full
  // list_shortcuts returns a copy of the list and its elements; modifiying the returned value does not modify the places sidebar
 

  /** Gets the list of shortcuts.
   * 
   * @newin{3,10}
   * @return A SList of File of the locations that have been added as
   * application-specific shortcuts with add_shortcut().
   * To free this list, you can use
   * 
   * [C example ellipted].
   */
  std::vector< Glib::RefPtr<Gio::File> > list_shortcuts() const;

  // transfer full
  // get_nth_bookmark returns a new Gio::File; modifiying the returned value does not modify the places sidebar
  
  /** This function queries the bookmarks added by the user to the places sidebar,
   * and returns one of them.  This function is used by Gtk::FileChooser to implement
   * the "Alt-1", "Alt-2", etc. shortcuts, which activate the cooresponding bookmark.
   * 
   * @newin{3,10}
   * @param n Index of the bookmark to query.
   * @return The bookmark specified by the index @a n, or
   * #<tt>0</tt> if no such index exist.  Note that the indices start at 0, even though
   * the file chooser starts them with the keyboard shortcut "Alt-1".
   */
  Glib::RefPtr<Gio::File> get_nth_bookmark(int n) const;

  
  /** Sets whether the @a sidebar should show an item for connecting to a network server; this is off by default.
   * An application may want to turn this on if it implements a way for the user to connect
   * to network servers directly.
   * 
   * @newin{3,10}
   * @param show_connect_to_server Whether to show an item for the Connect to Server command.
   */
  void set_show_connect_to_server(bool show_connect_to_server =  true);
  
  /** Returns the value previously set with set_show_connect_to_server()
   * 
   * @newin{3,10}
   * @return <tt>true</tt> if the sidebar will display a "Connect to Server" item.
   */
  bool get_show_connect_to_server() const;


// We use no_default_handler with _WRAP_SIGNAL because the C *Class struct is hidden for GtkPlacesSidebar.
 

  /**
   * @par Slot Prototype:
   * <tt>int on_my_%drag_action_requested(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::RefPtr<Gio::File>& dest_file, const std::vector< Glib::RefPtr<Gio::File> >& source_file_list)</tt>
   *
   * When the user starts a drag-and-drop operation and the sidebar needs
   * to ask the application for which drag action to perform, then the
   * sidebar will emit this signal.
   * 
   * The application can evaluate the @a context for customary actions, or
   * it can check the type of the files indicated by @a source_file_list against the
   * possible actions for the destination @a dest_file.
   * 
   * The drag action to use must be the return value of the signal handler.
   * 
   * @newin{3,10}
   * @param context Gdk::DragContext with information about the drag operation.
   * @param dest_file File with the tentative location that is being hovered for a drop.
   * @param source_file_list List of File that are being dragged.
   * @return The drag action to use, for example, Gdk::ACTION_COPY
   * or Gdk::ACTION_MOVE, or 0 if no action is allowed here (i.e. drops
   * are not allowed in the specified @a dest_file).
   */

  Glib::SignalProxy3< int,const Glib::RefPtr<Gdk::DragContext>&,const Glib::RefPtr<Gio::File>&,const std::vector< Glib::RefPtr<Gio::File> >& > signal_drag_action_requested();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%drag_perform_drop(const Glib::RefPtr<Gio::File>& dest_file, const std::vector< Glib::RefPtr<Gio::File> >& source_file_list, int action)</tt>
   *
   * The places sidebar emits this signal when the user completes a
   * drag-and-drop operation and one of the sidebar's items is the
   * destination.  This item is in the @a dest_file, and the
   *  @a source_file_list has the list of files that are dropped into it and
   * which should be copied/moved/etc. based on the specified @a action.
   * 
   * @newin{3,10}
   * @param dest_file Destination File.
   * @param source_file_list List of File that got dropped.
   * @param action Drop action to perform.
   */

  Glib::SignalProxy3< void,const Glib::RefPtr<Gio::File>&,const std::vector< Glib::RefPtr<Gio::File> >&,int > signal_drag_perform_drop();


  /**
   * @par Slot Prototype:
   * <tt>int on_my_%drag_action_ask(int actions)</tt>
   *
   * The places sidebar emits this signal when it needs to ask the application
   * to pop up a menu to ask the user for which drag action to perform.
   * 
   * @newin{3,10}
   * @param actions Possible drag actions that need to be asked for.
   * @return The final drag action that the sidebar should pass to the drag side
   * of the drag-and-drop operation.
   */

  Glib::SignalProxy1< int,int > signal_drag_action_ask();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%open_location(const Glib::RefPtr<Gio::File>& location, PlacesOpenFlags open_flags)</tt>
   *
   * The places sidebar emits this signal when the user selects a location
   * in it.  The calling application should display the contents of that
   * location; for example, a file manager should show a list of files in
   * the specified location.
   * 
   * @newin{3,10}
   * @param location File to which the caller should switch.
   * @param open_flags A single value from Gtk::PlacesOpenFlags specifying how the @a location should be opened.
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<Gio::File>&,PlacesOpenFlags > signal_open_location();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%populate_popup(Menu* menu, const Glib::RefPtr<Gio::File>& selected_item, const Glib::RefPtr<Gio::Volume>& selected_volume)</tt>
   *
   * The places sidebar emits this signal when the user invokes a contextual
   * menu on one of its items.  In the signal handler, the application may
   * add extra items to the menu as appropriate.  For example, a file manager
   * may want to add a "Properties" command to the menu.
   * 
   * It is not necessary to store the @a selected_item for each menu item;
   * during their GtkMenuItem::activate callbacks, the application can use
   * Gtk::PlacesSidebar::get_location() to get the file to which the item
   * refers.
   * 
   * The @a selected_item argument may be #<tt>0</tt> in case the selection refers to
   * a volume.  In this case, @a selected_volume will be non-<tt>0</tt>.  In this case,
   * the calling application will have to Glib::object_ref() the @a selected_volume and
   * keep it around for the purposes of its menu item's "activate" callback.
   * 
   * The @a menu and all its menu items are destroyed after the user
   * dismisses the menu.  The menu is re-created (and thus, this signal is
   * emitted) every time the user activates the contextual menu.
   * 
   * @newin{3,10}
   * @param menu A Gtk::Menu.
   * @param selected_item File with the item to which the menu should refer, or #<tt>0</tt> in the case of a @a selected_volume.
   * @param selected_volume Volume if the selected item is a volume, or #<tt>0</tt> if it is a file.
   */

  Glib::SignalProxy3< void,Menu*,const Glib::RefPtr<Gio::File>&,const Glib::RefPtr<Gio::Volume>& > signal_populate_popup();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%show_connect_to_server()</tt>
   *
   * The places sidebar emits this signal when it needs the calling
   * application to present an way to connect directly to a network server.
   * For example, the application may bring up a dialog box asking for
   * a URL like "sftp://ftp.example.com".  It is up to the application to create
   * the corresponding mount by using, for example, Glib::file_mount_enclosing_volume().
   * 
   * @newin{3,10}
   */

  Glib::SignalProxy0< void > signal_show_connect_to_server();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%show_error_message(const Glib::ustring& primary, const Glib::ustring& secondary)</tt>
   *
   * The places sidebar emits this signal when it needs the calling
   * application to present an error message.  Most of these messages
   * refer to mounting or unmounting media, for example, when a drive
   * cannot be started for some reason.
   * 
   * @newin{3,10}
   * @param primary Primary message with a summary of the error to show.
   * @param secondary Secondary message with details of the error to show.
   */

  Glib::SignalProxy2< void,const Glib::ustring&,const Glib::ustring& > signal_show_error_message();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The location to highlight in the sidebar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_location() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The location to highlight in the sidebar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_location() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Modes in which the calling application can open locations selected in the sidebar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PlacesOpenFlags > property_open_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Modes in which the calling application can open locations selected in the sidebar.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PlacesOpenFlags > property_open_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the sidebar includes a builtin shortcut to a 'Connect to server' dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_connect_to_server() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the sidebar includes a builtin shortcut to a 'Connect to server' dialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_connect_to_server() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the sidebar includes a builtin shortcut to the Desktop folder.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_desktop() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the sidebar includes a builtin shortcut to the Desktop folder.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_desktop() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::PlacesSidebar
   */
  Gtk::PlacesSidebar* wrap(GtkPlacesSidebar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_PLACESSIDEBAR_H */

