// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_ASYNC_HANDLE_H
#define _LIBGNOMEVFSMM_ASYNC_HANDLE_H


#include <glibmm.h>

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-async-ops.h>
#include <libgnomevfs/gnome-vfs-file-info.h>

#include <libgnomevfsmm/async-handle-2.h>
#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/file-info.h>
#include <libgnomevfsmm/uri.h>
#include <libgnomevfsmm/transfer.h>


namespace Gnome
{

namespace Vfs
{

/// Deprecated namespace - use Async2.
namespace Async
{

typedef Glib::ListHandle< Glib::RefPtr<const Uri> > ListHandleUris;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct FileInfoResultTraits
{
  typedef FileInfoResult  CppType;
  typedef const GnomeVFSGetFileInfoResult*    CType;
  typedef GnomeVFSGetFileInfoResult*    CTypeNonConst;

  static CType   to_c_type      (const CppType& obj) { return obj.gobj(); }
  static CType   to_c_type      (const CType&   obj) { return obj; }
  static CppType to_cpp_type    (const CType&   obj) { return CppType(const_cast<CTypeNonConst>(obj), true); }
  static void    release_c_type (const CType&)       {}
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

typedef Glib::ListHandle< FileInfoResult, FileInfoResultTraits > ListHandleFileInfoResults;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
struct FindDirectoryResultTraits
{
  typedef FindDirectoryResult  CppType;
  typedef const GnomeVFSFindDirectoryResult*    CType;
  typedef GnomeVFSFindDirectoryResult*    CTypeNonConst;

  static CType   to_c_type      (const CppType& obj) { return obj.gobj(); }
  static CType   to_c_type      (const CType&   obj) { return obj; }
  static CppType to_cpp_type    (const CType&   obj) { return CppType(const_cast<CTypeNonConst>(obj), true); }
  static void    release_c_type (const CType&)       {}
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

typedef Glib::ListHandle< FindDirectoryResult, FindDirectoryResultTraits > ListHandleFindDirectoryResult;


//The default constructor creates a null handle. Use an open*() method before anything else.
class Handle
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Handle CppObjectType;
  typedef GnomeVFSAsyncHandle BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

  
public:
  Handle();
  ~Handle();

  typedef sigc::slot<void, const Async::Handle&, Result> SlotOpen;
  typedef SlotOpen SlotClose;

  void open(const Glib::ustring& text_uri, OpenMode open_mode, int priority, const SlotOpen& slot);
  void open(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, int priority, const SlotOpen& slot);

  typedef sigc::slot<void, const Async::Handle&, const Glib::RefPtr<Glib::IOChannel>&, Result> SlotOpenAsChannel;
  void open_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, guint advised_block_size, int priority, const SlotOpenAsChannel& slot);
  void open_as_channel(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, guint advised_block_size, int priority, const SlotOpenAsChannel& slot);

  void create(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotOpen& slot);
  void create(const Glib::RefPtr<Uri>& uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotOpen& slot);

  void create_symbolic_link(const Glib::RefPtr<Uri>& uri, const Glib::ustring& uri_reference, int priority, const SlotOpen& slot);

  typedef SlotOpenAsChannel SlotCreateAsChannel;
  void create_as_channel(const Glib::ustring& text_uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotCreateAsChannel& slot);
  //gnome_vfs_async_create_uri_as_channel() is declared, but not defined in gnome-vfs.
  //void create_as_channel(const Glib::RefPtr<Uri> uri, OpenMode open_mode, bool exclusive, guint perm, int priority, const SlotCreateAsChannel& slot);

  void close(const SlotClose& slot);

  typedef sigc::slot<void, const Async::Handle&, Result, gpointer, FileSize, FileSize> SlotRead;
  void read(gpointer buffer, guint bytes, const SlotRead& slot);

  typedef sigc::slot<void, const Async::Handle&, Result, gconstpointer, FileSize, FileSize> SlotWrite;
  void write(gconstpointer buffer, guint bytes, const SlotWrite& slot);

  typedef sigc::slot<void, const Async::Handle&, ListHandleFileInfoResults > SlotGetFileInfo;
  void get_file_info(const ListHandleUris& uri_list, FileInfoOptions options, int priority, const SlotGetFileInfo& slot) const;

  typedef sigc::slot<void, const Async::Handle&, Result, const Glib::RefPtr<FileInfo>& > SlotSetFileInfo;
  void set_file_info(const Glib::RefPtr<Uri>& uri, const Glib::RefPtr<FileInfo>& info, SetFileInfoMask mask, FileInfoOptions options, int priority, const SlotSetFileInfo& slot);

  typedef sigc::slot<void, const Async::Handle&, Result, Glib::ListHandle<Glib::RefPtr<FileInfo> >, int> SlotLoadDirectory;
  void load_directory(const Glib::ustring& text_uri, FileInfoOptions options, guint items_per_notification, int priority, const SlotLoadDirectory& slot);
  void load_directory(const Glib::RefPtr<Uri>& uri, FileInfoOptions options, guint items_per_notification, int priority, const SlotLoadDirectory& slot);

  typedef sigc::slot<int, const Async::Handle&, Transfer::ProgressInfo&> SlotTransferProgress;
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void transfer(const ListHandleUris& source_uri_list, const ListHandleUris& target_uri_list, TransferOptions xfer_options, ErrorMode error_mode, OverwriteMode overwrite_mode, int priority, const SlotTransferProgress& progress_update_callback, const Transfer::SlotProgress& progress_sync_callback);
#else
  void transfer(const ListHandleUris& source_uri_list, const ListHandleUris& target_uri_list, TransferOptions xfer_options, ErrorMode error_mode, OverwriteMode overwrite_mode, int priority, const SlotTransferProgress& progress_update_callback, const Transfer::SlotProgress& progress_sync_callback, std::auto_ptr<Gnome::Vfs::exception>& error);
#endif

  typedef sigc::slot<void, const Async::Handle&, ListHandleFindDirectoryResult > SlotFindDirectory;
  void find_directory(const ListHandleUris& near_uri_list, FindDirectoryKind kind, bool create_if_needed, bool find_if_needed, guint permissions, int priority, const SlotFindDirectory& slot);

  typedef sigc::slot<void, const Async::Handle&, Result, gpointer> SlotFileControl;
  void file_control(const Glib::ustring& operation, gpointer operation_data, const SlotFileControl& slot);

  
  /** Cancel an asynchronous operation and close all its callbacks.
   * Its possible to still receive another call or two on the callback.
   * @param handle Handle of the async operation to be cancelled.
   */

  void cancel();

  GnomeVFSAsyncHandle*       gobj()       { return gobject_; }
  const GnomeVFSAsyncHandle* gobj() const { return gobject_; }
  GnomeVFSAsyncHandle**      gobj_addr()  { return &gobject_; }
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  void assign_gobj(GnomeVFSAsyncHandle* src);
#endif

protected:
  GnomeVFSAsyncHandle* gobject_;
  
private:
  Handle(const Handle&);
  Handle& operator=(const Handle&);


};

} // namespace Async
} // namespace Vfs
} // namespace Gnome


#endif /* _LIBGNOMEVFSMM_ASYNC_HANDLE_H */

