/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef _Included_org_gnu_gtk_Expander
#define _Included_org_gnu_gtk_Expander
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/* Inaccessible static: class_000241 */
/* Inaccessible static: class_000242 */
/* Inaccessible static: class_000243 */
/* Inaccessible static: class_000244 */
/* Inaccessible static: class_000245 */
/* Inaccessible static: evtMap */
/* Inaccessible static: class_000240 */
/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gtk_expander_get_type();
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_new
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1new
  (JNIEnv *env, jclass cls, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	jint ret = (jint)gtk_expander_new(l);
	(*env)->ReleaseStringUTFChars(env, label, l);
	return ret;
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_new_with_mnemonic
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1new_1with_1mnemonic
  (JNIEnv *env, jclass cls, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	jint ret = (jint)gtk_expander_new_with_mnemonic(l);
	(*env)->ReleaseStringUTFChars(env, label, l);
	return ret;
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_expanded
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1expanded
  (JNIEnv *env, jclass cls, jint expander, jboolean expanded)
{
	gtk_expander_set_expanded((GtkExpander*)expander, (gboolean)expanded);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_expanded
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1expanded
  (JNIEnv *env, jclass cls, jint expander)
{
	return (jboolean)gtk_expander_get_expanded((GtkExpander*)expander);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_spacing
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1spacing
  (JNIEnv *env, jclass cls, jint expander, jint spacing)
{
	gtk_expander_set_spacing((GtkExpander*)expander, (gint)spacing);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_spacing
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1spacing
  (JNIEnv *env, jclass cls, jint expander)
{
	return (jint)gtk_expander_get_spacing((GtkExpander*)expander);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_label
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1label
  (JNIEnv *env, jclass cls, jint expander, jstring label)
{
	const gchar* l = (*env)->GetStringUTFChars(env, label, NULL);
	gtk_expander_set_label((GtkExpander*)expander, l);
	(*env)->ReleaseStringUTFChars(env, label, l);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_label
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1label
  (JNIEnv *env, jclass cls, jint expander)
{
	const gchar *label = gtk_expander_get_label((GtkExpander*)expander);
	return (*env)->NewStringUTF(env, label);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_use_underline
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1use_1underline
  (JNIEnv *env, jclass cls, jint expander, jboolean underline)
{
	gtk_expander_set_use_underline((GtkExpander*)expander, (gboolean)underline);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_use_underline
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1use_1underline
  (JNIEnv *env, jclass cls, jint expander)
{
	return (gboolean)gtk_expander_get_use_underline((GtkExpander*)expander);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_use_markup
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1use_1markup
  (JNIEnv *env, jclass cls, jint expander, jboolean markup)
{
	gtk_expander_set_use_markup((GtkExpander*)expander, (gboolean)markup);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_use_markup
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1use_1markup
  (JNIEnv *env, jclass cls, jint expander)
{
	return (gboolean)gtk_expander_get_use_markup((GtkExpander*)expander);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_set_label_widget
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1set_1label_1widget
  (JNIEnv *env, jclass cls, jint expander, jint label)
{
	gtk_expander_set_label_widget((GtkExpander*)expander, (GtkWidget*)label);
}

/*
 * Class:     org_gnu_gtk_Expander
 * Method:    gtk_expander_get_label_widget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Expander_gtk_1expander_1get_1label_1widget
  (JNIEnv *env, jclass cls, jint expander)
{
	return (jint)gtk_expander_get_label_widget((GtkExpander*)expander);
}

#ifdef __cplusplus
}
#endif
#endif
