/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#include <string.h>
#ifdef __cplusplus
extern "C" 
{
#endif

typedef struct {
    JNIEnv *env;
    jobject obj;  /* object to recieve the signal */
    jmethodID methodID;  /* methodID of callback method */
    jobject methodData;  /* user defined data to pass to callback method */
} UIInfo_CallbackInfo;

// halps make a local array into a native array.
	JNIEXPORT jintArray JNICALL Java_org_gnu_gnome_UIInfo_toNativeArray(JNIEnv *env, jclass cls, jintArray uiinfo) 
	{
        gint *uiinfo_g_g = (gint *) (*env)->GetIntArrayElements (env, uiinfo, NULL);
        jint uiinfo_len = (*env)->GetArrayLength(env, uiinfo);
        GnomeUIInfo *uiinfo_g = g_new(GnomeUIInfo, uiinfo_len);
		gint *new_array_g = g_new( gint, uiinfo_len );
		jintArray new_array;
        int i = 0;
        for (i = 0; i < uiinfo_len; i++){
        	uiinfo_g[i] = *(GnomeUIInfo *)uiinfo_g_g[i];
			new_array_g[i] = (gint) & uiinfo_g[i];
//			g_free(uiinfo_g_g[i]);
		}
        (*env)->ReleaseIntArrayElements (env, uiinfo, (jint*)uiinfo_g_g, 0);

		new_array = (*env)->NewIntArray(env, uiinfo_len);
		(*env)->SetIntArrayRegion( env, new_array, 0, uiinfo_len, (jint *) new_array_g);
		g_free( new_array_g );
        return new_array;
	}


/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    uiinfo_new
 * Signature: (Ijava.lang.String;java.lang.String;III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_uiinfo_1new(JNIEnv *env, jclass cls, jint type, jstring label, jstring hint, jint pmType, jint acceleratorKey, jint acMods) {
    GnomeUIInfo *cptr = g_new(GnomeUIInfo, 1);
	GnomeUIInfoType infoType = (GnomeUIInfoType)type;
	GnomeUIPixmapType pixmapType = (GnomeUIPixmapType)pmType;
	guint accelKey = (guint)acceleratorKey;
	GdkModifierType modifierType = (GdkModifierType)acMods;
    
	const gchar* label_g = (*env)->GetStringUTFChars(env, label, 0);
    const gchar* hint_g = (*env)->GetStringUTFChars(env, hint, 0);

	cptr->type = infoType;
	cptr->label = label_g;
	cptr->hint = hint_g;
	cptr->pixmap_type = pixmapType;
	cptr->accelerator_key = accelKey;
	cptr->ac_mods = modifierType;
	
    return (jint)cptr;
}

/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    setPixmapInfo
 * Signature: (Ijava.lang.String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_UIInfo_setPixmapInfo__ILjava_lang_String_2
  (JNIEnv *env, jclass cls, jint hndl, jstring data) {
  	GnomeUIInfo *uiinfo = (GnomeUIInfo*)hndl;
    const gchar* data_g = (*env)->GetStringUTFChars(env, data, 0);
  	uiinfo->pixmap_info = (gconstpointer)data_g;
}

/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    setPixmapInfo
 * Signature: (I[B)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_UIInfo_setPixmapInfo__I_3B
  (JNIEnv *env, jclass cls, jint hndl, jbyteArray data) {
  	GnomeUIInfo *uiinfo = (GnomeUIInfo*)hndl;
	jint data_len = (*env)->GetArrayLength(env, data);
    gchar* data_g = (gchar*)g_malloc(data_len + 1);
	(*env)->GetByteArrayRegion(env, data, 0, data_len, (jbyte*)data_g);
	data_g[data_len] = 0;
  	uiinfo->pixmap_info = (gconstpointer)data_g;
}

/*
 * This is the callback method that recieves all callbacks
 * associated with the GnomeUIInfo activate.  It calls out
 * to the java method.
 */
static void
activateCallback(GtkWidget *widget, gpointer data)
{
  	UIInfo_CallbackInfo *cbi = data;
  	jvalue *jargs = g_new(jvalue, 1);

  	if (data == NULL) {
    	g_critical("Java-GNOME - unable to determine the callback method\n");
    	return;
  	}

  	jargs->i = cbi->methodData;
    (* cbi->env)->CallVoidMethodA(cbi->env, cbi->obj, cbi->methodID, jargs);
}

/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    setCallbackInfo
 * Signature: (ILjava/lang/String;Ljava/lang/Object;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_UIInfo_setCallbackInfo
  (JNIEnv *env, jclass cls, jint hndl, jstring method, jobject obj) {
  	GnomeUIInfo *uiinfo = (GnomeUIInfo*)hndl;
  	UIInfo_CallbackInfo *callbackData;
  	jthrowable exc;

  	callbackData = g_new(UIInfo_CallbackInfo, 1);
  	callbackData->env = env;
  	callbackData->obj = (*env)->NewGlobalRef(env, obj);
  	callbackData->methodID = (*env)->GetMethodID(env, 
			(*env)->GetObjectClass(env, obj), 
			(*env)->GetStringUTFChars(env, method, 0),
			"()V");
  	exc = (*env)->ExceptionOccurred(env);
  	if (exc) {
    	g_critical("Java-GNOME - cannot find callback method %s with signature %s in the specified object.\n",
   		(*env)->GetStringUTFChars(env, method, 0), "()V");
    	g_critical("Java-GNOME - exception is:\n");
    	(*env)->ExceptionDescribe(env);
    	(*env)->ExceptionClear(env);
    	g_warning("\n\nJava-GNOME - signal will not be mapped\n\n");
   	 	return;
  	}
  	uiinfo->user_data = callbackData;
  	uiinfo->moreinfo = activateCallback;
}

/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    setMoreInfo
 * Signature: (Ijava.lang.String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_UIInfo_setMoreInfo
  (JNIEnv *env, jclass cls, jint hndl, jstring info) {
  	GnomeUIInfo *uiinfo = (GnomeUIInfo*)hndl;
    const gchar* info_g = (*env)->GetStringUTFChars(env, info, 0);
  	uiinfo->moreinfo = (gpointer)info_g;
}

/*
 * Class:     org_gnu_gnome_UIInfo
 * Method:    setSubmenuInfo
 * Signature: (I[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gnome_UIInfo_setSubmenuInfo
  (JNIEnv *env, jclass cls, jint hndl, jintArray info)
{
	jsize len;
	int index;
	GnomeUIInfo* submenu;
	GnomeUIInfo* ptr;
	
	len = (*env)->GetArrayLength(env, info);
	submenu = (GnomeUIInfo*)g_malloc(sizeof(GnomeUIInfo)*len);
	ptr = submenu;
	for (index = 0; index < len; index++) { 
		jint tmp;
		(*env)->GetIntArrayRegion(env, info, index, 1, &tmp);
		memcpy(ptr, (GnomeUIInfo*)tmp, sizeof(GnomeUIInfo));
		ptr->widget = ((GnomeUIInfo*)tmp)->widget;
		ptr->user_data = ((GnomeUIInfo*)tmp)->user_data;
		ptr->moreinfo = ((GnomeUIInfo*)tmp)->moreinfo;
		ptr++;
	}
	((GnomeUIInfo*)hndl)->moreinfo = (gpointer)submenu;
	((GnomeUIInfo*)hndl)->user_data = NULL;
}
                                                                                

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    GnomeUIInfoType GnomeUIInfo_get_type (GnomeUIInfo * cptr) 
    {
        return cptr->type;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getType
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getType (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            jint result_j = (jint) (GnomeUIInfo_get_type (cptr_g));
            return result_j;
        }
    }

    gchar * GnomeUIInfo_get_label (GnomeUIInfo * cptr) 
    {
        return (gchar *)cptr->label;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getLabel
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_UIInfo_getLabel (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
		return (*env)->NewStringUTF(env, (gchar*)GnomeUIInfo_get_label (cptr_g));
    }

    gchar * GnomeUIInfo_get_hint (GnomeUIInfo * cptr) 
    {
        return (gchar *)cptr->hint;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getHint
     * Signature: (I)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gnome_UIInfo_getHint (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
		return (*env)->NewStringUTF(env,(gchar*)GnomeUIInfo_get_hint (cptr_g));
    }

    gpointer GnomeUIInfo_get_moreinfo (GnomeUIInfo * cptr) 
    {
        return cptr->moreinfo;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getMoreinfo
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getMoreinfo (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            return (jint)GnomeUIInfo_get_moreinfo (cptr_g);
        }
    }

    gpointer GnomeUIInfo_get_user_data (GnomeUIInfo * cptr) 
    {
        return cptr->user_data;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getUserData
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getUserData (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            return (jint)GnomeUIInfo_get_user_data (cptr_g);
        }
    }

    GnomeUIPixmapType GnomeUIInfo_get_pixmap_type (GnomeUIInfo * cptr) 
    {
        return cptr->pixmap_type;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getPixmapType
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getPixmapType (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            jint result_j = (jint) (GnomeUIInfo_get_pixmap_type (cptr_g));
            return result_j;
        }
    }

    gpointer GnomeUIInfo_get_pixmap_info (GnomeUIInfo * cptr) 
    {
        return (gpointer)cptr->pixmap_info;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getPixmapInfo
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getPixmapInfo (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            return (jint)GnomeUIInfo_get_pixmap_info (cptr_g);
        }
    }

    gint32 GnomeUIInfo_get_accelerator_key (GnomeUIInfo * cptr) 
    {
        return cptr->accelerator_key;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getAcceleratorKey
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getAcceleratorKey (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            jint result_j = (jint) (GnomeUIInfo_get_accelerator_key (cptr_g));
            return result_j;
        }
    }

    GdkModifierType GnomeUIInfo_get_ac_mods (GnomeUIInfo * cptr) 
    {
        return cptr->ac_mods;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getAcMods
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getAcMods (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            jint result_j = (jint) (GnomeUIInfo_get_ac_mods (cptr_g));
            return result_j;
        }
    }

    GtkWidget * GnomeUIInfo_get_widget (GnomeUIInfo * cptr) 
    {
        return cptr->widget;
    }

    /*
     * Class:     org.gnu.gnome.UIInfo
     * Method:    getWidget
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gnome_UIInfo_getWidget (JNIEnv *env, jclass cls, jint cptr) 
    {
        GnomeUIInfo *cptr_g = (GnomeUIInfo *)cptr;
        {
            return (jint)GnomeUIInfo_get_widget (cptr_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
