/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *   Philip A. Chapman <pchapman@pcsw.us>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-08 10:21:59 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gnome.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gnome.Help
     * Method:    gnome_help_display
     * Signature: (java.lang.String;java.lang.String;[I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Help_gnome_1help_1display(JNIEnv *env, jclass 
        cls, jstring filename, jstring linkId, jintArray error) 
    {
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gchar* linkId_g = (gchar*)(*env)->GetStringUTFChars(env, linkId, 0);
        GError *error_g = (GError *) (*env)->GetIntArrayElements (env, error, NULL);
        jboolean result_j = (jboolean) (gnome_help_display (filename_g, linkId_g, &error_g));
      	(*env)->ReleaseIntArrayElements (env, error, (jint *) error_g, 0);
        if (filename) (*env)->ReleaseStringUTFChars(env, filename, filename_g);
        if (linkId) (*env)->ReleaseStringUTFChars(env, linkId, linkId_g);
        return result_j;
    }

    /*
     * Class:     org.gnu.gnome.Help
     * Method:    gnome_help_display_with_doc_id
     * Signature: (Ijava.lang.String;java.lang.String;java.lang.String;[I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Help_gnome_1help_1display_1with_1doc_1id (JNIEnv 
        *env, jclass cls, jint program, jstring docId, jstring filename, jstring lineId, jintArray error) 
    {
        gchar* docId_g = (gchar*)(*env)->GetStringUTFChars(env, docId, 0);
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gchar* lineId_g = (gchar*)(*env)->GetStringUTFChars(env, lineId, 0);
        GError *error_g = (GError *) (*env)->GetIntArrayElements (env, error, NULL);
        jboolean result_j = (jboolean) (gnome_help_display_with_doc_id
            	((GnomeProgram*)program, docId_g, filename_g, lineId_g, &error_g));
        (*env)->ReleaseIntArrayElements (env, error, (jint *) error_g, 0);
        if (docId) (*env)->ReleaseStringUTFChars(env, docId, docId_g);
        if (filename) (*env)->ReleaseStringUTFChars(env, filename, filename_g);
        if (lineId) (*env)->ReleaseStringUTFChars(env, lineId, lineId_g);
        return result_j;
    }

    /*
     * Class:     org.gnu.gnome.Help
     * Method:    gnome_help_display_desktop
     * Signature: (Ijava.lang.String;java.lang.String;java.lang.String;[I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Help_gnome_1help_1display_1desktop (JNIEnv *env, 
        jclass cls, jint program, jstring docId, jstring filename, jstring linkId, jintArray error) 
    {
        gchar* docId_g = (gchar*)(*env)->GetStringUTFChars(env, docId, 0);
        gchar* filename_g = (gchar*)(*env)->GetStringUTFChars(env, filename, 0);
        gchar* linkId_g = (gchar*)(*env)->GetStringUTFChars(env, linkId, 0);
        GError *error_g = (GError *) (*env)->GetIntArrayElements (env, error, NULL);
        jboolean result_j = (jboolean) gnome_help_display_desktop ((GnomeProgram*)program, docId_g, 
                    filename_g, linkId_g, &error_g);
        (*env)->ReleaseIntArrayElements (env, error, (jint *) error_g, 0);
        if (docId) (*env)->ReleaseStringUTFChars(env, docId, docId_g);
        if (filename) (*env)->ReleaseStringUTFChars(env, filename, filename_g);
        if (linkId) (*env)->ReleaseStringUTFChars(env, linkId, linkId_g);
        return result_j;
    }

    /*
     * Class:     org.gnu.gnome.Help
     * Method:    gnome_help_display_uri
     * Signature: (java.lang.String;[I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gnome_Help_gnome_1help_1display_1uri (JNIEnv *env, 
        jclass cls, jstring helpUri, jintArray error) 
    {
        gchar* helpUri_g = (gchar*)(*env)->GetStringUTFChars(env, helpUri, 0);
        GError *error_g = (GError *) (*env)->GetIntArrayElements (env, error, NULL);
        jboolean result_j = (jboolean) gnome_help_display_uri (helpUri_g, &error_g);
        (*env)->ReleaseIntArrayElements (env, error, (jint *) error_g, 0);
        if (helpUri) (*env)->ReleaseStringUTFChars(env, helpUri, helpUri_g);
        return result_j;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
