/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.gdk.Atom;


/**
 * Data used in Drag and drop operations
 */
public class SelectionData extends org.gnu.glib.GObject
{
	public SelectionData( int handle ){
		this.setHandle(handle);
	}

   public Atom getSelection(){
		return new Atom( getSelection(getHandle()) );
	}

	public Atom getTarget(){
		return new Atom( getTarget(getHandle()) );
	}
	
	public Atom getType(){
		return new Atom( getType(getHandle()) );
	}

	public int getFormat(){
		return getFormat(getHandle());
	}

	public int getLength(){
		return getLength( getHandle() );
	}
	
	public String getText(){
		return gtk_selection_data_get_text( getHandle() );
	}
	public boolean setText( String text ){
		return gtk_selection_data_set_text( getHandle(), text );
	}
	
	public boolean targetsIncludText() {
		return gtk_selection_data_targets_include_text(getHandle());
	}

	public Atom[] getTargets() {
		int hndls[] = gtk_selection_data_get_targets(getHandle());
		if (null == hndls)
			return null;
		Atom[] value = new Atom[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			value[i] = new Atom(hndls[i]);
		}
		return value;
	}

	native static protected final int getSelection( int selectionData );
	native static protected final int getTarget( int selectionData );
	native static protected final int getType( int selectionData );
	native static protected final int getFormat( int selectionData );
	native static protected final String getData( int selectionData );
	native static protected final int getLength( int selectionData );
	native static protected final int getDisplay( int selectionData );
	native static protected final String  gtk_selection_data_get_text( int selectionData );
	native static protected final boolean gtk_selection_data_set_text( int selectionData, String str );
	native static protected final int[] gtk_selection_data_get_targets(int selectionData);
	native static protected final boolean gtk_selection_data_targets_include_text(int selectionData);
}

